(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[   1087960,      19245]
NotebookOptionsPosition[   1079145,      18970]
NotebookOutlinePosition[   1080473,      19013]
CellTagsIndexPosition[   1080430,      19010]
WindowFrame->Normal
ContainsDynamic->True *)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
Visualisierung innerhalb Mathematica 6.0
und ausserhalb mittels LiveGraphics3D\
\>", "Subtitle",
 CellChangeTimes->{{3.405586966728176*^9, 3.405586994003237*^9}, {
  3.405595495357494*^9, 3.405595503341631*^9}},
 TextAlignment->Center],

Cell[TextData[StyleBox["Andreas Kriegl (c) 2007.12.03",
 FontFamily->"Luxi Sans",
 FontSize->22]], "Text",
 CellChangeTimes->{{3.405595201256347*^9, 3.405595247718667*^9}, {
  3.405595512059539*^9, 3.405595515354012*^9}},
 TextAlignment->Center,
 FontSize->36],

Cell[CellGroupData[{

Cell["Initialisierung", "Subsubsection"],

Cell["Wir ergaenzen den Suchpfad durch den Pfad des Notebooks.", "Text",
 CellChangeTimes->{{3.405573169828132*^9, 3.40557317063255*^9}, {
  3.405573239183684*^9, 3.405573312431758*^9}, {3.40557351113046*^9, 
  3.405573546728494*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"PrependTo", "[", 
   RowBox[{"$Path", ",", 
    RowBox[{"NotebookDirectory", "[", "]"}]}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Manipulate", ",", 
    RowBox[{"ControlPlacement", "\[Rule]", "Right"}], ",", 
    RowBox[{"SaveDefinitions", "\[Rule]", "True"}]}], "]"}], ";"}]}], "Input",\

 InitializationCell->True,
 CellChangeTimes->{{3.405572947586341*^9, 3.405572948268868*^9}, {
  3.405573048766634*^9, 3.405573066494863*^9}, {3.405576404332919*^9, 
  3.405576423287464*^9}, {3.405595640497247*^9, 3.405595641362221*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Bemerkung: Die externen Links habe ich wie folgt produziert", \
"Subsubsection",
 CellChangeTimes->{{3.405596892918156*^9, 3.405596902896117*^9}, {
  3.405597467448056*^9, 3.40559746906872*^9}, {3.405606481855681*^9, 
  3.405606485273863*^9}, {3.40560806601772*^9, 3.405608067970651*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"Hyperlink", "[", 
  RowBox[{
   RowBox[{"Framed", "[", "\"\<Beispiel-1.html\>\"", "]"}], ",", 
   "\"\<./Beispiel-1.html\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Hyperlink", "[", 
  RowBox[{
   RowBox[{"Framed", "[", "\"\<Beispiel-2.html\>\"", "]"}], ",", 
   "\"\<./Beispiel-2.html\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Hyperlink", "[", 
  RowBox[{
   RowBox[{"Framed", "[", "\"\<Torus.html\>\"", "]"}], ",", 
   "\"\<./Torus.html\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Hyperlink", "[", 
  RowBox[{
   RowBox[{"Framed", "[", "\"\<LiveForm.m\>\"", "]"}], ",", 
   "\"\<./LiveForm.m\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Hyperlink", "[", 
  RowBox[{
   RowBox[{"Framed", "[", "\"\<PP3D.m\>\"", "]"}], ",", "\"\<./PP3D.m\>\""}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Hyperlink", "[", 
  RowBox[{
   RowBox[{"Framed", "[", "\"\<demo-1.m\>\"", "]"}], ",", 
   "\"\<./demo-1.m\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Hyperlink", "[", 
  RowBox[{
   RowBox[{"Framed", "[", "\"\<demo-2a.m\>\"", "]"}], ",", 
   "\"\<./demo-2a.m\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Hyperlink", "[", 
  RowBox[{
   RowBox[{"Framed", "[", "\"\<demo-2b.m\>\"", "]"}], ",", 
   "\"\<./demo-2b.m\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Hyperlink", "[", 
  RowBox[{
   RowBox[{"Framed", "[", "\"\<demo-2c.m\>\"", "]"}], ",", 
   "\"\<./demo-2c.m\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Hyperlink", "[", 
  RowBox[{
   RowBox[{"Framed", "[", "\"\<demo-2d.m\>\"", "]"}], ",", 
   "\"\<./demo-2d.m\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Hyperlink", "[", 
  RowBox[{
   RowBox[{"Framed", "[", "\"\<torus.m\>\"", "]"}], ",", 
   "\"\<./torus.m\>\""}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Hyperlink", "[", 
  RowBox[{
   RowBox[{"Framed", "[", "\"\<Beispiel-1.html\>\"", "]"}], ",", 
   RowBox[{"\"\<file://\>\"", "<>", 
    RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
    "\"\<Beispiel-1.html\>\""}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Hyperlink", "[", 
  RowBox[{
   RowBox[{"Framed", "[", "\"\<Beispiel-2.html\>\"", "]"}], ",", 
   RowBox[{"\"\<file://\>\"", "<>", 
    RowBox[{"NotebookDirectory", "[", "]"}], "<>", 
    "\"\<Beispiel-2.html\>\""}]}], "]"}], "\[IndentingNewLine]", 
 RowBox[{"Hyperlink", "[", 
  RowBox[{
   RowBox[{"Framed", "[", "\"\<Torus.html\>\"", "]"}], ",", 
   RowBox[{"\"\<file://\>\"", "<>", 
    RowBox[{"NotebookDirectory", "[", "]"}], "<>", "\"\<Torus.html\>\""}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"Hyperlink", "[", 
  RowBox[{
   RowBox[{"Framed", "[", "\"\<Homepage LiveGraphics3D\>\"", "]"}], ",", 
   "\"\<http://www.vis.uni-stuttgart.de/%7Ekraus/LiveGraphics3D/\>\""}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.405584898675349*^9, 3.405584899846218*^9}, {
  3.405606115155422*^9, 3.405606406976238*^9}, {3.405606940703353*^9, 
  3.405606940946903*^9}}],

Cell[BoxData[
 TagBox[
  ButtonBox[
   PaneSelectorBox[{False->
    FrameBox["\<\"Beispiel-1.html\"\>",
     StripOnInput->False], True->
    StyleBox[
     FrameBox["\<\"Beispiel-1.html\"\>",
      StripOnInput->False], "HyperlinkActive"]}, Dynamic[
     CurrentValue["MouseOver"]],
    BaselinePosition->Baseline,
    FrameMargins->0,
    ImageSize->Automatic],
   BaseStyle->"Hyperlink",
   ButtonData->{"./Beispiel-1.html", None},
   ButtonNote->"./Beispiel-1.html"],
  Annotation[#, "./Beispiel-1.html", "Hyperlink"]& ]], "Output",
 CellChangeTimes->{3.40560641992851*^9, 3.40560648916559*^9, 
  3.405606941214228*^9}],

Cell[BoxData[
 TagBox[
  ButtonBox[
   PaneSelectorBox[{False->
    FrameBox["\<\"Beispiel-2.html\"\>",
     StripOnInput->False], True->
    StyleBox[
     FrameBox["\<\"Beispiel-2.html\"\>",
      StripOnInput->False], "HyperlinkActive"]}, Dynamic[
     CurrentValue["MouseOver"]],
    BaselinePosition->Baseline,
    FrameMargins->0,
    ImageSize->Automatic],
   BaseStyle->"Hyperlink",
   ButtonData->{"./Beispiel-2.html", None},
   ButtonNote->"./Beispiel-2.html"],
  Annotation[#, "./Beispiel-2.html", "Hyperlink"]& ]], "Output",
 CellChangeTimes->{3.40560641992851*^9, 3.40560648916559*^9, 
  3.405606941292718*^9}],

Cell[BoxData[
 TagBox[
  ButtonBox[
   PaneSelectorBox[{False->
    FrameBox["\<\"Torus.html\"\>",
     StripOnInput->False], True->
    StyleBox[
     FrameBox["\<\"Torus.html\"\>",
      StripOnInput->False], "HyperlinkActive"]}, Dynamic[
     CurrentValue["MouseOver"]],
    BaselinePosition->Baseline,
    FrameMargins->0,
    ImageSize->Automatic],
   BaseStyle->"Hyperlink",
   ButtonData->{"./Torus.html", None},
   ButtonNote->"./Torus.html"],
  Annotation[#, "./Torus.html", "Hyperlink"]& ]], "Output",
 CellChangeTimes->{3.40560641992851*^9, 3.40560648916559*^9, 
  3.405606941380017*^9}],

Cell[BoxData[
 TagBox[
  ButtonBox[
   PaneSelectorBox[{False->
    FrameBox["\<\"LiveForm.m\"\>",
     StripOnInput->False], True->
    StyleBox[
     FrameBox["\<\"LiveForm.m\"\>",
      StripOnInput->False], "HyperlinkActive"]}, Dynamic[
     CurrentValue["MouseOver"]],
    BaselinePosition->Baseline,
    FrameMargins->0,
    ImageSize->Automatic],
   BaseStyle->"Hyperlink",
   ButtonData->{"./LiveForm.m", None},
   ButtonNote->"./LiveForm.m"],
  Annotation[#, "./LiveForm.m", "Hyperlink"]& ]], "Output",
 CellChangeTimes->{3.40560641992851*^9, 3.40560648916559*^9, 
  3.405606941471744*^9}],

Cell[BoxData[
 TagBox[
  ButtonBox[
   PaneSelectorBox[{False->
    FrameBox["\<\"PP3D.m\"\>",
     StripOnInput->False], True->
    StyleBox[
     FrameBox["\<\"PP3D.m\"\>",
      StripOnInput->False], "HyperlinkActive"]}, Dynamic[
     CurrentValue["MouseOver"]],
    BaselinePosition->Baseline,
    FrameMargins->0,
    ImageSize->Automatic],
   BaseStyle->"Hyperlink",
   ButtonData->{"./PP3D.m", None},
   ButtonNote->"./PP3D.m"],
  Annotation[#, "./PP3D.m", "Hyperlink"]& ]], "Output",
 CellChangeTimes->{3.40560641992851*^9, 3.40560648916559*^9, 
  3.40560694156533*^9}],

Cell[BoxData[
 TagBox[
  ButtonBox[
   PaneSelectorBox[{False->
    FrameBox["\<\"demo-1.m\"\>",
     StripOnInput->False], True->
    StyleBox[
     FrameBox["\<\"demo-1.m\"\>",
      StripOnInput->False], "HyperlinkActive"]}, Dynamic[
     CurrentValue["MouseOver"]],
    BaselinePosition->Baseline,
    FrameMargins->0,
    ImageSize->Automatic],
   BaseStyle->"Hyperlink",
   ButtonData->{"./demo-1.m", None},
   ButtonNote->"./demo-1.m"],
  Annotation[#, "./demo-1.m", "Hyperlink"]& ]], "Output",
 CellChangeTimes->{3.40560641992851*^9, 3.40560648916559*^9, 
  3.405606941657633*^9}],

Cell[BoxData[
 TagBox[
  ButtonBox[
   PaneSelectorBox[{False->
    FrameBox["\<\"demo-2a.m\"\>",
     StripOnInput->False], True->
    StyleBox[
     FrameBox["\<\"demo-2a.m\"\>",
      StripOnInput->False], "HyperlinkActive"]}, Dynamic[
     CurrentValue["MouseOver"]],
    BaselinePosition->Baseline,
    FrameMargins->0,
    ImageSize->Automatic],
   BaseStyle->"Hyperlink",
   ButtonData->{"./demo-2a.m", None},
   ButtonNote->"./demo-2a.m"],
  Annotation[#, "./demo-2a.m", "Hyperlink"]& ]], "Output",
 CellChangeTimes->{3.40560641992851*^9, 3.40560648916559*^9, 
  3.405606941751347*^9}],

Cell[BoxData[
 TagBox[
  ButtonBox[
   PaneSelectorBox[{False->
    FrameBox["\<\"demo-2b.m\"\>",
     StripOnInput->False], True->
    StyleBox[
     FrameBox["\<\"demo-2b.m\"\>",
      StripOnInput->False], "HyperlinkActive"]}, Dynamic[
     CurrentValue["MouseOver"]],
    BaselinePosition->Baseline,
    FrameMargins->0,
    ImageSize->Automatic],
   BaseStyle->"Hyperlink",
   ButtonData->{"./demo-2b.m", None},
   ButtonNote->"./demo-2b.m"],
  Annotation[#, "./demo-2b.m", "Hyperlink"]& ]], "Output",
 CellChangeTimes->{3.40560641992851*^9, 3.40560648916559*^9, 
  3.405606941922817*^9}],

Cell[BoxData[
 TagBox[
  ButtonBox[
   PaneSelectorBox[{False->
    FrameBox["\<\"demo-2c.m\"\>",
     StripOnInput->False], True->
    StyleBox[
     FrameBox["\<\"demo-2c.m\"\>",
      StripOnInput->False], "HyperlinkActive"]}, Dynamic[
     CurrentValue["MouseOver"]],
    BaselinePosition->Baseline,
    FrameMargins->0,
    ImageSize->Automatic],
   BaseStyle->"Hyperlink",
   ButtonData->{"./demo-2c.m", None},
   ButtonNote->"./demo-2c.m"],
  Annotation[#, "./demo-2c.m", "Hyperlink"]& ]], "Output",
 CellChangeTimes->{3.40560641992851*^9, 3.40560648916559*^9, 
  3.405606942021209*^9}],

Cell[BoxData[
 TagBox[
  ButtonBox[
   PaneSelectorBox[{False->
    FrameBox["\<\"demo-2d.m\"\>",
     StripOnInput->False], True->
    StyleBox[
     FrameBox["\<\"demo-2d.m\"\>",
      StripOnInput->False], "HyperlinkActive"]}, Dynamic[
     CurrentValue["MouseOver"]],
    BaselinePosition->Baseline,
    FrameMargins->0,
    ImageSize->Automatic],
   BaseStyle->"Hyperlink",
   ButtonData->{"./demo-2d.m", None},
   ButtonNote->"./demo-2d.m"],
  Annotation[#, "./demo-2d.m", "Hyperlink"]& ]], "Output",
 CellChangeTimes->{3.40560641992851*^9, 3.40560648916559*^9, 
  3.405606942190588*^9}],

Cell[BoxData[
 TagBox[
  ButtonBox[
   PaneSelectorBox[{False->
    FrameBox["\<\"torus.m\"\>",
     StripOnInput->False], True->
    StyleBox[
     FrameBox["\<\"torus.m\"\>",
      StripOnInput->False], "HyperlinkActive"]}, Dynamic[
     CurrentValue["MouseOver"]],
    BaselinePosition->Baseline,
    FrameMargins->0,
    ImageSize->Automatic],
   BaseStyle->"Hyperlink",
   ButtonData->{"./torus.m", None},
   ButtonNote->"./torus.m"],
  Annotation[#, "./torus.m", "Hyperlink"]& ]], "Output",
 CellChangeTimes->{3.40560641992851*^9, 3.40560648916559*^9, 
  3.405606942290028*^9}],

Cell[BoxData[
 TagBox[
  ButtonBox[
   PaneSelectorBox[{False->
    FrameBox["\<\"Beispiel-1.html\"\>",
     StripOnInput->False], True->
    StyleBox[
     FrameBox["\<\"Beispiel-1.html\"\>",
      StripOnInput->False], "HyperlinkActive"]}, Dynamic[
     CurrentValue["MouseOver"]],
    BaselinePosition->Baseline,
    FrameMargins->0,
    ImageSize->Automatic],
   BaseStyle->"Hyperlink",
   ButtonData->{
     URL["file:///home/andreas/uni/vortrag/Beispiel-1.html"], None},
   ButtonNote->"file:///home/andreas/uni/vortrag/Beispiel-1.html"],
  Annotation[#, "file:///home/andreas/uni/vortrag/Beispiel-1.html", 
   "Hyperlink"]& ]], "Output",
 CellChangeTimes->{3.40560641992851*^9, 3.40560648916559*^9, 
  3.405606942467354*^9}],

Cell[BoxData[
 TagBox[
  ButtonBox[
   PaneSelectorBox[{False->
    FrameBox["\<\"Beispiel-2.html\"\>",
     StripOnInput->False], True->
    StyleBox[
     FrameBox["\<\"Beispiel-2.html\"\>",
      StripOnInput->False], "HyperlinkActive"]}, Dynamic[
     CurrentValue["MouseOver"]],
    BaselinePosition->Baseline,
    FrameMargins->0,
    ImageSize->Automatic],
   BaseStyle->"Hyperlink",
   ButtonData->{
     URL["file:///home/andreas/uni/vortrag/Beispiel-2.html"], None},
   ButtonNote->"file:///home/andreas/uni/vortrag/Beispiel-2.html"],
  Annotation[#, "file:///home/andreas/uni/vortrag/Beispiel-2.html", 
   "Hyperlink"]& ]], "Output",
 CellChangeTimes->{3.40560641992851*^9, 3.40560648916559*^9, 
  3.405606942570584*^9}],

Cell[BoxData[
 TagBox[
  ButtonBox[
   PaneSelectorBox[{False->
    FrameBox["\<\"Torus.html\"\>",
     StripOnInput->False], True->
    StyleBox[
     FrameBox["\<\"Torus.html\"\>",
      StripOnInput->False], "HyperlinkActive"]}, Dynamic[
     CurrentValue["MouseOver"]],
    BaselinePosition->Baseline,
    FrameMargins->0,
    ImageSize->Automatic],
   BaseStyle->"Hyperlink",
   ButtonData->{
     URL["file:///home/andreas/uni/vortrag/Torus.html"], None},
   ButtonNote->"file:///home/andreas/uni/vortrag/Torus.html"],
  Annotation[#, "file:///home/andreas/uni/vortrag/Torus.html", 
   "Hyperlink"]& ]], "Output",
 CellChangeTimes->{3.40560641992851*^9, 3.40560648916559*^9, 
  3.405606942676239*^9}],

Cell[BoxData[
 TagBox[
  ButtonBox[
   PaneSelectorBox[{False->
    FrameBox["\<\"Homepage LiveGraphics3D\"\>",
     StripOnInput->False], True->
    StyleBox[
     FrameBox["\<\"Homepage LiveGraphics3D\"\>",
      StripOnInput->False], "HyperlinkActive"]}, Dynamic[
     CurrentValue["MouseOver"]],
    BaselinePosition->Baseline,
    FrameMargins->0,
    ImageSize->Automatic],
   BaseStyle->"Hyperlink",
   ButtonData->{
     URL["http://www.vis.uni-stuttgart.de/%7Ekraus/LiveGraphics3D/"], None},
   ButtonNote->"http://www.vis.uni-stuttgart.de/%7Ekraus/LiveGraphics3D/"],
  Annotation[#, "http://www.vis.uni-stuttgart.de/%7Ekraus/LiveGraphics3D/", 
   "Hyperlink"]& ]], "Output",
 CellChangeTimes->{3.40560641992851*^9, 3.40560648916559*^9, 
  3.405606942781278*^9}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Ein einfaches Beispiel via Graphics3D ",
 Cell[BoxData[
  TagBox[
   ButtonBox[
    PaneSelectorBox[{False->
     FrameBox["\<\"Beispiel-1.html\"\>",
      StripOnInput->False], True->
     StyleBox[
      FrameBox["\<\"Beispiel-1.html\"\>",
       StripOnInput->False], "HyperlinkActive"]}, Dynamic[
      CurrentValue["MouseOver"]],
     BaselinePosition->Baseline,
     FrameMargins->0,
     ImageSize->Automatic],
    BaseStyle->"Hyperlink",
    ButtonData->{
      URL["file:///home/andreas/uni/vortrag/Beispiel-1.html"], None},
    ButtonNote->"file:///home/andreas/uni/vortrag/Beispiel-1.html"],
   Annotation[#, "file:///home/andreas/uni/vortrag/Beispiel-1.html", 
    "Hyperlink"]& ]],
  CellChangeTimes->{3.405606421627113*^9}]
}], "Section",
 CellChangeTimes->{{3.405574517992487*^9, 3.405574531473485*^9}, {
  3.405606439699103*^9, 3.405606440723179*^9}}],

Cell[CellGroupData[{

Cell["Definition der Graphik ", "Subsection",
 CellChangeTimes->{{3.405585442479244*^9, 3.405585459214695*^9}, 
   3.405595150100361*^9, {3.405607073813207*^9, 3.405607074454708*^9}}],

Cell["Zuerst die Definition der Parameterabhaengigen 3D-Graphik ", "Text",
 CellChangeTimes->{{3.405575331303001*^9, 3.405575373742889*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Epsilon]", "=", "0.01"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Clear", "[", "G1", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"G1", "[", 
   RowBox[{"t_", ",", "s_"}], "]"}], ":=", 
  RowBox[{"Graphics3D", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{"die", " ", "Grundflaeche"}], " ", "*)"}], 
     "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Polygon", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"x", "-", " ", 
        RowBox[{"und", " ", "y"}], "-", "Koordinate"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "\[Epsilon]"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "s", ",", "\[Epsilon]"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "s", ",", "\[Epsilon]"}], "}"}]}], "}"}], "]"}], 
      ",", "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{"die", " ", "Flaechennormale"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Thickness", "[", "0.005", "]"}], ",", 
      RowBox[{"Line", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"t", ",", "s", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "s", ",", 
           RowBox[{"1", "-", "0.01"}]}], "}"}]}], "}"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PointSize", "[", "0.02", "]"}], ",", "Red", ",", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"t", ",", "s", ",", "1"}], "}"}], "]"}]}], 
     "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.2"}], ",", "1.2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.2"}], ",", "1.1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.2"}], ",", "1.2"}], "}"}]}], "}"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]}], "Input",
 CellChangeTimes->{{3.405574625936584*^9, 3.405574635112332*^9}, {
   3.405574690234938*^9, 3.405574699269565*^9}, {3.40557473810844*^9, 
   3.405574849055727*^9}, {3.405574925477862*^9, 3.405574940600301*^9}, {
   3.40557499202526*^9, 3.405575024326047*^9}, {3.405575144227538*^9, 
   3.405575184204375*^9}, 3.405576074585045*^9, {3.405580370975805*^9, 
   3.405580380970126*^9}, {3.4055804671233*^9, 3.405580516306949*^9}, {
   3.405580555723914*^9, 3.405580577238427*^9}, {3.405580896432491*^9, 
   3.405581210486107*^9}, {3.405581416787057*^9, 3.405581423779728*^9}, {
   3.405581499342168*^9, 3.405581503272508*^9}, {3.405581884582763*^9, 
   3.40558188994402*^9}, {3.405582005655874*^9, 3.405582028029597*^9}, {
   3.405582072567343*^9, 3.405582182006754*^9}, {3.405582242311594*^9, 
   3.405582257458527*^9}, {3.405582363378742*^9, 3.405582389884858*^9}, {
   3.405582559877223*^9, 3.40558256264663*^9}, {3.405582818073051*^9, 
   3.405582871011712*^9}, {3.405583170132307*^9, 3.405583175545795*^9}, {
   3.405585213821379*^9, 3.405585215292311*^9}, {3.405596483632037*^9, 
   3.405596556655198*^9}, {3.405606735084605*^9, 3.405606736230303*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Visualisierung der Graphik", "Subsection",
 CellChangeTimes->{{3.405595179684763*^9, 3.405595192667619*^9}}],

Cell[CellGroupData[{

Cell[TextData[{
 "Visualisierung innerhalb ",
 StyleBox["Mathematica",
  FontSlant->"Italic"],
 " 6.0"
}], "Subsubsection",
 CellChangeTimes->{{3.405585416643017*^9, 3.40558542406494*^9}, {
  3.405585517030138*^9, 3.405585518724335*^9}}],

Cell["\<\
Gezeichnet wird sie nur nach Angabe expliziter Parameterwerte\
\>", "Text",
 CellChangeTimes->{{3.405575383882325*^9, 3.405575416556165*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"G1", "[", 
   RowBox[{"0.5", ",", "0.5"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.405575032265985*^9, 3.405575035482818*^9}, {
   3.405581091661528*^9, 3.405581095366297*^9}, {3.405582177217157*^9, 
   3.405582178990083*^9}, 3.405606748113116*^9}],

Cell[BoxData[
 Graphics3DBox[{Polygon3DBox[{{0, 0, 0}, {1, 0, 0}, {1, 1, 0}, {0, 1, 0}}], 
   Line3DBox[{{0.5, 0, 0.01}, {0.5, 0.5, 0.01}, {0, 0.5, 0.01}}], 
   {Thickness[0.005], Line3DBox[{{0.5, 0.5, 0}, {0.5, 0.5, 0.99}}], 
    {RGBColor[1, 0, 0], PointSize[0.02], Point3DBox[{0.5, 0.5, 1}]}}},
  PlotRange->{{-0.2, 1.2}, {-0.2, 1.1}, {-0.2, 1.2}}]], "Output",
 CellChangeTimes->{
  3.405575036573721*^9, {3.405575167540406*^9, 3.40557519258887*^9}, {
   3.405580548016951*^9, 3.405580561110625*^9}, 3.405580593017166*^9, 
   3.40558097731572*^9, {3.405581014534174*^9, 3.405581032931885*^9}, 
   3.405581092563817*^9, {3.405581122954488*^9, 3.405581169085867*^9}, {
   3.405581219039254*^9, 3.405581224616111*^9}, 3.405581897293969*^9, 
   3.405582110196513*^9, {3.405582162029092*^9, 3.40558218501298*^9}, 
   3.405582574892412*^9, 3.405583596292437*^9, 3.405583628545089*^9, 
   3.405583684919725*^9, 3.405583784994498*^9, 3.40558383675509*^9, 
   3.40558387228586*^9, 3.405583909844929*^9, 3.405595927123657*^9, 
   3.405596411700708*^9, 3.405606748721974*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["Interaktiv kann sie manipuliert werden durch", "Text",
 CellChangeTimes->{{3.405575433700313*^9, 3.405575455617617*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"G1", "[", 
    RowBox[{"t", ",", "s"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"s", ",", "0", ",", "1"}], "}"}], ",", 
   RowBox[{"ControlType", "\[Rule]", "VerticalSlider"}], ",", 
   RowBox[{"ControlPlacement", "\[Rule]", "Left"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.405580642388824*^9, 3.405580671794992*^9}, {
   3.405580731999675*^9, 3.405580756120771*^9}, {3.405581046992321*^9, 
   3.405581047567068*^9}, {3.405590699345615*^9, 3.405590717300534*^9}, {
   3.405590780002515*^9, 3.405590785877042*^9}, 3.405606751582723*^9}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`s$$ = 0, $CellContext`t$$ = 0, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], 0, 1}, {
      Hold[$CellContext`s$$], 0, 1}}, Typeset`size$$ = {360., {193., 198.}}, 
    Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`t$96$$ = 0, $CellContext`s$97$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, 
      "Variables" :> {$CellContext`s$$ = 0, $CellContext`t$$ = 0}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$96$$, 0], 
        Hold[$CellContext`s$$, $CellContext`s$97$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, 
      "Body" :> $CellContext`G1[$CellContext`t$$, $CellContext`s$$], 
      "Specifications" :> {{$CellContext`t$$, 0, 1}, {$CellContext`s$$, 0, 
         1}}, "Options" :> {
       ControlType -> VerticalSlider, ControlPlacement -> Left}, 
      "DefaultOptions" :> {
       ControlPlacement -> Right, SaveDefinitions -> True}],
     ImageSizeCache->{447., {220., 227.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`G1[
         Pattern[$CellContext`t, 
          Blank[]], 
         Pattern[$CellContext`s, 
          Blank[]]] := Graphics3D[{
          Polygon[{{0, 0, 0}, {1, 0, 0}, {1, 1, 0}, {0, 1, 0}}], 
          
          Line[{{$CellContext`t, 
             0, $CellContext`\[Epsilon]}, {$CellContext`t, $CellContext`s, \
$CellContext`\[Epsilon]}, {0, $CellContext`s, $CellContext`\[Epsilon]}}], 
          Thickness[0.005], 
          Line[{{$CellContext`t, $CellContext`s, 
             0}, {$CellContext`t, $CellContext`s, 1 - 0.01}}], 
          PointSize[0.02], Red, 
          Point[{$CellContext`t, $CellContext`s, 1}]}, 
         PlotRange -> {{-0.2, 1.2}, {-0.2, 1.1}, {-0.2, 
          1.2}}], $CellContext`\[Epsilon] = 0.01}; Typeset`initDone$$ = True),
    
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.405575118576269*^9, 3.405575195078891*^9, {3.405575265839716*^9, 
   3.405575289945902*^9}, {3.405580658111073*^9, 3.405580672400345*^9}, 
   3.405580734148965*^9, 3.405581048069212*^9, 3.40558123352915*^9, 
   3.405582541791529*^9, 3.405582579546533*^9, 3.405590718318034*^9, 
   3.405590791477202*^9, 3.405595945396883*^9, 3.405606752541834*^9}]
}, Open  ]],

Cell["Oder besser :", "Text",
 CellChangeTimes->{{3.405575481250486*^9, 3.405575487023161*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"G1", "[", 
    RowBox[{
     RowBox[{"p", "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{"p", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"0.5", ",", "0.5"}], "}"}], ",", "\"\<Position\>\""}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", "1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.405576115624854*^9, 3.405576120920147*^9}, {
   3.405581264722702*^9, 3.405581267772932*^9}, {3.40558526945567*^9, 
   3.405585272565699*^9}, 3.40560675745945*^9}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`p$$ = {0.5, 0.5}, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`p$$], {0.5, 0.5}, "Position"}, {0, 0}, {1, 1}}}, 
    Typeset`size$$ = {360., {193., 198.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`p$127$$ = {0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`p$$ = {0.5, 0.5}}, 
      "ControllerVariables" :> {
        Hold[$CellContext`p$$, $CellContext`p$127$$, {0, 0}]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`G1[
        Part[$CellContext`p$$, 1], 
        Part[$CellContext`p$$, 2]], 
      "Specifications" :> {{{$CellContext`p$$, {0.5, 0.5}, "Position"}, {0, 
         0}, {1, 1}}}, "Options" :> {}, 
      "DefaultOptions" :> {
       ControlPlacement -> Right, SaveDefinitions -> True}],
     ImageSizeCache->{550., {220., 227.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`G1[
         Pattern[$CellContext`t, 
          Blank[]], 
         Pattern[$CellContext`s, 
          Blank[]]] := Graphics3D[{
          Polygon[{{0, 0, 0}, {1, 0, 0}, {1, 1, 0}, {0, 1, 0}}], 
          
          Line[{{$CellContext`t, 
             0, $CellContext`\[Epsilon]}, {$CellContext`t, $CellContext`s, \
$CellContext`\[Epsilon]}, {0, $CellContext`s, $CellContext`\[Epsilon]}}], 
          Thickness[0.005], 
          
          Line[{{$CellContext`t, $CellContext`s, 
             0}, {$CellContext`t, $CellContext`s, 1 - 0.01}}], 
          PointSize[0.02], Red, 
          Point[{$CellContext`t, $CellContext`s, 1}]}, 
         PlotRange -> {{-0.2, 1.2}, {-0.2, 1.1}, {-0.2, 
          1.2}}], $CellContext`\[Epsilon] = 0.01}; Typeset`initDone$$ = True),
    
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.405575118576269*^9, 3.405575195078891*^9, {3.405575265839716*^9, 
   3.405575292083209*^9}, 3.405576122722219*^9, {3.405581254086838*^9, 
   3.40558126856559*^9}, 3.405582584743682*^9, 3.405585276504927*^9, 
   3.405590865971724*^9, 3.405595966792867*^9, 3.405606758506017*^9}]
}, Open  ]],

Cell["Oder mittels Locator:", "Text",
 CellChangeTimes->{{3.405575601758044*^9, 3.405575715657698*^9}, {
  3.405584984787844*^9, 3.405584995149232*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"G1", "[", 
    RowBox[{
     RowBox[{"p", "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{"p", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"p", ",", 
       RowBox[{"{", 
        RowBox[{"0.5", ",", "0.5"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}]}], "}"}], ",", "Locator"}], "}"}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.405576038481464*^9, 3.405576041358295*^9}, {
   3.405576094857538*^9, 3.405576136710535*^9}, {3.405576179402355*^9, 
   3.405576245255414*^9}, {3.405581335615926*^9, 3.405581346626481*^9}, {
   3.40558530435161*^9, 3.405585307573682*^9}, 3.405606765843111*^9}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`p$$ = {0.5, 0.5}, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`p$$], {0.5, 0.5}, {1, 1}}, Automatic}}, 
    Typeset`size$$ = {360., {193., 198.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = False}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`p$$ = {0.5, 0.5}}, 
      "ControllerVariables" :> {}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`G1[
        Part[$CellContext`p$$, 1], 
        Part[$CellContext`p$$, 2]], 
      "Specifications" :> {{{$CellContext`p$$, {0.5, 0.5}, {1, 1}}, Automatic,
          ControlType -> Locator}}, "Options" :> {}, 
      "DefaultOptions" :> {
       ControlPlacement -> Right, SaveDefinitions -> True}],
     ImageSizeCache->{408., {220., 227.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`G1[
         Pattern[$CellContext`t, 
          Blank[]], 
         Pattern[$CellContext`s, 
          Blank[]]] := Graphics3D[{
          Polygon[{{0, 0, 0}, {1, 0, 0}, {1, 1, 0}, {0, 1, 0}}], 
          
          Line[{{$CellContext`t, 
             0, $CellContext`\[Epsilon]}, {$CellContext`t, $CellContext`s, \
$CellContext`\[Epsilon]}, {0, $CellContext`s, $CellContext`\[Epsilon]}}], 
          Thickness[0.005], 
          
          Line[{{$CellContext`t, $CellContext`s, 
             0}, {$CellContext`t, $CellContext`s, 1 - 0.01}}], 
          PointSize[0.02], Red, 
          Point[{$CellContext`t, $CellContext`s, 1}]}, 
         PlotRange -> {{-0.2, 1.2}, {-0.2, 1.1}, {-0.2, 
          1.2}}], $CellContext`\[Epsilon] = 0.01}; Typeset`initDone$$ = True),
    
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.405576205246873*^9, 3.405576246108159*^9, 3.405577964343187*^9, 
   3.405578021540878*^9, 3.40558019544619*^9, {3.40558132945383*^9, 
   3.405581347242428*^9}, 3.405581515305112*^9, 3.405582597690476*^9, 
   3.405585315783234*^9, 3.405606766517857*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Visualisierung mittels Live Graphics3D in Web-Browser", "Subsubsection",
 CellChangeTimes->{{3.405585011325674*^9, 3.405585018391212*^9}, {
  3.405585493049912*^9, 3.405585511696954*^9}}],

Cell[TextData[{
 "Nun laden wir das Macro ",
 Cell[BoxData[
  TagBox[
   ButtonBox[
    PaneSelectorBox[{False->
     FrameBox["\<\"LiveForm.m\"\>",
      StripOnInput->False], True->
     StyleBox[
      FrameBox["\<\"LiveForm.m\"\>",
       StripOnInput->False], "HyperlinkActive"]}, Dynamic[
      CurrentValue["MouseOver"]],
     BaselinePosition->Baseline,
     FrameMargins->0,
     ImageSize->Automatic],
    BaseStyle->"Hyperlink",
    ButtonData->{"./LiveForm.m", None},
    ButtonNote->"./LiveForm.m"],
   Annotation[#, "./LiveForm.m", "Hyperlink"]& ]]],
 " fuer's Schreiben des Inputs fuer das LiveGraphics3D Java-Applet."
}], "Text",
 CellChangeTimes->{{3.405573549784738*^9, 3.405573671435121*^9}, {
  3.405585193074325*^9, 3.405585198259274*^9}, {3.405596597004209*^9, 
  3.405596633214959*^9}, {3.405596865500434*^9, 3.405596866551125*^9}}],

Cell[BoxData[
 RowBox[{"<<", "\"\<LiveForm.m\>\""}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.405596725895496*^9, 3.405596740932614*^9}, {
  3.405606777085127*^9, 3.405606783187051*^9}}],

Cell[TextData[{
 "Wir schreiben die Definition der Graphic in eine Datei ",
 Cell[BoxData[
  TagBox[
   ButtonBox[
    PaneSelectorBox[{False->
     FrameBox["\<\"demo-1.m\"\>",
      StripOnInput->False], True->
     StyleBox[
      FrameBox["\<\"demo-1.m\"\>",
       StripOnInput->False], "HyperlinkActive"]}, Dynamic[
      CurrentValue["MouseOver"]],
     BaselinePosition->Baseline,
     FrameMargins->0,
     ImageSize->Automatic],
    BaseStyle->"Hyperlink",
    ButtonData->{"./demo-1.m", None},
    ButtonNote->"./demo-1.m"],
   Annotation[#, "./demo-1.m", "Hyperlink"]& ]],
  CellChangeTimes->{3.40560641992851*^9, 3.405606489930502*^9}]
}], "Text",
 CellChangeTimes->{{3.405585035670137*^9, 3.405585061386653*^9}, {
   3.405596844361538*^9, 3.405596844654907*^9}, 3.405606803080292*^9, 
   3.405606862121521*^9}],

Cell[BoxData[
 RowBox[{"WriteLiveForm", "[", 
  RowBox[{"\"\<demo-1.m\>\"", ",", 
   RowBox[{"G1", "[", 
    RowBox[{"t", ",", "s"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.405576290291337*^9, 3.405576291321593*^9}, {
  3.405576335022118*^9, 3.40557637571804*^9}, {3.40557817745256*^9, 
  3.405578186956807*^9}, {3.405578295748313*^9, 3.405578298744283*^9}, {
  3.405578619301525*^9, 3.405578622918257*^9}, {3.405581372703645*^9, 
  3.405581378270877*^9}, {3.405606865308961*^9, 3.40560687088208*^9}}],

Cell[TextData[{
 "Nun produzieren wir eine html-Datei ",
 Cell[BoxData[
  TagBox[
   ButtonBox[
    PaneSelectorBox[{False->
     FrameBox["\<\"Beispiel-1.html\"\>",
      StripOnInput->False], True->
     StyleBox[
      FrameBox["\<\"Beispiel-1.html\"\>",
       StripOnInput->False], "HyperlinkActive"]}, Dynamic[
      CurrentValue["MouseOver"]],
     BaselinePosition->Baseline,
     FrameMargins->0,
     ImageSize->Automatic],
    BaseStyle->"Hyperlink",
    ButtonData->{"./Beispiel-1.html", None},
    ButtonNote->"./Beispiel-1.html"],
   Annotation[#, "./Beispiel-1.html", "Hyperlink"]& ]],
  CellChangeTimes->{3.40560641992851*^9, 3.40560648916559*^9}],
 " mittels Text-Editor."
}], "Text",
 CellChangeTimes->{{3.405576443702738*^9, 3.405576533971527*^9}, {
   3.405596883786102*^9, 3.405596884587996*^9}, 3.405596957038221*^9, {
   3.405606896376444*^9, 3.405606924222211*^9}}],

Cell[TextData[{
 "Und koennen ",
 Cell[BoxData[
  TagBox[
   ButtonBox[
    PaneSelectorBox[{False->
     FrameBox["\<\"Beispiel-1.html\"\>",
      StripOnInput->False], True->
     StyleBox[
      FrameBox["\<\"Beispiel-1.html\"\>",
       StripOnInput->False], "HyperlinkActive"]}, Dynamic[
      CurrentValue["MouseOver"]],
     BaselinePosition->Baseline,
     FrameMargins->0,
     ImageSize->Automatic],
    BaseStyle->"Hyperlink",
    ButtonData->{
      URL["file:///home/andreas/uni/vortrag/Beispiel-1.html"], None},
    ButtonNote->"file:///home/andreas/uni/vortrag/Beispiel-1.html"],
   Annotation[#, "file:///home/andreas/uni/vortrag/Beispiel-1.html", 
    "Hyperlink"]& ]],
  CellChangeTimes->{3.40560641992851*^9, 3.40560648916559*^9, 
   3.405606942467354*^9}],
 " mittels Web-Browser betrachten."
}], "Text",
 CellChangeTimes->{{3.405585102388361*^9, 3.405585144036021*^9}, {
   3.405596931737442*^9, 3.405596953268753*^9}, 3.405606899732819*^9, 
   3.405606974488676*^9}]
}, Closed]],

Cell[CellGroupData[{

Cell["Eine in Hinblick auf Sichtbarkeiten verbesserte Version.", \
"Subsubsection",
 CellChangeTimes->{{3.40558418412546*^9, 3.405584217545351*^9}, 
   3.405596962342673*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"n", "=", "10"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"Remove", "[", "G1", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"G1", "[", 
   RowBox[{"t_", ",", "s_"}], "]"}], ":=", 
  RowBox[{"Graphics3D", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"{", "\[IndentingNewLine]", 
     RowBox[{"(*", " ", 
      RowBox[{
      "der", " ", "rechteckige", " ", "Teil", " ", "der", " ", "Grundflaeche",
        " ", "bis", " ", "zum", " ", "mobilen", " ", "Basispunkt"}], " ", 
      "*)"}], "\[IndentingNewLine]", 
     RowBox[{
      RowBox[{"Polygon", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "s", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "s", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "0"}], "}"}]}], "}"}], "]"}], ",", " ", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "der", " ", "Rest", " ", "der", " ", "Grundflaeche", " ", "ohne", " ", 
        "Kanten"}], " ", "*)"}], "\[IndentingNewLine]", 
      RowBox[{"EdgeForm", "[", "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Polygon", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"t", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "0", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "s", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"Polygon", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "s", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "1", ",", "0"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"t", ",", "s", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"(*", " ", 
       RowBox[{
       "die", " ", "Flaechennormel", "  ", "aus", " ", "kleinen", " ", 
        "Stuecken", " ", "zusammengesetzt"}], " ", "*)"}], 
      "\[IndentingNewLine]", 
      RowBox[{"Thickness", "[", "0.005", "]"}], ",", "\[IndentingNewLine]", 
      RowBox[{"Line", "[", 
       RowBox[{"Table", "[", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"t", ",", "s", ",", 
           RowBox[{"i", "/", "n"}]}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"i", ",", "0", ",", "n"}], "}"}]}], "]"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{"PointSize", "[", "0.02", "]"}], ",", "\[IndentingNewLine]", 
      "Red", ",", "\[IndentingNewLine]", 
      RowBox[{"Point", "[", 
       RowBox[{"{", 
        RowBox[{"t", ",", "s", ",", "1"}], "}"}], "]"}]}], 
     "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.2"}], ",", "1.2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.2"}], ",", "1.1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"-", "0.2"}], ",", "1.2"}], "}"}]}], "}"}]}]}], 
   "\[IndentingNewLine]", "]"}]}]}], "Input",
 CellChangeTimes->{{3.40558319882179*^9, 3.405583370137564*^9}, {
  3.405583413721519*^9, 3.405583435738118*^9}, {3.405583468376483*^9, 
  3.405583473382433*^9}, {3.405583506534235*^9, 3.405583570121292*^9}, {
  3.405583609484604*^9, 3.405583653603346*^9}, {3.40558374934862*^9, 
  3.405583757486977*^9}, {3.405583792799877*^9, 3.405583920894968*^9}, {
  3.405583971431467*^9, 3.405583971781333*^9}, {3.405584061852545*^9, 
  3.405584074819647*^9}, {3.405584141141638*^9, 3.405584144390248*^9}, {
  3.405596151848579*^9, 3.405596154327757*^9}, {3.405596981343166*^9, 
  3.405597071808547*^9}, {3.405607018341655*^9, 3.405607021809157*^9}}],

Cell[BoxData[
 RowBox[{"WriteLiveForm", "[", 
  RowBox[{"\"\<demo-1.m\>\"", ",", 
   RowBox[{"G1", "[", 
    RowBox[{"t", ",", "s"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.405576290291337*^9, 3.405576291321593*^9}, {
  3.405576335022118*^9, 3.40557637571804*^9}, {3.40557817745256*^9, 
  3.405578186956807*^9}, {3.405578295748313*^9, 3.405578298744283*^9}, {
  3.405578619301525*^9, 3.405578622918257*^9}, {3.405581372703645*^9, 
  3.405581378270877*^9}, {3.405607028863513*^9, 3.405607036426474*^9}}]
}, Closed]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Ein einfaches Beispiel via Plot3D ",
 Cell[BoxData[
  TagBox[
   ButtonBox[
    PaneSelectorBox[{False->
     FrameBox["\<\"Beispiel-2.html\"\>",
      StripOnInput->False], True->
     StyleBox[
      FrameBox["\<\"Beispiel-2.html\"\>",
       StripOnInput->False], "HyperlinkActive"]}, Dynamic[
      CurrentValue["MouseOver"]],
     BaselinePosition->Baseline,
     FrameMargins->0,
     ImageSize->Automatic],
    BaseStyle->"Hyperlink",
    ButtonData->{
      URL["file:///home/andreas/uni/vortrag/Beispiel-2.html"], None},
    ButtonNote->"file:///home/andreas/uni/vortrag/Beispiel-2.html"],
   Annotation[#, "file:///home/andreas/uni/vortrag/Beispiel-2.html", 
    "Hyperlink"]& ]],
  CellChangeTimes->{3.405606421726464*^9}]
}], "Section",
 CellChangeTimes->{{3.405574285816257*^9, 3.405574325693901*^9}, {
  3.405574495102014*^9, 3.405574496534591*^9}, {3.405606451148161*^9, 
  3.405606451752017*^9}}],

Cell["\<\
Wir beschreiben eine Flaeche als Graph einer Funktion f
sowie ihre Tangentialebenen t\
\>", "Text",
 CellChangeTimes->{{3.405585594882949*^9, 3.405585630098154*^9}, {
  3.405595087278668*^9, 3.4055950930492*^9}, {3.405607130210415*^9, 
  3.405607131957351*^9}}],

Cell[CellGroupData[{

Cell["Die parametrisierte Graphik", "Subsection",
 CellChangeTimes->{{3.405595016986537*^9, 3.405595022059357*^9}}],

Cell[CellGroupData[{

Cell["Zuerst die Funktionen", "Subsubsection",
 CellChangeTimes->{{3.405594664902254*^9, 3.405594670469247*^9}}],

Cell[BoxData[{
 RowBox[{"Remove", "[", 
  RowBox[{"f", ",", "t"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"f", "[", 
   RowBox[{"x_", ",", "y_"}], "]"}], ":=", 
  RowBox[{"1", "-", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{
      RowBox[{"x", "^", "2"}], "+", 
      RowBox[{"y", "^", "2"}]}], ")"}], "/", 
    "4"}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"t", "[", 
   RowBox[{"x_", ",", "y_", ",", "u_", ",", "v_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"f", "[", 
    RowBox[{"u", ",", "v"}], "]"}], "+", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"x", "-", "u"}], ")"}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"Derivative", "[", 
       RowBox[{"1", ",", "0"}], "]"}], "[", "f", "]"}], "[", 
     RowBox[{"u", ",", "v"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"(", 
     RowBox[{"y", "-", "v"}], ")"}], "*", 
    RowBox[{
     RowBox[{
      RowBox[{"Derivative", "[", 
       RowBox[{"0", ",", "1"}], "]"}], "[", "f", "]"}], "[", 
     RowBox[{"u", ",", "v"}], "]"}]}]}]}]}], "Input",
 CellChangeTimes->{{3.405495945454658*^9, 3.405496124655125*^9}, {
   3.40549624265787*^9, 3.405496243131956*^9}, {3.405496497765634*^9, 
   3.405496534586952*^9}, {3.405496573596703*^9, 3.405496682179972*^9}, {
   3.405496737128798*^9, 3.405496745881064*^9}, {3.405496883670807*^9, 
   3.405496959227244*^9}, {3.405497026769255*^9, 3.405497030444307*^9}, {
   3.405497096050697*^9, 3.405497176971317*^9}, 3.405497207625481*^9, {
   3.405497242262927*^9, 3.405497254243469*^9}, {3.405498392947344*^9, 
   3.405498454157984*^9}, {3.405585665477332*^9, 3.405585668706108*^9}, {
   3.405587025573486*^9, 3.405587040425555*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Einige Optionen und Konstante", "Subsubsection",
 CellChangeTimes->{{3.40559470190124*^9, 3.40559471867454*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"\[Epsilon]", "=", "0.03"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"z0", "=", 
   RowBox[{"-", "1"}]}], ";", " ", 
  RowBox[{"z1", "=", "2.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"x0", "=", 
   RowBox[{"-", "1"}]}], ";", " ", 
  RowBox[{"x1", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"y0", "=", 
   RowBox[{"-", "1"}]}], ";", " ", 
  RowBox[{"y1", "=", "1"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Plot3D", ",", "\[IndentingNewLine]", 
    RowBox[{"PlotStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"Directive", "[", 
       RowBox[{"Opacity", "[", "0.8", "]"}], "]"}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"BoxRatios", "\[Rule]", "Automatic"}], ",", "\[IndentingNewLine]",
     
    RowBox[{"Boxed", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Axes", "\[Rule]", "False"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetOptions", "[", 
   RowBox[{"Graphics3D", ",", "\[IndentingNewLine]", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"x0", ",", "x1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"y0", ",", "y1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"z0", ",", "z1"}], "}"}]}], "}"}]}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"BoxRatios", "\[Rule]", "Automatic"}], ",", "\[IndentingNewLine]",
     
    RowBox[{"Boxed", "\[Rule]", "False"}], ",", "\[IndentingNewLine]", 
    RowBox[{"Axes", "\[Rule]", "False"}]}], "\[IndentingNewLine]", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"SetOptions", "[", 
     RowBox[{"Manipulate", ",", 
      RowBox[{"TrackedSymbols", "\[Rule]", 
       RowBox[{"{", "u", "}"}]}]}], "]"}], ";"}], " ", "*)"}]}]}], "Input",
 CellChangeTimes->{{3.405587475997765*^9, 3.405587498908566*^9}, {
   3.4055875544879*^9, 3.405587557994264*^9}, {3.405587588629018*^9, 
   3.405587606807692*^9}, 3.405587685564776*^9, {3.405587741648279*^9, 
   3.405587765447608*^9}, {3.405587903457684*^9, 3.405587919519275*^9}, {
   3.405587968541738*^9, 3.405587969679411*^9}, {3.405588193823433*^9, 
   3.405588238610846*^9}, {3.405589587126371*^9, 3.405589626181496*^9}, {
   3.405590408364811*^9, 3.405590425853717*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Bemerkung zu Plot3D via LiveGraphics3D", "Subsubsection",
 CellChangeTimes->{{3.405594737089151*^9, 3.40559475080415*^9}, {
  3.405597251788181*^9, 3.405597254067652*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"P2a", "=", 
  RowBox[{"Plot3D", "[", 
   RowBox[{
    RowBox[{"f", "[", 
     RowBox[{"x", ",", "y"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "x0", ",", "x1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "y0", ",", "y1"}], "}"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.405504374296703*^9, 3.405504392334132*^9}, {
  3.405588616512289*^9, 3.405588623690119*^9}, {3.405607208258235*^9, 
  3.40560726386409*^9}, {3.405607315259485*^9, 3.405607315364089*^9}}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJx1nH2Y1VW1x+eqaJJFiZqZBtpYYiWaY140+V6FSkLn+oSVeo1SfCFrsnwp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   "], {{
     {Opacity[0.8], EdgeForm[None], 
      GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxNmXfgT2Ubxs/znC8iJHu07CZCRr1WVgOZ2UKRvUdZGSUalFIyGogQTSXZ
DaM9tBfRjmjRfD/Xe50/3j+e3/35nd/5ne/5Pud57vu6r1O+7/D2w2KSJDfw
IyXeTTyZuCckyY05jvH7O/xhKvwXx96Ab4D/hF+Hp8B/wK/Bk+Ff4Vfh6XDg
f9+CZ8ARfhueBP/COa/A0+C/4TfhCfAheDc8Fy7G+Z/BD8FnwT/Bi+FK8Pfw
Mrg+fBS+Cc7B78IPwmfCh+H74Srwj/ADcFX4EHwnXAr+Al4CV4Z/gJfC58BH
4DlwUfhT+Hb4ZPgTeBs8CT6JuJUxES5M3MKYABcibmZcDxckvsCYDhclvsiY
ARcjrmS0gX/jmi/BN8LFiTsY0/QMiNsZU+EixBWMS+BfOf8WuCD8IXwrfBL8
ETwTPgHeC98GF4E/hmfDJ8IfwDfD+eH34FlwAfh9+GG4JfwLvBxuDP8MvwzP
hEsQ72CUhD/n+H3wGfA38MWMx1kzeTh2Bbw58XdvC29JPCft4K2J56q95jHx
HDaBH4Nzmg94E3wi3AHeDk/mMxrD6+CU4zX1jOG/ibW0PuCrOOdC+JFEF0qS
evBK8N/Uf3sCXsLaulJznXg+68Mr4H+INbRW4D+JFzFWwYFzGsFr4QifrzUE
/0VcxO8VuO538OWM5zheQM8HXg/nhRcwTuecrzm2EC4PfwvfA58KH4Tnw+Xg
A/DdcFn4S/he+DT4K3geXBreB98Fl4H3w5XgvXynoXBF+F14CFwBfgceDF/G
2MD95OdYK3gjPI7/bwk/A+fjeNPU86MkcCn8LHyC9hy8AD5OPEfPG/6DWJBx
feJ9d7buFT5G/A//Pwkeor3N/9/K72WJuxmz4dLECxg/8fcbOL8OfASeCleH
D8DXw7Xhw/AUPV/4e3gyXBc+Ck+Dz4e/hSfCNeHv4ElwNfhL+Dr4XHgfPA6u
An8Ij9A9w5/CY+Dr4B/gnXA9+Hd4utYD/A08Qd8d/gIeC58FfwKPhs+D98Pj
4arwR/BI+Ez4Y3gUfCF8XHkUbg3XZh7uha+A68D3wePhrzjnZXgEPJzjG+Gx
8GccfxEeA78PvwCPhqdwzmZ4HHyQ4y/BI+ERHH8eHgWPhzfBbeG68EJ4ODwQ
fg4eCl8LPwsPgwfAG+AhcF/4GXgw3AdeD7fR84MXwIPg3vDT8AC4G/wkPBDu
Dj8F94e7wI/D18JdtQ/hPfAtcBliC8Z58B0cvwSuDs/TPlYegX9XboCvjt6n
j8PXRO/rJ+B+0fv9GcbQ6PyzitEpek0+C4+M3o8bGKOi1/xqxpXRa3sN3Dl6
bT8K94jOA5vg66Jz0U7GzXBJ4i7GLLgUcT1jSHTuep4xNjoPrGX0jM4VG+Ex
0XvwOcbo6P21jtErOo+1hKvBd8JPwv2j889TjEHR+Ue5vCdftw3Puz6/HyPO
UP5RTuRv8+FWcC34Hrg5fC48V/kZLgHfBl8K14DvUn5QXoPvVt6D/+GaN2kv
w//CM+EGOSVAvj9cGX6P48OUA+Af4V3wRPhneA/8NDw4Olc3ZhSCb+F4U/gU
+Ha4CVwYvhVuCOeFZ8GN4HzwbLgf3BF+TPdAnMxtDOUzLoInwoOD98QZcAni
HI6fCj9E3ML/FIHnR9cP1ZG1wftmB7wO/oBRHi4ZfF9d4VbB89Qebg7v4Dpv
w1envq+mcN3gPV0bPiu43naEWwTX0ivhS4Lnsj5cjVic4+3gZsH78nl4JfwW
o7TyLfE3xvlwleBnWws+Mzgn1YSrEptojUirwXOja5lqmubyMrghxz9nnAmf
SsyTfW7T4PxXVPUucd0oqPobrJvawhdncyLt91divdaG2DhYA14BNwnWgC3h
C4O1XmO4Vnb/TeDawXmrKnxKcM4+F66gtcV19sDrg9fFpXCDYP3YHK4XrAcv
gS8K1pgt4PrEw8SDjAOJ12Ah4snBGrM13Ch4zV4IVw9eUxfDdYJrZn+4c3At
7ad5C9aA18CdgnXN1XDHYA04AR4YXJOvhbsE5yRpj9vhttHaY05wDR8Adw2u
7YPh7tlz7wO3D9ZoPeDWwdq2N9wuWFf2gq8I1oPSGLcF1/8hcI9grdcFvixY
cw2DewXr06vgtsH6rjN8abCOU+2+KViDDIV7BudF6aK7gnOPNNviYE0gbbAi
WGOq1s8M1tez4fHBOeAiQo1gTT0GviZYJ94BT8nWm9bABcFaeyzcL1i/j4ev
Dc610lfzg3OktN+i4LwrjbcwWCsNl64L1vLj4P7BOVsa7264IjwS7hOsxUbA
vYO1/Gjt2eBeYRTcF24E3wAPD67PxfWVgvNWQ/h85QFyzqvEfuypcvAr8DWp
a+MazlkQXDNXw/fClyunwhP13Dn/NWJ/5VjlPI5fz++XKc/BE/RMOed1XYNz
ToffgAfA5eG34UGp6/+TnP9AsCaTNrs/uA4vg+8MzuuDs7Whmv8U/GBwbX8U
vg9upVwLT9Ka4fpv6u+pa/tyjs8LruFL4TuC6/CQbJ1Uz9aY5r8FPBMel+Wf
afDIYC0wJnu+DeEp8LBgrTEue9bN4ZvgsdqX2Z4aBNfL1sMAuBl8IzwGbgrP
gEfDF8PT4VHBNWpE9qxrZs9dz7RGtk703Ktl61z7olb23K/O1on2YAf47Gyf
dgvWX2OzdVU7WzNaz+pNG8E1g3sH7fG5cAfVSXhGcJ9aDz43WGsXgE8Mzucn
wPmCa2Nd+Jzguc8H5wl+5nnhlHiQa/ZNXJelQ+vAZwevkTxwIH4dXBcqB68v
leN/E2vGGsRKwRqwOlwxWIcWS/TP1rklwbzBurUEnAtea/nh/MF9w4lwoeC1
z60kfyde+9xe8qfyl/QCcXpwfVHNKhCs08+CTw/Wd4vg2cF6cDF8S7AeXALf
GlzP58M3wq3hOfDkYJ24EJ4Ft4PnwdOCc6zq3dRgPV4BLh3cK6jWFw/W+6fA
RYN7i7PhM4J7i3Pg8sH9QSW4bHA/URkuF9xDVITLBGv8MnDBbM7Lw6WCNX45
uEhwP1EWLqy8kPOaWMeENct5bc2Br8x5PzwI304szPnFgvWJatdwjh8lHmJ8
ydjK76dlx+XBvAtvDq7vX8HbOP574vp3EuP7jHUteTSq139oD3P+W8RNWsPE
nxg/aA/k/PzWcp3tjBeza/6W3QOnJ78yjjB+zOK3jG+y+9M5+xnHsmu+k11X
rPuT1tqf3cuR7Fr7tD9T34/uS9fQ532XuC/8grg7WLNvg9dkuW47/Ghwf/A5
vCv4c/TZX2ef+Ut2D5qDn7M5WRS977T/DmWfsz/7Lsez76PzNY8H/+976jvO
y+7nzuw+j2Zzcjw7Z1/2OYezub8rel/cxo/jmTaQN7U2eu2p35RvIB9DfZb0
qNaqNHPD1NpPfdaaaJ2m/bQ8er1JfzXI+nT1ZeujtZ/60FKp889y4jPR+lD9
7wWp64V6sbrS34l7t6ej84bW8rrovaBeVV6HPA31aNVS1zX1ZXVS1xH1etVT
1xH1dOqfpDMfU41IXfvU052Wer8/op6X8XBirV4ldZ3SequautZoj6ziOlUS
992VUudV7e+/GYMSe26VU9ejR/X50blFfXf51P7MGuIZqfPJatXQ1HlmFXFF
9F5WD35q6nyykrgyeu+rH38keu+rf384Op/IEyidOi89TCzDuAdeQayduv6q
DqjPk3+1OriPfFnzoDwfrevk1XwV3QvIV/wpWtfJH/sa7pTYw/k202nyeb6L
1nXyf76J7h3k7RyO7vXkHf0erVflWx6J1nvykVQ7OiT24o5G60n5Uceita78
z5+z2qca+Gu0vpXP+Vu07pUv+ktWg+SpHoK7J/am9kTXOHmzq6Nzvtbqrug6
Je93W3TdkZe7O7reyR/ekD1r+Sobs3UuX3c7XC1xn/hcdI+g/nFHdC2Tb7wT
viCxn/xCtobVWzwR3evJJ3kSPj2x7/FUtne0zrXGSiX2TIpnNUJ598voPkh6
fGl0ztReWxbdJ8pXeT+6B5Ev+k60jpWefTu6x5G3LB/0Y10/2A/4RPcQ3Nd8
pOsEe73vw9uCfYJPdc/BGlu9z9PBfthnmp9g3/dDeEewN/wBvD3YS9itfRrs
H+zSfgzureWprgr2ReTjPRTsi8i7Wxrsi8j3WxbsJb8Hbw32EuTNPhLsMci3
XB7sSexUHsjyrXKtcrs87NeUi1QHo/tEefIfRPdl8o2/iO4T5Y2/BzdL7D+/
Ea2r5fm/Fa2p9B7hTbhB4vcC+6L7SnnsH0b3lfKoP4vu6eRdy1N/XTkz2Gt/
Q3k12IN/E94Y7JHvhbcE9/uqO88H+zevKh9Kt8CtEvvkH0X3mPLPS6bWNstS
++Lapy05/99oP1PeVEzdO8gz6ZGzJlZ+CKl1rzyrrRz7T2J/smfOPYDyz2vR
vbm8lFxq/SyvJl9q3Ss/LX9qjS2PLk9q3SsPJ2VMTezP5E2tjeUfds9ZWytf
nZBaY8tL7JOzrlKeLJJa/z9AvCrnXkV5snfOvYHyZ6+c+xPl8JNT6zHplmap
a7FqcgH4ZngRsShjrtab8nG0FpLPvCRaO6l/OSl1T3Q/8d5oLap+qnlq72Vj
tk6Uu+TzVEyt8VQLKqTuJeX7SU/sT1xny2efq3cle6P9GflF0ktap9JKB7Jc
pz3+SbSfI9+pWDbn6l3ezfKA9vXiLKdJM0inHchyRdFszvXu475ozax+bWG0
lla/tijLM+qnFkT3kur75BdJU0jz9EidE5Qbno32i+RRd05dO/R+51OOd0vs
g23I8p687tfhyxN7boVT949LUl9X15dWeZxxXmLPvGPqNa+1/1i03yIPvFDq
PnQx8cFonTw0y/nqoVQX/mRcl1i79km9p+Tb90691+TTdk2df/Teqm/OGl01
ulPO3pzWWKfUXpl86eLZM9WcSze8lD2jsqn9BL3D6pCzl6fv1S7nnlBrrH3O
vaLuuUvOfeBSuFvqfKh3ZCVS9wg63jHndw9aby1UMxJ74F1z7ie1r69KnUP0
DuLlaB9P3qme0SuJ321tivbr9N6he+pcrWfXJjtHXvrmaH9J7y96pc6N8oFb
Z+crxz8Q3S/oXcyWaM9E7zjUWMnDlMf7T7SHKW/2nmhfTj7DD/DAxB7pziyX
6t1Bz9R5TP5zt5x7ZunAV6M9NHm2XVLn8P+9Z8zql+rmS9E+mN5rdM7ZB9H+
LceYlfh9338B8RfF5Q==
         "]], Polygon3DBox[CompressedData["
1:eJwtmmWgVdUWhc9a61hgSxgoCAImdqNiYmCiYHc8MVAMMAEDAQUsRJASFRVs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         "]], 
        Polygon3DBox[CompressedData["
1:eJwt1mWUVuUaBuAZhm5QujnSEqK0hEGXIN2CdCldIgooKnZQInpIlUZCD2ER
Shp0CQpiISKIHg5wrmfx/bjX897X/tasmW/v/b5TrOfQ1kNSJSUlrZI08ntK
UlJp0Cc5KWmk/rf1eVbK7M1GsCvW+VInJT1r7mAnWA+fuYVNZp+wg6wjy8ue
YdvZcdad/SHlWH82ll2zzulzT5ofswOsg8/0k716iqRjs13P73PPmV+wk+wh
nxkgX+sZJCOb63oun3vK/JwdYV18ZrSc1rNLQbbc9VHslJ5VCrBl7BDLZDZm
7dhh64Mso9mItWWHrMew7/WcUoitYIPZfj2bZGFvs0Hs2+iSmc1jA9k3eqYI
e4sdZpnNJqw9O2L9GytpPsyGs7+sL7Ia5mg2jWXW8/h7p7Ft7BjrxnKzp9lW
dpR1ZbeyKexTdoh1Yj9LcdaDDWUX4/6z3fqNxHMxkx1h2czmvDM7aX2OFTW7
scHsgvWPrIjZlQ2KZ8r6RDwfZivWnZ22PsZymC1ZV/ad9TcsxbyHtWBfWV9i
Dc2pbAYrEN+npGb3spbsa+sfWAGzI+vLfrY+znKaD7Bu7JT1n6yeOZG9yHLq
P0kx1p0NYX9Yn2WFzS5sIPvN+ldWwuzFhrHL1r+w28ye7FF2yfoMK2R2ZgPY
eevLrJH5FJvJ8sdzK6lYPdac7bW+wMqYfdko9o/1UZbdbMG6sBPxPrJd+jXd
bU2aEc8J28mu6pZJb8TPsdjDkiUtmxXvHtunp5H0bA7bx67ptaQh+5KdZvnM
9qw3O2f9PctvdmB92E/WY9kP+q1SmK1kV1hL83k2jxXXv5JkVpc1Y/us97P0
ZgP2IDtg/RdrYU5nb7Fi+nfxnLO2rBc7a30q9hizHXuY/Wh9Mp59sw3ryc5Y
H2AZzIasDTtond6XNtxcxbaxxvE8sifYFraftWfTJC2ryu5j+62fYenMauz+
xO/8b3avOYxNZrn08fFs6fnkNrbO9U1sormcfcba6hPiPdTzSwm23vWn4waa
ldjdlnvi2WE39Ipxn9hu9izLYtZmTdgx6+dYVrMOa8qOWz/Gfol9TkqyDewd
VtccyiYl3oWPZCibx9aw+vrG2D/ZYraRtdC3yhn9X1KBrXZ9KWtlPsFeZSX0
z+SgnkuKsPmxT7Gz8Z3E3xLnD/sPe8R8m33AGuhfyp/6HVKbfeL6LnZZv1Pq
sk/jHGK/6eWkKvswzgh2Xr9dqrGP4hxiv+plpUriO9jJLumVpQ77OJ5ZVtBs
xjqxX60nxdmlF4ufyTbH38ku6sWlPNvCXmN3mA8l9oMU/VWplNhjH4nbqr8i
FRN7Tuy7yfpMqZLq5lkb5286/WWpkNhjY2+KF/sNuTOxD8W5kEafLrlY/cR7
FM/9FPaPXibx925nk9nfemm5i21jT7Ireqn4XtlW9jqrnNjXYq9Lrb8k5RN7
e+z3N6xnsLsSZ1T8f5BWnyVVU938PyL2sPT6i3J7Yj+Nc+G69ePsgl407h3b
xF5gZc1OrD+7aj2HVTf7sTEsY7xD8ns8U3E/2UbX32Q1zQFsPMuiz5VabCCb
wLLq86Q2G8wmsuz6Mmkd3wV7jZXU35Y6bAh7nOXQ35K72SD2GMumz5ZqiT17
NMugj4w9K878eK/ZUtffZ83jXUycPbGvLZcH476w11kp/X/SNf5utpzdof9X
2sd9YUtYubi30i6eObaYlYnzxB42gC1JvKt1435LW/YqW8TK6pl8bgxbx3Ym
3uksbBzbwHazB2IfYePZh2wPa8WysQnsI7aXtWYZ2Ui2hu1gTVlmNpatZ7tY
y9iH2Qi2mm1nTdhV6cJms2WsUsrNQ603m8/WqzVjf5DD+nX9FlkY94YdYDkk
K3uHjWDH47yTPOxd9ig7khwvmnPKWMSusW7x3LAVrLI+XI7pqSU3W+J6dr/L
JHMz+5a1i3OM9WEL2AZWK/ZmeTjOAraOVdevS6/Ya9laVkMfJkf1VLEvssWu
p/Pzhpkr2VbW0GdS2ED2LtvE6rHUbBB7j21m97DP5YReMLG3x9+7mDWOs5k9
xwrpe+K71mtIfbYjfjZrao5nz7Mi+krpwKaxOay8vkgasFHsaZZPXyD3x/fN
prI8+nvSjE1gL7Ci+hJpwsax6aywPl/uY8PZFJZbXyj12Uj2FMurr5e+sc+w
91ltfYP0YzPZUlZH/1D6s1mJZyie+3FyTs8b5xRb63pa39+j5gr2OWvkM2nY
4Hg/2RZ2L9sb76FeUxqwL1zfHe+hXj355rkf++la9pD5MlvAquprpHOcw8k3
/3+J53md9GSvsIWsmr5C2sQ+zd5gpfUPpAd7ic1nVfTV0inOejaXVdRXScf4
X4S9ySroU+N5i/M4fm+2y/X/A66drJk=
         "]]}]}, {}, {}, {}}, {
     {GrayLevel[0], 
      Line3DBox[{246, 1, 242, 227, 661, 16, 675, 31, 690, 46, 705, 61, 720, 
       76, 735, 91, 750, 106, 765, 121, 780, 136, 795, 151, 810, 166, 825, 
       181, 840, 196, 961, 231, 248, 211, 244, 236, 445, 212, 446, 213, 447, 
       214, 448, 215, 449, 216, 450, 217, 451, 218, 452, 219, 453, 220, 454, 
       221, 455, 222, 456, 223, 457, 224, 658, 233, 249, 225, 245, 237, 867, 
       210, 853, 195, 838, 180, 823, 165, 808, 150, 793, 135, 778, 120, 763, 
       105, 748, 90, 733, 75, 718, 60, 703, 45, 688, 30, 959, 229, 247, 15, 
       243, 235, 275, 14, 273, 13, 271, 12, 269, 11, 267, 10, 265, 9, 263, 8, 
       261, 7, 259, 6, 257, 5, 255, 4, 253, 3, 251, 2, 659, 234, 246}]}, {
      Line3DBox[{661, 958, 458, 660, 1051, 868, 662, 1052, 869, 663, 1053, 
       870, 664, 1054, 871, 665, 1055, 872, 666, 1056, 873, 667, 465, 668, 
       1057, 874, 669, 1058, 875, 670, 1059, 876, 671, 1060, 877, 672, 1061, 
       878, 673, 654, 879, 959}], 
      Line3DBox[{675, 963, 1140, 674, 472, 676, 1062, 880, 677, 1063, 881, 
       678, 1064, 882, 679, 1065, 883, 680, 1066, 884, 681, 964, 1141, 682, 
       479, 683, 1067, 885, 684, 1068, 886, 685, 1069, 887, 686, 1070, 888, 
       687, 1071, 889, 688}], 
      Line3DBox[{690, 965, 1142, 689, 966, 1143, 691, 487, 692, 1072, 890, 
       693, 1073, 891, 694, 1074, 892, 695, 1075, 893, 696, 967, 1144, 697, 
       968, 1145, 698, 969, 1146, 699, 1076, 894, 700, 1077, 895, 701, 1078, 
       896, 702, 1079, 897, 703}], 
      Line3DBox[{705, 970, 1147, 704, 971, 1148, 706, 972, 1149, 707, 502, 
       708, 1080, 898, 709, 1081, 899, 710, 1082, 900, 711, 973, 1150, 712, 
       974, 1151, 713, 975, 1152, 714, 976, 1153, 715, 1083, 901, 716, 1084, 
       902, 717, 1085, 903, 718}], 
      Line3DBox[{720, 977, 1154, 719, 978, 1155, 721, 979, 1156, 722, 980, 
       1157, 723, 517, 724, 1086, 904, 725, 1087, 905, 726, 981, 1158, 727, 
       982, 1159, 728, 983, 1160, 729, 984, 1161, 730, 985, 1162, 731, 1088, 
       906, 732, 1089, 907, 733}], 
      Line3DBox[{735, 986, 1163, 734, 987, 1164, 736, 988, 1165, 737, 989, 
       1166, 738, 990, 1167, 739, 532, 740, 1090, 908, 741, 991, 1168, 742, 
       992, 1169, 743, 993, 1170, 744, 994, 1171, 745, 995, 1172, 746, 996, 
       1173, 747, 1091, 909, 748}], 
      Line3DBox[{106, 347, 107, 348, 108, 349, 109, 350, 110, 351, 111, 352, 
       112, 353, 113, 354, 114, 355, 115, 356, 116, 357, 117, 358, 118, 359, 
       119, 360, 120}], 
      Line3DBox[{750, 997, 1174, 749, 998, 1175, 751, 999, 1176, 752, 1000, 
       1177, 753, 1001, 1178, 754, 1002, 1179, 755, 547, 756, 1003, 1180, 757,
        1004, 1181, 758, 1005, 1182, 759, 1006, 1183, 760, 1007, 1184, 761, 
       1008, 1185, 762, 1092, 910, 763}], 
      Line3DBox[{765, 1009, 1186, 764, 1093, 911, 766, 1094, 912, 767, 1095, 
       913, 768, 1096, 914, 769, 1097, 915, 770, 1098, 916, 771, 1099, 917, 
       772, 1100, 918, 773, 1101, 919, 774, 1102, 920, 775, 1103, 921, 776, 
       1104, 922, 777, 1105, 923, 778}], 
      Line3DBox[{780, 1010, 1187, 779, 1106, 924, 781, 1107, 925, 782, 1108, 
       926, 783, 1109, 927, 784, 1110, 928, 785, 1111, 929, 786, 1011, 1188, 
       787, 577, 788, 1112, 930, 789, 1113, 931, 790, 1114, 932, 791, 1115, 
       933, 792, 1116, 934, 793}], 
      Line3DBox[{795, 1012, 1189, 794, 1013, 1190, 796, 1117, 935, 797, 1118, 
       936, 798, 1119, 937, 799, 1120, 938, 800, 1121, 939, 801, 1014, 1191, 
       802, 1015, 1192, 803, 592, 804, 1122, 940, 805, 1123, 941, 806, 1124, 
       942, 807, 1125, 943, 808}], 
      Line3DBox[{810, 1016, 1193, 809, 1017, 1194, 811, 1018, 1195, 812, 1126,
        944, 813, 1127, 945, 814, 1128, 946, 815, 1129, 947, 816, 1019, 1196, 
       817, 1020, 1197, 818, 1021, 1198, 819, 607, 820, 1130, 948, 821, 1131, 
       949, 822, 1132, 950, 823}], 
      Line3DBox[{825, 1022, 1199, 824, 1023, 1200, 826, 1024, 1201, 827, 1025,
        1202, 828, 1133, 951, 829, 1134, 952, 830, 1135, 953, 831, 1026, 1203,
        832, 1027, 1204, 833, 1028, 1205, 834, 1029, 1206, 835, 622, 836, 
       1136, 954, 837, 1137, 955, 838}], 
      Line3DBox[{840, 1030, 1207, 839, 1031, 1208, 841, 1032, 1209, 842, 1033,
        1210, 843, 1034, 1211, 844, 630, 845, 1138, 956, 846, 1035, 1212, 847,
        1036, 1213, 848, 1037, 1214, 849, 1038, 1215, 850, 1039, 1216, 851, 
       637, 852, 1139, 957, 853}], 
      Line3DBox[{867, 962, 656, 866, 1227, 1050, 865, 1226, 1049, 864, 1225, 
       1048, 863, 1224, 1047, 862, 1223, 1046, 861, 1222, 1045, 860, 645, 859,
        1221, 1044, 858, 1220, 1043, 857, 1219, 1042, 856, 1218, 1041, 855, 
       1217, 1040, 854, 655, 960, 961}]}, {
      Line3DBox[{251, 459, 1051, 252, 472, 278, 1143, 486, 292, 1148, 500, 
       306, 1155, 514, 320, 1164, 528, 334, 1175, 542, 348, 556, 1093, 362, 
       570, 1106, 376, 1190, 584, 390, 1194, 598, 404, 1200, 612, 418, 1208, 
       626, 432, 1217, 640, 446}], 
      Line3DBox[{253, 460, 1052, 254, 473, 1062, 279, 487, 293, 1149, 501, 
       307, 1156, 515, 321, 1165, 529, 335, 1176, 543, 349, 557, 1094, 363, 
       571, 1107, 377, 585, 1117, 391, 1195, 599, 405, 1201, 613, 419, 1209, 
       627, 433, 1218, 641, 447}], 
      Line3DBox[{255, 461, 1053, 256, 474, 1063, 280, 488, 1072, 294, 502, 
       308, 1157, 516, 322, 1166, 530, 336, 1177, 544, 350, 558, 1095, 364, 
       572, 1108, 378, 586, 1118, 392, 600, 1126, 406, 1202, 614, 420, 1210, 
       628, 434, 1219, 642, 448}], 
      Line3DBox[{257, 462, 1054, 258, 475, 1064, 281, 489, 1073, 295, 503, 
       1080, 309, 517, 323, 1167, 531, 337, 1178, 545, 351, 559, 1096, 365, 
       573, 1109, 379, 587, 1119, 393, 601, 1127, 407, 615, 1133, 421, 1211, 
       629, 435, 1220, 643, 449}], 
      Line3DBox[{259, 463, 1055, 260, 476, 1065, 282, 490, 1074, 296, 504, 
       1081, 310, 518, 1086, 324, 532, 338, 1179, 546, 352, 560, 1097, 366, 
       574, 1110, 380, 588, 1120, 394, 602, 1128, 408, 616, 1134, 422, 630, 
       436, 1221, 644, 450}], 
      Line3DBox[{261, 464, 1056, 262, 477, 1066, 283, 491, 1075, 297, 505, 
       1082, 311, 519, 1087, 325, 533, 1090, 339, 547, 353, 561, 1098, 367, 
       575, 1111, 381, 589, 1121, 395, 603, 1129, 409, 617, 1135, 423, 631, 
       1138, 437, 645, 451}], 
      Line3DBox[{8, 667, 23, 681, 38, 696, 53, 711, 68, 726, 83, 741, 98, 756,
        113, 771, 128, 786, 143, 801, 158, 816, 173, 831, 188, 846, 203, 860, 
       218}], Line3DBox[{263, 465, 264, 1141, 478, 284, 1144, 492, 298, 1150, 
       506, 312, 1158, 520, 326, 1168, 534, 340, 1180, 548, 354, 562, 1099, 
       368, 1188, 576, 382, 1191, 590, 396, 1196, 604, 410, 1203, 618, 424, 
       1212, 632, 438, 1222, 646, 452}], 
      Line3DBox[{265, 466, 1057, 266, 479, 285, 1145, 493, 299, 1151, 507, 
       313, 1159, 521, 327, 1169, 535, 341, 1181, 549, 355, 563, 1100, 369, 
       577, 383, 1192, 591, 397, 1197, 605, 411, 1204, 619, 425, 1213, 633, 
       439, 1223, 647, 453}], 
      Line3DBox[{267, 467, 1058, 268, 480, 1067, 286, 1146, 494, 300, 1152, 
       508, 314, 1160, 522, 328, 1170, 536, 342, 1182, 550, 356, 564, 1101, 
       370, 578, 1112, 384, 592, 398, 1198, 606, 412, 1205, 620, 426, 1214, 
       634, 440, 1224, 648, 454}], 
      Line3DBox[{269, 468, 1059, 270, 481, 1068, 287, 495, 1076, 301, 1153, 
       509, 315, 1161, 523, 329, 1171, 537, 343, 1183, 551, 357, 565, 1102, 
       371, 579, 1113, 385, 593, 1122, 399, 607, 413, 1206, 621, 427, 1215, 
       635, 441, 1225, 649, 455}], 
      Line3DBox[{271, 469, 1060, 272, 482, 1069, 288, 496, 1077, 302, 510, 
       1083, 316, 1162, 524, 330, 1172, 538, 344, 1184, 552, 358, 566, 1103, 
       372, 580, 1114, 386, 594, 1123, 400, 608, 1130, 414, 622, 428, 1216, 
       636, 442, 1226, 650, 456}], 
      Line3DBox[{273, 470, 1061, 274, 483, 1070, 289, 497, 1078, 303, 511, 
       1084, 317, 525, 1088, 331, 1173, 539, 345, 1185, 553, 359, 567, 1104, 
       373, 581, 1115, 387, 595, 1124, 401, 609, 1131, 415, 623, 1136, 429, 
       637, 443, 1227, 651, 457}], 
      Line3DBox[{275, 653, 654, 276, 484, 1071, 290, 498, 1079, 304, 512, 
       1085, 318, 526, 1089, 332, 540, 1091, 346, 554, 1092, 360, 568, 1105, 
       374, 582, 1116, 388, 596, 1125, 402, 610, 1132, 416, 624, 1137, 430, 
       638, 1139, 444, 656, 657, 658}], 
      Line3DBox[{445, 639, 655, 431, 625, 1207, 417, 611, 1199, 403, 597, 
       1193, 389, 583, 1189, 375, 569, 1187, 361, 555, 1186, 347, 541, 1174, 
       333, 527, 1163, 319, 513, 1154, 305, 499, 1147, 291, 485, 1142, 277, 
       471, 1140, 250, 458, 652, 659}]}, {}, {}}},
   VertexNormals->CompressedData["
1:eJx0vHk8Vt33Pq5SIoVGDYqiFGlSUliJBmlGs9JERBMqQ5HI0EQalCYlGolC
ETvzPM9TKg3Efd9pMCT57X2yfH+Pz7vnn/O6z3Pss/c6a691XWtdO7kd+9fu
7i0kJJQpLCTUh17vLHLWjZWtIHg9OK7ALVb2C7wSWdrXoK6E3Dvsohb5soKU
xq21j3z5Bdao3eAfsyskO42M9J/qVJL0c8fPP9VpAJ2QwR0Tw3KJ6FJN6d4x
leR7trdx75gG6D91XH956TQyjjhLThlTRVoVU9dNGdMI1Z0TXyqrvyZmOjL6
g3ZVkWKzERcG7WqEP51nh1qufUo2nh+jpOldRVoU3Q5pejdChLNEkcItDa0J
d06cUbhVRf7+boQfJ4Vm0OfhtVfdFPb8Vvk13PNd40PP8R2Sngyj84G0Xo0S
bD639s7k5tM1f+g5/671Qs/13rvNl6T2AZ3JJ2cz+xw4aHCU2edIQpMetSMM
8zXXYfZ8ZxnjyuyJdkS7oj0vHKydVWNTSvA644+8UahxA6xfWbdKpLmQ+Lfo
pfT/UUoqNN08xb41wLj54fJe2nkkZMMAtVU7yojMGutB4YcaYaWKTp81r9LI
32sZsf3opPi8shFm2YVcFnn4mswcudp8QGcZsb9ae+XsZB7Ia67PNUt+Smar
b4wbrVhOrEPPtdtu5IHQ3/+cdTRzhrXNLie1LXHv7ph3Pw89nz/d3uceHR/c
ZjbtYeM/fWfDjZ/9R2wcnQ8ELZvWm83nZD+tSWw+M4KFZtL5A/x8OJvN32pm
mTib/+CtblvoesHH4n4SW+/SkTfd2XoPXM1Vp3YB/6mtM5l91F0HGzL7ZAT0
06T2BPHtS4WZPTc7Ktoxe+J3Qj/F74V2RLuiPdNHmMqKmBURvCqNrj/I/Kdp
3LYJfQPyiPamY9aL04uI43beivSRPMgcJSLRtiad7CjSrA8cWUyq9fafXeHF
A+uXKnWSUvEkz2zeeCOjYpL2ybquupoH82TGxjiqhJEB6xwkxtgXk/TMhJxN
Unxo1VnbSsZraR1R+1DrcaqY/P3Nh1327c30eXAIluee/31Aj3s+L6y8mY4P
vtYf5dj40PL7Mxt/5fK5MnQ+0OmeUMfmE/Uo4Qybj1LJpCl0/iA37e0hNv+V
G6S4+XetE3quV523ooDaB5bHL17J7HPhkQZn/y57Qk974j7BfY/7Bf0S/RT9
E+2IdkV7LrV/KTPvRx7B6zm+f1/TRzxw7V2hE1iUToRERnlZzc0nU+uMW5h9
ls/4lK64N578veaTI6cnRrg78OHqoBH+1l5hxHpj+ktrr3yy7aFX+bJwPugW
SX7MTtLSmiq18LXIpXzy9zcf3lfMKKPPg6i3E/f8R09R7vlPzyrL6Pgg/vUG
N/6ikfefs/Gllq9cS+cD21eEebL5GN0NambzkRtyS57OG26rq3Lz3x0bLszm
37Ve6Lnec2NUdah94GnpmgnMPsPuinH+32VP6GlPjJsYRzF+4j7HfY/7Hf0S
/RT9E+2IdkV7Tmn7M7oRMgheA/1DBtbf4oOK+vaxcyPiSVKxz9Si8xlEXGeH
1/gOPuy+v61sdEkY8XM8nzQ5PoPczD4mGTZH0B03Pi5bLVOen0HmLL64QnGZ
AJae399CnweDFUbc8zkN6tzzSm99p9LxYVPzOG58CfNqTzZ+1zyg53y65g89
59+1Xui5XiltTwlqH/hjOroXs4/PpN8KzD4Xo5WHU3vCpvCf/Zg9i0ZaGjF7
Yp7AvIT5AuMmxlGMn7jPcd/jfke/RD9F/0Q7ol3Rnrnp7wr3N8YTvE7r7ySf
ZCwAcUHhjrODwsnfawJ52lCWeOSqAMx/avg8fAJas5znyEmPSiB/f3c/Dz2f
fzr6zjc6LpxZr8uNP8d57wQ2/pcruzXofCBxo0CGzUfy9zXO/vJfe1P/zwd9
5eQ0Nv/QBOVnbP6+Ps7T6HrBua7iE1uvtLrcJ7beLvtAT/t02RN62hPzOuZ5
zO+YVzAvYX7BuIlxFOMn7nPc97jf0S/RT9E/0S5oV7RPeZZawIEZ4QSvNpdC
D7qVCKCed9lFpQG0pI63FWpphpO/v7ufh57Pd40PPcc3WOJYSOcD1XoNpWw+
KorhEmw+6hvbU+n8oblOcJXN/6jiqVI2/xvXCsbQ9ULbjsSXbL1ZfXdlsfV2
2Qd62qfLntDTnv/FSRpaiJcwr+N+xfz+3zykpYX56L9xU0sL4yfucxwH9/t/
/RK00D//a0fQQnvi3//3+hVWf3IcAprhcC6+L/f836sA4jReTafjwxixUG82
/t+rAN57LlKm8+ker3x86nI2n9lBW1Pp/KEjTvwDm//fKx/CNLSb6HrBcavg
J1vv3ysf7QM97TNOcv4Fak9QVwgoYPb8e23sxp2IQxF/9vBnwO+FeR3zPOZ3
zEOYlzAfYdzEOIrxs4c/wz/8GdA/0Y7/tev/8Wf4hz93jy8hvZDzZzK9vZnN
Z+vifZw/550P4/x5foRYKZt/p0hfzp/FGx04fx77+vZPtl6hR18y/4c/d9un
y57Q05494jNgPEHciTgU8SfiJMRNiJcwr2Oex/yOeQjzEuYjjJsYRzF+9ojP
3fZBv/yvn/6f+Nz9/N4Hwty4eNVoXT+eje/04vt8Fp/jhcZz8xk8fjg3nw8h
0aUsPv+9xsPx1SHhbP7rbihx8bnyrdtPtt7zeg8/svV22Qd62qdHfO62J/Ii
5EnIjxDHI65HPI+4E3Eo4k/ESYibEC/1wBuA+R3zEOYlzEcYNzGOYvzE/Yn7
Hvc7+iX6Kfon2hHtivbsgTe659M1f+g5/671Qs/1mhvbDmJ4w0Gtdgyzz62l
0fLMPpodV4YxvJGt5zqU2dNxS6khs2cP/AyI95AXIU9CfoQ4HnE94nnEnYhD
EX/2wM+AeAnzOuZ5zO+YhzAvYT7CuPnfOMrv3ue473G/o1+in6J/9sDP3fY8
WjCSmzde559J78Pm37Ve6LnecS8LtRl+jte5PZ3ZZ7frfrH/gZ+77dmDDwLy
F+SZyDuRb/bgg/APPgj/4IOA+BNxEuImxEuY1zHPY37HPPTfvMTvjpsYRzF+
4j7HfY/7vQcfhH/wQfgHH+xer4rJ4zzGB/vl125i9unlbuT2P/hgtz2xDoJ1
EayHIG9HHo/8HXkm8k7km8iLkCchP0Icj7ge8XyP+gb8o74B/6hvwD/qG/CP
+kZ3/MR9jvse9zv6Jfop+ifaEe2K9rQz+jCX2QWv2mJCBsw+ewxF5rP6xo82
vgSz5w+VyUeYPbGuhHUmrC9hHQTrIlgP6VGvg3/U67r3C/Ii5EnIj3rU6+Af
9TpA/Ik46b+46f/U6+Af9bru8TFuYhzF+NmjXgf/qNd1rxft2G3XLnt+kahc
yuyI17XRgSeZPX+GlTg/KSkjeB1uH5GXQ77Aur0pA2v2VRCRrY9b3E6XkRtX
K1fV7PsC+umup+hzcKW4yIk9X5x6K5c9P/i89hD6PGSb3m5mz5/sG7OSPY/P
4d/h86NtosXZ+BcWruqgz4PJnVzueV6jixt7Dq+XhnnlsOc36Ov8Zs+VXpk9
mL1n8aDQFex5nB/OF+eJ4+J7cHycH84X54nj4ntw/C0zX466ebyc4FXzmeWG
DQe678M/7uPz8I/nu++/5W1eNH1pBUm7M8D04/pyMtNM0n360i+Q0XhpL/0N
AtNluuz/a73948bul4z+tYs9d2tNwTJ6H7LifnD3QzJe67HfZbtdLdjflavV
urL7OC6+B8fHv8fxcBx8H74f34vj4ntw/DvXp5afeFNKrJ5dVF69q5Q8PbQn
23hZAzR+UR+Xuq6IDE2silw+oZK49Yn4tXxCA8xJCxC1Ki0iR5Q3qiiXlJJb
5e+LZ+U2gPNnD7eoOflkVv8nuvI+leR07RVPeZ8GeLhkt9yk4HzSMfde57X5
ZWRxZ+cRr0WNUHEmY933z5kkcHyvmA/8SjJxW4nQR34D/FotabrwbhYZOybS
fOuFMnJOckpG4kOa1wyGrOuYmExKzabb7plXRZ5YJcTsmdcIp/n3Xo19kUwu
X5iuvqOsjEQv9/1w6Hcj+A7mHRtp9Yo8f/y0ovhgFRHVzZYrOdgI7XeOzNs8
K5bUL5rhXT6gnGiEvxx1fC4PsltD8qt9HpN+hetFYnyriP6k9JUxvhRnLnyR
qL75Cfmyuo/IZqVycv3A1jww5sHqmiSpNz6PIchHnnu+4eMl7vnUv89Dz+e/
Jwm50fmA+IBr3HxM7kRy89HZJryazge2ffx2ns1nceMBbj55Py9tpesF79Q3
Nmy9u7IPcOuVf7qvkK4XbJMt5rL1Snk8rmXr/cw7ZUztCf2EHkUze7prOHP2
rF296AS1J7xUddjD7Kn9JDqN2bPre0HP76Uw4ZAK/V5w2lfpD/ten/csOcy+
1/kbKuOpP4Dzur2cP3y7rMP5Q/68s0OpPwDvU7Uy84ccY8Ui5g8btrh5nllT
CsYtgkjH4AqSHXqhzTH4C4ysEK+h/gZ9Q4KUmL89i1+bxfxN+MiPiUO3lRGv
vk0eGz8XklMy8YHHqhtAykTSQmp5MdlY4XnJYXkRkfS+FjZkbyPsy7QUMRxY
QBqWVVxPCyoim3vtcHeqp3FY+ZlS3opssmCsprPKjyIivfdrW4URD4ZErNVx
1EghOis3TSEzi6mdNQ0OPeFBvwjJm6Z1saSPyYSkLJNics9/eWYDjwfrZDft
XjAkhBSbHe7d91gxOfvR95XVMD7Y755TTe+DkdMU7r7Y7cncfc3hvRLpOGBe
mpzIxpn1ID2DjaM849ka+l4wH8ebzN47VOreWvbeLbWX1Ok8YYr7Uyc2T58r
Stw81+2+O4CuC4bc3c+tqy006xRb14MqGStqB2geOZWzQ0OENGeHnVcPzKB2
A6X5x9yZ3VL9X9xhdnsnd7O/Z04ZKZUeHjt5dh7FFzvWixo3wjPjjx/Mw4rJ
YLkDmy555ZHjk2ueuH1rhMc+Nbl6pgXErs5Dt3dpHrmx9tdS3aM8UC87H+j7
PpsoDTWuCJDOJ3ua8jxHN/DgQWFjxZinKeStmFBCwop8IvbMfeywpXyAppFO
MafiSL+U7RZfbPKJd+LUc9fO8KHXral+q56HkCV5Fxt5Z/KJWZB9+O1IPmR+
PjV49fMQkJhpyN139RHl7r/vnR5Ix4HBswZz4+xyuXOWjdO81LeevhdeLLwb
z94bb/hRhr2318CwcDpPuJrysZzNM2iyEDfPSaWTiui64McJFW5ds8Zt4dYl
GvL7M7UDvMiR4+ywdeQ6zg6Hxs4bQu0GzVuqYpjdTKdrGjG7addf3Gc/uZys
Uzp87/v9NJLSMMl7THIjDE6vTdQVLiEb/Gs+Zqqkk6aQe+4623lwMoIfpxBa
QNoDxXxJUDrpNDupOJv6w+n9SUr+W3LIdw2va58GZpA+D5cant1NeUqv77bD
JFKJu4fecLftGUS/aPy50al8mBsVaFjXnxDpBZmOs29lkIDGR1JDJQQw+f3r
B3lzQ4l5dfCgwckZNI8HSS2YLwCpwklv6X24rO/A3d+Wdoi7P61DzZqOAwUj
zbhxVg9T48YRP+3vQN8L1t+kuPd6/np3lr23a57Qc55d64Ke65L43juV2gEG
1O/i7HDJczhnhzPZfeyp3aAi0vwus5vroKSzzG6HA67Mem9ZTvQHmQ+Kuv6a
FIlNebBgMA82bllplKJdQl6Yn0wubX1NlnoYNNg948GR4QdMVn0sIL93nBt/
Uj+ezLr0PFdBl/rPqJVz9kflkMGZS8eEXognQqukUsJf8+H3+PUHy4xSydyZ
WhP3Z8WT55/fvk9QEMDhZcFVbeaEuMm+3Da4JZ7AT+8LJgcEcNVIkPzIP5RY
Pqo31JZKIEYtpx/NvCkA37yoYnofDhe/5e5/cnbk7tvGfxL7ZU5g7o013Dg2
uZU+bJxeN0adou+FT3nhCuy9Ozoa37H3iut/0qfzhEwP99HcPEeTJDZPSzPN
fXRdMOD8Rjm2rqXj/bLZuoysZ2+jdgAdG7skZoeIUS71zA5ddoOedhNXLtqz
+XI5ObQg2q4k6inJe2B/L0qb8m5h89L7ZiXkqUvZq9RhYWThaBXhsZ94wOMf
2v28XyF5HG/cJG8RRnRb3afF2/Ehrc/D3o6CHJI8jn+5MDyM7J459cW3Vj6c
EjdYdvpEKikJGupSwgsjs2MbX6qZCGDCt8NTftwj5MtJS1urkeHk3GK/D06P
BbB8YPG6lLJQEmpkaaKqGk4yEw1FtlQKQKM5xpTehw79ndz94m+63P2ucaDn
OJ4dzwzoeyH3VdEJ9t77tY7ce8+t3SVN5wmCSEVunl+iCyPZPMN+GFjTdcEG
h/Ff2boUNE2msnUpPt3yjtoBJk9Jj2F2WLHAoDezQ5fdoKfd7BcllW0OLCex
Fht+ut8W15r3w6kpdg0PLuyIEdjYlJB120JuTrg+R6vA3HiFegsPrB8Pf9Qh
VUi8WvU31pzW0vp75YOX9TDf/b1zyZpj9z4uSFfRuq6jENcyQAAXJT8rGHin
kmGLtDseJE/SSnISudNhLQD5dBUJiCbEY2SRU+lr0Pp7FcBNxeO3rHmhpI/x
ogfJgvlaC6fonhv0VQD272MG2fBCoUip6D677/+z6Cy737Fp1Rw6DiREqXHj
/L0KoGb70Nn0vZBpV/KbvXe/75oA9t5dmiEBdJ7g/+r2BzbPZ3/mx7J5itpd
fE7XBV6v8tZz6+KudH8tfdZG7QCvFIqvMztobnDSZ3bIeeZUTu0G7eH878xu
k9rWcXbrdM3m/LP67tJj1M6wrMOaszNsVuT88xwvoZ5+F1h4rrAP+y4yqvKc
fxYPEFVRsAiD2kuinH8eDF/I+WdVrWgy/e5gp50Rxb67i6MK55+W809con4C
lwYm/C//hJ7++XCt8R7qh9ByfeF//LNtqSF3v1fWzP/ln93juFmd5/xz9xpt
7r0iqmu5987t1TGC+aewg24Sm+ef9AOcf75V78v5p0NytjJbV3LFO2W2ruR+
Yzj/7HPpWR2zw4pnrb2YHbrsBj3tdrFEl4uf8+/9GEXjANQfTL/P4sCSkmZD
Fj+tlo8qonED1nm9+cLihmPLeC5+6rwwn0HjDGxKn8vFz4bnWbNZ/Nz1dasS
jUtQa30+mcWlEb+KDrD4WdBfbz6NY1B2fSIXP62coytZ/HRPzTxM4x60P4v3
+f/Hz3tuFetonITQufZcnLzQFT9DQvO5+5Bgwd3f09ImyuKnmu4ubpzp58S5
ccbY+Lmx+OkcHDuPvfdU+Ewufip93MXFT5mQG1PYPD+AJhc/Dy79asXi55oP
qtPZuvatG8PFz4W86q0sfjavkyxkdkgaM5CLn112g552WzHLx4rldx+To4Tm
KdAV/n2O5SnFW9pcfpfXOdJC8xoIMgtOsbzW9uY4l99dt5sF0DwITR9yJ7E8
mJq9icvvY+8nBdC8CX3kGg1Y3szyT+Pye/awitE0z0K2UxmXZ0XPVBmw/H49
L+g0zcvgplcryfLyyCE/77P83vfuZRmax0EovUKS5fHOPltqWH6fJWXB3fdK
D+Lu9ynYf4jl9/UPF3LjqB7ax41zXeEgl9+jne5w7x0QdIV7b9c8oec8u9YF
PdelkG6SwvJ7iffvZmaHi0E6nB2ujhCyY/l9cOPeWGa3XpP8zjC7eT6wEGH4
81tFTBrFUXDdsZ3DUbbOwzn8OW9bxQ6Ku2CBUsFjhrsGTVnD4U+3bbv0KU4D
ieRhHE7bbyfK4U+duNxqiusgUGMzh+uWzTzB4U8FheWpFAdCSO9MDgcubZU5
xvDnLwW3oxQ3gmbg9DMMN/aPUrzM8Oewqg9tFGeCRM6lpwxnpneekGT4841m
IHdf+aU8d/+zaPYdhj9FfGdz40jtvHeajeMXPInDnx1bBCnsvbsDFbn3qoVM
4fBn2IEN3Dzf23h5sHl67b9ayPBnZ6sot65AnyNL2Loy86Zy+LNG/AxnB9nR
epwdRgX1G8zwp+Q4l1RmtyzrEgNmtw2jPBQYP0rNafelOB9MhaTvMpzvvizI
nPEjz6xQP8oL4LPr2P/Fj+Af/AiQHynIFi1k/GiT7LpplKeAVz8TjqcYnI/x
Z/xI7u2+fMproGlycxrjNas//9rB+NHOvrkSlAfBMUXVaMaDzJVLKxg/qh1z
krv/6336S3b/1NdHrxk/cl8vxY3jpGbNjaN1XZXjRyea6lTYezcopa75H/wI
/sGPAPnRuNRnlowfTRQ34OyQ8PD6U2aHCA3h6YwfmQp7XGB2Cz4uEcDsNkN6
XBmre7xKUJtFeSjEn1TjeGj0BpX+rL6Rn142l/JZMD9VV8j4rJFQ4zhWxzAZ
HT/Af34ZLAq4Y8t4sdok/52sXjHxLN+W8mvwaAlPZfz6iZ1+DKtLrH9cuYDy
dJhf9ec94+k96g+A9YcedQbAukGPekL3/R51A8C6waL5QwtYfWB2zTDuvb4j
pLn3jp2Ud5zVARLuPbNh85x/USeFzTO7slWZ8X2B7RIxtq5PYl+s2boMM0cO
Ybx+kauxGrODn5hKAbPDfaM/1Yy/G8TqzWR2SyqQy2R2k8zadpzyfTL+h1oc
5ftglD39F+P7eYPaxrI6kuljjRfLJ1SC9nRzrm7Qo14EWH+QIHO4ulDqkbLY
D/xKOJA0matjeF3eYMTqPy2GMUf3zKuCZQfrolk9pEedB7DOk9NVz5kzQKJ/
jG8VwEZ/rj6DdZuS9EpWt4GaEXu4+z3qM4D1mT1zK41ZHSb0uTn33t75l7n3
jpH9voXVWyYbuXDzzA8o7PzAb+hZV+lel008T47VTwohM4rZISSxpY3ZwVOb
5yqVU0rw2jr3o66UWgPM7PMrblVEEXHdZvntyf0y8uSi/X3fYOq3qqEvb9vl
k6ZNIaM3O5STXQ8HBor3a4Tje8Qvn9DIIuGv4s1EtCvIr0FfJBXWNILu1lX7
5xgkkxv7vggnNleQRPGp9X3dG+FK86Id4mdekV9RRK70aiUpTLu+ZktQIwwc
UZys5fuYhDVd7fwyqYq8f3Tq5r6QRljxuo9Z4JYnIH+83+rEq+XEY8E0hQ2L
eKAt0bffxJGxsCGiVUizrpxkvln5M6I/D9T7C4QWeCdDyOXHD8zlKkhbRcv8
wIhG8L7itzvCMAsGRl5Oy19UQcwTTmS7raTx/2ti8C2zfIjZY6Jhva6CjCIa
euIlDTCl6q3vb4cieCEzsPcTwwrybr5f+cBVDZAw9ueCqyvLiPLAmj/VRkVk
7/HZw8ZlN8DQ621KrlOLCV7lpRrLA5c0wqbMp0ZbP+STcInbs3w7iklF5KUF
h542wonVe+e3fs0ivLIEiwGJJURp75m8n8J030XbmTe/TSa2H3MnNdiXEuOo
QPe+Ojx4vDB+neLqWPLwU2eb4fgyMn3sOYM+5jzQTJBOydzyhPQZvVj/RSSd
V9Pcea22FL9pSIVWDQ2BvDPLBk76UUwOvbM2ru3kQcYR28W/82Jhk8ddH6+V
JWRcTTAvPYEHfkM/v/OVTgF3SZNZJpdKyObFJRNsrXiwx1NF5EO/bJj4Us26
PK2EtK/LKLfuzYOH6ha/GgrzYW7vw0V36kuIUD/b/mGu9LtfWPPtUFsRvHWq
nlLYWkJGRvVX1G2h/hP2YtmcplI4V9pPoqSlhFjvlLNZYtwAq+Pzyj1el5G7
Xq93f3mQRwxtB3+YsqoRrhfaXFt9pZhUT+h41H40n+xsMApZW0TjmF/8Rhmd
AoLXm0WpicZLeCAml6VteyGbHAre12jVt5A8cN+uYnaPB4aLLHXTTFLIkDXn
HzS9KiQBh4r9BTQ/3tTvl7egdxxZHTplxgvTIuJb9WBJ/5F8+BjwaWKfYSHk
VPRuHxGhYqIs9bzQRokPHX9mqo+JDIGT9hZpquIFZJEJ/4ViIB/W3Zny6tOh
OMhvdxaqOlRAdKPnLHQ144NAX9xyrU8KTL5xe/aStALSZDkq/KskHxwdNq11
vJcNJhKZwxaIF5J0ufdxY+/S/PLBanK0agEE2A3hD4RCcsJbX3aKHA9K7V3i
hCyKoWz/ksMW2wvJ4KeO9bvO0bxsOGWG+/4ymDPnmPp+m0Lyx3ldpCKNA71n
OA03HVtObi4IE51zI50oG047Oi26EU76bB1sJygmw10hJnV8Jnmzg9gu0+NB
5MtRzwQXCsjj4AG5soFZZMWuMpXRKdQfLEfmfRudQ/B68HpA6L6pfFhiKCoU
npNC+nuoHPZ0zSXV7RtXH3LkwxC5a0cLrseRufaf5ftb5pGQRNHHH57y4Xu1
cxxEhpBs7yG1Nv3zib6cwFwrnQ8HcndvTp8XCvaLN+5pzM8k9bt2TjutLIBv
A9LLLNvioMRy/foLUVlkxqm3lqZN1J4rmpw8mlMgtb7fGC/nbGKvFyCbeY3y
mq2yd44p5cBuPYdr9EoUxv38eIx+L93hg8pHuRdQXjtEUuJFDtk2sI9JXBAP
Xo9q8TLJKIZHe69U503MJTv8bE0GSfKATyYN0K0qA91sw+mT7XLJmaeyq/9Y
NMLbg3s/jd5dTvYmmy2xuxpP7lfVtwSJ8cC077CWfrNKSM6WlF/anQnEY781
z+8Oj+I9K+lR+QVkx3BSec00iehHKd9crsiHP9OtLj7xyCFb3b3U32XQ/e1a
ckTfjw+rxTzd3kxMJXi9fNnX8bCA4jrL1kVHRxEyedslBWHbNPLyZ85WDSUB
VOjImn6eF0rmr5qeHheaTmbXtP1M0xNA1cgoxfQboWA42Vjk0uREUhrdOvuN
rwDO7dGOP7mNwEvxkzEGE5PIr3v75xtsFkDjLV6Ih24qqL6/d19rYDJ5b3y+
aEA/AQQ0u4yZfTEHRIT1N4lWJRMn3/otuZf54G0waD71YxAdMtSY+jXxnfIz
jPnz1hjpYNsRJSB88HPJI+VU0ruowGIwxZkDllzWGaxaDo6+7l+9QlLJvHJF
ZUFuI2wuFpZWuVBOyoLnPK5/FU5ezOTnx2jy4NIxuQqPbSXkg8vH4Mr5EeSl
ttGDzioeLFRqnLaqvYB0hNTsXZMeRQ5uf3hOz4IPG/K/PzxdlEMer09dF2cc
TcK9J6vy3/Fhs85df8HuVOL8Ycha2a+viP0EMbNzCwTg5d1saHyYELxu4I/j
rT5JefeQ3hNrboQSa9tlsxq/vSbBA9akj7gvAMUg3z5/KkJhrPu0hGCb56Ti
3Tl4X0z54Ormpr4BBBaqL/S4fCWSWMs1Le0XIICfvLvGcDQVrlkq7Vt38wXx
KQ45f2ylAG68fp0eWJkD40ctGG/hEk3mxY+b3vmWD7WZG7ZV/iyA4637DFu0
XpHqsYLH1Zv5UDA3wZ/GZXgYvVaFxmmyQn5CI4vPicpyUZ3W5fBD+IeNvhoh
22c6nPYbyYMfMzdN+3G3nJytS3gzwdCZyPjNrDy9hvLuGeYGK6xLyMxNs88/
TvMmpnfPlug0U/548cWnzxKFJEYlTMw26yoZdWb2CjtPPoif0Jjs8juHREp+
O3/7fABRbSoI3ioigA/qv6LXeKaSzEG5S0asDSJnTLMn7LYUgDUvtfP5Y0JO
5NwbsXLMI8IrGZdwNEIAX8dMuyxaGUrwmjalvl39rQBOeoYkvRCEguyfiYol
4EKWOj6veiEQwOGvpnkTYgh0zFbbXzD7Amko/h3hRgTwKQs6Xc6nQr6uwrsk
GX/i7y6kNPqgAPKuW5Z8/pMDgbvqdx+uDCARR8wkB9J5nvbadl9iUCEcW66a
Vv/tHjm6XuiFnysfHu6eoX/eqgQmm+/WqM14QKSjRl3bQ/H/1sNZDE+AonPi
BoovyOuFgzlcMaELZ6zuwh2INyq/imvTcYhBxgE/Og48KA3zZ+NEly+/Rt9L
IlSMdb58uwfj5SpesvfutLifSudJQiaKJdJ5QlKtjBSbp9yosp90XaS8cARb
F+xfcZBbl/Srry+oHUjnQJOphbMvwHhjiGR2kPjsvIjajWw8nTuxDFygv5Vc
NbOb4K99u69o59+yRyQiHhP4VWOhRr8LFPRKiWffpfPg93T6HeGMz50b9DtC
U0fVePYdz5oXadHvDhvrpLLod4dDH9YHse/+U2zoV+onIHP70m/qJxB6+4w+
85Nk5zXG1K/g6S0p3Sdp3vBs5tUi5ler0jcwPwTVB/PbqR/C0foZnB8Ou5ca
Sf2WbJ3h70P9FnoVDeH8FvFHehceGduFQxrXKa+h+4Kc3ubkRPcFaO1wC2H7
4kuzwzO6j4j5ldbVdB/Bx2213D7ScrdfSvcd6XvJ6yrdd2CiKe/N9l3XPiVd
+xRwnxZ15H/vqAgl5zxkU+i+hheuF7l9bZJZMZvGARhzbqYajQNQ+nocFwci
B+9xofGi+/q05XkDixtG3i8DaZwBEAraReMMrHPeYMrijF6G6msal6BiYoc1
jUvgZ3BoJotLvNQDmjSOwb7FG/xpHAOr722nWRzrsImopXEPDM0+VdC4B3rf
W4NY3OuKk9AVJwHjZM3gX2o0rhKb6Byx0yGpkAsbp7K4+t0kMIjGYZJ6Sv4j
jcOww342F4endOEPfhceQRxS+/DLQBrnCV9SbQeN8/Bm/1FjFufFfjndonmB
jFuq9ILmBajruMXlBV6xshfNI+RcdloJzSNwNmQWl0cqzOJY3iHCzgtEad6B
61s/cXnn5UOPRzRPwaXY1lKapyDC/NsPlqe0r8zZQvMa9BlpM53mNSh7zjNm
ee2e8WNvmv+6rxblHg4sD5pFTPKneRPId5mlNG/Cup9Jh1ne7CVdIkvzLAiN
vl9P8ywsMF98neVZl7U3+4jMKgHVo2oDFnYmQED6wS8sLyskx7E8Du+/uxjR
PA5v3qzk8ridnPcfnaoyckmDp0/zPuyKaOXy/tlHQ9wpTiDH+sgLKE6A73P6
cDhBY6RuEcUVJGVL7FiKKyDJLXcbwxVmXfijpguPIA6R1e1vT3ELKZwuNIni
FjD8rcXhltlP88IoziHJrydYUJwDt612czhnzNXyoRQXEasHFkcoLoLtDQUq
DBfdED07aQHFn1OE5n+lOApszz83Yzhq0jWJSxR3gaKIwgyKu2C5+M8HDHdZ
yPsOojgN7D16O1CcBlekt6xiOI0feamE4rnu687TBSEM102IvRFOcSCIrppa
TXEgDN8xmMOBpw1ThlLcCMGTf2RS3Ajxew1tGG5MuzNfluJMSLs1SJbiTLi0
L9eG4cxn4csUKC4leWLCiykuBc3Przlcus2vdwzFsUT7QbkdxbHgccqTw7Gy
Jj/kKe4lTZG9mijuBXLbhcO9lkVJOhQnk1b5yJEUJ8OYnVMIw8liXfjjfBce
QRxySyj2IsXh5Our+EEUh4P01EcLGA6/liMTO5riz8+3Eksobod1NSuiGG6/
MiL+OsX54FMTcoPifGiA0fkM5/+q7PxGeQGEbTPQorwAZp+q1WW8YGyaxVrK
I+Cw9I4QyiPAbPOOa4xH/PHIX0V5B7wa2NBAeQfsq7o8lfGOsRFPjSk/6b6K
kLMJjKdYK9y/TnkNXOK9fUZ5DVhZRD9mvCa8dkYt5UHgcG3SAcqDQCny2FvG
g5avTNKlvIkMMRIfRnkTBBsrcbxp49U5HyjPIubVj+ZSngUTWkonMZ4FbzY0
UV5GvjoPraa8DJ7flOd42cXa8021/bKJiK6hPeVxUNARx/E4w7jAQsr7yIPP
eYz3gSN/rzzjfY+68Ed+Fx5BHLLnZLoO5ZWkqnLGSMor4cq3sM2MV7Z9HFJM
eSgoJlUvpzwUXF2L1BkPtTPNtKe8FZZLv/tNeStIzTJby3irv5jXccpzISf9
2SzKc+HzmMWujOcOs7q0kvJi+D6qzwHKi8G0j0EO48X6IuO2Uh4N82XnqlEe
DS/rLmoxHi2qqDuV8u3ua8jyAxzv5psdXUZ5OizZmC36xqgI2hzkpBhP/6ry
9lT9rlLSX9l78ZCFFbBydlSnyasv4Fwrc4HyfSKRG96H8n3wn+TO8f2+vVfd
uWWWTz59M9S2XlcB0wY0LGX1gUPH962KMMwiexabFuQvqoDDDTeyWD2hxok6
o3cyiSYVYeZyFTBr9J95rP7Qdn9HvcLIWGJWvbyXZl05LK4N4eoVE7vwB+IR
xCEqe+63aPk+hh1Ch1g9BPSLt3L1kK76CXTVTwDrJ9nHjjjOMUiG6dkdIonN
FRB1p/gzq7c8FI64c0IjC4w/qlqJaFdAUFTVIFafeX9rUPxtu3wQfak/frND
OSTamwawes7IV5XpqyKKYPlyqfYn98vAKvVkIKv/rHV9687sJr2jlza1G0mx
qxLaTu1mm9z3Ar0PX3Q1gd3PNRjC2TP3Z7qXVE4pOM34fZLVl9yS83VYfQl/
4//H+ykfyzzZb7wOXhu3kN0fcqCvDxu/bFCWLvte6yX4HWz8hosuHkznY9B0
8BWr+53MsGhldT8H3x1OrB6o9CviBdP/3A7f0M7uo84MdWeoN8Pn8O/wedQD
oT4IdUGoa0GdC+pbUJ+Beg3UaWC/HHUH2DfHvi/2z7H/i31f7ANj/xf7cNjP
xH4c9pOwL4d9JewnYX8J+0rYF8E+CfZHsL6P9X6s82OdGuvWWK9GHR7q8lCP
h7o91PGhfg91VKirQj0V6oFQH4S6INS1oM4F9S2oz0C9Buo0UGeAugPUG2C/
HPvn2DfHvi/2gbH/i/1L7GdiHxP7cNiXw34c9pOwv4R9JeyLYJ8E+yNY38d6
P9b5sU6NdWusV6N+EfWMqGNE/RzWs7Hei7o07MNg/wX1Vai3Qp0V6mlQN4S6
GtS7oP4FdS+o20AdB+o3UH/wXz0CH7CPjn117KdjPxj7w9gXxv4f9jmxD4j9
OezXYZ8O+0w914v9EuyfYN8E6+M97Ya6T9SBov4TdaKoG0W9KOr8sK+F/SzU
q6F+DXVrqGdCHRbqmlA/hHoi1BGhDgZ1MaiHQT0H6jtQ14G6BNQpoD4B++vY
b8c+O/ZfsW+MfVjsd2L/E/ue2LfruV7sP2E/CvtQ2EfBvgr2U1Avi/pZ1M2i
vhb1tqizRd0k6ihRP4n6P9QDog4QdWyoa+vWs3XpsVCfhbos1BWhzgj1RaiP
Qb0M6mRQ54G6D9R7oF4B9QuoW8C+e3cfvqv/jv1j7CdjHxn7oNgXxX4o9vOw
v4d9PexLYZ8K+1OoM8a+H/b7UJeM/SvsW6EOFXWpqEdFPSXqK1FXibpA1Ami
PhD1bah3Q50b6qtQF4M6FtQb/Vd/1P089Hwe9R+oB0EdCOoYUNeAegbsx2N/
Hvvy2FfGPjP2l7E/+g+7QU+7od4a+6jYJ0U9N+q7UdeNul7U+aK+F/WpqFdF
nSrqLFF3iXpL1Aui/gV1g6h7Q50R6t9Qv4V6LtRxoQ4Jn0c9EuppcHzU1aAu
BHUiqA9BfQPqHVDngH167Ntjvx77yj3thn1T7KNi/xTtjH1pfB518NhfRT08
6qRRN416adT7ov4Xdb+oW0UdK+pXUX+JekzUYaKOEHVbqCdEPRzq41AXh7ou
fB71XahPQr0S6pRQZ4O6G9TboF4E9SOoG0HdA+ogUP+Adu5pN+xDo92wH43n
AbDPj/19PD+A/WrsU6PuHHXoqD9H/TTqqVFHjTpg1AWjHhj1rKhvRV1rj7jR
rX9DfeF/9Yb/J250P496L9R/oe4LdUuoY0L9EupvUI+DOhzUkaCuBPUkqIf4
h92gp93wHAWeq8DzFHjuAs9h4PkL1PGjrh/1/KhHR3066tJRV406a9RXoz4Y
9cKoE0adK+peUe+Kek3Ub6JuE3WHqENE/SHq51BPhzo61IGhLgz1YKhnQn0T
6ppQl4M6HdTnoL4E9SaoM0GdBOomUC+B50/wPAqeQ8HzKnh+Bc+t4LkI1AGh
/gf1/aj3R51/D1wHiOtQb436a9Rdo24YdcSoH0b9K+phUQeLOk7UdaKeE/WI
qE9EXWIPXNetr0N9GOrFUCeGOqee60W9Dup3ULeDuhPUoaD+BM/t4DkePL/T
g6d061LwnAnqqlBPhecl8PwEnpvowVMAeQrq11HPjjp21GGjLhv12Kgn/q++
mN+ti0WdLOpjUd+Jek/UefbgKd16RdTbof4OdXeoG+u5XtQ/oR4KdVA9eEq3
3fC8E55/wnNPeD4Kz0vhOSk8t4PnePD8Dp4/wfMoeA4Fz1HguQo8T4HnAfB8
AJ4LQF076txR3476bNRro04bdcaoO0a9MeplUT+LulnUfaIOFPWfqF9EPSPq
GFGHh7o81OOhngz1ZagrQ10U6qRQH4XnxPDcGJ4Xw/NOeP4Jzz3huR08x4Pn
d/D8CZ5HwXMoPepC8I+6EGBdCHXtqHNHfXuPuhD8oy7UrTdGvSzqZ1E3i7pP
1IGi/hP1i6hnRB0j6vBQl4d6PKzHYX0O63LJm0sWfDAqIiEXiyffWllG+k++
dG9MdgMcnOv8uvlBHln4ybHD93UZuSm28u7EVY0wfPpdpw030onxgV/DbceW
k9+NooumRDdCyog4u9tX40njie0+yrvLScEH8dIAMR7Y3KzTmBkbTu40dxpp
Xign2tpVCVGaPCj30h15w8iZvFi5Z8ifu+XEYeXhQE9qtzHuN3ZJqxGodv4W
I2ZTThwL4zsuj+SBVLDNSpOQVJjmFjRSQbWcXLi/TIuX2whvxqpNbTmaC5Md
9lRvqiojH2feSPtt0QjaISM3rrcpBC2H0oIb+8vIhQ1uDZNoPAy6W3QosaUE
NMaJhS9tKiUPe+sZsbo91p2xDo315+zDhy6L2uWTXe96VRtfKSZbs38PX1nU
CJuiS7a0j88kY+2+J3oLionqBef+Ono0D37IKj3ZmUCuuc41k59VQn7W+qZ4
3+GB5+ppqsYaEST6wV7je9tKiFFE5LvWKh6cSom8JJrhTXx1fx80sS4hu9PS
JRc088CkodehY8qpUN3myPMaUUKgrDBCksartOvv+B4TcyHP74WHS0YxMXjb
UiAuyYNd5/or624vhCpjSd2JFsVkyeXsbayPE19XF/mstQQW+sUP9W0rIkOt
pa6wfoSqD5ngb1gBR3ITQyUci0hze/mFQasawPFNcb1+YBYZUuW5V9i3gEw9
P3bLsBQenBcqf1trmkSc7/RS1cgvICqSSbN1FflQNaLX3G/pUaQ6smaITXsB
0R2hUKJtwQc9lfvHF+RcJV4/J0v1liwkhZ+ySmw8+SDZKJJYTPOi6Zr6xDnu
BeSah8nL2CAe3FjZee+jViFEWbgUvFctIL51k6xYv0lh3qnvx+pLYMnS+JTB
Rflkj/sBk3DXRpB5OVvBeF0FDChe1B5llk9uattEDCxpgPx+ES7DM5OJkZ6u
7juPHDJ35oyaRX4Uz5zY/mnj1mjyZNLY28VFOWTT0zMnP7/jg2roz2Y/7wDS
r3PRg1e/c4j/XkebTSICcB3TvFxevBCEOi3LIu5lE6+vA26Mu8sDYZ0NVVFp
JRCkucJRWSSbrN2p+MW2Nw8E9X67YxZVwKrBTa2fDbNIkt6OYveVjbA7YdJR
j6+vSMnd/hfGm6aSiRMzXLwWCKB/0UbL72uDSJiT0J9Tnqlk/IoxojssBTDu
5Gdx/Us0/goq9yRIp5Anb4P7HLHiweeyYMn1chXgktfxycI7maz9+to6KKIR
XGRCO0rHPCKRE9qHtD0mxGf5DI0jEQJIMtKWmFlXDr+jNk/bODKW9Fs+62pU
//+nr1Dooa+4u7FKfdaPYnLWSrpl39AQePVEz+ddJw8UJYfl6IsXkLw5P2SN
IkIgpP3mmImBfCjy2hc5uSCTVO3iD09XD4X8ypgkD2UBeNwJXF86OZGc2fzo
c/T1UIh5fP91la8Ayh2H9x1j+5x8ulTzeWhFKGQfb+t4VyyA1JrffSQXupCb
MkFlUwSUT9XprHsp6NardF9RR6F96vXCjG+vYf12a3ujG6HwauJp25H3BWDi
n9zsGZoOzQrfOwbMC4XX2zNOZekJ4NRoC+kN/fMhso+S5VI6/9ejx23RSeeD
5pVfovzOIoid535hLF1vv7wqRXslPtwN2ZxzL7IMbm+yLpPZ8gRGf5VN+23L
A9Vlx06/m1QFn/2G8N5eeAzQ2rziYEhjt14io4deoqXe6eT3QwXk/uPWNycO
xYHGuRmLXMz40JbQMfhjVBbR/nLQKL41DtQGSK7a1cQHK4/1LlETk0i4fKtm
9FYCgXWt29ZuFsBob/HDq/wiiaNfw66Vtwm4LIgcLhIggOHn7+wKUrtARPYU
XHxKeZb2Vi9wJwK42n7PNN8mDa4PmbNfchSBy2Bsv0BJAOO/DjxduzcPFp9+
c0vtehx4Tp/e3vCUD/sPvP7ha1oEH6Q9ft/uFQdySzrqJEfyYYWG1yz18WUg
tOrmi+BVsaDq11tkgDkPqjT8D6RdrYTOheHLk06/gsjyxF8mQY3desqvPfQM
PyOTQlKds0mvEZNu6TWngOGPJOOMa3zQWa/8+vbAZPI22HTqJN1UmNrnvKZ4
P8qjL+ySkbv1glzI+HW06gjlR4d1nzutFMCyW3Nm147zJ1rOcoe0z1O+4/8z
VeYg9ZPPin3WuebC574ZPMecFDi6/c7Yo458+B37iJf7qhBeFo0PdzJJga1K
271bKa5+ebB0RY59KayesXVMxNtkuHDv8NZBOjy41P6jMLy5ApzfDwmQMEiG
hEexZwa40zzbpR9420M/cLlQbe/SqmRSI96Q1uKbAyMOPjXJu8yH6Bsn1g4/
GU36HnKMWluZA1Yf+/XqTePMvDkS245UBRAZ6wjtR39y4OS4VF1JGmeChzus
2Ni3EKzHzDJediEbZgWHTba6x4OM99HCPxJKQG3JReHkr1ngum6DX4cwD+5H
zXjZuqACTEaWOWzTyIKYfcp+U9Y0Qv+u/rt3j/67hq3bri3wipiZWv5K/FkA
/s/fVdZs5oPEw3idsO/3iHHJoOrWgYUw/eX2KH9XPkwfMljkVEcxdOZ7uKz+
kA8mEkH8w08bYaiy+vjVrB95a/Hxi3b50Hb1nZhUv0boHRsnuSbzASmREJtx
0qoEpnt+cLKgeDsssmXU/ftlYBg457xeRBFsNTYcezm4AbBPiX1L7FfiOQE8
N4DnBbB/if1M7GPivyOA/64A/nsC2I/E/iT2JdVD1g6m86F429CVzofIztQf
z+ZzMCLHks4fokZ8nEjnT37EOJxg89c19B9N10taHn86TNdLDrd6DGTr9T9g
34fahwxsGGVP7UMsXwZ9ZfY5XfwljtoTNo38nUPtSfyOz3/J7NnoffE8tT9k
DFnQSO1PNn87Us3sz+vaJ1N66JBbGmOf0e9LYvqp7Kffl9QKzbvGvu/9HQ6d
3xNKyNI9e5uSvmaRcGefa8wfMh7/Yf5DTB9OXUX9h+ivdZzC/GfmJeVX1N/g
0O2mmdTfSLDLsUXM37YEzzlB/RPm6KgHUP8kh/ZlcP6pPWm8NfVnGJxlGE39
mdzWhO3Mn1E3Y9pDx7sr710e3S/kiqDBl+4XktB32Dm2X7SDv2vT/UU0gleK
0P1Fnk8p3s72V3VbaR3dj8R/9YRAuh/JDpsiH7YfR8gb/jFyzSXleVBD9y/J
Mbg9ju3fD1cU2H4HrcfRe+h+J+vXmaax/b60IXUpjQ9wdFXuThofiOu7l1x8
0H8ZlkvjCYR1tMrQeEKO3rjFxZNrA16/pPEHKow0rtL4Q1qu7uDiD+pUBvTQ
zXbFN9IV3wjGNyHx+9NpPCSNHt4XaTwk/gmT+7N4aLnnymcaP4lWw+lyGj/J
6NDEBhY/zYryjtN4S2KrzE/SeEvUc3U7WLyVWZS2mcZn8uB32wYan4mUuZYD
i8+udjHjg9UugKfBtmM0npNppVlcPO+K/9AV/wnG/4Bp/jdovoBnUZ/70XxB
tBtecfkiLjJTgeYXcB97WIXmFxL77uJKll/qs1/70HwEv4hnFM1HZNDvezos
H6Gu9VEPXeuG5fdYviMF17VjaL4jsWljV7J816CZmEXzI5n/8UA6zY9E+6wb
lx/NXoV18DqLiHz5kzE0n5LoM7ZKLJ+2WOgMoPmXRI6Y1IfmXzLPdeNWln/3
JP3+TPM1uePp/oLma6JZle/O8vXHvqVaNL+T180XLWh+J9Eur7j87mhxr/fg
hS4Qd/joRooTyNuipxxOOPhATJTiCijoGFZGcQVJl+3kcEVchcdGikPA9N1T
hkOIg95lDodsWe2cTHEL1GduzUtTDyXCW5Q43LJ38r4qinPg04qaQEM6z0WH
/4xiOGeXfOIiiotgrl7xaYqLSGCu+3mGi1CPuqKHHrX3VN4girvIw3F/9Cnu
gneLC/0Y7pplv0+mbMwjOOIWPIHiNDh1qnQ+w2lNn472p7iOiMm9aaO4DuYn
R9swXPf00WGGA4mU7tgjFAeCutpgDgdel52SQHEjfF/RJu7umQoxn5X6M9zI
+x7jRXEm2P4c509xJoyxkuZw5rGqtM0Ul5LJ88dI1Blmgbbi4hKGS03zNYop
jiUzaut9KI6FiluzOBxbcV9Mj+Je8km8z2eKe0EtIvE6w70PcmVmXfUOgMH7
auIoTgZFzV7WDCcPH+vXZ9PWaLDraxJBcTXs2FJ8guHqjIFLfSgOB2/RP8so
DofNYePeMBz+SGeBLMXtxDQxRuiFWT7weqdwuN1Ivf4LxflEbEB+LsX50Fb5
msP5SsWSdykvIDXh7SWUF8CQ+q+WjBeYxm19TnkE4QvC0yiPAPthFzkeEVRw
7oB2zlV4HuU2ivIOWFA/oZjxjusSR8woT4HQtp1ylKdAaqRNIeMpi3vF8ymv
gVXC5hqU10CDoHoW4zUZDi0tlAfBp0pxxoMg7cyGzYwHmZwYOZ7yJmKp7B5G
eRPcHtLA8aZ5p0Y9oDyL3DxTNZ7yLGhTXsjxLM9EG0Vddj4k1WcJ5WVg8OI1
x8s+ixpUUx5HNincOEN5HJhPsShkPE6sKGkn5X2kw6CJ8T44P/1gJON9M7a4
LhPL8AbbxFoHyhOhzrF4EOOJ3qeVzSivhPJrf0wprwTF65tqGK9UTNWqozwU
rHjx1pSHwr0pFxIZD5UOOGNFeSvECm1JobwV/pgME2G8deTldTcpz4XagNk1
lOfCwsnbhzGe23Qq15LyZVI57k8U5ctwUwQ4vpxT6Luc8muSPznyDeXXUNQ8
iuPXH6NvSVE+TlyudtZTPg5NM5JTGR+/rztNlfJ30t6orUD5O/Q1GKXJ+Huv
Lc1LKN8nZSLLX1G+DzNmTP7D+P65ewmzbxg5w/kWU1YfADd/W64+0FVPgK56
AmA9YbBNufvtq/FQJxrB6g9gVXawhNUfXId2XtpwIx3ezI+UtR1bDss0H2qz
ekUN+ZTR/CAPvp2p7nfxdRn8OvLyFqtvCF1N0v9gVAQiCRtm3VpZBvVTTwSw
esiVJ0NnO6UUkQojJ2NfKCPNS+aePR/TAMdzRuXN8ssnYoZxn52D6H2f+tuv
pjfC0sp+kuO9ssgG1bbgU3/KyKUts6c3XmyEvreX93MLTCZzE2Qeey4qJ8EC
g5WxHxuh9EvR68PSsaS6qPxslF05qRqrs1+O+nnjQP6JanhCLL9o1d6h8eat
zssBjjTONK+VE7OZGAuPBvupzLUvJy59RYyzZXmwSzFntuyjZJBXPXzTbHE5
Oeiu4a1Jx0+V6m070zsLlK+/H/2qs4x0nr91dQmdz/3WCTl11/IhnbfGuy/F
Rwnp5xzapzXC/H3z95WnFUFfizfSxtpl5Ey60/3o6AaYYO/DW/Qtn8ydVPf1
+ulikhxbWVKd2AhZq/UK58tmE91hVplaVcXEy4FYLlDhwT3Ro98rKY9tjR87
w1SmhFhEurhNd+VB9pTYO4eiYskb5XO/1q4oIZ13qo9aJPJgoXJusum7J2Sx
yLLfgRYlpClwbt7ELzxQu3/Q/518CsS8EO3rPK6ElNcoXJl/kgdyIyrPqCll
w7l5hr2m1BQT/YaAWuGpPMicM3WcQks+2E3NO7nwfDEpWe+43DKhEd4fWLU2
akYxqE1TKUmbUUwuDzTIGrS4ERo3eioZaJdBXsVSmQ9pReTP9qhCtl712Mrm
acHZxHNb+qeHXgWkfoxBknsU9bekxHn+J1KIYKlE1sWkAiKwjv24YDAfaoV+
3Y5dHEfei72bqS4oIDfEn/2QMuLDlBAyc4R1CMnfLVqxUrSQ6LdcCRQ9zoe3
Wl/u2kdkA7kQkJZ5voAYhstYlUTwwOLGJAULvQKotGlLc9IrIIdUHwntpN+9
36mCMJXzdH/ypE3mteQT9wfhYWxdDrmr49qCy2Cous/R5mv5JG2HiIB9x1Ol
bpO2VqUQp9gZHVeO55B9sl5lB87wQfz6h02iiXHE0u/W5eWpOSSxMMnJvoAP
BsdFpc40hRD9tN4bX3/PIVsXh82w7qD4cGLBptjzBcA/qL3jakQ2OSqvlMDm
GX157y3pmmKYnlNvtE0pm1hmTH3Ql9rfs1T++tPOMjjVMZO/0juLWFWLrltK
/W1j8syn0yZTHKOz6fe47ankg3nLwnlzBbDffuZpr43s/FSKy3PXVNIqXu/z
cZcAFirdc7YdVwLxOh6y7fIp5HGukbEG/e6J87bZbV1cDqolgQZzHyUTYcn8
fVrUz5WutsUp3Q8l8wZqSqY9IKR14cygFWECIK/PiM6yLwfxWzsfeE+MJe1l
B8VyZP9dD1n5zHRHNvW/nYqB4Q7tT+C6w2+FvtQPq/w+jHem3+9GXa5TlGcI
HLIlaxuO8WFuW1bCnB85pHjSqavtfUJhkbTxto3MbuOFGha4pZI0C6lR8mah
EDBZzyyfrkvTx/OE5CNCnKZ4DDj0NBTSEzwWLKDzlPtyov13dSgJ8dO+HVEd
Cs4tE4xV3/6/cyU96yH3n8QFBT0gcPC+yeVPwaHQ3z/rwEo6zh0hJ94111TI
9g/aO3pjKOgcODnrM30v8QgSu/c9B2TPtasMbAoBofTYXbZ0ng0NcYN0RAuh
9o59561DIdA4p/LbAOqfRadqI65blMCcEYV6Yu+ewJ0v1i8VqR3EL1ik3aR2
y7dpUHgIT8BhTrb8sUW8f9ZD7j4Yb/TkawHZYqgeXLklDoKDzfc7GVK+7H96
+ZOMHBK6JGZg/+I4CLBY5vc7nw+ZkW5G33alkqlZH34cnEPAtt3YrlSN4uG3
cvIZxwlJkcveZHmcgI6gU0LipACqpIfNq3saSk5v3Tm35CGBtVfXPmP2HNG+
+YHI9lRYnLwiqV2RQFP889ka1N+WLWq3mZKaAy9U9ynGJMRB9gKd8mPU/wfv
/f1GUVAABelJr/YujgOFlh+pw+j+dQ0f27x4RQk49d9zeFpULIQ470u2ovHq
q7PQ0TC7clC/VKO9WjoWNFc9Np4g9//Od/Ssh+hdEN48zj2H9FGYYyJTnwKe
ve1iV53mQ69m6cR901PJ2ZQ1b+ZPT4XZdmcDffl8+Llmt0XFHELUvlwKIbtS
Yevxujll1A63Ft+6HWIWSsSfq5eMc0uFOjld8wL6fX10JTWcj+fAs+Gv23Sq
UkBqyI6z1nS/GxprVbslFUDoq97CR06kgHtKRYMujVe3bZQHbJIpgVnRY7Oi
Kc60V5u4UZXG512nnyw8uagcKrI/1x8ITAY3o+lBhO4vs3/UQ+b8GlStVZ9C
lg6zNew8lQO3dJ8rrabr2vbqgMeO4jjS12HGrpMZOdB+ZmxWB/2+ViZTnjkL
h5KBCUGHpH/kAH+FX9wm6ocjdjypDvAqAIdbVmtGB9O4vjHxsBeNt8MLlo2f
XVUMnwJI9njZbOCZumbq0PxyvkVqwIk/ZZQPFQyT8sqCjlsX7fg0zoj1qIdc
6OJ3zi2Lq6WM48gx76QTAV8LYFP1933O1A/rjQKvyXqFELv5mz7a0H2w6dGN
h410X7dcCjx35XQxTHj60hm+5cMv8ePlNTTf5XbYZTsGlUGfO0P7q/jlw5Dj
B6ziaN7vVfD4VWT7E6Jyf4d7Kt03u9bc69OP7pflb9er+kAZqM8bZO+YUgSK
LuKe3hQ/1C07qUTvE+1N7/bT+yT1+Psz7P4A21DpKBp31sbPPkbHIXZjZvRl
42hPmp5E30tIZl3HVIo7zl0adJC9V998+xk6T1JXEGZH50lgfp9KNs8DUzSH
y3mFQEfjrFK6LuKivf4xW9ezylDhwcZxIBt53ZragezLOH2A2UHwj7qEu7Vd
L2pn8unGKCFqZ9Lrdv9jzM4dDrxx9LsQo2ezYul3IXLCf7LYd8nNX8u+I9lt
4qZDvyMpcgk9wr7jCLkUyRPCofBwx5at9LuT0++OE/bd5w+9HUr9BNS2/llB
/YTy9A+cn/yWy/5A/QrKT5jrUb8iX1pElJlfvf1HXeKr5DkN6rdk45QJJdRv
idwX6/vMb2euvN+H+jmZ224UQ/2caD1cv5n5+U/1bWV0X5AnNl9+Hqb5XEl+
MY/tizVecmp0H5HhMcI8uo9Iur7eObaP0qtkXtN9Bytl47LoviNCyy9z+07v
8cNLdJ/Cq7sbrtJ9SqqGzVNj+7TB4nkO3ddQHxZRQPc1cXL6u6/tUqVMaRyA
qhOHN9A4QB4vUuDigHePugT6baOyKosz5LJH/TQaZ4hrch0XZ/rXXmikcYnk
12w2mMbwlHZSKotLUVeO5dM4RpL9LK7SOEama9/IYHEsIyxnG417RM/y2AAa
98iRYaKVLO7Vrva8TuMkWbVH8yGNk8TIJnIOi5ONU6v1aFwFD50DqjSukrvX
/sbVi9FuOjQOg1bo3vk0DhOVD3/j8B7deAsat+HbpYB0GrfJrb3iXNy28SQ7
aJyHJ6O9PonQeDDL0PUKi/NXXJbtpHkBai1znWheICtf5VuxvPCvusQ5uwMs
7xCFMTljad4hfJFCLu+82zXpMc1TxHf+vSZRih+fVt6MYXnKt79wb5rXiLuO
sgfNaySideVPltdULmr9DKT4ZsWpxkpxineuppuasjyoMWTLe5o3yaxpx2bT
vEkMhECV5U2+Zv1NmmdJuqrzKZpnybekdi7PClcaj+6geXpOzE5nmq+JQtvf
fP3i7TE3mt9BJvpl+0Galx515ffcHMcfFA/Au/wLvybQ+D23qdmU4YGdMSNK
KX6ATLv6+RQ/kHOOh7cy/JBVIzaD4g3oVFcTpniD6FT3XcPwxnUVX0uKT0Do
y911FJ8Q4fgD8gyf/Ksucd1Th+EfEmHikEDxD1zZI8Phn6VLinMoXoL+0lLS
FC/BuAl9OLwkLSR8kOIrGj/7W1B8BTHz/PYzfFUceO44xWMkrFZoGsVj8BnE
OTzm+HV9PMVvsO1K/VmK30DHYSqH314+WpRB8R5MlZgqKkvz8IGHP7UZ3ost
9j9P8SFZ6icktorykgVCA9YzfHhXxtef4kmykXfXjOJJePoi4z7DkxN+fFoX
y/Dx8qoDFH+CheKbeIY/B12W2UXxKsgF7d1H8SqcmtZ/OsOr99WKj1B8C4pl
WY8ovgWNb3+OMXxbk7VAleJh+KIn29uP5smN/DulDA+Pn2YXTvEzaQrVd6P4
GSLOBHD4OaptZAjF26Rh0zxTirdh6NADHN72vuwmS/E5kZ7gn03xOezT/ovP
k9NXXaJ4nogcP5NF8Tw8C7Pg8HzWFomHFP+DmmvSJ4r/IWaS/B2G/3201iZR
vgBvSrctoHwBnqWKfWN8YZpY5VLKL2DTE14e5RewXGvtB8Yv5ixPEp5O86Lo
1wmfKR+BOp5pIuMj3z4tl6P8hSwU1E2i/AV+PGvm+EuvOkN9ynfIxUGTqynf
Af3fazm+w/siNpLyIzIp1tOd8iPwr47j+NGO4bIOlE+RU+en9qV8CkpqhD8w
PpV6tPUM5V/kqI6sCOVfcNFmP8e/LA3bZMwoLgw+2bffPeqPUUUDcxhf06xL
Tab8DqQOjBQ2oLhpWaf7YcbvLu5fIFxFccbZvnfnUj4IMgvWnGR8cOvV4lrK
H2FH/8xsyh9BInrRXsYfRfZe/UH5JozJVPpO+SacsF1XzPhmqa3/TspPSaDt
qAmUn0L7qQUcPz0hbhFP+Sy5lKV4nfJZCA/7Yc++Y7LI7I2U/xL3uXsVKf8F
vSM3/Rj/rRxvOY7yZfLlY14Q5csww8z2POPLO/xFm6wpTwja8o7xa5h3cDPH
rxV3iXtSPg7VQ9UZH4cjVs84Pm7WL7OA8ndY1T+I8XcYGdqP4++FGVKjKN+H
cF3NcMr3wWeN5HLG9y+/ilUYT/GKhKpP2CmKX765xCuz+oCL2eKKWRRPGKaK
NDlTfBHop3/j/xtoPOFivaN9PbDdMPVpcNpkYDtiql9SJ2j8AQAyE1ZI
    "]],
  Boxed->False,
  Method->{"RotationControl" -> "Globe"},
  PlotRange->{{-1, 1}, {-1, 1}, {0.5000001428571327, 1.}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{{3.405504384115466*^9, 3.405504393613583*^9}, 
   3.405586103469387*^9, {3.405607261516462*^9, 3.405607316335504*^9}},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Open  ]],

Cell["\<\
Das Folgende funktioniert nur in Mathematica Version <= 5.2
In Version 5.2: Plot3D, ListPlot3D returns SurfaceGraphics
In Version 6.0: Plot3D and ParametricPlot3D returns \
Graphics3D[GraphicsComplexe[DATA]\
\>", "Text",
 CellChangeTimes->{{3.405591238055143*^9, 3.405591341559328*^9}, {
  3.405597195816804*^9, 3.405597198957445*^9}}],

Cell[BoxData[
 RowBox[{"WriteLiveForm", "[", 
  RowBox[{"\"\<demo-2a.m\>\"", ",", "P2a"}], "]"}]], "Input",
 CellChangeTimes->{{3.405607243850231*^9, 3.405607247220439*^9}, {
  3.405607295426223*^9, 3.405607312519342*^9}}],

Cell["\<\
Wir koennen Normal[ ..] verwenden um GraphicsComplex in normale Graphics3D \
Primitive umzuwandeln, allerdings entfernt dies auch die Faerbung der \
Flaechen.\
\>", "Text",
 CellChangeTimes->{{3.405591345030725*^9, 3.405591386021255*^9}, {
  3.405597218713853*^9, 3.405597234981492*^9}}],

Cell[BoxData[
 RowBox[{"WriteLiveForm", "[", 
  RowBox[{"\"\<demo-2b.m\>\"", ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"Normal", "[", 
     RowBox[{"P2a", "[", 
      RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.405607322871144*^9, 3.405607333567566*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Die parametrisierte  Graphik", "Subsubsection",
 CellChangeTimes->{{3.405594776044902*^9, 3.405594811845097*^9}}],

Cell["\<\
Nun die eigentliche Graphic bestehend aus der beweglichen Ordinate G0,
sowie den Plot3D P der Grundflaeche, der Flaeche, sowie der Tangentialebene
und die Kombination G all dieser.\
\>", "Text",
 CellChangeTimes->{{3.405591470966049*^9, 3.405591561900945*^9}}],

Cell[BoxData[{
 RowBox[{"Remove", "[", 
  RowBox[{"G0", ",", "P", ",", "G"}], "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"G0", "[", 
   RowBox[{"u_", ",", "v_"}], "]"}], ":=", 
  RowBox[{"{", "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "Diee", " ", "Verbindunsggerade", " ", "zwischen", " ", "Parameterpunkt", 
     " ", "und", " ", "Beruehrpunkt"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{"Red", ",", 
    RowBox[{"PointSize", "[", "0.02", "]"}], ",", 
    RowBox[{"Point", "[", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", 
       RowBox[{"z0", "-", "\[Epsilon]"}]}], "}"}], "]"}], ",", 
    RowBox[{"Point", "[", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", 
       RowBox[{"z0", "+", "\[Epsilon]"}]}], "}"}], "]"}], ",", 
    RowBox[{"Point", "[", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", 
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"u", ",", "v"}], "]"}], "+", "\[Epsilon]"}]}], "}"}], "]"}], 
    ",", 
    RowBox[{"Point", "[", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", 
       RowBox[{
        RowBox[{"f", "[", 
         RowBox[{"u", ",", "v"}], "]"}], "-", "\[Epsilon]"}]}], "}"}], "]"}], 
    ",", "\[IndentingNewLine]", 
    RowBox[{"Point", "[", 
     RowBox[{"{", 
      RowBox[{"u", ",", "v", ",", 
       RowBox[{"f", "[", 
        RowBox[{"u", ",", "v"}], "]"}]}], "}"}], "]"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"Line", "[", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"u", ",", "v", ",", "z0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", "v", ",", 
         RowBox[{"f", "[", 
          RowBox[{"u", ",", "v"}], "]"}]}], "}"}]}], "}"}], "]"}], ",", 
    "\[IndentingNewLine]", "Black"}], "}"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"P", "[", 
    RowBox[{"u_", ",", "v_"}], "]"}], ":=", 
   RowBox[{"Plot3D", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"-", "1"}], ",", 
       RowBox[{"f", "[", 
        RowBox[{"x", ",", "y"}], "]"}], ",", 
       RowBox[{"t", "[", 
        RowBox[{"x", ",", "y", ",", "u", ",", "v"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "x0", ",", "x1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"y", ",", "y0", ",", "y1"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"G2", "[", 
   RowBox[{"u_", ",", "v_"}], "]"}], ":=", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{"{", " ", 
    RowBox[{
     RowBox[{"G0", "[", 
      RowBox[{"u", ",", "v"}], "]"}], " ", ",", 
     RowBox[{
      RowBox[{"P", "[", 
       RowBox[{"u", ",", "v"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], " ", "}"}], " ", "]"}]}]}], "Input",
 CellChangeTimes->{{3.405498604890969*^9, 3.405498695972356*^9}, {
   3.405498792719001*^9, 3.405498793034434*^9}, {3.405499099930385*^9, 
   3.405499100284575*^9}, {3.4054991569661*^9, 3.405499181183708*^9}, {
   3.405499347350066*^9, 3.405499366074372*^9}, {3.405499401479907*^9, 
   3.405499406244736*^9}, {3.405499471731608*^9, 3.405499695242928*^9}, {
   3.405504319885591*^9, 3.405504356842648*^9}, {3.405585712237414*^9, 
   3.405585748505256*^9}, {3.405585865358099*^9, 3.405585868566701*^9}, {
   3.405585904071293*^9, 3.405585912238046*^9}, {3.405586148680282*^9, 
   3.405586149531366*^9}, {3.405587300584662*^9, 3.405587324867649*^9}, {
   3.40558747003935*^9, 3.405587511741425*^9}, {3.405587691318201*^9, 
   3.405587714973404*^9}, {3.405587750519192*^9, 3.405587801518317*^9}, {
   3.405587978153915*^9, 3.405587980415197*^9}, {3.405588044325273*^9, 
   3.405588066502329*^9}, {3.405588134260949*^9, 3.405588151592734*^9}, 
   3.405588220062084*^9, {3.405588375808926*^9, 3.405588383202198*^9}, 
   3.40558865778686*^9, {3.405588769028122*^9, 3.405588815950141*^9}, {
   3.405588849630192*^9, 3.405588879166252*^9}, {3.405589292154283*^9, 
   3.405589345113762*^9}, {3.405589477838886*^9, 3.405589478816287*^9}, {
   3.40558953235553*^9, 3.405589549045243*^9}, {3.405590915676161*^9, 
   3.405590939475057*^9}, {3.405597285616755*^9, 3.40559732684603*^9}, 
   3.405607370835218*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"G2", "[", 
   RowBox[{"0.5", ",", "0.5"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.405498699638825*^9, 3.405498708781096*^9}, 
   3.405607371981294*^9}],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[1, 0, 0], PointSize[0.02], Point3DBox[{0.5, 0.5, -1.03}], 
    Point3DBox[{0.5, 0.5, -0.97}], Point3DBox[{0.5, 0.5, 0.905}], 
    Point3DBox[{0.5, 0.5, 0.845}], Point3DBox[{0.5, 0.5, 0.875}], 
    Line3DBox[{{0.5, 0.5, -1}, {0.5, 0.5, 0.875}}], 
    {GrayLevel[0]}}, GraphicsComplex3DBox[CompressedData["
1:eJx1fW3QZmlR3msSk5SmSiGkLK1KojKi+IEoYgp/eKtI2PEDjWAqYomURgrN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    "], {{
      {Opacity[0.8], EdgeForm[None], 
       GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxFmQX4FVUaxg/3jDDEgISkICCtqISUSLcS0iBSUkqXoNIYq64da6yNid2x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          "]], 
         Polygon3DBox[CompressedData["
1:eJwtmgW0HFUWRRvqwX9JJ0CwEAgaJLi7Q3ALCa6BIMHd3YfBBxl8cHd3d3d3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          "]], Polygon3DBox[CompressedData["
1:eJwt13WgFlUaB+APLt2NlIAupfRKiKQoXdIgId0hUpKuCqgIrgGiiEmHoHQo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          "]]}]}, 
      {Opacity[0.8], EdgeForm[None], 
       GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmXf8jlUfx++b61Lfn999FU2losxkb6mEjAaZLQ20n/aup/lURiENLSUi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          "]], 
         Polygon3DBox[CompressedData["
1:eJwtmnW8HdXVhu8Jsw+cydyLhuCaEBKIECAhWLDgGhJcitf7tZRCoVRwd4fi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          "]], 
         Polygon3DBox[CompressedData["
1:eJwt13m4TVUbAPCDey73uOciQuYprnnMlLmiZC6RzKHRUN+n0lepvqiENKG5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          "]]}]}, 
      {Opacity[0.8], EdgeForm[None], 
       GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmWXAFkUbhV8f9VndfZ21u7C7u7sTg06lpRvp7u7uBgWkG6RDBQGLMACx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          "]], Polygon3DBox[CompressedData["
1:eJwtmnXgF1UWxX+OMA/njd+fua7dubZrB3Z3gYooSAkC0iFINwrS3dIqAkpL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          "]], Polygon3DBox[CompressedData["
1:eJwt12eUVdUVAOCnCTzhPQdIgoqxQCKILmsilkQRC01FigJipEgvwlAEZghd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          "]]}]}, {}, {}, {}}, {
      {GrayLevel[0], 
       Line3DBox[{246, 1, 242, 227, 2037, 16, 2051, 31, 2066, 46, 2081, 61, 
        2096, 76, 2111, 91, 2126, 106, 2141, 121, 2156, 136, 2171, 151, 2186, 
        166, 2201, 181, 2216, 196, 2338, 231, 248, 211, 244, 236, 943, 212, 
        944, 213, 945, 214, 946, 215, 947, 216, 948, 217, 949, 218, 950, 219, 
        951, 220, 952, 221, 953, 222, 954, 223, 955, 224, 1156, 233, 249, 225,
         245, 237, 2243, 210, 2229, 195, 2214, 180, 2199, 165, 2184, 150, 
        2169, 135, 2154, 120, 2139, 105, 2124, 90, 2109, 75, 2094, 60, 2079, 
        45, 2064, 30, 2336, 229, 247, 15, 243, 235, 773, 14, 771, 13, 769, 12,
         767, 11, 765, 10, 763, 9, 761, 8, 759, 7, 757, 6, 755, 5, 753, 4, 
        751, 3, 749, 2, 1157, 234, 246}]}, 
      {GrayLevel[0], 
       Line3DBox[{495, 250, 491, 476, 2341, 265, 2355, 280, 2370, 295, 2385, 
        310, 2400, 325, 2415, 340, 2430, 355, 2446, 2447, 370, 2475, 385, 
        2490, 400, 2505, 415, 2520, 430, 2535, 445, 2658, 480, 497, 460, 493, 
        485, 1367, 461, 1368, 462, 1369, 463, 1370, 464, 1371, 465, 1372, 466,
         1373, 467, 1374, 1375, 468, 1376, 469, 1377, 470, 1378, 471, 1379, 
        472, 1380, 473, 1595, 482, 498, 474, 494, 486, 2562, 459, 2548, 444, 
        2533, 429, 2518, 414, 2503, 399, 2488, 384, 2473, 2472, 369, 2443, 
        354, 2428, 339, 2413, 324, 2398, 309, 2383, 294, 2368, 279, 2655, 478,
         496, 264, 492, 484, 1185, 263, 1183, 262, 1181, 261, 1179, 260, 1177,
         259, 1175, 258, 1172, 1171, 257, 1169, 256, 1167, 255, 1165, 254, 
        1163, 253, 1161, 252, 1159, 251, 1596, 483, 495}]}, 
      {GrayLevel[0], 
       Line3DBox[{744, 499, 740, 725, 2661, 514, 2675, 529, 2690, 544, 2705, 
        559, 2720, 574, 2735, 589, 2750, 604, 2766, 2767, 619, 2795, 634, 
        2810, 649, 2825, 664, 2840, 679, 2855, 694, 2978, 729, 746, 709, 742, 
        734, 1806, 710, 1807, 711, 1808, 712, 1809, 713, 1810, 714, 1811, 715,
         1812, 716, 1813, 1814, 717, 1815, 718, 1816, 719, 1817, 720, 1818, 
        721, 1819, 722, 2034, 731, 747, 723, 743, 735, 2882, 708, 2868, 693, 
        2853, 678, 2838, 663, 2823, 648, 2808, 633, 2793, 2792, 618, 2763, 
        603, 2748, 588, 2733, 573, 2718, 558, 2703, 543, 2688, 528, 2975, 727,
         745, 513, 741, 733, 1624, 512, 1622, 511, 1620, 510, 1618, 509, 1616,
         508, 1614, 507, 1611, 1610, 506, 1608, 505, 1606, 504, 1604, 503, 
        1602, 502, 1600, 501, 1598, 500, 2035, 732, 744}]}, {
       Line3DBox[{2037, 2335, 956, 2036, 3280, 2244, 2038, 3281, 2245, 2039, 
        3282, 2246, 2040, 3283, 2247, 2041, 3284, 2248, 2042, 3285, 2249, 
        2043, 2980, 3370, 2044, 3286, 2250, 2045, 3287, 2251, 2046, 3288, 
        2252, 2047, 3289, 2253, 2048, 3290, 2254, 2049, 1152, 2255, 2336}], 
       Line3DBox[{2051, 2981, 3371, 2050, 970, 2052, 3291, 2256, 2053, 3292, 
        2257, 2054, 3293, 2258, 2055, 3294, 2259, 2056, 3295, 2260, 2057, 
        2982, 3372, 2058, 2983, 3373, 2059, 3296, 2261, 2060, 3297, 2262, 
        2061, 3298, 2263, 2062, 3299, 2264, 2063, 3300, 2265, 2064}], 
       Line3DBox[{2066, 2984, 3374, 2065, 2985, 3375, 2067, 985, 2068, 3301, 
        2266, 2069, 3302, 2267, 2070, 3303, 2268, 2071, 3304, 2269, 2072, 
        2986, 3376, 2073, 2987, 3377, 2074, 2988, 3378, 2075, 3305, 2270, 
        2076, 3306, 2271, 2077, 3307, 2272, 2078, 3308, 2273, 2079}], 
       Line3DBox[{2081, 2989, 3379, 2080, 2990, 3380, 2082, 2991, 3381, 2083, 
        1000, 2084, 3309, 2274, 2085, 3310, 2275, 2086, 3311, 2276, 2087, 
        2992, 3382, 2088, 2993, 3383, 2089, 2994, 3384, 2090, 2995, 3385, 
        2091, 3312, 2277, 2092, 3313, 2278, 2093, 3314, 2279, 2094}], 
       Line3DBox[{2096, 2996, 3386, 2095, 2997, 3387, 2097, 2998, 3388, 2098, 
        2999, 3389, 2099, 1015, 2100, 3315, 2280, 2101, 3316, 2281, 2102, 
        3000, 3390, 2103, 3001, 3391, 2104, 3002, 3392, 2105, 3003, 3393, 
        2106, 3004, 3394, 2107, 3317, 2282, 2108, 3318, 2283, 2109}], 
       Line3DBox[{2111, 3005, 3395, 2110, 3006, 3396, 2112, 3007, 3397, 2113, 
        3008, 3398, 2114, 3009, 3399, 2115, 1030, 2116, 3319, 2284, 2117, 
        3010, 3400, 2118, 3011, 3401, 2119, 3012, 3402, 2120, 3013, 3403, 
        2121, 3014, 3404, 2122, 3015, 3405, 2123, 3320, 2285, 2124}], 
       Line3DBox[{106, 845, 107, 846, 108, 847, 109, 848, 110, 849, 111, 850, 
        112, 851, 113, 852, 114, 853, 115, 854, 116, 855, 117, 856, 118, 857, 
        119, 858, 120}], 
       Line3DBox[{2126, 3016, 3406, 2125, 3017, 3407, 2127, 3018, 3408, 2128, 
        3019, 3409, 2129, 3020, 3410, 2130, 3021, 3411, 2131, 1045, 2132, 
        3022, 3412, 2133, 3023, 3413, 2134, 3024, 3414, 2135, 3025, 3415, 
        2136, 3026, 3416, 2137, 3027, 3417, 2138, 3028, 3418, 2139}], 
       Line3DBox[{2141, 3321, 2286, 2140, 3322, 2287, 2142, 3323, 2288, 2143, 
        3324, 2289, 2144, 3325, 2290, 2145, 3326, 2291, 2146, 3327, 2292, 
        2147, 1060, 2148, 3328, 2293, 2149, 3329, 2294, 2150, 3330, 2295, 
        2151, 3331, 2296, 2152, 3332, 2297, 2153, 3333, 2298, 2154}], 
       Line3DBox[{2156, 3029, 3419, 2155, 3334, 2299, 2157, 3335, 2300, 2158, 
        3336, 2301, 2159, 3337, 2302, 2160, 3338, 2303, 2161, 3339, 2304, 
        2162, 3030, 3420, 2163, 1075, 2164, 3340, 2305, 2165, 3341, 2306, 
        2166, 3342, 2307, 2167, 3343, 2308, 2168, 3344, 2309, 2169}], 
       Line3DBox[{2171, 3031, 3421, 2170, 3032, 3422, 2172, 3345, 2310, 2173, 
        3346, 2311, 2174, 3347, 2312, 2175, 3348, 2313, 2176, 3349, 2314, 
        2177, 3033, 3423, 2178, 3034, 3424, 2179, 1090, 2180, 3350, 2315, 
        2181, 3351, 2316, 2182, 3352, 2317, 2183, 3353, 2318, 2184}], 
       Line3DBox[{2186, 3035, 3425, 2185, 3036, 3426, 2187, 3037, 3427, 2188, 
        3354, 2319, 2189, 3355, 2320, 2190, 3356, 2321, 2191, 3357, 2322, 
        2192, 3038, 3428, 2193, 3039, 3429, 2194, 3040, 3430, 2195, 1105, 
        2196, 3358, 2323, 2197, 3359, 2324, 2198, 3360, 2325, 2199}], 
       Line3DBox[{2201, 3041, 3431, 2200, 3042, 3432, 2202, 3043, 3433, 2203, 
        3044, 3434, 2204, 3361, 2326, 2205, 3362, 2327, 2206, 3363, 2328, 
        2207, 3045, 3435, 2208, 3046, 3436, 2209, 3047, 3437, 2210, 3048, 
        3438, 2211, 1120, 2212, 3364, 2329, 2213, 3365, 2330, 2214}], 
       Line3DBox[{2216, 3049, 3439, 2215, 3050, 3440, 2217, 3051, 3441, 2218, 
        3052, 3442, 2219, 3053, 3443, 2220, 3366, 2331, 2221, 3367, 2332, 
        2222, 3054, 3444, 2223, 3055, 3445, 2224, 3056, 3446, 2225, 3057, 
        3447, 2226, 3058, 3448, 2227, 1135, 2228, 3368, 2333, 2229}], 
       Line3DBox[{2243, 2339, 1154, 2242, 3459, 3069, 2241, 3458, 3068, 2240, 
        3457, 3067, 2239, 3456, 3066, 2238, 3455, 3065, 2237, 3454, 3064, 
        2236, 2334, 3369, 2235, 3453, 3063, 2234, 3452, 3062, 2233, 3451, 
        3061, 2232, 3450, 3060, 2231, 3449, 3059, 2230, 1153, 2337, 2338}], 
       Line3DBox[{2341, 2654, 1381, 2340, 3565, 2563, 2342, 3566, 2564, 2343, 
        3567, 2565, 2344, 3568, 2566, 2345, 3569, 2567, 2346, 3570, 2568, 
        2347, 3571, 3070, 3460, 2348, 3572, 2569, 2349, 3573, 2570, 2350, 
        3574, 2571, 2351, 3575, 2572, 2352, 3576, 2573, 2353, 3174, 3670, 
        2574, 2655}], 
       Line3DBox[{2355, 3071, 3461, 2354, 1396, 2356, 3577, 2575, 2357, 3578, 
        2576, 2358, 3579, 2577, 2359, 3580, 2578, 2360, 3581, 2579, 2361, 
        3582, 3072, 3462, 2362, 3073, 3463, 2363, 3583, 2580, 2364, 3584, 
        2581, 2365, 3585, 2582, 2366, 3586, 2583, 2367, 3587, 2584, 2368}], 
       Line3DBox[{2370, 3074, 3464, 2369, 3075, 3465, 2371, 1412, 2372, 3588, 
        2585, 2373, 3589, 2586, 2374, 3590, 2587, 2375, 3591, 2588, 2376, 
        3592, 3076, 3466, 2377, 3077, 3467, 2378, 3078, 3468, 2379, 3593, 
        2589, 2380, 3594, 2590, 2381, 3595, 2591, 2382, 3596, 2592, 2383}], 
       Line3DBox[{2385, 3079, 3469, 2384, 3080, 3470, 2386, 3081, 3471, 2387, 
        1428, 2388, 3597, 2593, 2389, 3598, 2594, 2390, 3599, 2595, 2391, 
        3600, 3082, 3472, 2392, 3083, 3473, 2393, 3084, 3474, 2394, 3085, 
        3475, 2395, 3601, 2596, 2396, 3602, 2597, 2397, 3603, 2598, 2398}], 
       Line3DBox[{2400, 3086, 3476, 2399, 3087, 3477, 2401, 3088, 3478, 2402, 
        3089, 3479, 2403, 1444, 2404, 3604, 2599, 2405, 3605, 2600, 2406, 
        3606, 3090, 3480, 2407, 3091, 3481, 2408, 3092, 3482, 2409, 3093, 
        3483, 2410, 3094, 3484, 2411, 3607, 2601, 2412, 3608, 2602, 2413}], 
       Line3DBox[{2415, 3095, 3485, 2414, 3096, 3486, 2416, 3097, 3487, 2417, 
        3098, 3488, 2418, 3099, 3489, 2419, 1460, 2420, 3609, 2603, 2421, 
        3610, 3100, 3490, 2422, 3101, 3491, 2423, 3102, 3492, 2424, 3103, 
        3493, 2425, 3104, 3494, 2426, 3105, 3495, 2427, 3611, 2604, 2428}], 
       Line3DBox[{2430, 3106, 3496, 2429, 3107, 3497, 2431, 3108, 3498, 2432, 
        3109, 3499, 2433, 3110, 3500, 2434, 3111, 3501, 2435, 1476, 2436, 
        3612, 3112, 3502, 2437, 3113, 3503, 2438, 3114, 3504, 2439, 3115, 
        3505, 2440, 3116, 3506, 2441, 3117, 3507, 2442, 3118, 3508, 2443}], 
       Line3DBox[{2447, 3613, 2605, 2445, 3614, 2606, 2449, 3615, 2607, 2451, 
        3616, 2608, 2453, 3617, 2609, 2455, 3618, 2610, 2457, 3619, 2611, 
        2459, 3621, 1493, 2461, 3622, 2612, 2463, 3623, 2613, 2465, 3624, 
        2614, 2467, 3625, 2615, 2469, 3626, 2616, 2471, 3627, 2617, 2473}], 
       Line3DBox[{2472, 3522, 3132, 2470, 3521, 3131, 2468, 3520, 3130, 2466, 
        3519, 3129, 2464, 3518, 3128, 2462, 3517, 3127, 2460, 3516, 3126, 
        3620, 2458, 3515, 3125, 2456, 3514, 3124, 2454, 3513, 3123, 2452, 
        3512, 3122, 2450, 3511, 3121, 2448, 3510, 3120, 2444, 3509, 3119, 
        2446}], Line3DBox[{2475, 3133, 3523, 2474, 3628, 2618, 2476, 3629, 
        2619, 2477, 3630, 2620, 2478, 3631, 2621, 2479, 3632, 2622, 2480, 
        3633, 2623, 2481, 3634, 3134, 3524, 2482, 1509, 2483, 3635, 2624, 
        2484, 3636, 2625, 2485, 3637, 2626, 2486, 3638, 2627, 2487, 3639, 
        2628, 2488}], 
       Line3DBox[{2490, 3135, 3525, 2489, 3136, 3526, 2491, 3640, 2629, 2492, 
        3641, 2630, 2493, 3642, 2631, 2494, 3643, 2632, 2495, 3644, 2633, 
        2496, 3645, 3137, 3527, 2497, 3138, 3528, 2498, 1525, 2499, 3646, 
        2634, 2500, 3647, 2635, 2501, 3648, 2636, 2502, 3649, 2637, 2503}], 
       Line3DBox[{2505, 3139, 3529, 2504, 3140, 3530, 2506, 3141, 3531, 2507, 
        3650, 2638, 2508, 3651, 2639, 2509, 3652, 2640, 2510, 3653, 2641, 
        2511, 3654, 3142, 3532, 2512, 3143, 3533, 2513, 3144, 3534, 2514, 
        1541, 2515, 3655, 2642, 2516, 3656, 2643, 2517, 3657, 2644, 2518}], 
       Line3DBox[{2520, 3145, 3535, 2519, 3146, 3536, 2521, 3147, 3537, 2522, 
        3148, 3538, 2523, 3658, 2645, 2524, 3659, 2646, 2525, 3660, 2647, 
        2526, 3661, 3149, 3539, 2527, 3150, 3540, 2528, 3151, 3541, 2529, 
        3152, 3542, 2530, 1557, 2531, 3662, 2648, 2532, 3663, 2649, 2533}], 
       Line3DBox[{2535, 3153, 3543, 2534, 3154, 3544, 2536, 3155, 3545, 2537, 
        3156, 3546, 2538, 3157, 3547, 2539, 3664, 2650, 2540, 3665, 2651, 
        2541, 3666, 3158, 3548, 2542, 3159, 3549, 2543, 3160, 3550, 2544, 
        3161, 3551, 2545, 3162, 3552, 2546, 1573, 2547, 3667, 2652, 2548}], 
       Line3DBox[{2562, 2659, 1593, 2561, 3564, 3173, 2560, 3563, 3172, 2559, 
        3562, 3171, 2558, 3561, 3170, 2557, 3560, 3169, 2556, 3559, 3168, 
        3669, 2555, 2653, 3668, 2554, 3558, 3167, 2553, 3557, 3166, 2552, 
        3556, 3165, 2551, 3555, 3164, 2550, 3554, 3163, 2549, 3553, 2657, 
        2656, 2658}], 
       Line3DBox[{2661, 2974, 1820, 2660, 3776, 2883, 2662, 3777, 2884, 2663, 
        3778, 2885, 2664, 3779, 2886, 2665, 3780, 2887, 2666, 3781, 2888, 
        2667, 3782, 3175, 3671, 2668, 3783, 2889, 2669, 3784, 2890, 2670, 
        3785, 2891, 2671, 3786, 2892, 2672, 3787, 2893, 2673, 3279, 3881, 
        2894, 2975}], 
       Line3DBox[{2675, 3176, 3672, 2674, 1835, 2676, 3788, 2895, 2677, 3789, 
        2896, 2678, 3790, 2897, 2679, 3791, 2898, 2680, 3792, 2899, 2681, 
        3793, 3177, 3673, 2682, 3178, 3674, 2683, 3794, 2900, 2684, 3795, 
        2901, 2685, 3796, 2902, 2686, 3797, 2903, 2687, 3798, 2904, 2688}], 
       Line3DBox[{2690, 3179, 3675, 2689, 3180, 3676, 2691, 1851, 2692, 3799, 
        2905, 2693, 3800, 2906, 2694, 3801, 2907, 2695, 3802, 2908, 2696, 
        3803, 3181, 3677, 2697, 3182, 3678, 2698, 3183, 3679, 2699, 3804, 
        2909, 2700, 3805, 2910, 2701, 3806, 2911, 2702, 3807, 2912, 2703}], 
       Line3DBox[{2705, 3184, 3680, 2704, 3185, 3681, 2706, 3186, 3682, 2707, 
        1867, 2708, 3808, 2913, 2709, 3809, 2914, 2710, 3810, 2915, 2711, 
        3811, 3187, 3683, 2712, 3188, 3684, 2713, 3189, 3685, 2714, 3190, 
        3686, 2715, 3812, 2916, 2716, 3813, 2917, 2717, 3814, 2918, 2718}], 
       Line3DBox[{2720, 3191, 3687, 2719, 3192, 3688, 2721, 3193, 3689, 2722, 
        3194, 3690, 2723, 1883, 2724, 3815, 2919, 2725, 3816, 2920, 2726, 
        3817, 3195, 3691, 2727, 3196, 3692, 2728, 3197, 3693, 2729, 3198, 
        3694, 2730, 3199, 3695, 2731, 3818, 2921, 2732, 3819, 2922, 2733}], 
       Line3DBox[{2735, 3200, 3696, 2734, 3201, 3697, 2736, 3202, 3698, 2737, 
        3203, 3699, 2738, 3204, 3700, 2739, 1899, 2740, 3820, 2923, 2741, 
        3821, 3205, 3701, 2742, 3206, 3702, 2743, 3207, 3703, 2744, 3208, 
        3704, 2745, 3209, 3705, 2746, 3210, 3706, 2747, 3822, 2924, 2748}], 
       Line3DBox[{2750, 3211, 3707, 2749, 3212, 3708, 2751, 3213, 3709, 2752, 
        3214, 3710, 2753, 3215, 3711, 2754, 3216, 3712, 2755, 1915, 2756, 
        3823, 3217, 3713, 2757, 3218, 3714, 2758, 3219, 3715, 2759, 3220, 
        3716, 2760, 3221, 3717, 2761, 3222, 3718, 2762, 3223, 3719, 2763}], 
       Line3DBox[{2767, 3824, 2925, 2765, 3825, 2926, 2769, 3826, 2927, 2771, 
        3827, 2928, 2773, 3828, 2929, 2775, 3829, 2930, 2777, 3830, 2931, 
        2779, 3832, 1932, 2781, 3833, 2932, 2783, 3834, 2933, 2785, 3835, 
        2934, 2787, 3836, 2935, 2789, 3837, 2936, 2791, 3838, 2937, 2793}], 
       Line3DBox[{2792, 3733, 3237, 2790, 3732, 3236, 2788, 3731, 3235, 2786, 
        3730, 3234, 2784, 3729, 3233, 2782, 3728, 3232, 2780, 3727, 3231, 
        3831, 2778, 3726, 3230, 2776, 3725, 3229, 2774, 3724, 3228, 2772, 
        3723, 3227, 2770, 3722, 3226, 2768, 3721, 3225, 2764, 3720, 3224, 
        2766}], Line3DBox[{2795, 3238, 3734, 2794, 3839, 2938, 2796, 3840, 
        2939, 2797, 3841, 2940, 2798, 3842, 2941, 2799, 3843, 2942, 2800, 
        3844, 2943, 2801, 3845, 3239, 3735, 2802, 1948, 2803, 3846, 2944, 
        2804, 3847, 2945, 2805, 3848, 2946, 2806, 3849, 2947, 2807, 3850, 
        2948, 2808}], 
       Line3DBox[{2810, 3240, 3736, 2809, 3241, 3737, 2811, 3851, 2949, 2812, 
        3852, 2950, 2813, 3853, 2951, 2814, 3854, 2952, 2815, 3855, 2953, 
        2816, 3856, 3242, 3738, 2817, 3243, 3739, 2818, 1964, 2819, 3857, 
        2954, 2820, 3858, 2955, 2821, 3859, 2956, 2822, 3860, 2957, 2823}], 
       Line3DBox[{2825, 3244, 3740, 2824, 3245, 3741, 2826, 3246, 3742, 2827, 
        3861, 2958, 2828, 3862, 2959, 2829, 3863, 2960, 2830, 3864, 2961, 
        2831, 3865, 3247, 3743, 2832, 3248, 3744, 2833, 3249, 3745, 2834, 
        1980, 2835, 3866, 2962, 2836, 3867, 2963, 2837, 3868, 2964, 2838}], 
       Line3DBox[{2840, 3250, 3746, 2839, 3251, 3747, 2841, 3252, 3748, 2842, 
        3253, 3749, 2843, 3869, 2965, 2844, 3870, 2966, 2845, 3871, 2967, 
        2846, 3872, 3254, 3750, 2847, 3255, 3751, 2848, 3256, 3752, 2849, 
        3257, 3753, 2850, 1996, 2851, 3873, 2968, 2852, 3874, 2969, 2853}], 
       Line3DBox[{2855, 3258, 3754, 2854, 3259, 3755, 2856, 3260, 3756, 2857, 
        3261, 3757, 2858, 3262, 3758, 2859, 3875, 2970, 2860, 3876, 2971, 
        2861, 3877, 3263, 3759, 2862, 3264, 3760, 2863, 3265, 3761, 2864, 
        3266, 3762, 2865, 3267, 3763, 2866, 2012, 2867, 3878, 2972, 2868}], 
       Line3DBox[{2882, 2979, 2032, 2881, 3775, 3278, 2880, 3774, 3277, 2879, 
        3773, 3276, 2878, 3772, 3275, 2877, 3771, 3274, 2876, 3770, 3273, 
        3880, 2875, 2973, 3879, 2874, 3769, 3272, 2873, 3768, 3271, 2872, 
        3767, 3270, 2871, 3766, 3269, 2870, 3765, 3268, 2869, 3764, 2977, 
        2976, 2978}]}, {
       Line3DBox[{749, 957, 3280, 750, 970, 776, 3375, 984, 790, 3380, 998, 
        804, 3387, 1012, 818, 3396, 1026, 832, 3407, 1040, 846, 1054, 3322, 
        860, 1068, 3334, 874, 3422, 1082, 888, 3426, 1096, 902, 3432, 1110, 
        916, 3440, 1124, 930, 3449, 1138, 944}], 
       Line3DBox[{751, 958, 3281, 752, 971, 3291, 777, 985, 791, 3381, 999, 
        805, 3388, 1013, 819, 3397, 1027, 833, 3408, 1041, 847, 1055, 3323, 
        861, 1069, 3335, 875, 1083, 3345, 889, 3427, 1097, 903, 3433, 1111, 
        917, 3441, 1125, 931, 3450, 1139, 945}], 
       Line3DBox[{753, 959, 3282, 754, 972, 3292, 778, 986, 3301, 792, 1000, 
        806, 3389, 1014, 820, 3398, 1028, 834, 3409, 1042, 848, 1056, 3324, 
        862, 1070, 3336, 876, 1084, 3346, 890, 1098, 3354, 904, 3434, 1112, 
        918, 3442, 1126, 932, 3451, 1140, 946}], 
       Line3DBox[{755, 960, 3283, 756, 973, 3293, 779, 987, 3302, 793, 1001, 
        3309, 807, 1015, 821, 3399, 1029, 835, 3410, 1043, 849, 1057, 3325, 
        863, 1071, 3337, 877, 1085, 3347, 891, 1099, 3355, 905, 1113, 3361, 
        919, 3443, 1127, 933, 3452, 1141, 947}], 
       Line3DBox[{757, 961, 3284, 758, 974, 3294, 780, 988, 3303, 794, 1002, 
        3310, 808, 1016, 3315, 822, 1030, 836, 3411, 1044, 850, 1058, 3326, 
        864, 1072, 3338, 878, 1086, 3348, 892, 1100, 3356, 906, 1114, 3362, 
        920, 1128, 3366, 934, 3453, 1142, 948}], 
       Line3DBox[{759, 962, 3285, 760, 975, 3295, 781, 989, 3304, 795, 1003, 
        3311, 809, 1017, 3316, 823, 1031, 3319, 837, 1045, 851, 1059, 3327, 
        865, 1073, 3339, 879, 1087, 3349, 893, 1101, 3357, 907, 1115, 3363, 
        921, 1129, 3367, 935, 1143, 3369, 949}], 
       Line3DBox[{8, 2043, 23, 2057, 38, 2072, 53, 2087, 68, 2102, 83, 2117, 
        98, 2132, 113, 2147, 128, 2162, 143, 2177, 158, 2192, 173, 2207, 188, 
        2222, 203, 2236, 218}], 
       Line3DBox[{761, 3370, 963, 762, 3372, 976, 782, 3376, 990, 796, 3382, 
        1004, 810, 3390, 1018, 824, 3400, 1032, 838, 3412, 1046, 852, 1060, 
        866, 3420, 1074, 880, 3423, 1088, 894, 3428, 1102, 908, 3435, 1116, 
        922, 3444, 1130, 936, 3454, 1144, 950}], 
       Line3DBox[{763, 964, 3286, 764, 3373, 977, 783, 3377, 991, 797, 3383, 
        1005, 811, 3391, 1019, 825, 3401, 1033, 839, 3413, 1047, 853, 1061, 
        3328, 867, 1075, 881, 3424, 1089, 895, 3429, 1103, 909, 3436, 1117, 
        923, 3445, 1131, 937, 3455, 1145, 951}], 
       Line3DBox[{765, 965, 3287, 766, 978, 3296, 784, 3378, 992, 798, 3384, 
        1006, 812, 3392, 1020, 826, 3402, 1034, 840, 3414, 1048, 854, 1062, 
        3329, 868, 1076, 3340, 882, 1090, 896, 3430, 1104, 910, 3437, 1118, 
        924, 3446, 1132, 938, 3456, 1146, 952}], 
       Line3DBox[{767, 966, 3288, 768, 979, 3297, 785, 993, 3305, 799, 3385, 
        1007, 813, 3393, 1021, 827, 3403, 1035, 841, 3415, 1049, 855, 1063, 
        3330, 869, 1077, 3341, 883, 1091, 3350, 897, 1105, 911, 3438, 1119, 
        925, 3447, 1133, 939, 3457, 1147, 953}], 
       Line3DBox[{769, 967, 3289, 770, 980, 3298, 786, 994, 3306, 800, 1008, 
        3312, 814, 3394, 1022, 828, 3404, 1036, 842, 3416, 1050, 856, 1064, 
        3331, 870, 1078, 3342, 884, 1092, 3351, 898, 1106, 3358, 912, 1120, 
        926, 3448, 1134, 940, 3458, 1148, 954}], 
       Line3DBox[{771, 968, 3290, 772, 981, 3299, 787, 995, 3307, 801, 1009, 
        3313, 815, 1023, 3317, 829, 3405, 1037, 843, 3417, 1051, 857, 1065, 
        3332, 871, 1079, 3343, 885, 1093, 3352, 899, 1107, 3359, 913, 1121, 
        3364, 927, 1135, 941, 3459, 1149, 955}], 
       Line3DBox[{773, 1151, 1152, 774, 982, 3300, 788, 996, 3308, 802, 1010, 
        3314, 816, 1024, 3318, 830, 1038, 3320, 844, 3418, 1052, 858, 1066, 
        3333, 872, 1080, 3344, 886, 1094, 3353, 900, 1108, 3360, 914, 1122, 
        3365, 928, 1136, 3368, 942, 1154, 1155, 1156}], 
       Line3DBox[{943, 1137, 1153, 929, 1123, 3439, 915, 1109, 3431, 901, 
        1095, 3425, 887, 1081, 3421, 873, 1067, 3419, 859, 3321, 1053, 845, 
        1039, 3406, 831, 1025, 3395, 817, 1011, 3386, 803, 997, 3379, 789, 
        983, 3374, 775, 969, 3371, 748, 956, 1150, 1157}], 
       Line3DBox[{1159, 1382, 3565, 1160, 1396, 1188, 3465, 1411, 1203, 3470, 
        1426, 1218, 3477, 1441, 1233, 3486, 1456, 1248, 3497, 1471, 1263, 
        3510, 1486, 3614, 1278, 1501, 3628, 1293, 3526, 1516, 1308, 3530, 
        1531, 1323, 3536, 1546, 1338, 3544, 1561, 1353, 3554, 1576, 1368}], 
       Line3DBox[{1161, 1383, 3566, 1162, 1397, 3577, 1189, 1412, 1204, 3471, 
        1427, 1219, 3478, 1442, 1234, 3487, 1457, 1249, 3498, 1472, 1264, 
        3511, 1487, 3615, 1279, 1502, 3629, 1294, 1517, 3640, 1309, 3531, 
        1532, 1324, 3537, 1547, 1339, 3545, 1562, 1354, 3555, 1577, 1369}], 
       Line3DBox[{1163, 1384, 3567, 1164, 1398, 3578, 1190, 1413, 3588, 1205, 
        1428, 1220, 3479, 1443, 1235, 3488, 1458, 1250, 3499, 1473, 1265, 
        3512, 1488, 3616, 1280, 1503, 3630, 1295, 1518, 3641, 1310, 1533, 
        3650, 1325, 3538, 1548, 1340, 3546, 1563, 1355, 3556, 1578, 1370}], 
       Line3DBox[{1165, 1385, 3568, 1166, 1399, 3579, 1191, 1414, 3589, 1206, 
        1429, 3597, 1221, 1444, 1236, 3489, 1459, 1251, 3500, 1474, 1266, 
        3513, 1489, 3617, 1281, 1504, 3631, 1296, 1519, 3642, 1311, 1534, 
        3651, 1326, 1549, 3658, 1341, 3547, 1564, 1356, 3557, 1579, 1371}], 
       Line3DBox[{1167, 1386, 3569, 1168, 1400, 3580, 1192, 1415, 3590, 1207, 
        1430, 3598, 1222, 1445, 3604, 1237, 1460, 1252, 3501, 1475, 1267, 
        3514, 1490, 3618, 1282, 1505, 3632, 1297, 1520, 3643, 1312, 1535, 
        3652, 1327, 1550, 3659, 1342, 1565, 3664, 1357, 3558, 1580, 1372}], 
       Line3DBox[{1169, 1387, 3570, 1170, 1401, 3581, 1193, 1416, 3591, 1208, 
        1431, 3599, 1223, 1446, 3605, 1238, 1461, 3609, 1253, 1476, 1268, 
        3515, 1491, 3619, 1283, 1506, 3633, 1298, 1521, 3644, 1313, 1536, 
        3653, 1328, 1551, 3660, 1343, 1566, 3665, 1358, 1581, 3668, 1373}], 
       Line3DBox[{1171, 1388, 3571, 1173, 1402, 3582, 1194, 1417, 3592, 1209, 
        1432, 3600, 1224, 1447, 3606, 1239, 1462, 3610, 1254, 1477, 3612, 
        1269, 1492, 3620, 3621, 1284, 1507, 3634, 1299, 1522, 3645, 1314, 
        1537, 3654, 1329, 1552, 3661, 1344, 1567, 3666, 1359, 1582, 3669, 
        1374}], Line3DBox[{1175, 1390, 3572, 1176, 3463, 1404, 1196, 3467, 
        1419, 1211, 3473, 1434, 1226, 3481, 1449, 1241, 3491, 1464, 1256, 
        3503, 1479, 1271, 3517, 1494, 3622, 1286, 1509, 1301, 3528, 1524, 
        1316, 3533, 1539, 1331, 3540, 1554, 1346, 3549, 1569, 1361, 3560, 
        1584, 1376}], 
       Line3DBox[{1177, 1391, 3573, 1178, 1405, 3583, 1197, 3468, 1420, 1212, 
        3474, 1435, 1227, 3482, 1450, 1242, 3492, 1465, 1257, 3504, 1480, 
        1272, 3518, 1495, 3623, 1287, 1510, 3635, 1302, 1525, 1317, 3534, 
        1540, 1332, 3541, 1555, 1347, 3550, 1570, 1362, 3561, 1585, 1377}], 
       Line3DBox[{1179, 1392, 3574, 1180, 1406, 3584, 1198, 1421, 3593, 1213, 
        3475, 1436, 1228, 3483, 1451, 1243, 3493, 1466, 1258, 3505, 1481, 
        1273, 3519, 1496, 3624, 1288, 1511, 3636, 1303, 1526, 3646, 1318, 
        1541, 1333, 3542, 1556, 1348, 3551, 1571, 1363, 3562, 1586, 1378}], 
       Line3DBox[{1181, 1393, 3575, 1182, 1407, 3585, 1199, 1422, 3594, 1214, 
        1437, 3601, 1229, 3484, 1452, 1244, 3494, 1467, 1259, 3506, 1482, 
        1274, 3520, 1497, 3625, 1289, 1512, 3637, 1304, 1527, 3647, 1319, 
        1542, 3655, 1334, 1557, 1349, 3552, 1572, 1364, 3563, 1587, 1379}], 
       Line3DBox[{1183, 1394, 3576, 1184, 1408, 3586, 1200, 1423, 3595, 1215, 
        1438, 3602, 1230, 1453, 3607, 1245, 3495, 1468, 1260, 3507, 1483, 
        1275, 3521, 1498, 3626, 1290, 1513, 3638, 1305, 1528, 3648, 1320, 
        1543, 3656, 1335, 1558, 3662, 1350, 1573, 1365, 3564, 1588, 1380}], 
       Line3DBox[{1185, 1590, 1591, 3670, 1186, 1409, 3587, 1201, 1424, 3596, 
        1216, 1439, 3603, 1231, 1454, 3608, 1246, 1469, 3611, 1261, 3508, 
        1484, 1276, 3522, 1499, 3627, 1291, 1514, 3639, 1306, 1529, 3649, 
        1321, 1544, 3657, 1336, 1559, 3663, 1351, 1574, 3667, 1366, 1593, 
        1594, 1595}], 
       Line3DBox[{1367, 1575, 3553, 1592, 1352, 1560, 3543, 1337, 1545, 3535, 
        1322, 1530, 3529, 1307, 1515, 3525, 1292, 1500, 3523, 1277, 3613, 
        1485, 3509, 1262, 1470, 3496, 1247, 1455, 3485, 1232, 1440, 3476, 
        1217, 1425, 3469, 1202, 1410, 3464, 1187, 1395, 3461, 1158, 1381, 
        1589, 1596}], 
       Line3DBox[{1375, 1583, 3559, 1360, 1568, 3548, 1345, 1553, 3539, 1330, 
        1538, 3532, 1315, 1523, 3527, 1300, 1508, 3524, 1285, 1493, 3516, 
        1270, 1478, 3502, 1255, 1463, 3490, 1240, 1448, 3480, 1225, 1433, 
        3472, 1210, 1418, 3466, 1195, 1403, 3462, 1174, 1389, 3460, 1172}], 
       Line3DBox[{1598, 1821, 3776, 1599, 1835, 1627, 3676, 1850, 1642, 3681, 
        1865, 1657, 3688, 1880, 1672, 3697, 1895, 1687, 3708, 1910, 1702, 
        3721, 1925, 3825, 1717, 1940, 3839, 1732, 3737, 1955, 1747, 3741, 
        1970, 1762, 3747, 1985, 1777, 3755, 2000, 1792, 3765, 2015, 1807}], 
       Line3DBox[{1600, 1822, 3777, 1601, 1836, 3788, 1628, 1851, 1643, 3682, 
        1866, 1658, 3689, 1881, 1673, 3698, 1896, 1688, 3709, 1911, 1703, 
        3722, 1926, 3826, 1718, 1941, 3840, 1733, 1956, 3851, 1748, 3742, 
        1971, 1763, 3748, 1986, 1778, 3756, 2001, 1793, 3766, 2016, 1808}], 
       Line3DBox[{1602, 1823, 3778, 1603, 1837, 3789, 1629, 1852, 3799, 1644, 
        1867, 1659, 3690, 1882, 1674, 3699, 1897, 1689, 3710, 1912, 1704, 
        3723, 1927, 3827, 1719, 1942, 3841, 1734, 1957, 3852, 1749, 1972, 
        3861, 1764, 3749, 1987, 1779, 3757, 2002, 1794, 3767, 2017, 1809}], 
       Line3DBox[{1604, 1824, 3779, 1605, 1838, 3790, 1630, 1853, 3800, 1645, 
        1868, 3808, 1660, 1883, 1675, 3700, 1898, 1690, 3711, 1913, 1705, 
        3724, 1928, 3828, 1720, 1943, 3842, 1735, 1958, 3853, 1750, 1973, 
        3862, 1765, 1988, 3869, 1780, 3758, 2003, 1795, 3768, 2018, 1810}], 
       Line3DBox[{1606, 1825, 3780, 1607, 1839, 3791, 1631, 1854, 3801, 1646, 
        1869, 3809, 1661, 1884, 3815, 1676, 1899, 1691, 3712, 1914, 1706, 
        3725, 1929, 3829, 1721, 1944, 3843, 1736, 1959, 3854, 1751, 1974, 
        3863, 1766, 1989, 3870, 1781, 2004, 3875, 1796, 3769, 2019, 1811}], 
       Line3DBox[{1608, 1826, 3781, 1609, 1840, 3792, 1632, 1855, 3802, 1647, 
        1870, 3810, 1662, 1885, 3816, 1677, 1900, 3820, 1692, 1915, 1707, 
        3726, 1930, 3830, 1722, 1945, 3844, 1737, 1960, 3855, 1752, 1975, 
        3864, 1767, 1990, 3871, 1782, 2005, 3876, 1797, 2020, 3879, 1812}], 
       Line3DBox[{1610, 1827, 3782, 1612, 1841, 3793, 1633, 1856, 3803, 1648, 
        1871, 3811, 1663, 1886, 3817, 1678, 1901, 3821, 1693, 1916, 3823, 
        1708, 1931, 3831, 3832, 1723, 1946, 3845, 1738, 1961, 3856, 1753, 
        1976, 3865, 1768, 1991, 3872, 1783, 2006, 3877, 1798, 2021, 3880, 
        1813}], Line3DBox[{1614, 1829, 3783, 1615, 3674, 1843, 1635, 3678, 
        1858, 1650, 3684, 1873, 1665, 3692, 1888, 1680, 3702, 1903, 1695, 
        3714, 1918, 1710, 3728, 1933, 3833, 1725, 1948, 1740, 3739, 1963, 
        1755, 3744, 1978, 1770, 3751, 1993, 1785, 3760, 2008, 1800, 3771, 
        2023, 1815}], 
       Line3DBox[{1616, 1830, 3784, 1617, 1844, 3794, 1636, 3679, 1859, 1651, 
        3685, 1874, 1666, 3693, 1889, 1681, 3703, 1904, 1696, 3715, 1919, 
        1711, 3729, 1934, 3834, 1726, 1949, 3846, 1741, 1964, 1756, 3745, 
        1979, 1771, 3752, 1994, 1786, 3761, 2009, 1801, 3772, 2024, 1816}], 
       Line3DBox[{1618, 1831, 3785, 1619, 1845, 3795, 1637, 1860, 3804, 1652, 
        3686, 1875, 1667, 3694, 1890, 1682, 3704, 1905, 1697, 3716, 1920, 
        1712, 3730, 1935, 3835, 1727, 1950, 3847, 1742, 1965, 3857, 1757, 
        1980, 1772, 3753, 1995, 1787, 3762, 2010, 1802, 3773, 2025, 1817}], 
       Line3DBox[{1620, 1832, 3786, 1621, 1846, 3796, 1638, 1861, 3805, 1653, 
        1876, 3812, 1668, 3695, 1891, 1683, 3705, 1906, 1698, 3717, 1921, 
        1713, 3731, 1936, 3836, 1728, 1951, 3848, 1743, 1966, 3858, 1758, 
        1981, 3866, 1773, 1996, 1788, 3763, 2011, 1803, 3774, 2026, 1818}], 
       Line3DBox[{1622, 1833, 3787, 1623, 1847, 3797, 1639, 1862, 3806, 1654, 
        1877, 3813, 1669, 1892, 3818, 1684, 3706, 1907, 1699, 3718, 1922, 
        1714, 3732, 1937, 3837, 1729, 1952, 3849, 1744, 1967, 3859, 1759, 
        1982, 3867, 1774, 1997, 3873, 1789, 2012, 1804, 3775, 2027, 1819}], 
       Line3DBox[{1624, 2029, 2030, 3881, 1625, 1848, 3798, 1640, 1863, 3807, 
        1655, 1878, 3814, 1670, 1893, 3819, 1685, 1908, 3822, 1700, 3719, 
        1923, 1715, 3733, 1938, 3838, 1730, 1953, 3850, 1745, 1968, 3860, 
        1760, 1983, 3868, 1775, 1998, 3874, 1790, 2013, 3878, 1805, 2032, 
        2033, 2034}], 
       Line3DBox[{1806, 2014, 3764, 2031, 1791, 1999, 3754, 1776, 1984, 3746, 
        1761, 1969, 3740, 1746, 1954, 3736, 1731, 1939, 3734, 1716, 3824, 
        1924, 3720, 1701, 1909, 3707, 1686, 1894, 3696, 1671, 1879, 3687, 
        1656, 1864, 3680, 1641, 1849, 3675, 1626, 1834, 3672, 1597, 1820, 
        2028, 2035}], 
       Line3DBox[{1814, 2022, 3770, 1799, 2007, 3759, 1784, 1992, 3750, 1769, 
        1977, 3743, 1754, 1962, 3738, 1739, 1947, 3735, 1724, 1932, 3727, 
        1709, 1917, 3713, 1694, 1902, 3701, 1679, 1887, 3691, 1664, 1872, 
        3683, 1649, 1857, 3677, 1634, 1842, 3673, 1613, 1828, 3671, 
        1611}]}, {}, {}, {}, {}, {}, {}, {}, {}, {}}},
    VertexNormals->CompressedData["
1:eJzsvXlYj933952ETCFTmTJUQqYyNq0yJIkoGSvJGJkrNJiJQpMpRTKUpJFE
09Y8qDR+GlEUDZ+BioR0n/u8Wn4/3d/rj+c+nud4fsdxn9c/59H7Oq99rb0+
+1x7rX3svV/jLPcZbRMXExObNEBMrLvYn39O/P38DJzO6ZzO6ZzO6ZzO6ZzO
6ZzO6ZzO6ZzO6ZzO6ZzO6ZzO6Zz+v+tayv32x48tJ38/G6CXW+1k4zoeWZw6
efOzF+XknUrZjmcvGiAuRXrQsaOFJNfps2P4worOZyOITHSnT4x4TRwaiwzE
Yys6n41wW61GVV4mg6Tcma8zeVQlWROsrTd5FB+2SY/MUZ7/kjzda3xaamtl
55MP1m/DJlkbhZOlzZvMNd0ryT3xM9s03fl/7C8TkFQFv0ryz5MPWh+vWDLv
w7CGVjP6/v62kez7Nc+lK5j2wWKx4BRt/58nH9auXarN2ANlb1fqUnv+efJh
VlOWPmM/+Hs8W0ztn2X0gLV/xSp5Gaa/UN/X3o72V/K7vhPtb9KsF9MZ/0DY
0rBt1D//PBvQn9DVn+hH9Cv686F7w8Z3NiUEn4/N2xeGmTXCzT7RNr2+FRKZ
jQHfJFtKyNXgq0f6NDXCK7Jb10Unj0T4+VsZWpaSmtqs3xEH+aCXKzdzVVwG
MYxdM29VXCnpsyp4xNMKxs9VSqG9Hr0k5sMLvPp2lBKtYV8uXZokgKBbZz7u
SA0nXySyRCOVykjphcTPtusFcPjEntK7Vppaebv0ddpml5F//mb0ovjuO1PD
QSvAm33fdOQF9v2Q4cOymPZhQ5uON21f93i6K23/+LPuwNgDRzOz51J73Df3
Ye15/VV6OWM/tO75spPa77qmvZ3af8CzhwPTX3C/UvyV9tdA9u5h2t/jz3mb
Gb9AqEHHBuqfJzUNC6h/jo9UtWb8Cf46H5WoPz+GnGH9j+Py73HaCOhH9Cv6
0/zWfL1eO4oIPrXKwrbQ8WM2N31JD/88Yqpleks3s4j0KQedTFkBjDaQWNC2
KpPMH/la6oFsMUm59/v0chcBPDKvkho0KJEMVFm9xsSkmGzbnPLmzRsBWAs1
mxynRZBdw3mao+yLSfe49tQNg4R/xvMyg3WyF84xemiakIwXQquv8kCnaREw
7uUj9n1fqUT2fSeYPYZpH74qmRrS9p9m2L2l7Q8J227O2AP7TpX2p/bY7Xhw
itrzVGaqIWM/FA3TvEbtX1Npx9ofsLWZ9hOWm7zWof3V/PxkK+3vO5OHvxj/
gPSij4eofw5YHmD93+lP6OpP/M7//u4bAccljlMcn+hH9Cv6c6qqj6ZaSx7B
p1D8xK9twQLYV+d19H5RJvHdtjN4z7x8ktc7VkT90/vRlmal3Ynkn2c+OVse
H+LsIIRGq7iiQy4RxMRtaM0hl3wyXeJXgX7kf/nZxE3Q0OtqPvFY/f1tTgrT
Tt7SZuZ98Hv0+QN9/8uhWPb928rrxSftToT0nSPZ9o12Att+vHD5dcYecK3x
vkftqa/QZu1Rlq/WZ+yGEH27hdT+vftS2qj9nf2Frv292e3ZPsY/IH05djH1
z7vL19jx3+lP6OpPjJsYRzF+4neO3z1+7zgucZzi+EQ/ol/Rn7/DB+nyIYvg
U+emcu96PyE49O5QmxeVSBzl2ncUuWWR0YfUz41vF4L80NtfR/IiiMYRSbHJ
iVmk75q+/SPmiCDu+SZ9JX3QytNVWF+Wn0X++VsE3X+FDBnFi4BWvdyOScz7
6jbp/ej7+9duXc+0D/csZNn2x5KZZ2n71Zlxqxk7wKzYejG1J3yRtSS1x/rQ
tkjGfphqm3SE2o/fy5LpW4cy/YXVT/rr0P6e/vKWHf9BKUe1GP+Ab0PfGdQ/
ww5ayVL/+F33MGD8CRqLPWZSf0pdcllM/Ynz0N/zEh8wbmIcxfiJ3zl+9/i9
47jEcYrjE/2IfkV/zpUd1m0/P5Hgc8H+ReNSzESQHWJ88pJUJAmxGutxSSqJ
fPrUmHjYWwQnVb3cHoWAVkFUuqHMiCTyz98icNs61J95H3L4Difp+0prVJLo
+90uTBzItItPols3Yyxtf4b4JjvGHuiTT5ZSe8YZic5Qe0Y8yug2aXc+7Bm/
/AO1n396wWNq/2R1AzOmv1Di5NoxkOnv0B+D/ulv1R0a92Hj1Zex1D+D5s65
SP3T6U/o6k+c13Gex/kd5yGcl3A+wriJcRTjJ37n+N3j947jEscpjk/0I/oV
/an6O/bl/pmRBJ/LTskdOMsT/YkbKz86DgbNSHI5scepaY0iuLHeqop5DyYW
ebLvRx0p2U/fvxjoe4dpH7Kmd2fb39J3E9t+84KvUow9cPPZJNaem+HAjv9Z
btMaGftheIkSa79acls+tT/0xclFTH9Bz8P9C9vf9bkptL/qk39/ZfwDb8Yn
11L/NDftFVH/3Mh/bcX4E+6+GKBE/QlJwZbUn5gn/Z038eHveV1TC+d3nIfw
ffy+MG6ijvHz7+8ctPB7/3tcghaOT/QjtoP+/Le8dN9NLVXmfbCYEn9yWiNo
/fP80/6f/w7bzzg7Yidjzx/d7KrnUmrPevk+TYz9sARa3uSkaGn98xTC+9ye
Y5n+wkL1qwIyXkvrn6cQDsWcWML45087rs9lSqh/Ov3ZJQ/l/8k7MQ/F/BPz
JMybMF/CeR3neZzfcR7CeQnnI4ybGEcxfuJ3jt89fu84LnGc4vhEP/7tV2bc
Ttdm38Pn2H1u7PuPJ393p+P50seUO7T9B0cfsOM5dHAsO56P3JrP2pOZ+7Mv
tef4o97seFbVfNZE7f+l8oIdz+YhPH06nmd7vFSm/Z3to5BM+3v+VQ47noPX
/xKn/jl8Zg47nrdm7GDH877EFgvqz34vFrLjGfP4v/N6/p+8E/NQzD8xT8K8
CfMlnNdxnsf5HechnJdwPsK4iXEU4yd+5/jd4/eO4wPHKY5P9CP6Ff2Z9X2e
HG0Xn/oWo+Vo+8njBbY0Pnc/0rSO2jPhyC42Pk/PmPSDsb8zTicCxucCzQ4T
Gp/F1rqOpv0tP7Ccjc+RD/f50fi8Un9dJvVPzVoHF+qfTn9CV39iXfR3ncT/
k8djXo/5POadmIdi/ol5EuZNmC/hvI7zPM7vOA/hvITzEcbNP3G0M36in/G7
x+8dxyWOUxyf6Ef0K/pTWzictQOfcqLgXtSe7Be/Imi+8TRhjjO1f7LVADYe
vn9fN4TmG69rtAxpf02NVdj+FhaINGm+8c8zA26dypCh/un0J3T15586s7Pu
xHoT6yKsk7A+wjwe83rM5zHvxDwU80/MkzBvwniO8zrO8zh+cB7CeQnnI4yb
f8dR4Z/vHL97/N5xXOI4xfbRj+hX9OfJDxtZu/G5SKviO7VfbTDxpfmzp8Bt
Be1vRd4Wbdrfqtc92Px5aIqlAfXPuY6MX9Q/38PbVtL8udQsfwn157bPffSp
P7Fuxzoe63esM7HuxHoT6yKsk7A+6lIPAubzmHdiHor5J+ZJmDdhvoTzOs7z
OL/jPPT3vCT8Ezf/xNHO+InfOX73+L3juMRxiuMT/Yh+RX8qjGlYTvuJT+3g
wM20v2vdSn7SerD+1Sx76p+JeU521D+XLt49SevBScJNw6g/993Jt6f+xHWQ
v9dFGv7U7VjHY/2OdSbWnVhvYl2EdRLWR5jHY16P+TzmnZiHYv6JeRLmTZgv
YdzAeR7nd5yHcF7C+QjjJsZRjJ/4neN3j987jkscpzg+0Y/oV/Rn57rPnyeu
/3T6E7r6s8t6HeD6Eq6D4LoIrod0Wa+Df1mvA6w3sS7COgnroy7rdYD5POad
mIdi/tllvQ4wX8J5Hed5nN+7rNfBv6zX/Ymf+J3jd4/fO45LHKc4Prus13X1
J3T154WUmkchvFKCT48v0+JzSQPMVhqj9m5vOem466FwzrWU/PN3A5RWeIYz
78GkuvdB9P2VIBv3396Hru/je/jfdXkf2wd8/0iHexh9D58DL3WPpe///V75
n/f//v+Vky46/ItOurbTxf4/enJ8vtbtY2UEn6P391iybn8DnFi1eRHzN+xT
T9WkeuNP4WKq49/471Gf8nr1Qvo3Pl84ly6ienP4J+sZeuVkzjH9y7Vry8jA
+KOHZug1gKZOsifzN0RfMjhA//0/zwYw3D/xIn1v85Giw4wOi60XsHrne13+
uwbAdvH/g+3jf4/tdWmHdG2niz1/9O0/fr9xmpLb5SnkdE7ndE7ndE7ndE7n
dE7ndE7ndE7ndE7ndE7ndE7ndE7n9P+gi/3Hfz5zOqdzOqdzOqdzOqdzOqdz
OqdzOqdzOqdzOqdzOqdzOqdzOqdzOqdzOqdzOqdzOqdzOqdzOqdzOqf/pXvp
WHc79baEOH5ZtXrl1hJyPmp4nJl+I7gmH1+QvqaIeD48/dFgQgWZuG16ncGE
RvB0XTx9T0kRyd730FSZV0I8BtenqL5uhO61M+9Gz8kn23uqH5H3qOh8NoLh
/hWLJgbmk22u+2f6qJcSoXH1DpfFfCB+BWebP70iqy9HCWqEFWTysflfaoSN
4B9TeHvBvWwydfi9W+aepaRE71hs8iM+FE9pP9KumEpMrAse7lSrJAUmc0N2
qvEhyXjm+zHPU8mI2K27LEtLyQdx3dKDv/iw2G6qv+yeOPL5TdQg3oFK8rz/
8cG8A3xwNnHeslE1nkwqsI8r61tG3g+7MfDYPAHsHFDY/sbjMXkoZaoe61VJ
oNVHJ9aLD9vX/KiZvzGEHPmWOHfjlDLSNvNVKpgJgO955rGmu69G1/ta0z7a
bH7r8RimberHtpO6xIBth/8m+d1/unc0qWe+otrGELhr4Mm2f+KaF9u+Xalx
CmM/lNguZu2//UCKtf/D4IwrjP2wdoXrS2q/k3aLFLV/UWnbWcY/UJBZFsz6
h33y4VLLqq+Mf6ANpKypf4JO9yih/vGEEm/G/zB1GeFT/3sNmfuZ+t9Lbe9j
xv9w9F4P1v/Tr6fFUP8vv2sdwvy+sP3KygP09z3zZhb7+/Z9W6TP/L7w6PmT
GfT3TZDswf6+RVvEljLjB/YOyHxPx89gxY+f6PjJi3OYzYwfkArP20jHz3lz
QTIdP899njy6uKoEfkXu/+gYWE7+eTaAgkdHL2Z8wpedS4zp+Pz4siqGjs91
9o5rh2wqJesuHw5Z/6mQ3Hx928vpTSMUzhl8ZZBBMdG99jDOwaCInNAmdwfv
5kNkq8LU1f0LSPDL36kZAUXENF3B/ng9H+xItFXe8hwy9mfvh9NaisjWxK/C
chMBbDVPOuCokUYyYqxNiEoxsVW3WHowRADLlzXXbq+LJ0EfSr9lWxSTFwpy
iY0CATT7bM/RHhxKBuvGzuzhVExkxWOf7BkqhHDpFZUbBt3W6HoParFGQTed
waGwYfBN9v0a54vs+92rDkjsqIuHp9FeX2j7K6ddY9s//XHZBcYesGnSNKL2
GLmV6FF7JGoXHWfsh4CjX+9R+7cVrGXtHx4iocL0F77tGkFof9vVb7P9lb4l
f43xD4jvDIqm/qlz0r5H/XPaNcaU8ScoBMU/pv6MuXzTk/qzRfmo+oXcUmLl
n/Bm0uw84q/uvaS3GR/kx4sN2hVRTMbbzT121SWP7N90/M7ZJmacX3RvXrq9
gIyWVt4uXpJH2n54ay06IoDRFpvfeb3PIU1pHT/8ZfKJuLnDyZGNAlhbJNdv
dHgaudu8+2PS8nzSwe8xfKieEIYPLXgVey6BbDEefaXBJp9o1Uo437woBEn3
HImVT0NJkW7zMOHFfNLbXezxnWdCGKicWK8feVuj6z2oxVcM1Zj3YbFECfu+
28jXwfR9rTd19Uz70CvrjRdt/83Tq+do+4LZ5vKMPVBkcbia2qN07sYwas/Y
LWd/MvbDrU0SrP0W598cp/bLbsz9yfQXbF+nW9H+XnmSrUH7uyrLVZrxD7QY
DGT9s6lEjfXP/Cnp2ow/wS55HOvPedHndKk/1R1G37OfVEbqGwYUNj/MIL6S
aqdGpfLBWGm3YJEEj8g4hgzPnpZJPvJVnBZuFsBJ1apqhbAC4jguO50EZJJ3
gepjZzPjZFadpqWPaS5xCbmU9bF/Fgm+abji0jYhdKzo7TN0QDpJanDTPbs5
i0So5F0YmS6EQI2mc3WShMgfd4me7ZdFJFTi+w8ZIAKVVuXivHlhpCVFQ186
NYsc1taX0lYXQevWqUb/6R5U3YlTRubPCwPY0519X2FDL/b993st4pj2YYJj
xTPafln3L/1o+3LuHmGMPXB7Ttpiao9zVc15ao9NT8/9jP1AuhdkUvvrg2yW
U/tL0p7VMf2F1tn8NNrfvbvmyNH+jvj5oZnxD2weFTaM+qdmYh9H6h+9BY1B
jD9BNb8kn/VnQ84J6s/W35Wb3luXkewMe4Vo35ek+9ig29rSAnhv2X4uTYdH
gpZvqSv5/pI0VadWHX0iAMdbPy8Z1hYQy0GDlp1elkjktyimKywSwvztik77
onOJ3+ddEOaZSM5/2vIy8qUQZte+Cyg1SSc2O8Yt3ZedSBrmjn2XpCCCR65z
lX5YETJj9JJL0q2JpPZAkpvFfhEYSm/4GewTRs5r6J7WGZREFoaHBqncFsEu
j6PX/9M9qAtVEhc89gkDm6/utvT9R/dq2Pcvj0/VZdoHY5/gK7T9O/ESbPsG
+mejGHtgp7r4OmrPqjt1b6g9Yj9zPRn7oaUqQ4vav9J9AKH2l1xx92b6C1+M
5qvT/vLt6lJpf51uPrrE+AfK25dUUf+sePX6HfXPxCHCrYw/Ye1us5nUn3sr
xt6i/lz9+/TNjdfKyLmch+686HCyWM7qZrSOANxWe/YM2sEjuve789OHRhA7
J/6P0R8FYDtypcfTnoWk8MHoyQq7IsjGe1OVEo8KYYJOmb6jKJdssrRLKoyM
IGVj9J40fRfC7yLBCdeT6eRmW4kfTxBBziqPiJ5rIQKvbMHhlgeERBXDlT2y
keTd7FEfjj8WgYPXz6tppWFkysem07NmRZKCvSk9TStEkGX6/PxZnp9G13tQ
lybY5TDvQ5FZIfu+mvYl9v0n4sOvM+3Dkl5tXrT9OwZ33tP25ZZJuzP2gHzG
ftaer1e3PaP2xM/ftZ6xH+z6NCVS+7uftYik9pvc1r7B9BcCxE9Mov3NSpWd
SPtrtm5sf8Y/8KhxZSP1z9aYJ23UP7tqt/gz/oRtvXPdqD/76jXcoP7MrO3R
0/R+Gem/6HnD4/j5WkX5Nz/FrxLAKePH421teGTaZ9OINdajtUzXFSyc3yqA
6uvVZe2DCglmgN3W/V71zlUIOx8VVOwTf02WS17yCl0xXcu++OaL1r4iqDAp
NjV2Tyc8KVu/9kOg9c9TBNVHxbZBDCHDE2ecGJ46V2vgCKdjJS9FYP0+VspG
EPanfZ+vRZekPotgweUQ72mNfhotZ89GZAimqGP+eYRs0GXeB30vn4epInUt
3Y232PfHOtRYM+3DNsOK7x1COS1vdzO2/ZWB6tsZe/7ksx8tJVh7FtjsbmDs
hwnv773Vzpymddk94jm1/5B1cRXTX3h7qW7lO1ctrX+eQujbR3MS4x+Iv3b1
2gTfOVphDtcXUP8cVzvQl/Hnn/bjHHd/pP6sdDJgx7PKt3URjP8hyGUyO56P
hW9jx/O3h+m9M4ZGMPEmnB3P/ROU2PFcpX9Ij/l9YfJBIfv77p50nR3PLXuW
VjPjAbZm9WDHc8/Ub/Z0PKtKzyPM+IEB32TZ8axYYmpBx/PsF9+fMOMNVGtm
suN5ZM+Xl+h4nukSdI8Zn/Ba+Qw7Pp9mR174T/eglsmOL6bjWen7CfZ9nama
7PuL+p87TsdzRkME237zjyh2PCupj3Sh4zmuKi+B2nN80z/judd4JXY89x2W
WkXtvzxjDDue1f08btLxfDCHZ0T7ezfGXJH2d8PsnEF0PB8+Ki5H/aOwwew7
9U/zVmV2PA9SORZO/bnvSTA7nh3mX6bxhPStDAQmnoCc0hNfGk/e+SqfpvH5
oUnDDyb+gJN9IRufRT0mudL4bJ0vv4GJVzDRqD8bn4OPWzvS+FybOHINE99A
p/8dNr7pRfODaXwedCpxMxMPYe0F8bc0HjpWZ2vR+By72NGXiZ+wQf7NZRo/
U0wixJl4S/bvfe3OxFvIuT6FjbeHvdaVHfb20+h6Dyr5YahG47NR+3gaz+F+
twPs+6ZHNpjR+FyZXHWPtj90vxzb/oagshgan029x+2g9qjbj2Hj84PlH11o
fG6eddOE2u+zJj6B2m8VOsCTxuf9O1zW0/6GyXSw8XmXd+QFGp8PjVdn/fO+
6g4bn11lm6xofA769FuL+tPO0dWH+lM5ZBmbb+Sczahi5kfokXToJJ0fm4a6
82m+Mb7l4AxmPoU6LUl2PnVvCKqk+caPoMG1zPwLdub27Py7TK/fBppvzPge
VcXM1/Aw9C47X5+pkrtD840Q5yEmzPwOT2Sz2fk9vF3iFs03GlRGpjH5APSf
d4vNBx6mK1fSfMNnosJ6Jn8AlVy7/jR/8CzcOiFijp9G13tQHz73kqb5RsbV
7+vo+3G5C9j3wxfeiKX5xr1+0am0/VgLJbb9ousdoWy+YXVqNbVnuf841p4v
Xrx9NN+ocd9SSu138nhuQO03+KzL5hsOTXrFtL+bPp0aQ/sr9mkrm2/8UMyV
p/6pMbBwoP5ZvS7gIc03TBsL3lF/npxnwuYb8ZHf5tP8+Uqwbi2T78Hu5eVs
vje76lRfmj8Xbjx0lskPQTTsGJsfxs463kLz50dFMw8w+SQU365m80kT6eoa
mj8HlU7qcVcmHzySwtj885Tz7R40f072m/+ZyVehbLNgKM1Xkw0cn9D8+b1f
0B0mvwXDhT5naX5r6jj2lyGTPw+ePGgMkw+DdasEmw+35N+p/U/3oDq8bNWm
+bNVLn80fb/72tRH9P34qoY6mj//Piq6SdtXUbjOth/7qd8Imj+nnRosoPYs
vL2btWfMEvFmmj8PdY2UoPbn/Hh7jNp/pBnY/NlB995+2t8einXqtL8B0fW0
voBExfwz1D8D1Cz9qH/G1j9l8+eCRcdrqD+vr3daTP2ZPLHZhNaD/sEVT5j6
BbQD8tj65dOhIW60HlTonZPA1DtgXWvA1jvO6c8m03pwvIVGGlMfQff+jmx9
9GO5JlsPPrhpEszUU5D4cjtbT920P7Cb1oN7VGaaMvUXuF+xY+uv7+9icmk9
6OvwrJ2p12DCyAUvab0W5vQ0hdaD5mus5zH1HYzK9oik9V2bh+zX/3QP6lzF
zeq0Hkx/+02Tvp9XOjqCvn/I7lIfWg/Gf8hvo+3bNUuw7Yf/dD5O68HRvqPW
U3tKr0iz9lyQGHuY1oOXumc+ovbPF/gLqP2RC86q0nowJDw+nfZX1aTkCO3v
5R/3vGk9uP+0QRL1z5sjkXeof46l3mLrwYdLRJHUnzVPznpQf97YqcKuF9UF
j9nA1OMQrvqRrceVv+2ZRteFThg+sGTqenj1O4Ot6+9leyyk6z/ujsfm+qiX
Av9+5Ha6PhCn4H2LrvM8MiT3zD1LwShuAbvOIAy/8pGu51x7b7bfsrQU5GIy
eXS9Quxm2mG6brNRwTqprG8ZnFTqNoCue0RN+dVA12f6GX7R3DilDKI/Hkih
6yeNvvN72K2/pdH1HlTDC5PG0PWWHQuy2feXh+iy74/wtfei6yqDxGPTaPtD
ZAL60/Zbxcxb6PpJYersg9SeQGNSTO0JeaAaTNdJvlWMY+0P7uP6gtpvribD
rocUBSXOof2NW8/bRvub12SuStc9PAKdLah/VkutZP1jGtNB/QnDtUV0/Q2U
EotjqT9bCm48uLiqhLiGrG10DCyHtuTV7HqIUd/fOnRdTtVhYb3BhAq4nXCd
XVfpsv4GuP4mLxF8hq6zec7b2lwjrIB4vSoRXecRi3A+TNfTLujWhe1Uq4R+
ZqfZ9aI4Ueodum4W8NBzCO9AJVQdyZSm6067jH78oOtjvWeYL471qgSbJWOA
rmudMnoc9N/Wwf7cgxo/ydecroO5nZBi3/9xPVeLXQdbxU+m61oXtcez7acN
XM+232X9CnD9qv7x2ht0nepKvXkTtX/a2E9Cav/sc0XBdD3q8A4XR9rf9WMC
bGl/B/iELqHrTqnqkxupf8Yp9P9I/bP6in3IoNwSgs/J35VUB81thIipHR8M
o4qI8Rq5caEPS8nzPROuewU2wsjQ5xV3juaTY+tblm90KCO7vVd59evJhyUV
imknNbJJc89Hvr10yknNrMBuCqv4cDbqutcc41TyeLedavK3cmJs7lDZw5kP
vqeHn+t3MY5kGGxaV+JdQaaM+bjQNIAPMyNdPmh5PSa9ZH7ObJxYSVzK+3ru
DeVDvurFnnTclnauK5Z3+vPunIjY+6Yh8PnE5lPJ3mUkJbBEdt1iJv6Hy+kr
ysYD2SOlollXRq7F69dHSTLxs2fIOG33VEjmKVdZjSsn0oG9pt2PYsbhhqHX
olZnw4dv59vzF5eTMfNnJJxdwQel4KOv/Hbkg+7F2bsPrSknpfle8/rxGsG+
YGD8L4cieCQ6pByyupwsswtI72/YCHOnOe33XlFKDmllTnhrUkRkogdJyOU0
goPzB+MzU4sJPlUUfmTdX8KHxZar7M1r8km/nhIWXu3F5JW8ucrBcD5se/rG
7vvnbHLjY/frfZN5ZIT+5JSvEgIw2/biyreqVGKe4mPaaF9CItp7OfRYyMSx
H8nOSivjyavFDgom40vJ21HvlnZnvuttL1S+vTINISVf5zs9f1ZKjKe4Tf9u
K4BxJV/YddfcLuuua7POvK8cEgrk2UH1iS3F5PCZ3NUfOgQwfFb05V958XBR
cfxLlxU84tX8+kNmkgDqzWJlrsikgcevMlOLqzwy8tAKWds9AuiwOa9R0zMH
nMR++pVl8Mjb8Y9yDokLwPLDkxH8QmZ+NYRu9+p5RMt414/wM3wIuFo7+FBb
EfjILF1f+J1Haq/MklnU2gjBy8Vs5nwpAfVJVnN4rTxyQYtnucSsEV5Kr+h3
4WUp2Vh91bkhKI9oeEoVTTbkw6tNEmkrrxeTqiGX8n4eySdOuffuGBXxYbJ0
jOPohQUEn4fK3j03WyIA09t6J209c8hlVSXpvT0KyaKZm+R3PBBAXHXdoQyL
NPJWLCDvS1whEX2d7CVi5uUfRf4yOuIJZNEUvuXz7UWke4GslqSsEA5IK7p1
HxpKVg9YS3qJFZMttstf2UwRwqDO9belneucEp3rnE/Hztw86lkoDD1i2DKr
XwHZ8cAwUum+EEbfrhL7dDABJu43nVJ5sIBUKt9TO7NDCCFp0wKMPNLAatjA
tUsyCgg5OvHR54FMHmKx0tvxQQ5kLnVW1+5XSGrB8umYewL4wDNaGTOrAHRG
vR8kBYWk6eHyIZPHMflqf5k6sV3FsEn2x/VdmwuJOLRVbL3MfI/6VabO+0ph
boeP2T6bQhJX6BigxMST4ctcl20fU0ZkF4+dN+dWJolYI7ZregwffJxXqR8V
FZPeA083pY9/RSomVu/SXyqAF7NJicizgFycNLbfuPvZRN/IVmFkmgBkvXV6
NI/MJfjctF8saO9UIdQfP6YcmZtGxrkJoi6ceU0ub5qof9BRCFu9zRMKfBPI
GDOvZZLWeWTxqPQHNeFCGHcrbqT2s1DyfFBjX1vJfDLmS+MWrUwh9Dg6Q57m
w8Zd1jkbHMSdM9XC4PW8aYH8/FdkzuVnU1yVRbBp3rlxe9oSYOWORTc8o7PJ
uRltO7Z/EcK7/tOfnP+WBjuNDU1cTuSQxf5pI17dFELor74Ceh/B6O9fcpkn
wXsJnu0K6DbSuQDul701GvA8l7jYrjNJCBDAEJU5zyyyisFig8zYfMXXJLq0
1lhqoABWif+ct6iyFCSDfh2YdPQ1OXrNTef3Lj5EhKcOGrWtjFyaenjzUe9E
Mk/8kCCgjwC2rzo2pZcqj6hfXzlhQUcSkWgRf3/jrgAGnzuuPSK/gLwqK5f0
2Z5CwjZLXDNQEkLxIKXCkPO5JNK70rI6K5XUNQ49uOyGENLq8sLfKqYTfLoO
dj5iJxJCpk3AkSMjCJGOGWYmYZtBrucv26gxRQQ9Blh6f1ILI1Ib5LqTsExC
XuQ0ZSwVQcAwXXadM7tznTO+c51z4jf/W5m3wiAkNG7S1UnJZJtg9qy3XiL4
dPRzy+lNBO4OHvfdWDGF1LvPnGe8UQR8zbgP5xelw8tZn8q0+qcSvfrfr/v2
ZOqR+XWWs6/kgs2qfY69K1OJI7SveX1NCBO9Lm5jxj2o9XBzZr4Dkjp0dRAd
/6eIeZHtcB4UVKX1eKycTubzJS2kmTxZTjf1kPSsMkjPUx7lGppOnplvlhO9
5kOvWFP9aZ5lJD3jTGp9XCTRTQpOi9UUwNLWC70ubOKRE5PE3lSoR5GLvzXu
dFQyeZRQwtzwZwGZ5z40ZFVmNFk4N+Tc0l1CGKpp3+RalEsO9JF3SzCLIc5+
TdOE1UKwqwzIF21LJ9Ob9p0c+zmOtIcXbrmszdTLd+vvmNkRgk8Hw8SGladF
oNvbesu7W0wd7fV6E7/pJTlgci19+EMRFBedZ9c5c7usc/oWrzv4uzwMhvNM
6wNtnpL89bFa74tFoG1pY97Tn8D7neah164/I6a6Bbo9/UUw22ryZTiSDqPG
7wldc/s5efzo9kWnFSLwmjiuz4OKXLDtbbp716kY0n+T3JSOKiFMVTY/X/G1
AGpk3F1ateJIgmTCgzcbhaCiNC6biftwpExmPTMPEDfzHe9p/Lf3WlffcagM
ZpVufb5sLiEhsebHb8gyeWPah40t98rI6uZWhQmrTxCp+Y75rqsE4Pu12nn5
IR5xu/FGLCTDnTzbH5S98JsAjsW8la4bUEhcks4/ss32JppiM3SPXmDq5VNF
B079yiXLR514dMfNn2iJadwz7yUChylJX1ZdSCdq1x2thxsFEMXS8eO2WYsg
SlLDJOoxIc8n2pisGBVMxl66+vJIlAjaf+zJ6V0RRvApSex/zq8SwcLO9Te9
znVOt851zjvT9rQ8F4WBt0vqDh4zytoOn6p8LhLB456FUvKxBFo2vxAUzPYk
Pyd8eXqWiKD+Ml/9tFs69Ll/Vip1tA8Zqy+nNPKACG6WDpOr+83U0Zr6p+0q
/EnkqJy+/Rn7MyOG5A2QKoRQo1mDGpoekDWy3hE3zjDx//xZW7c9PCjLX+r+
ISuIHFWr8djJ1DU+oz87M/kNKO+Y5MzkO+SkfrEMzXO+dOY91zrzIMx/rg/m
7WXaIef8v2Yz7YDCtc+etB3L9X0zmf8veZOcsYL5/8LU32cj6f8302DLQMZO
sutSQCJjJySqXulH7dxvJVBk+kWyS/tfYvoFw0gH269HtXU9GT8Qd2ViXTjb
E1Q8frN+WGLGe8r4jUTly+4ogVOw4fNz1m+zjfez68n4xHVO9bLHEn0qwv48
lxj3Y3+XlztqTJnfEQxkrl9hfkeQatNmf8eyZx0/mN8den649Yj53cGgzXks
/d31dHVPMOMEltkXf2LGCVw6pnKXjhPFfQtHMeMKWvyOGtple8PUmquL6Lha
A9svM+MQ1CcWHWbGIfRdbPGKjsOaG/GWzLgFwwU6U+RXn4B9Ic2v6biVPeH4
iRnnRBQdX8qMc+jVR4Md55c686HBnfkR5kUWD8Mdme+IjMkRj2e+I5gjVRxA
vyPDqxo/71fkkoXfb7ow3x0Eqtxlv7viXdfPMN8pMT7fL4n5TiE/o5D9Tt0C
IyYy3zVZ+KkHj/muQbyHxhL6XSfOeaDCxAFSbDW3x0Obp8A78YSNA3oX7rHr
nIe7rHN2VO+5y8QZ2Hby/mYmzkDdsyVsnGlpnsBj4tGfp3CKTD2NS3d3bi9n
4hgEdy+KZOIYTPv2xJLGsTcavmIXi3Ihrt/bx0zcA3mz4Kk07r0bOseSiZOw
0C83i4mTMCTn4VkaJ49aqAxh4ipsbDw1rFI9CvJOqt2icXXfcjdDJg7DiT6N
1UwchovS2qk0Dlcr1O5h4jaR9u0zhYnbcPjVRzZub694nMvEebIj0kaOifOw
ol/JJhrnMR963JkfYV6U2G2PATOPEOfcS17MPAKDnEzX0nmkx40VRcy8QyJu
Wtcz8w6suDAgj8470dITBcw8RVqG/frJzFMQMmwSO08d+HrbjJnXSNSMEl1m
XoOo/RtV6byG62+8LuucIxv5PGbehDky3Qcy8ybc+fXxC503nbZ5hTDzLBz2
vLqDmWfB4lXLejrP+lS+TmHm4z9PoepDOzov85YFVjHzOKhF+B9h5nF4vUx3
P53HQ6/1WMLM+7BzfsEwZt4Hh6c7r9B5f9qnR8pMngAnTS7OZPIEWB0yr5rm
CaOHuoxi8gqIUsm0Z/IKOCQY30Dziik7dVWYPIRUngs9weQh4HNbfAHNQ4r2
q4QxeQvhHWiaxuQtsDJ+7mqatxhFy/8Y4VxAzpSP2sHkOTB5zGw2zxnTmQ+F
dOZHmBfdeCZ5m8mjyBmjHruYPApOyJxl86ghISDO5F0k2nVDIJN3wYDt19i8
q1BxnB6Tp5GJQ+Y/Y/I0OJc8hs3TZBsT6mj+nN1lndP3et91TB4IP70/SzN5
IHQoRFvSPLDf5LsVTN4Ip6YeN2LyRhi4dtt9mjceK5unzeSZcH3i6mQmzwRx
dzM9mmf2HjZBlslH/zxXRZwNoHlpRr13BZPHwmaDJ7JMHgvvT/SRp3msn0hT
h8l7odF+dweT98Kb0h5WNO/dkNm2ksmT4dBha10mT4YeVhI7aZ7cFvDbhMmr
yZmsi9uYvBrSFXzZvPqLb59qJg8np48r+zF5OAweM7iS5uHJ/j2WMnk7OXh7
tCyTt8P7GmDz9oyzOqeZPJ9USEktZPJ8mPT0Epvnq3fmQ5gfYV4UNeRM1seD
CcRyr+Q8po6A/qXu82kdsee84gSm7iBpfRx/MnUHCLcej6B1x6+rR9h1zo2d
65y6neucrTNN2pm6BpKa779i6hoAu9gMWtfIZY2cw9RBsHCT5VamDoJu5Vs1
aR3UZH/1JFM3wfBasRKmbgJvSQcPWjd9ulB6mamzQKNw5FCmzoLeF/pPoHVW
Q1n6OaYe+/McohwfReuyR5/f0ToOXo2SLGHqONA2Pu5H6zjVQp9BTN0H/RIO
X2LqPtg6XbKA1n35prP2MHUieeOnp8nUiVDvX83WiSqypf2YupKYL5lhwdSV
UD9rFFtX8sr2DGbqUOIwZ5IkU4dCZNEktg4tXHR3KlO3Et7F9wFM3QoJ3pps
3XrrZ70YU+eSyq/+m5k6F8qST7J1rlNnPjSzMz9y78yLNgZ6PGDqaCItNmcB
U0dDXU2uMa2jo280ttB1zpou65wvyjynZzPz93lt49NMnQ4al6Wm0Tq9/ZUq
Yep6WPTpwEymrofqV5d0aV3f/eniu9+qUkG9r4RFo30JPBU+O0rXAV7IHTr9
/XM2QFGSb99kHvSX0kmi6wZ12++fMK/Jh1HCm5u92ovhSMLgmXSdodpu9Loz
U4v/PK9Kbsuk6xI9fG/Yeq8ohS9BMye9NSkCvfRv3eg6hvfC6sf1W0vIqblO
NoMXlMP0WWP5FnENQGz7PfvlUETGPu6uGrK6HCbstWTXQxZKz3/ptyOfHOy5
6OChNeVgl/WIXT9RvmvmHLU6m0yK7CdRsLgcMoU34ul6i++S3oO13VNJkci2
xmpcOdxpip9K12de20orKsrGk/pNW2dr1pWBXeoodj1nVmc+dLMzP8K8CNff
bLqsc55SjVwGXo9hp94hjcaJlTB2pbQbXV+6PF3hbr+LcVB21nV9iXcFxHRM
ZdejDmx3eDDHOBWKx/PVkr+Vg5T8+zK6fnVzeHXpSY1seDzP07+XTjmM1l7f
Ib+KDyNk9lffOZoP75cPNd7oUAZ57Qs86PpYrY5RvWFUEbRKKCiGPiyFnIAe
V+l6mkHLrVDqz9HL0ncx/iRrlo8TUn+uSwl+wujQT1a4h+qS07RZP1/XW/tk
UG4JLDtz4TFdr3t2ZqgKXa/T6/z7aue/j+7U16c+CqV/4/OC8B6rL8jawbZv
+9JkH/0dIeFbI22/y34zwP1migbDA+m6a6TMwA90H9pi8cF1VP+fdk8gp3M6
p3M6p3M6p3M6p3M6p3M6p3M6p3M6p3M6p3M6p3M6p3M6p3M6p3M6p3M6p3M6
p3M6p3M6p3M6p3P6/1v6/9f3VXI6p3M6p3M6p3M6p3M6p3M6p3M6p3M6p3M6
p3M6p3M6p3M6p3M6p3P6/z06cuyQa4c8O7zPBe93wXtdkB+GPDHkiCHvCvlX
yL1CPhPympDThDwh5AshVwj5N8jDQQ4O8lqQ34LcFuSLIG8EOSPIw0A+BnIx
kN+APAfkOCBvAPkDyB3A+/Hxvny8Jx/vc8f73fFed+T8IfcPeX/IBUROIPIB
kbuGHDbkryEnDLlhyAtDrhVyrpBvhRwm5DIhjwm5QcgRQn4Qcm6Qe4O8G+Sy
IKcF+SzIEUGuCPJEkHuBHAzkXyCnAbkNyGtArgByBpAvgPfg4734eB8+3tuO
97jj/e3IR0ReInISkaf49/3ujYAcO+TaIc8OuWvIYUP+GnLCkBuGvDDkWiHn
CvlWyGFCLhPymPBLQ44Q8oOQc4PcG+TdIJcFOS3IZ0GOCHJFkCeC3AvkYCD/
AjkNyG1AXgNyBZAzgHwBvAe/q9+QK4mcSeRLIocSuZTIo0QuIHICkQ+IHDvk
2iHPDrlryGFD/hpywpAbhrww5Foh5wr5VshhQi4T8piQG4QcIeQHIecGuTfI
u0EuC3JakM+CHBHkiiBPBLkXyMFA/gVyGpDbgLwG5AogZwD5AsjjRD4ncjmR
34k8T+R4ImcRuYvIW0QuIHICkQ+IHDvk2iHPDrlryGFD/hpywpAbhrww5Fr9
zbkSAXKYkMuEPCbkBiFHCPlByLlB7g3ybpDLgpwW5LMgRwS5IsgTQe4FcjCQ
f4GcBuQ2IK8BOabINUWeKXJPkYOK/FPkViLHEvmVyFlE7iLyFpELiJxA5AMi
xw65dsizQ+4actiQv4acMOSGIS8MuVbIuUK+FXKYkMuEPCbkBiFHCPlByLlB
7g3ybpDLgpwW5LMgRwS5IsgTQe4FcjCQf4H8V+TBIgcWebHIj0VuLHJAkQuK
PFDkViLHEvmVyFlE7iLyFpELiJxA5AMixw65dsizw/iMHDbkryEnDLlhyAtD
rhVyrpBvhRwm5DIhjwm5QcgRQn4Qcm6Qe4O8G+SyIKcF+SzIEUGuCPJEkI+L
vFzkNSAfF3m5yMlF/u7fPF7+H/4u8niRw4scVuSyIo8VOazIZUUeK/JEkS+K
9+0jTxT5osgVRS4mcjKRj4lcTORkIh8T+Y7Ie8T7dZHviLxH5DwipxC5hcgr
RE4hcguRV4i8PeTvYZ6MvD3k7yF3D7lxyJHDe5WRG4ccOeTHIf8MeWhoP/LP
kIeGHDTkeOG9wnjPLXK8kOuFPC/kUSGfCrlUyKNCPhVyqZCrhJwlvHcUuUrI
WfrDV+q8NxN5QXh/JvKBkBeEnCDk3PzNveH/4dwg9wZ5N8hpRm4z8pqR64yc
Z+Q7I/cXOcDI/0VOLXJrkVeLXFXkrCJfFTmgyAVFHihyK5FjifxK5CwidxF5
i8gFRE4g8gGRY4dcO+TZIXcNOWzIX0NOGHLDkBeGXCvkXCHfCjlMyGVCHhNy
g5AjhPwg5Fsj7xo518jD/psvxP/DUUauMvKUkfuLHGDk/yKnFrm1yKtFripy
VpGvihxQ5IIiDxTjM3IskV+JnEXkLiJvEbmAyAlEPiBy7JBrhzw75K4hhw35
a8gJQ24Y8sKQa4WcK+RbIYepq9+QC46ccOSDI0ccueLIE0cuNXKqkU+NHGXk
KiNPGbm/yAFG/i9yapFbi7xa5KoiZxX5qsgBRS4o8kCRW4kcS+RXImcRuYvI
W0QuIHICkQ+IHDvk2iHPDrlryGFD/hpywpAbhrww5Foh5wr5VshTR746ctWR
v448duSwI+cbud/I+0YuNXKqkU+NHGXkKiNPGbm/yAFG/i9yapFbi7xa5Kr+
zVkV/uGAIhcUeaDIrUSOJfIrkbOI3EXkLSIXEDmByAdEjh1y7ZBnh9w15LAh
fw05YcgNQ14YcuiRS488euTWI8ce+fXITUeOOvLTkfON3G/kfSOXGjnVyKdG
jjJylZGnjNxf5AAj/xc5tcitRV4tclWRs4p8VeSAIhcUeaDIrUSOJfIrkbOI
3EXkLSIXEDmByAdEjh1y7ZBnh9w15LAhf+3LziXGdF1OwaOjF+XdfXxZxa4v
IW8e+fPInUc+OvLSkZOOPG/keyPXG/nTyKNGDjXykpGfjNxkjMPI+0XOL/Jo
kU+LXFrkpyJPFTmqyPtE/idyP5FPibxK5FQiTxH5ishVRP4f8gCRA4j3U/99
X3UDNF94ua3GpIjc9jBb77eilMyzOHBlVE4jfPQzef8tKI/kaf+YfuVlKekm
o++laMiHs07SoetuZZKpfj0NbMeUEVFZ+ZzJMUxdk5Trdcc7kfzWiotT3lZG
DEqvZvv3EYDB0HlrVOIjScSsdec1PcvI13Dv6GhNAchlnrPwNTlBBKpN8Pte
GRldRm5eYPzWoEuCZeYSWHQikN/Hpozc6Nbw5ZqsAOYcD99rEZoOE0I8DBVm
lZEtk0pnCF7zQSGidXPrkddQ0Vdu0MbKUrJocOCLX7v4sPvT3SNrbQph2xDX
7rf3lZLlnhYVE5l4aC8c6JPcyoO6Rfblel9KSL5Ox0J67z3ez473teM97byr
4rG9j+aTj5EekubXi0m9u37vFUV8kFQadeXn+FdE1+YT311UTPTa/NsXLGXi
zNu1Ymc6kojukLs+8qo8slRrQqz7XQH0VFpqZaYRRUJqC10ebOKRc/tul36v
FMDeX6a9+mS5k+PvbAIsDvFIjmdtT+1vAui2eeVjJ+V0GDP33FDX4Twycr1t
8EAmXtl9C552QfE1TF5cFn4qq5i8X6Gc3m+gAKYkrV+1aHMhzJ4+YpfirmIy
a8xaI8pHyNW0fvvkO/Pdqm7V9GorIjOfmjjT+/yNfg0w9lldDhnpkYUDHItI
okHUCSnDRjiZ3KhocD+b2HVMc5fwKiCtEGs0NE0AD1Z97V+zPYXUbR9sqpFf
QF77+0xdpCSEcWvVjjZlRhMxmzYdm58FZHbAxFydXULQUHIeo5PrTaQdVmqK
DywkVzXTX9tcEML86u19ecy8KOiRVT/HuYB8VkgLjQ8QwMn3I3JrtQqhT4bX
t/ezCsjNubUWlOMwPfzmmGP1PPBay6uTLson0lm2RpFn+DBgkPwaszXlMDd+
huzzHfnk3IBZD/rzGsEqTPLxsFepZJ6+2Onq87nkgNX+ssU3hBDUkTxmg3kM
SdIJ/FRclEtW7Dc59qlaCONfuA/ydvcn3teqvsT9yiVfoXbfhl4iWG2x3E6+
XyGM39k4/NmDHDJ44T5PuXuUL1Ar+TyDBz9iNz9X7pVD7HsFvrEVF4D7Na3r
sYvLYXp79Yy61dnEb7NZmvMKPtQ/Oxt4/nMc+SbfP2P89nSy1dvruIu2CMZc
7uvRbBRAPK0zZzlfSCeNDw/0tLRm8mSd52rLrvJAXTjuWpJMGnn4Mv673R4B
dN+9YOHaceVQNPp7393uqWTGuxPbA6L40LjkmHrpqGAyeMR+q7bHhDz8EaB2
OIqpszasW6hSVwY37/e3Xi8bT9IW+1+MlhT84T76d+Efae+X2KnaUkzm7rs4
ed+QUDAzvH++ukMABe9+tC3rV0BWf27QM4kKhZPjxIYp3hfCuvzFXycVvCIJ
cicXZM4Pg3mfpBLPK4sgxqSnfQnlmcm4mcb6hoFnXm1CpZcINp/SUx5l+5Qk
GPmsGVoeBpJfFdqri0Xg+SJy4cAFp0jQN3PJKaIwSKwftOaFSAR7x8zck9X0
EkaLxD6Z3AqDGJUnh2QfimB3Tc40l7BMOBq4YlI/tTDoNZaczl4qgvPz5NTX
SeaD2tAHvnqMnY4F49YuzBSC8rjPc4UdRTBh65DmMUy/dqk6jbWfIgQ3rzyJ
gGelcF6VrzKG8cNY5Y1xv2yZcT7lWEb1xEq4FCarU+35GByuP9I6EMr/w3Ec
3oVbdKRxY2jzwQIy5mzwhFMHEyC56ZbmqR1CsKgXGNdGZ5PGHUq3E78ngJGv
kv7WL0KYO/JbQrRiCtn69P6BGHMCkvkxpkYbRTD82VRfwxvPSI3HlvwVdxjd
7vqQXv4iqPaS/xAw15PsvKxVGM7UUxUhx7SciQh0vdJu5dtkQHRvj5cDRxAQ
HNxqpz1FBI3aOx5/2J0HYSusP871TYDK2DtfG8OFYPs4d8SV7UWgou4H/t0S
YMv7Y9UDZRn/bB6xc/74UpigJtEeaBgP7Qcm/ezD1K1zhdsfZnhXQHuQ+8UU
1zhIUjThWwTwYWcnPyi0Cz9o9tsBdekncsiGPMuCpd/SYPv8hrVZNxn91L4v
d/qnkusHVS0nLkoHBY/f8/r1FMEc+QizcX7PyaEgx6DKw+kgvXVWxPEVIpDI
vmX5Qc6H8Pk5oTpu6VC5Y0jq6AMi8JE+umzNmdfgcn2vnFNuGrT0uz/8iCNT
NwUuHZYXVwipQwyqj1ukwX15e+fvTP78dPpE+1z7EgAvWe2oqlSY/fCTsdRC
Jm+x/tDzybdyeHZreNYA41RQmJN1rK8z/w+nMLQLl2dGrNklvcpUsthqxYDv
XrmQOTVlQ941IUSn3vEZdjqGzN9U0WpUkQtuV3r+6sbEkzOn7RwPV/qTPQVm
LsG/mTj3UVl7IBNP1E4H263vUQgSEvN99T1zwPeUktyeBwI4vtN+ZksSD3of
PDA/9XM2vDmre7FdQgCzdS8LvmuXg5KYeOQmjWzYZBJ0fvIqPszv5NcodeHX
LDUIuGkKcSTp3YEJKV8LQMs/vOjdRiZPXpB5MaL5ASlUSpZo618IYrd+hPuc
EcKOtzYzz7UXg9dSqQcra/JBXiBfbRfOh5uLxI1XOpRBxLnA21eO5kPuhoQf
A3sy9Vont0WlC7fFbkbg1lWvgsiMNLONp/fwQDg29PAuJt8+bNVX9+HDUsgd
FxK6NKoIBizmSV0LbISpnfwRny78EeR5IN8DuR7ILUaOMfKLkfOB3A/kfeh3
cj2Q+4G8j878h3TNf5DngXwP5Hr8TzsPy+mczumczumczumczumczumczumc
zumczumczumczumczumczumczumczun/Z/r/X+eOOZ3TOZ3TOZ3TOf3/Ht2r
cz9uU+f+XNyX6xndQ+fhw1KysM+GoKVRRcSzX8tAuo9OT8bYf9WrIHi9PHT1
6T08ctch5gjddze4c3/qpc79qrhPVV+/evlKhzJyYdjnG1eO5pNFrdm/6L4+
tfFvp59rLyZ7V8feXlmTTxyX7HtP9wFqlZplRTQ/AOOsF+3f+xeSZ8c/RdB9
g+PlR+aYQhzYlCUPT/laQJRD04vpPsPgzv2guzr3h+K+0PYJAXXftctJDxU9
v00a2URFs9WF7mO8tS92SksSjwhEFcqpn7PJ0aTpl+m+x7ee0YfW9ygkIWkP
L+t75pC3avZj6T7J260FMYcr/YE3/5FD8O9ckvujmd1XaZP4LmbY6RgQkG91
RhW55PKWC+w+TCOh/X29ylTobVX0vdUrl+RZTNhI922GdO7vHNO53xPzPWmT
PR2R38qJs6Tq8wHGqaTs8paTdF/o28XELte+hJRcuaQSVZVKAm7NM6H7SF2i
hAPy4gpJioVf4XGLNDJi0OQLdN+pZ39prTVnXpOmHU/6OuWmkdv1e2TpPlXe
10nVH+R84B0vx1vHLZ0YvG9h97WmbTM4MM7vOWx63OhXeTidrDxkxe6D1alp
EfPvnwqWGalGExelk/1TBsyn+2Ylh6f/Sj+RAzoz1OOXfksjBYEP2X22Ezv3
g6p37g/FfaGmx9QCM7wriNqxU/tTXOOIhHF/Ad3HG/Zwgun88aVENOBKaqBh
PLmRaP+b7vud+mWt7JXtRcRfTn68f7cEktek+p7uEx6xzeHBh915ZLqXUuZc
3wTifky8le4rdnyh55Vvk0Emjw1wHTiCEDeL2MN0H/Jhn6mWgXM9QbrE6FV4
DCEhYy6y+5YDrXjJhjeewc/ed2+uuENIyYRuQ+k+Z03FwqRoxRSYNqPEKsac
kOKVkey+aLFuEltqo7Mhua76WOL3BKKYk7qU7qPevb1XbPPBArgwepXg5MEE
0n7PVYPuu57ZuT/VqXO/Ku5TPa/YM6F6YiUZLGwurfJ8TAYMvq9D93U360T/
fvCslJRXubaNNg0h6zMq4uk+8LCou1OEHUVE9lb9mTFDQkmZ9IAJdN+4x0PZ
Wesk84lnrYmFXlQokfdZs47uM19S0jDOJSyTNCqmNvZVCyNurx+cofvS859t
3J3V9JJYjfodaHIrjIwo7mZD97FbdfRcOGjBKRgxISNjsiiM8DfpsfvePzuO
0xtl+xSIQf2woeVhRGHkGHafvGmt3PWSScng3u/yqFjfMCJn0pfdV694Z6XE
5IJXcFLg1z1zfhiZJnv4Jd2Hf8h6YjeDfgWQ4VDVx4Sx89Xb6UPpvv3nUel7
VVuKYcJWb8Fepl85ofed6T7/m537cVU79+fivtzSznPx/8SnWxrlneeUczvP
1yuva/7rfP3SznPxE6Vl1R1ibmtIdJ6LN+48/255+EPBAG2/P+ffszvPuV/c
oceec4/vPOee23mePZO4/HWeXa/z3LrXtD0tz0V+Gm6d59ZnG+9nz7HjE+Pq
4c5z6B+sH/x1Dp3Xed58XUlQbAz813nz7M5z5R+vRl1dH3v7z7nyjZ3nxw0v
2rPnx3U7z4/XdJ4Tb+4paPnv58RtO8+D26hGLgMv3z/nwV0SxbVV6srI5vOy
7utl4+HH1NfsuQw1rTv2paOCYdbZ4QfaHhN4b2XEnuOokG7TWjuunDhO8h2x
2z0VVvhmsec+Inmi2cuu8oj54paQJJk0kDrswp4TqZ077XWzUQDseNRLy/lC
Oogl8HrQcyV78xtLz3+Og/bwnLzx29PhcPqhY/QcykpejHvs4nJS9sIb6lZn
Q3VQC3tupWr+727PM3hEJFySrtwrB2ZdGvyWnnPZkpO2V75fIbF3aJv67EEO
pOcuZM/F6HyoXeHt7g/DlxmJxf/KBa/Yir30HM2pEieNDeYx8HJy5tfiolxQ
niLlRM/d7P+cnTjsVSpUDjvuXn0+F64V3ymh53RayVBDszXlRK37AfnnO/Jh
6bDR7Lke15Tw4cfqeWSPxajP0kX50LjoGXsO6JLZu7RarUJy6UdV+/tZBXC0
tYk9N3RXVqm1ODqXtDcu+zLHuQD6H6tnzxmtTz2RrJPrDbzHUbriAwvBvtfU
XHou6a5m07WmzGjIHDRZ1+ZnAcismpBDzzFdvMYfWbM9BYqtvC018gvgcHPH
FHruqdeVY7MM7meDg2XvKxJeBfDdaeUqek7KVfOEgc/qctIxIbp8gGMRLDBu
Y89VXex3tuTJdx4ZEHpgkVdbEUwYtJc9hzV840T9RZsLyU6fiQcUdxXDFnVN
9tyWTXW+3AXF1yRG7E30qaxiyN9enkbPeSmfvufppJxOrj2cO9J1OA9+aQWy
58KGTDI+1ifLHTTHtz22OMSDz9t8e9BzZAM8X90104gC37mO1x9s4sGZzz7F
9NwZEXpJnelIghjJ177yqjyQrVoXQ8+pjXKU8P85/hW05xU2uYuK4d6jtJ/0
XNuBEKfE3kfzoWrfnt7m14vhR29FSXoOTuHwzCvJrTzipqpbrfelBJIqm9nz
dC5ZEfvX2hQSww/WfW7vK4WPOjrs+bt23mLj1iOvyRD/wuEbK0uhVXIWe17P
u6Ngk0VoOjlx6YCJwqwyWJtixJ7vGz9om6vMXEJEgtPCPjZloHy/XxM9D0gm
lGy7ZXIC6mdl6/6+Vwb+OnO96fnBUbxbB1XiI+HwZZdLmp5lIOg37Rk9bziu
Wi7kjnciqMOJdOVtZVD7ZnEmPZ+oIrcpbt2tTOBPtV1lO6YMVla9nUXPM+6w
m1v3LSgPlv5cMvvKy1Koi1roQc8/Dm9S2l1jUgSKv46Y+60ohbb9azzpecmr
necNlnaeP4juPHfwP21di9M5ndM5ndM5ndM5ndP/z/T/aeuHnM7pnM7pnM7p
nM7pnM7pnM7pnM7pnM7p/0/1u537kb502Y+kJN5jgweUElg656pjWhHZOT3G
wT22Efb2bjWK/hkCW/rFBKfv4pGqWPjVo0EAw/9lP9JtR4VvjgGlJFn+/Nhp
N/KJ0qtYi4QZfEhZEhl93bWYjMqOuA1N+UTHZlzOu2Q+WLos1xznEgru8RMk
bHsXkqfXlR/wnYTgolmlJ22WAN3utd32/1xALkRF7TyxWggh/7IfqWFn4OyT
v0vJhLyoOYNcsolr3dy9wit8OHTz+9LZlcXk/L6WtvFjc0jegNWJC6cJoPh8
Zre7LgVE8Lbi5MjAHGI7Y9Rel2gB5KeXqp2UCIP2sfkBMi25JKAwN2ZDuxCG
p6u3WhYnQGjHnKuns3KJxDXj9PZ8IXic85CF+jQ4Obf9dMe5XDK/tVZhpasQ
Qv9lP9KxEWp7Ti8uI7Eh1j/3308lDs0DfUktHz5eDFLZMJpHDHJc6mJk0si6
hdYrZ50RQN4Mq99nUwrIKpeRiodPphG38KG1i6SFYGafd+jEsVzya3NPmUWV
aSR7stP5QxeFoNpryJCwHWEwIe1qu9zZdCJe9H17wVYR+FmOKCqfQ+DTh9oi
sjWd3DO1Uy2dK4I1sdO675uRDi9XbeiuMSOdtHnl+XkJhTBrlsxjOedcuHut
zml0fRpRHCwRbej67/uRtHkQEHG0jMi8mLBupUw8uZA7x3jCOAEcfVE5asly
HpFw8PaaHh1PAsWfx+9JFsCJZUs6lEQFZNh4xZrdugmk7v7ypKEmQhjmIRE4
OT2XWI0r0o9NSiAfTtwsdioQws6xOwt6bU4nmbbDq38qESIjvkZVY54ILtTY
R9eFh8Hs+1v38h4Rcn5je4R2hAhqSp+7ZR0j8PSMpZv1MUIGXD/ef8BpEVTP
DLrZtDUdcsNT5Q7OIcT/jK1tCeOHZd+2BYRk5cIwm43TJIsTiNHFKZ6/mN93
YPuQSyGfC8C0QSGqwjSBfPpsu/04Mw7xvjzHzv1Ibp37kWSy9rbdZr6rT+fd
4BGEkEViv2SdmO/Lcee8Sl/m+3GUSl7apzqEiB4tjlRivqMRj5qnLmTGfcT2
X01+B0PJ6EpJYd9jjJ8XuWs+aM4lZ4JrJvT/EkrCdXw22zLjcPt1SVmfM+kk
bImV1cj1YcSb5zDzE/P7JlzY9DkgiJDfK9VTPgaGkRCPI/tWMH4wmadv3/4m
DNx625CoN2FEXPKc6awqEczaua9hYDABp2sz5x8MDyMDiqO1qN9GT/48Q+ds
OozzODVNfkcYWbxeuCWfaT/AWmrE3JZc0PdoPfOzexi5PL1j/XrGngktn9ac
6F0ImqFSVtEXQsnLz9H6jcz3K9bqdz1nFw8STOTCHX6GkByznqNo3PD5l/1I
yDmbvmdAE+WeIe8MeV1zDW1eU34XcruQL6XYuR8JOVPIQxo5cOo9ykdCLhLy
ex7EmwVSng9yfJA3s2e50nnKn0HuDPJRPDv3IyEnBXkY8Sae4ZSPgVwM5CI8
MnGUERPJaSEfAe/xx/1IeJ8/3jtfeLmbkN5Dj/fP4z3pn8r3rqP3puN96Xiv
t72l4Ba95xvv98b7qXE/Et5TXac6Uk3VvowUvGvs6aEYD22GZr9zxgpgWEW0
uvLDMMh4aGyVEUTg1d1V95czv/u7abcfmOuWEb0Lrq7zglMhxuqspRYTl4Yf
Cwi0leORADvZ7T/l08DKNNlI47QAPh6f0O6yPgySEgOSnp5JB++7Ry/XMuNk
XIHYqBmTCNh8f641dnM6+KVM1VJjvlMvoU5KeEcp6elzYo6hezZMFnupp8fE
59CVo1Nk3hWTbW9mPdg0JQfUa9fd6jFVAEF7wCHerYDMf2b43DsqB47Fv4jm
RQlgkjLv6sUvoZCSFhL2sjkXYkOTpxxixuHU14akd3ICvOmb3WiQngsawz8c
sWfixpHWFdvNK9NAZfbWJTeO5UK2YVvefiZOHi5dWNMWWEq+P5C/9+1mPtzq
NrTq53Q+GCmVF01zKyZNJ2e7qLXmw4Mdl+9bJ/HB1rbf4l1LC8ju8NyW40sL
YL9pSYslM25Pn1Qsto/KIRG9d3x95VYAka/7bqF2psZoioYfCgW9PQsGGDLf
h8acSz69me/aWOGHZIJuArRHZm2dLyqAzS+XNg5i4p5GbOwRn5NpcJd4fr+S
UgBfzWsrtJk4P+rygkUzAnNgjHj1gGCXAvi0d9gLZ2aeqv3uaGisU0o+fZyj
X5NRBLt27EuOiWmECKXSA9Ezi0mYWFL3zJnFMOfmu3gpXT40W1SqK7Tmk1CL
WxEL3Irh+EhroP1S+/Uleu6UHNLzTveZk98Vw5EisVIJxv+rEyKeV8unkYsh
/6u9c/+qOW3DeFReJJmWrEgHGUyHKXRg1+ZOKDMJOcREFNGb40KGmnQQSTXa
iSIlpESpyHQij1M0SmTo8Nau17HD3jk0qEi917OZX1r1B7xr7V/v1dr72/Pc
93V9rmft9X1OmgfqVlBubE2ENfbdYbnYz/PpBZpKDy2TMd8tauG3x2Ou55hJ
VLfnFpJEt3riIscKGtWivGk9dH64+3KTWs07ZCjIXrNOu4K6Ptj7TISvmU1S
1Rbq3ae9Lfkd02ufkGmczyob+HJgXKOmXWs5jXUXayeEPyGpWsZdMThhzrff
3xzt8f5PizK/A9XFj1lRaqWj64wqWnOzLJavQ2Vxy/PGuHJ2p+F9sXJqFQlM
izbw/c3fmX1osqiUBX00X3q1u4rO3S4Js0cfZuXFz9FLK2KHO10rPe2qqYua
9kxD/xttHmziPb6QWZWqrJ7qW02WqlOc+ByV/JzwTEwXKM64ZVQS9OziIOPu
39APKorpGjs1C2nc1fjbuT7VFDC0zX0MfLDpwR/T9p0pon0PQ18cmF1NnlPX
USE+/0vC0cX6YaXkIQl4GtJVRcGOLrpSPE+1eHe72dFyirv8XicopYqsdoYd
vAqOijfXWxVw5zEl120XRRP+XtXCNxKcVhDt5YI6W9GhEIE6G9Gp5sfrCiYF
rfgcZpucPRKfw/68GSPin6MmOG2H72XmyhNq8b0s5ozHGP693atijfCc7O9P
f9biOVnIf97O4M/ZqKHW9Ct8vTTl5RX8X+x7rSgP/n95t188jXVg/14+bTjW
gc2Z+EzBD+vg0Dm0tbf7Ky2co+ZhPUn9/pZVWE/2uslOtp6L0p2WYv0p49dh
f2H9WVKaQTBf/+bYoFPYL/LJDV2A/WI2hxeH8/2aJ/giwf5SnOXom9hfZmvX
fyPf33cLDojQDxTrMdQe/cC09rXL+mHrjih19BW7YiQYjb5iNs0dxbyv9PRV
hqEP2ZmLuz6gD5mts4Y778Myu3Q99C17o6znhr5lQ+bG+vK+HbD687Nt4JiQ
85WG6HN22at8M+/zlf4SbcwFsy1xMcZcsGN+9Xf4XDgM3fqgt3sn73aEPsJ8
kcaHMSaYL9bUViubrzfXve5hHunho3oDzCMzaTeVzeOu0AkzMb+0KSnqPOaX
GUXGyebX4E3DLsw7HRVe6izG3Iu/zfvn6XbO0AfSXGs4E/rA1ibPlumDbv1k
C+gJyw+2UYGesPZUVsD1ZGb9+/XQHxY7eGQr9Ic1dkWIuf4UZOZICsFne+zS
3KBXzHDuGinXq6S/ohKgbyzGuEMZ+sY2lDolcH3TN+x8NT7nhLDn/Y/e9a4S
6CTtVfokhU4yx9kdq7lOHq9xmQtdJSXHwBboKlvh+lVXFze9rIEO08AVzXug
wyzmwyqZDk9zHy2BbtNP2zSOQ7fZSUllPd93Y/XQhdB5FrHkqQA6z+wbCx9x
nd9uPj0OvsCWmVWK4QtMoubsy32hxnDQL/AR9l3NklPwETbv+Etj7iOBpw2T
ertXccim9GD4Ee2zH3kafsTmCUtlfiRdOqME/kV2OoWH4F/sbZ6BzL++n/T6
HvyOXvpcmgC/Yz6Tpsj8zqJEtcHUgDETXcFk+CN79zqGuD965+kx+Cm7Z789
H37KFKrGRXI/dYtccba3+welonEZ8GUS9bOdC19mH9/ckPny8ReSc/BxWu1Q
4QcfZ4L2WTIfv5+V3WmUmsm2fMl2h++z6UMyZb4vcJ4Q2tu9e2rSHCH4gTyf
rH0lgv69CXCU8YP3o4Xgn0Thhh73x73r4/3zN8TNInAgy9snlYIDSaijos05
8MLDx/PBjeykck0KuJGqrx524NwYKbZVAWeyn8Kib4EzyaUj3YVzZuL+ai1w
Kfu5SGkzuJSSEtI8OJfqOAVeAceyygBdH3As+QeaEedYk4mHrcC9bJm6YTe4
l0TfuLev35OnFUVl9XbfmVlzdxu4mvb7k2LD2UxSG68l4+qUCGt9cDgNH7fx
LDicLqY+mMg53FLQ6ABuJ6+7F93A7WTn7OPGuf32HuEUcD616qTMOrktg065
zJJyzl+jmPEKuYBmsOxU5AIytHqXyXOB/w4dhUT4yqM2nwDkCIp6PluT54jf
+3hfvW9pQCByCstN9pQgp5CCKNqT55TM2qJo5BrWvnzREuQaslqWL8s1LxzU
o5CDmJ7/QjPkINo+P06Wg0zVtXchN7GuV10pyE1UcORrbhpYeWAnchZrbFmc
gJxFhVlBspz17uAuGe/2vBfsi19DHfIaVXX/a0TnD4xONEkn8bx2XvHTZeQ7
mnP35RbkO+ofNOExz3eKozwVDcBDKjFe/TaCj4pVzG/wPHhkcJ0+8iMZuYVf
Q36kpyHSKzw/MtO2DORNejv8+l7kTSrLiV/A86ZXH++xP5R37AjyLNMf1HEY
eZb2dzrL8mzWoWt/b0buHeB/Tx35lzyOfM2/W3MjryMvszzt3+qQl2lpopMs
L7/OiXqcgVxUPuqCuh5yUvMBa1m+7jBI3fGjdaKw571dDi6LgpDTqbXhvhFy
Op2LyAvhOX13yzOlEHBeuvczM+R6ejBs83Oe6z/tEFq6gJOmhgo+FoCbxvbT
ns/PASK0OryDwQ0n6sJVt4IjbGxCjvFzA50+3m9/6FZQf0Juv57lG9cdUkbl
mtGyc4nKItuHq5Fvs+MrzgYj72ZWF93h5xiuV4WdgUqZ7ENu/B+ayHmbVMbI
zj1SqLult3uy9q5fP+A0eNTURCLSAp8OfL1tIz8/uVUvmGcBnnNq/ThgLPju
i0Me4+ctjwUK1kHgm5nitFnfgXd+j/9xIz+fse7jvfeht+LV1V2vsWjNyLRT
yN/bNI568vMfFb2gbr2wDFb2wlJlB+YpsXT+GX5etLdi07Le7pn67y/O+bHg
yN3igckErhxz5kkJP3dqO7jusx+4qq7SYbwJOGtoQOZKfk7l1+N9+P/k+oxS
gxG5yLFKP2y5dBfz+vSz1WeuY5UnpQm93bsUWbNzZRT4rPuT9JgfeC3Mpt6H
n6eZ9/GefNGrcPXEqHhhz/uGYr7xrv03/s2R//5cXpfX5XV5XV6X1+V1eV1e
l9fldXldXpfX5XV5XV6X1/9v6v8DmQgCDQ==
     "]]},
  Boxed->False,
  PlotRange->{{-1, 1}, {-1, 1}, {-1, 2.5}}]], "Output",
 CellChangeTimes->{
  3.405498710650659*^9, {3.405498802733039*^9, 3.405498822186719*^9}, 
   3.405499185507826*^9, 3.405499370237288*^9, 3.405499478261877*^9, 
   3.405499510528138*^9, {3.405499551723233*^9, 3.405499571206441*^9}, 
   3.405499601613529*^9, 3.405499635207511*^9, 3.405499699207621*^9, {
   3.405504345236547*^9, 3.405504362644007*^9}, 3.40558587404614*^9, 
   3.405585928210846*^9, 3.405586161835303*^9, 3.405587534044577*^9, 
   3.405587566600215*^9, 3.405587698442275*^9, 3.405587730231336*^9, 
   3.405587834351557*^9, 3.405587988274737*^9, {3.405588051498927*^9, 
   3.405588073995257*^9}, 3.405588162028123*^9, 3.405588386555615*^9, 
   3.405588833763538*^9, 3.405588886266153*^9, 3.405607378036328*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJztvXl0n1d63/f6twEgpdk8M54tni1eMrYn4/FMxp7YHjuxZ2I7E+92vMT2
eGxnPHWaxPVpT9vUJz1t2tOmaXNO0jb1mUUSKYmUKImSKImSSInbjwRJkARI
kARIkABJbARAAATxI8FFun3us9z73Pve98XvB0LtP9Y5rwD+lnd57ud+n+U+
74svf+UvvvbH/+wrf/GnX/3KR77051/5F1/706/+Fx/54j//c3ip+h1Z9h0f
g237RzL7u8ky+d8uA/9V7O9/ZH/Lsp32Rw3frJoxfCnDd75K77/ovtCwb8OH
+AP49lfoQzvch3oSH/oD+tAz9kfdvvNA4kO/Tx96yu2pqj5kz8v+K/XF36Mv
Ppk8T/nixuIvbnVf7C76Ir7LJ/iY/YGf2Zj4eLf7eGRNPtgm9+1K4tsbEq/V
3R5riWv4Xdrtw+4a6qtcvLxWcbvtSuz2d2i333JnmzJN6mwLGeA9fsOdaOqk
8Iu1IkJ+m3bxV24XysRFl9lwl5nCKUXFb9FR/m936bW2L32Mv5ECcEPxof5P
d0FdbR8K/pV6o8ddLhvrP7h9F34cX3qwiLwcq3Lyv0kH+PfOTqldePOncE8N
WNV9IyU3v0EH/Xels+iB0t22P0EKSP51Ood/6yy7mt74cyibSDlJiY73v7jj
9ZTuInX1XSlVik0lx/s1Ot7/5Gxcvsd2dazmzjA1oVIX/qt0Iv+ju/B2Gao4
GUkN9gY+HfWau5jUBCw5tf/e2aj4QKtQVXRW7LBT+9jgTpeH6i/daZTTlRpI
rxip+ZsERxngX7mx6RyS1MilJWdVvchhJeP0y3Sa/407zRL+A1ALpeL+lL9Q
CuSEf4lO+L9yI7raZAn2WIxvh2CldOEX6dT+ok3YCv17uaZUE6OUmoF8Nv/S
nU3qeG3tce20ep1pV9L+EZ31Py+VtEL17AjKtWBcqk3JK/mzNhQwLbXtRpSF
qJXD5HWNSfm6s3nhkWurc1sYY3YkWuWR1T+kE/6nq6PdEULlp5k2fRlChTMi
h0N0YX98H/S3K4fpEyn/hqChFDAnm6mA8Bfosv5wzVOhULZrpTOykI1u992U
jv88ne4frD4f2vMa7UYQnSe87aZsP0dX9HvuigrncOFprjFRKXTR5dOp3QSR
Lwxz59raTr1z11A+Odr1I4UfxneZwd9yI7Y+87pz/7FGyU9TLcP2Jbq633CC
0G6GWOiBy31d5/CWx9ntMyNX/EW64l9xoKZ2gYOQq/+tB8ad09NRoJ6qkPEV
/6Ib4/ur55Wfw5qY94w+4Ehv35fIdf4sXeeX3Uxt13LpAmPRNzK04Jro9z77
/vyPXPHP0BX/grviwlNKzd7OPeQawa91Mt/Lp0qJFX7OWaFcJNfbMRXP6PZD
qM6p9APF2H/JXX62egK5XsWL8m+UXmxpvBp8tF70brlr+3tkl59xslfMU26g
OneFa6wwFBakOk+B0kRG1vhpZ43COKODAkwbQUe2ehWrcw/fTni6+uQT0/w0
meYnnWk6l+7y0Uqx27lv7TwiaKOEkNLTnyJ7/LgTlI40olDs1ydeaMdXty8t
HUbNqQGNrPZjjqLOI6B2h7TQy9eLZmuXG5n1WSFpP6MU83yBzPM5B1V59NR5
SXaNLhxfWi17b++y429kWRZOwadOtUpt9JNko8+UClHn19n5N9qZlvcX3JS7
oDZUmKfbpzsWqdTIpca/4CpXWavrZLa252h9hazzgm77NAiCP0Fm/ZQzawcA
FApZB1d7P/lTeTVuvavGqSCLrfdJZ73yqHC9E7DOfXJBnrL2KKNI4pIf1qb7
cTLdDzjt6yisLO+n6byhY/1yug6pL7zqevyuGO7vkuG+3xlufTLY8gh0jdUd
v1JQjv46tnF0VEn4PNnye5wt25kDRGOp9LXpFdKL2u3xnNrfGpfR1uT4210n
YBN/3EnkGkkoDGb9RbNGsCSt0mu1/isjwXAX62NbyYo3CE/3jzr7rbmJKj/m
xWHw/YVBhbOj85ipXCTLoSgMen6UbPrd6yyhhfnAW+ot7ideLC9UtJsllcdI
bOwPOYDXvL4RfHiNi6lrrD3ViuyxPm6ztmZ90Zb+HFn6A87Sa5xVHfmcvEG1
5K1bvNlB+9gar7ow4Po7ZNb3ObOuT162xnCs7SpoiTVSEU3nydl6r6GkoofP
ku3fjz86mXn3UydeB4sWvdbGGsA6tkukg9GyS04VOj+rZOU+nVhhKtBhiMdv
rlP/QHlVoPNqVufIiKk/Q6b+YMLU671Qm48CV0vlO6/dt+3WsizLu7Xgygu1
u90kUpGjLP2hhKXvpwGl/W6PUs1ZxeEHH64Wzal0q93aiSlf2m9/1UBg/zQN
wd9IDEE7nq6TYLHQRvfTPZua1OVLDIUuq7BR+76DxZxdVrG+m4n3Ezu+xSqd
uvZYeMeUby9e11+H2DGdfomVf5is/N2FvvOtjSJTl9NZQaNUmf3cWu/qVnl3
2mpzS6z/KbL+h9u0fueWKVSd2B6rm7HQUHHf9/0Scz8lsNUcf2T4j7Rh+NUF
p9y5V9fZMh05uPJ8Iz37yvxUu47f24UF5qMJS3e7k3urIsb7M08hCWKe+6md
lseLhe96txTFi0z0xxJ27nwZsvPUfxVs1suPFU6mNbrremRJ+0Zq9z7eS3Vw
f5Js//GE7dc7UCxcoSjX6Lemqth+2axcaQqLVoWVxB8ii/9N/NF+Nlt4oMLQ
cH2CoDQ+8u4a8q8O51Oh+ymsKf4gGfh72nCQSfvJGlfnDdWdh4SrxjI5na4W
zaL1Ln+V92elills+O9NGL7QMm1nZzQ+BWQVrgy3e+9SORgpk6X2XHdXVGzk
ta/+OTZWC3FkPH6geDzWO1JsY40sWz1x7Xx2tVNxXVcHzox/XxHj5Zq1PsvI
ZSCtR7NNp2YL0NCC1ZU4cIF50sUdIflvkdWxL8ef9hrb09YnLqwWmWSDG4tC
UVnHULCdcHf1yk1k508k6F7HJoXCUKY8He98/XSNFcNOC2GruKW2bib/frL8
DzjC76ei2obU+sTKX/Jab3e+71W/8tt021/TEmOSOrNWr45J57PuPrsQtEZ2
FLp4o7Tnw/SB1ntJOUVxieHXOts6iVHKp0YuYWjPMoXC0vlyzSqLyZ0KS2h7
CvM4vUx8vPDOv3ZV974DuPKZtE7lmgQvqZnklxbKcykm+pMJq3aOzRpLGetj
ns6Fpro2P9T5VZY/F4cqJdnfTgxBO7OqE8npfIW4PJYpF6S3mJ3yyk272Wg0
Cp9KjEI5ReuRf/nEOlu9xtW5OJe78zJx7qBZrP0mAzE5FWVpGaK8/FctUu9y
au6/XuX+tT6dKOXPECnEo60SaGTVTydAXuvKTJqNjm5sKxeY9up97Ud76xjT
FDqnVIxCSzzZjyRsX9Zk0HkSvsZuisKSeeeV005jvVW6KRKzqPxJFh9fxdRr
rFC8lVmEnxBlU6hQgsrDvDUmDblLFZQ/Qvb9TMK+9738W56NdxTv1IpISVmr
jWi584BvHQPhHEXRYHw2MRidpeo5F7XmVL18zbdRatB26lad+pz1WvCMLP9h
sjz18a+xZJxTn3LS1n0V662rjBcqTzr9jIz6uQTO7adPZcNZDlh5WNhRWHOf
d7C30Z+1jgXhVMRC3YV8o9X6xn5Ztl4rmvlsPbcKU75A9xaEN+oM3Ofbva+V
Gmfp8S/3OQPvR2iqPERyHPtG5zXy8tm0PmWd8ggHD8Qgfz5h0/JZdj9Fq3bV
pfN6ernf7ch4VWuXzuOa1IHS7TWCNd16wncdJ0zmk6+SrqKyudRRU+SaijPl
azHlLrteZOfyQlU5L6lVTLqbip+CURLbtWGNzu+ZuZ/JVCgVnQYw/gglRi+7
vJygRLb9iUJpLoqC19H3dF7bW1My3sGkqYemLp8qbUUsYm+6O5OfZtVJgLOe
tc+OFKUTnW5jfZfLEc6byMdWabbqfCqlApH3FVu/0EnfZ0n4fhYy1zs9qvP/
TTg7bGzXYf95KQop7tnyXyjivnCK+YhnHZd619jxed8zqs6nEA1A+cW3Ibdq
Kilj/1TC2GvMLTual/+/SlChtWrK9pnf7i8UXJWbqhO6aEJ8F43RTyfG6K0P
CjsXqvKgsNiNZ47stFPOqnoyJOdkd/rrhbd2FvaZpOpd76VhoCcAr2u4mOrZ
eWtyr5JwR6025S5OTmE1+7ebLaQcLpv37xfJfkfqVLgaUY000L7x/0W2VQ3t
bG2pzsB7LrGqiS+1HUEvupj2s3IZjPfQ2f1Mm4PRRmtFw4m8Qr7DYk5562M3
/1tdB/43eabljq2Epx5PBVM0gJ114iQ1pMzW76ZD/2yhrduyUj75zBUCy6OD
jmaGh8lTK5l+emakwEjJSgr28vCxjWVyxvmLiZPLq3B6mnXkygvvQEsrWZtk
RabINdd38eVNEfA4nhtWY71QrTtqvPFq/F3Fpu48PFxLk1cBKt2lF1vsuDJk
ly5mAgxr1cTIgcqsW56Pd66ihUu8XJf5UtHM6+hG+nIH1nmTROeu20/Imr2i
ipk43WLbi2JW2pBKHoZV7l3oMIzjSvo/oBMrMMh6t/+tceU/xVBDXbT978pg
iy5lnGx82tu47q5xozt+JNUpW8l9P9b5sElXtwTdZs9/++ytkNjO08w1uhwp
m4iB7X+XwchXwL4bnUU94ikP2H6CGLJcdMncDvTzbVjXyUDndyCscVGtvG6r
wmSwopv3VxSn3dFlZZkOM1Ph9JoDtoAN7rn/hYRVy0OxNQpAW+F7J7wnkrxL
p6wKXBpsCb9kf/j/eM7i4dflcCI6hqe+s3cbzdJ8H9Q/TFi089p258usqyxT
t+8pXFZ20tusqi5KXhOatW0xhAvmmFGUdge7V7OovJOIbwb+csKwhaF5Rxlu
G612beRvPNlHT7UYsLzJxIw6GOAoYWq4lbJMd8KMXozaf7JIJjeC0J9BXqPz
L6/Sdx4ryTe0vugCG1mLLbqKVWtm4qz7HF3j5HCLiAz8WRYTGVWp5VzbiCf5
aWm/mCCz8yWu+xdC3go/X+g5srCoLkYeG2xTAQBna3zY4LWJoZbye25ipPK9
kG13cuVhOj949JcKjd5+g3Kn9Yk2ogedBDG+gzG+KoAFy8FWEYKHPMFuDzm7
xU4qKwUqXU3+XLERy9vT22gSWOMiVSxmGZ5BOYmXzyix5QmbtJl/nmIEXOF5
4of5Mfu/nDBTR534b83i/yq+0MRGBEd9iTYbLJ3W0zQ27MQwGTYVnhZGpil3
5B3AF+hYv5KwZWfpgTuHjgLeciXXJSn73/mBlp7DF4E/O49HT0sUX0dT6v9i
pZP/wJQykafOt5zFC1goXqpI6zz/QcdfTVi1jVstyhfqO+/YrfMe9PXb/0bI
nELYBfDoFwfDOEmZk0xcJcxwYk8Mt8TZTJ5riR3dUESG8ZNyFUPyOPCfTv01
OtaqDigZvLb/TJNU0FNY8dAy4NEagdDc2hC2bqHxTEjjZfDFgp2dzBNgtkna
6muxGp4D/5nwX0/AVh69tNMAtprzVaFBeO4y+cRCdu6eBwtZKyHjbKGzfvIF
8zXAy9pJ9llmqPQ8zaQKRH9KPXUZdS83CYdSvQ/PqifMuYFWKmIjV9BAW+g5
an+/Yo0wPtySCZm3RFqp5DUjskyJWvabie+sZ3wwplyDnkvlnlO57ZoZOuEn
zXA/XP7wQKuhTlsuv5vNZl8TjC5DrHZlqEUayxY7X24xlyaqXZcYa43dOB3U
AAobd3iI6JzOgpWspYb6Wy6WGDnliywNQs7NJ3MJzALmCerccr1i3snzkdzX
tYNIWOgfJxEsmEvlqyXlHk6V72pucpw53rJ2kCsCU0RwJFJS5yyAmEu0ZRLp
Xx4OIv0uZmZyJB9TVMz0haJQLWGn33KHLq+qdF6+b7eLF3d++pg959PHneY6
Rw9zLLJdV6BFF08TWqPg0cbOtJysRyaTMp412eQF+srUhaTqyaglrPXbCarK
mnjWp80rt9Qcn+nQQFRTs1OO65oXMAbNJK7PGYZXPiZGWkEauppBqG6Z/U7C
ID4fKi8arlofO3WsvJIj56URoc81zHm4/JHB4EqtKTbyV8QImROuuhkHjZng
Td5LzdYSc/xuwhzlFfCUidbYWFjjefOm8f+BCVPgCPbachAFYEH8/CmdPHuZ
vkgRN3NUjzky4+daWWo6ScipJ6186R/Rz3+SMFs7QhKXAkvdWZgRypW9Af9+
kzZ39oPHywtZznoQMQ5z/TaVyimnePFMPENpIl4+R5t8lCfGqhb7vYTFChO4
cvfm3yVL45v34Oc9ezpv4Jm8GZ6HOXW8lROkswNWaECKKtYwZfNVXrsoSQek
cxxI4jW8LWFL4y79993nChPOzkNG7+PEDd9701kiIzNUtRncxWhYwI/120lw
ZsCHO1LDGz6Vl93oGsEestcxiInGgI9LUpOOTPm2+DWPxh8k0Cgr/Xb0TFo/
K+F7d8Eex4+0xFQVtFU4pQSDQQgIT5/QaXh4PXFFjt4Fg5iLGBmODlHqGq+T
rmKLryRs4Uuz5aGgJwnMdxsu6s6btNnLPmEv2/i58gZe15v2C3Q5MEPMKc4X
AIq4ksv/6csZ5goHO+QLZ1uRjbrcN1KiFFiBLcNRyx8mrFA+T3zZtnz1SM5/
BWxgTQQbvAZGgu8hHUcDM9FEqpgBjPZOHo9iehCD0/25iNZdtZtJqpJ2/jRM
mZEzrbLcIcdZ9NoDwUjknfpX+ZvRjb4dTZ6o8RjMcwvsYc228gZtt98U03Wh
6e7CN08o8/VDMGTthpTJpZ0O/Hfmwzdro3O0tW2H1Od6nG1SFmYD/ZH9oeqi
RTNKLejWzE24wMOHWmKHijVCBa3Q5WaZ2OBEX6tUi6XycnogV6cQtwqzi80i
76Vk1fvgnsS7ZcFgkVnacEDlU7GmjbZ8x5jWHQICjFex1rPTzzL0pjB07Igd
82NgNzv9rA0tQ5YfPATOwDfxLr5gaGvmDFXAzFkAfehU60F+ObLoA22i45LO
y94ZsmX+uNAyZauTBfdJvM3cAIss89a6S9a5Cdd8uBfw4uk1f8OYvsMtayIS
cvv1u/Z/99ypWMflhFzl5JTXW7hOn8QtNeixWewXH0x8zns6MVrCQH+SMFDs
txIdLUt3LNbaHMt3vUnAHPCZI4fh9FdQoa0tbhu0BW538Zj33L6VIxdE5EoG
wRiwpXILL6dvb3O+aEOI6dgQ/zRhiPL5ojLImlmEy7tuN7g8ME7F2qZijQI7
6e0ls9+Ey7QbGCYjy9RiyyhSyAQD4LqcZchxnALPdYrkOCktXkmT4Us+2s+U
CiUs87WEZcprmSp2q5qFW8YsruAGXzvQbMGVsZVM82DLHDwImBw6ZJVkGa67
dc84Y92Cqz7KFFWsmWB3jI9HSPKrAYiBTvbrzHFtmopTiXMYQtFcCQJqak3L
/lSBquZG6gHtSlfnb9InrVUWVuBlAAdeBrOYpt3AIITPXTgHsAcXdxGdN9ki
EBGuGDJIxdoDLkC0956454q1R0oVvBinplTqG22YwSdJNBoNMwfXeY03u7N9
+1tm3wEYyv1NO9KLd2iq8PWaJbgAuOQKXvIDZhkut/UGg8CXbd3O0aN46W7G
HANXc/xYKwgbBnztPOlB2g1INkav2euSfFmbQt6jPtDs6+prMh9UOLbBvLa3
ZV6HzVrIbnv3tcze/aQQQIRZgIsDKCrWRjxV0ErKQhVrIABam+eWMs8xiGKO
sVkKhbMgR0hNnfLYTNZuzHhYpuGfvO70nyXsoiKOhrm6bMwM7GEWNrQR2GXP
PriIa7fke/NkHviXtU2VbHMIbQNndkMM02WWwRitNxU/hoxztK8lAfLqVuEJ
XRiFFJpXlMYahHeSNByvWv5ZZBmSM/r/NAQT02AYMA7sYvdeu9Axy+BYA83B
lYF90DIIEMCzcEcsBPTcZQuBMET2OXyYzu4wyMkRsM0bZC+e7uUhhymQinbn
Vsr8qVTzi8pCks5MLNGlTsLPKTDPq6/bMd21x8rK1RYzdNM4M+3ZbxlacQxp
C1WsgWCfTfDQYB5zEGxyCLZe9ND33nDORecAKUeSEotctaDgIlP7C7Aab+Vf
489xh8DXvYG6zMwiXDxsL+9u4WY//8rrLWssu2azbM/WGuoqGGdGGep1EKE5
4AhshVZCnu7Y71iWeswisGR5ug6GsgZr2iAXfr8D2127veF8Tz5xKvTIhbKS
4ksVLVcBbyKdjbK9vubtBXNsAWwBG9gNDgCWA0u//BrZbfIGQTaN82+6ZaeC
thvaDubfngNgO7DZNbbb/B2kjBg7cKjFjK3cpVSczSbmuvdmIhBOzcNy3Ukl
BikI4xCbDZaalHSjqkujJuacLFpzzNvgQJnPoTd33TgTTi2j+dB6FWs8OE80
3y0ynUVuD4Q+1nTznHHuA4e3H7ab8O9b1oRgOMBl5Z47vLnzBhKHJUGuXLTL
nU+4Ct2AtzEv5Raw6FLPCR90pLiju6+pwMMV4Mlr9lhT88baEa04DZa7qqw4
C1acE7UDK06xFS2zN938tczesgPxOjBoDWm3vU0yfguMetNuZEhz665MuNuY
z6MVqQaSVdIJWdEaQZGvKA8WhPgStF2Spmyawp1t+vv2B69hjc/Jou3ENWMt
jPadWnD2hc+AheEQM9e9fcXGUy2274POvrtBE+32Gth2CWBdAlhvwLZsN57r
tkxy844DAiC1eZ0t477hyrixbd/Qts2FHCmFEwQvjMS1zHDCV+Nag3w4X/he
DVpu4fsdZ2DYx6WrxlyagTRxFoLgWUMmbwQmn/Qmr6DNNxLVbPFZa/EbdK0v
Q5wHVjevws9ddttn/e7iTXTPYO7rZHIb3K24Lllbz7tFQmrTaBvV2GpwVRfz
cjAHBl89uImyJP6twLIpPW2TY3tFzDH2kUi8cXHamFHYxqYx175qd6/Mbq7M
selpVxPzaHb46JQYvYZGvwoGn1lCo1es1XkevwK2ngdFsdtCy4Q2XxGbUzhh
MV++o1AHK9ia1y0xP+xz5Q2uysvCRTQC9/wI9LjLLIyPIrtzetucwhKjXQ2y
O7hnEhMnFV5JaKCHIbVI4kfi1/2ha2bLcy0zMklHuDAFL8PQgFVwcGAujM3Q
fLg0y4MzZ1iH6npkzCRMiKlFlO5FK9YyMDg4MBvmlukQ9uc1PzI0MDU3MPYj
S7ZscOO2nXZ2XPZCeN/ieiSPS8XVubnCpOpuBSrv5TdlwwcY3pQP8ANV46IM
jxT/S0arMGxJ+dCK2mn+Gz9Fx/4lP04Pms3b/Y2xw+PGnJsw5jxsMnYjU8Zc
gEFzM+sqzqwZ67DU4OE2brdrxg/gAk4tdBzWSU9fp5l11Q7gDRzAih05FkI1
fmYBnAgMoazu8eQySzCpbtw24eSiAcwqPIQ4elxsl4oH1gfBitGKoF8BbTvn
Z1vpInHh6BW47JR/rzIpajAdKSkfw0OJpUYR+NOXjTlzxZizV+ynh8atXYcn
eEhhOO1Q4nSc5un4djPKU3GMp+IlGMHLxaNpJhdxOnJIAOMJU1pGE0d0WU1J
FMj5lkNtkSua13mTwZRyuAymLWUqpUQfpcYzo+JdXRfvZFrSykDm67fHBlrF
iWdeMHWVtJ4YWPmcfU3qhn6WurtT4xlpcZkIqjypc/oCvYflDfqT2t3m5Jgx
p8boWgYvGRzj0zDGZ2Cqnh2Hw9ph7gmG+TwP88g0z1wY41E3azeYsWicr1yj
cR6f57GmccaJS2NcxzG+Go5xJtjZqYrF6lvoEFfsnJHhXVLDu8yrHGp4ZfGH
qvpVXdHPKr5U7UZXlZfTtdbIMXk5lIKv/YCspDRI1zORYD3SDRzatHLHwksS
VTie+Jy0Bo/n8QvGnLhoTL/dRo0ZgLFVY1wxg5ftbtQQZzTGXWYIxncYxvcc
j7EdX57O8BkYZfjeKM9lGGN4DUYZTuxywRhPLLr5zHMZnCyPc5b5Owmj+XzT
xtQ83rJAQVP6Ni1OuBWcRjDcuDChhpsWJmp6yrmJlIU9KqnoM99rMXTelw3r
JPoysnra8kDTG2XD7LoIJ/3qn7B39aqf4fRITnrGb50PdPicMUfOy376RqzW
HhsxueHvH1MIXOJpzlP89HjAwATOczX+56fVPL/K83wG5/msPcexOTfP4TUg
AMbNjv/4AjPgx99MgVeeXmI7ddNUX6apjtO9RV+xqxLz1ivD+NNU3xgPvS22
41RfvqemO419xgO/YvKT3fnKgkQ6Xec7PZyKfXikZed1tdhjd3LXHxDZgM+i
1tc8fw0nO4oIt/9UiY0eQ0wrqngJH/fTvmoODhlzCLbeIXvo3mF7mcLI0fM8
9S0mHzLHAJHjFxmTBCIWD8QkRMScBXmwEjE0yTLBiDiZYEQugjyMzqJEWERI
Jerm8jVWCU8InBIw4krqIA22rH4Vy6FAB0xBYUP4sKt087RCZ7OiFSylMxtL
xAatztGMk4VdXqbKNBkyk8t7AFK+wOdC+rc7zpcHWEQcVIqCOX0GfsHwntE3
x/Ep02lMtlJ5Gj0IPHuHemvza8Zu2Yc5Svq33wqeVGP2DhqzD7b9p+kIB84Y
c+AsaBjgxFgFSB0+76SHkKoFSJ0YhWsBpuDykSog6pQnyjZIYtx4Jk1UxSIF
ewygmoGXR21NYwxJQs1hmq4QTZks91u9mQStmVpivQGirN4sK71RPOESjZUa
WvJdsbuPeLLrD1lFLfm21JKvjRpXvCjkwgtRnMMDrdUUJwIKvVctQVWV2VKB
Bv5+3ZjiRI8TCeX+nOSApwrb37wWhTRtxJc37UaazKOvG/PYHmMeh23LXtj2
GbN1H331yQP2crYdsJ0NTzWNefqgMc/Atv0QbL3GPAvbc7302R1HjNlx1JgX
+ox5EbaX7HYMzmbncfsXSV4+QR97td+YXXYbMGY3bK+dNOb1U8bssRvAixAX
A2wODRuLsOlVAB8doc8Dw6YPCD52kSkWgt8TEHzqClM87nXxDNB7dpIIHgI9
HIbt3HReFy+AJl6cRV0kx2nLRoDv5Xk3qytmfFHWjieuBxTr1UZSxm6imBeI
UBl5sXGBAibpX7gegiwcL0dr+LcMz2fpX8gSDR1KH23Q5Knx1NaKqI3DY3rN
hklVcZme1oKcSPdScE6EiqqpnvLuWu5SSIVe7EzfiT8aXiYB6kf3MNh7Ya9A
Ndh6637HtaXabAOmnzrIXB+CjwHU2fci1vZjzzPSO/oU1seM2Wm348Yx/Uqb
TO87w1wD0weGFNeK6d7zzHWe6Yo5Pmp96Ykx8vXo74Hpk55pmxagKp9OM12x
UIMhEOurjLVH2ozOoasnEd6AVF8BFw9A46aRltXhaVuamV524swNBrMKaVzv
XHHibFsvrmN72xLBjBEgbkxz602GpZaMAIuLbBuU7JpQzu0nKY9wZNcc2W7q
hi8zuDw3PNAScqhKaVGm7xdrUjWjz2t830m6zPhu3sMIgyY/vo90eQvwKwwn
+DXP9FrzWIgfNM8eZoiPRhAfY4gB4J0njBZmu8o/YE9x90kHMbwGCMPJ7z1N
EO/3ENuJP2SPdXCYIVYAHx5REAPAfSDIx0aNZdgSnJEyb3AEn7ySUGYg+Mwk
UlyxCAMyw9NKmBXBF2YldqB8ZgxE+RIW7C8vWDavLCYwjhHucgjPKITtGirN
LYAYzpj7h7DFCtus7lJ7FbeACMkCH+wBZfkWjn4HutydgLnG32WaucolRPsC
BivqHfsGlahEiCVatJIdLLhofgMtvue/lVzPTVUd6c9gZe9SAUcANekyga2g
5oCjaXeHYAdQf2dHUL/cryIOUOVdADSCDar8+qCA3UNgp5SZoT50DsPm8zYz
T0HdN8pgjxkvzQD1QAi1l2YPNcryEJA8PE3SLJWyi3OkxaOYkQPLtpMLxPgS
iDHwbGmmMIPXQJYIZm6msDnYMq6B6G6dW45kEWRq1eFOOOrU6XEUCydBpxdj
TLJcizuOUxBHyx7uLhNil2kuYJprPnImd+wRMAVXWKuYIyzY4AzwOlwrWrBN
VYvKYKbV700Mc6TScN6AMyji1gMq0gCV3gYwPwUwP92LQGP0vB1gfvaIAxq+
CzjDoR3Qx+1rgDMowSowE8s1x/L+sxwGAsx2agvODuX3mt4R1ugLjPNqKAvO
40qjAeXTk4zzFOJMGgwRBmjzedDlkRnWaKDZUX3NpoDzuDDEQF9eNF6irxtP
NdYQqC/D9VXNSH+QanBxWN92fUG2xnyXT6hubrxB8YXleflNmZI3EQMrzyt+
W02gg5tMc+neilNTgblGjcRhLJIFUt3NkYdWaFWO1MuzqcpDquhQd+zHt6OG
dP+oppveegToBsLhi8A3vPMo0P0YSPXj+0mutyi6n2S6twHdT/UqwoHu7Uz3
cyDVz/cZArzbvABwvwhK/dIJUuud/UqtB+BjQDd8bDew/dog8o1h9B6Aey/A
vU/DvcHBfRCCj0PnKQBJwF2xdIMBjo0pvoHt/stKqhXbgxMcX1asQtsFMht5
CNWzjuqKxRreBqhRonFbYKm2Mn0FVzU11BMg077dCLGe1u2CgOPsisL6NmHN
LW8ujVq8R62CS1jXuGEjjmVcHGkZJ9d2rdPKZoleh0F0nmiJwed5gtxGVb/t
1Jcpx51a9a0kskYfnchameg2fQOl+q4LmX1AIjMlVSLjJ9l9J/54wIPLsrwZ
oH0UoH1MQetkuQmHAmqB7UCVmVlR5ef6kFsKMwTa4yXQ9iC0uwcVuADtHoB2
71kHLpMLaYaiFraKxRaAPnxBgQtq3AekCrXHgdgTRG2D4AT9zd5hzoD6np2m
YAIDiqsE6zmA9fxsACzJMNA66mmtmEuL1rU5GQZax7lpi2l1MixNhjUzo0Cd
k/ahLrMAA2nZVHyaJeDrBtb1l/F+JaBfY9pGcFwNqexK6GzV62zN6az9AGzt
1jIais9AcVPFi+7OSH23DiBiSklebQBxQKpHTzQL5PWwLVUckY9pSnccM1pe
KxZTCEccqCcpdNhVROmZPKUHgNLmOUcqUVoL5PWoLbQBpkRAj+kHLR2A7eQ4
aarV04efa5lBiBNOA6lAK+z+LDYWILFA6vBMSOsId8JeAFIvhrSaMUD0Ei5G
XkZsr0S4Tiw7gc2o4bBGDYeAGUMrdWZpip2HcV2w0cIidhdeF2bfxK1qgWWl
VPlcga6q7KmuhZVgyGxlJQ+vLxZz7oanl4JW3vBhLp+ZwhDf61YRgPzmKyRR
iThglMOAPaimNgzYa18TNX38gHD6Ls8pM7qtN+AU5XT70bycIqgA6YsgpS/1
M6jd5pUBBSpAumtQgXraxrlnMGezajrEORv81IwetGo6goHuCC+zKq9v9RO8
vSW0H6gcGGdKJ9DjM/jAqL2Hdpo19SpuFYsoHPvcLEMaAXpxniHFXqYxbEUD
SM1lgBMAtXXhJVcXZkARUtBB6/4ZUFlZdcLKTbDX7nAEYEG1BWAP6nVgbCkE
NdJWJa1+HT2Topdf2X5ThZ8rAlu3onXFiI0EVF2RCISVZdr1VBX3xwQ142Bx
Q2oSVF8u6GnOrb/kX+MnB+Nf02mwm2KSXTBrKX4CKH7yENYgem1MgSQDxc8o
ip8Fep9LUSxyWzcvC8WnHMWwS+AYTus1kNrXqdxAMMCp/MetfiWvFzT1MORi
R8Dz/6dtNjgCYYVTOSbeP0UvE4yx6xRqbMXiC/Y5e5UBnmGJJXorFl8e9AsK
3lEH7wYHLwK85BV2fFkpbMsVi1FcVygimE2AO6/BrZvFNzy4CC8OWiizmt7C
1V4OV28Z1y/A9OK/6vGyHscDYHUKZIVbsT+HsV0uNcuqera49EsHCL4OzGor
pQeuu0nvGVfS2n6Mw2cIW/oDc3WvyRAzbAYt3rzfOlDaodNWIHLHcUflRtY/
69z3gGjuAbHcy8K5H0TzAAjmARDMJmwHR5xwXrBChxTCBt6dYlGJQ5nCE7gK
DBzaKq4lcYJ1dFKRCPqJOioaOoQaOjzLJM55HR0BDC/MM4q4EjyGzv2SQvAK
UDLOre0Ty15Fpm6Sfk5jZ9lVLNPOKA4di3eJw/l7yKJFsWJJhF1cz3GYSKQo
GXKsyP3BFabAvsahASFQAGXFQZkqF3QXKWoqfBVEFcJS1g1+w881Spgsv2cn
IPHBkESm8VHQ08cOhJq69WCsqXXz1OFQU7f3yThuNP/6r8KWBogMMNHaCYK6
E0KCl0+ysKKg7sL67W4Q1NfOkKjmED+HiNtY9rw1bHOEMQeRtULbe9GLLRrJ
am3VHAPCjzPhVSS8bgYmmHBPt40Upu17jvAZFlpsqjuH98og4twca/G+APHr
RdhGF1WYcN0PXo3lFBUWALRoT91CtM00wAJwa7QrZu6ODNY1Iht2uyBc1xzX
MHss24Q2aUmLJRalrL9FMPokqsrEW1qEahX0CtAujFjxNK6w0LpaQWH1C95W
TIv6uvghS3Xa1nSkmyqT+dws/Oi94LkDIeE/QoTTX4HbkNJa8+gBItzSvaXJ
xDxxyObfT/Zy6GvhPhLAbf7y/2mRPLM074Bg4QXYXuzH0Ne8ZKsHO09KbPgK
hLrAN4W+iu3Xz9rwF+u5e4cd3oz229JojxLaR8e8gvcB28eA7eMQQ5ywfcEW
7/c4vE9OKsSnQwE/y3gPgXIPA9YAeID3iML74qKsxzVIwYG/y8DfFcBvfJlt
N4GZ2WRIOOl3gyC32n2HNiTccj2PnQ8o32/wBnxfJ8YrFvKKhZy76n30S4yE
y3FJwnke0OcFZQd2YdGhVrJm4bO2riKEfagh5QUfCteiQgMxmof40xpiSs4e
BogfAYg3CcRapgHiLQc5/IXkTSjedliRfNQWG/rkSM8BxM/jwgRgbBcr+hnk
AVysQIpfPuVUGineBRTvPsMkC8Uf0BSb/ecpDjkABCPJF5hkoLh3lEkuoPj4
OJKMEXE/IDwgGE8xZoMo0khySDG8N4xhMJJ8TZG8ID7pbVaoseAwBhSPAWGX
8iTjDeQTQJZCuWJZBveEen2bUJ5llOfuOpxFsG31dtG2vF5H7WK1doRE9bIK
YSpA14s4jiIMHyAU1B+6VEgj1GIk3FARDs8G4jJqjZaIQlTYd/ZEpKba4H+Y
6H2feuthIteWICDY/aiT4McVuVuB3Cd6I3qB3KdBf5/pIw22n3sW0H3uOOKL
GrwDsEV8BxBfDDB2MrpOhAHdXWcYXwguXsceSstvj+c3Yrd5gfm9iLH0qP07
6IfHFL/Abh+weyzBbj9wOwDbySnHr5dhgPfMDAMMEjw0ZxhfklkrvRcWUXoJ
WgK2Yi7dwGeULsfqi3ckTt5iZPGOxGnsx716m5nF1YY5fILDHK8J29B5HjR3
Aau5i1jNXVSk2k3ncvv6W45cPE3Ha1eggbIGZ1+7ZozT2lzcHLG8gVVX7wt+
7yHpdcFBPb5vg4OtIHHTMhu08qTKDqkiGhP8fvxB/TyP7PPau/kABxHNiOBe
RTDQuw3ofQrofRpDYyu+pOXt0LtzUBF8WhFM9BK8NbMH4N17zgFcsfTaK8+x
+/Yku33A7rFxxa9id2CK+M2c+NbMaWF3FtmVIhdGEddYe7mFcmTRYVwxo9ex
9QHkcAygApAtxhXLMbw8zs2/qLxWcadWWHY3EsJ3aJu9S5JrEb4mGNsHyUHI
sPCmzyItxjBnrPhmPo5gFb3pUqqbFhkvr7dYLBs+ygizRKTxtgsEJLRFQrMu
fbNBwCitjMXtZ9KMQ8FtiCtVgiXI1X/DQv9nT/DTmtOaU1pkdT8cEEAFfB2q
gOmWQx7VHKZKaLcfMx7VExgn9Ft8HaptYPraEKKKmVyS043mwAXWWYgPDo1S
jNALjAasEqdwCkCqvaPKssqc9itOT05LnHBVgsYhlFVH5zxtBPQI3vuNhAIs
oyKywKftZ1g2XmgZz3EAZgIomQQoppzK1s00MHE1RNSqrbvp4dobnqEFRHLR
cIBQiwOEitVYVkGpnN10qnYzBysC3EiWIcI13qo9tKRtWfBINFFcyuKCWyT4
TBTScb+OCn2Z4wbOPV2WYK6Z/3uFNKc6K/82vfkBTTjQ/Qio8KYDTHiXeTSi
e4sI8WGsV+ASGwsxEc50Pwt0P3cCCSfAIRAGuF8EuF/CnknAG0JHBPw0Aw5w
7wK4dw8pwAHuPecU4CMYRVQs3taEIdwVSzcniUdZg/vGlQ4D2ycmTRdL0OkZ
L7lnbZ/CENYjhgHocxboBdqU5MJ5X8Sb+0ZZb8ew+waYtrf9LNND2ca5qXcC
S22TGC8A1UgzbLb8hg/GmoGRnb1Hojt3T9iYx3gBRBfFVrbrEn/WEeOqxpib
dBoS+jpybkqQS4kT19x8XleN6K7rUEJIl94cn6IlACfvEPRX8ruLRne715Bg
1Y0W3LQvRDuV9vdyVCnOzlPMf7nzg/jjvUTxfkcxxROA8GOA8OOHQpF+4jBi
jCK9DRB+qi+BsUa4oRHWGl2xDMPbQvCuIUXxsI0ozmFR4ryDOCOCq0jwwVGk
2IYTeDORlejDfAfj0Ssk0VT02kjSDJLcD5I8MO2k2SqzGQSWkWnimVX6gwj0
MAB9joEeWYziCKvSAPToDYYaQHYyDbhduamgXnEybaZuM9R3WKbv+g7jOZbm
axg9zOPTpRYYZiamK4Fylf8v+N6UDKnK2KoELvMxhlrDaGh4XRel0NuI6fX3
Ggm4vjFY37UulFf4dmcdj6iYxEfKimfXaxbVJ1I3rv+Q5vlD+NZDoMrINPO8
GXh+9KBiujdiuoDn7cc58LBM91N8vAOAfuGkg5pkudvLchnQXWYPA70PVHk/
xBo25jgAQDdHeScVK7/g9I+B8B4n8U3SewrvqQd+s3eY00DvmTkkGBO4oYje
84uKYCD3AmwXPb0Vi69dm1umB8kKvOO3IoAJXuF15h6J8SwWG+becBVjEOJ5
EV+MdruTCkx7cbVijExv2g6EW0YquKrugB+6ZfflUzjRW32vkJQeuopE1xOr
Gx7oZMLF5Ls+9NaBh9fggh53/rxaCCnB9kP2B/cEAqaAMYIKkD7eq+IHBem2
PgWqgtQK73P9CVBBdV8aJOXdyXfBvQKUvoo3W+zC4i+SCoHD6+cYQ/g/auwY
bTYM7gV9PXzZaawDddyDemIqCSuDWtWgWqm9Zl8bAlaGFxBWeO38okiFBvXi
DYSVQO1GUC8BUpdvMqwhqLLwY0V2Gkbrqt1gJARYK7Rzbzqx5XBv2ZZRW0ZK
CMKl/TnHqnTTU+1AjT36LbubsKJAaOMp3Q6RUlXdrug2ca+cCSwVkayqPkyu
R+txUlm7pyadJHzGGPkLK/BPTSSHtw+BiD58AIX0Y/jdLosIqpjd9vJtC/tJ
xayLRh07OKbQAWx6GZsj4JqPjjM6ddK4EBvYBYADWJ3k+3Cshx4EbE7PMTrX
SN+G8D4cAMd2zyySxp3XGuexMaO4qmvZqWpuOEJomMnbJG5TDMz0PQSmYomB
05xVvGRUN804fxBo/HJo3SVGlNXHGpZhnaruF7ZyeT1Glt1x2+EdP5SpFkMf
StYjQNyXgvXbeiRUfHwfQ1LrQDo3+kH65W/gD8pIHjrgQDGbwNtuBhF7FETs
sV4SMudxQcSegO1JuwIASpa90zwFGvY0bM+Ajm3nG8ee7WctAw3bARq2AzTs
BdheHGQtYx17GXTsFdGxitk9bHf4GhD6OhO6hwndB4Tuv0i+Fhg1TSDzYESo
Ezd85IVFtGb6ANFjkw7TCjL6XhK3iNDBuYhSELahBRK3YSBTKB3hhdkRIPTC
DaZ0GWNI6Xa9AoiMr9CGwgYETN5BQG2mj7VThpRU7Q3R2WUnGLa670jFN2oh
qT0FORAnPXW3asXRZOZTeu18G2pt11dNFbK+OhW1FNRUObXJzdqsO6qeWo/v
h5Svy2KsJtSBG/raT2hg3+6U7aEI2M2HQmjR+4LnRWjB8z6JpVNL7UeJWiD2
GSZ2uyL2+ZOK2kGiNiLWvDpEMeIu8LqAbQ5aK63/x9aWBxegPTCmwL2E2c9l
bKq54sDF5D2C1pxAXe3HFasBoPYk3z/D1NqWA6xNnVHUDhG1tuUAa1PnQ2oZ
hzHbuH3pJubygMuVkFmby2PePnU3ElYSwhuEqNsoilt2w+cRbgXYkUPNx5QN
VZ4qyH1UPYq0P78gEC2+SnCpb0eoJRS4zv+PlwSc95ecXfGdBdGnTn66VTKf
5/lvEc/fjT8+FgpwM+K5l3gWlrcAy1uB5Sf6kGeMJrcBy08By08Dy8/0KwUe
iBR4MKHAwPIrQ8hzxcJsg0lA+bXziLNd18LObhcpEMoVy3L2INEM8nvoMklw
L5B8eFzRDCT3TTLNAck10w8kD8w4miuIcpUkGEA+iwECYAwfHVpUEnzd3U92
AeC6uEzqOwo4jdkNEAKgLc4Vy7O9zUaIvsMqTDTzoEpJPye7vidmOXTwyYpU
VRVUg9JqaglWcvNuVYQSaZSyqoe3zqXXKOKU3xsqSSrrpK2FcaZeAosKrOHD
RHLBZgTz92uYf8jBHADNMG/ujYAGmLccjYAWmFmctwvQAww0w7xjUAENMO/k
23VfHnJAozjvApp3n2eiR0ic9/A9CvuA5v2jGPeOWSFuA2cbWUxi3gQ4H59G
pDFfsjj3zxDSp2Zd3kRMX2OmMUca8o9FOg9qPLIkH76AEe5FT7NVaBTnS4DN
5ZVAoO1iLXZ5TXLjwA0cH4dzTePsel8KU3mvvXzvo+QdwiqXU0Vlu7hSqtTY
xRBIbZeS4aBMmupOTGVKjTDiTaXm9/wpp15O0fp9ROuH8ceGkFYg9REgddOh
kFY8P0AV9rTFg2ojiWO4FhAp73aAFGEFUJ+3BaYd2JKIrAKnLzGnO8/mOIVd
Aqlg2tdGmNULilUIIPaPCasbTRM4PXiZWQVOe8cVqyy7fcDoMexJPI6N3yci
Tk/OeumljoG3O60dhoDhHKBpEd26p2VGACER3IstRhSYGQMqGM+MFLduxm97
lbLbEnpE1wGggoAsCyIG2xTQQkn0mAojPayzUkxSjtnVlfySP3OqhVBKS/W4
+ZCF1T3qTeQ4vLUmSzwRWa1uJQKDKM3Pgo7b8hsU7MmxsH4Ef7zfowqYPnxQ
oSqiejgS1b5QVLcBp08Bp0/3R6wCp8+dQlYzgvW7zAsA6osA6s6zkagOR6LK
oL6uQN0LoO4bQ1gx4j2gQD2ES6+AKlyqg3USRRVvrzk2TaKKwmpbw4FUeQj6
IAjoaYhuTy+gkFYtqTCDNacj3AbuWPWcViyotn6w4pQ08JJ27XQJde2G9tBR
VJBiterSMv5wS4ezVbUUJdQ23EJrwQJUqiAa9xSmblvMVaW624wNfESgItrc
Y0270hlb6tnV30PvfRR/1HPsbsLebyAXvvboYceu1dmjBoh37DK32054doXb
7cDts6eY3UEOCJjbl4rYBW53Abe7R0woshc9u/vHOLyteo3Fnm/C1n7sCOir
xbaLhakfdHQA4tZTfNuCRXVwnnA9Y3FdZL9vH8QKvA4DaeeAs/Mhr3atFbtf
R28qbV1xcC0pj4n/qlL3tsCaimNrCWJZdr3ECrEcxOL+bnqoNbtYVqg5aa2q
AoNPxfL9gwpNHVSkSmF1hbI4kKZ9GkJxswAHHK5vwL15z0UQeUT/pkaUyijf
1vIK0rqp1xClHyRK+RZwq65b+lhhgdAnjxeoa4LQHUDoC2eYUiB055CiFAh9
FcOAXdi+7SiNCI3VtQmIHoQQ4NA4hgEkmA+Yo+D9+0BIj/F2HDz/iRny/kLs
SU9sxSILOZ3V1zOLCC0GAwLs8A2GdjknsnDGozfFGV63SC45c4uwihDeCCAu
yL5qrsmKIoGGxlTX9Ctx2uXXR93t4+pwKw7vMHrV0cIGJa/yzXqC06quiwnc
FsGeRCGsWfp0UDqEZGISedtXUyHsxwncj9kfGzhqe5yRFCwD4exXwglIbj/F
WA4iltbpn7YRJWIJSL7ESFo0XwYkXznnhXPXCIonPVoBrtRGnb2ghof5TkNk
TnF3HJc5gbrsnchc/1zI3al5UspBgO70ogIPKBpaUkq5LA5iBJOkCy2jBue6
NeJSbtQq1PyPZixL82UQVZ5Pt8tWQ8TSbX4BWDX26hos9vB5NVTq1pUAzJd6
OVuSmLQrvr9FxDn1iFCd8Tf1IzVSmvgxQosIo0Xxb4MePgR6+DDo4SO9qIlm
M4jh5iPmbXwKf/mwtzmB8S6nW6+Dbu0ZpVN0ugWadQA06wBoVhMAOjjO2gUQ
9fJ9JkcAoqO2YN+HxaJjoF3HZ1i/bK9oPz6dfGAVjM7iPdYAEpwl6tcyopRx
M+R168pwiJdyg7Jk451CaoQXXdr07hV3KVFhtxMmVQrKJF2WelBX6FKz8Lao
akKTKuo1Lm6qlrsImfgRxqH4eDyiNMZ/JPXsTlqq6griQY4J5aeIFTlbyre/
DTQ9BDQ93MtEHXZE4fuP2acCgZBl7zVbQcaeABl78gRJ2bZ+ljO+mdpK2XaQ
sWcHWc7Au+4AGXsBZOzFIZIy52HPkZS9ajtGQcey95GDVZD+u6daZi8Aug8A
3a8gPTCuQJ1IgDpNitcHlB6bYVJnQSospd1m4JqiFAgdXFSUXjcEaN0MAW3D
yz54oQR30UgTmarIVJ2XjWPDG4ZzGPKhDlsUQQGWB13lLcq1ErCUpLhzUR0c
jLdLYXz13S2HylMFMl/PpAkXEutujdJelBXQ1eNVliOZTVLOqF6kw0JhlZPu
KK+RD2bpBOYjmtueQAlz7AK3jx6VxKpOfhjA3QrgPnEC4bXFon5cLAVwn+Yb
VlPg7gBwXxjy8KIfBh+M8IL/fRUb6ZheIPc1IPd1IHcP9zc7etsk98g00wvk
9s0wveCnT8yxxtYcvSeB3lP2sUCD2OOBAF9HgNFTD1EuI8A2uROSge0iH00G
WuLXOTTEV7tJawXTaqih5I5dENiy9Z58AzMPYbBgVM3pqnLNmX5mvIRc3XzD
taLULR6Je26mV/H1s1m8TOdT8PiBV74xJPW5dOudeHC8NqaVsu4vBSr7UG+S
VvzM40zqFiB1K5D6BEjrk/0ks9uY1GdiWk8X0Mp3Pu0EUl8GUl8ZQVoxYtwF
pO4GUl8DUl8fU7QCqfuA1P1XIlonmFYgtZfveEqRegxIPT6HtGJk2Q+oOrFd
iMT2uoQDodY05WFjSC42nHOWKXgyrpnX25qDlROaYPWT97aMFKnbnNzvgrEg
Xg+TmKyqC/C8ipRA2/eBpjKZsIJkT7UrIb8+xvRCrFdHfRnUf8QJafl9KrUo
dgi78LJ0bkNL/Nn34g9Oyg+FIG+yT7rajOV4x/Exe4ZAMZxSwDEwLIr7rx6y
pgSKQYUdx8KwChf+zWMtx/DLI4pjYHgXMLx7FDm2K6Nj4uP2XnYcVyzE1sgT
jDFWNwFidiKI8VWFcYiwXR3FtrqBeYdxhpLrR4rv+SBZFI3ltvmq09kgEdcV
Tgl2OVoQOpHpGvnUMPmuamgpbKjyQzLtG8GtJRIaZOHavV5YUiFFF91U7atB
oRqHTwpgf3/bzpc77uiq2JlqctaJe6y09rXrprgtT8hl9u/mYE0V7WkZlJeZ
3u0B7qXtEVDgTUdIhTcDvY/2OYJRhbcAvVsjFX4K6H36FHtXC/CD5lmA97kz
q4uwA/gChg0XbW1/d4EI7wMB3j9OInwAyEWCQYAPgQD3ctfyYfh55CoTDPT2
Ab3H5hzBOXrJAXrBtf3wdNvSgh34xYCuRePuZ8oSWX3Ar5Zhp7Z1naRJ1Etx
cK2IZF07wmEmsNWdI4RdxslaXdWQMn/XtE7W4udxU8n/dvp53Kk8Ta+a0pcL
AoBUvl+j9sCCsPaDGs8fxLe+BXh+m/F8+LBCFPDc3KcQPe4R1QK77WSAKAUK
p0OB3TGUYBT43DnCjF5ARr3AjkWMEp8VCyhovEMU8Dw4RTFCr+tVPoJ/zOwo
49nn7oYOsezyCOaelNft2as59pzKLIWCFC5ruvJAI2zZy/zz11pKLLuiRc1M
OIscfkWVM31g4CeWBLR1n351a+evYZSfDboBNQvL8GHFILeiVC94QAtrcVCz
uqtOVj91yEPrp4xEsgworX1SaeFbvRGgAOcmzLcAT36Q/GOgn48r/URABxSg
p4SO7fjENRHQ57H5dAfe/oyAejgrlk7YvfBp2dwFbO4e83zaj+4BNveCdu7D
ttP92HZq4TwwSYCCfsrtd8Cil8trLoKcZzvNo2UXLDaLzliL1k06V16LI1P9
JBFPov0QxZ8hhFWXRtkx6Y4XeVjxCghsusf4ZK6imU+p1C3P4cPV4vZS3oLW
UyWFOhLVdQGvi/mIVXt+r6TyR5VSlYRUEfR9hCA26dHNFO9EIUTOjhdwBoxt
A8aeHvQiuB0YexYYe+6s5qzbvACMvXiuQATtQ6mBMkDfccb3xe254jmr88kf
BNE7NO398xH8C35HbYG0b05sM+9sM8/ut87/189o4EDSqYrc+E750HVnadQ8
/1CdTMhzO2ra1uSo0tT0y+m60uTvQpa74HTQqCkUMgOnm8vk4+fzZFnmblkW
7JyHZvm+46/iTngVhY8H1i7cf1M+1tQt08V/5CsOJTPx2E4UmcNPKClEGQQJ
fAgk8GHYHgEfvanPrmWSSwM2zP4J4/UHHCMzYrOQacmpgBNLCQqS/fc1GzLk
OcEbGPk6wrIOE1NT6UZT6uiJcI0XqvFzN9xHpJzeUI9UkJyYj6V8pu+wbCRg
0bf8eq8ia9VRgpzpR5PppvjyZovg3YgX50VzC92pZuNcJJhlSWHL4of45dXq
PZoSeuL5N8VhCilAySN9SIrZzLf5Pgoi9pi9zXdLP2bNVsuUjj3FOvbMaWva
7WfQZ4KOPQc+8nl83s0O7BV+AXTsxfPiW3fi80JeBh17BZzlq6OYdIzZWxx3
g4i9poRsD4C6d9x4YAHWA1MBsD7pmHHGuBYYY96Zm4F1uFadF2Xd10rn7izn
L1/3SpcCuKoCvhtGikNW8WSj+CZgOF62lmPzjRrdrjXIP5Esp3RBo0XK1VZj
VyumqUSu1pEoAZ8QrJgMwas7GAt1Tj4gEaHel3wuy9RzcZjUH1CkYmjHlD50
tIBUcLWPC6lVsxUofZIotVX1QXmmDpBqOTXbgdJnhxypllOzAyh9gSg1L42w
xwVKXwZKX4GQ7tUxIbVKpF4WovdgMWcvU7ofiznAqR2IaS2taLJrbiZ7KfW0
CpE+YuOPiJetFWe89OElz1zm3W9KUXV+smy1Pa+o6C8kDcn8jbzkSKI17vxt
Q/wXSlZWlclQWOv8f9mV0LlgXNpEK9wF+QUPS8BelFF7YFMJML7xnZrEdzrN
zNHYxzQyiZtPoGaax0Est9gNUHwCUHwyQvEpQPEZRnH7kMKRUdxxPsIxieJG
jaJ5XYsmoehFc9qN+BxeMHwHpfIajvo1LxLzgUjM23r3gu9RXAzeXXTeVrDk
kV6yQKkCuMac19qiu9V87SV4gIfvNItKiYjWLfey8unlGYd+hm4TS9DyoBqd
bHRF6sh8xq088YJO0JahYzj/RkRfQehXM+LK8fvvIBjppsyahxFA/PYR2BWQ
CCzELFpVfKyfWQQOt+ZYpEeDPA0cPnM2YhE4fP6cYpFv7rEc7rwYsGhJNLuA
w92XHYtOFScciqKAc+6K8/hVIn/NPrvGJa7oURmSj/hU2MeakTx6IhWMdqcb
dXOPWj/McqlJWRrSSDzXS+UYFF16HUwsvtxW8WlODPkMfJU7tUij7mPT8aB6
Mg2Bs+AVM5d+5GNbZS5iz7iTyAsn/dlyvsmc2PqGxxT18qE+1kxgdBPEl//y
Gy3zaH/EKTD6BASYT0KAuc1ufB/a02eR04qFFIKDZ4cVpozoizGmgOgrY4hp
xTIK9kRK+W5Kq5Z7Jrz3hHQHuwbn8FI9qXNMKkaX8pgt5tP+7qiNsyH/uB9X
uc5w/SWMMunpXOS9pzWynDc3p3I32ugeyW4Psf8TObIREq20F9dpEt/JnqW7
124Jw1pXI56rUb+6zNOmVLdz0ArNcTFITwcdtXaprNzRLdGBe0/94bR6UNGU
5D7l9eW1gTmP+wME9CeV7n4DYP4mwPxte3f7Q31Od5ln1F3hGVjeAixvBZaf
GESere6eliMjz5goWaDfgUALzDtGIqAB5p0A88tjDmjU3F1A826g+bVxGYxZ
67Hz6PrSjBhGlRRdNh9nRuX8ZiK5BKtWXH+kWqS69KVlBxZ2ctANPRJ7Cu4u
JuiOMKUwgvaUuxGtoDJeWBaqpspCSgXzFDai3iX+go8cvGBn4RqPl+l6Yh9B
/uU7N+hPQ9Gj6eiqvw8R/BbrKWoq8PcI8LfpRJrBLcDg1kHWVNDTbWeMZhD9
/nbg71ng7/nzIYP2cy8xfzvHFIPM3y5W0xkembplsGrJy+Ux4vKr5PLn0xFi
Q6+7KABVyfu6M62kRryY3ZQuDBVvLtkpccPtTaRTGMRYlB68pUnSvRhZNVoc
dDfv5IJWDG4pKBAGRQfdSmHQCszzYMXhoEQ2RV93oj04D15QMxe/70JcKkck
Fn4CnWYNz1LPW2AoP2V/4B92AO9vIdsySKA9oSB7CiB7eigJmq0SYUXoBb41
7KVR+9pO7JsQ0Pgc9ToGneolthT7bBkdzHEaFrEqu2YZNta6hl5bnlS2rbpn
ZQYpAj/dVT5W90TF4EpfGrdWBk8wzqc4vl5JdW6H3k27rFC8xCeD48LMKh1h
JbhYx5Dw1eB2iYVo3PkLknhrb8lXp8rh6gA6Y4rrSbwJ1xrWFc5v3qkQ4j8O
8g2QtW8eJWn7NkvbQyBtD4O0PQLStqlfydsAB5lsECs/M2iemWBgZvFf9P85
NdaVyEvOoW1WzYS5oUYuRvKPKiOpfKP7vWkXcdEpqvUQrUQZ35jlyzFyDgIR
7bwV0iLHiUo0ok/+EVZ6Ac9f0S13wLBHd8XIvdv1WGTwKHJft3JbRhCJ8Ctw
oKku3yi/YSe5YvKxQ/ia3S2T9MOsTAFJfUwSUPQQUPQwUPRIvyIJHORj4CAf
t7dhb8HOma0gXU+cUfI1xPIFsrUdZGs7+MZnwS8+P0I+cscFtl7VXLWQzOSI
n3XhRz4wq7FDzHxOwXlwojrIc3lRcuJwDa7KsZhyi2bKrg3LWhw3mEWFafdT
BljfEBg+7CLMket61VjJF+Gp4jVVzsnkvitf4JPnXjRlabHbu76GXkzW3jFq
sqmQqhQQmPmYTZDTGUxWC/Y+z+VMv/SjYsfcKhGz9+kO2LOf2QzcPXoyYu9t
nr2zir3hAvYuKOm+ausbMzlq2Diz1jh5uas4uat6b1l3nlLwdZlBxVVj6qGj
pOXfADwavVQf1o1Q3gLnWViFyXx7t/PCKcgybtXyt80U3KaAwi3d3yo8XTEu
DQpl0TnbyMTdIYmp7CIiKbUXHwo2EpzJe+/QsH3AwfYNgO2bfQwcw/YQwPZw
fwI4CNIeH6RAbQvQthVoe/JsgjimbfuIqPK0O2mAzW4keOhvhQL7rq2iyJaF
+NUcfplERSpKUxGayVy2irJXkIzmq35yF0zYBlhVfTA+bPMLJZm9UZHuKo0o
4xW4ljtWcKcfhxSsYnHpJKoS5mqDnvygJs2nkwycdGzi+xoCumpc8Y74Cffg
8WpK3rwiFyBvZXILrAoM7O9vJwjpL1+9vzMIAcDNAOBjgyGETwiEQwwhAPg0
APgMrxvXi+Bjq3nhmyHwCLpUXU/CPnsYea2LffC8t0emLd3k5ae6hzHscxCv
XI9R9Dq8FGanwl417pFRktgVLhh384JxluWfaI6QShwoJepEuEdnphu5Ul0R
PS6n6ElIlURlys1mEX5Rdqsfg3nLqD8JlwA3TDO5AvcZ/PEeYg04+0Yfswac
fZs5e6ifWLOf2QRiZ1l7VLMGnG0Bzp4Azp5kzrYN++LvlDJANcFbhamzn7Gv
xbmGkFf15NW11IlSEIEVaqhxXiNUv3knMgu4R73s1vA3ofgKSFNuUannGq+U
0oV/nKSmnl9mPyQd0XZfPUULclUaWdUVeNNEfxlNH1hR1fDeNvcMHtyrl8Eu
VVLOSqp2UcEk8/f064/6XUZwbSS4Pmt/UP/lxpAiVqtHB5kiJmgLEPTEkKup
TuGOp4PJNu2u8qqWiKvWEZYi4x1KE2s0aO38qgOrEvUR+NiMf8t7y1p450cu
hFkyRV0r6vF3uSbourrxWW5tzrWSeqP4FHXO5JMC/2wGOqwO2uCye9TI8qBn
1ZRD0/GSfuST8mDJPzqpZOyW1q2KZlpXm+UgPe43Vqu/gz9IqK1S4QZK9U1Q
qm/xH9et2LoTX45Vnim0xpTd0bS3n0A1jcNz1WLqMx6ZHooZ5+CiyF4nlIyP
SzJVNYhWwyN06srfKcmXGqy87Nas+OykpS8Xa+XLZt3qaXRq6YpPX5aufGyv
gv4sC3pUunKPuZWfLhGIjt2lmgjU68kUVLQmk0iqMMbLu9m6Oo7an2eHC6qf
Y7cXsAPcfBM83LdAl77dT57uIb69fRPo0+ZBMfqkfdyHcNHgicTOSjZ+b9bw
Gqf2TVUVHEXL8ymA6DIFINcOGgHk67YNLlDooHbJCUCCGBeIVRIliYZSHxlO
j0uN1ci+Ezc0ZeFfPBKu4rUjFxhFB4ml6BaGkLccp2UrUMovuokU0tKURyjl
a/yeFk4EfxR/9HhajiVoAVIePuly4wkbdhRqT+ZjH5kRV0V7soYs8Tic2InF
NPFX+YhSjI+rWl6EakFJeoEDoyjuqbkAO+W9UroS3+6QicvSPtAXuDAEiTuS
FCeqIylLLKPr4Q3GLD+UfjkypSDujTCE8mvxTS5d6KaUfAnXh9/vIlh+LHZL
xwJQxCgTPK4TeDIOl5rGhSw0ZaMZD4t1VvQvSczgYJH4rEJMTcHih0gExy8q
V12w05W4pTULHyvFXqkZNk+wxNAzqnm5RqmLVx3J2lRjRVYNOdHhTtOVrvKc
9CjvlVFknW1IiElNScg1U9y9Xg9Fx1ce9Id9bOOb431iJr+9mxj5PP6gI3PI
kkkuM67GatxFhxMWgkmXUggTOoLhEJhcUXnKVE1k56ggqTI512bm7U4X/Br+
gnH3OxMeARn2Hb9mnLm79ehqZJWP2UlVi3xjo1+zYTxmTPgMSB3+6vU/GRJO
sb1HEvPmo+JU2JJa1vFIRCF05oMnOYXw/poNjoX3Egt/1/7g0xh3XwxGPqvr
5VP8ndyXkgZ92g2SBr9CIrIw6wDC3wogiKx0xVv/mvH3x9V9X0FdBycCRlYP
752rqqhEVa/FurqXoFYEhSrjJFtdmm5JWE5eeq59dMQRvTztAd+oqyEztNnW
u0wSb38YqXln8SKgP6dg2VnFQLyTmmq4zbIseL6jSqCy7kQq/d68fKw4a9PF
a/nAY0y4Mc+HI9VcKmTf5XQoj5Hs13mWukuJ1CGlEnDNfS+ut1A+7WBZCA/P
/acuwba79UGuLIiwKuX9UIP/r5fd1NKbXx2JQhb9sIVwiaQpfyVBL5GoC9ZN
/bP+LQxXGvafPYRNONoeDB2hppdbyhDBN96vAtXc4odFYhz3M67vdeE7CAuo
4AiGow3cmA0+T4k+GozfJX8luDlx8dGGCjQcBZLKiFq6VbCaW3+t8K2Pohxi
eudbuvhWDd2tyYFmPuoQj5LlnsvuH2DAl+hTG7moIEvOwnso6268uxIBSEN1
16sJU4/KyfUYLjyQH2i+K/tzkQK4SDQa8qr9v5ysSMMEvjGhyxzd/qLCqV7g
SGbs0Mw6eZ8zsQvCCMPfiNNwQ+2raH6FMwur+Pom1+AW/x4n/9VoBHl85GUZ
a96CFfQwp2lxfM9viPhX7f/r0TBmMqml94jH1k/gKHHxzyEMgxK/6hOOoC+0
8dN3Puvmc3dyPqOJxp1NgiARo4Mq17RE1mWjgXaDW48Hlxd3Mg4VsrD2peth
Ur8Q8+oQoUuHCJzsBBM9ihu5tO7bK6Td1eu2vydLYoKaChQ9Hk3d4dOVFHSP
g4xTV8xJgAOf06xxvUK8c5reSrEdGBlnLrwC0XKzQa0x6iXKD9Ow/4gb9o3R
wtA4Dta4Y3/Cf7nqPH1WlRARxV2BEM7taTfLqPigEkfXZdqVGP4KNZ3iN72T
VzXz3DJ98LQZrwBVtbgsfj3KHXRVK3wKiFtoyTjX1LNSLbLw9FkOTivsG3Q+
PFHlqvPQ60eGNW2nmer11wlI8iH0YZOFry/RI6+poyrKFHuUPvCkt39BJxCB
CTcXG0jCpNp49OuJdZOarx+IxtO/sqpjgM5flRB48KWUECcPJAHXwpb0eXt8
Fd3pGngXV72j52lGd2v4mmVubKTTpebuaM/Ch7/UwzGvR+twMjZODBCBmnH6
4Y6VGs1q+kbOmsciDBMjKETx624JmB/P6tvPvUjUw0JCgy7Ji4Acw83/Qhqq
rvxIQZ6EdbTyz4e4Gp6qNHxWHA1BCSE0FJ6ZqispUaCEscb1a/kaK0PdN3fW
XLNdJnG0Lzsthee25MYPp3DBczCCZ1N5INT9PP4y3LMCSfPVnPHBoHiAIBis
qX/ib0FTgR9MeqAe3b0VFQQiZ1AvCuFTVlfqXw9GX7yALxyxGogjjNUgEwhS
4+9nd52OSu28WeYWMtzvggIHAQt+bDSzEgd6V0A5ntMC9bxSf/sLbzW9mMEj
7esE6jXHSJZ4Kk9qtnfpmhPPX9+MGdWXgqRRIlLXzSkXNRMPLb7Bf1qG7jkN
o8GNTht0mzCTIME8xX91dabBWW3kNy4GgxuMobT1SOaqG7mV6FMax1M/9Pq8
+YIQ1439OUlK70e56tesZL5nuQ4zvpys6mqH/hEQ+lYTganpaio3rFTlx1a3
3M6Eg+TDuTBSiP9OUrJ/XEt6pWg+89/O/ISb+Q+ErYpe9XM5R97t+7qOXuLm
SU8hn6/r4IRX6wW5XE4zyj2FSQakPJj5kmEJEMGdR2HTF43qAl2Mz/mjGKGR
uDkp6oVVYQPDHT1s0w99wY2eKnpo5tMKz7BM6nrUpOF2FMpGPS5D8uktS1N5
WKds8jMcsrDgx8x8f4KZrgQ9kbdIg+N9hEKGx2XSnp2KEVTZhxwFN9egQWfs
nPfRoSp9ea2oqLpPkCry+pr4Bt6HlAQFBU2AmEoSRSUX4Q0hmc8cU8qhnYMn
8oae9XWiYtmprt51E7sVojWJQGHY1y4Hhymq6dKzLyguSMmGzxa8Q0hV9xq+
1FOT0ZZNbuPVAz7pzBHGBG6oK7SO5LGSSKBG/Q2zIXSiEXU39il1vmZvuUou
Rvu0kHuOZTA4BUy047kbEmUk5BqSbcm+TOAjwGDUadj1+XJHYvlYi4pkuSf5
+qGje5vpIfZRTJ/6y7mFMSH+q84Ck1oprFA4EJUC7CcmkZEpx42sI2s34Wu6
yinMKuXu4kPrBWUO9uixOz4IqKgeFZ//B/YvvPs5vsWGDyWDkO4+79IrjNFA
diXmd5QLsvhLoOwXn66aePHJjyvdVUd/rSV6y8cBDxSV+rLwj86t6DHk3KCp
l3BwMGkMa24MMyn/yJTVa0vBHBKPfom9PCVwqUVA+W4tdOM1WgRuuvsFZJjr
RQPpD57Fndpq2opgU3tkYp2YPyCqMm188+QNvbbX8E47/VhtXzGIxsjPR7rr
gx7kjy886GR3Y8L5VtRr48kofSIPflf4mxRfRoPYR0SW7SpxGZ9u2EHWlOVZ
P058NN8MtOBiEL/ikn8MdI4eebhgwXSsqIcSNX2FVg9pVfW96tlW9EQtPfmC
m0cq7sno7K99MlCgl9TRTs8C94MZRU1doYf1wxp52DrNSy8iE7kos+rDb3xN
GnlIO/0MzURu8VNUgo+dqr6dQjnVODfwYRT9O1pZFavLOlv4aCmURgqxoghK
3ehfk0uQO7T58pf8B/REbdpyx5Kf3bmnBGi6gp4hL57U28vLIIm0uDAC9vEx
TWmdmnHkpsKkaKrWSGnJmWXkM91lUZY1xR+ICmZZrgu9XuRC/X1aQW+xDpAj
2U11hVZLCio+fuJ+9EzybZ+1uMcs5qW57t7g9mIZN7AdPzZH/zUOMkR+1kdj
m6vdyXj6uUttlrTE2UYkrLjIZGZHrORycRmEqhpkrdVN6aGoubC56pKiXOCU
5dwuraW4wZhxfM7YuNd74zk3iQqKpZVQwsWFas2ultwmVXMIZOGN9NfDkD4f
Rfuyu2/383+azcfTev5eX21kqWGFuhQid+t/ezAxif0U52sc9tey0QfuVZ3O
ysAE9W5Et6EiTzKNKnjQe7PuwHPhwPjZcY13RAVtPfFYgaN+lqBBWyIl+40g
UuIqaOkTV8J7zj1NiYw47mPL5508Ju9LSGxXPG1kP36I/FOeU96zxHH6FjeZ
i/72LJ2Z4W+Bw/S/xbdgk23kkUxyBrI6Te82OfushtGszjozrog24lq0XL6P
iFK6GY1D1b+otD81SoFaFSrYT9B4vdfNoVRaURihRvFrZZWhyrhfBCcWT73z
JiwcVOg3L4wXKNhRi0kc47BrzKJ7Sf2YN9yzjFQq0lSr9LrTINBMXVbUuWfT
PSUOp1UY+7jZGI1vsAghU5cUpeluxs9EXBQW17XTTQ2tPNUgy4L7Ur5AY/ru
cEzb8H3Rh73SymWNB+cXlgFVL9iE0RUuKQ25S6yoXFNCWd81MO1wv+pe861C
6v50eYqGPcYlN7L5TlNsK/BJDA12/AA1j0Ut0F9ZbM53Ruhyc9BIqHSY7CQ6
rP/sQ5MXp3iZSz0kS85dRyOirjyy70qMbIeln6auHXJVwMOkzLchOfRNaSLW
yOo0RQ/AFIq/bxnSscxV8axdoacsfO5AQopdl4BesPIh7byzRtndc3yX9oIm
PhnvcEwgNeScucSef4/G6h1urArnXqq64+dj/HCJxMDq2CuQXJWM8GFVS17o
zDeqWKCpFyD8jdNFD2nKMu7oSbXsVahlD3mPbg3xiYlKNDU4MkFFcetxeqIG
sKFqR/6jzeB5DdZg3tg/QwP0tk7Cx8j6qZsx/Mjpv02J1z/uBpKkM3e3Dg/4
pPMwYSN1TS+xh6tvkeurqF7KfBwkdR4dgfLokMGuBDNLvtalCnWBxaOyu7wg
zeOK+oRv+SINw4NvRcSYDlyCcF3G4lygBWXt7WxC8VM8Klf9poMUmTMNGs9M
Wh9rcY97RS2E+9GRIKSmRjFVj6MDJsIWH87Pu2xgJZikpPphIMEbfvMf0Phs
7DhCrCaGoZL4nArwa5iJqdS5O61K1bB4zSMik6WWQF65HnU3mxQAMY+eTWsX
u+6oUhY8DLNg3bZO0YM/meiRmWI8b6huR/PPk9U3JGZF4TJOak3PG9fPuFpi
AAt3WrFDUgtrlKhknugGq8YFo3OS6XC+SdKV+YdwON+f+Q7BMcMrgboR3Ht1
jgSyBtcvs8y3DNjtsgQZQSPpFaWakrF5BUg9KScYEPztyzQg3aXTwI+k9yAP
JHbftF3nqcBLWb54fSe+Dy2g3WfFsEsrahKyBjMm850d4Q3EHL7pru6Lhhdy
s7Cdq6bWF1I6JfFcblJJpFBx8FR4UKOwHX9eds8t8U9FaHLvW/CYm0wFyjxa
XaXTxw9uKkf2n2sjAouC8VyBSS5qnO/xl2hHBmgiHigJAeBgI/z6lATXURxQ
ENBxBHHV70jdAK5W2zNaumOkZKFy1irXXDhNMm7BiGok3oyRdHgr/FI8eXqK
DFl1MyI1RClvEjl/vxdW3mGnXPn7IFNFoh4GecobhSwZNLZriwdxsdTUxsKA
iOem72uR95q8glqNMlc9st4KXla81PyKchXVkNeU9gSMFrJcXvLZkDgN/djF
4dysr7ohEANpbcq42MrMSo2AjxDWglx3QT75kmhBvLzb9YwzX3NK/t6qftKd
3cclXcn1FveP0/o1FajWwvneSNijsOjSnTB8T8K0qUhKCjESJiU116tq5hb7
cX9ew72bzjhSVY+XD7tKa05to3noMfPn/Btko7e7ib4h/FA1tEyUcaWMktNn
jpzUd320g6/VnP9naqyxHJHi5cZD/DgHw0sNF1tZerW5qJRxMdRg3m+TH+jp
h6srgUlhUvqPyYDvdAZshJdZHvf1FH1kQ8LkHYWB8tzgSEm6E5w1NEm5xKlH
0Zq3y4bEOXn7/TYZ5zudcVJOIZXFPxAeoNhWoQ1SUKYOGTnEaPJV3dRMkhDm
x9lqrfv4xu+SId7jDLGx/LKywAYpw6cslHTsoYWiv4xTOIGTNBUNc2osox38
Hhngu5zP81fyYGI/Kfkqt4fXlJ7QHvlAvV1eyq2RC4sklOVL/UAC+gcTl5CK
hFKGSD11pid8NxqCDUUmqYWvpWIU/+5X6HI+5C7nwaKTi2iMc58VY2LhSDnQ
3HDkdxqddaEwROMUmeKrdGHfzSmHTvC713CaSZVJU7Mh8VtXwlqFClvu01NW
iBjla/9wqdeqlF6xJyk1/VOhZ6H/SJoi9yTcQhHD3/6EruijiVmXSsxT6tfG
GEZhZhuqFa/SrKiIPjUb/BEK1OtrdKEfdxf6QPiNNjxkO+SsTmzgEuXSslhi
owmb8iH40tfpsr7HXVZ3aGDPUmoX7Yq8zKyUmJZXF+qltigsfPud/jO6wO9z
HjBVbo3uAPLvFp5rj5uG5YLe7jRMeTQ+9U+4U4+SzVzRq2wKRSGMh74QjZQB
aonL8SKfauj9F3QRP5gALOV4IxsWht3lfLdRakklA4U4/TldxCfdRbSRhkV7
9MC0gW9qwqXsUTif1GtFivIXdE2fYj+cZYXOPxVv5Ht1O5y1keuPRqKa+M1z
9l/Sqf+wmxhRkTjFVBau5FQS55WaoakIpivx2n9Np/QZd0q1hKnKvVrktgu9
WvTaKgFZFnzkv6XT/JwDuaOcLiVra/VdbQKf+vB/RxfxYwlyIzdeeKg16nVx
D+yKRNnqNXtQPtfPF0V8EUaFIOQcafA1H/blni8Ov/1rOocfT8RoKReYmryF
EX5q4LoT5+APmboLj8/wJ93sSWlkSmj0X95eyTn4QkpTYbff1f9AZ/PTRWOW
8h/RWauEPBekFeqB/9K/oTP4+6UjlpKANuZlKoIurB/8z3QiP+tOpDDqLhyY
8kKaDiPjOL083+dT+5I7tVRGH0lsPl5NLbDEf7Ew9Bx+l/8rncHPuTMoX8mP
PELq/KJp/b/RAX4hEQAWlkjvO0Tye/7f6fBfDi1cLTrbwjJCT+mJ4L/+PR3q
FxOmTFc28mNVmMvhb/+BDvDLCYXxK6SFnsKfjT+ev6r/SPv+1SISk+FPyXOv
/y/a36+XGqOdqnA48f8T7fY379cE/re/oj3+dqlQ+l4Nj8836ItUnk0vu5XP
IG+sb9Gu/kknc8Rj8RB9+w8SQ+cRT3ks/uIfJsYoFcX6M99EX/wjd77xBMpJ
1KP0jT9JWNl/93H60NcSHsN/aCt96OvuQ/6tJ+mtP3Nvedl+it76z91bESPP
0PuU6IVW4rfwHx//69//+ve//v2vf//r39fr9+w7/l8GNW4A\
\>"]]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Die interaktiven Animationen der Tangentialebene", "Subsection",
 CellChangeTimes->{{3.405595032803203*^9, 3.405595064245582*^9}}],

Cell[CellGroupData[{

Cell["Die animierte Graphik", "Subsubsection",
 CellChangeTimes->{{3.405594815606231*^9, 3.405594819670194*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"G2", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{"u", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "\"\<Fusspunkt\>\""}], "}"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"x0", ",", "x0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x1", ",", "y1"}], "}"}]}], "}"}], ",", 
   RowBox[{"ContinuousAction", "\[Rule]", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.405499745708001*^9, 3.405499765929048*^9}, {
   3.405499820839619*^9, 3.405499821447991*^9}, {3.405508806933156*^9, 
   3.405508849616687*^9}, {3.405588485636971*^9, 3.405588496834991*^9}, {
   3.40558956620697*^9, 3.405589576661356*^9}, 3.405589665033029*^9, {
   3.405590625854673*^9, 3.405590631684735*^9}, 3.40559095151018*^9, 
   3.405607392400405*^9}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = {0, 0}, Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`u$$], {0, 0}, "Fusspunkt"}, {-1, -1}, {1, 1}}}, 
    Typeset`size$$ = {290., {214., 218.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`u$417$$ = {0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = {0, 0}}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$417$$, {0, 0}]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`G2[
        Part[$CellContext`u$$, 1], 
        Part[$CellContext`u$$, 2]], 
      "Specifications" :> {{{$CellContext`u$$, {0, 0}, 
          "Fusspunkt"}, {-1, -1}, {1, 1}}}, 
      "Options" :> {ContinuousAction -> False}, 
      "DefaultOptions" :> {
       ControlPlacement -> Right, SaveDefinitions -> True}],
     ImageSizeCache->{496., {241., 248.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`G2[
         Pattern[$CellContext`u, 
          Blank[]], 
         Pattern[$CellContext`v, 
          Blank[]]] := Graphics3D[{
          $CellContext`G0[$CellContext`u, $CellContext`v], 
          Part[
           $CellContext`P[$CellContext`u, $CellContext`v], 
           1]}], $CellContext`G0[
         Pattern[$CellContext`u, 
          Blank[]], 
         Pattern[$CellContext`v, 
          Blank[]]] := {Red, 
         PointSize[0.02], 
         Point[{$CellContext`u, $CellContext`v, $CellContext`z0 - \
$CellContext`\[Epsilon]}], 
         Point[{$CellContext`u, $CellContext`v, $CellContext`z0 + \
$CellContext`\[Epsilon]}], 
         Point[{$CellContext`u, $CellContext`v, \
$CellContext`f[$CellContext`u, $CellContext`v] + $CellContext`\[Epsilon]}], 
         Point[{$CellContext`u, $CellContext`v, \
$CellContext`f[$CellContext`u, $CellContext`v] - $CellContext`\[Epsilon]}], 
         Point[{$CellContext`u, $CellContext`v, 
           $CellContext`f[$CellContext`u, $CellContext`v]}], 
         Line[{{$CellContext`u, $CellContext`v, $CellContext`z0}, \
{$CellContext`u, $CellContext`v, 
            $CellContext`f[$CellContext`u, $CellContext`v]}}], 
         Black}, $CellContext`z0 = -1, $CellContext`\[Epsilon] = 
       0.03, $CellContext`f[
         Pattern[$CellContext`x, 
          Blank[]], 
         Pattern[$CellContext`y, 
          Blank[]]] := 1 - ($CellContext`x^2 + $CellContext`y^2)/4, 
       Attributes[Power] = {Listable, NumericFunction, OneIdentity}, 
       TagSetDelayed[Power, 
        Default[Power, 2], 1], $CellContext`P[
         Pattern[$CellContext`u, 
          Blank[]], 
         Pattern[$CellContext`v, 
          Blank[]]] := Plot3D[{-1, 
          $CellContext`f[$CellContext`x, $CellContext`y], 
          $CellContext`t[$CellContext`x, $CellContext`y, $CellContext`u, \
$CellContext`v]}, {$CellContext`x, $CellContext`x0, $CellContext`x1}, \
{$CellContext`y, $CellContext`y0, $CellContext`y1}], $CellContext`t[
         Pattern[$CellContext`x, 
          Blank[]], 
         Pattern[$CellContext`y, 
          Blank[]], 
         Pattern[$CellContext`u, 
          Blank[]], 
         Pattern[$CellContext`v, 
          
          Blank[]]] := $CellContext`f[$CellContext`u, $CellContext`v] + \
($CellContext`x - $CellContext`u) 
         Derivative[
          1, 0][$CellContext`f][$CellContext`u, $CellContext`v] + \
($CellContext`y - $CellContext`v) 
         Derivative[0, 1][$CellContext`f][$CellContext`u, $CellContext`v], 
       Attributes[Derivative] = {
        NHoldAll, ReadProtected}, $CellContext`x0 = -1, $CellContext`x1 = 
       1, $CellContext`y0 = -1, $CellContext`y1 = 1}; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.40549976663126*^9, {3.405499825265665*^9, 3.405499838909466*^9}, {
   3.405508850682068*^9, 3.405508860458898*^9}, {3.405585956416951*^9, 
   3.405585957504962*^9}, {3.405587866991772*^9, 3.405587878497152*^9}, {
   3.405588014827462*^9, 3.405588023044804*^9}, {3.405588171295624*^9, 
   3.405588171641606*^9}, 3.405588497812797*^9, 3.405588897936123*^9, 
   3.405589665852587*^9, 3.405589740291842*^9, 3.40559063371171*^9, 
   3.405590952466549*^9, 3.405607393095249*^9}]
}, Open  ]],

Cell["", "Text",
 CellChangeTimes->{{3.405503109501576*^9, 3.405503166828603*^9}, {
   3.405585990810459*^9, 3.405586008963657*^9}, 3.405591308939785*^9}],

Cell["Wir faerben die Flaechen des Plots explizit.", "Text",
 CellChangeTimes->{{3.40559097231729*^9, 3.40559099884136*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"G2", "[", 
   RowBox[{"u_", ",", "v_"}], "]"}], ":=", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"G0", "[", 
      RowBox[{"u", ",", "v"}], "]"}], ",", 
     RowBox[{"FaceForm", "[", 
      RowBox[{
       RowBox[{"RGBColor", "[", 
        RowBox[{"0", ",", "1", ",", "1"}], "]"}], ",", 
       RowBox[{"RGBColor", "[", 
        RowBox[{"0", ",", "0.6", ",", "0.6"}], "]"}]}], "]"}], ",", 
     RowBox[{
      RowBox[{"P", "[", 
       RowBox[{"u", ",", "v"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], "\[IndentingNewLine]", "}"}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.405498604890969*^9, 3.405498695972356*^9}, {
   3.405498792719001*^9, 3.405498793034434*^9}, {3.405499099930385*^9, 
   3.405499100284575*^9}, {3.4054991569661*^9, 3.405499181183708*^9}, {
   3.405499347350066*^9, 3.405499366074372*^9}, {3.405499401479907*^9, 
   3.405499406244736*^9}, {3.405499471731608*^9, 3.405499695242928*^9}, {
   3.405504319885591*^9, 3.405504356842648*^9}, {3.405505715073465*^9, 
   3.405505794697797*^9}, {3.405505873437312*^9, 3.40550588679118*^9}, {
   3.40550593178545*^9, 3.405505943284107*^9}, {3.405505978555648*^9, 
   3.405505984820617*^9}, {3.405506017196908*^9, 3.405506030600681*^9}, {
   3.405507235340171*^9, 3.405507241596611*^9}, {3.405586154691471*^9, 
   3.405586155510304*^9}, {3.405586209019653*^9, 3.405586216332029*^9}, {
   3.405588428884145*^9, 3.405588430644445*^9}, {3.405588546683959*^9, 
   3.405588561735124*^9}, {3.405588922246601*^9, 3.405588946871218*^9}, {
   3.40558944230481*^9, 3.405589443692722*^9}, {3.40558969641536*^9, 
   3.405589716662426*^9}, 3.405591089327925*^9, 3.405607402918452*^9}],

Cell[BoxData[
 RowBox[{"WriteLiveForm", "[", 
  RowBox[{"\"\<demo-2c.m\>\"", ",", 
   RowBox[{"Graphics3D", "[", 
    RowBox[{"Normal", "[", 
     RowBox[{
      RowBox[{"G2", "[", 
       RowBox[{"u", ",", "v"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}], "]"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.405607419388186*^9, 3.40560742499042*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"G2", "[", 
   RowBox[{"0.5", ",", "0.5"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.405505798521421*^9, 3.405505803501624*^9}, 
   3.405607411508209*^9}],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[1, 0, 0], PointSize[0.02], Point3DBox[{0.5, 0.5, -1.03}], 
    Point3DBox[{0.5, 0.5, -0.97}], Point3DBox[{0.5, 0.5, 0.905}], 
    Point3DBox[{0.5, 0.5, 0.845}], Point3DBox[{0.5, 0.5, 0.875}], 
    Line3DBox[{{0.5, 0.5, -1}, {0.5, 0.5, 0.875}}], 
    {GrayLevel[0]}}, 
   {FaceForm[RGBColor[0, 1, 1], RGBColor[0, 0.6, 0.6]], 
    GraphicsComplex3DBox[CompressedData["
1:eJx1fW3QZmlR3msSk5SmSiGkLK1KojKi+IEoYgp/eKtI2PEDjWAqYomURgrN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     "], {{
       {Opacity[0.8], EdgeForm[None], 
        GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJxFmQX4FVUaxg/3jDDEgISkICCtqISUSLcS0iBSUkqXoNIYq64da6yNid2x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           "]], 
          Polygon3DBox[CompressedData["
1:eJwtmgW0HFUWRRvqwX9JJ0CwEAgaJLi7Q3ALCa6BIMHd3YfBBxl8cHd3d3d3
1+AeYPbm1FrTQ+163fW7q66cc1+m3XynYTuO3el0hvB/hf+O06vTOY3/7tl0
OhP07XQWqZ3OuvCf8NLwe/Ci8LTwl306nU05tzPHJ3LuUNZm5rU8x19zbkHW
3u92OpfAR8Bbw1Nx/Tfgm+GZ4XdYPxc+EN4CLqyfCu8Bjw/3g6+C/w0PhK/j
/fPDA+EF4Lfg0+G94c3ht+Ez4H3gkfAy/KhdOf4P5w7nuy3JuVmbfMeF4PG5
/hUc/4tzk7P2Jp//L7wXvBk8AetXwkfDU8CD+cxy8Fft35+Q9avhY+Ap4S58
AXwIPCn8Rjf3Zhd4BPwZfB18Arwj/CF8GXwUvA38NdffBl4V/pX7O4DrPQD/
D56e9ct5/zRwheeEr4IHwxPA88CXwVPDPfAc8Fdcb3N4OfgXrjc513sQPg+e
gfVXeP/B8ObwRnDD+inw7vB48GusHw1vC28C/8H1/t3yuPANrC8ITwUvBL/E
+oxwX/jdPvnN/vaTOHcYa6/zmp3jiTn3EetT8vdegK+BB/PeceEz2+fXD96b
17kc38+5G/lsD+tncbwv5yZk7V3+/v/gg+AtjU/4PPhgeCu4d6/E1wHwJPDL
rO8DbwhvCH8AXwofCY+CK+8/G94Pngh+nfUTOolxY70X6+fA+8MTw4P4TkvB
n8Lzw3vyOpvjezl3PWs7lTw7n+FN8Jy8VuP4B84twnt34nUyx7dw7tKaHDFX
/E6nwzvDp8C3wpfDB/qM4afgu+GDjAn4afgeeB5ea3D8E+cWY+1QY4Tj5zh3
f81v9Lcac2fCB8NXwM/A98KHwFfCz8L3wQfAl8BPwHfCc/NaneMfObcoayP4
fSdyfAPnLmJtzZLYNwdOqXkmPhufyX9qctxc95mdVJNj5po5fHRNDpvL5vAx
NTlsLBgTx8K7wKfCt8FX1Dxjn/X58MnwFLwW4vi9Nh/MKXPrcs6dxdqDvL7m
+DNeg3iW27N+HOvXwuezth18LHyNOQJv2ze1wRpxNjydNYTjTzg3H2vPwh/B
H/Oahuv91ENOc/wBr6nhfXjPBbz3EfhW3rsgr7U4/p1zS7C2G6//cnwH565i
bVf4NPh2+Ep4d/hM+G74WnhWXity/A3nFmZtFngFeHSbf3vxOofj+zh3A2v7
whfCj8K3wWP1Si20JvZhbQ9eZ3F8D+euY30aXkv4ezg3b9/UyLXhP5rUzv14
XcTxY5y7nbVryY+5OO7fxv818JzwpO39uRqeA56kvd68fGYo/DO8OHyY7+H4
ec49wNpFvJ//dH6jH83C2rR830/ML17TcTw2r5M53o3P9GV9PPhiazs8AN6f
18UcP865O4yHXoldY3hG1vrAF9qr4P5wX/giaxM8mflSUoteaOPjVb7Pvzje
hnMbsz6Gax4Dbwf3wL/DR8Gj4HHgZ+Ap4QK/QX17Gh4Ijw2/Dj/Uzf1cBF6Z
978Ibw2vAq8PvwBvBa8Mrwc/D28JrwSva32FR7X9YQP4Sa4/OfwX9+tVrv9g
N/G1MOsrsf6U9wDuwK+xfinrk4FjeP/srP8AP9xJjBqrD8DD7Y3wivDt3fS7
Wdvnfwnc3/jl87PBD3P9ieBv4ee5/ts1/XkK3v8Z/KoxC08IfwC/Bc8HTw5/
Ct/E9Rb3Xrf18OtuYt+cMDdu7iYep2/rza3d1NsZ2/h5hevNAveD3+d6t3ST
nzO09e9R1iexXvH9XmT9DWskPBnrH8OPwBPD37P+Avwcn98CXpH1dfj8E6wP
aO/XK6w/y/pIeAXW17a/dlOLzFlz95Nuaoc1xdryOLwRvBS8hs8L3gReBl4T
/rGb2mCOmqs/dZOr5pi5dmM39WzqNt/f5/ssZi7AX/F9LmZ9Avgrvt+srF8P
LwBP2UR/fdyNPrGmWds+h2/upOfYe77opvfYY+w1t8FD4Fna+vRzN7luTplb
j9c8/1/5ey97/7rRh4uxvqr6hvVh8ALwD6w/yvp68OLwav79mvhaEP6R9We6
0SfLw2sZr/Cm8LLwMOMLXgdeFF4F/rSbWn08vAP8GNeb1HrC93mJ633ZTa+0
R9grnoZHwEPg4b4f3hBeEl7d5wtvDC8NDzXfuN4guDf8Fte7oxutOBu8FOt3
dlNvZ2+ihyfqld5nD5wKHm3N7URf/MbnJ2b9RnsdPLXPg/WV4Dngb1mfhPWb
7I3wNKwPhJ+EL4VngvvDd8Knw9PB33TTC6zZ1u6Puult9ih71btcfxF7EfwF
1/+jm95uT7e3T9orvcb8mhaeDL4LPgMeZP3h89PDXfhtPv8iPAPcB34H/gs+
Dt4B7qV26EbvjQfPBf/J+rHw9nBVS7A+Ezw+PDf8JuvzwgPgT8w3eyrcC36z
jwfRWzvBXd7/G+tHwlvDxd8P7wdvBP/O+/+Gj4d3hHsbr/Bh8BbwWPCv8BHw
VnAD/wIfDm8Jj+337UYb2YPsRR/VxP/M8Ddc/wt4/TZ+f4K/V4PBm8J/wnfz
+VXhueFlzecaPb0Z/Dfrd3XTr33ey/h9unm+aji13E+8/1B4JNyB7+lGH84D
D4G/76aXq4HVwg/x/gnh0cT7c1z/3m702LysL8f6fd3ov/ng5eH7u+m388Mr
wF/y+Q3gJeCf+fxr8GzwRPCH8C/d9E77pdrv2260gZpWbTu6m3hRk6hNXtbz
deI/3uPzY7rRjmpOteeHrC8LD4ZHs/4tvD+8MfwH/F03WlnNonb5vRstqyZV
m/7WjdZV46p1f1DzwiPgv/j8B/Ay8Ezw115PzQpvAo+BP4FXhueEv4M/hVeB
54K/h9+BF27r6+d9olnVrsNK8nnsGr/1eJP6qgfS++iB9jeWS56dz3D3Gg+l
lzoE3q3GY1gLrAnb1fRke7MaYIUaTaG20GPtW6NZvZfeU7WsPdhebE9f3tzk
761lrzHGa2qWtcueMrSmp9hbrKFr1mgMtYY1dMWaGmottWavVFOzrd3W6JVr
ctRcHQxPXlOzjX1zYJWaGmot3QweXlNDraX2uNVqara125o7rKbn2fussWvU
aEC1oBpRrflZk15sT56+RkOqJefuxFsZ08a2Mb10TUwb28b0MjUxbWyvac+o
yRlzx5xYqqaH2cvUMGpve+g/vbQTLa2H/2eW0Im3t2f+0zs7mWWoqf/xtp1o
7UlKvLQ9a62anDf3zdklanqCvcGcd3aixlI7qCG6NTXSWmlNHFCjkdXKami9
hT3GXmOPWbjGw+vljcF+NZ5f7z+tOQu/3qR2WkMnrqkx1hp7zKLwuCW92J48
pKbH2mtHwmvDvWu+y3NN9JyaUm3pDGLDmhwz16x5m9XkrLlrDd6kJsfMNXN6
05qaaG00B0e08Wo+WBNH1tS4kW1+GL/WdGu7NXpUTU22NlvDt6qp2dZua/bW
NTV9izbftqypsdZaa8LmNTOJbdt8Mt/sIfYSe8QuNZp9uzZ/d6jpufZee/Rp
NRpeLW/P2abNb+cXJ7b57EzK2ZQzkr1qPJRe6qQ2//UkehM91h41MxRnKXqW
PeFfmtQqa9Z8NTM2Z23OvPaumTE5a9JvHlczQ9JP62+dX+lZ9C7WqCNqPIve
5UL4yJp5l374vE7mLXoIvYQeY/0aD6GX0GOsV+M59B6j4A1qNK/aV8+xbk1M
qPX1DMaKMzhncc7Ejq/xXHovPdRRNTMZZzP69QNqNI/aR410as2MzFmZM70T
amZuahc1jP7eGY2zGmcsB9fUYLXV9Z3UZmdCzgPOaOuv8wZnac7U9P/ObJzd
OCM6sGZG46zGmc5BNR5Dr6GncBajh9BLLN2JN9Uz6B2W6mSWoqfR29hzf+6J
h9BL6Bl+7ckM1FmommvKGk2uNndGOlVNj7ZX94N/7InH0GvomX6B72qi3dXw
zgvU1GprNe3vPdG0als9zG898Xh/tfXkz57k95C23lr/nBmu2j5P67U9cab2
903f1tsZ299nfbUnD27jcYaaGeFybX23XqiB1EL28BlrNNDibb+wvqhh52jr
3axtfRwO79z2BzXGEm3/WKymB8/Z1qfZajzVmDa+xvRknjIVx+NaM7jWE03q
nfXPXqxG7NXWv1Kj0Xu39W+cGo2qVlXD9tRoWLXsIK9Z40H1onrGvjUzSmeV
atxao2EmaPuf9VpP2a/tx31qPLxeXk/9d080k9pJjztezUzT2aaaavwaDT5N
228G1swEnA04E3DQoSfXm//j4XuiQaZu+439X4+sV1YzT9rW+/5tv7D+62En
a/ul9V/PrffWY/ev0dgD2v46SY0mV5s7w9ixRgOphdRIs9d4tgXafmp98pre
2zea/C1/k/ONV5r8Vu+Zsfpsk3vpPTdWn2nyLLwn/taXm9wr76mx+0KTe+0z
8F6+1OTZGPP8r/NAk1zwnntvXmzyLMyBceH7m+SGz9RcfLrJszaGSKPOQ01i
yxgxd59sEjt6Br2DemyjmpmCswVnBs42zaneHD/cJNe858bSW02ehc+Mj3Qe
a/IsjTlz+akmsegzRLJ2HmnybI0RP/Zok9jR8y7Y9uP5a2rIOBzf17S1BXY/
5u4mtcOc9dl93iSXjQlj8f0msWJMGcsfNIk1c9hY+aJJbpuzxsKXTXLZnLNW
fdckF33m1qrvm8SC/Uk9NbSth+a0sfttk1y3ZrlPdG+TWmbNM/Y/bFILjRlr
ya9NYskYNLfebhKbxqC5+GaT2LSmcti5p0mttWaaOx81qaXWDGPTP2otsSZ5
73pKapU1yFryd5Pa5D21Vv3W5F5bA60945XURj2iXlEPu3PNDMdZjjOfdWo8
u3rdPYKNa2YMx7f95YIajWCvW6tEO5xT0ws3KPHn9jh78fCS3nduTa/bsMRf
X13j57cp8ffOfPXjo0rmk2OpGexVJfXPmbNaYP0Sv+489CH4fL7TIZy7uEa7
bF6yn+MM3l67Wcl+0S3wS/AuJe8/rGT2/Tmvw0v2JNyb2Llk/0XNZG7MVqKl
dqrRcnOW+H1rhlpvjpJaokbaC56lRDup6fQmMxgkfaPp9uRw5hKtp2bbzV5S
ouXcU3A+u1fJfuCBJbPzL3gdUaIR1AKrlWgHNeHu8EwlWlFNuAc8uEQrqunU
prOXaL1D29/8XifzZWf8+tmNS+ZzaqTz4KVL9qrcw3RvYqmS/R5n8I/BW5XM
9/Ro7lUsXOLd1CBqkUVKvKF7Gs7/Vi/Z63DPw3nVGiV7IWoctc5KJXsb7mE4
79uyZF7lnsdl8IoleyFqGmNvaMleh3sk7g2tULJ3on7wnlkzrB3uETlP3KJk
nueekvPdkSXzPp+hsxtnND5bY1r/vUlJrLvn4Xxpo5J5ofHnPHa9kvmSe1LO
C9cu2atyD8l52zole0vusTgPXbdk78U9C/37tiXzAuPd+cLWJfNd9yicF+xQ
4v/dg3ga3q5kvuUemvOr7UvmD+asXmSuklzWk+wET1fiVfQAao9BJd5Aj6vW
7ZZ4Xz2j3riUeEk9uLnfq8Sb6zH10k2J99TT6W3HKvF6ekq97NglXlNPrVbu
XeK1127jf9LSeq0ar1VLvPyw9vtOVOKV9dxq8z4lXnzdNr4nK9Hi67T50r+k
VqnxRsDjlHjf9dv8mrxE6+sp9bLvNPGaeni97LtNvL39dzD8fBNvqoZQS7zW
xFv+4zHhV5t4Tz2os4MxTbyp9Vbt91cTr7lBm/9TlHiJ9dp8HFDiNawnerFZ
SzsLgfeGB5Z4TT2V3mqektnJ8Pb5TVwya3CGsSM8Yclsw3o+ytJSMpvQE+m1
li3xSnoQvdTyJd5Ej6L2X7XEu+iZ9GJDSryUnkkvt1yJl9Ij6iXnLvGO9oBt
4SlLeoOaYTt4qhItoUfTa6xS4t1GtN932hIvrEfeHp66xDvrkXeApynxztYD
vdLKJV5Iz6NXXbLEC+kZ9b4LlHhJPZXabbESr2X90csuWuKN1mj/3gQls5eh
7d/rVzIrWq39/uOXzG7cU3f+uWPJfFHPZG1YvMRL6ZnslUuUeCk97WHw/CVe
V72ldn+wyX6dHlhvPl+JN9bT6qUXKvG6ema9/oIlXto967fgfUrmexfWzDs3
Lfn3EfYw98/d/7e32SOdTVpDrCXjqDs62YO1Z16rbuhkz9Ce5573uxzvXzKP
dM/yVXj3kv0Ve7CzdnuQvdk92pc53rVkP8w901fg3Ur2Z+yR7g+6X2nvdH/f
2bH30HupBnBWb09XGzgz/Kr1f/oX/czo1k+qTe15/luY1zvphe5ZvsbxHiX7
Ld5T90LVtN5re7z/dsOebe93/93ZsPfMe6dGcLZvzbZ2qzmc7as51CL2QHvh
ASXzbu+x/vn69vP+G4C3Od63ZP7qvzF4E967ZF7tvwl4B96vZD/B7+x337Nk
Xvx/melPKg==
           "]], Polygon3DBox[CompressedData["
1:eJwt13WgFlUaB+APLt2NlIAupfRKiKQoXdIgId0hUpKuCqgIrgGiiEmHoHQo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           "]]}]}, 
       {Opacity[0.8], EdgeForm[None], 
        GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmXf8jlUfx++b61Lfn999FU2losxkb6mEjAaZLQ20n/aup/lURiENLSUi
EglNUmSTrJSRjFJoSHvzvD+vz/3H5byd37mvcc53fM73VO13bfdryuRyuRH8
U5b28zSXuzGfy+1JcrkVhVwuyuVynUtzuVVwefg0+EP4H8adAi+HE/o7wSvh
EvhUeAn8F2PawZ/AB9DfFf4UPhA+E14HV4K7w4vhXxjfFl4K/w23h1fDpYw5
HV4DV4S7wB/BZeGO8Hvwp4xvXur3epH3Py7180fDx6b+jtfglqm/Yxp8PJzC
r8BN4Y1c/4NLU3/HVLhV6vd6Bq5Gu5P2R64tXDu4dnNt4vqVvz1LWz31e70M
N049NxPhJqm/YzrcGv6G9ieuL/L+1jG0dWi30/7A9SXX+3zXWvpa8F2z4XVw
S3gH3IB79YU3wIfDPeFv4EZwf/gX+Bp9dwnPgf8D7wt/DldlzFmM2QQfDZ8N
b4GrwefC2+Bj4fPhr+Hj4Avhr+A68AXwZvgY+Bz4M7gy3Av+Db5Oc8yz5sDr
4Vb0/wpfq3ml/0f4SngfeC78GdyaMfMKXoMT4IXwd3Ab+AN4A3w8vAD+Fj4J
XgsfynO7wevhw+Ae8PfwpVoH7v8DfLnWGf4WbsyYixmzG76C/nL0fwc3of8S
+nfBl2nd6N8JN6S/X6nf5THWpHLq5z8KH077FddD8EGp770O7g/n+f1S2Vs5
33s9fLF+m/cab8zbBrT+W7ku0dzQDkj8d63/Z8Xf6z69U9uLfrOB66u8bXEz
19fFft1H7/spbV/NV/G5rfQNvM978EW024q2+zlXM/62D+0YnnshfzsEzmir
0z8T7iCf4KoFT2dMDfrfhTvSdxT8JtwGPgJ+HT4Rvp+rNvw64x+Aj4XfgO+E
q8KT4b4lfne9z3z6z9U30X8TfBg8Dr4RrgSPhS9lDQ7W90UuV5NnfQSfVfQX
zelfOful5mRZ0S/1jfty1Wb8Ctpziv67pThvtehfTnt2antfCZ+b2t5Xw31S
+8pCuFtqe18M90jtN4vg7kVf3lVcF93/++I76PnfFd+henEde6X2syVwz9T+
tAo+L3VcnAG3hw8qzv8pqWPnO3C71HazvWgbu4rr/nXxOXretuLzdxZtpDW/
/Zu5aVrOcWV7ca6+KPj7zyt1zFhLf7/UPjQHPjV1rH0bbpvaz96HO6X29bnw
6aljzwfwaalj+Wy4c+r49InWF/6y4DXow7PehT+mryk8E14NN4EPynK58bIz
7OEA+AW4Bnwg/BJcEy6Bh8FHwhn8pNYBrgA/r3mFK8Kj4OpwwENlm/DfPOtW
uAL8L3y75hX+B75N3wo3ZfwO5SB4H3iQvhXeD35K6w/vZfxdWiu4PP2PyA/g
Ung4XAXeQ/sE336UYhzf/ZxsDf6X63H4yOL6Ku80U1yGn5edwnu5RsBVaHP0
PwlXVTyBn4KPhv/kHW6m3Y9nNeO5O5Vn4Rbw98rLJc5rykc1FOPgkXBNuMCY
EbJrxvzFfW6B94dz9N+t94LLwQO1tnCNzLm1CXwE/BFcF66ZOTc1hRvCXygm
w7Uy56lm8OHwe/In+Eh4OVwPPgpeAdeHb8SfT1V80FpmtodG9B+T2U4aw1Xh
VXBDuAq8UvYFN4C3wifCTeDt8MlwY/hr5Q64Evym/AwuA98LHwLn4Xvgg+Gy
8H2ycc0bPEB+ACfwg7JrxUX4VcU1MfM5mXduod/QP0Xxg/7jMuunVnB9eIty
GVwX3qR4DNfOnBObw/Xgzcp98LGZc1wLuE7mnNhS88az3uBZJ+ld4Ulwc60Z
PF7xEH674PlsiB+9WfAa1YffKnjOG8DT4aVai1LP052KS7Sv0/+h1pT+N+Bl
WiP4d9ohjDk0tU/cBUdqW7sbLlHc47oHLp9a/ygPHkz7G9fD8CG0U7nnYs1P
qW3zfuUX2j+4hsKVZM9cw+DDUq/nrXCZ1DZ1G1yWdg3XlfCv5IIZBdtDY+5Z
D/s5IG9dofm+Bc6nnu+b4L2J5/hmOJfaLv4L75M6d98Bl1OM4rodTmgXcJ2n
uMpv3ynY3hrxrGnwEtmSdALtA4zZj/YHrgfh/Wl/4hoEH6D1yzyuA+92UuY5
PQ0+MfMcnQq3hn+EO8OtMt+rI3xKZv/vBrfLHFO6wu0zx4gzFQP5+zieVV9+
DY+F68kHMs/pGYxpk3muT4fbZo5BXeDj4d1wJ7h55rVsD3fKHLN6wN0y2995
8GmZn9cb/oN5uEHPhH+Hr4dLS3y/AbxDhdTfNBCuqGfz2/2kOUvcvkR/A31/
5vfuRX/nzHGwJ3xmZj1xLtwTristCvfIrD/6wB0zx7XucNfMPnkO3CWzn5wN
X6AcoNyLjfSHP5Rdlfh+8+AuqTVyGfipxDrxX6b94cT6UXlzYGLdWpYxzyTW
hv/QPzixftwDD02sZ/fCjyTW2jnGP5o4jh4BvwwPho+CX4HvkA/DIxLnov3g
x+Cr4Dz8eGIdncAjE+exo+Epiec7hZ9PnNMK8LDEcagdvCJxzDsN/jRx3GoL
L08cj7vDm+C3tDbw2sTxV3H4E/iJ1JrtTbhaWJdKnypPZvDwxPmnPPxQUbNp
zKDEdlEOfiGxHtHeSDpTeaaUdkjiHH4M/Fri/FkNnpo4f1aHp8HbwjpT67gx
rC1lJ5+H46Hs8JfwmsoeNoW1qGzsy7B2Uo79Cp6Vt238HNZg0mJ94RbyWXz5
IriZ4hJ8Idxcfi3NH7YT2eH38Py8feHngtdpT/lc7mraCvQ/yTs3Ks6V5qNx
2Pb2lndeVYx6LnHOORAelVhHVISfTZxzKsMTEuuOI+GJifPP4fB4+GnFZnhG
4jx2EDy6qLGlmV9KrOc1383LWWO3oN2q/TTv83HeftQpfB9pmw7wcXnnO+VA
aewXuU8/+lvKl0utferC7yTWDnXgt+DmYduWpmoRfmfpqNZhW5VGOjG8vsqz
J4TXXRqjZdgXpMEGF7xnKMuzHoYfln3DQ+Ahsid4HDxD8wK/BM+UL8Fj4Xfk
Y/Br8CK4NnxK+D2Vu8fQ/7rmkf72YdvWnLWBa+Sd948N+6D2pHXCvqn9svYb
mhPFurrh9dKeun54HbXPbRKef627/ETaXHq7RthHtA89KWzb0h5Nw2sq/VY7
7FPah9YK+7L2qjXD/qJ9aLOwbUinjeZbpmu9+Zbx8LtwFXgCPAuuqvWCx6Ze
u2HwY/C+8DPwRNkiPBKeJBuCn4VfkV3CHcNrLe03jr5W8ILEGvx4eGFi3S2b
eTux1m4Mz06s2ZvAcxJr+dbwIngCfAK8WL/lWS+m9rvn4MmyOXgEPCa13z0O
P6e4Bk+CP1BcgCfDc+Ea8KvwPLgmPBGerZgCvwy/r1gJvwLPUXwp9f6gEe/w
vt6T/mn8v5L64dfgQ+Ch8KPwPvAj8ONwwI/CzyrewY/BIxXL4Cfg0anjxih4
KnwofHr4Wdp37J/Zb0voP5v++nnfZ0JYO0nvTYTvzVvvTQ5rJGnIKWFdIX34
alhvSENqnjrCqxLPZSd4deJ36QCvTLzOXeD1idf5TPizxOvcFd6Q2EY6wx8n
XmvF/zXwa+E8Lu2qdTgZXiYbCGs/addpYZ0jzf98WEd9wtgRYQ0mff5MWL9J
z78R1oTS5CPDWkva/qmw3pO2fzys07QveD2sJ6XRxob1p/YUY8LaVfuOF8Ja
TnuToeG6pfYmj4a1n/YaU8M6RHsEra1i+weJ11bxbV5i/1AumJt4DXvDW4o5
UXWJbYnt5Sx4a2L/Oxv+InFcOQf+MrEvXgR/m9gX+8LfJY5VF8LfwPXKOY90
TR3nGsDvJo5zDeFZiePcBfDOxLHtfHhHYjvtBW9ObOMXw7sS2/il8O7EGv9a
+K/E/nEF/HNiP+sGb0xsyyfBSxPbchv4w2Lel7/PT1yTkd7+RVoivBfQ3kr+
dzn8U2K/vAz+MbEuvgb+M/F+4jr478T7ievhfxL76CXwD4n3BFfDfySO2VfB
v8PPwCfCS6RPwnsE7ccXwaPy1rStwjk3jx91Uz0ob5/dU7CuysE9inFe3/Rf
xUh4Evc8M1zLUjzsHq5TycdPDdemlGs+Ce/vpIE/hV/NW5d2Dt9HuWnfzHou
gR9K7dczuX+7Yi5QflkT3q9Jo54crmUpx10RnnPF3uvCvqxYdE3YfxVD+ofX
Qn55btg2FA/PCduM4s/1Yd9XLrgh7MvKcdfCp+Qd064M+69i7OXhdVecPzhz
XK4IXxaec+WFl+k7A17Ht7Sl/1C4DP03hX1BPnFzeH+kPfXVcI+897/zw3UG
7WvegR/Je0/xXrgeon3Q++H6hvY4s8P1De1B3g7vAVXHmBWuk6iOMS9cx9D+
cmG4TqK9zEfhvY/2RCvCe2HtlZaH9xfaHy0I116055oTrp9on/VxuPaiGkmf
sDZW7ej8sH5W7ahXON+pTtKzuBaypTvhfnnXNB4I+4h85aqwrlZ9oHc496k2
tSy8L9OeqyvcNO8aUZdwrlTt6AK4fd71rkvCul31rovDMVk2cFY4h6oGdUY4
56oOdmlYw6tu9jbj+sDbWbsGYX2ofdmt4Vwg7bQnXLfUGcHecD1T9fBciWuS
qoEPKrjmq3WfxJgb8q7J/xuuhaoePqvgeN8MHlhwbVf++GDBdVvp3l/DNUPV
GH8Ka3Jp7xnhcxbV9n8P1xt11jATvi/v2v5v4Vqiaoa7w/VPnTUs4v4/KyfB
P4brpTqz+Jj+Ctz7DPiPcE1S5xQ/hGuYOuNQLV01ctXD5zN+m2IN/esY80Le
51yHZd4XVYaHFxyPlLvXhs+SdLZVhd8vkI3xtw3h8yadT60Pn+PojOw5+D95
n0l1z1wr7w0/UPCeQXsHPX+w/DH1XlW6UfpRtW7p996Z662aQ+n4RpnrFHrn
Xdz/rbzPcbS31Xfp+6YXc7HyZq/M+eYixvwTfmedGdWnbw18IWPupr9n3nrp
jnCOkIYcHM5lqgvdHtYP0pm3hfWDtPfi8DmIzumGwf3zrjs9FM59qiPdEo4n
0ueDwnlQNajh4VygmtWocPzXOdeT4fyimrDsS9+S0g4I50HVkZ4O5zXVkB8M
27w0/8Bw3lR95olwblKN6K5w3pQ+rJy5vlMLXsZalGEuOsAfhNdC54+PhfOp
aj7jw7lM51NLw2dAOvecW9Qnikuyx6d1f9ol9A/P+9zzz3CdXGdnQ8L5WrW4
EzLXiWTD48L5Wmdb9xdjrOLJwtT285v2jGFNIh27sWD7ky39L6w9pIHvDesT
6eT7wvpEOvnFcF7WGdzocM7VGeJDBect5a9qmetr8uWvw+ekOpP9JnxeqXO9
neEzU50z7gifjeqsbUv4rFNnu5vhCXmfz04p+Bs0z9vpn5L3Od3TBecY5Z0z
Mtcx5bPyXdnzyfztxYJjmXxwa/j8VOfFAwrO5crvq8Jnsjp31hrquY342+pi
vlBs316wrcv+O2SuoWutvyjGf9UHVobXTufI/weunbxq
           "]], 
          Polygon3DBox[CompressedData["
1:eJwtmnW8HdXVhu8Jsw+cydyLhuCaEBKIECAhWLDgGhJcitf7tZRCoVRwd4fi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           "]], 
          Polygon3DBox[CompressedData["
1:eJwt13m4TVUbAPCDey73uOciQuYprnnMlLmiZC6RzKHRUN+n0lepvqiENKG5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           "]]}]}, 
       {Opacity[0.8], EdgeForm[None], 
        GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmWXAFkUbhV8f9VndfZ21u7C7u7sTg06lpRvp7u7uBgWkG6RDBQGLMACx
u5XvOt/ZH8Nc77DP7uzMPXecLVKxdtFauYKCggH8cyR926igoBo8O19QsIN+
H+192geML6c/hn47bbGup99N/yltJ+1D/l5Bfyz9KtpU+Cfu0yIuKDgbfikp
KGgOnwW/CLeGz4OLw63gc+FicEv4HPhl+GPdC07oP9MzNBfaJ/y9mr6Qfi9t
HZzSb6bNgf/hufvg9fDx9O/Q5sOHGd8Ez4b/hjfCs+C/4A3wm/Cf8EfwSjim
b8x8ToWfZz7b+HsRnKN/l7ZAi0f/Hm0hfAR9E64/DS7K9U3h0+EX4PbwhfCd
2bscoK2hfU47SNue8de0j7N13a97ZvvwBe3nIwoK9uT8e63D3uw3H9GqcP+j
6R9K/P9fZetVmfGj6B9MfO/Ps2edHXlvv6H/lLYBPiHys77UGtMa8NuT6K9k
vDt8JVyG+/SAr4LLJn7OZ9m79GT8avpyjHeAL4JLwL3ga+DycEf4Yrgk3BA+
GX428fseou2iNWL8FPrnGO8EXwKXgjvDl8Kl4ZpwAj+u92V+G+ET6ffQ1sKB
fgCtJjyPPX058twaw1dHXqsH4ebwi/AI+KrIa3U//Dr8Ajwc7ga/Ak+Hy8K3
wK3gSvBdcEf4VfhOuAPcH34Nnpv32h0J3wtfA+fhh+Fr4Qh+FD4H/oW9vUf3
iX299uc82m+MP8D4ufCv8H3wZfB/8Ivw5fBh+OW813BXdh6vZ/xY+qcYLwPf
DLeEb4YLZZPwdfAxWkP4psjr+TxcCr4Rbg6Xhm+CW8AN4CfhAXnbpp63O7Nl
2cCebA8/zez2YGZvstNR7NPx9M8ktq99mT3/nL277HBMYrsendjedY380A/Z
eT+O/ifaNvjHyPf+OLP/sfxmXvbbz/m/TfBJ9F/q/MOna09oD8E9mH8N+EG4
O1wTflj2Cz8AXw7Xg+9P/Fw9/+vsuWdlZ0TnQ+fnkHwB/Rn0B2lb4dPov5Jf
gM+k/5ZWABfPe1+1v3fD58O/8+4PwbXZ9+MYf5Jn1oVT+Gmdl2C/PLCQswC3
gwfBneH28GC4C9wBHgJ3hTvCQ+FucCd4GNwT7gqPhNvDreH+8Ah4NjwD7gF3
gUfA3eHO8HB4JDwHngn3hnvAo+G+cC94LDwA7gtPgJcw/1LM/zXmP5yxdvBm
nQuu6cPf47mmH9wbHgcPhPvBE+HB8Fh4MjwMngZPg+cEx4PV8HB4Fjwd7gP3
lO3AQ+Bx8BR4VnBMWgm/GRzDVsCzg/37KnhycAxYAE8Jjg0L4anBMWMR3AFu
I18Ct4Nbwf3g8vBjcB24bLDd1IJLwjfC1eFJwXFlPlwBfhyuC5eG75A9wuXg
B+HahV6D11mr1azVtOAYs5jxMfBixSp4QbC/WwfPDY5/b8MzguPTUnh+sE9f
C88LjoVr4JnB8XsZPD04bi2Bx8IrFBfh8cHx+y14HLwSngOPhhcpRsIT4NXw
XLgOex3kZxLvW1d4W97XjlEcguvDJeFxcF24ODwGrgI/Cw+CA78fCfemr8z4
M/BAxlvCleCZedtsFfhNuClcAZ4CN4MrwlMzvy1fPS3vvaoMvwFXhZ+DB8PV
4OfhIXB1uCg8VOOxffIjzKFqnPlquFZsn/kEXD22z3wUrhHbxz6WeD2myafl
vWZT5KMyP6M4MgxuApeHJ8N14GLyVzr78MvykXA9uIT8GdwQLgNPgBvBZeGJ
cGO4HDwpb39QHZ6Tt51WhWfBxeH74M557+1k+TF4uuxX/ivvMzRE/jrvc9ZX
/jRvWxsLfw0Xg++FO+XtA4bJp+ftM4bK78NLdI7hb/I+f93g7XAJ+H64C1we
flT7C1eAH4P7wBXhx+G+8CvwE3A/+Hn4NrgN/GQWj16Hn4BvgJvlfZ6uh5tm
MUv+vBtcEn4A7gq/AN8Bt8v7vF4HN4GLwrfDbeEi8B/44UfgC+A/4cfgS+F/
4aLw78F5wChs/hP2/dWcfeDM2OvTBt4T21bli65PnGfKX30Re1/k97pzj/rw
Eu75fmx7kI/dGdue5Xs/iG3P8tX7Ytvw/31s7FhcgXsPjB3TK8oOmVs5+Y5C
57jKdb/n73f4+zvFs5R7JY5Xij9luP5++pr8/w2Jc2bl1ONjr6HWsiHX1KLv
wDWDYuc8r3Dt5tg2qVjzCtc8p/eB28At4D7yLbHzhGpc/25su1U82hbbbhWP
Pot9luX/Z8W2k3by1bHttq18fjYfnaHZsfe0PeOLYttJV3gZ/LT2vdDP177M
YA2+D87tNB+9x0taT8bXxT53in1rYo/3hdfGPoPy7eMS5xSK+98G5wdah/Wx
fZdiwdGs6VDGJ8E/xd5TxboDsWsoxcGv4Ro5x7Vh/F9beBNz2Mp46Zxj98bY
vlExfUHsc9EZXhj7XHSRD4cfgTvCG2L7B+UD82OfqU7w6th+Rv5vQuw8p0ri
d9C7KF/6lfEOslXGf4Hbw63hb+DmOlPwb3BHrT98CG6q8wX/HDuO6x1/hNvA
rXR/uDXcEv4ebgW3gL+DW8LN4W/hFpob/CFcF64H74LrwHXhHXBtuA78B9xZ
ew0fRxsB96IvVD4B91SOxzWN4EaqHeCGcEN4P9wYbgz/DneSXamWhOvB9eE3
4Hv07qzb7mzvdC4Pwk3kH7hmL9wAbgCfTBsvO6E/KbGvk88rgW3cQF+N+9yT
uP7dDL8Xu+6oxdjdiWvnTYwf4Not8KnyPYnr6PWM35a4rlRMvznx+VVMvy9x
/bsVvgx728/vNsD3Jq5Pt8C3JK5DFd9vTVyHKu5PjJ3TVmXsLtoyeCPjRyb2
/4oD/3FNT9kPY3n5FK0D/XbGJQzUhv+Fe8j24H/g7nAH+DDcS7YKF9B6y1bp
i7EmFylO86xT+HuCzhT9UbT+OrP0RyfWHLrRR7RBcA/6pbHjfnd+uyp2XO4N
L4+dJ/QodD2lmrRU3nnWmfJL8KDI9rMAvgI+ES4J74Rnwr/n7Q+VVyu/Vv51
AVw9b98nH/gvvFu5D/wffDtcRH4s77pd9XsN+W14OvxrFk91LrbAUyKfi415
nxPZ1dK8/YRsbzE8JLL9L4InRD4Xa+GJkc/LOnhS5HO0Hn4j8nl8F54R+cxu
hb9Q7gYfrdge+QxuYPzNyDb/Hjwz8nl/J2/bWQrnI8eCHFwptq97G36A/unI
tXktrn8mct1dG342ct1dJ4vFWofX4Kci1/g14dsir20J+NbIOWEx+JbIdc1L
8EuRdYNG8CXwP8TW5+CL4b/hZ+AL4b/gJ+ARkc/gMvjFyPpDQ/iuyLpBmbxz
5yt0ruGBke12Pjw4sm9ZCD8UWXeqBD8aWWuqCj8cWZuqDN8XWaupkO21bKw0
/EhkPaoKfHdkXaIsfG9knac8fE9kjagcPDKyL1oOj4rso1bAoyP7pZXwtYm1
JtUm18gf5Vyb7Ip8TiO9U+J8Urn65Yn1NOX2l8KTcq5NLkmc16lGyCW2Q9nj
xantfjnjx6e2y6nyIYnzUuX8RySOR6qtTsx8gnzaX9hEs5zrrzMS53iqBa5L
rJWpbloZO3/uBa+InVf3hM/nWeu4xzzFysjv9Qfvex6/HZ1zHXRB5j+l1Z2W
OP9UfVEkcc6p+ut0eHDO9cj5iesI1WhnJs4/VXdUDM4F66leU5xn/COedQZz
WKBnM741sv/5Pu95jYK/hHfAM+Df4C2Rfft3ec9Jc/tWOVRk//YBPC+yn9wF
j48cK9fAayPXLAfhtyL7xh3w3Mg+cyc8JnJMWQX/Gbu+U336duRYtj/Ln7X+
u+GFkdfqEHxC4pxcdd/xid9R9dexcJec699jEtdcqt/jxLm36vT+sXNmndel
kX3vnrzXRr76Q3hZZD+8F14TOc4egJdHjgX74ErBuXJD+c7Ea9gncf54mXyp
3j3LPZSnnZP63QZwzVmpnyH/f0lq3zpc78H15+dcO1+a2peNSJzDKs/pxT3P
Tj2P/oxflHrPhsFXJfZ7Q+nT1L5Pcefk1L5PceTE1L5P8eVU2sSc73N66n3V
/E9Lva+qN3vH9vOqzS9M7d91/1NT76Vyj1NS77FyjxNS+2LFsguz/Fm2c1Jq
f60YembqdVfO8HOmwyi3KZLa5gYrr4mtH1aC/8x0FeUbU2LXJi2Zz3+ZrqIc
bBLjtzLenPEbE2tTil03ZT5ca7sltvZYM7GepjrgLe6xK9hvSo/9K9NMlC+1
yzRe+bx/M31G+c8/mT6jPGpq7BqqFc89FKyBqtY4L/UZGMQ1F6Q+b0Pgc1Pb
00D41eBargHXj4qz+gv+O9OOlL8Vpo6FyjFC6vinvOKnTMtSHtKF356Rs8by
Y6Z3Kb/qFZy7qS77KliHVd0xN7auWwP+MlgDVS70Q6abaX12BsctfYN4PzhW
6buDcjo9q6LORXBNqBr/7eBaUbX/wWBtVDn2gWB9ubJ8WJzVp8r/gzXi6ox/
GBwnpGPvD46F2vePgmOJNO0PgmOMtPHVwfqgtIg3gmOD/Pl3wTqstLUvguPi
q/A3wfqm3nd3cGyTPj8u8wOq6ZYE66HKRdcFx13p5yuCNWh9I9gQXPdKh9wb
HC+l2+8LjveqPd8J1q/1jWNLsJ4urX5TsB4t3XJrsN6t7yabg7V16fwzmM9T
Oa/Jp8E5h2rYd4P1aH0r2R6sU+ub0bZgbVrfjJYH67DKh5cFa6zKgZcG67DK
vVcGa+X6DrIqWEOXhrMjOC/RN6b1wfmH9JwxcaYhqBYL1talZe0Jjv36lvFZ
cD6k+ndQcC2nuu+T4NxC30SOTJ1zqA4aGhyTFHNzqXNT1US/ZJqq6p2jUueC
qqHyqXMd1WLNgvUy1bZNg/Ug1YCfB+dhqrUXB2vNyuej1DmHarpjUuccqt3a
Bmtnqm3rx873qiruxNbHVCfGqeOT6izV8fItrbH5gtTfTlSvJaljnnL+5sE6
lPLzhcE6u+qXusFanjSQesFam+r3asEakNa2RbBupRy+cbD+pbq1UbD+pdq2
VbCup7yiVrA2JB/YOljjUy3QjPnHOeurg2PHIPmW14I1JvnGobFzwkZwg2CN
T7pBnWBtUXVf/WAdUJpD1WC9TH6pdrAOJV9XM1iragE3CdYuVZtXD9aYdMZf
D9bppD/cKVvPOZZVDtaeNIchsb8pKIYeDv4+pFp7NOPXMt6Y8eNS1wCqxdYG
58Gqoa5OnLcr9rWJXddIN14UXE+qHhwe+9uT/MDE4NxLOViVYP1O9y8VXM/U
gH8N1vlVg38cnPtKC+oau56SFj05tv6md1c9pzV/Gtv4Lfg7gupofdfQtyZp
TG25/oSc739u4ppLceGcxLmWYkG97NuWarj3gr9RqXY+NnV+rDr9osT1l+Lj
xfLjOceUsxPXXMorjkid60tbaBmsqyr/HBWcPyn3G8mz7s7ZJ/eLXbMoF+ob
u+5T3lg8uFbUufgfcV9G+Q==
           "]], Polygon3DBox[CompressedData["
1:eJwtmnXgF1UWxX+OMA/njd+fua7dubZrB3Z3gYooSAkC0iFINwrS3dIqAkpL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           "]], Polygon3DBox[CompressedData["
1:eJwt12eUVdUVAOCnCTzhPQdIgoqxQCKILmsilkQRC01FigJipEgvwlAEZghd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           "]]}]}, {}, {}, {}}, {
       {GrayLevel[0], 
        Line3DBox[{246, 1, 242, 227, 2037, 16, 2051, 31, 2066, 46, 2081, 61, 
         2096, 76, 2111, 91, 2126, 106, 2141, 121, 2156, 136, 2171, 151, 2186,
          166, 2201, 181, 2216, 196, 2338, 231, 248, 211, 244, 236, 943, 212, 
         944, 213, 945, 214, 946, 215, 947, 216, 948, 217, 949, 218, 950, 219,
          951, 220, 952, 221, 953, 222, 954, 223, 955, 224, 1156, 233, 249, 
         225, 245, 237, 2243, 210, 2229, 195, 2214, 180, 2199, 165, 2184, 150,
          2169, 135, 2154, 120, 2139, 105, 2124, 90, 2109, 75, 2094, 60, 2079,
          45, 2064, 30, 2336, 229, 247, 15, 243, 235, 773, 14, 771, 13, 769, 
         12, 767, 11, 765, 10, 763, 9, 761, 8, 759, 7, 757, 6, 755, 5, 753, 4,
          751, 3, 749, 2, 1157, 234, 246}]}, 
       {GrayLevel[0], 
        Line3DBox[{495, 250, 491, 476, 2341, 265, 2355, 280, 2370, 295, 2385, 
         310, 2400, 325, 2415, 340, 2430, 355, 2446, 2447, 370, 2475, 385, 
         2490, 400, 2505, 415, 2520, 430, 2535, 445, 2658, 480, 497, 460, 493,
          485, 1367, 461, 1368, 462, 1369, 463, 1370, 464, 1371, 465, 1372, 
         466, 1373, 467, 1374, 1375, 468, 1376, 469, 1377, 470, 1378, 471, 
         1379, 472, 1380, 473, 1595, 482, 498, 474, 494, 486, 2562, 459, 2548,
          444, 2533, 429, 2518, 414, 2503, 399, 2488, 384, 2473, 2472, 369, 
         2443, 354, 2428, 339, 2413, 324, 2398, 309, 2383, 294, 2368, 279, 
         2655, 478, 496, 264, 492, 484, 1185, 263, 1183, 262, 1181, 261, 1179,
          260, 1177, 259, 1175, 258, 1172, 1171, 257, 1169, 256, 1167, 255, 
         1165, 254, 1163, 253, 1161, 252, 1159, 251, 1596, 483, 495}]}, 
       {GrayLevel[0], 
        Line3DBox[{744, 499, 740, 725, 2661, 514, 2675, 529, 2690, 544, 2705, 
         559, 2720, 574, 2735, 589, 2750, 604, 2766, 2767, 619, 2795, 634, 
         2810, 649, 2825, 664, 2840, 679, 2855, 694, 2978, 729, 746, 709, 742,
          734, 1806, 710, 1807, 711, 1808, 712, 1809, 713, 1810, 714, 1811, 
         715, 1812, 716, 1813, 1814, 717, 1815, 718, 1816, 719, 1817, 720, 
         1818, 721, 1819, 722, 2034, 731, 747, 723, 743, 735, 2882, 708, 2868,
          693, 2853, 678, 2838, 663, 2823, 648, 2808, 633, 2793, 2792, 618, 
         2763, 603, 2748, 588, 2733, 573, 2718, 558, 2703, 543, 2688, 528, 
         2975, 727, 745, 513, 741, 733, 1624, 512, 1622, 511, 1620, 510, 1618,
          509, 1616, 508, 1614, 507, 1611, 1610, 506, 1608, 505, 1606, 504, 
         1604, 503, 1602, 502, 1600, 501, 1598, 500, 2035, 732, 744}]}, {
        Line3DBox[{2037, 2335, 956, 2036, 3280, 2244, 2038, 3281, 2245, 2039, 
         3282, 2246, 2040, 3283, 2247, 2041, 3284, 2248, 2042, 3285, 2249, 
         2043, 2980, 3370, 2044, 3286, 2250, 2045, 3287, 2251, 2046, 3288, 
         2252, 2047, 3289, 2253, 2048, 3290, 2254, 2049, 1152, 2255, 2336}], 
        Line3DBox[{2051, 2981, 3371, 2050, 970, 2052, 3291, 2256, 2053, 3292, 
         2257, 2054, 3293, 2258, 2055, 3294, 2259, 2056, 3295, 2260, 2057, 
         2982, 3372, 2058, 2983, 3373, 2059, 3296, 2261, 2060, 3297, 2262, 
         2061, 3298, 2263, 2062, 3299, 2264, 2063, 3300, 2265, 2064}], 
        Line3DBox[{2066, 2984, 3374, 2065, 2985, 3375, 2067, 985, 2068, 3301, 
         2266, 2069, 3302, 2267, 2070, 3303, 2268, 2071, 3304, 2269, 2072, 
         2986, 3376, 2073, 2987, 3377, 2074, 2988, 3378, 2075, 3305, 2270, 
         2076, 3306, 2271, 2077, 3307, 2272, 2078, 3308, 2273, 2079}], 
        Line3DBox[{2081, 2989, 3379, 2080, 2990, 3380, 2082, 2991, 3381, 2083,
          1000, 2084, 3309, 2274, 2085, 3310, 2275, 2086, 3311, 2276, 2087, 
         2992, 3382, 2088, 2993, 3383, 2089, 2994, 3384, 2090, 2995, 3385, 
         2091, 3312, 2277, 2092, 3313, 2278, 2093, 3314, 2279, 2094}], 
        Line3DBox[{2096, 2996, 3386, 2095, 2997, 3387, 2097, 2998, 3388, 2098,
          2999, 3389, 2099, 1015, 2100, 3315, 2280, 2101, 3316, 2281, 2102, 
         3000, 3390, 2103, 3001, 3391, 2104, 3002, 3392, 2105, 3003, 3393, 
         2106, 3004, 3394, 2107, 3317, 2282, 2108, 3318, 2283, 2109}], 
        Line3DBox[{2111, 3005, 3395, 2110, 3006, 3396, 2112, 3007, 3397, 2113,
          3008, 3398, 2114, 3009, 3399, 2115, 1030, 2116, 3319, 2284, 2117, 
         3010, 3400, 2118, 3011, 3401, 2119, 3012, 3402, 2120, 3013, 3403, 
         2121, 3014, 3404, 2122, 3015, 3405, 2123, 3320, 2285, 2124}], 
        Line3DBox[{106, 845, 107, 846, 108, 847, 109, 848, 110, 849, 111, 850,
          112, 851, 113, 852, 114, 853, 115, 854, 116, 855, 117, 856, 118, 
         857, 119, 858, 120}], 
        Line3DBox[{2126, 3016, 3406, 2125, 3017, 3407, 2127, 3018, 3408, 2128,
          3019, 3409, 2129, 3020, 3410, 2130, 3021, 3411, 2131, 1045, 2132, 
         3022, 3412, 2133, 3023, 3413, 2134, 3024, 3414, 2135, 3025, 3415, 
         2136, 3026, 3416, 2137, 3027, 3417, 2138, 3028, 3418, 2139}], 
        Line3DBox[{2141, 3321, 2286, 2140, 3322, 2287, 2142, 3323, 2288, 2143,
          3324, 2289, 2144, 3325, 2290, 2145, 3326, 2291, 2146, 3327, 2292, 
         2147, 1060, 2148, 3328, 2293, 2149, 3329, 2294, 2150, 3330, 2295, 
         2151, 3331, 2296, 2152, 3332, 2297, 2153, 3333, 2298, 2154}], 
        Line3DBox[{2156, 3029, 3419, 2155, 3334, 2299, 2157, 3335, 2300, 2158,
          3336, 2301, 2159, 3337, 2302, 2160, 3338, 2303, 2161, 3339, 2304, 
         2162, 3030, 3420, 2163, 1075, 2164, 3340, 2305, 2165, 3341, 2306, 
         2166, 3342, 2307, 2167, 3343, 2308, 2168, 3344, 2309, 2169}], 
        Line3DBox[{2171, 3031, 3421, 2170, 3032, 3422, 2172, 3345, 2310, 2173,
          3346, 2311, 2174, 3347, 2312, 2175, 3348, 2313, 2176, 3349, 2314, 
         2177, 3033, 3423, 2178, 3034, 3424, 2179, 1090, 2180, 3350, 2315, 
         2181, 3351, 2316, 2182, 3352, 2317, 2183, 3353, 2318, 2184}], 
        Line3DBox[{2186, 3035, 3425, 2185, 3036, 3426, 2187, 3037, 3427, 2188,
          3354, 2319, 2189, 3355, 2320, 2190, 3356, 2321, 2191, 3357, 2322, 
         2192, 3038, 3428, 2193, 3039, 3429, 2194, 3040, 3430, 2195, 1105, 
         2196, 3358, 2323, 2197, 3359, 2324, 2198, 3360, 2325, 2199}], 
        Line3DBox[{2201, 3041, 3431, 2200, 3042, 3432, 2202, 3043, 3433, 2203,
          3044, 3434, 2204, 3361, 2326, 2205, 3362, 2327, 2206, 3363, 2328, 
         2207, 3045, 3435, 2208, 3046, 3436, 2209, 3047, 3437, 2210, 3048, 
         3438, 2211, 1120, 2212, 3364, 2329, 2213, 3365, 2330, 2214}], 
        Line3DBox[{2216, 3049, 3439, 2215, 3050, 3440, 2217, 3051, 3441, 2218,
          3052, 3442, 2219, 3053, 3443, 2220, 3366, 2331, 2221, 3367, 2332, 
         2222, 3054, 3444, 2223, 3055, 3445, 2224, 3056, 3446, 2225, 3057, 
         3447, 2226, 3058, 3448, 2227, 1135, 2228, 3368, 2333, 2229}], 
        Line3DBox[{2243, 2339, 1154, 2242, 3459, 3069, 2241, 3458, 3068, 2240,
          3457, 3067, 2239, 3456, 3066, 2238, 3455, 3065, 2237, 3454, 3064, 
         2236, 2334, 3369, 2235, 3453, 3063, 2234, 3452, 3062, 2233, 3451, 
         3061, 2232, 3450, 3060, 2231, 3449, 3059, 2230, 1153, 2337, 2338}], 
        Line3DBox[{2341, 2654, 1381, 2340, 3565, 2563, 2342, 3566, 2564, 2343,
          3567, 2565, 2344, 3568, 2566, 2345, 3569, 2567, 2346, 3570, 2568, 
         2347, 3571, 3070, 3460, 2348, 3572, 2569, 2349, 3573, 2570, 2350, 
         3574, 2571, 2351, 3575, 2572, 2352, 3576, 2573, 2353, 3174, 3670, 
         2574, 2655}], 
        Line3DBox[{2355, 3071, 3461, 2354, 1396, 2356, 3577, 2575, 2357, 3578,
          2576, 2358, 3579, 2577, 2359, 3580, 2578, 2360, 3581, 2579, 2361, 
         3582, 3072, 3462, 2362, 3073, 3463, 2363, 3583, 2580, 2364, 3584, 
         2581, 2365, 3585, 2582, 2366, 3586, 2583, 2367, 3587, 2584, 2368}], 
        Line3DBox[{2370, 3074, 3464, 2369, 3075, 3465, 2371, 1412, 2372, 3588,
          2585, 2373, 3589, 2586, 2374, 3590, 2587, 2375, 3591, 2588, 2376, 
         3592, 3076, 3466, 2377, 3077, 3467, 2378, 3078, 3468, 2379, 3593, 
         2589, 2380, 3594, 2590, 2381, 3595, 2591, 2382, 3596, 2592, 2383}], 
        Line3DBox[{2385, 3079, 3469, 2384, 3080, 3470, 2386, 3081, 3471, 2387,
          1428, 2388, 3597, 2593, 2389, 3598, 2594, 2390, 3599, 2595, 2391, 
         3600, 3082, 3472, 2392, 3083, 3473, 2393, 3084, 3474, 2394, 3085, 
         3475, 2395, 3601, 2596, 2396, 3602, 2597, 2397, 3603, 2598, 2398}], 
        Line3DBox[{2400, 3086, 3476, 2399, 3087, 3477, 2401, 3088, 3478, 2402,
          3089, 3479, 2403, 1444, 2404, 3604, 2599, 2405, 3605, 2600, 2406, 
         3606, 3090, 3480, 2407, 3091, 3481, 2408, 3092, 3482, 2409, 3093, 
         3483, 2410, 3094, 3484, 2411, 3607, 2601, 2412, 3608, 2602, 2413}], 
        Line3DBox[{2415, 3095, 3485, 2414, 3096, 3486, 2416, 3097, 3487, 2417,
          3098, 3488, 2418, 3099, 3489, 2419, 1460, 2420, 3609, 2603, 2421, 
         3610, 3100, 3490, 2422, 3101, 3491, 2423, 3102, 3492, 2424, 3103, 
         3493, 2425, 3104, 3494, 2426, 3105, 3495, 2427, 3611, 2604, 2428}], 
        Line3DBox[{2430, 3106, 3496, 2429, 3107, 3497, 2431, 3108, 3498, 2432,
          3109, 3499, 2433, 3110, 3500, 2434, 3111, 3501, 2435, 1476, 2436, 
         3612, 3112, 3502, 2437, 3113, 3503, 2438, 3114, 3504, 2439, 3115, 
         3505, 2440, 3116, 3506, 2441, 3117, 3507, 2442, 3118, 3508, 2443}], 
        Line3DBox[{2447, 3613, 2605, 2445, 3614, 2606, 2449, 3615, 2607, 2451,
          3616, 2608, 2453, 3617, 2609, 2455, 3618, 2610, 2457, 3619, 2611, 
         2459, 3621, 1493, 2461, 3622, 2612, 2463, 3623, 2613, 2465, 3624, 
         2614, 2467, 3625, 2615, 2469, 3626, 2616, 2471, 3627, 2617, 2473}], 
        Line3DBox[{2472, 3522, 3132, 2470, 3521, 3131, 2468, 3520, 3130, 2466,
          3519, 3129, 2464, 3518, 3128, 2462, 3517, 3127, 2460, 3516, 3126, 
         3620, 2458, 3515, 3125, 2456, 3514, 3124, 2454, 3513, 3123, 2452, 
         3512, 3122, 2450, 3511, 3121, 2448, 3510, 3120, 2444, 3509, 3119, 
         2446}], Line3DBox[{2475, 3133, 3523, 2474, 3628, 2618, 2476, 3629, 
         2619, 2477, 3630, 2620, 2478, 3631, 2621, 2479, 3632, 2622, 2480, 
         3633, 2623, 2481, 3634, 3134, 3524, 2482, 1509, 2483, 3635, 2624, 
         2484, 3636, 2625, 2485, 3637, 2626, 2486, 3638, 2627, 2487, 3639, 
         2628, 2488}], 
        Line3DBox[{2490, 3135, 3525, 2489, 3136, 3526, 2491, 3640, 2629, 2492,
          3641, 2630, 2493, 3642, 2631, 2494, 3643, 2632, 2495, 3644, 2633, 
         2496, 3645, 3137, 3527, 2497, 3138, 3528, 2498, 1525, 2499, 3646, 
         2634, 2500, 3647, 2635, 2501, 3648, 2636, 2502, 3649, 2637, 2503}], 
        Line3DBox[{2505, 3139, 3529, 2504, 3140, 3530, 2506, 3141, 3531, 2507,
          3650, 2638, 2508, 3651, 2639, 2509, 3652, 2640, 2510, 3653, 2641, 
         2511, 3654, 3142, 3532, 2512, 3143, 3533, 2513, 3144, 3534, 2514, 
         1541, 2515, 3655, 2642, 2516, 3656, 2643, 2517, 3657, 2644, 2518}], 
        Line3DBox[{2520, 3145, 3535, 2519, 3146, 3536, 2521, 3147, 3537, 2522,
          3148, 3538, 2523, 3658, 2645, 2524, 3659, 2646, 2525, 3660, 2647, 
         2526, 3661, 3149, 3539, 2527, 3150, 3540, 2528, 3151, 3541, 2529, 
         3152, 3542, 2530, 1557, 2531, 3662, 2648, 2532, 3663, 2649, 2533}], 
        Line3DBox[{2535, 3153, 3543, 2534, 3154, 3544, 2536, 3155, 3545, 2537,
          3156, 3546, 2538, 3157, 3547, 2539, 3664, 2650, 2540, 3665, 2651, 
         2541, 3666, 3158, 3548, 2542, 3159, 3549, 2543, 3160, 3550, 2544, 
         3161, 3551, 2545, 3162, 3552, 2546, 1573, 2547, 3667, 2652, 2548}], 
        Line3DBox[{2562, 2659, 1593, 2561, 3564, 3173, 2560, 3563, 3172, 2559,
          3562, 3171, 2558, 3561, 3170, 2557, 3560, 3169, 2556, 3559, 3168, 
         3669, 2555, 2653, 3668, 2554, 3558, 3167, 2553, 3557, 3166, 2552, 
         3556, 3165, 2551, 3555, 3164, 2550, 3554, 3163, 2549, 3553, 2657, 
         2656, 2658}], 
        Line3DBox[{2661, 2974, 1820, 2660, 3776, 2883, 2662, 3777, 2884, 2663,
          3778, 2885, 2664, 3779, 2886, 2665, 3780, 2887, 2666, 3781, 2888, 
         2667, 3782, 3175, 3671, 2668, 3783, 2889, 2669, 3784, 2890, 2670, 
         3785, 2891, 2671, 3786, 2892, 2672, 3787, 2893, 2673, 3279, 3881, 
         2894, 2975}], 
        Line3DBox[{2675, 3176, 3672, 2674, 1835, 2676, 3788, 2895, 2677, 3789,
          2896, 2678, 3790, 2897, 2679, 3791, 2898, 2680, 3792, 2899, 2681, 
         3793, 3177, 3673, 2682, 3178, 3674, 2683, 3794, 2900, 2684, 3795, 
         2901, 2685, 3796, 2902, 2686, 3797, 2903, 2687, 3798, 2904, 2688}], 
        Line3DBox[{2690, 3179, 3675, 2689, 3180, 3676, 2691, 1851, 2692, 3799,
          2905, 2693, 3800, 2906, 2694, 3801, 2907, 2695, 3802, 2908, 2696, 
         3803, 3181, 3677, 2697, 3182, 3678, 2698, 3183, 3679, 2699, 3804, 
         2909, 2700, 3805, 2910, 2701, 3806, 2911, 2702, 3807, 2912, 2703}], 
        Line3DBox[{2705, 3184, 3680, 2704, 3185, 3681, 2706, 3186, 3682, 2707,
          1867, 2708, 3808, 2913, 2709, 3809, 2914, 2710, 3810, 2915, 2711, 
         3811, 3187, 3683, 2712, 3188, 3684, 2713, 3189, 3685, 2714, 3190, 
         3686, 2715, 3812, 2916, 2716, 3813, 2917, 2717, 3814, 2918, 2718}], 
        Line3DBox[{2720, 3191, 3687, 2719, 3192, 3688, 2721, 3193, 3689, 2722,
          3194, 3690, 2723, 1883, 2724, 3815, 2919, 2725, 3816, 2920, 2726, 
         3817, 3195, 3691, 2727, 3196, 3692, 2728, 3197, 3693, 2729, 3198, 
         3694, 2730, 3199, 3695, 2731, 3818, 2921, 2732, 3819, 2922, 2733}], 
        Line3DBox[{2735, 3200, 3696, 2734, 3201, 3697, 2736, 3202, 3698, 2737,
          3203, 3699, 2738, 3204, 3700, 2739, 1899, 2740, 3820, 2923, 2741, 
         3821, 3205, 3701, 2742, 3206, 3702, 2743, 3207, 3703, 2744, 3208, 
         3704, 2745, 3209, 3705, 2746, 3210, 3706, 2747, 3822, 2924, 2748}], 
        Line3DBox[{2750, 3211, 3707, 2749, 3212, 3708, 2751, 3213, 3709, 2752,
          3214, 3710, 2753, 3215, 3711, 2754, 3216, 3712, 2755, 1915, 2756, 
         3823, 3217, 3713, 2757, 3218, 3714, 2758, 3219, 3715, 2759, 3220, 
         3716, 2760, 3221, 3717, 2761, 3222, 3718, 2762, 3223, 3719, 2763}], 
        Line3DBox[{2767, 3824, 2925, 2765, 3825, 2926, 2769, 3826, 2927, 2771,
          3827, 2928, 2773, 3828, 2929, 2775, 3829, 2930, 2777, 3830, 2931, 
         2779, 3832, 1932, 2781, 3833, 2932, 2783, 3834, 2933, 2785, 3835, 
         2934, 2787, 3836, 2935, 2789, 3837, 2936, 2791, 3838, 2937, 2793}], 
        Line3DBox[{2792, 3733, 3237, 2790, 3732, 3236, 2788, 3731, 3235, 2786,
          3730, 3234, 2784, 3729, 3233, 2782, 3728, 3232, 2780, 3727, 3231, 
         3831, 2778, 3726, 3230, 2776, 3725, 3229, 2774, 3724, 3228, 2772, 
         3723, 3227, 2770, 3722, 3226, 2768, 3721, 3225, 2764, 3720, 3224, 
         2766}], Line3DBox[{2795, 3238, 3734, 2794, 3839, 2938, 2796, 3840, 
         2939, 2797, 3841, 2940, 2798, 3842, 2941, 2799, 3843, 2942, 2800, 
         3844, 2943, 2801, 3845, 3239, 3735, 2802, 1948, 2803, 3846, 2944, 
         2804, 3847, 2945, 2805, 3848, 2946, 2806, 3849, 2947, 2807, 3850, 
         2948, 2808}], 
        Line3DBox[{2810, 3240, 3736, 2809, 3241, 3737, 2811, 3851, 2949, 2812,
          3852, 2950, 2813, 3853, 2951, 2814, 3854, 2952, 2815, 3855, 2953, 
         2816, 3856, 3242, 3738, 2817, 3243, 3739, 2818, 1964, 2819, 3857, 
         2954, 2820, 3858, 2955, 2821, 3859, 2956, 2822, 3860, 2957, 2823}], 
        Line3DBox[{2825, 3244, 3740, 2824, 3245, 3741, 2826, 3246, 3742, 2827,
          3861, 2958, 2828, 3862, 2959, 2829, 3863, 2960, 2830, 3864, 2961, 
         2831, 3865, 3247, 3743, 2832, 3248, 3744, 2833, 3249, 3745, 2834, 
         1980, 2835, 3866, 2962, 2836, 3867, 2963, 2837, 3868, 2964, 2838}], 
        Line3DBox[{2840, 3250, 3746, 2839, 3251, 3747, 2841, 3252, 3748, 2842,
          3253, 3749, 2843, 3869, 2965, 2844, 3870, 2966, 2845, 3871, 2967, 
         2846, 3872, 3254, 3750, 2847, 3255, 3751, 2848, 3256, 3752, 2849, 
         3257, 3753, 2850, 1996, 2851, 3873, 2968, 2852, 3874, 2969, 2853}], 
        Line3DBox[{2855, 3258, 3754, 2854, 3259, 3755, 2856, 3260, 3756, 2857,
          3261, 3757, 2858, 3262, 3758, 2859, 3875, 2970, 2860, 3876, 2971, 
         2861, 3877, 3263, 3759, 2862, 3264, 3760, 2863, 3265, 3761, 2864, 
         3266, 3762, 2865, 3267, 3763, 2866, 2012, 2867, 3878, 2972, 2868}], 
        Line3DBox[{2882, 2979, 2032, 2881, 3775, 3278, 2880, 3774, 3277, 2879,
          3773, 3276, 2878, 3772, 3275, 2877, 3771, 3274, 2876, 3770, 3273, 
         3880, 2875, 2973, 3879, 2874, 3769, 3272, 2873, 3768, 3271, 2872, 
         3767, 3270, 2871, 3766, 3269, 2870, 3765, 3268, 2869, 3764, 2977, 
         2976, 2978}]}, {
        Line3DBox[{749, 957, 3280, 750, 970, 776, 3375, 984, 790, 3380, 998, 
         804, 3387, 1012, 818, 3396, 1026, 832, 3407, 1040, 846, 1054, 3322, 
         860, 1068, 3334, 874, 3422, 1082, 888, 3426, 1096, 902, 3432, 1110, 
         916, 3440, 1124, 930, 3449, 1138, 944}], 
        Line3DBox[{751, 958, 3281, 752, 971, 3291, 777, 985, 791, 3381, 999, 
         805, 3388, 1013, 819, 3397, 1027, 833, 3408, 1041, 847, 1055, 3323, 
         861, 1069, 3335, 875, 1083, 3345, 889, 3427, 1097, 903, 3433, 1111, 
         917, 3441, 1125, 931, 3450, 1139, 945}], 
        Line3DBox[{753, 959, 3282, 754, 972, 3292, 778, 986, 3301, 792, 1000, 
         806, 3389, 1014, 820, 3398, 1028, 834, 3409, 1042, 848, 1056, 3324, 
         862, 1070, 3336, 876, 1084, 3346, 890, 1098, 3354, 904, 3434, 1112, 
         918, 3442, 1126, 932, 3451, 1140, 946}], 
        Line3DBox[{755, 960, 3283, 756, 973, 3293, 779, 987, 3302, 793, 1001, 
         3309, 807, 1015, 821, 3399, 1029, 835, 3410, 1043, 849, 1057, 3325, 
         863, 1071, 3337, 877, 1085, 3347, 891, 1099, 3355, 905, 1113, 3361, 
         919, 3443, 1127, 933, 3452, 1141, 947}], 
        Line3DBox[{757, 961, 3284, 758, 974, 3294, 780, 988, 3303, 794, 1002, 
         3310, 808, 1016, 3315, 822, 1030, 836, 3411, 1044, 850, 1058, 3326, 
         864, 1072, 3338, 878, 1086, 3348, 892, 1100, 3356, 906, 1114, 3362, 
         920, 1128, 3366, 934, 3453, 1142, 948}], 
        Line3DBox[{759, 962, 3285, 760, 975, 3295, 781, 989, 3304, 795, 1003, 
         3311, 809, 1017, 3316, 823, 1031, 3319, 837, 1045, 851, 1059, 3327, 
         865, 1073, 3339, 879, 1087, 3349, 893, 1101, 3357, 907, 1115, 3363, 
         921, 1129, 3367, 935, 1143, 3369, 949}], 
        Line3DBox[{8, 2043, 23, 2057, 38, 2072, 53, 2087, 68, 2102, 83, 2117, 
         98, 2132, 113, 2147, 128, 2162, 143, 2177, 158, 2192, 173, 2207, 188,
          2222, 203, 2236, 218}], 
        Line3DBox[{761, 3370, 963, 762, 3372, 976, 782, 3376, 990, 796, 3382, 
         1004, 810, 3390, 1018, 824, 3400, 1032, 838, 3412, 1046, 852, 1060, 
         866, 3420, 1074, 880, 3423, 1088, 894, 3428, 1102, 908, 3435, 1116, 
         922, 3444, 1130, 936, 3454, 1144, 950}], 
        Line3DBox[{763, 964, 3286, 764, 3373, 977, 783, 3377, 991, 797, 3383, 
         1005, 811, 3391, 1019, 825, 3401, 1033, 839, 3413, 1047, 853, 1061, 
         3328, 867, 1075, 881, 3424, 1089, 895, 3429, 1103, 909, 3436, 1117, 
         923, 3445, 1131, 937, 3455, 1145, 951}], 
        Line3DBox[{765, 965, 3287, 766, 978, 3296, 784, 3378, 992, 798, 3384, 
         1006, 812, 3392, 1020, 826, 3402, 1034, 840, 3414, 1048, 854, 1062, 
         3329, 868, 1076, 3340, 882, 1090, 896, 3430, 1104, 910, 3437, 1118, 
         924, 3446, 1132, 938, 3456, 1146, 952}], 
        Line3DBox[{767, 966, 3288, 768, 979, 3297, 785, 993, 3305, 799, 3385, 
         1007, 813, 3393, 1021, 827, 3403, 1035, 841, 3415, 1049, 855, 1063, 
         3330, 869, 1077, 3341, 883, 1091, 3350, 897, 1105, 911, 3438, 1119, 
         925, 3447, 1133, 939, 3457, 1147, 953}], 
        Line3DBox[{769, 967, 3289, 770, 980, 3298, 786, 994, 3306, 800, 1008, 
         3312, 814, 3394, 1022, 828, 3404, 1036, 842, 3416, 1050, 856, 1064, 
         3331, 870, 1078, 3342, 884, 1092, 3351, 898, 1106, 3358, 912, 1120, 
         926, 3448, 1134, 940, 3458, 1148, 954}], 
        Line3DBox[{771, 968, 3290, 772, 981, 3299, 787, 995, 3307, 801, 1009, 
         3313, 815, 1023, 3317, 829, 3405, 1037, 843, 3417, 1051, 857, 1065, 
         3332, 871, 1079, 3343, 885, 1093, 3352, 899, 1107, 3359, 913, 1121, 
         3364, 927, 1135, 941, 3459, 1149, 955}], 
        Line3DBox[{773, 1151, 1152, 774, 982, 3300, 788, 996, 3308, 802, 1010,
          3314, 816, 1024, 3318, 830, 1038, 3320, 844, 3418, 1052, 858, 1066, 
         3333, 872, 1080, 3344, 886, 1094, 3353, 900, 1108, 3360, 914, 1122, 
         3365, 928, 1136, 3368, 942, 1154, 1155, 1156}], 
        Line3DBox[{943, 1137, 1153, 929, 1123, 3439, 915, 1109, 3431, 901, 
         1095, 3425, 887, 1081, 3421, 873, 1067, 3419, 859, 3321, 1053, 845, 
         1039, 3406, 831, 1025, 3395, 817, 1011, 3386, 803, 997, 3379, 789, 
         983, 3374, 775, 969, 3371, 748, 956, 1150, 1157}], 
        Line3DBox[{1159, 1382, 3565, 1160, 1396, 1188, 3465, 1411, 1203, 3470,
          1426, 1218, 3477, 1441, 1233, 3486, 1456, 1248, 3497, 1471, 1263, 
         3510, 1486, 3614, 1278, 1501, 3628, 1293, 3526, 1516, 1308, 3530, 
         1531, 1323, 3536, 1546, 1338, 3544, 1561, 1353, 3554, 1576, 1368}], 
        Line3DBox[{1161, 1383, 3566, 1162, 1397, 3577, 1189, 1412, 1204, 3471,
          1427, 1219, 3478, 1442, 1234, 3487, 1457, 1249, 3498, 1472, 1264, 
         3511, 1487, 3615, 1279, 1502, 3629, 1294, 1517, 3640, 1309, 3531, 
         1532, 1324, 3537, 1547, 1339, 3545, 1562, 1354, 3555, 1577, 1369}], 
        Line3DBox[{1163, 1384, 3567, 1164, 1398, 3578, 1190, 1413, 3588, 1205,
          1428, 1220, 3479, 1443, 1235, 3488, 1458, 1250, 3499, 1473, 1265, 
         3512, 1488, 3616, 1280, 1503, 3630, 1295, 1518, 3641, 1310, 1533, 
         3650, 1325, 3538, 1548, 1340, 3546, 1563, 1355, 3556, 1578, 1370}], 
        Line3DBox[{1165, 1385, 3568, 1166, 1399, 3579, 1191, 1414, 3589, 1206,
          1429, 3597, 1221, 1444, 1236, 3489, 1459, 1251, 3500, 1474, 1266, 
         3513, 1489, 3617, 1281, 1504, 3631, 1296, 1519, 3642, 1311, 1534, 
         3651, 1326, 1549, 3658, 1341, 3547, 1564, 1356, 3557, 1579, 1371}], 
        Line3DBox[{1167, 1386, 3569, 1168, 1400, 3580, 1192, 1415, 3590, 1207,
          1430, 3598, 1222, 1445, 3604, 1237, 1460, 1252, 3501, 1475, 1267, 
         3514, 1490, 3618, 1282, 1505, 3632, 1297, 1520, 3643, 1312, 1535, 
         3652, 1327, 1550, 3659, 1342, 1565, 3664, 1357, 3558, 1580, 1372}], 
        Line3DBox[{1169, 1387, 3570, 1170, 1401, 3581, 1193, 1416, 3591, 1208,
          1431, 3599, 1223, 1446, 3605, 1238, 1461, 3609, 1253, 1476, 1268, 
         3515, 1491, 3619, 1283, 1506, 3633, 1298, 1521, 3644, 1313, 1536, 
         3653, 1328, 1551, 3660, 1343, 1566, 3665, 1358, 1581, 3668, 1373}], 
        Line3DBox[{1171, 1388, 3571, 1173, 1402, 3582, 1194, 1417, 3592, 1209,
          1432, 3600, 1224, 1447, 3606, 1239, 1462, 3610, 1254, 1477, 3612, 
         1269, 1492, 3620, 3621, 1284, 1507, 3634, 1299, 1522, 3645, 1314, 
         1537, 3654, 1329, 1552, 3661, 1344, 1567, 3666, 1359, 1582, 3669, 
         1374}], Line3DBox[{1175, 1390, 3572, 1176, 3463, 1404, 1196, 3467, 
         1419, 1211, 3473, 1434, 1226, 3481, 1449, 1241, 3491, 1464, 1256, 
         3503, 1479, 1271, 3517, 1494, 3622, 1286, 1509, 1301, 3528, 1524, 
         1316, 3533, 1539, 1331, 3540, 1554, 1346, 3549, 1569, 1361, 3560, 
         1584, 1376}], 
        Line3DBox[{1177, 1391, 3573, 1178, 1405, 3583, 1197, 3468, 1420, 1212,
          3474, 1435, 1227, 3482, 1450, 1242, 3492, 1465, 1257, 3504, 1480, 
         1272, 3518, 1495, 3623, 1287, 1510, 3635, 1302, 1525, 1317, 3534, 
         1540, 1332, 3541, 1555, 1347, 3550, 1570, 1362, 3561, 1585, 1377}], 
        Line3DBox[{1179, 1392, 3574, 1180, 1406, 3584, 1198, 1421, 3593, 1213,
          3475, 1436, 1228, 3483, 1451, 1243, 3493, 1466, 1258, 3505, 1481, 
         1273, 3519, 1496, 3624, 1288, 1511, 3636, 1303, 1526, 3646, 1318, 
         1541, 1333, 3542, 1556, 1348, 3551, 1571, 1363, 3562, 1586, 1378}], 
        Line3DBox[{1181, 1393, 3575, 1182, 1407, 3585, 1199, 1422, 3594, 1214,
          1437, 3601, 1229, 3484, 1452, 1244, 3494, 1467, 1259, 3506, 1482, 
         1274, 3520, 1497, 3625, 1289, 1512, 3637, 1304, 1527, 3647, 1319, 
         1542, 3655, 1334, 1557, 1349, 3552, 1572, 1364, 3563, 1587, 1379}], 
        Line3DBox[{1183, 1394, 3576, 1184, 1408, 3586, 1200, 1423, 3595, 1215,
          1438, 3602, 1230, 1453, 3607, 1245, 3495, 1468, 1260, 3507, 1483, 
         1275, 3521, 1498, 3626, 1290, 1513, 3638, 1305, 1528, 3648, 1320, 
         1543, 3656, 1335, 1558, 3662, 1350, 1573, 1365, 3564, 1588, 1380}], 
        Line3DBox[{1185, 1590, 1591, 3670, 1186, 1409, 3587, 1201, 1424, 3596,
          1216, 1439, 3603, 1231, 1454, 3608, 1246, 1469, 3611, 1261, 3508, 
         1484, 1276, 3522, 1499, 3627, 1291, 1514, 3639, 1306, 1529, 3649, 
         1321, 1544, 3657, 1336, 1559, 3663, 1351, 1574, 3667, 1366, 1593, 
         1594, 1595}], 
        Line3DBox[{1367, 1575, 3553, 1592, 1352, 1560, 3543, 1337, 1545, 3535,
          1322, 1530, 3529, 1307, 1515, 3525, 1292, 1500, 3523, 1277, 3613, 
         1485, 3509, 1262, 1470, 3496, 1247, 1455, 3485, 1232, 1440, 3476, 
         1217, 1425, 3469, 1202, 1410, 3464, 1187, 1395, 3461, 1158, 1381, 
         1589, 1596}], 
        Line3DBox[{1375, 1583, 3559, 1360, 1568, 3548, 1345, 1553, 3539, 1330,
          1538, 3532, 1315, 1523, 3527, 1300, 1508, 3524, 1285, 1493, 3516, 
         1270, 1478, 3502, 1255, 1463, 3490, 1240, 1448, 3480, 1225, 1433, 
         3472, 1210, 1418, 3466, 1195, 1403, 3462, 1174, 1389, 3460, 1172}], 
        Line3DBox[{1598, 1821, 3776, 1599, 1835, 1627, 3676, 1850, 1642, 3681,
          1865, 1657, 3688, 1880, 1672, 3697, 1895, 1687, 3708, 1910, 1702, 
         3721, 1925, 3825, 1717, 1940, 3839, 1732, 3737, 1955, 1747, 3741, 
         1970, 1762, 3747, 1985, 1777, 3755, 2000, 1792, 3765, 2015, 1807}], 
        Line3DBox[{1600, 1822, 3777, 1601, 1836, 3788, 1628, 1851, 1643, 3682,
          1866, 1658, 3689, 1881, 1673, 3698, 1896, 1688, 3709, 1911, 1703, 
         3722, 1926, 3826, 1718, 1941, 3840, 1733, 1956, 3851, 1748, 3742, 
         1971, 1763, 3748, 1986, 1778, 3756, 2001, 1793, 3766, 2016, 1808}], 
        Line3DBox[{1602, 1823, 3778, 1603, 1837, 3789, 1629, 1852, 3799, 1644,
          1867, 1659, 3690, 1882, 1674, 3699, 1897, 1689, 3710, 1912, 1704, 
         3723, 1927, 3827, 1719, 1942, 3841, 1734, 1957, 3852, 1749, 1972, 
         3861, 1764, 3749, 1987, 1779, 3757, 2002, 1794, 3767, 2017, 1809}], 
        Line3DBox[{1604, 1824, 3779, 1605, 1838, 3790, 1630, 1853, 3800, 1645,
          1868, 3808, 1660, 1883, 1675, 3700, 1898, 1690, 3711, 1913, 1705, 
         3724, 1928, 3828, 1720, 1943, 3842, 1735, 1958, 3853, 1750, 1973, 
         3862, 1765, 1988, 3869, 1780, 3758, 2003, 1795, 3768, 2018, 1810}], 
        Line3DBox[{1606, 1825, 3780, 1607, 1839, 3791, 1631, 1854, 3801, 1646,
          1869, 3809, 1661, 1884, 3815, 1676, 1899, 1691, 3712, 1914, 1706, 
         3725, 1929, 3829, 1721, 1944, 3843, 1736, 1959, 3854, 1751, 1974, 
         3863, 1766, 1989, 3870, 1781, 2004, 3875, 1796, 3769, 2019, 1811}], 
        Line3DBox[{1608, 1826, 3781, 1609, 1840, 3792, 1632, 1855, 3802, 1647,
          1870, 3810, 1662, 1885, 3816, 1677, 1900, 3820, 1692, 1915, 1707, 
         3726, 1930, 3830, 1722, 1945, 3844, 1737, 1960, 3855, 1752, 1975, 
         3864, 1767, 1990, 3871, 1782, 2005, 3876, 1797, 2020, 3879, 1812}], 
        Line3DBox[{1610, 1827, 3782, 1612, 1841, 3793, 1633, 1856, 3803, 1648,
          1871, 3811, 1663, 1886, 3817, 1678, 1901, 3821, 1693, 1916, 3823, 
         1708, 1931, 3831, 3832, 1723, 1946, 3845, 1738, 1961, 3856, 1753, 
         1976, 3865, 1768, 1991, 3872, 1783, 2006, 3877, 1798, 2021, 3880, 
         1813}], Line3DBox[{1614, 1829, 3783, 1615, 3674, 1843, 1635, 3678, 
         1858, 1650, 3684, 1873, 1665, 3692, 1888, 1680, 3702, 1903, 1695, 
         3714, 1918, 1710, 3728, 1933, 3833, 1725, 1948, 1740, 3739, 1963, 
         1755, 3744, 1978, 1770, 3751, 1993, 1785, 3760, 2008, 1800, 3771, 
         2023, 1815}], 
        Line3DBox[{1616, 1830, 3784, 1617, 1844, 3794, 1636, 3679, 1859, 1651,
          3685, 1874, 1666, 3693, 1889, 1681, 3703, 1904, 1696, 3715, 1919, 
         1711, 3729, 1934, 3834, 1726, 1949, 3846, 1741, 1964, 1756, 3745, 
         1979, 1771, 3752, 1994, 1786, 3761, 2009, 1801, 3772, 2024, 1816}], 
        Line3DBox[{1618, 1831, 3785, 1619, 1845, 3795, 1637, 1860, 3804, 1652,
          3686, 1875, 1667, 3694, 1890, 1682, 3704, 1905, 1697, 3716, 1920, 
         1712, 3730, 1935, 3835, 1727, 1950, 3847, 1742, 1965, 3857, 1757, 
         1980, 1772, 3753, 1995, 1787, 3762, 2010, 1802, 3773, 2025, 1817}], 
        Line3DBox[{1620, 1832, 3786, 1621, 1846, 3796, 1638, 1861, 3805, 1653,
          1876, 3812, 1668, 3695, 1891, 1683, 3705, 1906, 1698, 3717, 1921, 
         1713, 3731, 1936, 3836, 1728, 1951, 3848, 1743, 1966, 3858, 1758, 
         1981, 3866, 1773, 1996, 1788, 3763, 2011, 1803, 3774, 2026, 1818}], 
        Line3DBox[{1622, 1833, 3787, 1623, 1847, 3797, 1639, 1862, 3806, 1654,
          1877, 3813, 1669, 1892, 3818, 1684, 3706, 1907, 1699, 3718, 1922, 
         1714, 3732, 1937, 3837, 1729, 1952, 3849, 1744, 1967, 3859, 1759, 
         1982, 3867, 1774, 1997, 3873, 1789, 2012, 1804, 3775, 2027, 1819}], 
        Line3DBox[{1624, 2029, 2030, 3881, 1625, 1848, 3798, 1640, 1863, 3807,
          1655, 1878, 3814, 1670, 1893, 3819, 1685, 1908, 3822, 1700, 3719, 
         1923, 1715, 3733, 1938, 3838, 1730, 1953, 3850, 1745, 1968, 3860, 
         1760, 1983, 3868, 1775, 1998, 3874, 1790, 2013, 3878, 1805, 2032, 
         2033, 2034}], 
        Line3DBox[{1806, 2014, 3764, 2031, 1791, 1999, 3754, 1776, 1984, 3746,
          1761, 1969, 3740, 1746, 1954, 3736, 1731, 1939, 3734, 1716, 3824, 
         1924, 3720, 1701, 1909, 3707, 1686, 1894, 3696, 1671, 1879, 3687, 
         1656, 1864, 3680, 1641, 1849, 3675, 1626, 1834, 3672, 1597, 1820, 
         2028, 2035}], 
        Line3DBox[{1814, 2022, 3770, 1799, 2007, 3759, 1784, 1992, 3750, 1769,
          1977, 3743, 1754, 1962, 3738, 1739, 1947, 3735, 1724, 1932, 3727, 
         1709, 1917, 3713, 1694, 1902, 3701, 1679, 1887, 3691, 1664, 1872, 
         3683, 1649, 1857, 3677, 1634, 1842, 3673, 1613, 1828, 3671, 
         1611}]}, {}, {}, {}, {}, {}, {}, {}, {}, {}}},
     VertexNormals->CompressedData["
1:eJzsvXlYj933952ETCFTmTJUQqYyNq0yJIkoGSvJGJkrNJiJQpMpRTKUpJFE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      "]]}},
  Boxed->False,
  PlotRange->{{-1, 1}, {-1, 1}, {-1, 2.5}}]], "Output",
 CellChangeTimes->{3.405505804497423*^9, 3.405505890661874*^9, 
  3.405505949021724*^9, 3.405505988244079*^9, 3.405506037736759*^9, 
  3.405507249053451*^9, 3.405586234267184*^9, 3.405588950749947*^9, 
  3.405589728040906*^9, 3.405607412529937*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\
eJztfWmwbElxXnFOd9/lvccisYMYYEDQgBCXRSyPRUgsYjMgif0KGDYBRpaM
CTu8hh3yEl5DEfJKKBRSKCwHISukcDgc/mEJxDaswwzDAIPYDAzDjgQ0+9A+
VZlZmZWVWeecvv3kP7yIfvfe7rNV1pdfrlX9tCte98qX/8oVr3vVS6+46xNf
e8WvvfJVL/1bd33Cr752eKu/WQg3u/vw+uO7hvj7NgT67/9sh39d/P1l8bcQ
/nf8sUgf9tvT9FZIn7wUPv9f+YRV/Hg4CA9IH18BB/3PfNCRcdCL4aA/ij+W
8ZPzxkEvgoP+MF+pFwfF54p/WSe+EE78A/M56cRz/olvyCceeiemT/EBfz/+
SMecMw4/zIcraeLNfi+f3RlnHxvvLfMVF8YYTuGyv5vHsBwZPL3X5cseGJd9
AVz2t/PTWqKxntbFAF7xt/KDWg+VTlx4CHk+XOL1+RJCxN4wV3mYFpwsVDwP
7vKf8tAXk4d+imdYADz2b/Uf8oAOJt9q+Mv64CgPF4X1m/na7uHprQse8iqs
0sM/B27wG1lO1iVY/BbcrQnr8xkW3Twbbvpvm1p0vnnZ6QriIPlZ8Az/Okt2
jG/4GVqKVFGKut+/zPc7al7CGv2BxUpaVHS/X4T7/fMs4/YVp/LYIj+hpVDW
wH8BHuSf5oFPxVCXacSa7GN8HPFeHoylgI1H+ydZRv6NRlDlPRUabOsax/lx
car+UX6MNrqsiWTGsPTXBI4QwD/IczMfJNbM2ZQzyhcVrGiengmP+ffyYzbw
XwDVpYqzMb9LBfTAz4AH/jt5RseUpbiiD9+ZwLJ44enwaK+bCDbXvrc5pTdm
ydJAfJq/mZ/Gut+kK+6OVuaZqZT21+Cpf7VJaS57zgLlLjBucpM5ktdMYECb
aqd6lC7U2mBiXkOkvDrL3L3zYhy3ro85i7TantVT4YF/eRzasyDUfkxb9C0I
uRpRwUEN7OVnQP9UOrQfpH0GQUMwYEWblkP4FBjWS3ZWBZe2F02NdLFxmM+1
ePzJ8LgvHteHaVZjqgcxP+CdGrI9CUb0wjwiV4fdx9wxUHFNdFudpgaIOLAU
Oy92e/T5pqGtHFPtiHtw+hQx+Lw8Y/vR6/n2Y0fKt1FN0/ZEGN2zMyFMjRBd
C9y2dfPB2/azp2OGRvwEGPHPZ6Bal0iTUOX/9gHj+eiZ5ahbGTIc8dPzHJ8t
n9d+hp0wzxg9n5E+3ZbQOB8P43xa1tSpkrMTjN4ZIUlwJ/SzzT6b/aERPw5G
/JQ8YveRLO2dbyF3BP5ijr63VaUhhSdlKbRJct+Gydfo6S7UfFTyRCHsn5iH
H8YDyH0lL9pnNAfb9FeLQ5fep23T9jMgl8dl2vPxVE3UfFO4Y4bBTUjND4Fs
RCppPDZLw/UzZiRgJjgdYTyLNd/CT3FPx5WPRPNYEM2js2jmU3d7tizszret
8z2CCSkEi09/GuTxyEwoszjCJfv9+AtTbPV0apnpNVsTqqT28Iyi+R7Q1Cl1
rfzS09aDPDP7qZBMjyhJPI8B8Tw0g6rtPc1Pye5owtNbY9H7tGHrM0IIpQqu
r900ZfRokNGDm0Q0f5zzz5iilmdzbtomaAILo7o9cDZJWTNnzb8zypFa3Rxt
nWZoOUM2P6E7HQ0EwUeBWB+QxToDAC6RzRjtWeKndjZu31ljy8lC6d0/S6/t
Fe47AJtvk504ZXcvw6M482ApukeC6O6buW+WW9nup5nf0LG/mG4m6t1RL/Wn
JLiLILh7Z8HtJ4Jte6A7Zne4UtCG/h7bOGZlEh4BsrxnluUUHQA0NqlvolWw
i9rT8Gxdb8cy2k6Gf2qdAEV8eabIHZHgOrM8aOQIpKSRXqv9V0aK6fb5cVKw
wgJBdb9blt/OTVT1nPtu8NncIFc75vtMbZJsg8J1eh4GMr3LninUjQcuqbU4
i7/YTlRMjZLaPhIK+84ZwDvXN4qDdyym7ph7Wnjy2I/ZXOzML1LSDwVJ3zFL
eketmmVzaoFKytubvzmjfWzHUbsO10+BWG+fxbqfuGxHd2xyFrQhDcujmR+c
7buGYnkPDwHZ3yH9mKN5Z8kT70Gi3nsTagB7bJewndHWkK1E50MErZzRiLmh
wEwXDz/cU/9AOyswP5s1HzIk6geDqO9kiHrfhdraCxwL5efn7iebtRBCbdaK
kbvcPTWIFMgRkr6zIemzNKBM7/Zocs6IwS8O7j2dslvtdkdMu7Q/vWpAYH8g
TMGPGVMwxdLNcRZdGZ2le9ZS6naJwTVZbqP2mZ3FSi4j0s+aeBbf8RKztDV2
Tbynwrb7df09+I52+EVSPgEp38W1nZfWi7SGMy+h0WRm1q19Z7fa3WljukXS
fwBI/7KJ0p8vGZd1tDzGxegKSvd9nxUxZ0mBjRl+Jfi7ThD8OOG0jXu/Z8nM
MnDteMPWvpadmmr4WS5IMHczJH2YH+5SeYxnE4+LBBLPWXKnbX/R/ZTNkvIX
EdF3N+Q8vww5P/Qfgc2+7JirTDua66WSZPzAujz7e1YH9/1B9pcbst+3o+hW
KNocfWmyitPTZm2mcZNWbibxJ0Di90g/pkez7o1c13A/TpANH/p0h/hrpj65
5sfNKd4PBHzPCQbSlB/VuOY3VM93CUd9mYqne0+L9p3+avdnWcksFPyPG4J3
JTM5OoP5cZDlVoanrl1qA8MSmXXlZR6RL+Tdq38ZG2MuDs3Hff352LenOKFG
FsYD1/naNSXjulcDjhi/l4fxNmftp4zcAtI+mm3miq2AhiSsA+PGjnjs5A4h
eQ1ST305/Ng7tqftxy/sPZEc57lwSWWPruAUd3c8c6PkfB8D3XtsUnBdmXY4
Pr9+umPGcG4ibMQsTVpMfm+Q/H0zws+SUZ1AtRxY8ZB3Xe585qpfe5nu9JoW
CRPYGbl6HCbzte6MXQiSI2e5LiyUaTZM3mjfJWULxQ3B76ptc3yUtmpUAcM0
ybjEMr9cM1JMnksspezBzcPw0jjcXfk3lXXP7MC1NWlP6RoDL5YmcWmhHUsh
ou9vSHU+bHZMZexHPPOJpt/NDs0fZXtfHMiUhJ80pmCKVs2hnPkV4rYv0yak
S4ydduZmajSqZuEBxiy0UbSP+IsD6zCe45pPzm1z3iLnGc1i05sMSOSQlIUy
RDv913vs3UbN2fNV+a/9dKK09xBx4TEpBaqk+kADyLtWZmxszFrY1iaYafm+
6d7eHn0a1zhZPgqUeMKDDNm3mgzmB+E7dlO4KfP5mdO5vt5IN4WhRe2dLC4f
EfWOGYpLGUWwQrRUyKWgtpu3Y9BQDZWgDPV37HXbC2KYZNrR+Cx/Z+EhxZLW
BG95vsO3R0e4QpGajIcYkzEvVK9M1M6hervmu2oKdEreaq7N2VfBU0n+MpA8
9PHvmDKu2KeNtL1XsS5dZtxlHjv8VEJ9qAHn6eFTazrbAGu7hbPcmjOuYJ/Q
n7XHhLDlsUB3IS602q/vF8K+Kpp1tF5VYdoFukvg3ognyMdPXdcKjbOw/csZ
NfAsRNPjFNF94gfzc+RtbdpPWqft4aQbIZAfYci0rWVnSVpNZZf5+fS23Z0l
vD7KZb5fY93Ibq8hWMPSE1x1bIiMg69GV1FLl2Y1Re6UnGnXYtome+nJuZ2o
auPFqmLCaircBaPh202Qxvw1M2dRJpcq5jowfIeG0FvDqwhFyfZRLjV7XvAe
bc/83N5OwfgMpVmWom6ryiSPheQNqzNxN6s5Ds4+c5+zGGUOT0+o72I6IlsT
Omyk2Wq+KlmOyO196btG+owp4bMUMvcdHi3x/22pHdG3m9l/3oSChXuU/GM8
3Lsqxh7PHku9O3Z8nlmjlvgIagLag59At0KVhLB/2hD2jrHlLL38/0pBrrQW
QvaBX2dzBUdx02eiUwpxO5ijxxpzdOmdwvlE1XYKfTMeMrJtoxx6qQymTh7a
p7tLO90+EyvfdVuYBtgBeK/uotWzc2lir4a7I6pN1eDoEcbkPzVasAwuivdn
PdqfxU5uNaJXHBg/+KuItvpSzsMhF8UTsOUiqW71UKcQujeY6VE5TcZtYDIe
N3EyJrRWrDLJC8jPTOa0Wx8P8e/4aRQuvdYf3OR7C+JZalXYehM4rxPH5JCW
rG8Nt368K+tJUqqDzyoR2PYOZmkGg4lRi37PRVszLGBYtGKBve0+TiiTI5yf
YIi4ZmFbzWaZcncFms1kE5GlRFE11x+g7BHwaT6Px7DusvWsxhtm49v5op7v
Hu7S5OVA5bA5WN9whYTdi/ExBrkK3h6Tbjsen8+ibokX8zJPNCQ+2VkeJy1X
dPvuZ2OFXKDYr9sgqJHRh9NqkrH8m20YW7sw043DTPrPxR8u7ey7/W/Hyr+F
oZUYdDKNH0hC7aOMD0Da9NiWy20Jhxb6RGuDMhwfOqyrxy87uxScOj+u3NHG
UJ6EJEpSjaA9lyXKmLZM3vSIsASvN2Ts/3nyBOlmvZ+/5GDHKlo7USv4dZBi
VvRBmln5D5XyhyD9Sst/3tlDK7CBTfZPafoQ++nH23cVzXEju5TN6xNeEb8g
f1Pi5el0O2KZLap+lveE7mhc+PRUz1VwTcR+FvmN1KWnmwZC7vr9LLNeoFSb
LSnbxLqFjm0FSg/l5aUWtVuHcPXv0zyP4Mwh7YTeugkBGyp71BUAWC2yDEdh
/cktuH5jSebQECOT0fStRAKt/IDvPd7R2rfT8vOdIzpD8ovMqF3MnxbSMqU6
2OwP5eOyTAGRhT0LGpEqLU3POsGBxO3Rnj7R8O/oQ08mQny5x7uWQ4BOChn9
qXEGGOAchT+8Igt/WMcVNEGhlDLJdqt1tO2X406jz3CFPr0jeW5CYoL3IKOe
WooLIQlK5gyvjhD84Y2E6cqWmzZSoQkoO338UF+I7X70CV0BO1alNJmF9ARt
JCKREokGyhpUMuMNFBXg3OdMB+O++s80xDSr9f7SVPtHbOFFKcQlBp6CDUtJ
Xr9x/VHXFbXsDzP+Y0B4P2/a7dMZJiw/wywPt03dMumUNPGaTVa5LnnrC+nZ
xN9BXGVwdDE/HgL1+lrZ13++2Z4wu1gI8CsSNrvj9zb+giHaCSsq2vX4+Y25
S7yCFgzKNHs9gx1HRWYTc53Kg/SANfaJ8LiPbJIc2ezUaaqsiiOCxHnAb0j9
xfjD9YdGChPTty6xXB03sSGVn+ksOuRJhtduDlEEwpEEiQ8WmKxGhGISG7yW
u0gtPQN+G/izXIPr+SxT+rzGTK5wCMpnJ80jCUWwJQm9fwMYRwmhUygJsTfh
RTBsCcrW00C5H/jGdGsYS+Ycw4z0Z7CnhcJcs7H8tCMhC6mjIItBDAtXDDZN
0XtbImaIzcJzjOHv0yU4FcZBKlLbWApLPcDkfYLTr94kma0MmUk7iBjKvq08
jsSE5OSKjkLEiBz815Lajq03M+J/t0sH5woA9b6UUblaRfgofvIjVtn7Qgcj
+rFRVJ0h2JUhsA48FBBQVjAlpud6xm5+faRt7ET+bpG5Y33VJkojE8bVdgqv
cFIRwwN8soN/feHgH5BifrSkcaCa9cc2wuigXDzpPC+bsXYyZX6afmq3Ljzz
exNgrsqky5b+Gi0xlWa+bkPj/uBmacuLUndRXoN0YGI+trG6jDpfVM83gNTq
1NlPL1dVTy7ArwSUtQxzmdF378BOmoJZorp+dFPFui2BQK4yvMAQCMdA7UTh
aE5sQITyiMeHT+bsAxvJIOgrDnNV+tqB+CqRivLTrNanhihODVG0M96WeHbs
HMSaEI7uve3kS2/ILdEyu9HExii37AaU2IlW37S0h2gThOhQWJhFDOGXDHFN
YQ6d8muarjIQxINxuFdNFBK6zvzeQh6XLV4oc7OUTJCudJA5nnPjInqhISI3
RmubLf40lAm7gwniGHASkrfTRWm0NDGfQcEE+og06JsLrhQDxvG+KP5oFxjn
e4N9KfY4uB+0h99FE43qQcflgPzamjwVILLN7sGZuX6D2eT6AW+uGYbn/sUe
sTph/aztY1nP4sAGcazftSGxHGX3zdIKnS1jLxectuF/t1TTGO0Vxmg5bdr2
0hgX8Zlu2qaB0CsNDIeeo1vwx2Cyrt7oxCq+CqcUUw9kKz+0UU/T3oqzGDj6
Y+hQvMQYeBvoLN52MSc///e3IJWbtoD9iMt3s1Qooi28L9bplfRXM+9fzDSN
Ii3TXR1kph3zbmmpeu+8xJBha1+aflQLbGdpgmr47aKkuiimpBLovwtJJRmR
wy5NJ6fsU1Jq6hjdqkI19WrwL4s/RCbSUwyhiMNgvjcM5soNwMEZ6Po9Zf7j
mjrmp+DuAwkt1+ltbr1oyM3RWGc0Rj2B9NvasxCfXvwu2V8hmKQnXRRMF8mj
i4LJdP5eNgiHWQdygPZ+dLghz3bBIOvQWMNvuULx/09tSBokiZfPNA1L+zOk
qygFgEca2iCB9Ts2CR7D2ydfH/5854bo1IpBlkyWC/IWKJtmzYAWQDzR+v4Q
nqmVL4pXTLAbxkLFYcxdHDJlR9+xSaMcXokhD4xhatcvjfKajRXgMXndYgTi
GgBxhCQTHOEvzzYQctHNxe9EJafRLtNI0wjAIMQRBzFkFAcbgdzQcXUaravp
RfcHifo0mz47I3rkj/qVxqjbmbpePsHFbw1P/+30irT9tk0HQli/PSr0lZvE
9TSZ6DEMokhqfyhjoOgmxLF7ZDPGYfTehTwnlC04/fRGCgOaqcKr0K4pxFp7
iEtu/yYqLww7TXsadmSlt2/i2JOCD6/kD1D65KbCTyoobRi4++3G7hxYZ0wY
L3v86MwM4yHH8i2D/N+6EZNYD4kNN41L+n/v3ggPp9CZOLceKWUCmsDU1t5k
FNzJUdNn0I0YXm1AXHoj6z+LA/5mGvCbN0kSaXA4v0DcPQgDBCFcmGEuDUkA
cQ1GnkThspeDtXaPkx+WDWL7TDH99BNrH3/dkAXzf0T4N4ZBbOCVBDOIpIt4
J5aOyv6dZMgAIleiVL7P3k7SbgkR9nr8qFpLAxWyvROPJVZiiigIvIjp7WDF
7DVKIkBHyG6DUU4C+cZW4mSVcJI4AOkvjRQtgOMCxpAJyA/0bQiXokxOIRY0
43Br7K4Bn6A/7kIjJZknCMkALgZD/jUc5fAzimX9xsQVb4oi2WyBSZZJd9Ac
kEyCMIt9MovJ83lnOj1agtOb/F42S+NvPjKKlsUo8AKKYm4/+3jBHKRxfxGZ
7U8oHh3GH+UQmeAbyWeJOvPN9AqdIY1BEgQqlgb6gOgcnH4/DeSmjH1zqHVf
9xg82gUH+d4NGzMr/XjhKtCdvzpM2iCSOMo/Rb78+pYUJiRQLFAMUUkG05JE
oMQwKAmC4nRQmSiALv5PN/nBGB7G2cBygi2xdhYZ37CxMtOwQjEHB6df4gkb
rvKVrZDO8P9fbklCgBXWF6DVZYLHYHRBPt/d4qHJgzqNQjpNWBnEIm+TcgyR
PEbVos24LDi3TFdkWwaZmBxDwoG1tJA2oITgl7dJLvHsr26jXJJsOiGh069t
WxKK6IkSohfKIPpep8k2n36vEE5WpCSgH9ie4nnUfmV+XTZum18RoHrwXBki
tMgHRfii+IPqE1/K2PzyFl4SZ10UYhelSK72JlvxDgQ5cFHUtEGQp4M6niZ3
Pf6/iGKEKw/QS3iD2Y5aeBpt+WkM0Cfba7f9Pt79o6obQOmlVZJn5+TAEJ+F
QGy7ekEWX7zG54fjvzC8vphe0wQaJ2fA5enXYXCD+Y/yBEcgjmbwAU4Hxj9N
jD9ItY8CpQmLAUAhQ8tEWQa+3WGyFOKohWWR2ATgkfwReM/Nujuc8rn49J9P
Z7P8gPXo7K8k4YWK9pLwvpY++HrO/wxCPB08qvRKwjxNIQiCEoEJYIjAPP2u
AGdKI4wKleObNiWKbDbmnm/cFAUlhWzrXgtDslZLIAv3WexUDc7z/xhO+yyO
8MZtEne8GqH1C0lAX9z2Eq8g7ijsRRL2Sgo7oTUKFx74G8np22wJqFnO6UpA
AslFi/KNHivKmcUsrEwWnxtL+Ri3aVauocLE342c7eWOFTcNoUTfievVxAAb
zkA7dZ6BP+YlhKefiUO+IV2UJyWMzkpkjzwzBYH0PCXJVYzzgbPIOpBUgOzK
t+Pp30lnEvLJ+jPqLXG08wUOWcvMXy3/PudnLLtm2YSeHuWGOhi3qBpn5KlM
1TFHNZzz6fRKQVwxJ8N80GGf20peB25anGVGNlt6ETgEKcVX4XHg1Eiflaan
te1A4sBGeu9cOY3ok9Vzk9OFer4KPVxr3YiDuqHID1jfGfsYmJYUIC8RmJ/M
cvq/W5qjhTc9XbYbXVKXBRiOL+VXcgrjSV/Bifpq+qsxSxkeRGIpI6FnhfzA
CbMCz+n4elanETl+ladX85VpUNpdvTQt8T1rxw6ck7Qh04rw+bHhOh/H1yci
zHmWPlXOUgTbDVuYJJyoYYrg0M8lWZ19rrJEwfKQVgUkOPKQQp8te5w0im9w
2th551kTDQ1jlic2LCK5iXrJQs4MqczwE7uU2m3Ep5/d0Ofc1/r5TZ4Z2K4P
9v/M35L9keE6f55n+KNbf7aiPuUZ+/SWKa+LMxUPKOfKdcfkPMU4C++dYnQR
Y8F1vr5F92CRSC+9By7C6ERRIIo6Jm2SGx25Tm2ADrHagFu+gCgK4UCoSHrj
5oineJWPENOZL3zBUC7YXzTcItuhy7OaDeP9cBzh9UlUOK04td34zMZZTXdv
zSzO7qyZTdEz5SklW6Zp7ZLi9Tyv30r3y/EezmkOU+jQGDKnqiz51m6LmPs9
sqyOVPasjBcrJs9f5x2nSJZ6JZQnA8/w2U3V+TL89UiY3VumH/jEf7qNr3AZ
uYG/XewkMYz/A0lU1+HsfXA4/EPbS4eFgwILWds/r71NGwloDWJehSOBFHXV
YPjWPDD8YJvzcELa2XVBV8ZFhAKD62WqNuP4+8lWLEAyvZzC3mY1H1i96Gmh
DyokoKH8ky2g4Y1RTm9KMvmz4c83wwsu8db09tuGt96OryujqN6Rh/uu4a13
JyG9JxHbe4e/r8LX+7LCXh1vcU067P3DB9em1wSwHRRgG3AGxw0/B7TF8z+e
ciyf2Eaw8YsdNRzGZ8DRyG5APJWjThtx6E2T8SfmoeP/MmEuQO6pz9Hn6TfI
uV4W4SdCsPLcVuRL8+smUqsCfBFUVm3svEE9tt9sUUp0Bcr3LNqSoCPGyii7
UX9xi+1UoKW5leaiNyZ5vSnJS8Dv9C0ZPLMw2EUIxl/nAjCCL12tAOBhC4AR
fp3FdVOBF0GXrkfAS+m5Hn04ojpMG9NQqiiBqY5ySgFyHJzsFIA78ACHlBca
9Sj2cqSzj+jh5Q838po2snTibdn2IcHGDNuiPrlYoTZ4jxgDWS9BFt97Sz7u
rdsIsvje25NaXrmNGOPXO0kt3x0lSUhbZqQh2iLWQgJbF7EW7xjR9oH0ih9c
l95jtMX3CG69hBtaVnw8gFsQeFsWeEPMxQNaoFtI0AHXoR7HmAf4rkxoZraj
hKbGG6QLBOYYbZ00rTPre0V2TDIUWz92olbUT1hiL/GbBaiCwsQJZmrCSuDA
d6aEH5FIe+M2YQyQtmKkvSXTWURZl2DWE5MlIuvS/wsCWcSYwtlBgbMBY4S1
RGsAtUMJNXiVxHYpkLbQ4fUi4oz2D6sdtxxE0+2+ZkIrXpcTHgiKClrdGWqm
tXNWmcGi5XBAD75opYp03CiuXmRI8hUkiOk5rMjCKrmO4uy4wllkMsFopckE
jEWTiTgDz+2QPTcbYmMIG9CFQv1wusn1WwkwwlfEVrpoia9Dxhdh7DN44PCT
YgVkMZgSmf8kqMX/0WNTLLZIDJbh9vUI0tS8IFw0KGVBfMBsVhJZCCLw3zEu
tOK9hUdHZpi/LCiOkGc7bjWyZQxKz3TOQN7DHOS9cb/IW2jkJW+NnMhrtuCw
gdMWpVg4bJcWdURiZcL9i2cA3EKXpDpMN6Ujv5PwFjqvGK2igVYXnUxhAARO
mKjCqkFgbXjqxAScUbDdkbiAZe4JX7jHz4+mHyvJbPACbCUXDYIAhEQZCBSm
M0UC76L5KcF11URwLQtwIcDAR3MQ1qVgFOcQQlGoG3QRYPGyn2KFpip5lQbL
Cc6FTIPh0UU0WtRAF0WG0/XORDEn1xM4DNAVg84LAPoSW21XPYjl6WA4raxG
axE+nVp6bOfmAezWMufB4OpSBLDIvIXcBd7ZUnpn5P7Hz96Vr/SeLb10yIkB
wNX5UMZYBTHmsBpiALNek9gnEF2EJMypiaJ6glWjqB4WuXULe0A6t0upgS/l
oqUKLhpnyq19b5tr6hgAUF9Sb0DsWJDWaQUKtxgoU6nBLqhzVqRDL42ghQA6
r2OKEMTjqGRaAaxeAisK7c/S4MgqvnWbUxgFe9VWMfr8mbh6aRXjXwlNkbEy
oghNhxWaBhzBYcPPAU1dhFI8GzMY+BL1zV7696GXxc10HcCTLm42sbQoUhdW
p1ZuBKjhFHK+7dtbbIdJZ3C6NliYcn1qUZ3h5JTwnwQ+BHBK/8tdklwZvQJ0
6j3hxZX1OLkQ1oo7izqRIjrccjDtuw8V0gNNaxJ4oYk8xx8T4LtWgK+XISas
CBhuvn6D6C2hssBgGdf/PXX7VohbiEhSAM7CGxjDJQOODSKElQJnS40zLgdE
2ZZmkVAGWbKFzpKxcbRQprZENl2l0vcOXCjnHAXvUSbAGT8/YOoy4gNlKQ8E
l5FnJlIj9EIpVGOxGojg29fxW2OWzHjs/4dboPAsr+scgVIQVCYpMHfxVOlP
dclbP0iwSYfVuf2SqGTj0u7AEZ2P1P0IGX0YnNGxR0kJkiKYPO2621+0UaYy
1RL/GzduFdCNI629fqzjOg9PDNBliSKdYJMokg7hCHZWJXYYP700kuzeJ+++
S95Xn7kqYiy3sb1e1y8zWZHfBU9Yxo0ARHC5cFY+sn8cVrEjpVw5dkyHWj2k
NCPZXQf64kzFQlhHsoyIQBt9ZV0mMcbVG0FdVgJBb1yQxazwQ9xTdQKVRLWq
8IN/CwO8kH6ZxZcM9OrQPvttCoQPAhDerkFgstqZPr+SERjLDiK+RBBu1/9l
A0EA0F2cl9JeTodgpEGEoYZgvDkaUKp0ZiSaKITwEkcpKusxukyEGPFctjrV
WIzH/AUbovQZ1di9BkLsobFK7GAaK1D2mf4mNGMqm2nhlaPPes04J3BFGGmg
rUi2yWgC1ccE2AMlwBYaYCKLwaVMBJmguIMCXfGVjqnRtdTJC9SxvzKIIdGN
dKWKAgCK5KvSuS/CSwRWhSvdm9VxKXMhux4NJ024/XaWTFcs8VWZ18I6Wl7+
UUYOdloxaxLsEjFd3Oq0G6c3RCuQ9BKslsgTANvtZQAKQAstpFHRXPj96LEt
JdBy2NlZdfMG0GQaNl0vBpwqSSZghsFn1Vzrls3pUKYzYLNeshmMJXq2ZfxJ
QOtyEoMkV61kAX9uJVMYsvePUQa+suRIWgKBC/rpbStlJQF2svWTYRYQjw3u
Gn7nLAbWCCSwQwgiNHAbjKwY1EqCIAbvIAmPezc6XelMn+dKZ4lBCjzTMSpX
C/BbctvGB/BaqpiOYUWVRUMc7g+DS41B2b0Bks+ldG4fkiGG0b0RVDMq2dC+
7kPtUuIDH5iTH+x+qyyW2kSGnXmdo0UMHYG5Ldp8jlV0KqFVHNj8VhGR7Vhk
m265ptQy9EADYnXEIDIbyPdVcoNK6RiZZpy9bwuZtRWb0xJi+0AYJTzScdKQ
OhRX9EB+PqfcqxLApQQV4kHhybGUCwNhR+V7imjIzTsR1KQdrTKasO6fk3JV
eLLEs0XNqwo2ZPelBp7VWvSTAMY7SptrRA4tJL5LILGXSJSuXS+xiJYWnzJa
W65Nharq+RG67e5ABNMJV/lCUgwjTqAFo3QtLhg0gSjaIG1Prki3AbylJ2d7
X7vGp/pMPGqZz6wCEjK+vbpGacJpEyeFPRmTEHD5Dn3WNoU6/FakO0nUQbEd
ywqrAnWIPD9pokhQZngVCTIR+iS40sUquGoLfmLZB7QS5fwGL86B/B2hvgwp
kApXTIVf3WZXLxhhBQBR4xCxqHG4kuvpJRv2uSzaLnxWvltOwE6IU0uoWn6f
VQPrS8AfGKfJr6RQfBiq1hO6/1JdKLfoKYj+hAHRN0uIHuuafSqoIkylndYF
CISolVAZ4ElBSKZGGYRMRmZIsxmwm03HttPAuNBgJBAGSppUoceyWpsM80Rw
JKvPa5HTtWA9chBOmV1yIiqME9zK3B4JzBaRqMKx1dPBkDuUEHK6LBuug0Pp
KnZpQO/O8QeVw9+WULoT0HrXANtrFDCngnYXYNRYjoCk1+u2SVmtR8wwxDqv
h/KMGEPS5QgX0BZPwqCCABePTIFlLOyJ9tr486TgK8deHqv3oGcoBPGVraHq
Gtd7X7YxEgJnivO3FnC8UT6j0I8c4SZcSTiRZLmMenecZHNBQN0za6988udd
tWW7894327Ljx6KlkZQir6unhdvWZKMQBbtw+WdZqaykh6KzQkxifOe4nMgq
z+VYRDG5OWlLBxwbsx9kHLJoBJX3g0n+sfTjAA5565ZfRp08HaMc+M5bZyIN
1bWFoVIU0nEz9soDVZdQtbQoJd7tU3mQsWGRXjekzz6beFCtrat6/03zpctQ
GWIdr0dfFvXzdBS3Luam/2WOJqXLwTO5KlF2hD46nSBQWVbB2edRxosv2CuQ
4DUajf988YtVZBBK34tO0l/WiyCzSuj3kbhbaXIh3HVccsKr+lYLYTfiHvmo
640lAIvUuyF6Nnq9AICXN4HLJBntsxWjYXv2KNiqflnqtaY2xjG8dTlqXDT8
nYWCzNppeF0JKnGcd/FeCGNrCHhVgG/NrBZIA74OBbtuPBtSaxnLGlB5F+m8
AyJNXyr7UxqVq7JriNcO6PIB5m1z61A6rLUIqpdLUwCTGEpOWzUQkVOzYM5v
pMOd/IaGJr561WG7rFqJUDkyNINd2dRhmbCaZrJDJR7aiTkCi/wyI5FbY3Vg
+y7K85J53acHsFXtAuoJLQ0y1zvoljfC6L0lRmdabJn8XVWrkxGnYxil9rYq
4QYQ7cQCeIHSvYF0QY3g1b4koluX+NJtrxzFarzg97Kx9mqjvTaFBRyqwoIu
ujuuW5+BqCpUynEMVlOJR90H9gha8agFv3sB/C5LP5Yl/AB6obbapre4mA68
ak2yrjpMWoAgghBEX4f53nQomG0oPPSY5VAZDoLHl3K7cFW0X79pw4wYB6P3
KQqL3MGLr+OSoqzMmc4+BQEeSWWBgtNFwW6CXiQ43GSbbLUrgsUJPGxZ4hri
oovO7+ilIAUp767aLOf1yQd6cYKkvNAbPeRUXUjHgasY3ysdRbEeoTO3/IDW
8RmAo6g3Hdpem5C3rLQcxKVuFCFkNoBnIeCghN6EHG7vgYm+jqWgpXXahaO0
6xJo7pYLk/NhQSRIJphkZYhbzXQClejnVGR4TwDm3TQZChvcyepDOgCMMFYf
GitNAZUClK2FMr2kQvQSFzlyQWT23vIGRYGQulsW1a70+ZfTY39lO9JPQpfj
DUBqgytcKmEs+wxFd+GdQovbq8lG1AxyI+64LMsH23ULw35KO+4uLA1VU4r+
Ns1SDjp9LM27VYa9xzgAe3u5addaEShWasmkzdHY2hrVTDcNgckI5zSK6/ed
AY5L3oZObznrrk3QTBYc66cXg9Y9vSdbqy1EOYgKrY5DpnPHwX14h6TpG0kV
F1vKVoVXzNSttRGXAyLvHn8cpyc4KFo4RYOwMMQ24LpUal21V3L10hQPxgat
JoQTtIamywtoRCZGpf3SlXkZRN/eVLcT+WWaCrfYKELPiRtvLAQbFhdQ4STj
xkr0FAQrCUwQkvXVS5yDVLbxwHrenOi27C+DR6a0a9zcHXAD8KlWB3aqTy4+
wAXC9++ytM8TjUQ4iKVWaChd6ycbPnbGit2922duWGhVo6d2a5f2kpcp2f92
CGltNNSOHhUO2kX8ijDqQ9ztACmlgY4X9VhSKID0cg8ZClieVrZ0qs+jWsnX
y5V88a8izyEbi9IxeiXyslzR94cb8v7zUndMctQV9XQ9Wp7lQ83aw9jw//O6
LCtJsS6aHK19qsr0rcU0570LsNciZnudS+1OO1ojAyYiVzzYTl9b1CI2/RSP
kg90Wz2D7eDfVcJtlJXArYdBOAthuJyOh7Xhdr2C21EBt8kLE84Atc7c3Lfk
HHSFhXGw+61l8r02b4piVM+kRSe6vOXXJQhO7uZXCrp+JmOcNJtfG18dV7YR
kwCCXAaEILynwXng3B/qtcvay+rtRVjCyTqsVqOK9TF64wUqPHSyhRLwF9/D
vFpnrIxpAZDyuOlqsq2jgzXMJTmsaasVHVAJMepUwmiJQPAI7yokUC78H+2w
Ty3fy9uJk+ItbXAG9MQW5ViC0aYk2O1AUnShjOuiy82qCwc78wu12vDjEoZX
CtMbT1KrAtMx740TeFVCAqY38p6AAZK969/ZmMle3HKGMhzr39+4GQ5sq+zk
+gWV5wU8LmXeDY6jfc/jRWmvmS9tIc/biZ4TBCaBkibGZbB6nyArkaWsYzpp
of3lesKt70HXiLSSYeJW4VCwcMsn47Ee2g89lwbjeydKDq4Da+0XZ2WJoSKG
BYol47PasmaVA1LEp0uT1zJNSljKhYQLTZQ684Ho7OyVNTYy9Y78U5AJ9Mok
ac0DswXNans3SF2ot/2ww+Yd2HprLcgMeChuE4LRbiBNs9VBZUUnagC+oXUr
skvPK7yTRNpCIw1CkKW1eDUAEy4kE+q9UdPVmsu5ermkMHRmh/knlXUu4t2V
7rpzd57PCwhLnDmlJycWlVhY8yoVdRTPq3DNJaux99ioS6ztSgbA/FDzljaM
vPrA6qbStjLIeKbO++H1zVzKmnoaqlw3iZgXeiDaoAiG0bHaibdcvrrQvNa1
V65a8UeJMcv56114VS1QB6hICU0UZEid5tZXql4qXWUjZZkV0TlbirjKpev8
RWmc1kXGVxqs0aRIPtXJ3GqSCeo9uiETVu3v2cmW1oY2VqINlklDq9MhHUW2
UC93jnGBvRaQMNNZ5XjETWUKpZO21EtfEnaIc8vmb/Ftfa5EzGYLBNqhkOVa
tu+qLMDwGWOJyUR5/U6cWZq/0PD69PYNIdQ9RfnhdGBSPbFbJVUJHCEW/Nnu
SrLWP+fshvAiEVD3kXFB4W/10t8KlxPmRIYeeSIs5OIStkGmgIS2OPqlfFfX
SS0I34aUeQExRc7zWV06VidRkM5MO550vRUxiioz026RtPw9dwtei1JuIxGw
Ki0UW6duhzXH18WzPpggxKmJ0KnGSDRldn6CcrGZaSgXK+2UbMNg+AkzJTXa
Zni90KI62VEvm9Vba9QUrkeaFTnIm9Am3i4EKii0wNYzW1bVRhUX6yC6pCk6
YCRbxhszIBjvK51zBmJnIrEuCOgFT4hGa28PgUILhLrkjQTq4k8KxnAS4uly
U4IaWG53qu1wFocUQb4ClLvrXr2NRmkKC999zNIUzCwadWmuT+hRYZgHWhcl
9HXsqaJGWUW19qMLtB0zgmk6s+2IpyPdzwiHlbVMBFS1oKpD/8n4er9QTLrc
+tqleWYNS+lVObraxpMPXldLnqyUUNH4oNhiRsqp+ioMeoRgL0DXLT1BRGyW
ibU0xo0kVI3egvxiSwY1nQ9fR4VLslrM1UukBRHdrQoLmq1o4aUfVGuBxQqr
eLGPJ3B9YiuXV3Upt48K8plsRIsCUwhjtT0n9b4oxTWWzKknR6/HLUNKdT0F
jfY0WV+uoq630M+3rupU1nuW6Zu1N6Wsrp4oYLcjRiGp3MWD9699uwsASlgM
utSgFFkH7q9d/1ba13Z88bBI73f6+6U+utXLSXPoCB7dUi6+Ekv9Qms/gvrr
5TIiJ8TbNQsRZipOLaxzRaziNm5lqJ7r8eUvLkupSNJZZeN6Dq5yNtwBcjiF
P3ciRiiU2S4WWzaZ3lt/aUMgDecBoPeXrKnXY/VybXtw7TKlXDM4Vcq1LD5Z
i7AWMrcPqf3Q6O9ZaJTUJNX+UgGbb+milu+oA1Z7Zbi5rgVkV04pvhqW3XlK
cx9LMbg24YkTZIbGeJI1r7DNUUR5jSJk4ar7zQFXaaOjDlVXp/TNtac+6U1c
wGIia6W/To9ko4p4VoLDcs2oE9QKZd3ZtBxCK1oopsVaE2DlzKw1o2KZiLsO
WlUKi7J2hZX289OVa0RVVy1Mbo7K9bM5ab3azCLaHhB/XEAaLb5cqoRP6A1a
ktFnOu4TCWGfpIdnWoAnE9tVyMk5Z8wNMdiJEJyVXkt/Wts7Wg0/I180VibX
j4yDtb+UJ7fny5fbjtLFaWn9iZoyPNbqOsPRSC9vIWVUaU8dPlS766YL3EpM
PRkwvVjzwFtQnNz+2xqKb3U/aU98pK5RUIVFLoIT6rY7iSayGiqjYDXwudKz
st9KpQsmcTNW7jIPmcETTJBucCjvVWPQQFnNNG49QAUY1mI/bcrjZRE4sPVo
L4FTueRVpz1bKKu7IYwvKxICkqakmBlnzO53h6gxM8FgtJxtQZkkGAQAj3BU
vC0QUUSGU3blVKgrqahdcLESV0ROMm9Sao38uXb23bOpzNoawVAXFJSV/ZJZ
bdFzjfB6oAsvZ5cD59sRy/WU5pdaY8xH8FpTt4fCRaPcUgqlkYzvMqKqrlWJ
oTxJKopq75vSng0xFHcHbZ5/n1llZHAiT9bcJh0uKUfVdmMHGYYD1A4oShyR
N33LMTDN4Kpj6zvp5BI0QtMUU+d9E0w5jQbTicM5f+AC0l1tqoTLLpIFC0sb
+tJ+1k2Hcleytp1t55qkqzfC+iojolC0wDkwBC91RXL3uvziHr2LVSNx9aBZ
iMPjiq9APCrhVn5RT64/TlsZ3zIZpUWqlVOixspch1D3uzBlXqzWgagcg67/
zIq3ZiWIsHwV7C/H1P2K62KLLKtCzX+i9pzmg2tYYLoIvoYHu6nsiL5NQisP
FZb4LffCLfO7IHJCTOxVzEjx9vKg384b5kGtFHMfgRYZ0uTQXZoRWl9OV9Go
0yBYcR2FXJVhdFVPJQDUoUWhz9pt+BxAJX2fHG2KWnGE2bP+YaHXZuUjiCSD
P9+6X3DNqzyFcEogVOWv+g7VPBNMW0sptAsafA/GLSpKMijav9Wsqigv+/dl
NFv0RFmQH+20sfx6K6Gh8p1EL0f5NySVn0o/sExcE8o5b0JMgcFUXIzQI9UW
SfU5Kw3azUN6n4J1mdGVEp+yoMFClD09qmPX6q4SkOAFLdIslegs7002UiFW
hF81nzbJ2rJvMqEsmuKOdBoZviR1WULD+z5TCJtYKsd53lfC1An+kKKwMhut
Dcsk3uzK11pFoZbHp2sFa4p2LTPX2EZ+7X6LgRVZCUhbIpDXtxjErxqoObd3
/aj4uRZPAQWMgR6moWC4HGKRqGcn6qiMgM4itpspLOrXkYUiWN3o7Dh1IxcN
QdrEqjTBI6v91PmRijUTPn7bkbhT3lBuiVWx5OL6j8DsPzz9WJSzn1v0a4Jx
YD9hg00/5i0/cPcr50IiX7ndzCMTJPVQ7AJPGItOpkYUCr0WoiVZnEi0qeu5
zRmW2yCzTkUnRfoNvhY7PCL9QGzkZeH5XoURWhcrF+qtv6X82va+ZQtK5Kzl
4hcLgg1VtIRTcIjlcdinnWy1RyQfl/lnRJutjVjMrUvKyVZ+pxJ57WzxV6LD
17mGeLYd0mcDYUG6tZey5TnZilSL46QGbCl/J+OpOFo9xdpubGn3qKjRFa1S
1VXY5eB8RHpPSnULr+GQbfUsFMhI0sYpNAk9BE1dnX5yInTrixdua+h4FmWN
q3WdDBsp2uPZo0Ap7hDa2Wi3m86lGc40qk916zuBLYQcsxSMJNMAayPQEsOQ
syWKtenkVfyTk0mj/lq7/mbNc/rgDsJtK+x8dZ0+++kLKapKI5w29kLpUEaA
oRMeSdbiPptjBySSs3jGxSZEjfKINDrreo+oEOqURsbW2qotCfouFe0wz6Qm
7YvbbTPrUK9ToSNOEybV+smHKu2UG5i5nCXYEf46EA++LgsnpJATTJ6lwpZ7
xSVPBQyVqlAbGXrJc8MRGIsFiGX7+L9VmBbbflZtVXVJm+bRWsOfG/zSM+Fu
Ew/JWndoal0hCzbx2gDQyzNUfq8aQL1gLtc9Ujy1lvFWuwctyJxT5Yara9CE
9eVw24uf5QfFpKp+ptJ0lEUaof7pUZalrptfjhr/ugzm8kF5Ls+JuST1cuyy
K/bW16Nbbktwfaqe7XBj5/g2Ygq/rKSTtZE+Ke5AQ9NaJKdDzbDrl1pctNzm
AUoedtfzVF5bPWZOasDWo9CEokIf+V3N9JC2iMKYH+RucqlA1Er5Wg4zh7hF
k5OUxoSVMBYvqnyWFVepJg/dOCIoXKQiFtus/+JJ6rnShiBoN9dqpeLLECHz
6hTceY/7YVndl2Xcu2Ims9Vzwopl1yhXDhsdUm8PUYqooKrz6pAMzb48zslH
lFOzbqwo5xku5trMwzGAEzHnZ5cJUd12Ki3guiqK8hTBrk2wjEPFroqsl553
a0lUpxrszTGsFXjWHVgbl+y0lL4y/b42OguFzNUGSi2LTR9IVnSYRty8ShvJ
yat0s6BaeWW72B0mxConesrSB7hT/v0MX/dc1uQD1GzLOeJisvVU5/ADefPO
mrR2n+7Fwqux/GVrY2RrUtwLmCW1PGMKu1Zho9BUK3sRdBqxUMl6Y32BM3Fw
ZWuLHa4s/cRvzrpP1uTz+Uj2nlfKwQphzO9tF4rNmn3modbFlT/jTJdbarBL
xuW08uCcvrulvGSGumW1Oc+BAX3J9wJZni6XoW4NB6foyPxX50CslBOi4N4G
Cg4MPFjqZcVSxlqsddECaTFpGrJujQuFv+GyPj2aNX+hkeQtbJ3qkRQ0bWm7
LpeVClmFj/KqQha1P1gvIKQ7eHlDWFYOttlSdfaymbyt5JPqUKVld5YuuG62
BXW3IahwdxRrVgtvlXxIxj1AmyWlOIktDYHNdsvWdoSk9Gx9I20d0J494bkK
9dwWk4HfQn6PPG3LineDMLyup5X+WjqksC52G1WORpvKqxxrTasHjbvWJb5K
ZZXraaGjFqBVipjQ/bOWkaobKPEF1UMVX0SvYldYcgNbz6uP2Pyed9eh1t+o
KqgkRBd7LWMJhyFVFKgUhMhKttPaLlbIPr8ig+IhxjoJasUoNEbe0q2bCW5Q
uy6oZIhcRVXbjHUZztTBJjSTw/bI6Y0LmSXPGdawE++1hCCduOI3ORdM0Y6K
WAXAqks7s43ON9YTbMHE2WBdik7cQV6NmqldFWrsRXwRHRVZo3UYDrpsYWdW
niHlmxyUVo7nyjY6JQtYjnmVQTNzOxe3W7PKXnnN67G9l1XQjQkjkhVl9dRq
Sx5Db6gQ67GrkKFMapBYmMKgGxET6UYs6DqL7EqCssm4pHYH7SlqafVoW6xZ
KC99L8tdmbGNlZxhK1Mn24eLSaunQ/WK8MTj8lJBf2SQGt1mrN/qaWnqWNeg
jwzKWxO8RwGBQJqoYFHFnCT3Ht0FqVdEagx3lzNGLUWSKBfUeKqqbjEWs2OQ
5qU8LRhZS+Qkc1sfrI1KZD1j0CAABWVly/i3C4YespbWpfBz7PJq3ypIDxBL
5uy4re0KtfTGSsbMaKeytBIm8qXDDVUDRyHv4nGqT1uVkcYM0ENbzf04F7c3
2PFAqwFdh6emK5Npyno1DFdpPdbUIVLFMmt7dY02eoa/viwp1r7K2vlCmBAq
q6I+HalrrCln46qDVfZl4nkUTMtts4pY7rfr3SnfrxuZkVDmjVq7KJ1UZypt
syoUXJtXjmDtckj5qY0VlDtcXcqdo3LcEP0W2FC+bN29KecN6gJVp/tjYMJu
XU7YBHukDmaWdIMQM8zkJA0RQ6apduOT4dbZO5MFTvSub9wUj6Ik59xY8TOd
pKEXhPeuO/yyDJTnzaktf2tMaf2J/XDWfsSYtZnJjLXMb2HYy0ARQjo2p7Uw
plYF22vlE6aquIa1creYHFncYNtUG56+FLIsLxZKKZwKhIjTtMSi+xmQ/i3H
PTcrIcHasxifKsvBcfwkt6HpnLC+a5nYdoSmTrdWBrClcpsNik0/xLmldaoy
kWJAKksovFAWdxQUC/lxMDE3n+OgKalbPeA8Y734rRj8hE5NTd3SZNhL/9Yy
ilQuhlNhM5Zt09NVyZvMfHlq6A3qehWgNoj+CSDtC5fCBbNdhML5JY4ti5kW
F7FAggxEVAlzBTMa7NSEuvJKTEk9zw2voHB70Ws+Le4G7Fsaa3ylM38OxH5u
tovVG9LtjOOEI1xlAA9tLrEahA/yCNXsGaXr7FTZ+4XUhtNKDji1O7Yaar6U
g8TiOczQfDLI+tiAuFsWsKo+LFJWn4Uxbe5FuzgRVQWmQO1KUAC78gWb2Dv3
lFg92W51+7DKl9HmLOIq6XVChr5oyFO9z1Jd1rjY3wE6uyRPg2k4bEKe54+5
/rxx+eTTW86OkLdfNNArWQp4F4kS0pygEyV2vkJwVkni1qdsN5R61doj07z5
kFVhkYX/I50j0pBVhrHsCCRXFOfmoKkiPJVW+MjHTfCIlLtbpVbEoI4l5ehc
Xka9NJ14ol7GUhHSWpamhVN8ccvfUSnaiAM6gwr6oXaZ1ykj55AAj/UZWiGO
PHH1GeXWRFjWQNlkvgpyKK1K0v7j2kmGHCkvuzIZbVaX+Xea20LfavdS9wNJ
a8ACYJZg5vh5wfd9CUiLSgoQumBtpzuOjcfAuSFxK/jJ/paaagpYqy3YVDJE
VsrFDQ5LnpbZ3PWN3hexnUifiIV8lMf5i8JbXJQ6vDJE4KYhDg1ZHxnStPwe
Sk2IZvmaQpkpQ64Bh6o/gf03aUCZdNeye1NtadOVT/pskMwtsjIflwf1pTxU
TGOJomJa9HPEueybpPcW2W4LjGTo1Y6T9GzNdkwJRWMFVCA4SYSuY6tADQo3
3HsuCO5WWXCrcnht7+zIO+TYEPUsZ+3ApopDA1UriaAqVjkSwq/lcmw8E8vv
+SCcH83CsQjfio/PlzfwZVXKwAKjdUtl7JSq9VkRTSSUIWkYa4NOH5yCIG6T
BXGuPaxQyMASvCUh02iXElqUv7mKa6LJm2ZrLtUFXggCuF02ajySC8Z1LNpq
y4O55KiUR+1YT8VLWxqVy0POKA71jgboLxhDsLwcSxDWzhBH5adqCo49kSzK
9ywnhD+9AoZz5zycC97DKTTqWOV0u9XEYZnLajrqi6qndolBzZMSxUthYHfB
oEGG4Yc7PKbJMjZqjo3fDgxpuQzbtuWWFBRGceyXNa1W1xwxI8lSf8u3dO2H
KYrSdBUHLIzfXgEjupuhdVYgbbHfhDlUTuUE1tKVjFPhslvawHdw2OuVMNDL
80DPl2dMsJBTkDOO2MIk0tCCplilsJYNSW+9GoZ1zzysw1LAjCXrElNJnjTL
ItN2fmDZlIWba+aL/goM8F7ZAlqpULX6gj91n/Uoq2Gb0KeqoWXR8NHvkx9d
RZNVkqqlQsqFYdC70LAEsDCGwyRvdXr+GgzifgbALMOrZOi63W18T0ijWMGA
C6fXwiDunwcxIfxSV2TATICvpXCtL9Wpxi7e8xjldTCmB6AdDsE1/pa/Ufd7
ztRaZfrVTPTGb4yzvw2PfpIVQyV1LUyFssrSGc9laajlwRwY7/1deKQH50da
GKJqWzVltl2rpt4bcchCccjfh8d8aAbyrJjOorVdbddEwFsH/0MYxMMN5Coz
7t5qR772+zJPycsW78Wb4rM+wvP4FIxcIFSGtDiN3T6+PM/EP4ZneKTho1km
0FJe18O3Ju7QeAa+pbWaCp/w0Vl7LI60iIZvtcgimIBSy+3mS/06PM1jvTmz
7Id6ahGQV06aywd80j+DJ/jZ5oxZFDBBLy0P2s0f/At4kMfnB3G9bndi2ok0
6UZqP70d7+OjPTE/mhXRK4qt/VWreMLUbdXn+ZL/Cp7gSfkJ2lV2ZRGs51Nq
/W/gBk8xHEA3RXpmF4mv/O/g9k8rJdx7T+umEY6aD5L++g241dMNUdqZjXqu
3Fgu/fabcINnGgzDNU7XUvDT8P14VP8erv0LHhJN96ex2ex/hOs9qymMKVnh
UvH/M1z2OWcVAf/2erji85tEyR0VDJ/fghNP0w+7rtbWIBbWb8OlfmmOjjAs
fgfOfrExdQxxy2LhiS8x5sjyYvnJfw9OfFl+Xq1AFUX9VzjjFYaU+dz/Bge9
0rAYfNAb4KBX54P4oz+Aj16TP2La/kP46G/kjxRG/gg+h0CvlBJ+lP64/Ie/
//D3H/7+w99/+Pu+fg83+387fXI7\
\>"]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Nun mit PP3D anstelle von Plot3D", "Subsubsection",
 CellChangeTimes->{{3.405586654720103*^9, 3.405586683591454*^9}, {
  3.40559101599792*^9, 3.405591037790376*^9}, {3.405594847793744*^9, 
  3.405594849454197*^9}}],

Cell[TextData[{
 Cell[BoxData[
  TagBox[
   ButtonBox[
    PaneSelectorBox[{False->
     FrameBox["\<\"PP3D\"\>",
      StripOnInput->False], True->
     StyleBox[
      FrameBox["\<\"PP3D\"\>",
       StripOnInput->False], "HyperlinkActive"]}, Dynamic[
      CurrentValue["MouseOver"]],
     BaselinePosition->Baseline,
     FrameMargins->0,
     ImageSize->Automatic],
    BaseStyle->"Hyperlink",
    ButtonData->{"./PP3D.m", None},
    ButtonNote->"./PP3D.m"],
   Annotation[#, "./PP3D.m", "Hyperlink"]& ]],
  CellChangeTimes->{3.405597607701579*^9}],
 " ist eine vereinfachte modifierte Version von ParametricPlot3D\ndie nur \
Graphics3D-Primitive zurueckliefert."
}], "Text",
 CellChangeTimes->{{3.405597389065807*^9, 3.405597440326425*^9}, {
  3.405597491289965*^9, 3.405597531246064*^9}, {3.405597611620334*^9, 
  3.405597617521141*^9}}],

Cell[BoxData[
 RowBox[{"<<", "\"\<PP3D.m\>\""}]], "Input",
 InitializationCell->True,
 CellChangeTimes->{{3.405572850897538*^9, 3.405572867164323*^9}, {
  3.405573081342141*^9, 3.405573098472218*^9}, {3.405596682723608*^9, 
  3.405596684207923*^9}}],

Cell["Die 3 in P inkludierten ParametricPlot3D von vorher sind nun", "Text",
 CellChangeTimes->{{3.405597650599529*^9, 3.405597670814306*^9}}],

Cell[BoxData[{
 RowBox[{"P0", ":=", 
  RowBox[{"PP3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", "z0"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "x0", ",", "x1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "y0", ",", "y1"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"P1", ":=", 
  RowBox[{"PP3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", 
      RowBox[{"f", "[", 
       RowBox[{"x", ",", "y"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "x0", ",", "x1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "y0", ",", "y1"}], "}"}]}], 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"P2", "[", 
   RowBox[{"u_", ",", "v_"}], "]"}], ":=", 
  RowBox[{"PP3D", "[", 
   RowBox[{
    RowBox[{"{", 
     RowBox[{"x", ",", "y", ",", 
      RowBox[{"t", "[", 
       RowBox[{"x", ",", "y", ",", "u", ",", "v"}], "]"}]}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"x", ",", "x0", ",", "x1"}], "}"}], ",", 
    RowBox[{"{", 
     RowBox[{"y", ",", "y0", ",", "y1"}], "}"}]}], "]"}]}]}], "Input"],

Cell["Die Graphik G ist ganz analog", "Text",
 CellChangeTimes->{{3.405597685130595*^9, 3.405597692989721*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"G2", "[", 
   RowBox[{"u_", ",", "v_"}], "]"}], ":=", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"G0", "[", 
      RowBox[{"u", ",", "v"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"FaceForm", "[", 
      RowBox[{
       RowBox[{"RGBColor", "[", 
        RowBox[{"0", ",", "1", ",", "1"}], "]"}], ",", 
       RowBox[{"RGBColor", "[", 
        RowBox[{"0", ",", "0.6", ",", "0.6"}], "]"}]}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"P0", "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{"P1", "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{
      RowBox[{"P2", "[", 
       RowBox[{"u", ",", "v"}], "]"}], "[", 
      RowBox[{"[", "1", "]"}], "]"}]}], "\[IndentingNewLine]", "}"}], 
   "\[IndentingNewLine]", "]"}]}]], "Input",
 CellChangeTimes->{{3.405498604890969*^9, 3.405498695972356*^9}, {
   3.405498792719001*^9, 3.405498793034434*^9}, {3.405499099930385*^9, 
   3.405499100284575*^9}, {3.4054991569661*^9, 3.405499181183708*^9}, {
   3.405499347350066*^9, 3.405499366074372*^9}, {3.405499401479907*^9, 
   3.405499406244736*^9}, {3.405499471731608*^9, 3.405499695242928*^9}, {
   3.405504319885591*^9, 3.405504356842648*^9}, {3.405505715073465*^9, 
   3.405505794697797*^9}, {3.405505873437312*^9, 3.40550588679118*^9}, {
   3.40550593178545*^9, 3.405505943284107*^9}, {3.405505978555648*^9, 
   3.405505984820617*^9}, {3.405506017196908*^9, 3.405506030600681*^9}, {
   3.405507235340171*^9, 3.405507241596611*^9}, {3.405507344370604*^9, 
   3.405507422800484*^9}, 3.405507502999704*^9, {3.405507539276124*^9, 
   3.405507544609541*^9}, {3.405507644215842*^9, 3.405507650497184*^9}, {
   3.405507777037932*^9, 3.405507794473119*^9}, {3.405507933982372*^9, 
   3.405507947704964*^9}, {3.405508053781588*^9, 3.405508071948854*^9}, {
   3.405508139903117*^9, 3.405508233394553*^9}, {3.405508310667622*^9, 
   3.405508311268742*^9}, {3.405508343129685*^9, 3.405508344251137*^9}, {
   3.405509148175962*^9, 3.405509190095764*^9}, 3.405586712005079*^9, {
   3.405587266473454*^9, 3.405587277985729*^9}, {3.405587380177365*^9, 
   3.405587382044941*^9}, {3.405588993475648*^9, 3.405589003631759*^9}, {
   3.405589145027233*^9, 3.40558917240791*^9}, {3.405589430443606*^9, 
   3.405589433395753*^9}, {3.405589784293696*^9, 3.405589808690634*^9}, 
   3.405607462155563*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"G2", "[", 
   RowBox[{"0.5", ",", "0.5"}], "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.405507507709027*^9, 3.405507514537611*^9}, 
   3.405591132617981*^9, 3.40560746551625*^9}],

Cell[BoxData[
 Graphics3DBox[{
   {RGBColor[1, 0, 0], PointSize[0.02], Point3DBox[{0.5, 0.5, -1.03}], 
    Point3DBox[{0.5, 0.5, -0.97}], Point3DBox[{0.5, 0.5, 0.905}], 
    Point3DBox[{0.5, 0.5, 0.845}], Point3DBox[{0.5, 0.5, 0.875}], 
    Line3DBox[{{0.5, 0.5, -1}, {0.5, 0.5, 0.875}}], 
    {GrayLevel[0]}}, 
   {FaceForm[RGBColor[0, 1, 1], RGBColor[0, 0.6, 0.6]], 
    {EdgeForm[GrayLevel[
     0.5]], {Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[-11, 13], -1}, {
         Rational[-11, 13], -1, -1}, {-1, -1, -1}, {-1, 
          Rational[-11, 
           13], -1}}, {{-0.8461538461538461, -0.8461538461538461, -1}, \
{-0.8461538461538461, -1, -1}, {-1, -1, -1}, {-1, -0.8461538461538461, -1}}]],
       Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[-9, 13], -1}, {
         Rational[-11, 13], Rational[-11, 13], -1}, {-1, 
          Rational[-11, 13], -1}, {-1, 
          Rational[-9, 
           13], -1}}, {{-0.8461538461538461, -0.6923076923076923, -1}, \
{-0.8461538461538461, -0.8461538461538461, -1}, {-1, -0.8461538461538461, \
-1}, {-1, -0.6923076923076923, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[-7, 13], -1}, {
         Rational[-11, 13], Rational[-9, 13], -1}, {-1, 
          Rational[-9, 13], -1}, {-1, 
          Rational[-7, 
           13], -1}}, {{-0.8461538461538461, -0.5384615384615384, -1}, \
{-0.8461538461538461, -0.6923076923076923, -1}, {-1, -0.6923076923076923, \
-1}, {-1, -0.5384615384615384, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[-5, 13], -1}, {
         Rational[-11, 13], Rational[-7, 13], -1}, {-1, 
          Rational[-7, 13], -1}, {-1, 
          Rational[-5, 
           13], -1}}, {{-0.8461538461538461, -0.38461538461538464`, -1}, \
{-0.8461538461538461, -0.5384615384615384, -1}, {-1, -0.5384615384615384, \
-1}, {-1, -0.38461538461538464`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[-3, 13], -1}, {
         Rational[-11, 13], Rational[-5, 13], -1}, {-1, 
          Rational[-5, 13], -1}, {-1, 
          Rational[-3, 
           13], -1}}, {{-0.8461538461538461, -0.23076923076923078`, -1}, \
{-0.8461538461538461, -0.38461538461538464`, -1}, {-1, -0.38461538461538464`, \
-1}, {-1, -0.23076923076923078`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[-1, 13], -1}, {
         Rational[-11, 13], Rational[-3, 13], -1}, {-1, 
          Rational[-3, 13], -1}, {-1, 
          Rational[-1, 
           13], -1}}, {{-0.8461538461538461, -0.07692307692307693, -1}, \
{-0.8461538461538461, -0.23076923076923078`, -1}, {-1, -0.23076923076923078`, \
-1}, {-1, -0.07692307692307693, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[1, 13], -1}, {
         Rational[-11, 13], Rational[-1, 13], -1}, {-1, 
          Rational[-1, 13], -1}, {-1, Rational[
          1, 13], -1}}, {{-0.8461538461538461, 
          0.07692307692307693, -1}, {-0.8461538461538461, \
-0.07692307692307693, -1}, {-1, -0.07692307692307693, -1}, {-1, 
          0.07692307692307693, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[3, 13], -1}, {
         Rational[-11, 13], Rational[1, 13], -1}, {-1, Rational[
          1, 13], -1}, {-1, Rational[3, 13], -1}}, {{-0.8461538461538461, 
          0.23076923076923078`, -1}, {-0.8461538461538461, 
          0.07692307692307693, -1}, {-1, 0.07692307692307693, -1}, {-1, 
          0.23076923076923078`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[5, 13], -1}, {
         Rational[-11, 13], Rational[3, 13], -1}, {-1, Rational[
          3, 13], -1}, {-1, Rational[5, 13], -1}}, {{-0.8461538461538461, 
          0.38461538461538464`, -1}, {-0.8461538461538461, 
          0.23076923076923078`, -1}, {-1, 0.23076923076923078`, -1}, {-1, 
          0.38461538461538464`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[7, 13], -1}, {
         Rational[-11, 13], Rational[5, 13], -1}, {-1, Rational[
          5, 13], -1}, {-1, Rational[7, 13], -1}}, {{-0.8461538461538461, 
          0.5384615384615384, -1}, {-0.8461538461538461, 
          0.38461538461538464`, -1}, {-1, 0.38461538461538464`, -1}, {-1, 
          0.5384615384615384, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[9, 13], -1}, {
         Rational[-11, 13], Rational[7, 13], -1}, {-1, Rational[
          7, 13], -1}, {-1, Rational[9, 13], -1}}, {{-0.8461538461538461, 
          0.6923076923076923, -1}, {-0.8461538461538461, 
          0.5384615384615384, -1}, {-1, 0.5384615384615384, -1}, {-1, 
          0.6923076923076923, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[11, 13], -1}, {
         Rational[-11, 13], Rational[9, 13], -1}, {-1, Rational[
          9, 13], -1}, {-1, Rational[11, 13], -1}}, {{-0.8461538461538461, 
          0.8461538461538461, -1}, {-0.8461538461538461, 
          0.6923076923076923, -1}, {-1, 0.6923076923076923, -1}, {-1, 
          0.8461538461538461, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], 1, -1}, {
         Rational[-11, 13], Rational[11, 13], -1}, {-1, Rational[
          11, 13], -1}, {-1, 
         1, -1}}, {{-0.8461538461538461, 1, -1}, {-0.8461538461538461, 
          0.8461538461538461, -1}, {-1, 0.8461538461538461, -1}, {-1, 
         1, -1}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[-11, 13], -1}, {
         Rational[-9, 13], -1, -1}, {Rational[-11, 13], -1, -1}, {
         Rational[-11, 13], 
          Rational[-11, 
           13], -1}}, {{-0.6923076923076923, -0.8461538461538461, -1}, \
{-0.6923076923076923, -1, -1}, {-0.8461538461538461, -1, -1}, \
{-0.8461538461538461, -0.8461538461538461, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[-9, 13], -1}, {
         Rational[-9, 13], Rational[-11, 13], -1}, {
         Rational[-11, 13], Rational[-11, 13], -1}, {
         Rational[-11, 13], 
          Rational[-9, 
           13], -1}}, {{-0.6923076923076923, -0.6923076923076923, -1}, \
{-0.6923076923076923, -0.8461538461538461, -1}, {-0.8461538461538461, \
-0.8461538461538461, -1}, {-0.8461538461538461, -0.6923076923076923, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[-7, 13], -1}, {
         Rational[-9, 13], Rational[-9, 13], -1}, {
         Rational[-11, 13], Rational[-9, 13], -1}, {
         Rational[-11, 13], 
          Rational[-7, 
           13], -1}}, {{-0.6923076923076923, -0.5384615384615384, -1}, \
{-0.6923076923076923, -0.6923076923076923, -1}, {-0.8461538461538461, \
-0.6923076923076923, -1}, {-0.8461538461538461, -0.5384615384615384, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[-5, 13], -1}, {
         Rational[-9, 13], Rational[-7, 13], -1}, {
         Rational[-11, 13], Rational[-7, 13], -1}, {
         Rational[-11, 13], 
          Rational[-5, 
           13], -1}}, {{-0.6923076923076923, -0.38461538461538464`, -1}, \
{-0.6923076923076923, -0.5384615384615384, -1}, {-0.8461538461538461, \
-0.5384615384615384, -1}, {-0.8461538461538461, -0.38461538461538464`, -1}}]],
       Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[-3, 13], -1}, {
         Rational[-9, 13], Rational[-5, 13], -1}, {
         Rational[-11, 13], Rational[-5, 13], -1}, {
         Rational[-11, 13], 
          Rational[-3, 
           13], -1}}, {{-0.6923076923076923, -0.23076923076923078`, -1}, \
{-0.6923076923076923, -0.38461538461538464`, -1}, {-0.8461538461538461, \
-0.38461538461538464`, -1}, {-0.8461538461538461, -0.23076923076923078`, \
-1}}]], Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[-1, 13], -1}, {
         Rational[-9, 13], Rational[-3, 13], -1}, {
         Rational[-11, 13], Rational[-3, 13], -1}, {
         Rational[-11, 13], 
          Rational[-1, 
           13], -1}}, {{-0.6923076923076923, -0.07692307692307693, -1}, \
{-0.6923076923076923, -0.23076923076923078`, -1}, {-0.8461538461538461, \
-0.23076923076923078`, -1}, {-0.8461538461538461, -0.07692307692307693, \
-1}}]], Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[1, 13], -1}, {
         Rational[-9, 13], Rational[-1, 13], -1}, {
         Rational[-11, 13], Rational[-1, 13], -1}, {
         Rational[-11, 13], Rational[1, 13], -1}}, {{-0.6923076923076923, 
          0.07692307692307693, -1}, {-0.6923076923076923, \
-0.07692307692307693, -1}, {-0.8461538461538461, -0.07692307692307693, -1}, \
{-0.8461538461538461, 0.07692307692307693, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[3, 13], -1}, {
         Rational[-9, 13], Rational[1, 13], -1}, {
         Rational[-11, 13], Rational[1, 13], -1}, {
         Rational[-11, 13], Rational[3, 13], -1}}, {{-0.6923076923076923, 
          0.23076923076923078`, -1}, {-0.6923076923076923, 
          0.07692307692307693, -1}, {-0.8461538461538461, 
          0.07692307692307693, -1}, {-0.8461538461538461, 
          0.23076923076923078`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[5, 13], -1}, {
         Rational[-9, 13], Rational[3, 13], -1}, {
         Rational[-11, 13], Rational[3, 13], -1}, {
         Rational[-11, 13], Rational[5, 13], -1}}, {{-0.6923076923076923, 
          0.38461538461538464`, -1}, {-0.6923076923076923, 
          0.23076923076923078`, -1}, {-0.8461538461538461, 
          0.23076923076923078`, -1}, {-0.8461538461538461, 
          0.38461538461538464`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[7, 13], -1}, {
         Rational[-9, 13], Rational[5, 13], -1}, {
         Rational[-11, 13], Rational[5, 13], -1}, {
         Rational[-11, 13], Rational[7, 13], -1}}, {{-0.6923076923076923, 
          0.5384615384615384, -1}, {-0.6923076923076923, 
          0.38461538461538464`, -1}, {-0.8461538461538461, 
          0.38461538461538464`, -1}, {-0.8461538461538461, 
          0.5384615384615384, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[9, 13], -1}, {
         Rational[-9, 13], Rational[7, 13], -1}, {
         Rational[-11, 13], Rational[7, 13], -1}, {
         Rational[-11, 13], Rational[9, 13], -1}}, {{-0.6923076923076923, 
          0.6923076923076923, -1}, {-0.6923076923076923, 
          0.5384615384615384, -1}, {-0.8461538461538461, 
          0.5384615384615384, -1}, {-0.8461538461538461, 
          0.6923076923076923, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[11, 13], -1}, {
         Rational[-9, 13], Rational[9, 13], -1}, {
         Rational[-11, 13], Rational[9, 13], -1}, {
         Rational[-11, 13], Rational[11, 13], -1}}, {{-0.6923076923076923, 
          0.8461538461538461, -1}, {-0.6923076923076923, 
          0.6923076923076923, -1}, {-0.8461538461538461, 
          0.6923076923076923, -1}, {-0.8461538461538461, 
          0.8461538461538461, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], 1, -1}, {
         Rational[-9, 13], Rational[11, 13], -1}, {
         Rational[-11, 13], Rational[11, 13], -1}, {
         Rational[-11, 13], 1, -1}}, {{-0.6923076923076923, 
          1, -1}, {-0.6923076923076923, 
          0.8461538461538461, -1}, {-0.8461538461538461, 
          0.8461538461538461, -1}, {-0.8461538461538461, 1, -1}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[-11, 13], -1}, {
         Rational[-7, 13], -1, -1}, {Rational[-9, 13], -1, -1}, {
         Rational[-9, 13], 
          Rational[-11, 
           13], -1}}, {{-0.5384615384615384, -0.8461538461538461, -1}, \
{-0.5384615384615384, -1, -1}, {-0.6923076923076923, -1, -1}, \
{-0.6923076923076923, -0.8461538461538461, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[-9, 13], -1}, {
         Rational[-7, 13], Rational[-11, 13], -1}, {
         Rational[-9, 13], Rational[-11, 13], -1}, {
         Rational[-9, 13], 
          Rational[-9, 
           13], -1}}, {{-0.5384615384615384, -0.6923076923076923, -1}, \
{-0.5384615384615384, -0.8461538461538461, -1}, {-0.6923076923076923, \
-0.8461538461538461, -1}, {-0.6923076923076923, -0.6923076923076923, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[-7, 13], -1}, {
         Rational[-7, 13], Rational[-9, 13], -1}, {
         Rational[-9, 13], Rational[-9, 13], -1}, {
         Rational[-9, 13], 
          Rational[-7, 
           13], -1}}, {{-0.5384615384615384, -0.5384615384615384, -1}, \
{-0.5384615384615384, -0.6923076923076923, -1}, {-0.6923076923076923, \
-0.6923076923076923, -1}, {-0.6923076923076923, -0.5384615384615384, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[-5, 13], -1}, {
         Rational[-7, 13], Rational[-7, 13], -1}, {
         Rational[-9, 13], Rational[-7, 13], -1}, {
         Rational[-9, 13], 
          Rational[-5, 
           13], -1}}, {{-0.5384615384615384, -0.38461538461538464`, -1}, \
{-0.5384615384615384, -0.5384615384615384, -1}, {-0.6923076923076923, \
-0.5384615384615384, -1}, {-0.6923076923076923, -0.38461538461538464`, -1}}]],
       Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[-3, 13], -1}, {
         Rational[-7, 13], Rational[-5, 13], -1}, {
         Rational[-9, 13], Rational[-5, 13], -1}, {
         Rational[-9, 13], 
          Rational[-3, 
           13], -1}}, {{-0.5384615384615384, -0.23076923076923078`, -1}, \
{-0.5384615384615384, -0.38461538461538464`, -1}, {-0.6923076923076923, \
-0.38461538461538464`, -1}, {-0.6923076923076923, -0.23076923076923078`, \
-1}}]], Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[-1, 13], -1}, {
         Rational[-7, 13], Rational[-3, 13], -1}, {
         Rational[-9, 13], Rational[-3, 13], -1}, {
         Rational[-9, 13], 
          Rational[-1, 
           13], -1}}, {{-0.5384615384615384, -0.07692307692307693, -1}, \
{-0.5384615384615384, -0.23076923076923078`, -1}, {-0.6923076923076923, \
-0.23076923076923078`, -1}, {-0.6923076923076923, -0.07692307692307693, \
-1}}]], Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[1, 13], -1}, {
         Rational[-7, 13], Rational[-1, 13], -1}, {
         Rational[-9, 13], Rational[-1, 13], -1}, {
         Rational[-9, 13], Rational[1, 13], -1}}, {{-0.5384615384615384, 
          0.07692307692307693, -1}, {-0.5384615384615384, \
-0.07692307692307693, -1}, {-0.6923076923076923, -0.07692307692307693, -1}, \
{-0.6923076923076923, 0.07692307692307693, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[3, 13], -1}, {
         Rational[-7, 13], Rational[1, 13], -1}, {
         Rational[-9, 13], Rational[1, 13], -1}, {
         Rational[-9, 13], Rational[3, 13], -1}}, {{-0.5384615384615384, 
          0.23076923076923078`, -1}, {-0.5384615384615384, 
          0.07692307692307693, -1}, {-0.6923076923076923, 
          0.07692307692307693, -1}, {-0.6923076923076923, 
          0.23076923076923078`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[5, 13], -1}, {
         Rational[-7, 13], Rational[3, 13], -1}, {
         Rational[-9, 13], Rational[3, 13], -1}, {
         Rational[-9, 13], Rational[5, 13], -1}}, {{-0.5384615384615384, 
          0.38461538461538464`, -1}, {-0.5384615384615384, 
          0.23076923076923078`, -1}, {-0.6923076923076923, 
          0.23076923076923078`, -1}, {-0.6923076923076923, 
          0.38461538461538464`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[7, 13], -1}, {
         Rational[-7, 13], Rational[5, 13], -1}, {
         Rational[-9, 13], Rational[5, 13], -1}, {
         Rational[-9, 13], Rational[7, 13], -1}}, {{-0.5384615384615384, 
          0.5384615384615384, -1}, {-0.5384615384615384, 
          0.38461538461538464`, -1}, {-0.6923076923076923, 
          0.38461538461538464`, -1}, {-0.6923076923076923, 
          0.5384615384615384, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[9, 13], -1}, {
         Rational[-7, 13], Rational[7, 13], -1}, {
         Rational[-9, 13], Rational[7, 13], -1}, {
         Rational[-9, 13], Rational[9, 13], -1}}, {{-0.5384615384615384, 
          0.6923076923076923, -1}, {-0.5384615384615384, 
          0.5384615384615384, -1}, {-0.6923076923076923, 
          0.5384615384615384, -1}, {-0.6923076923076923, 
          0.6923076923076923, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[11, 13], -1}, {
         Rational[-7, 13], Rational[9, 13], -1}, {
         Rational[-9, 13], Rational[9, 13], -1}, {
         Rational[-9, 13], Rational[11, 13], -1}}, {{-0.5384615384615384, 
          0.8461538461538461, -1}, {-0.5384615384615384, 
          0.6923076923076923, -1}, {-0.6923076923076923, 
          0.6923076923076923, -1}, {-0.6923076923076923, 
          0.8461538461538461, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], 1, -1}, {
         Rational[-7, 13], Rational[11, 13], -1}, {
         Rational[-9, 13], Rational[11, 13], -1}, {
         Rational[-9, 13], 1, -1}}, {{-0.5384615384615384, 
          1, -1}, {-0.5384615384615384, 
          0.8461538461538461, -1}, {-0.6923076923076923, 
          0.8461538461538461, -1}, {-0.6923076923076923, 1, -1}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[-11, 13], -1}, {
         Rational[-5, 13], -1, -1}, {Rational[-7, 13], -1, -1}, {
         Rational[-7, 13], 
          Rational[-11, 
           13], -1}}, {{-0.38461538461538464`, -0.8461538461538461, -1}, \
{-0.38461538461538464`, -1, -1}, {-0.5384615384615384, -1, -1}, \
{-0.5384615384615384, -0.8461538461538461, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[-9, 13], -1}, {
         Rational[-5, 13], Rational[-11, 13], -1}, {
         Rational[-7, 13], Rational[-11, 13], -1}, {
         Rational[-7, 13], 
          Rational[-9, 
           13], -1}}, {{-0.38461538461538464`, -0.6923076923076923, -1}, \
{-0.38461538461538464`, -0.8461538461538461, -1}, {-0.5384615384615384, \
-0.8461538461538461, -1}, {-0.5384615384615384, -0.6923076923076923, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[-7, 13], -1}, {
         Rational[-5, 13], Rational[-9, 13], -1}, {
         Rational[-7, 13], Rational[-9, 13], -1}, {
         Rational[-7, 13], 
          Rational[-7, 
           13], -1}}, {{-0.38461538461538464`, -0.5384615384615384, -1}, \
{-0.38461538461538464`, -0.6923076923076923, -1}, {-0.5384615384615384, \
-0.6923076923076923, -1}, {-0.5384615384615384, -0.5384615384615384, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[-5, 13], -1}, {
         Rational[-5, 13], Rational[-7, 13], -1}, {
         Rational[-7, 13], Rational[-7, 13], -1}, {
         Rational[-7, 13], 
          Rational[-5, 
           13], -1}}, {{-0.38461538461538464`, -0.38461538461538464`, -1}, \
{-0.38461538461538464`, -0.5384615384615384, -1}, {-0.5384615384615384, \
-0.5384615384615384, -1}, {-0.5384615384615384, -0.38461538461538464`, -1}}]],
       Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[-3, 13], -1}, {
         Rational[-5, 13], Rational[-5, 13], -1}, {
         Rational[-7, 13], Rational[-5, 13], -1}, {
         Rational[-7, 13], 
          Rational[-3, 
           13], -1}}, {{-0.38461538461538464`, -0.23076923076923078`, -1}, \
{-0.38461538461538464`, -0.38461538461538464`, -1}, {-0.5384615384615384, \
-0.38461538461538464`, -1}, {-0.5384615384615384, -0.23076923076923078`, \
-1}}]], Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[-1, 13], -1}, {
         Rational[-5, 13], Rational[-3, 13], -1}, {
         Rational[-7, 13], Rational[-3, 13], -1}, {
         Rational[-7, 13], 
          Rational[-1, 
           13], -1}}, {{-0.38461538461538464`, -0.07692307692307693, -1}, \
{-0.38461538461538464`, -0.23076923076923078`, -1}, {-0.5384615384615384, \
-0.23076923076923078`, -1}, {-0.5384615384615384, -0.07692307692307693, \
-1}}]], Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[1, 13], -1}, {
         Rational[-5, 13], Rational[-1, 13], -1}, {
         Rational[-7, 13], Rational[-1, 13], -1}, {
         Rational[-7, 13], Rational[1, 13], -1}}, {{-0.38461538461538464`, 
          
          0.07692307692307693, -1}, {-0.38461538461538464`, \
-0.07692307692307693, -1}, {-0.5384615384615384, -0.07692307692307693, -1}, \
{-0.5384615384615384, 0.07692307692307693, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[3, 13], -1}, {
         Rational[-5, 13], Rational[1, 13], -1}, {
         Rational[-7, 13], Rational[1, 13], -1}, {
         Rational[-7, 13], Rational[3, 13], -1}}, {{-0.38461538461538464`, 
          0.23076923076923078`, -1}, {-0.38461538461538464`, 
          0.07692307692307693, -1}, {-0.5384615384615384, 
          0.07692307692307693, -1}, {-0.5384615384615384, 
          0.23076923076923078`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[5, 13], -1}, {
         Rational[-5, 13], Rational[3, 13], -1}, {
         Rational[-7, 13], Rational[3, 13], -1}, {
         Rational[-7, 13], Rational[5, 13], -1}}, {{-0.38461538461538464`, 
          0.38461538461538464`, -1}, {-0.38461538461538464`, 
          0.23076923076923078`, -1}, {-0.5384615384615384, 
          0.23076923076923078`, -1}, {-0.5384615384615384, 
          0.38461538461538464`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[7, 13], -1}, {
         Rational[-5, 13], Rational[5, 13], -1}, {
         Rational[-7, 13], Rational[5, 13], -1}, {
         Rational[-7, 13], Rational[7, 13], -1}}, {{-0.38461538461538464`, 
          0.5384615384615384, -1}, {-0.38461538461538464`, 
          0.38461538461538464`, -1}, {-0.5384615384615384, 
          0.38461538461538464`, -1}, {-0.5384615384615384, 
          0.5384615384615384, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[9, 13], -1}, {
         Rational[-5, 13], Rational[7, 13], -1}, {
         Rational[-7, 13], Rational[7, 13], -1}, {
         Rational[-7, 13], Rational[9, 13], -1}}, {{-0.38461538461538464`, 
          0.6923076923076923, -1}, {-0.38461538461538464`, 
          0.5384615384615384, -1}, {-0.5384615384615384, 
          0.5384615384615384, -1}, {-0.5384615384615384, 
          0.6923076923076923, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[11, 13], -1}, {
         Rational[-5, 13], Rational[9, 13], -1}, {
         Rational[-7, 13], Rational[9, 13], -1}, {
         Rational[-7, 13], Rational[11, 13], -1}}, {{-0.38461538461538464`, 
          0.8461538461538461, -1}, {-0.38461538461538464`, 
          0.6923076923076923, -1}, {-0.5384615384615384, 
          0.6923076923076923, -1}, {-0.5384615384615384, 
          0.8461538461538461, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], 1, -1}, {
         Rational[-5, 13], Rational[11, 13], -1}, {
         Rational[-7, 13], Rational[11, 13], -1}, {
         Rational[-7, 13], 1, -1}}, {{-0.38461538461538464`, 
          1, -1}, {-0.38461538461538464`, 
          0.8461538461538461, -1}, {-0.5384615384615384, 
          0.8461538461538461, -1}, {-0.5384615384615384, 1, -1}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[-11, 13], -1}, {
         Rational[-3, 13], -1, -1}, {Rational[-5, 13], -1, -1}, {
         Rational[-5, 13], 
          Rational[-11, 
           13], -1}}, {{-0.23076923076923078`, -0.8461538461538461, -1}, \
{-0.23076923076923078`, -1, -1}, {-0.38461538461538464`, -1, -1}, \
{-0.38461538461538464`, -0.8461538461538461, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[-9, 13], -1}, {
         Rational[-3, 13], Rational[-11, 13], -1}, {
         Rational[-5, 13], Rational[-11, 13], -1}, {
         Rational[-5, 13], 
          Rational[-9, 
           13], -1}}, {{-0.23076923076923078`, -0.6923076923076923, -1}, \
{-0.23076923076923078`, -0.8461538461538461, -1}, {-0.38461538461538464`, \
-0.8461538461538461, -1}, {-0.38461538461538464`, -0.6923076923076923, -1}}]],
       Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[-7, 13], -1}, {
         Rational[-3, 13], Rational[-9, 13], -1}, {
         Rational[-5, 13], Rational[-9, 13], -1}, {
         Rational[-5, 13], 
          Rational[-7, 
           13], -1}}, {{-0.23076923076923078`, -0.5384615384615384, -1}, \
{-0.23076923076923078`, -0.6923076923076923, -1}, {-0.38461538461538464`, \
-0.6923076923076923, -1}, {-0.38461538461538464`, -0.5384615384615384, -1}}]],
       Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[-5, 13], -1}, {
         Rational[-3, 13], Rational[-7, 13], -1}, {
         Rational[-5, 13], Rational[-7, 13], -1}, {
         Rational[-5, 13], 
          Rational[-5, 
           13], -1}}, {{-0.23076923076923078`, -0.38461538461538464`, -1}, \
{-0.23076923076923078`, -0.5384615384615384, -1}, {-0.38461538461538464`, \
-0.5384615384615384, -1}, {-0.38461538461538464`, -0.38461538461538464`, \
-1}}]], Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[-3, 13], -1}, {
         Rational[-3, 13], Rational[-5, 13], -1}, {
         Rational[-5, 13], Rational[-5, 13], -1}, {
         Rational[-5, 13], 
          Rational[-3, 
           13], -1}}, {{-0.23076923076923078`, -0.23076923076923078`, -1}, \
{-0.23076923076923078`, -0.38461538461538464`, -1}, {-0.38461538461538464`, \
-0.38461538461538464`, -1}, {-0.38461538461538464`, -0.23076923076923078`, \
-1}}]], Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[-1, 13], -1}, {
         Rational[-3, 13], Rational[-3, 13], -1}, {
         Rational[-5, 13], Rational[-3, 13], -1}, {
         Rational[-5, 13], 
          Rational[-1, 
           13], -1}}, {{-0.23076923076923078`, -0.07692307692307693, -1}, \
{-0.23076923076923078`, -0.23076923076923078`, -1}, {-0.38461538461538464`, \
-0.23076923076923078`, -1}, {-0.38461538461538464`, -0.07692307692307693, \
-1}}]], Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[1, 13], -1}, {
         Rational[-3, 13], Rational[-1, 13], -1}, {
         Rational[-5, 13], Rational[-1, 13], -1}, {
         Rational[-5, 13], Rational[1, 13], -1}}, {{-0.23076923076923078`, 
          0.07692307692307693, -1}, {-0.23076923076923078`, \
-0.07692307692307693, -1}, {-0.38461538461538464`, -0.07692307692307693, -1}, \
{-0.38461538461538464`, 0.07692307692307693, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[3, 13], -1}, {
         Rational[-3, 13], Rational[1, 13], -1}, {
         Rational[-5, 13], Rational[1, 13], -1}, {
         Rational[-5, 13], Rational[3, 13], -1}}, {{-0.23076923076923078`, 
          0.23076923076923078`, -1}, {-0.23076923076923078`, 
          0.07692307692307693, -1}, {-0.38461538461538464`, 
          0.07692307692307693, -1}, {-0.38461538461538464`, 
          0.23076923076923078`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[5, 13], -1}, {
         Rational[-3, 13], Rational[3, 13], -1}, {
         Rational[-5, 13], Rational[3, 13], -1}, {
         Rational[-5, 13], Rational[5, 13], -1}}, {{-0.23076923076923078`, 
          0.38461538461538464`, -1}, {-0.23076923076923078`, 
          0.23076923076923078`, -1}, {-0.38461538461538464`, 
          0.23076923076923078`, -1}, {-0.38461538461538464`, 
          0.38461538461538464`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[7, 13], -1}, {
         Rational[-3, 13], Rational[5, 13], -1}, {
         Rational[-5, 13], Rational[5, 13], -1}, {
         Rational[-5, 13], Rational[7, 13], -1}}, {{-0.23076923076923078`, 
          0.5384615384615384, -1}, {-0.23076923076923078`, 
          0.38461538461538464`, -1}, {-0.38461538461538464`, 
          0.38461538461538464`, -1}, {-0.38461538461538464`, 
          0.5384615384615384, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[9, 13], -1}, {
         Rational[-3, 13], Rational[7, 13], -1}, {
         Rational[-5, 13], Rational[7, 13], -1}, {
         Rational[-5, 13], Rational[9, 13], -1}}, {{-0.23076923076923078`, 
          0.6923076923076923, -1}, {-0.23076923076923078`, 
          0.5384615384615384, -1}, {-0.38461538461538464`, 
          0.5384615384615384, -1}, {-0.38461538461538464`, 
          0.6923076923076923, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[11, 13], -1}, {
         Rational[-3, 13], Rational[9, 13], -1}, {
         Rational[-5, 13], Rational[9, 13], -1}, {
         Rational[-5, 13], Rational[11, 13], -1}}, {{-0.23076923076923078`, 
          0.8461538461538461, -1}, {-0.23076923076923078`, 
          0.6923076923076923, -1}, {-0.38461538461538464`, 
          0.6923076923076923, -1}, {-0.38461538461538464`, 
          0.8461538461538461, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], 1, -1}, {
         Rational[-3, 13], Rational[11, 13], -1}, {
         Rational[-5, 13], Rational[11, 13], -1}, {
         Rational[-5, 13], 1, -1}}, {{-0.23076923076923078`, 
          1, -1}, {-0.23076923076923078`, 
          0.8461538461538461, -1}, {-0.38461538461538464`, 
          0.8461538461538461, -1}, {-0.38461538461538464`, 1, -1}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[-11, 13], -1}, {
         Rational[-1, 13], -1, -1}, {Rational[-3, 13], -1, -1}, {
         Rational[-3, 13], 
          Rational[-11, 
           13], -1}}, {{-0.07692307692307693, -0.8461538461538461, -1}, \
{-0.07692307692307693, -1, -1}, {-0.23076923076923078`, -1, -1}, \
{-0.23076923076923078`, -0.8461538461538461, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[-9, 13], -1}, {
         Rational[-1, 13], Rational[-11, 13], -1}, {
         Rational[-3, 13], Rational[-11, 13], -1}, {
         Rational[-3, 13], 
          Rational[-9, 
           13], -1}}, {{-0.07692307692307693, -0.6923076923076923, -1}, \
{-0.07692307692307693, -0.8461538461538461, -1}, {-0.23076923076923078`, \
-0.8461538461538461, -1}, {-0.23076923076923078`, -0.6923076923076923, -1}}]],
       Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[-7, 13], -1}, {
         Rational[-1, 13], Rational[-9, 13], -1}, {
         Rational[-3, 13], Rational[-9, 13], -1}, {
         Rational[-3, 13], 
          Rational[-7, 
           13], -1}}, {{-0.07692307692307693, -0.5384615384615384, -1}, \
{-0.07692307692307693, -0.6923076923076923, -1}, {-0.23076923076923078`, \
-0.6923076923076923, -1}, {-0.23076923076923078`, -0.5384615384615384, -1}}]],
       Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[-5, 13], -1}, {
         Rational[-1, 13], Rational[-7, 13], -1}, {
         Rational[-3, 13], Rational[-7, 13], -1}, {
         Rational[-3, 13], 
          Rational[-5, 
           13], -1}}, {{-0.07692307692307693, -0.38461538461538464`, -1}, \
{-0.07692307692307693, -0.5384615384615384, -1}, {-0.23076923076923078`, \
-0.5384615384615384, -1}, {-0.23076923076923078`, -0.38461538461538464`, \
-1}}]], Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[-3, 13], -1}, {
         Rational[-1, 13], Rational[-5, 13], -1}, {
         Rational[-3, 13], Rational[-5, 13], -1}, {
         Rational[-3, 13], 
          Rational[-3, 
           13], -1}}, {{-0.07692307692307693, -0.23076923076923078`, -1}, \
{-0.07692307692307693, -0.38461538461538464`, -1}, {-0.23076923076923078`, \
-0.38461538461538464`, -1}, {-0.23076923076923078`, -0.23076923076923078`, \
-1}}]], Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[-1, 13], -1}, {
         Rational[-1, 13], Rational[-3, 13], -1}, {
         Rational[-3, 13], Rational[-3, 13], -1}, {
         Rational[-3, 13], 
          Rational[-1, 
           13], -1}}, {{-0.07692307692307693, -0.07692307692307693, -1}, \
{-0.07692307692307693, -0.23076923076923078`, -1}, {-0.23076923076923078`, \
-0.23076923076923078`, -1}, {-0.23076923076923078`, -0.07692307692307693, \
-1}}]], Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[1, 13], -1}, {
         Rational[-1, 13], Rational[-1, 13], -1}, {
         Rational[-3, 13], Rational[-1, 13], -1}, {
         Rational[-3, 13], Rational[1, 13], -1}}, {{-0.07692307692307693, 
          0.07692307692307693, -1}, {-0.07692307692307693, \
-0.07692307692307693, -1}, {-0.23076923076923078`, -0.07692307692307693, -1}, \
{-0.23076923076923078`, 0.07692307692307693, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[3, 13], -1}, {
         Rational[-1, 13], Rational[1, 13], -1}, {
         Rational[-3, 13], Rational[1, 13], -1}, {
         Rational[-3, 13], Rational[3, 13], -1}}, {{-0.07692307692307693, 
          0.23076923076923078`, -1}, {-0.07692307692307693, 
          0.07692307692307693, -1}, {-0.23076923076923078`, 
          0.07692307692307693, -1}, {-0.23076923076923078`, 
          0.23076923076923078`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[5, 13], -1}, {
         Rational[-1, 13], Rational[3, 13], -1}, {
         Rational[-3, 13], Rational[3, 13], -1}, {
         Rational[-3, 13], Rational[5, 13], -1}}, {{-0.07692307692307693, 
          0.38461538461538464`, -1}, {-0.07692307692307693, 
          0.23076923076923078`, -1}, {-0.23076923076923078`, 
          0.23076923076923078`, -1}, {-0.23076923076923078`, 
          0.38461538461538464`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[7, 13], -1}, {
         Rational[-1, 13], Rational[5, 13], -1}, {
         Rational[-3, 13], Rational[5, 13], -1}, {
         Rational[-3, 13], Rational[7, 13], -1}}, {{-0.07692307692307693, 
          0.5384615384615384, -1}, {-0.07692307692307693, 
          0.38461538461538464`, -1}, {-0.23076923076923078`, 
          0.38461538461538464`, -1}, {-0.23076923076923078`, 
          0.5384615384615384, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[9, 13], -1}, {
         Rational[-1, 13], Rational[7, 13], -1}, {
         Rational[-3, 13], Rational[7, 13], -1}, {
         Rational[-3, 13], Rational[9, 13], -1}}, {{-0.07692307692307693, 
          0.6923076923076923, -1}, {-0.07692307692307693, 
          0.5384615384615384, -1}, {-0.23076923076923078`, 
          0.5384615384615384, -1}, {-0.23076923076923078`, 
          0.6923076923076923, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[11, 13], -1}, {
         Rational[-1, 13], Rational[9, 13], -1}, {
         Rational[-3, 13], Rational[9, 13], -1}, {
         Rational[-3, 13], Rational[11, 13], -1}}, {{-0.07692307692307693, 
          0.8461538461538461, -1}, {-0.07692307692307693, 
          0.6923076923076923, -1}, {-0.23076923076923078`, 
          0.6923076923076923, -1}, {-0.23076923076923078`, 
          0.8461538461538461, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], 1, -1}, {
         Rational[-1, 13], Rational[11, 13], -1}, {
         Rational[-3, 13], Rational[11, 13], -1}, {
         Rational[-3, 13], 1, -1}}, {{-0.07692307692307693, 
          1, -1}, {-0.07692307692307693, 
          0.8461538461538461, -1}, {-0.23076923076923078`, 
          0.8461538461538461, -1}, {-0.23076923076923078`, 1, -1}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[-11, 13], -1}, {
         Rational[1, 13], -1, -1}, {Rational[-1, 13], -1, -1}, {
         Rational[-1, 13], Rational[-11, 13], -1}}, {{
         0.07692307692307693, -0.8461538461538461, -1}, {
         0.07692307692307693, -1, -1}, {-0.07692307692307693, -1, -1}, \
{-0.07692307692307693, -0.8461538461538461, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[-9, 13], -1}, {
         Rational[1, 13], Rational[-11, 13], -1}, {
         Rational[-1, 13], Rational[-11, 13], -1}, {
         Rational[-1, 13], Rational[-9, 13], -1}}, {{
         0.07692307692307693, -0.6923076923076923, -1}, {
         0.07692307692307693, -0.8461538461538461, -1}, \
{-0.07692307692307693, -0.8461538461538461, -1}, {-0.07692307692307693, \
-0.6923076923076923, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[-7, 13], -1}, {
         Rational[1, 13], Rational[-9, 13], -1}, {
         Rational[-1, 13], Rational[-9, 13], -1}, {
         Rational[-1, 13], Rational[-7, 13], -1}}, {{
         0.07692307692307693, -0.5384615384615384, -1}, {
         0.07692307692307693, -0.6923076923076923, -1}, \
{-0.07692307692307693, -0.6923076923076923, -1}, {-0.07692307692307693, \
-0.5384615384615384, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[-5, 13], -1}, {
         Rational[1, 13], Rational[-7, 13], -1}, {
         Rational[-1, 13], Rational[-7, 13], -1}, {
         Rational[-1, 13], Rational[-5, 13], -1}}, {{
         0.07692307692307693, -0.38461538461538464`, -1}, {
         0.07692307692307693, -0.5384615384615384, -1}, \
{-0.07692307692307693, -0.5384615384615384, -1}, {-0.07692307692307693, \
-0.38461538461538464`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[-3, 13], -1}, {
         Rational[1, 13], Rational[-5, 13], -1}, {
         Rational[-1, 13], Rational[-5, 13], -1}, {
         Rational[-1, 13], Rational[-3, 13], -1}}, {{
         0.07692307692307693, -0.23076923076923078`, -1}, {
         0.07692307692307693, -0.38461538461538464`, -1}, \
{-0.07692307692307693, -0.38461538461538464`, -1}, {-0.07692307692307693, \
-0.23076923076923078`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[-1, 13], -1}, {
         Rational[1, 13], Rational[-3, 13], -1}, {
         Rational[-1, 13], Rational[-3, 13], -1}, {
         Rational[-1, 13], Rational[-1, 13], -1}}, {{
         0.07692307692307693, -0.07692307692307693, -1}, {
         0.07692307692307693, -0.23076923076923078`, -1}, \
{-0.07692307692307693, -0.23076923076923078`, -1}, {-0.07692307692307693, \
-0.07692307692307693, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[1, 13], -1}, {
         Rational[1, 13], Rational[-1, 13], -1}, {
         Rational[-1, 13], Rational[-1, 13], -1}, {
         Rational[-1, 13], Rational[1, 13], -1}}, {{
         0.07692307692307693, 0.07692307692307693, -1}, {
         0.07692307692307693, -0.07692307692307693, -1}, \
{-0.07692307692307693, -0.07692307692307693, -1}, {-0.07692307692307693, 
          0.07692307692307693, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[3, 13], -1}, {
         Rational[1, 13], Rational[1, 13], -1}, {
         Rational[-1, 13], Rational[1, 13], -1}, {
         Rational[-1, 13], Rational[3, 13], -1}}, {{
         0.07692307692307693, 0.23076923076923078`, -1}, {
         0.07692307692307693, 0.07692307692307693, -1}, {-0.07692307692307693,
           0.07692307692307693, -1}, {-0.07692307692307693, 
          0.23076923076923078`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[5, 13], -1}, {
         Rational[1, 13], Rational[3, 13], -1}, {
         Rational[-1, 13], Rational[3, 13], -1}, {
         Rational[-1, 13], Rational[5, 13], -1}}, {{
         0.07692307692307693, 0.38461538461538464`, -1}, {
         0.07692307692307693, 
          0.23076923076923078`, -1}, {-0.07692307692307693, 
          0.23076923076923078`, -1}, {-0.07692307692307693, 
          0.38461538461538464`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[7, 13], -1}, {
         Rational[1, 13], Rational[5, 13], -1}, {
         Rational[-1, 13], Rational[5, 13], -1}, {
         Rational[-1, 13], Rational[7, 13], -1}}, {{
         0.07692307692307693, 0.5384615384615384, -1}, {
         0.07692307692307693, 
          0.38461538461538464`, -1}, {-0.07692307692307693, 
          0.38461538461538464`, -1}, {-0.07692307692307693, 
          0.5384615384615384, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[9, 13], -1}, {
         Rational[1, 13], Rational[7, 13], -1}, {
         Rational[-1, 13], Rational[7, 13], -1}, {
         Rational[-1, 13], Rational[9, 13], -1}}, {{
         0.07692307692307693, 0.6923076923076923, -1}, {
         0.07692307692307693, 0.5384615384615384, -1}, {-0.07692307692307693, 
          0.5384615384615384, -1}, {-0.07692307692307693, 
          0.6923076923076923, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[11, 13], -1}, {
         Rational[1, 13], Rational[9, 13], -1}, {
         Rational[-1, 13], Rational[9, 13], -1}, {
         Rational[-1, 13], Rational[11, 13], -1}}, {{
         0.07692307692307693, 0.8461538461538461, -1}, {
         0.07692307692307693, 0.6923076923076923, -1}, {-0.07692307692307693, 
          0.6923076923076923, -1}, {-0.07692307692307693, 
          0.8461538461538461, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], 1, -1}, {
         Rational[1, 13], Rational[11, 13], -1}, {
         Rational[-1, 13], Rational[11, 13], -1}, {
         Rational[-1, 13], 1, -1}}, {{0.07692307692307693, 1, -1}, {
         0.07692307692307693, 0.8461538461538461, -1}, {-0.07692307692307693, 
          0.8461538461538461, -1}, {-0.07692307692307693, 1, -1}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[-11, 13], -1}, {
         Rational[3, 13], -1, -1}, {Rational[1, 13], -1, -1}, {
         Rational[1, 13], Rational[-11, 13], -1}}, {{
         0.23076923076923078`, -0.8461538461538461, -1}, {
         0.23076923076923078`, -1, -1}, {0.07692307692307693, -1, -1}, {
         0.07692307692307693, -0.8461538461538461, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[-9, 13], -1}, {
         Rational[3, 13], Rational[-11, 13], -1}, {
         Rational[1, 13], Rational[-11, 13], -1}, {
         Rational[1, 13], Rational[-9, 13], -1}}, {{
         0.23076923076923078`, -0.6923076923076923, -1}, {
         0.23076923076923078`, -0.8461538461538461, -1}, {
         0.07692307692307693, -0.8461538461538461, -1}, {
         0.07692307692307693, -0.6923076923076923, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[-7, 13], -1}, {
         Rational[3, 13], Rational[-9, 13], -1}, {
         Rational[1, 13], Rational[-9, 13], -1}, {
         Rational[1, 13], Rational[-7, 13], -1}}, {{
         0.23076923076923078`, -0.5384615384615384, -1}, {
         0.23076923076923078`, -0.6923076923076923, -1}, {
         0.07692307692307693, -0.6923076923076923, -1}, {
         0.07692307692307693, -0.5384615384615384, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[-5, 13], -1}, {
         Rational[3, 13], Rational[-7, 13], -1}, {
         Rational[1, 13], Rational[-7, 13], -1}, {
         Rational[1, 13], Rational[-5, 13], -1}}, {{
         0.23076923076923078`, -0.38461538461538464`, -1}, {
         0.23076923076923078`, -0.5384615384615384, -1}, {
         0.07692307692307693, -0.5384615384615384, -1}, {
         0.07692307692307693, -0.38461538461538464`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[-3, 13], -1}, {
         Rational[3, 13], Rational[-5, 13], -1}, {
         Rational[1, 13], Rational[-5, 13], -1}, {
         Rational[1, 13], Rational[-3, 13], -1}}, {{
         0.23076923076923078`, -0.23076923076923078`, -1}, {
         0.23076923076923078`, -0.38461538461538464`, -1}, {
         0.07692307692307693, -0.38461538461538464`, -1}, {
         0.07692307692307693, -0.23076923076923078`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[-1, 13], -1}, {
         Rational[3, 13], Rational[-3, 13], -1}, {
         Rational[1, 13], Rational[-3, 13], -1}, {
         Rational[1, 13], Rational[-1, 13], -1}}, {{
         0.23076923076923078`, -0.07692307692307693, -1}, {
         0.23076923076923078`, -0.23076923076923078`, -1}, {
         0.07692307692307693, -0.23076923076923078`, -1}, {
         0.07692307692307693, -0.07692307692307693, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[1, 13], -1}, {
         Rational[3, 13], Rational[-1, 13], -1}, {
         Rational[1, 13], Rational[-1, 13], -1}, {
         Rational[1, 13], Rational[1, 13], -1}}, {{
         0.23076923076923078`, 0.07692307692307693, -1}, {
         0.23076923076923078`, -0.07692307692307693, -1}, {
         0.07692307692307693, -0.07692307692307693, -1}, {
         0.07692307692307693, 0.07692307692307693, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[3, 13], -1}, {
         Rational[3, 13], Rational[1, 13], -1}, {
         Rational[1, 13], Rational[1, 13], -1}, {
         Rational[1, 13], Rational[3, 13], -1}}, {{
         0.23076923076923078`, 0.23076923076923078`, -1}, {
         0.23076923076923078`, 0.07692307692307693, -1}, {
         0.07692307692307693, 0.07692307692307693, -1}, {
         0.07692307692307693, 0.23076923076923078`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[5, 13], -1}, {
         Rational[3, 13], Rational[3, 13], -1}, {
         Rational[1, 13], Rational[3, 13], -1}, {
         Rational[1, 13], Rational[5, 13], -1}}, {{
         0.23076923076923078`, 0.38461538461538464`, -1}, {
         0.23076923076923078`, 0.23076923076923078`, -1}, {
         0.07692307692307693, 0.23076923076923078`, -1}, {
         0.07692307692307693, 0.38461538461538464`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[7, 13], -1}, {
         Rational[3, 13], Rational[5, 13], -1}, {
         Rational[1, 13], Rational[5, 13], -1}, {
         Rational[1, 13], Rational[7, 13], -1}}, {{
         0.23076923076923078`, 0.5384615384615384, -1}, {
         0.23076923076923078`, 0.38461538461538464`, -1}, {
         0.07692307692307693, 0.38461538461538464`, -1}, {
         0.07692307692307693, 0.5384615384615384, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[9, 13], -1}, {
         Rational[3, 13], Rational[7, 13], -1}, {
         Rational[1, 13], Rational[7, 13], -1}, {
         Rational[1, 13], Rational[9, 13], -1}}, {{
         0.23076923076923078`, 0.6923076923076923, -1}, {
         0.23076923076923078`, 0.5384615384615384, -1}, {
         0.07692307692307693, 0.5384615384615384, -1}, {
         0.07692307692307693, 0.6923076923076923, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[11, 13], -1}, {
         Rational[3, 13], Rational[9, 13], -1}, {
         Rational[1, 13], Rational[9, 13], -1}, {
         Rational[1, 13], Rational[11, 13], -1}}, {{
         0.23076923076923078`, 0.8461538461538461, -1}, {
         0.23076923076923078`, 0.6923076923076923, -1}, {
         0.07692307692307693, 0.6923076923076923, -1}, {
         0.07692307692307693, 0.8461538461538461, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], 1, -1}, {
         Rational[3, 13], Rational[11, 13], -1}, {
         Rational[1, 13], Rational[11, 13], -1}, {Rational[1, 13], 1, -1}}, {{
         0.23076923076923078`, 1, -1}, {
         0.23076923076923078`, 0.8461538461538461, -1}, {
         0.07692307692307693, 0.8461538461538461, -1}, {
         0.07692307692307693, 1, -1}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[-11, 13], -1}, {
         Rational[5, 13], -1, -1}, {Rational[3, 13], -1, -1}, {
         Rational[3, 13], Rational[-11, 13], -1}}, {{
         0.38461538461538464`, -0.8461538461538461, -1}, {
         0.38461538461538464`, -1, -1}, {0.23076923076923078`, -1, -1}, {
         0.23076923076923078`, -0.8461538461538461, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[-9, 13], -1}, {
         Rational[5, 13], Rational[-11, 13], -1}, {
         Rational[3, 13], Rational[-11, 13], -1}, {
         Rational[3, 13], Rational[-9, 13], -1}}, {{
         0.38461538461538464`, -0.6923076923076923, -1}, {
         0.38461538461538464`, -0.8461538461538461, -1}, {
         0.23076923076923078`, -0.8461538461538461, -1}, {
         0.23076923076923078`, -0.6923076923076923, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[-7, 13], -1}, {
         Rational[5, 13], Rational[-9, 13], -1}, {
         Rational[3, 13], Rational[-9, 13], -1}, {
         Rational[3, 13], Rational[-7, 13], -1}}, {{
         0.38461538461538464`, -0.5384615384615384, -1}, {
         0.38461538461538464`, -0.6923076923076923, -1}, {
         0.23076923076923078`, -0.6923076923076923, -1}, {
         0.23076923076923078`, -0.5384615384615384, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[-5, 13], -1}, {
         Rational[5, 13], Rational[-7, 13], -1}, {
         Rational[3, 13], Rational[-7, 13], -1}, {
         Rational[3, 13], Rational[-5, 13], -1}}, {{
         0.38461538461538464`, -0.38461538461538464`, -1}, {
         0.38461538461538464`, -0.5384615384615384, -1}, {
         0.23076923076923078`, -0.5384615384615384, -1}, {
         0.23076923076923078`, -0.38461538461538464`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[-3, 13], -1}, {
         Rational[5, 13], Rational[-5, 13], -1}, {
         Rational[3, 13], Rational[-5, 13], -1}, {
         Rational[3, 13], Rational[-3, 13], -1}}, {{
         0.38461538461538464`, -0.23076923076923078`, -1}, {
         0.38461538461538464`, -0.38461538461538464`, -1}, {
         0.23076923076923078`, -0.38461538461538464`, -1}, {
         0.23076923076923078`, -0.23076923076923078`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[-1, 13], -1}, {
         Rational[5, 13], Rational[-3, 13], -1}, {
         Rational[3, 13], Rational[-3, 13], -1}, {
         Rational[3, 13], Rational[-1, 13], -1}}, {{
         0.38461538461538464`, -0.07692307692307693, -1}, {
         0.38461538461538464`, -0.23076923076923078`, -1}, {
         0.23076923076923078`, -0.23076923076923078`, -1}, {
         0.23076923076923078`, -0.07692307692307693, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[1, 13], -1}, {
         Rational[5, 13], Rational[-1, 13], -1}, {
         Rational[3, 13], Rational[-1, 13], -1}, {
         Rational[3, 13], Rational[1, 13], -1}}, {{
         0.38461538461538464`, 0.07692307692307693, -1}, {
         0.38461538461538464`, -0.07692307692307693, -1}, {
         0.23076923076923078`, -0.07692307692307693, -1}, {
         0.23076923076923078`, 0.07692307692307693, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[3, 13], -1}, {
         Rational[5, 13], Rational[1, 13], -1}, {
         Rational[3, 13], Rational[1, 13], -1}, {
         Rational[3, 13], Rational[3, 13], -1}}, {{
         0.38461538461538464`, 0.23076923076923078`, -1}, {
         0.38461538461538464`, 0.07692307692307693, -1}, {
         0.23076923076923078`, 0.07692307692307693, -1}, {
         0.23076923076923078`, 0.23076923076923078`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[5, 13], -1}, {
         Rational[5, 13], Rational[3, 13], -1}, {
         Rational[3, 13], Rational[3, 13], -1}, {
         Rational[3, 13], Rational[5, 13], -1}}, {{
         0.38461538461538464`, 0.38461538461538464`, -1}, {
         0.38461538461538464`, 0.23076923076923078`, -1}, {
         0.23076923076923078`, 0.23076923076923078`, -1}, {
         0.23076923076923078`, 0.38461538461538464`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[7, 13], -1}, {
         Rational[5, 13], Rational[5, 13], -1}, {
         Rational[3, 13], Rational[5, 13], -1}, {
         Rational[3, 13], Rational[7, 13], -1}}, {{
         0.38461538461538464`, 0.5384615384615384, -1}, {
         0.38461538461538464`, 0.38461538461538464`, -1}, {
         0.23076923076923078`, 0.38461538461538464`, -1}, {
         0.23076923076923078`, 0.5384615384615384, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[9, 13], -1}, {
         Rational[5, 13], Rational[7, 13], -1}, {
         Rational[3, 13], Rational[7, 13], -1}, {
         Rational[3, 13], Rational[9, 13], -1}}, {{
         0.38461538461538464`, 0.6923076923076923, -1}, {
         0.38461538461538464`, 0.5384615384615384, -1}, {
         0.23076923076923078`, 0.5384615384615384, -1}, {
         0.23076923076923078`, 0.6923076923076923, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[11, 13], -1}, {
         Rational[5, 13], Rational[9, 13], -1}, {
         Rational[3, 13], Rational[9, 13], -1}, {
         Rational[3, 13], Rational[11, 13], -1}}, {{
         0.38461538461538464`, 0.8461538461538461, -1}, {
         0.38461538461538464`, 0.6923076923076923, -1}, {
         0.23076923076923078`, 0.6923076923076923, -1}, {
         0.23076923076923078`, 0.8461538461538461, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], 1, -1}, {
         Rational[5, 13], Rational[11, 13], -1}, {
         Rational[3, 13], Rational[11, 13], -1}, {Rational[3, 13], 1, -1}}, {{
         0.38461538461538464`, 1, -1}, {
         0.38461538461538464`, 0.8461538461538461, -1}, {
         0.23076923076923078`, 0.8461538461538461, -1}, {
         0.23076923076923078`, 1, -1}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[-11, 13], -1}, {
         Rational[7, 13], -1, -1}, {Rational[5, 13], -1, -1}, {
         Rational[5, 13], Rational[-11, 13], -1}}, {{
         0.5384615384615384, -0.8461538461538461, -1}, {
         0.5384615384615384, -1, -1}, {0.38461538461538464`, -1, -1}, {
         0.38461538461538464`, -0.8461538461538461, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[-9, 13], -1}, {
         Rational[7, 13], Rational[-11, 13], -1}, {
         Rational[5, 13], Rational[-11, 13], -1}, {
         Rational[5, 13], Rational[-9, 13], -1}}, {{
         0.5384615384615384, -0.6923076923076923, -1}, {
         0.5384615384615384, -0.8461538461538461, -1}, {
         0.38461538461538464`, -0.8461538461538461, -1}, {
         0.38461538461538464`, -0.6923076923076923, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[-7, 13], -1}, {
         Rational[7, 13], Rational[-9, 13], -1}, {
         Rational[5, 13], Rational[-9, 13], -1}, {
         Rational[5, 13], Rational[-7, 13], -1}}, {{
         0.5384615384615384, -0.5384615384615384, -1}, {
         0.5384615384615384, -0.6923076923076923, -1}, {
         0.38461538461538464`, -0.6923076923076923, -1}, {
         0.38461538461538464`, -0.5384615384615384, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[-5, 13], -1}, {
         Rational[7, 13], Rational[-7, 13], -1}, {
         Rational[5, 13], Rational[-7, 13], -1}, {
         Rational[5, 13], Rational[-5, 13], -1}}, {{
         0.5384615384615384, -0.38461538461538464`, -1}, {
         0.5384615384615384, -0.5384615384615384, -1}, {
         0.38461538461538464`, -0.5384615384615384, -1}, {
         0.38461538461538464`, -0.38461538461538464`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[-3, 13], -1}, {
         Rational[7, 13], Rational[-5, 13], -1}, {
         Rational[5, 13], Rational[-5, 13], -1}, {
         Rational[5, 13], Rational[-3, 13], -1}}, {{
         0.5384615384615384, -0.23076923076923078`, -1}, {
         0.5384615384615384, -0.38461538461538464`, -1}, {
         0.38461538461538464`, -0.38461538461538464`, -1}, {
         0.38461538461538464`, -0.23076923076923078`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[-1, 13], -1}, {
         Rational[7, 13], Rational[-3, 13], -1}, {
         Rational[5, 13], Rational[-3, 13], -1}, {
         Rational[5, 13], Rational[-1, 13], -1}}, {{
         0.5384615384615384, -0.07692307692307693, -1}, {
         0.5384615384615384, -0.23076923076923078`, -1}, {
         0.38461538461538464`, -0.23076923076923078`, -1}, {
         0.38461538461538464`, -0.07692307692307693, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[1, 13], -1}, {
         Rational[7, 13], Rational[-1, 13], -1}, {
         Rational[5, 13], Rational[-1, 13], -1}, {
         Rational[5, 13], Rational[1, 13], -1}}, {{
         0.5384615384615384, 0.07692307692307693, -1}, {
         0.5384615384615384, -0.07692307692307693, -1}, {
         0.38461538461538464`, -0.07692307692307693, -1}, {
         0.38461538461538464`, 0.07692307692307693, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[3, 13], -1}, {
         Rational[7, 13], Rational[1, 13], -1}, {
         Rational[5, 13], Rational[1, 13], -1}, {
         Rational[5, 13], Rational[3, 13], -1}}, {{
         0.5384615384615384, 0.23076923076923078`, -1}, {
         0.5384615384615384, 0.07692307692307693, -1}, {
         0.38461538461538464`, 0.07692307692307693, -1}, {
         0.38461538461538464`, 0.23076923076923078`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[5, 13], -1}, {
         Rational[7, 13], Rational[3, 13], -1}, {
         Rational[5, 13], Rational[3, 13], -1}, {
         Rational[5, 13], Rational[5, 13], -1}}, {{
         0.5384615384615384, 0.38461538461538464`, -1}, {
         0.5384615384615384, 0.23076923076923078`, -1}, {
         0.38461538461538464`, 0.23076923076923078`, -1}, {
         0.38461538461538464`, 0.38461538461538464`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[7, 13], -1}, {
         Rational[7, 13], Rational[5, 13], -1}, {
         Rational[5, 13], Rational[5, 13], -1}, {
         Rational[5, 13], Rational[7, 13], -1}}, {{
         0.5384615384615384, 0.5384615384615384, -1}, {
         0.5384615384615384, 0.38461538461538464`, -1}, {
         0.38461538461538464`, 0.38461538461538464`, -1}, {
         0.38461538461538464`, 0.5384615384615384, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[9, 13], -1}, {
         Rational[7, 13], Rational[7, 13], -1}, {
         Rational[5, 13], Rational[7, 13], -1}, {
         Rational[5, 13], Rational[9, 13], -1}}, {{
         0.5384615384615384, 0.6923076923076923, -1}, {
         0.5384615384615384, 0.5384615384615384, -1}, {
         0.38461538461538464`, 0.5384615384615384, -1}, {
         0.38461538461538464`, 0.6923076923076923, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[11, 13], -1}, {
         Rational[7, 13], Rational[9, 13], -1}, {
         Rational[5, 13], Rational[9, 13], -1}, {
         Rational[5, 13], Rational[11, 13], -1}}, {{
         0.5384615384615384, 0.8461538461538461, -1}, {
         0.5384615384615384, 0.6923076923076923, -1}, {
         0.38461538461538464`, 0.6923076923076923, -1}, {
         0.38461538461538464`, 0.8461538461538461, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], 1, -1}, {
         Rational[7, 13], Rational[11, 13], -1}, {
         Rational[5, 13], Rational[11, 13], -1}, {Rational[5, 13], 1, -1}}, {{
         0.5384615384615384, 1, -1}, {
         0.5384615384615384, 0.8461538461538461, -1}, {
         0.38461538461538464`, 0.8461538461538461, -1}, {
         0.38461538461538464`, 1, -1}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[-11, 13], -1}, {
         Rational[9, 13], -1, -1}, {Rational[7, 13], -1, -1}, {
         Rational[7, 13], Rational[-11, 13], -1}}, {{
         0.6923076923076923, -0.8461538461538461, -1}, {
         0.6923076923076923, -1, -1}, {0.5384615384615384, -1, -1}, {
         0.5384615384615384, -0.8461538461538461, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[-9, 13], -1}, {
         Rational[9, 13], Rational[-11, 13], -1}, {
         Rational[7, 13], Rational[-11, 13], -1}, {
         Rational[7, 13], Rational[-9, 13], -1}}, {{
         0.6923076923076923, -0.6923076923076923, -1}, {
         0.6923076923076923, -0.8461538461538461, -1}, {
         0.5384615384615384, -0.8461538461538461, -1}, {
         0.5384615384615384, -0.6923076923076923, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[-7, 13], -1}, {
         Rational[9, 13], Rational[-9, 13], -1}, {
         Rational[7, 13], Rational[-9, 13], -1}, {
         Rational[7, 13], Rational[-7, 13], -1}}, {{
         0.6923076923076923, -0.5384615384615384, -1}, {
         0.6923076923076923, -0.6923076923076923, -1}, {
         0.5384615384615384, -0.6923076923076923, -1}, {
         0.5384615384615384, -0.5384615384615384, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[-5, 13], -1}, {
         Rational[9, 13], Rational[-7, 13], -1}, {
         Rational[7, 13], Rational[-7, 13], -1}, {
         Rational[7, 13], Rational[-5, 13], -1}}, {{
         0.6923076923076923, -0.38461538461538464`, -1}, {
         0.6923076923076923, -0.5384615384615384, -1}, {
         0.5384615384615384, -0.5384615384615384, -1}, {
         0.5384615384615384, -0.38461538461538464`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[-3, 13], -1}, {
         Rational[9, 13], Rational[-5, 13], -1}, {
         Rational[7, 13], Rational[-5, 13], -1}, {
         Rational[7, 13], Rational[-3, 13], -1}}, {{
         0.6923076923076923, -0.23076923076923078`, -1}, {
         0.6923076923076923, -0.38461538461538464`, -1}, {
         0.5384615384615384, -0.38461538461538464`, -1}, {
         0.5384615384615384, -0.23076923076923078`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[-1, 13], -1}, {
         Rational[9, 13], Rational[-3, 13], -1}, {
         Rational[7, 13], Rational[-3, 13], -1}, {
         Rational[7, 13], Rational[-1, 13], -1}}, {{
         0.6923076923076923, -0.07692307692307693, -1}, {
         0.6923076923076923, -0.23076923076923078`, -1}, {
         0.5384615384615384, -0.23076923076923078`, -1}, {
         0.5384615384615384, -0.07692307692307693, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[1, 13], -1}, {
         Rational[9, 13], Rational[-1, 13], -1}, {
         Rational[7, 13], Rational[-1, 13], -1}, {
         Rational[7, 13], Rational[1, 13], -1}}, {{
         0.6923076923076923, 0.07692307692307693, -1}, {
         0.6923076923076923, -0.07692307692307693, -1}, {
         0.5384615384615384, -0.07692307692307693, -1}, {
         0.5384615384615384, 0.07692307692307693, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[3, 13], -1}, {
         Rational[9, 13], Rational[1, 13], -1}, {
         Rational[7, 13], Rational[1, 13], -1}, {
         Rational[7, 13], Rational[3, 13], -1}}, {{
         0.6923076923076923, 0.23076923076923078`, -1}, {
         0.6923076923076923, 0.07692307692307693, -1}, {
         0.5384615384615384, 0.07692307692307693, -1}, {
         0.5384615384615384, 0.23076923076923078`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[5, 13], -1}, {
         Rational[9, 13], Rational[3, 13], -1}, {
         Rational[7, 13], Rational[3, 13], -1}, {
         Rational[7, 13], Rational[5, 13], -1}}, {{
         0.6923076923076923, 0.38461538461538464`, -1}, {
         0.6923076923076923, 0.23076923076923078`, -1}, {
         0.5384615384615384, 0.23076923076923078`, -1}, {
         0.5384615384615384, 0.38461538461538464`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[7, 13], -1}, {
         Rational[9, 13], Rational[5, 13], -1}, {
         Rational[7, 13], Rational[5, 13], -1}, {
         Rational[7, 13], Rational[7, 13], -1}}, {{
         0.6923076923076923, 0.5384615384615384, -1}, {
         0.6923076923076923, 0.38461538461538464`, -1}, {
         0.5384615384615384, 0.38461538461538464`, -1}, {
         0.5384615384615384, 0.5384615384615384, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[9, 13], -1}, {
         Rational[9, 13], Rational[7, 13], -1}, {
         Rational[7, 13], Rational[7, 13], -1}, {
         Rational[7, 13], Rational[9, 13], -1}}, {{
         0.6923076923076923, 0.6923076923076923, -1}, {
         0.6923076923076923, 0.5384615384615384, -1}, {
         0.5384615384615384, 0.5384615384615384, -1}, {
         0.5384615384615384, 0.6923076923076923, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[11, 13], -1}, {
         Rational[9, 13], Rational[9, 13], -1}, {
         Rational[7, 13], Rational[9, 13], -1}, {
         Rational[7, 13], Rational[11, 13], -1}}, {{
         0.6923076923076923, 0.8461538461538461, -1}, {
         0.6923076923076923, 0.6923076923076923, -1}, {
         0.5384615384615384, 0.6923076923076923, -1}, {
         0.5384615384615384, 0.8461538461538461, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], 1, -1}, {
         Rational[9, 13], Rational[11, 13], -1}, {
         Rational[7, 13], Rational[11, 13], -1}, {Rational[7, 13], 1, -1}}, {{
         0.6923076923076923, 1, -1}, {
         0.6923076923076923, 0.8461538461538461, -1}, {
         0.5384615384615384, 0.8461538461538461, -1}, {
         0.5384615384615384, 1, -1}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[-11, 13], -1}, {
         Rational[11, 13], -1, -1}, {Rational[9, 13], -1, -1}, {
         Rational[9, 13], Rational[-11, 13], -1}}, {{
         0.8461538461538461, -0.8461538461538461, -1}, {
         0.8461538461538461, -1, -1}, {0.6923076923076923, -1, -1}, {
         0.6923076923076923, -0.8461538461538461, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[-9, 13], -1}, {
         Rational[11, 13], Rational[-11, 13], -1}, {
         Rational[9, 13], Rational[-11, 13], -1}, {
         Rational[9, 13], Rational[-9, 13], -1}}, {{
         0.8461538461538461, -0.6923076923076923, -1}, {
         0.8461538461538461, -0.8461538461538461, -1}, {
         0.6923076923076923, -0.8461538461538461, -1}, {
         0.6923076923076923, -0.6923076923076923, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[-7, 13], -1}, {
         Rational[11, 13], Rational[-9, 13], -1}, {
         Rational[9, 13], Rational[-9, 13], -1}, {
         Rational[9, 13], Rational[-7, 13], -1}}, {{
         0.8461538461538461, -0.5384615384615384, -1}, {
         0.8461538461538461, -0.6923076923076923, -1}, {
         0.6923076923076923, -0.6923076923076923, -1}, {
         0.6923076923076923, -0.5384615384615384, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[-5, 13], -1}, {
         Rational[11, 13], Rational[-7, 13], -1}, {
         Rational[9, 13], Rational[-7, 13], -1}, {
         Rational[9, 13], Rational[-5, 13], -1}}, {{
         0.8461538461538461, -0.38461538461538464`, -1}, {
         0.8461538461538461, -0.5384615384615384, -1}, {
         0.6923076923076923, -0.5384615384615384, -1}, {
         0.6923076923076923, -0.38461538461538464`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[-3, 13], -1}, {
         Rational[11, 13], Rational[-5, 13], -1}, {
         Rational[9, 13], Rational[-5, 13], -1}, {
         Rational[9, 13], Rational[-3, 13], -1}}, {{
         0.8461538461538461, -0.23076923076923078`, -1}, {
         0.8461538461538461, -0.38461538461538464`, -1}, {
         0.6923076923076923, -0.38461538461538464`, -1}, {
         0.6923076923076923, -0.23076923076923078`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[-1, 13], -1}, {
         Rational[11, 13], Rational[-3, 13], -1}, {
         Rational[9, 13], Rational[-3, 13], -1}, {
         Rational[9, 13], Rational[-1, 13], -1}}, {{
         0.8461538461538461, -0.07692307692307693, -1}, {
         0.8461538461538461, -0.23076923076923078`, -1}, {
         0.6923076923076923, -0.23076923076923078`, -1}, {
         0.6923076923076923, -0.07692307692307693, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[1, 13], -1}, {
         Rational[11, 13], Rational[-1, 13], -1}, {
         Rational[9, 13], Rational[-1, 13], -1}, {
         Rational[9, 13], Rational[1, 13], -1}}, {{
         0.8461538461538461, 0.07692307692307693, -1}, {
         0.8461538461538461, -0.07692307692307693, -1}, {
         0.6923076923076923, -0.07692307692307693, -1}, {
         0.6923076923076923, 0.07692307692307693, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[3, 13], -1}, {
         Rational[11, 13], Rational[1, 13], -1}, {
         Rational[9, 13], Rational[1, 13], -1}, {
         Rational[9, 13], Rational[3, 13], -1}}, {{
         0.8461538461538461, 0.23076923076923078`, -1}, {
         0.8461538461538461, 0.07692307692307693, -1}, {
         0.6923076923076923, 0.07692307692307693, -1}, {
         0.6923076923076923, 0.23076923076923078`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[5, 13], -1}, {
         Rational[11, 13], Rational[3, 13], -1}, {
         Rational[9, 13], Rational[3, 13], -1}, {
         Rational[9, 13], Rational[5, 13], -1}}, {{
         0.8461538461538461, 0.38461538461538464`, -1}, {
         0.8461538461538461, 0.23076923076923078`, -1}, {
         0.6923076923076923, 0.23076923076923078`, -1}, {
         0.6923076923076923, 0.38461538461538464`, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[7, 13], -1}, {
         Rational[11, 13], Rational[5, 13], -1}, {
         Rational[9, 13], Rational[5, 13], -1}, {
         Rational[9, 13], Rational[7, 13], -1}}, {{
         0.8461538461538461, 0.5384615384615384, -1}, {
         0.8461538461538461, 0.38461538461538464`, -1}, {
         0.6923076923076923, 0.38461538461538464`, -1}, {
         0.6923076923076923, 0.5384615384615384, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[9, 13], -1}, {
         Rational[11, 13], Rational[7, 13], -1}, {
         Rational[9, 13], Rational[7, 13], -1}, {
         Rational[9, 13], Rational[9, 13], -1}}, {{
         0.8461538461538461, 0.6923076923076923, -1}, {
         0.8461538461538461, 0.5384615384615384, -1}, {
         0.6923076923076923, 0.5384615384615384, -1}, {
         0.6923076923076923, 0.6923076923076923, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[11, 13], -1}, {
         Rational[11, 13], Rational[9, 13], -1}, {
         Rational[9, 13], Rational[9, 13], -1}, {
         Rational[9, 13], Rational[11, 13], -1}}, {{
         0.8461538461538461, 0.8461538461538461, -1}, {
         0.8461538461538461, 0.6923076923076923, -1}, {
         0.6923076923076923, 0.6923076923076923, -1}, {
         0.6923076923076923, 0.8461538461538461, -1}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], 1, -1}, {
         Rational[11, 13], Rational[11, 13], -1}, {
         Rational[9, 13], Rational[11, 13], -1}, {Rational[9, 13], 1, -1}}, {{
         0.8461538461538461, 1, -1}, {
         0.8461538461538461, 0.8461538461538461, -1}, {
         0.6923076923076923, 0.8461538461538461, -1}, {
         0.6923076923076923, 1, -1}}]]}, {
      Polygon3DBox[
       NCache[{{1, Rational[-11, 13], -1}, {1, -1, -1}, {
         Rational[11, 13], -1, -1}, {
         Rational[11, 13], Rational[-11, 13], -1}}, {{
         1, -0.8461538461538461, -1}, {1, -1, -1}, {
         0.8461538461538461, -1, -1}, {
         0.8461538461538461, -0.8461538461538461, -1}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[-9, 13], -1}, {1, Rational[-11, 13], -1}, {
         Rational[11, 13], Rational[-11, 13], -1}, {
         Rational[11, 13], Rational[-9, 13], -1}}, {{
         1, -0.6923076923076923, -1}, {1, -0.8461538461538461, -1}, {
         0.8461538461538461, -0.8461538461538461, -1}, {
         0.8461538461538461, -0.6923076923076923, -1}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[-7, 13], -1}, {1, Rational[-9, 13], -1}, {
         Rational[11, 13], Rational[-9, 13], -1}, {
         Rational[11, 13], Rational[-7, 13], -1}}, {{
         1, -0.5384615384615384, -1}, {1, -0.6923076923076923, -1}, {
         0.8461538461538461, -0.6923076923076923, -1}, {
         0.8461538461538461, -0.5384615384615384, -1}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[-5, 13], -1}, {1, Rational[-7, 13], -1}, {
         Rational[11, 13], Rational[-7, 13], -1}, {
         Rational[11, 13], Rational[-5, 13], -1}}, {{
         1, -0.38461538461538464`, -1}, {1, -0.5384615384615384, -1}, {
         0.8461538461538461, -0.5384615384615384, -1}, {
         0.8461538461538461, -0.38461538461538464`, -1}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[-3, 13], -1}, {1, Rational[-5, 13], -1}, {
         Rational[11, 13], Rational[-5, 13], -1}, {
         Rational[11, 13], Rational[-3, 13], -1}}, {{
         1, -0.23076923076923078`, -1}, {1, -0.38461538461538464`, -1}, {
         0.8461538461538461, -0.38461538461538464`, -1}, {
         0.8461538461538461, -0.23076923076923078`, -1}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[-1, 13], -1}, {1, Rational[-3, 13], -1}, {
         Rational[11, 13], Rational[-3, 13], -1}, {
         Rational[11, 13], Rational[-1, 13], -1}}, {{
         1, -0.07692307692307693, -1}, {1, -0.23076923076923078`, -1}, {
         0.8461538461538461, -0.23076923076923078`, -1}, {
         0.8461538461538461, -0.07692307692307693, -1}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[1, 13], -1}, {1, Rational[-1, 13], -1}, {
         Rational[11, 13], Rational[-1, 13], -1}, {
         Rational[11, 13], Rational[1, 13], -1}}, {{
         1, 0.07692307692307693, -1}, {1, -0.07692307692307693, -1}, {
         0.8461538461538461, -0.07692307692307693, -1}, {
         0.8461538461538461, 0.07692307692307693, -1}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[3, 13], -1}, {1, Rational[1, 13], -1}, {
         Rational[11, 13], Rational[1, 13], -1}, {
         Rational[11, 13], Rational[3, 13], -1}}, {{
         1, 0.23076923076923078`, -1}, {1, 0.07692307692307693, -1}, {
         0.8461538461538461, 0.07692307692307693, -1}, {
         0.8461538461538461, 0.23076923076923078`, -1}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[5, 13], -1}, {1, Rational[3, 13], -1}, {
         Rational[11, 13], Rational[3, 13], -1}, {
         Rational[11, 13], Rational[5, 13], -1}}, {{
         1, 0.38461538461538464`, -1}, {1, 0.23076923076923078`, -1}, {
         0.8461538461538461, 0.23076923076923078`, -1}, {
         0.8461538461538461, 0.38461538461538464`, -1}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[7, 13], -1}, {1, Rational[5, 13], -1}, {
         Rational[11, 13], Rational[5, 13], -1}, {
         Rational[11, 13], Rational[7, 13], -1}}, {{
         1, 0.5384615384615384, -1}, {1, 0.38461538461538464`, -1}, {
         0.8461538461538461, 0.38461538461538464`, -1}, {
         0.8461538461538461, 0.5384615384615384, -1}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[9, 13], -1}, {1, Rational[7, 13], -1}, {
         Rational[11, 13], Rational[7, 13], -1}, {
         Rational[11, 13], Rational[9, 13], -1}}, {{
         1, 0.6923076923076923, -1}, {1, 0.5384615384615384, -1}, {
         0.8461538461538461, 0.5384615384615384, -1}, {
         0.8461538461538461, 0.6923076923076923, -1}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[11, 13], -1}, {1, Rational[9, 13], -1}, {
         Rational[11, 13], Rational[9, 13], -1}, {
         Rational[11, 13], Rational[11, 13], -1}}, {{
         1, 0.8461538461538461, -1}, {1, 0.6923076923076923, -1}, {
         0.8461538461538461, 0.6923076923076923, -1}, {
         0.8461538461538461, 0.8461538461538461, -1}}]], 
      Polygon3DBox[
       NCache[{{1, 1, -1}, {1, Rational[11, 13], -1}, {
         Rational[11, 13], Rational[11, 13], -1}, {
         Rational[11, 13], 1, -1}}, {{1, 1, -1}, {
         1, 0.8461538461538461, -1}, {
         0.8461538461538461, 0.8461538461538461, -1}, {
         0.8461538461538461, 1, -1}}]]}}, 
    {EdgeForm[GrayLevel[
     0.5]], {Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[-11, 13], Rational[217, 338]}, {
         Rational[-11, 13], -1, Rational[193, 338]}, {-1, -1, Rational[
          1, 2]}, {-1, Rational[-11, 13], Rational[
          193, 338]}}, {{-0.8461538461538461, -0.8461538461538461, 
         0.6420118343195266}, {-0.8461538461538461, -1, 
          0.5710059171597633}, {-1, -1, 0.5}, {-1, -0.8461538461538461, 
          0.5710059171597633}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[-9, 13], Rational[237, 338]}, {
         Rational[-11, 13], Rational[-11, 13], Rational[217, 338]}, {-1, 
          Rational[-11, 13], Rational[193, 338]}, {-1, Rational[-9, 13], 
          Rational[213, 338]}}, {{-0.8461538461538461, -0.6923076923076923, 
         0.7011834319526628}, {-0.8461538461538461, -0.8461538461538461, 
         0.6420118343195266}, {-1, -0.8461538461538461, 
          0.5710059171597633}, {-1, -0.6923076923076923, 
          0.6301775147928994}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[-7, 13], Rational[253, 338]}, {
         Rational[-11, 13], Rational[-9, 13], Rational[237, 338]}, {-1, 
          Rational[-9, 13], Rational[213, 338]}, {-1, Rational[-7, 13], 
          Rational[229, 338]}}, {{-0.8461538461538461, -0.5384615384615384, 
         0.7485207100591716}, {-0.8461538461538461, -0.6923076923076923, 
         0.7011834319526628}, {-1, -0.6923076923076923, 
          0.6301775147928994}, {-1, -0.5384615384615384, 
          0.6775147928994083}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[-5, 13], Rational[265, 338]}, {
         Rational[-11, 13], Rational[-7, 13], Rational[253, 338]}, {-1, 
          Rational[-7, 13], Rational[229, 338]}, {-1, Rational[-5, 13], 
          Rational[241, 338]}}, {{-0.8461538461538461, -0.38461538461538464`, 
         0.7840236686390533}, {-0.8461538461538461, -0.5384615384615384, 
         0.7485207100591716}, {-1, -0.5384615384615384, 
          0.6775147928994083}, {-1, -0.38461538461538464`, 
          0.7130177514792899}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[-3, 13], Rational[21, 26]}, {
         Rational[-11, 13], Rational[-5, 13], Rational[265, 338]}, {-1, 
          Rational[-5, 13], Rational[241, 338]}, {-1, Rational[-3, 13], 
          Rational[249, 338]}}, {{-0.8461538461538461, -0.23076923076923078`, 
         0.8076923076923077}, {-0.8461538461538461, -0.38461538461538464`, 
         0.7840236686390533}, {-1, -0.38461538461538464`, 
          0.7130177514792899}, {-1, -0.23076923076923078`, 
          0.7366863905325444}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[-1, 13], Rational[277, 338]}, {
         Rational[-11, 13], Rational[-3, 13], Rational[21, 26]}, {-1, 
          Rational[-3, 13], Rational[249, 338]}, {-1, Rational[-1, 13], 
          Rational[253, 338]}}, {{-0.8461538461538461, -0.07692307692307693, 
         0.8195266272189349}, {-0.8461538461538461, -0.23076923076923078`, 
         0.8076923076923077}, {-1, -0.23076923076923078`, 
          0.7366863905325444}, {-1, -0.07692307692307693, 
          0.7485207100591716}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[1, 13], Rational[277, 338]}, {
         Rational[-11, 13], Rational[-1, 13], Rational[277, 338]}, {-1, 
          Rational[-1, 13], Rational[253, 338]}, {-1, Rational[1, 13], 
          Rational[253, 338]}}, {{-0.8461538461538461, 0.07692307692307693, 
         0.8195266272189349}, {-0.8461538461538461, -0.07692307692307693, 
         0.8195266272189349}, {-1, -0.07692307692307693, 
          0.7485207100591716}, {-1, 0.07692307692307693, 
          0.7485207100591716}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[3, 13], Rational[21, 26]}, {
         Rational[-11, 13], Rational[1, 13], Rational[277, 338]}, {-1, 
          Rational[1, 13], Rational[253, 338]}, {-1, Rational[3, 13], 
          Rational[249, 338]}}, {{-0.8461538461538461, 0.23076923076923078`, 
         0.8076923076923077}, {-0.8461538461538461, 0.07692307692307693, 
         0.8195266272189349}, {-1, 0.07692307692307693, 
          0.7485207100591716}, {-1, 0.23076923076923078`, 
          0.7366863905325444}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[5, 13], Rational[265, 338]}, {
         Rational[-11, 13], Rational[3, 13], Rational[21, 26]}, {-1, Rational[
          3, 13], Rational[249, 338]}, {-1, Rational[5, 13], Rational[
          241, 338]}}, {{-0.8461538461538461, 0.38461538461538464`, 
         0.7840236686390533}, {-0.8461538461538461, 0.23076923076923078`, 
         0.8076923076923077}, {-1, 0.23076923076923078`, 
          0.7366863905325444}, {-1, 0.38461538461538464`, 
          0.7130177514792899}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[7, 13], Rational[253, 338]}, {
         Rational[-11, 13], Rational[5, 13], Rational[265, 338]}, {-1, 
          Rational[5, 13], Rational[241, 338]}, {-1, Rational[7, 13], 
          Rational[229, 338]}}, {{-0.8461538461538461, 0.5384615384615384, 
         0.7485207100591716}, {-0.8461538461538461, 0.38461538461538464`, 
         0.7840236686390533}, {-1, 0.38461538461538464`, 
          0.7130177514792899}, {-1, 0.5384615384615384, 
          0.6775147928994083}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[9, 13], Rational[237, 338]}, {
         Rational[-11, 13], Rational[7, 13], Rational[253, 338]}, {-1, 
          Rational[7, 13], Rational[229, 338]}, {-1, Rational[9, 13], 
          Rational[213, 338]}}, {{-0.8461538461538461, 0.6923076923076923, 
         0.7011834319526628}, {-0.8461538461538461, 0.5384615384615384, 
         0.7485207100591716}, {-1, 0.5384615384615384, 
          0.6775147928994083}, {-1, 0.6923076923076923, 
          0.6301775147928994}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[11, 13], Rational[217, 338]}, {
         Rational[-11, 13], Rational[9, 13], Rational[237, 338]}, {-1, 
          Rational[9, 13], Rational[213, 338]}, {-1, Rational[11, 13], 
          Rational[193, 338]}}, {{-0.8461538461538461, 0.8461538461538461, 
         0.6420118343195266}, {-0.8461538461538461, 0.6923076923076923, 
         0.7011834319526628}, {-1, 0.6923076923076923, 
          0.6301775147928994}, {-1, 0.8461538461538461, 
          0.5710059171597633}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], 1, Rational[193, 338]}, {
         Rational[-11, 13], Rational[11, 13], Rational[217, 338]}, {-1, 
          Rational[11, 13], Rational[193, 338]}, {-1, 1, Rational[
          1, 2]}}, {{-0.8461538461538461, 1, 
          0.5710059171597633}, {-0.8461538461538461, 0.8461538461538461, 
         0.6420118343195266}, {-1, 0.8461538461538461, 
          0.5710059171597633}, {-1, 1, 0.5}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[-11, 13], Rational[237, 338]}, {
         Rational[-9, 13], -1, Rational[213, 338]}, {
         Rational[-11, 13], -1, Rational[193, 338]}, {
         Rational[-11, 13], Rational[-11, 13], Rational[
          217, 338]}}, {{-0.6923076923076923, -0.8461538461538461, 
         0.7011834319526628}, {-0.6923076923076923, -1, 
          0.6301775147928994}, {-0.8461538461538461, -1, 
          0.5710059171597633}, {-0.8461538461538461, -0.8461538461538461, 
         0.6420118343195266}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[-9, 13], Rational[257, 338]}, {
         Rational[-9, 13], Rational[-11, 13], Rational[237, 338]}, {
         Rational[-11, 13], Rational[-11, 13], Rational[217, 338]}, {
         Rational[-11, 13], Rational[-9, 13], Rational[
          237, 338]}}, {{-0.6923076923076923, -0.6923076923076923, 
        0.7603550295857988}, {-0.6923076923076923, -0.8461538461538461, 
        0.7011834319526628}, {-0.8461538461538461, -0.8461538461538461, 
        0.6420118343195266}, {-0.8461538461538461, -0.6923076923076923, 
        0.7011834319526628}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[-7, 13], Rational[21, 26]}, {
         Rational[-9, 13], Rational[-9, 13], Rational[257, 338]}, {
         Rational[-11, 13], Rational[-9, 13], Rational[237, 338]}, {
         Rational[-11, 13], Rational[-7, 13], Rational[
          253, 338]}}, {{-0.6923076923076923, -0.5384615384615384, 
        0.8076923076923077}, {-0.6923076923076923, -0.6923076923076923, 
        0.7603550295857988}, {-0.8461538461538461, -0.6923076923076923, 
        0.7011834319526628}, {-0.8461538461538461, -0.5384615384615384, 
        0.7485207100591716}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[-5, 13], Rational[285, 338]}, {
         Rational[-9, 13], Rational[-7, 13], Rational[21, 26]}, {
         Rational[-11, 13], Rational[-7, 13], Rational[253, 338]}, {
         Rational[-11, 13], Rational[-5, 13], Rational[
          265, 338]}}, {{-0.6923076923076923, -0.38461538461538464`, 
        0.8431952662721893}, {-0.6923076923076923, -0.5384615384615384, 
        0.8076923076923077}, {-0.8461538461538461, -0.5384615384615384, 
        0.7485207100591716}, {-0.8461538461538461, -0.38461538461538464`, 
        0.7840236686390533}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[-3, 13], Rational[293, 338]}, {
         Rational[-9, 13], Rational[-5, 13], Rational[285, 338]}, {
         Rational[-11, 13], Rational[-5, 13], Rational[265, 338]}, {
         Rational[-11, 13], Rational[-3, 13], Rational[
          21, 26]}}, {{-0.6923076923076923, -0.23076923076923078`, 
        0.8668639053254438}, {-0.6923076923076923, -0.38461538461538464`, 
        0.8431952662721893}, {-0.8461538461538461, -0.38461538461538464`, 
        0.7840236686390533}, {-0.8461538461538461, -0.23076923076923078`, 
        0.8076923076923077}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[-1, 13], Rational[297, 338]}, {
         Rational[-9, 13], Rational[-3, 13], Rational[293, 338]}, {
         Rational[-11, 13], Rational[-3, 13], Rational[21, 26]}, {
         Rational[-11, 13], Rational[-1, 13], Rational[
          277, 338]}}, {{-0.6923076923076923, -0.07692307692307693, 
        0.878698224852071}, {-0.6923076923076923, -0.23076923076923078`, 
        0.8668639053254438}, {-0.8461538461538461, -0.23076923076923078`, 
        0.8076923076923077}, {-0.8461538461538461, -0.07692307692307693, 
        0.8195266272189349}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[1, 13], Rational[297, 338]}, {
         Rational[-9, 13], Rational[-1, 13], Rational[297, 338]}, {
         Rational[-11, 13], Rational[-1, 13], Rational[277, 338]}, {
         Rational[-11, 13], Rational[1, 13], Rational[
          277, 338]}}, {{-0.6923076923076923, 0.07692307692307693, 
        0.878698224852071}, {-0.6923076923076923, -0.07692307692307693, 
        0.878698224852071}, {-0.8461538461538461, -0.07692307692307693, 
        0.8195266272189349}, {-0.8461538461538461, 0.07692307692307693, 
        0.8195266272189349}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[3, 13], Rational[293, 338]}, {
         Rational[-9, 13], Rational[1, 13], Rational[297, 338]}, {
         Rational[-11, 13], Rational[1, 13], Rational[277, 338]}, {
         Rational[-11, 13], Rational[3, 13], Rational[
          21, 26]}}, {{-0.6923076923076923, 0.23076923076923078`, 
        0.8668639053254438}, {-0.6923076923076923, 0.07692307692307693, 
        0.878698224852071}, {-0.8461538461538461, 0.07692307692307693, 
        0.8195266272189349}, {-0.8461538461538461, 0.23076923076923078`, 
        0.8076923076923077}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[5, 13], Rational[285, 338]}, {
         Rational[-9, 13], Rational[3, 13], Rational[293, 338]}, {
         Rational[-11, 13], Rational[3, 13], Rational[21, 26]}, {
         Rational[-11, 13], Rational[5, 13], Rational[
          265, 338]}}, {{-0.6923076923076923, 0.38461538461538464`, 
        0.8431952662721893}, {-0.6923076923076923, 0.23076923076923078`, 
        0.8668639053254438}, {-0.8461538461538461, 0.23076923076923078`, 
        0.8076923076923077}, {-0.8461538461538461, 0.38461538461538464`, 
        0.7840236686390533}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[7, 13], Rational[21, 26]}, {
         Rational[-9, 13], Rational[5, 13], Rational[285, 338]}, {
         Rational[-11, 13], Rational[5, 13], Rational[265, 338]}, {
         Rational[-11, 13], Rational[7, 13], Rational[
          253, 338]}}, {{-0.6923076923076923, 0.5384615384615384, 
        0.8076923076923077}, {-0.6923076923076923, 0.38461538461538464`, 
        0.8431952662721893}, {-0.8461538461538461, 0.38461538461538464`, 
        0.7840236686390533}, {-0.8461538461538461, 0.5384615384615384, 
        0.7485207100591716}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[9, 13], Rational[257, 338]}, {
         Rational[-9, 13], Rational[7, 13], Rational[21, 26]}, {
         Rational[-11, 13], Rational[7, 13], Rational[253, 338]}, {
         Rational[-11, 13], Rational[9, 13], Rational[
          237, 338]}}, {{-0.6923076923076923, 0.6923076923076923, 
        0.7603550295857988}, {-0.6923076923076923, 0.5384615384615384, 
        0.8076923076923077}, {-0.8461538461538461, 0.5384615384615384, 
        0.7485207100591716}, {-0.8461538461538461, 0.6923076923076923, 
        0.7011834319526628}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[11, 13], Rational[237, 338]}, {
         Rational[-9, 13], Rational[9, 13], Rational[257, 338]}, {
         Rational[-11, 13], Rational[9, 13], Rational[237, 338]}, {
         Rational[-11, 13], Rational[11, 13], Rational[
          217, 338]}}, {{-0.6923076923076923, 0.8461538461538461, 
        0.7011834319526628}, {-0.6923076923076923, 0.6923076923076923, 
        0.7603550295857988}, {-0.8461538461538461, 0.6923076923076923, 
        0.7011834319526628}, {-0.8461538461538461, 0.8461538461538461, 
        0.6420118343195266}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], 1, Rational[213, 338]}, {
         Rational[-9, 13], Rational[11, 13], Rational[237, 338]}, {
         Rational[-11, 13], Rational[11, 13], Rational[217, 338]}, {
         Rational[-11, 13], 1, Rational[193, 338]}}, {{-0.6923076923076923, 1,
           0.6301775147928994}, {-0.6923076923076923, 0.8461538461538461, 
         0.7011834319526628}, {-0.8461538461538461, 0.8461538461538461, 
         0.6420118343195266}, {-0.8461538461538461, 1, 
          0.5710059171597633}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[-11, 13], Rational[253, 338]}, {
         Rational[-7, 13], -1, Rational[229, 338]}, {
         Rational[-9, 13], -1, Rational[213, 338]}, {
         Rational[-9, 13], Rational[-11, 13], Rational[
          237, 338]}}, {{-0.5384615384615384, -0.8461538461538461, 
         0.7485207100591716}, {-0.5384615384615384, -1, 
          0.6775147928994083}, {-0.6923076923076923, -1, 
          0.6301775147928994}, {-0.6923076923076923, -0.8461538461538461, 
         0.7011834319526628}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[-9, 13], Rational[21, 26]}, {
         Rational[-7, 13], Rational[-11, 13], Rational[253, 338]}, {
         Rational[-9, 13], Rational[-11, 13], Rational[237, 338]}, {
         Rational[-9, 13], Rational[-9, 13], Rational[
          257, 338]}}, {{-0.5384615384615384, -0.6923076923076923, 
        0.8076923076923077}, {-0.5384615384615384, -0.8461538461538461, 
        0.7485207100591716}, {-0.6923076923076923, -0.8461538461538461, 
        0.7011834319526628}, {-0.6923076923076923, -0.6923076923076923, 
        0.7603550295857988}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[-7, 13], Rational[289, 338]}, {
         Rational[-7, 13], Rational[-9, 13], Rational[21, 26]}, {
         Rational[-9, 13], Rational[-9, 13], Rational[257, 338]}, {
         Rational[-9, 13], Rational[-7, 13], Rational[
          21, 26]}}, {{-0.5384615384615384, -0.5384615384615384, 
        0.8550295857988166}, {-0.5384615384615384, -0.6923076923076923, 
        0.8076923076923077}, {-0.6923076923076923, -0.6923076923076923, 
        0.7603550295857988}, {-0.6923076923076923, -0.5384615384615384, 
        0.8076923076923077}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[-5, 13], Rational[301, 338]}, {
         Rational[-7, 13], Rational[-7, 13], Rational[289, 338]}, {
         Rational[-9, 13], Rational[-7, 13], Rational[21, 26]}, {
         Rational[-9, 13], Rational[-5, 13], Rational[
          285, 338]}}, {{-0.5384615384615384, -0.38461538461538464`, 
        0.8905325443786982}, {-0.5384615384615384, -0.5384615384615384, 
        0.8550295857988166}, {-0.6923076923076923, -0.5384615384615384, 
        0.8076923076923077}, {-0.6923076923076923, -0.38461538461538464`, 
        0.8431952662721893}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[-3, 13], Rational[309, 338]}, {
         Rational[-7, 13], Rational[-5, 13], Rational[301, 338]}, {
         Rational[-9, 13], Rational[-5, 13], Rational[285, 338]}, {
         Rational[-9, 13], Rational[-3, 13], Rational[
          293, 338]}}, {{-0.5384615384615384, -0.23076923076923078`, 
        0.9142011834319527}, {-0.5384615384615384, -0.38461538461538464`, 
        0.8905325443786982}, {-0.6923076923076923, -0.38461538461538464`, 
        0.8431952662721893}, {-0.6923076923076923, -0.23076923076923078`, 
        0.8668639053254438}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[-1, 13], Rational[313, 338]}, {
         Rational[-7, 13], Rational[-3, 13], Rational[309, 338]}, {
         Rational[-9, 13], Rational[-3, 13], Rational[293, 338]}, {
         Rational[-9, 13], Rational[-1, 13], Rational[
          297, 338]}}, {{-0.5384615384615384, -0.07692307692307693, 
        0.9260355029585798}, {-0.5384615384615384, -0.23076923076923078`, 
        0.9142011834319527}, {-0.6923076923076923, -0.23076923076923078`, 
        0.8668639053254438}, {-0.6923076923076923, -0.07692307692307693, 
        0.878698224852071}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[1, 13], Rational[313, 338]}, {
         Rational[-7, 13], Rational[-1, 13], Rational[313, 338]}, {
         Rational[-9, 13], Rational[-1, 13], Rational[297, 338]}, {
         Rational[-9, 13], Rational[1, 13], Rational[
          297, 338]}}, {{-0.5384615384615384, 0.07692307692307693, 
        0.9260355029585798}, {-0.5384615384615384, -0.07692307692307693, 
        0.9260355029585798}, {-0.6923076923076923, -0.07692307692307693, 
        0.878698224852071}, {-0.6923076923076923, 0.07692307692307693, 
        0.878698224852071}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[3, 13], Rational[309, 338]}, {
         Rational[-7, 13], Rational[1, 13], Rational[313, 338]}, {
         Rational[-9, 13], Rational[1, 13], Rational[297, 338]}, {
         Rational[-9, 13], Rational[3, 13], Rational[
          293, 338]}}, {{-0.5384615384615384, 0.23076923076923078`, 
        0.9142011834319527}, {-0.5384615384615384, 0.07692307692307693, 
        0.9260355029585798}, {-0.6923076923076923, 0.07692307692307693, 
        0.878698224852071}, {-0.6923076923076923, 0.23076923076923078`, 
        0.8668639053254438}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[5, 13], Rational[301, 338]}, {
         Rational[-7, 13], Rational[3, 13], Rational[309, 338]}, {
         Rational[-9, 13], Rational[3, 13], Rational[293, 338]}, {
         Rational[-9, 13], Rational[5, 13], Rational[
          285, 338]}}, {{-0.5384615384615384, 0.38461538461538464`, 
        0.8905325443786982}, {-0.5384615384615384, 0.23076923076923078`, 
        0.9142011834319527}, {-0.6923076923076923, 0.23076923076923078`, 
        0.8668639053254438}, {-0.6923076923076923, 0.38461538461538464`, 
        0.8431952662721893}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[7, 13], Rational[289, 338]}, {
         Rational[-7, 13], Rational[5, 13], Rational[301, 338]}, {
         Rational[-9, 13], Rational[5, 13], Rational[285, 338]}, {
         Rational[-9, 13], Rational[7, 13], Rational[
          21, 26]}}, {{-0.5384615384615384, 0.5384615384615384, 
        0.8550295857988166}, {-0.5384615384615384, 0.38461538461538464`, 
        0.8905325443786982}, {-0.6923076923076923, 0.38461538461538464`, 
        0.8431952662721893}, {-0.6923076923076923, 0.5384615384615384, 
        0.8076923076923077}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[9, 13], Rational[21, 26]}, {
         Rational[-7, 13], Rational[7, 13], Rational[289, 338]}, {
         Rational[-9, 13], Rational[7, 13], Rational[21, 26]}, {
         Rational[-9, 13], Rational[9, 13], Rational[
          257, 338]}}, {{-0.5384615384615384, 0.6923076923076923, 
        0.8076923076923077}, {-0.5384615384615384, 0.5384615384615384, 
        0.8550295857988166}, {-0.6923076923076923, 0.5384615384615384, 
        0.8076923076923077}, {-0.6923076923076923, 0.6923076923076923, 
        0.7603550295857988}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[11, 13], Rational[253, 338]}, {
         Rational[-7, 13], Rational[9, 13], Rational[21, 26]}, {
         Rational[-9, 13], Rational[9, 13], Rational[257, 338]}, {
         Rational[-9, 13], Rational[11, 13], Rational[
          237, 338]}}, {{-0.5384615384615384, 0.8461538461538461, 
        0.7485207100591716}, {-0.5384615384615384, 0.6923076923076923, 
        0.8076923076923077}, {-0.6923076923076923, 0.6923076923076923, 
        0.7603550295857988}, {-0.6923076923076923, 0.8461538461538461, 
        0.7011834319526628}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], 1, Rational[229, 338]}, {
         Rational[-7, 13], Rational[11, 13], Rational[253, 338]}, {
         Rational[-9, 13], Rational[11, 13], Rational[237, 338]}, {
         Rational[-9, 13], 1, Rational[213, 338]}}, {{-0.5384615384615384, 1, 
          0.6775147928994083}, {-0.5384615384615384, 0.8461538461538461, 
         0.7485207100591716}, {-0.6923076923076923, 0.8461538461538461, 
         0.7011834319526628}, {-0.6923076923076923, 1, 
          0.6301775147928994}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[-11, 13], Rational[265, 338]}, {
         Rational[-5, 13], -1, Rational[241, 338]}, {
         Rational[-7, 13], -1, Rational[229, 338]}, {
         Rational[-7, 13], Rational[-11, 13], Rational[
          253, 338]}}, {{-0.38461538461538464`, -0.8461538461538461, 
         0.7840236686390533}, {-0.38461538461538464`, -1, 
          0.7130177514792899}, {-0.5384615384615384, -1, 
          0.6775147928994083}, {-0.5384615384615384, -0.8461538461538461, 
         0.7485207100591716}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[-9, 13], Rational[285, 338]}, {
         Rational[-5, 13], Rational[-11, 13], Rational[265, 338]}, {
         Rational[-7, 13], Rational[-11, 13], Rational[253, 338]}, {
         Rational[-7, 13], Rational[-9, 13], Rational[
          21, 26]}}, {{-0.38461538461538464`, -0.6923076923076923, 
        0.8431952662721893}, {-0.38461538461538464`, -0.8461538461538461, 
        0.7840236686390533}, {-0.5384615384615384, -0.8461538461538461, 
        0.7485207100591716}, {-0.5384615384615384, -0.6923076923076923, 
        0.8076923076923077}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[-7, 13], Rational[301, 338]}, {
         Rational[-5, 13], Rational[-9, 13], Rational[285, 338]}, {
         Rational[-7, 13], Rational[-9, 13], Rational[21, 26]}, {
         Rational[-7, 13], Rational[-7, 13], Rational[
          289, 338]}}, {{-0.38461538461538464`, -0.5384615384615384, 
        0.8905325443786982}, {-0.38461538461538464`, -0.6923076923076923, 
        0.8431952662721893}, {-0.5384615384615384, -0.6923076923076923, 
        0.8076923076923077}, {-0.5384615384615384, -0.5384615384615384, 
        0.8550295857988166}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[-5, 13], Rational[313, 338]}, {
         Rational[-5, 13], Rational[-7, 13], Rational[301, 338]}, {
         Rational[-7, 13], Rational[-7, 13], Rational[289, 338]}, {
         Rational[-7, 13], Rational[-5, 13], Rational[
          301, 338]}}, {{-0.38461538461538464`, -0.38461538461538464`, 
        0.9260355029585798}, {-0.38461538461538464`, -0.5384615384615384, 
        0.8905325443786982}, {-0.5384615384615384, -0.5384615384615384, 
        0.8550295857988166}, {-0.5384615384615384, -0.38461538461538464`, 
        0.8905325443786982}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[-3, 13], Rational[321, 338]}, {
         Rational[-5, 13], Rational[-5, 13], Rational[313, 338]}, {
         Rational[-7, 13], Rational[-5, 13], Rational[301, 338]}, {
         Rational[-7, 13], Rational[-3, 13], Rational[
          309, 338]}}, {{-0.38461538461538464`, -0.23076923076923078`, 
        0.9497041420118343}, {-0.38461538461538464`, -0.38461538461538464`, 
        0.9260355029585798}, {-0.5384615384615384, -0.38461538461538464`, 
        0.8905325443786982}, {-0.5384615384615384, -0.23076923076923078`, 
        0.9142011834319527}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[-1, 13], Rational[25, 26]}, {
         Rational[-5, 13], Rational[-3, 13], Rational[321, 338]}, {
         Rational[-7, 13], Rational[-3, 13], Rational[309, 338]}, {
         Rational[-7, 13], Rational[-1, 13], Rational[
          313, 338]}}, {{-0.38461538461538464`, -0.07692307692307693, 
        0.9615384615384616}, {-0.38461538461538464`, -0.23076923076923078`, 
        0.9497041420118343}, {-0.5384615384615384, -0.23076923076923078`, 
        0.9142011834319527}, {-0.5384615384615384, -0.07692307692307693, 
        0.9260355029585798}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[1, 13], Rational[25, 26]}, {
         Rational[-5, 13], Rational[-1, 13], Rational[25, 26]}, {
         Rational[-7, 13], Rational[-1, 13], Rational[313, 338]}, {
         Rational[-7, 13], Rational[1, 13], Rational[
          313, 338]}}, {{-0.38461538461538464`, 0.07692307692307693, 
        0.9615384615384616}, {-0.38461538461538464`, -0.07692307692307693, 
        0.9615384615384616}, {-0.5384615384615384, -0.07692307692307693, 
        0.9260355029585798}, {-0.5384615384615384, 0.07692307692307693, 
        0.9260355029585798}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[3, 13], Rational[321, 338]}, {
         Rational[-5, 13], Rational[1, 13], Rational[25, 26]}, {
         Rational[-7, 13], Rational[1, 13], Rational[313, 338]}, {
         Rational[-7, 13], Rational[3, 13], Rational[
          309, 338]}}, {{-0.38461538461538464`, 0.23076923076923078`, 
        0.9497041420118343}, {-0.38461538461538464`, 0.07692307692307693, 
        0.9615384615384616}, {-0.5384615384615384, 0.07692307692307693, 
        0.9260355029585798}, {-0.5384615384615384, 0.23076923076923078`, 
        0.9142011834319527}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[5, 13], Rational[313, 338]}, {
         Rational[-5, 13], Rational[3, 13], Rational[321, 338]}, {
         Rational[-7, 13], Rational[3, 13], Rational[309, 338]}, {
         Rational[-7, 13], Rational[5, 13], Rational[
          301, 338]}}, {{-0.38461538461538464`, 0.38461538461538464`, 
        0.9260355029585798}, {-0.38461538461538464`, 0.23076923076923078`, 
        0.9497041420118343}, {-0.5384615384615384, 0.23076923076923078`, 
        0.9142011834319527}, {-0.5384615384615384, 0.38461538461538464`, 
        0.8905325443786982}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[7, 13], Rational[301, 338]}, {
         Rational[-5, 13], Rational[5, 13], Rational[313, 338]}, {
         Rational[-7, 13], Rational[5, 13], Rational[301, 338]}, {
         Rational[-7, 13], Rational[7, 13], Rational[
          289, 338]}}, {{-0.38461538461538464`, 0.5384615384615384, 
        0.8905325443786982}, {-0.38461538461538464`, 0.38461538461538464`, 
        0.9260355029585798}, {-0.5384615384615384, 0.38461538461538464`, 
        0.8905325443786982}, {-0.5384615384615384, 0.5384615384615384, 
        0.8550295857988166}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[9, 13], Rational[285, 338]}, {
         Rational[-5, 13], Rational[7, 13], Rational[301, 338]}, {
         Rational[-7, 13], Rational[7, 13], Rational[289, 338]}, {
         Rational[-7, 13], Rational[9, 13], Rational[
          21, 26]}}, {{-0.38461538461538464`, 0.6923076923076923, 
        0.8431952662721893}, {-0.38461538461538464`, 0.5384615384615384, 
        0.8905325443786982}, {-0.5384615384615384, 0.5384615384615384, 
        0.8550295857988166}, {-0.5384615384615384, 0.6923076923076923, 
        0.8076923076923077}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[11, 13], Rational[265, 338]}, {
         Rational[-5, 13], Rational[9, 13], Rational[285, 338]}, {
         Rational[-7, 13], Rational[9, 13], Rational[21, 26]}, {
         Rational[-7, 13], Rational[11, 13], Rational[
          253, 338]}}, {{-0.38461538461538464`, 0.8461538461538461, 
        0.7840236686390533}, {-0.38461538461538464`, 0.6923076923076923, 
        0.8431952662721893}, {-0.5384615384615384, 0.6923076923076923, 
        0.8076923076923077}, {-0.5384615384615384, 0.8461538461538461, 
        0.7485207100591716}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], 1, Rational[241, 338]}, {
         Rational[-5, 13], Rational[11, 13], Rational[265, 338]}, {
         Rational[-7, 13], Rational[11, 13], Rational[253, 338]}, {
         Rational[-7, 13], 1, Rational[229, 338]}}, {{-0.38461538461538464`, 
          1, 0.7130177514792899}, {-0.38461538461538464`, 0.8461538461538461, 
         0.7840236686390533}, {-0.5384615384615384, 0.8461538461538461, 
         0.7485207100591716}, {-0.5384615384615384, 1, 
          0.6775147928994083}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[-11, 13], Rational[21, 26]}, {
         Rational[-3, 13], -1, Rational[249, 338]}, {
         Rational[-5, 13], -1, Rational[241, 338]}, {
         Rational[-5, 13], Rational[-11, 13], Rational[
          265, 338]}}, {{-0.23076923076923078`, -0.8461538461538461, 
         0.8076923076923077}, {-0.23076923076923078`, -1, 
          0.7366863905325444}, {-0.38461538461538464`, -1, 
          0.7130177514792899}, {-0.38461538461538464`, -0.8461538461538461, 
         0.7840236686390533}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[-9, 13], Rational[293, 338]}, {
         Rational[-3, 13], Rational[-11, 13], Rational[21, 26]}, {
         Rational[-5, 13], Rational[-11, 13], Rational[265, 338]}, {
         Rational[-5, 13], Rational[-9, 13], Rational[
          285, 338]}}, {{-0.23076923076923078`, -0.6923076923076923, 
        0.8668639053254438}, {-0.23076923076923078`, -0.8461538461538461, 
        0.8076923076923077}, {-0.38461538461538464`, -0.8461538461538461, 
        0.7840236686390533}, {-0.38461538461538464`, -0.6923076923076923, 
        0.8431952662721893}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[-7, 13], Rational[309, 338]}, {
         Rational[-3, 13], Rational[-9, 13], Rational[293, 338]}, {
         Rational[-5, 13], Rational[-9, 13], Rational[285, 338]}, {
         Rational[-5, 13], Rational[-7, 13], Rational[
          301, 338]}}, {{-0.23076923076923078`, -0.5384615384615384, 
        0.9142011834319527}, {-0.23076923076923078`, -0.6923076923076923, 
        0.8668639053254438}, {-0.38461538461538464`, -0.6923076923076923, 
        0.8431952662721893}, {-0.38461538461538464`, -0.5384615384615384, 
        0.8905325443786982}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[-5, 13], Rational[321, 338]}, {
         Rational[-3, 13], Rational[-7, 13], Rational[309, 338]}, {
         Rational[-5, 13], Rational[-7, 13], Rational[301, 338]}, {
         Rational[-5, 13], Rational[-5, 13], Rational[
          313, 338]}}, {{-0.23076923076923078`, -0.38461538461538464`, 
        0.9497041420118343}, {-0.23076923076923078`, -0.5384615384615384, 
        0.9142011834319527}, {-0.38461538461538464`, -0.5384615384615384, 
        0.8905325443786982}, {-0.38461538461538464`, -0.38461538461538464`, 
        0.9260355029585798}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[-3, 13], Rational[329, 338]}, {
         Rational[-3, 13], Rational[-5, 13], Rational[321, 338]}, {
         Rational[-5, 13], Rational[-5, 13], Rational[313, 338]}, {
         Rational[-5, 13], Rational[-3, 13], Rational[
          321, 338]}}, {{-0.23076923076923078`, -0.23076923076923078`, 
        0.9733727810650887}, {-0.23076923076923078`, -0.38461538461538464`, 
        0.9497041420118343}, {-0.38461538461538464`, -0.38461538461538464`, 
        0.9260355029585798}, {-0.38461538461538464`, -0.23076923076923078`, 
        0.9497041420118343}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[-1, 13], Rational[333, 338]}, {
         Rational[-3, 13], Rational[-3, 13], Rational[329, 338]}, {
         Rational[-5, 13], Rational[-3, 13], Rational[321, 338]}, {
         Rational[-5, 13], Rational[-1, 13], Rational[
          25, 26]}}, {{-0.23076923076923078`, -0.07692307692307693, 
        0.985207100591716}, {-0.23076923076923078`, -0.23076923076923078`, 
        0.9733727810650887}, {-0.38461538461538464`, -0.23076923076923078`, 
        0.9497041420118343}, {-0.38461538461538464`, -0.07692307692307693, 
        0.9615384615384616}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[1, 13], Rational[333, 338]}, {
         Rational[-3, 13], Rational[-1, 13], Rational[333, 338]}, {
         Rational[-5, 13], Rational[-1, 13], Rational[25, 26]}, {
         Rational[-5, 13], Rational[1, 13], Rational[
          25, 26]}}, {{-0.23076923076923078`, 0.07692307692307693, 
        0.985207100591716}, {-0.23076923076923078`, -0.07692307692307693, 
        0.985207100591716}, {-0.38461538461538464`, -0.07692307692307693, 
        0.9615384615384616}, {-0.38461538461538464`, 0.07692307692307693, 
        0.9615384615384616}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[3, 13], Rational[329, 338]}, {
         Rational[-3, 13], Rational[1, 13], Rational[333, 338]}, {
         Rational[-5, 13], Rational[1, 13], Rational[25, 26]}, {
         Rational[-5, 13], Rational[3, 13], Rational[
          321, 338]}}, {{-0.23076923076923078`, 0.23076923076923078`, 
        0.9733727810650887}, {-0.23076923076923078`, 0.07692307692307693, 
        0.985207100591716}, {-0.38461538461538464`, 0.07692307692307693, 
        0.9615384615384616}, {-0.38461538461538464`, 0.23076923076923078`, 
        0.9497041420118343}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[5, 13], Rational[321, 338]}, {
         Rational[-3, 13], Rational[3, 13], Rational[329, 338]}, {
         Rational[-5, 13], Rational[3, 13], Rational[321, 338]}, {
         Rational[-5, 13], Rational[5, 13], Rational[
          313, 338]}}, {{-0.23076923076923078`, 0.38461538461538464`, 
        0.9497041420118343}, {-0.23076923076923078`, 0.23076923076923078`, 
        0.9733727810650887}, {-0.38461538461538464`, 0.23076923076923078`, 
        0.9497041420118343}, {-0.38461538461538464`, 0.38461538461538464`, 
        0.9260355029585798}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[7, 13], Rational[309, 338]}, {
         Rational[-3, 13], Rational[5, 13], Rational[321, 338]}, {
         Rational[-5, 13], Rational[5, 13], Rational[313, 338]}, {
         Rational[-5, 13], Rational[7, 13], Rational[
          301, 338]}}, {{-0.23076923076923078`, 0.5384615384615384, 
        0.9142011834319527}, {-0.23076923076923078`, 0.38461538461538464`, 
        0.9497041420118343}, {-0.38461538461538464`, 0.38461538461538464`, 
        0.9260355029585798}, {-0.38461538461538464`, 0.5384615384615384, 
        0.8905325443786982}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[9, 13], Rational[293, 338]}, {
         Rational[-3, 13], Rational[7, 13], Rational[309, 338]}, {
         Rational[-5, 13], Rational[7, 13], Rational[301, 338]}, {
         Rational[-5, 13], Rational[9, 13], Rational[
          285, 338]}}, {{-0.23076923076923078`, 0.6923076923076923, 
        0.8668639053254438}, {-0.23076923076923078`, 0.5384615384615384, 
        0.9142011834319527}, {-0.38461538461538464`, 0.5384615384615384, 
        0.8905325443786982}, {-0.38461538461538464`, 0.6923076923076923, 
        0.8431952662721893}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[11, 13], Rational[21, 26]}, {
         Rational[-3, 13], Rational[9, 13], Rational[293, 338]}, {
         Rational[-5, 13], Rational[9, 13], Rational[285, 338]}, {
         Rational[-5, 13], Rational[11, 13], Rational[
          265, 338]}}, {{-0.23076923076923078`, 0.8461538461538461, 
        0.8076923076923077}, {-0.23076923076923078`, 0.6923076923076923, 
        0.8668639053254438}, {-0.38461538461538464`, 0.6923076923076923, 
        0.8431952662721893}, {-0.38461538461538464`, 0.8461538461538461, 
        0.7840236686390533}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], 1, Rational[249, 338]}, {
         Rational[-3, 13], Rational[11, 13], Rational[21, 26]}, {
         Rational[-5, 13], Rational[11, 13], Rational[265, 338]}, {
         Rational[-5, 13], 1, Rational[241, 338]}}, {{-0.23076923076923078`, 
          1, 0.7366863905325444}, {-0.23076923076923078`, 0.8461538461538461, 
         0.8076923076923077}, {-0.38461538461538464`, 0.8461538461538461, 
         0.7840236686390533}, {-0.38461538461538464`, 1, 
          0.7130177514792899}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[-11, 13], Rational[277, 338]}, {
         Rational[-1, 13], -1, Rational[253, 338]}, {
         Rational[-3, 13], -1, Rational[249, 338]}, {
         Rational[-3, 13], Rational[-11, 13], Rational[
          21, 26]}}, {{-0.07692307692307693, -0.8461538461538461, 
         0.8195266272189349}, {-0.07692307692307693, -1, 
          0.7485207100591716}, {-0.23076923076923078`, -1, 
          0.7366863905325444}, {-0.23076923076923078`, -0.8461538461538461, 
         0.8076923076923077}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[-9, 13], Rational[297, 338]}, {
         Rational[-1, 13], Rational[-11, 13], Rational[277, 338]}, {
         Rational[-3, 13], Rational[-11, 13], Rational[21, 26]}, {
         Rational[-3, 13], Rational[-9, 13], Rational[
          293, 338]}}, {{-0.07692307692307693, -0.6923076923076923, 
        0.878698224852071}, {-0.07692307692307693, -0.8461538461538461, 
        0.8195266272189349}, {-0.23076923076923078`, -0.8461538461538461, 
        0.8076923076923077}, {-0.23076923076923078`, -0.6923076923076923, 
        0.8668639053254438}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[-7, 13], Rational[313, 338]}, {
         Rational[-1, 13], Rational[-9, 13], Rational[297, 338]}, {
         Rational[-3, 13], Rational[-9, 13], Rational[293, 338]}, {
         Rational[-3, 13], Rational[-7, 13], Rational[
          309, 338]}}, {{-0.07692307692307693, -0.5384615384615384, 
        0.9260355029585798}, {-0.07692307692307693, -0.6923076923076923, 
        0.878698224852071}, {-0.23076923076923078`, -0.6923076923076923, 
        0.8668639053254438}, {-0.23076923076923078`, -0.5384615384615384, 
        0.9142011834319527}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[-5, 13], Rational[25, 26]}, {
         Rational[-1, 13], Rational[-7, 13], Rational[313, 338]}, {
         Rational[-3, 13], Rational[-7, 13], Rational[309, 338]}, {
         Rational[-3, 13], Rational[-5, 13], Rational[
          321, 338]}}, {{-0.07692307692307693, -0.38461538461538464`, 
        0.9615384615384616}, {-0.07692307692307693, -0.5384615384615384, 
        0.9260355029585798}, {-0.23076923076923078`, -0.5384615384615384, 
        0.9142011834319527}, {-0.23076923076923078`, -0.38461538461538464`, 
        0.9497041420118343}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[-3, 13], Rational[333, 338]}, {
         Rational[-1, 13], Rational[-5, 13], Rational[25, 26]}, {
         Rational[-3, 13], Rational[-5, 13], Rational[321, 338]}, {
         Rational[-3, 13], Rational[-3, 13], Rational[
          329, 338]}}, {{-0.07692307692307693, -0.23076923076923078`, 
        0.985207100591716}, {-0.07692307692307693, -0.38461538461538464`, 
        0.9615384615384616}, {-0.23076923076923078`, -0.38461538461538464`, 
        0.9497041420118343}, {-0.23076923076923078`, -0.23076923076923078`, 
        0.9733727810650887}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[-1, 13], Rational[337, 338]}, {
         Rational[-1, 13], Rational[-3, 13], Rational[333, 338]}, {
         Rational[-3, 13], Rational[-3, 13], Rational[329, 338]}, {
         Rational[-3, 13], Rational[-1, 13], Rational[
          333, 338]}}, {{-0.07692307692307693, -0.07692307692307693, 
        0.9970414201183432}, {-0.07692307692307693, -0.23076923076923078`, 
        0.985207100591716}, {-0.23076923076923078`, -0.23076923076923078`, 
        0.9733727810650887}, {-0.23076923076923078`, -0.07692307692307693, 
        0.985207100591716}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[1, 13], Rational[337, 338]}, {
         Rational[-1, 13], Rational[-1, 13], Rational[337, 338]}, {
         Rational[-3, 13], Rational[-1, 13], Rational[333, 338]}, {
         Rational[-3, 13], Rational[1, 13], Rational[
          333, 338]}}, {{-0.07692307692307693, 0.07692307692307693, 
        0.9970414201183432}, {-0.07692307692307693, -0.07692307692307693, 
        0.9970414201183432}, {-0.23076923076923078`, -0.07692307692307693, 
        0.985207100591716}, {-0.23076923076923078`, 0.07692307692307693, 
        0.985207100591716}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[3, 13], Rational[333, 338]}, {
         Rational[-1, 13], Rational[1, 13], Rational[337, 338]}, {
         Rational[-3, 13], Rational[1, 13], Rational[333, 338]}, {
         Rational[-3, 13], Rational[3, 13], Rational[
          329, 338]}}, {{-0.07692307692307693, 0.23076923076923078`, 
        0.985207100591716}, {-0.07692307692307693, 0.07692307692307693, 
        0.9970414201183432}, {-0.23076923076923078`, 0.07692307692307693, 
        0.985207100591716}, {-0.23076923076923078`, 0.23076923076923078`, 
        0.9733727810650887}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[5, 13], Rational[25, 26]}, {
         Rational[-1, 13], Rational[3, 13], Rational[333, 338]}, {
         Rational[-3, 13], Rational[3, 13], Rational[329, 338]}, {
         Rational[-3, 13], Rational[5, 13], Rational[
          321, 338]}}, {{-0.07692307692307693, 0.38461538461538464`, 
        0.9615384615384616}, {-0.07692307692307693, 0.23076923076923078`, 
        0.985207100591716}, {-0.23076923076923078`, 0.23076923076923078`, 
        0.9733727810650887}, {-0.23076923076923078`, 0.38461538461538464`, 
        0.9497041420118343}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[7, 13], Rational[313, 338]}, {
         Rational[-1, 13], Rational[5, 13], Rational[25, 26]}, {
         Rational[-3, 13], Rational[5, 13], Rational[321, 338]}, {
         Rational[-3, 13], Rational[7, 13], Rational[
          309, 338]}}, {{-0.07692307692307693, 0.5384615384615384, 
        0.9260355029585798}, {-0.07692307692307693, 0.38461538461538464`, 
        0.9615384615384616}, {-0.23076923076923078`, 0.38461538461538464`, 
        0.9497041420118343}, {-0.23076923076923078`, 0.5384615384615384, 
        0.9142011834319527}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[9, 13], Rational[297, 338]}, {
         Rational[-1, 13], Rational[7, 13], Rational[313, 338]}, {
         Rational[-3, 13], Rational[7, 13], Rational[309, 338]}, {
         Rational[-3, 13], Rational[9, 13], Rational[
          293, 338]}}, {{-0.07692307692307693, 0.6923076923076923, 
        0.878698224852071}, {-0.07692307692307693, 0.5384615384615384, 
        0.9260355029585798}, {-0.23076923076923078`, 0.5384615384615384, 
        0.9142011834319527}, {-0.23076923076923078`, 0.6923076923076923, 
        0.8668639053254438}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[11, 13], Rational[277, 338]}, {
         Rational[-1, 13], Rational[9, 13], Rational[297, 338]}, {
         Rational[-3, 13], Rational[9, 13], Rational[293, 338]}, {
         Rational[-3, 13], Rational[11, 13], Rational[
          21, 26]}}, {{-0.07692307692307693, 0.8461538461538461, 
        0.8195266272189349}, {-0.07692307692307693, 0.6923076923076923, 
        0.878698224852071}, {-0.23076923076923078`, 0.6923076923076923, 
        0.8668639053254438}, {-0.23076923076923078`, 0.8461538461538461, 
        0.8076923076923077}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], 1, Rational[253, 338]}, {
         Rational[-1, 13], Rational[11, 13], Rational[277, 338]}, {
         Rational[-3, 13], Rational[11, 13], Rational[21, 26]}, {
         Rational[-3, 13], 1, Rational[249, 338]}}, {{-0.07692307692307693, 1,
           0.7485207100591716}, {-0.07692307692307693, 0.8461538461538461, 
         0.8195266272189349}, {-0.23076923076923078`, 0.8461538461538461, 
         0.8076923076923077}, {-0.23076923076923078`, 1, 
          0.7366863905325444}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[-11, 13], Rational[277, 338]}, {
         Rational[1, 13], -1, Rational[253, 338]}, {
         Rational[-1, 13], -1, Rational[253, 338]}, {
         Rational[-1, 13], Rational[-11, 13], Rational[277, 338]}}, {{
         0.07692307692307693, -0.8461538461538461, 0.8195266272189349}, {
         0.07692307692307693, -1, 
          0.7485207100591716}, {-0.07692307692307693, -1, 
          0.7485207100591716}, {-0.07692307692307693, -0.8461538461538461, 
         0.8195266272189349}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[-9, 13], Rational[297, 338]}, {
         Rational[1, 13], Rational[-11, 13], Rational[277, 338]}, {
         Rational[-1, 13], Rational[-11, 13], Rational[277, 338]}, {
         Rational[-1, 13], Rational[-9, 13], Rational[297, 338]}}, {{
        0.07692307692307693, -0.6923076923076923, 0.878698224852071}, {
        0.07692307692307693, -0.8461538461538461, 
        0.8195266272189349}, {-0.07692307692307693, -0.8461538461538461, 
        0.8195266272189349}, {-0.07692307692307693, -0.6923076923076923, 
        0.878698224852071}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[-7, 13], Rational[313, 338]}, {
         Rational[1, 13], Rational[-9, 13], Rational[297, 338]}, {
         Rational[-1, 13], Rational[-9, 13], Rational[297, 338]}, {
         Rational[-1, 13], Rational[-7, 13], Rational[313, 338]}}, {{
        0.07692307692307693, -0.5384615384615384, 0.9260355029585798}, {
        0.07692307692307693, -0.6923076923076923, 
        0.878698224852071}, {-0.07692307692307693, -0.6923076923076923, 
        0.878698224852071}, {-0.07692307692307693, -0.5384615384615384, 
        0.9260355029585798}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[-5, 13], Rational[25, 26]}, {
         Rational[1, 13], Rational[-7, 13], Rational[313, 338]}, {
         Rational[-1, 13], Rational[-7, 13], Rational[313, 338]}, {
         Rational[-1, 13], Rational[-5, 13], Rational[25, 26]}}, {{
        0.07692307692307693, -0.38461538461538464`, 0.9615384615384616}, {
        0.07692307692307693, -0.5384615384615384, 
        0.9260355029585798}, {-0.07692307692307693, -0.5384615384615384, 
        0.9260355029585798}, {-0.07692307692307693, -0.38461538461538464`, 
        0.9615384615384616}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[-3, 13], Rational[333, 338]}, {
         Rational[1, 13], Rational[-5, 13], Rational[25, 26]}, {
         Rational[-1, 13], Rational[-5, 13], Rational[25, 26]}, {
         Rational[-1, 13], Rational[-3, 13], Rational[333, 338]}}, {{
        0.07692307692307693, -0.23076923076923078`, 0.985207100591716}, {
        0.07692307692307693, -0.38461538461538464`, 
        0.9615384615384616}, {-0.07692307692307693, -0.38461538461538464`, 
        0.9615384615384616}, {-0.07692307692307693, -0.23076923076923078`, 
        0.985207100591716}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[-1, 13], Rational[337, 338]}, {
         Rational[1, 13], Rational[-3, 13], Rational[333, 338]}, {
         Rational[-1, 13], Rational[-3, 13], Rational[333, 338]}, {
         Rational[-1, 13], Rational[-1, 13], Rational[337, 338]}}, {{
        0.07692307692307693, -0.07692307692307693, 0.9970414201183432}, {
        0.07692307692307693, -0.23076923076923078`, 
        0.985207100591716}, {-0.07692307692307693, -0.23076923076923078`, 
        0.985207100591716}, {-0.07692307692307693, -0.07692307692307693, 
        0.9970414201183432}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[1, 13], Rational[337, 338]}, {
         Rational[1, 13], Rational[-1, 13], Rational[337, 338]}, {
         Rational[-1, 13], Rational[-1, 13], Rational[337, 338]}, {
         Rational[-1, 13], Rational[1, 13], Rational[337, 338]}}, {{
        0.07692307692307693, 0.07692307692307693, 0.9970414201183432}, {
        0.07692307692307693, -0.07692307692307693, 
        0.9970414201183432}, {-0.07692307692307693, -0.07692307692307693, 
        0.9970414201183432}, {-0.07692307692307693, 0.07692307692307693, 
        0.9970414201183432}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[3, 13], Rational[333, 338]}, {
         Rational[1, 13], Rational[1, 13], Rational[337, 338]}, {
         Rational[-1, 13], Rational[1, 13], Rational[337, 338]}, {
         Rational[-1, 13], Rational[3, 13], Rational[333, 338]}}, {{
        0.07692307692307693, 0.23076923076923078`, 0.985207100591716}, {
        0.07692307692307693, 0.07692307692307693, 
        0.9970414201183432}, {-0.07692307692307693, 0.07692307692307693, 
        0.9970414201183432}, {-0.07692307692307693, 0.23076923076923078`, 
        0.985207100591716}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[5, 13], Rational[25, 26]}, {
         Rational[1, 13], Rational[3, 13], Rational[333, 338]}, {
         Rational[-1, 13], Rational[3, 13], Rational[333, 338]}, {
         Rational[-1, 13], Rational[5, 13], Rational[25, 26]}}, {{
        0.07692307692307693, 0.38461538461538464`, 0.9615384615384616}, {
        0.07692307692307693, 0.23076923076923078`, 
        0.985207100591716}, {-0.07692307692307693, 0.23076923076923078`, 
        0.985207100591716}, {-0.07692307692307693, 0.38461538461538464`, 
        0.9615384615384616}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[7, 13], Rational[313, 338]}, {
         Rational[1, 13], Rational[5, 13], Rational[25, 26]}, {
         Rational[-1, 13], Rational[5, 13], Rational[25, 26]}, {
         Rational[-1, 13], Rational[7, 13], Rational[313, 338]}}, {{
        0.07692307692307693, 0.5384615384615384, 0.9260355029585798}, {
        0.07692307692307693, 0.38461538461538464`, 
        0.9615384615384616}, {-0.07692307692307693, 0.38461538461538464`, 
        0.9615384615384616}, {-0.07692307692307693, 0.5384615384615384, 
        0.9260355029585798}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[9, 13], Rational[297, 338]}, {
         Rational[1, 13], Rational[7, 13], Rational[313, 338]}, {
         Rational[-1, 13], Rational[7, 13], Rational[313, 338]}, {
         Rational[-1, 13], Rational[9, 13], Rational[297, 338]}}, {{
        0.07692307692307693, 0.6923076923076923, 0.878698224852071}, {
        0.07692307692307693, 0.5384615384615384, 
        0.9260355029585798}, {-0.07692307692307693, 0.5384615384615384, 
        0.9260355029585798}, {-0.07692307692307693, 0.6923076923076923, 
        0.878698224852071}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[11, 13], Rational[277, 338]}, {
         Rational[1, 13], Rational[9, 13], Rational[297, 338]}, {
         Rational[-1, 13], Rational[9, 13], Rational[297, 338]}, {
         Rational[-1, 13], Rational[11, 13], Rational[277, 338]}}, {{
        0.07692307692307693, 0.8461538461538461, 0.8195266272189349}, {
        0.07692307692307693, 0.6923076923076923, 
        0.878698224852071}, {-0.07692307692307693, 0.6923076923076923, 
        0.878698224852071}, {-0.07692307692307693, 0.8461538461538461, 
        0.8195266272189349}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], 1, Rational[253, 338]}, {
         Rational[1, 13], Rational[11, 13], Rational[277, 338]}, {
         Rational[-1, 13], Rational[11, 13], Rational[277, 338]}, {
         Rational[-1, 13], 1, Rational[253, 338]}}, {{
         0.07692307692307693, 1, 0.7485207100591716}, {0.07692307692307693, 
         0.8461538461538461, 0.8195266272189349}, {-0.07692307692307693, 
         0.8461538461538461, 
         0.8195266272189349}, {-0.07692307692307693, 1, 
          0.7485207100591716}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[-11, 13], Rational[21, 26]}, {
         Rational[3, 13], -1, Rational[249, 338]}, {
         Rational[1, 13], -1, Rational[253, 338]}, {
         Rational[1, 13], Rational[-11, 13], Rational[277, 338]}}, {{
         0.23076923076923078`, -0.8461538461538461, 0.8076923076923077}, {
         0.23076923076923078`, -1, 0.7366863905325444}, {
         0.07692307692307693, -1, 0.7485207100591716}, {
         0.07692307692307693, -0.8461538461538461, 0.8195266272189349}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[-9, 13], Rational[293, 338]}, {
         Rational[3, 13], Rational[-11, 13], Rational[21, 26]}, {
         Rational[1, 13], Rational[-11, 13], Rational[277, 338]}, {
         Rational[1, 13], Rational[-9, 13], Rational[297, 338]}}, {{
        0.23076923076923078`, -0.6923076923076923, 0.8668639053254438}, {
        0.23076923076923078`, -0.8461538461538461, 0.8076923076923077}, {
        0.07692307692307693, -0.8461538461538461, 0.8195266272189349}, {
        0.07692307692307693, -0.6923076923076923, 0.878698224852071}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[-7, 13], Rational[309, 338]}, {
         Rational[3, 13], Rational[-9, 13], Rational[293, 338]}, {
         Rational[1, 13], Rational[-9, 13], Rational[297, 338]}, {
         Rational[1, 13], Rational[-7, 13], Rational[313, 338]}}, {{
        0.23076923076923078`, -0.5384615384615384, 0.9142011834319527}, {
        0.23076923076923078`, -0.6923076923076923, 0.8668639053254438}, {
        0.07692307692307693, -0.6923076923076923, 0.878698224852071}, {
        0.07692307692307693, -0.5384615384615384, 0.9260355029585798}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[-5, 13], Rational[321, 338]}, {
         Rational[3, 13], Rational[-7, 13], Rational[309, 338]}, {
         Rational[1, 13], Rational[-7, 13], Rational[313, 338]}, {
         Rational[1, 13], Rational[-5, 13], Rational[25, 26]}}, {{
        0.23076923076923078`, -0.38461538461538464`, 0.9497041420118343}, {
        0.23076923076923078`, -0.5384615384615384, 0.9142011834319527}, {
        0.07692307692307693, -0.5384615384615384, 0.9260355029585798}, {
        0.07692307692307693, -0.38461538461538464`, 0.9615384615384616}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[-3, 13], Rational[329, 338]}, {
         Rational[3, 13], Rational[-5, 13], Rational[321, 338]}, {
         Rational[1, 13], Rational[-5, 13], Rational[25, 26]}, {
         Rational[1, 13], Rational[-3, 13], Rational[333, 338]}}, {{
        0.23076923076923078`, -0.23076923076923078`, 0.9733727810650887}, {
        0.23076923076923078`, -0.38461538461538464`, 0.9497041420118343}, {
        0.07692307692307693, -0.38461538461538464`, 0.9615384615384616}, {
        0.07692307692307693, -0.23076923076923078`, 0.985207100591716}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[-1, 13], Rational[333, 338]}, {
         Rational[3, 13], Rational[-3, 13], Rational[329, 338]}, {
         Rational[1, 13], Rational[-3, 13], Rational[333, 338]}, {
         Rational[1, 13], Rational[-1, 13], Rational[337, 338]}}, {{
        0.23076923076923078`, -0.07692307692307693, 0.985207100591716}, {
        0.23076923076923078`, -0.23076923076923078`, 0.9733727810650887}, {
        0.07692307692307693, -0.23076923076923078`, 0.985207100591716}, {
        0.07692307692307693, -0.07692307692307693, 0.9970414201183432}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[1, 13], Rational[333, 338]}, {
         Rational[3, 13], Rational[-1, 13], Rational[333, 338]}, {
         Rational[1, 13], Rational[-1, 13], Rational[337, 338]}, {
         Rational[1, 13], Rational[1, 13], Rational[337, 338]}}, {{
        0.23076923076923078`, 0.07692307692307693, 0.985207100591716}, {
        0.23076923076923078`, -0.07692307692307693, 0.985207100591716}, {
        0.07692307692307693, -0.07692307692307693, 0.9970414201183432}, {
        0.07692307692307693, 0.07692307692307693, 0.9970414201183432}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[3, 13], Rational[329, 338]}, {
         Rational[3, 13], Rational[1, 13], Rational[333, 338]}, {
         Rational[1, 13], Rational[1, 13], Rational[337, 338]}, {
         Rational[1, 13], Rational[3, 13], Rational[333, 338]}}, {{
        0.23076923076923078`, 0.23076923076923078`, 0.9733727810650887}, {
        0.23076923076923078`, 0.07692307692307693, 0.985207100591716}, {
        0.07692307692307693, 0.07692307692307693, 0.9970414201183432}, {
        0.07692307692307693, 0.23076923076923078`, 0.985207100591716}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[5, 13], Rational[321, 338]}, {
         Rational[3, 13], Rational[3, 13], Rational[329, 338]}, {
         Rational[1, 13], Rational[3, 13], Rational[333, 338]}, {
         Rational[1, 13], Rational[5, 13], Rational[25, 26]}}, {{
        0.23076923076923078`, 0.38461538461538464`, 0.9497041420118343}, {
        0.23076923076923078`, 0.23076923076923078`, 0.9733727810650887}, {
        0.07692307692307693, 0.23076923076923078`, 0.985207100591716}, {
        0.07692307692307693, 0.38461538461538464`, 0.9615384615384616}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[7, 13], Rational[309, 338]}, {
         Rational[3, 13], Rational[5, 13], Rational[321, 338]}, {
         Rational[1, 13], Rational[5, 13], Rational[25, 26]}, {
         Rational[1, 13], Rational[7, 13], Rational[313, 338]}}, {{
        0.23076923076923078`, 0.5384615384615384, 0.9142011834319527}, {
        0.23076923076923078`, 0.38461538461538464`, 0.9497041420118343}, {
        0.07692307692307693, 0.38461538461538464`, 0.9615384615384616}, {
        0.07692307692307693, 0.5384615384615384, 0.9260355029585798}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[9, 13], Rational[293, 338]}, {
         Rational[3, 13], Rational[7, 13], Rational[309, 338]}, {
         Rational[1, 13], Rational[7, 13], Rational[313, 338]}, {
         Rational[1, 13], Rational[9, 13], Rational[297, 338]}}, {{
        0.23076923076923078`, 0.6923076923076923, 0.8668639053254438}, {
        0.23076923076923078`, 0.5384615384615384, 0.9142011834319527}, {
        0.07692307692307693, 0.5384615384615384, 0.9260355029585798}, {
        0.07692307692307693, 0.6923076923076923, 0.878698224852071}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[11, 13], Rational[21, 26]}, {
         Rational[3, 13], Rational[9, 13], Rational[293, 338]}, {
         Rational[1, 13], Rational[9, 13], Rational[297, 338]}, {
         Rational[1, 13], Rational[11, 13], Rational[277, 338]}}, {{
        0.23076923076923078`, 0.8461538461538461, 0.8076923076923077}, {
        0.23076923076923078`, 0.6923076923076923, 0.8668639053254438}, {
        0.07692307692307693, 0.6923076923076923, 0.878698224852071}, {
        0.07692307692307693, 0.8461538461538461, 0.8195266272189349}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], 1, Rational[249, 338]}, {
         Rational[3, 13], Rational[11, 13], Rational[21, 26]}, {
         Rational[1, 13], Rational[11, 13], Rational[277, 338]}, {
         Rational[1, 13], 1, Rational[253, 338]}}, {{
         0.23076923076923078`, 1, 0.7366863905325444}, {0.23076923076923078`, 
         0.8461538461538461, 0.8076923076923077}, {0.07692307692307693, 
         0.8461538461538461, 0.8195266272189349}, {
         0.07692307692307693, 1, 0.7485207100591716}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[-11, 13], Rational[265, 338]}, {
         Rational[5, 13], -1, Rational[241, 338]}, {
         Rational[3, 13], -1, Rational[249, 338]}, {
         Rational[3, 13], Rational[-11, 13], Rational[21, 26]}}, {{
         0.38461538461538464`, -0.8461538461538461, 0.7840236686390533}, {
         0.38461538461538464`, -1, 0.7130177514792899}, {
         0.23076923076923078`, -1, 0.7366863905325444}, {
         0.23076923076923078`, -0.8461538461538461, 0.8076923076923077}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[-9, 13], Rational[285, 338]}, {
         Rational[5, 13], Rational[-11, 13], Rational[265, 338]}, {
         Rational[3, 13], Rational[-11, 13], Rational[21, 26]}, {
         Rational[3, 13], Rational[-9, 13], Rational[293, 338]}}, {{
        0.38461538461538464`, -0.6923076923076923, 0.8431952662721893}, {
        0.38461538461538464`, -0.8461538461538461, 0.7840236686390533}, {
        0.23076923076923078`, -0.8461538461538461, 0.8076923076923077}, {
        0.23076923076923078`, -0.6923076923076923, 0.8668639053254438}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[-7, 13], Rational[301, 338]}, {
         Rational[5, 13], Rational[-9, 13], Rational[285, 338]}, {
         Rational[3, 13], Rational[-9, 13], Rational[293, 338]}, {
         Rational[3, 13], Rational[-7, 13], Rational[309, 338]}}, {{
        0.38461538461538464`, -0.5384615384615384, 0.8905325443786982}, {
        0.38461538461538464`, -0.6923076923076923, 0.8431952662721893}, {
        0.23076923076923078`, -0.6923076923076923, 0.8668639053254438}, {
        0.23076923076923078`, -0.5384615384615384, 0.9142011834319527}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[-5, 13], Rational[313, 338]}, {
         Rational[5, 13], Rational[-7, 13], Rational[301, 338]}, {
         Rational[3, 13], Rational[-7, 13], Rational[309, 338]}, {
         Rational[3, 13], Rational[-5, 13], Rational[321, 338]}}, {{
        0.38461538461538464`, -0.38461538461538464`, 0.9260355029585798}, {
        0.38461538461538464`, -0.5384615384615384, 0.8905325443786982}, {
        0.23076923076923078`, -0.5384615384615384, 0.9142011834319527}, {
        0.23076923076923078`, -0.38461538461538464`, 0.9497041420118343}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[-3, 13], Rational[321, 338]}, {
         Rational[5, 13], Rational[-5, 13], Rational[313, 338]}, {
         Rational[3, 13], Rational[-5, 13], Rational[321, 338]}, {
         Rational[3, 13], Rational[-3, 13], Rational[329, 338]}}, {{
        0.38461538461538464`, -0.23076923076923078`, 0.9497041420118343}, {
        0.38461538461538464`, -0.38461538461538464`, 0.9260355029585798}, {
        0.23076923076923078`, -0.38461538461538464`, 0.9497041420118343}, {
        0.23076923076923078`, -0.23076923076923078`, 0.9733727810650887}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[-1, 13], Rational[25, 26]}, {
         Rational[5, 13], Rational[-3, 13], Rational[321, 338]}, {
         Rational[3, 13], Rational[-3, 13], Rational[329, 338]}, {
         Rational[3, 13], Rational[-1, 13], Rational[333, 338]}}, {{
        0.38461538461538464`, -0.07692307692307693, 0.9615384615384616}, {
        0.38461538461538464`, -0.23076923076923078`, 0.9497041420118343}, {
        0.23076923076923078`, -0.23076923076923078`, 0.9733727810650887}, {
        0.23076923076923078`, -0.07692307692307693, 0.985207100591716}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[1, 13], Rational[25, 26]}, {
         Rational[5, 13], Rational[-1, 13], Rational[25, 26]}, {
         Rational[3, 13], Rational[-1, 13], Rational[333, 338]}, {
         Rational[3, 13], Rational[1, 13], Rational[333, 338]}}, {{
        0.38461538461538464`, 0.07692307692307693, 0.9615384615384616}, {
        0.38461538461538464`, -0.07692307692307693, 0.9615384615384616}, {
        0.23076923076923078`, -0.07692307692307693, 0.985207100591716}, {
        0.23076923076923078`, 0.07692307692307693, 0.985207100591716}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[3, 13], Rational[321, 338]}, {
         Rational[5, 13], Rational[1, 13], Rational[25, 26]}, {
         Rational[3, 13], Rational[1, 13], Rational[333, 338]}, {
         Rational[3, 13], Rational[3, 13], Rational[329, 338]}}, {{
        0.38461538461538464`, 0.23076923076923078`, 0.9497041420118343}, {
        0.38461538461538464`, 0.07692307692307693, 0.9615384615384616}, {
        0.23076923076923078`, 0.07692307692307693, 0.985207100591716}, {
        0.23076923076923078`, 0.23076923076923078`, 0.9733727810650887}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[5, 13], Rational[313, 338]}, {
         Rational[5, 13], Rational[3, 13], Rational[321, 338]}, {
         Rational[3, 13], Rational[3, 13], Rational[329, 338]}, {
         Rational[3, 13], Rational[5, 13], Rational[321, 338]}}, {{
        0.38461538461538464`, 0.38461538461538464`, 0.9260355029585798}, {
        0.38461538461538464`, 0.23076923076923078`, 0.9497041420118343}, {
        0.23076923076923078`, 0.23076923076923078`, 0.9733727810650887}, {
        0.23076923076923078`, 0.38461538461538464`, 0.9497041420118343}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[7, 13], Rational[301, 338]}, {
         Rational[5, 13], Rational[5, 13], Rational[313, 338]}, {
         Rational[3, 13], Rational[5, 13], Rational[321, 338]}, {
         Rational[3, 13], Rational[7, 13], Rational[309, 338]}}, {{
        0.38461538461538464`, 0.5384615384615384, 0.8905325443786982}, {
        0.38461538461538464`, 0.38461538461538464`, 0.9260355029585798}, {
        0.23076923076923078`, 0.38461538461538464`, 0.9497041420118343}, {
        0.23076923076923078`, 0.5384615384615384, 0.9142011834319527}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[9, 13], Rational[285, 338]}, {
         Rational[5, 13], Rational[7, 13], Rational[301, 338]}, {
         Rational[3, 13], Rational[7, 13], Rational[309, 338]}, {
         Rational[3, 13], Rational[9, 13], Rational[293, 338]}}, {{
        0.38461538461538464`, 0.6923076923076923, 0.8431952662721893}, {
        0.38461538461538464`, 0.5384615384615384, 0.8905325443786982}, {
        0.23076923076923078`, 0.5384615384615384, 0.9142011834319527}, {
        0.23076923076923078`, 0.6923076923076923, 0.8668639053254438}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[11, 13], Rational[265, 338]}, {
         Rational[5, 13], Rational[9, 13], Rational[285, 338]}, {
         Rational[3, 13], Rational[9, 13], Rational[293, 338]}, {
         Rational[3, 13], Rational[11, 13], Rational[21, 26]}}, {{
        0.38461538461538464`, 0.8461538461538461, 0.7840236686390533}, {
        0.38461538461538464`, 0.6923076923076923, 0.8431952662721893}, {
        0.23076923076923078`, 0.6923076923076923, 0.8668639053254438}, {
        0.23076923076923078`, 0.8461538461538461, 0.8076923076923077}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], 1, Rational[241, 338]}, {
         Rational[5, 13], Rational[11, 13], Rational[265, 338]}, {
         Rational[3, 13], Rational[11, 13], Rational[21, 26]}, {
         Rational[3, 13], 1, Rational[249, 338]}}, {{
         0.38461538461538464`, 1, 0.7130177514792899}, {0.38461538461538464`, 
         0.8461538461538461, 0.7840236686390533}, {0.23076923076923078`, 
         0.8461538461538461, 0.8076923076923077}, {
         0.23076923076923078`, 1, 0.7366863905325444}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[-11, 13], Rational[253, 338]}, {
         Rational[7, 13], -1, Rational[229, 338]}, {
         Rational[5, 13], -1, Rational[241, 338]}, {
         Rational[5, 13], Rational[-11, 13], Rational[265, 338]}}, {{
         0.5384615384615384, -0.8461538461538461, 0.7485207100591716}, {
         0.5384615384615384, -1, 0.6775147928994083}, {
         0.38461538461538464`, -1, 0.7130177514792899}, {
         0.38461538461538464`, -0.8461538461538461, 0.7840236686390533}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[-9, 13], Rational[21, 26]}, {
         Rational[7, 13], Rational[-11, 13], Rational[253, 338]}, {
         Rational[5, 13], Rational[-11, 13], Rational[265, 338]}, {
         Rational[5, 13], Rational[-9, 13], Rational[285, 338]}}, {{
        0.5384615384615384, -0.6923076923076923, 0.8076923076923077}, {
        0.5384615384615384, -0.8461538461538461, 0.7485207100591716}, {
        0.38461538461538464`, -0.8461538461538461, 0.7840236686390533}, {
        0.38461538461538464`, -0.6923076923076923, 0.8431952662721893}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[-7, 13], Rational[289, 338]}, {
         Rational[7, 13], Rational[-9, 13], Rational[21, 26]}, {
         Rational[5, 13], Rational[-9, 13], Rational[285, 338]}, {
         Rational[5, 13], Rational[-7, 13], Rational[301, 338]}}, {{
        0.5384615384615384, -0.5384615384615384, 0.8550295857988166}, {
        0.5384615384615384, -0.6923076923076923, 0.8076923076923077}, {
        0.38461538461538464`, -0.6923076923076923, 0.8431952662721893}, {
        0.38461538461538464`, -0.5384615384615384, 0.8905325443786982}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[-5, 13], Rational[301, 338]}, {
         Rational[7, 13], Rational[-7, 13], Rational[289, 338]}, {
         Rational[5, 13], Rational[-7, 13], Rational[301, 338]}, {
         Rational[5, 13], Rational[-5, 13], Rational[313, 338]}}, {{
        0.5384615384615384, -0.38461538461538464`, 0.8905325443786982}, {
        0.5384615384615384, -0.5384615384615384, 0.8550295857988166}, {
        0.38461538461538464`, -0.5384615384615384, 0.8905325443786982}, {
        0.38461538461538464`, -0.38461538461538464`, 0.9260355029585798}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[-3, 13], Rational[309, 338]}, {
         Rational[7, 13], Rational[-5, 13], Rational[301, 338]}, {
         Rational[5, 13], Rational[-5, 13], Rational[313, 338]}, {
         Rational[5, 13], Rational[-3, 13], Rational[321, 338]}}, {{
        0.5384615384615384, -0.23076923076923078`, 0.9142011834319527}, {
        0.5384615384615384, -0.38461538461538464`, 0.8905325443786982}, {
        0.38461538461538464`, -0.38461538461538464`, 0.9260355029585798}, {
        0.38461538461538464`, -0.23076923076923078`, 0.9497041420118343}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[-1, 13], Rational[313, 338]}, {
         Rational[7, 13], Rational[-3, 13], Rational[309, 338]}, {
         Rational[5, 13], Rational[-3, 13], Rational[321, 338]}, {
         Rational[5, 13], Rational[-1, 13], Rational[25, 26]}}, {{
        0.5384615384615384, -0.07692307692307693, 0.9260355029585798}, {
        0.5384615384615384, -0.23076923076923078`, 0.9142011834319527}, {
        0.38461538461538464`, -0.23076923076923078`, 0.9497041420118343}, {
        0.38461538461538464`, -0.07692307692307693, 0.9615384615384616}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[1, 13], Rational[313, 338]}, {
         Rational[7, 13], Rational[-1, 13], Rational[313, 338]}, {
         Rational[5, 13], Rational[-1, 13], Rational[25, 26]}, {
         Rational[5, 13], Rational[1, 13], Rational[25, 26]}}, {{
        0.5384615384615384, 0.07692307692307693, 0.9260355029585798}, {
        0.5384615384615384, -0.07692307692307693, 0.9260355029585798}, {
        0.38461538461538464`, -0.07692307692307693, 0.9615384615384616}, {
        0.38461538461538464`, 0.07692307692307693, 0.9615384615384616}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[3, 13], Rational[309, 338]}, {
         Rational[7, 13], Rational[1, 13], Rational[313, 338]}, {
         Rational[5, 13], Rational[1, 13], Rational[25, 26]}, {
         Rational[5, 13], Rational[3, 13], Rational[321, 338]}}, {{
        0.5384615384615384, 0.23076923076923078`, 0.9142011834319527}, {
        0.5384615384615384, 0.07692307692307693, 0.9260355029585798}, {
        0.38461538461538464`, 0.07692307692307693, 0.9615384615384616}, {
        0.38461538461538464`, 0.23076923076923078`, 0.9497041420118343}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[5, 13], Rational[301, 338]}, {
         Rational[7, 13], Rational[3, 13], Rational[309, 338]}, {
         Rational[5, 13], Rational[3, 13], Rational[321, 338]}, {
         Rational[5, 13], Rational[5, 13], Rational[313, 338]}}, {{
        0.5384615384615384, 0.38461538461538464`, 0.8905325443786982}, {
        0.5384615384615384, 0.23076923076923078`, 0.9142011834319527}, {
        0.38461538461538464`, 0.23076923076923078`, 0.9497041420118343}, {
        0.38461538461538464`, 0.38461538461538464`, 0.9260355029585798}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[7, 13], Rational[289, 338]}, {
         Rational[7, 13], Rational[5, 13], Rational[301, 338]}, {
         Rational[5, 13], Rational[5, 13], Rational[313, 338]}, {
         Rational[5, 13], Rational[7, 13], Rational[301, 338]}}, {{
        0.5384615384615384, 0.5384615384615384, 0.8550295857988166}, {
        0.5384615384615384, 0.38461538461538464`, 0.8905325443786982}, {
        0.38461538461538464`, 0.38461538461538464`, 0.9260355029585798}, {
        0.38461538461538464`, 0.5384615384615384, 0.8905325443786982}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[9, 13], Rational[21, 26]}, {
         Rational[7, 13], Rational[7, 13], Rational[289, 338]}, {
         Rational[5, 13], Rational[7, 13], Rational[301, 338]}, {
         Rational[5, 13], Rational[9, 13], Rational[285, 338]}}, {{
        0.5384615384615384, 0.6923076923076923, 0.8076923076923077}, {
        0.5384615384615384, 0.5384615384615384, 0.8550295857988166}, {
        0.38461538461538464`, 0.5384615384615384, 0.8905325443786982}, {
        0.38461538461538464`, 0.6923076923076923, 0.8431952662721893}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[11, 13], Rational[253, 338]}, {
         Rational[7, 13], Rational[9, 13], Rational[21, 26]}, {
         Rational[5, 13], Rational[9, 13], Rational[285, 338]}, {
         Rational[5, 13], Rational[11, 13], Rational[265, 338]}}, {{
        0.5384615384615384, 0.8461538461538461, 0.7485207100591716}, {
        0.5384615384615384, 0.6923076923076923, 0.8076923076923077}, {
        0.38461538461538464`, 0.6923076923076923, 0.8431952662721893}, {
        0.38461538461538464`, 0.8461538461538461, 0.7840236686390533}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], 1, Rational[229, 338]}, {
         Rational[7, 13], Rational[11, 13], Rational[253, 338]}, {
         Rational[5, 13], Rational[11, 13], Rational[265, 338]}, {
         Rational[5, 13], 1, Rational[241, 338]}}, {{
         0.5384615384615384, 1, 0.6775147928994083}, {0.5384615384615384, 
         0.8461538461538461, 0.7485207100591716}, {0.38461538461538464`, 
         0.8461538461538461, 0.7840236686390533}, {
         0.38461538461538464`, 1, 0.7130177514792899}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[-11, 13], Rational[237, 338]}, {
         Rational[9, 13], -1, Rational[213, 338]}, {
         Rational[7, 13], -1, Rational[229, 338]}, {
         Rational[7, 13], Rational[-11, 13], Rational[253, 338]}}, {{
         0.6923076923076923, -0.8461538461538461, 0.7011834319526628}, {
         0.6923076923076923, -1, 0.6301775147928994}, {
         0.5384615384615384, -1, 0.6775147928994083}, {
         0.5384615384615384, -0.8461538461538461, 0.7485207100591716}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[-9, 13], Rational[257, 338]}, {
         Rational[9, 13], Rational[-11, 13], Rational[237, 338]}, {
         Rational[7, 13], Rational[-11, 13], Rational[253, 338]}, {
         Rational[7, 13], Rational[-9, 13], Rational[21, 26]}}, {{
        0.6923076923076923, -0.6923076923076923, 0.7603550295857988}, {
        0.6923076923076923, -0.8461538461538461, 0.7011834319526628}, {
        0.5384615384615384, -0.8461538461538461, 0.7485207100591716}, {
        0.5384615384615384, -0.6923076923076923, 0.8076923076923077}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[-7, 13], Rational[21, 26]}, {
         Rational[9, 13], Rational[-9, 13], Rational[257, 338]}, {
         Rational[7, 13], Rational[-9, 13], Rational[21, 26]}, {
         Rational[7, 13], Rational[-7, 13], Rational[289, 338]}}, {{
        0.6923076923076923, -0.5384615384615384, 0.8076923076923077}, {
        0.6923076923076923, -0.6923076923076923, 0.7603550295857988}, {
        0.5384615384615384, -0.6923076923076923, 0.8076923076923077}, {
        0.5384615384615384, -0.5384615384615384, 0.8550295857988166}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[-5, 13], Rational[285, 338]}, {
         Rational[9, 13], Rational[-7, 13], Rational[21, 26]}, {
         Rational[7, 13], Rational[-7, 13], Rational[289, 338]}, {
         Rational[7, 13], Rational[-5, 13], Rational[301, 338]}}, {{
        0.6923076923076923, -0.38461538461538464`, 0.8431952662721893}, {
        0.6923076923076923, -0.5384615384615384, 0.8076923076923077}, {
        0.5384615384615384, -0.5384615384615384, 0.8550295857988166}, {
        0.5384615384615384, -0.38461538461538464`, 0.8905325443786982}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[-3, 13], Rational[293, 338]}, {
         Rational[9, 13], Rational[-5, 13], Rational[285, 338]}, {
         Rational[7, 13], Rational[-5, 13], Rational[301, 338]}, {
         Rational[7, 13], Rational[-3, 13], Rational[309, 338]}}, {{
        0.6923076923076923, -0.23076923076923078`, 0.8668639053254438}, {
        0.6923076923076923, -0.38461538461538464`, 0.8431952662721893}, {
        0.5384615384615384, -0.38461538461538464`, 0.8905325443786982}, {
        0.5384615384615384, -0.23076923076923078`, 0.9142011834319527}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[-1, 13], Rational[297, 338]}, {
         Rational[9, 13], Rational[-3, 13], Rational[293, 338]}, {
         Rational[7, 13], Rational[-3, 13], Rational[309, 338]}, {
         Rational[7, 13], Rational[-1, 13], Rational[313, 338]}}, {{
        0.6923076923076923, -0.07692307692307693, 0.878698224852071}, {
        0.6923076923076923, -0.23076923076923078`, 0.8668639053254438}, {
        0.5384615384615384, -0.23076923076923078`, 0.9142011834319527}, {
        0.5384615384615384, -0.07692307692307693, 0.9260355029585798}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[1, 13], Rational[297, 338]}, {
         Rational[9, 13], Rational[-1, 13], Rational[297, 338]}, {
         Rational[7, 13], Rational[-1, 13], Rational[313, 338]}, {
         Rational[7, 13], Rational[1, 13], Rational[313, 338]}}, {{
        0.6923076923076923, 0.07692307692307693, 0.878698224852071}, {
        0.6923076923076923, -0.07692307692307693, 0.878698224852071}, {
        0.5384615384615384, -0.07692307692307693, 0.9260355029585798}, {
        0.5384615384615384, 0.07692307692307693, 0.9260355029585798}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[3, 13], Rational[293, 338]}, {
         Rational[9, 13], Rational[1, 13], Rational[297, 338]}, {
         Rational[7, 13], Rational[1, 13], Rational[313, 338]}, {
         Rational[7, 13], Rational[3, 13], Rational[309, 338]}}, {{
        0.6923076923076923, 0.23076923076923078`, 0.8668639053254438}, {
        0.6923076923076923, 0.07692307692307693, 0.878698224852071}, {
        0.5384615384615384, 0.07692307692307693, 0.9260355029585798}, {
        0.5384615384615384, 0.23076923076923078`, 0.9142011834319527}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[5, 13], Rational[285, 338]}, {
         Rational[9, 13], Rational[3, 13], Rational[293, 338]}, {
         Rational[7, 13], Rational[3, 13], Rational[309, 338]}, {
         Rational[7, 13], Rational[5, 13], Rational[301, 338]}}, {{
        0.6923076923076923, 0.38461538461538464`, 0.8431952662721893}, {
        0.6923076923076923, 0.23076923076923078`, 0.8668639053254438}, {
        0.5384615384615384, 0.23076923076923078`, 0.9142011834319527}, {
        0.5384615384615384, 0.38461538461538464`, 0.8905325443786982}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[7, 13], Rational[21, 26]}, {
         Rational[9, 13], Rational[5, 13], Rational[285, 338]}, {
         Rational[7, 13], Rational[5, 13], Rational[301, 338]}, {
         Rational[7, 13], Rational[7, 13], Rational[289, 338]}}, {{
        0.6923076923076923, 0.5384615384615384, 0.8076923076923077}, {
        0.6923076923076923, 0.38461538461538464`, 0.8431952662721893}, {
        0.5384615384615384, 0.38461538461538464`, 0.8905325443786982}, {
        0.5384615384615384, 0.5384615384615384, 0.8550295857988166}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[9, 13], Rational[257, 338]}, {
         Rational[9, 13], Rational[7, 13], Rational[21, 26]}, {
         Rational[7, 13], Rational[7, 13], Rational[289, 338]}, {
         Rational[7, 13], Rational[9, 13], Rational[21, 26]}}, {{
        0.6923076923076923, 0.6923076923076923, 0.7603550295857988}, {
        0.6923076923076923, 0.5384615384615384, 0.8076923076923077}, {
        0.5384615384615384, 0.5384615384615384, 0.8550295857988166}, {
        0.5384615384615384, 0.6923076923076923, 0.8076923076923077}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[11, 13], Rational[237, 338]}, {
         Rational[9, 13], Rational[9, 13], Rational[257, 338]}, {
         Rational[7, 13], Rational[9, 13], Rational[21, 26]}, {
         Rational[7, 13], Rational[11, 13], Rational[253, 338]}}, {{
        0.6923076923076923, 0.8461538461538461, 0.7011834319526628}, {
        0.6923076923076923, 0.6923076923076923, 0.7603550295857988}, {
        0.5384615384615384, 0.6923076923076923, 0.8076923076923077}, {
        0.5384615384615384, 0.8461538461538461, 0.7485207100591716}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], 1, Rational[213, 338]}, {
         Rational[9, 13], Rational[11, 13], Rational[237, 338]}, {
         Rational[7, 13], Rational[11, 13], Rational[253, 338]}, {
         Rational[7, 13], 1, Rational[229, 338]}}, {{
         0.6923076923076923, 1, 0.6301775147928994}, {0.6923076923076923, 
         0.8461538461538461, 0.7011834319526628}, {0.5384615384615384, 
         0.8461538461538461, 0.7485207100591716}, {
         0.5384615384615384, 1, 0.6775147928994083}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[-11, 13], Rational[217, 338]}, {
         Rational[11, 13], -1, Rational[193, 338]}, {
         Rational[9, 13], -1, Rational[213, 338]}, {
         Rational[9, 13], Rational[-11, 13], Rational[237, 338]}}, {{
         0.8461538461538461, -0.8461538461538461, 0.6420118343195266}, {
         0.8461538461538461, -1, 0.5710059171597633}, {
         0.6923076923076923, -1, 0.6301775147928994}, {
         0.6923076923076923, -0.8461538461538461, 0.7011834319526628}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[-9, 13], Rational[237, 338]}, {
         Rational[11, 13], Rational[-11, 13], Rational[217, 338]}, {
         Rational[9, 13], Rational[-11, 13], Rational[237, 338]}, {
         Rational[9, 13], Rational[-9, 13], Rational[257, 338]}}, {{
        0.8461538461538461, -0.6923076923076923, 0.7011834319526628}, {
        0.8461538461538461, -0.8461538461538461, 0.6420118343195266}, {
        0.6923076923076923, -0.8461538461538461, 0.7011834319526628}, {
        0.6923076923076923, -0.6923076923076923, 0.7603550295857988}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[-7, 13], Rational[253, 338]}, {
         Rational[11, 13], Rational[-9, 13], Rational[237, 338]}, {
         Rational[9, 13], Rational[-9, 13], Rational[257, 338]}, {
         Rational[9, 13], Rational[-7, 13], Rational[21, 26]}}, {{
        0.8461538461538461, -0.5384615384615384, 0.7485207100591716}, {
        0.8461538461538461, -0.6923076923076923, 0.7011834319526628}, {
        0.6923076923076923, -0.6923076923076923, 0.7603550295857988}, {
        0.6923076923076923, -0.5384615384615384, 0.8076923076923077}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[-5, 13], Rational[265, 338]}, {
         Rational[11, 13], Rational[-7, 13], Rational[253, 338]}, {
         Rational[9, 13], Rational[-7, 13], Rational[21, 26]}, {
         Rational[9, 13], Rational[-5, 13], Rational[285, 338]}}, {{
        0.8461538461538461, -0.38461538461538464`, 0.7840236686390533}, {
        0.8461538461538461, -0.5384615384615384, 0.7485207100591716}, {
        0.6923076923076923, -0.5384615384615384, 0.8076923076923077}, {
        0.6923076923076923, -0.38461538461538464`, 0.8431952662721893}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[-3, 13], Rational[21, 26]}, {
         Rational[11, 13], Rational[-5, 13], Rational[265, 338]}, {
         Rational[9, 13], Rational[-5, 13], Rational[285, 338]}, {
         Rational[9, 13], Rational[-3, 13], Rational[293, 338]}}, {{
        0.8461538461538461, -0.23076923076923078`, 0.8076923076923077}, {
        0.8461538461538461, -0.38461538461538464`, 0.7840236686390533}, {
        0.6923076923076923, -0.38461538461538464`, 0.8431952662721893}, {
        0.6923076923076923, -0.23076923076923078`, 0.8668639053254438}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[-1, 13], Rational[277, 338]}, {
         Rational[11, 13], Rational[-3, 13], Rational[21, 26]}, {
         Rational[9, 13], Rational[-3, 13], Rational[293, 338]}, {
         Rational[9, 13], Rational[-1, 13], Rational[297, 338]}}, {{
        0.8461538461538461, -0.07692307692307693, 0.8195266272189349}, {
        0.8461538461538461, -0.23076923076923078`, 0.8076923076923077}, {
        0.6923076923076923, -0.23076923076923078`, 0.8668639053254438}, {
        0.6923076923076923, -0.07692307692307693, 0.878698224852071}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[1, 13], Rational[277, 338]}, {
         Rational[11, 13], Rational[-1, 13], Rational[277, 338]}, {
         Rational[9, 13], Rational[-1, 13], Rational[297, 338]}, {
         Rational[9, 13], Rational[1, 13], Rational[297, 338]}}, {{
        0.8461538461538461, 0.07692307692307693, 0.8195266272189349}, {
        0.8461538461538461, -0.07692307692307693, 0.8195266272189349}, {
        0.6923076923076923, -0.07692307692307693, 0.878698224852071}, {
        0.6923076923076923, 0.07692307692307693, 0.878698224852071}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[3, 13], Rational[21, 26]}, {
         Rational[11, 13], Rational[1, 13], Rational[277, 338]}, {
         Rational[9, 13], Rational[1, 13], Rational[297, 338]}, {
         Rational[9, 13], Rational[3, 13], Rational[293, 338]}}, {{
        0.8461538461538461, 0.23076923076923078`, 0.8076923076923077}, {
        0.8461538461538461, 0.07692307692307693, 0.8195266272189349}, {
        0.6923076923076923, 0.07692307692307693, 0.878698224852071}, {
        0.6923076923076923, 0.23076923076923078`, 0.8668639053254438}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[5, 13], Rational[265, 338]}, {
         Rational[11, 13], Rational[3, 13], Rational[21, 26]}, {
         Rational[9, 13], Rational[3, 13], Rational[293, 338]}, {
         Rational[9, 13], Rational[5, 13], Rational[285, 338]}}, {{
        0.8461538461538461, 0.38461538461538464`, 0.7840236686390533}, {
        0.8461538461538461, 0.23076923076923078`, 0.8076923076923077}, {
        0.6923076923076923, 0.23076923076923078`, 0.8668639053254438}, {
        0.6923076923076923, 0.38461538461538464`, 0.8431952662721893}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[7, 13], Rational[253, 338]}, {
         Rational[11, 13], Rational[5, 13], Rational[265, 338]}, {
         Rational[9, 13], Rational[5, 13], Rational[285, 338]}, {
         Rational[9, 13], Rational[7, 13], Rational[21, 26]}}, {{
        0.8461538461538461, 0.5384615384615384, 0.7485207100591716}, {
        0.8461538461538461, 0.38461538461538464`, 0.7840236686390533}, {
        0.6923076923076923, 0.38461538461538464`, 0.8431952662721893}, {
        0.6923076923076923, 0.5384615384615384, 0.8076923076923077}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[9, 13], Rational[237, 338]}, {
         Rational[11, 13], Rational[7, 13], Rational[253, 338]}, {
         Rational[9, 13], Rational[7, 13], Rational[21, 26]}, {
         Rational[9, 13], Rational[9, 13], Rational[257, 338]}}, {{
        0.8461538461538461, 0.6923076923076923, 0.7011834319526628}, {
        0.8461538461538461, 0.5384615384615384, 0.7485207100591716}, {
        0.6923076923076923, 0.5384615384615384, 0.8076923076923077}, {
        0.6923076923076923, 0.6923076923076923, 0.7603550295857988}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[11, 13], Rational[217, 338]}, {
         Rational[11, 13], Rational[9, 13], Rational[237, 338]}, {
         Rational[9, 13], Rational[9, 13], Rational[257, 338]}, {
         Rational[9, 13], Rational[11, 13], Rational[237, 338]}}, {{
        0.8461538461538461, 0.8461538461538461, 0.6420118343195266}, {
        0.8461538461538461, 0.6923076923076923, 0.7011834319526628}, {
        0.6923076923076923, 0.6923076923076923, 0.7603550295857988}, {
        0.6923076923076923, 0.8461538461538461, 0.7011834319526628}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], 1, Rational[193, 338]}, {
         Rational[11, 13], Rational[11, 13], Rational[217, 338]}, {
         Rational[9, 13], Rational[11, 13], Rational[237, 338]}, {
         Rational[9, 13], 1, Rational[213, 338]}}, {{
         0.8461538461538461, 1, 0.5710059171597633}, {0.8461538461538461, 
         0.8461538461538461, 0.6420118343195266}, {0.6923076923076923, 
         0.8461538461538461, 0.7011834319526628}, {
         0.6923076923076923, 1, 0.6301775147928994}}]]}, {
      Polygon3DBox[
       NCache[{{1, Rational[-11, 13], Rational[193, 338]}, {
         1, -1, Rational[1, 2]}, {Rational[11, 13], -1, Rational[193, 338]}, {
         Rational[11, 13], Rational[-11, 13], Rational[217, 338]}}, {{
         1, -0.8461538461538461, 0.5710059171597633}, {1, -1, 0.5}, {
         0.8461538461538461, -1, 0.5710059171597633}, {
         0.8461538461538461, -0.8461538461538461, 0.6420118343195266}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[-9, 13], Rational[213, 338]}, {
         1, Rational[-11, 13], Rational[193, 338]}, {
         Rational[11, 13], Rational[-11, 13], Rational[217, 338]}, {
         Rational[11, 13], Rational[-9, 13], Rational[237, 338]}}, {{
         1, -0.6923076923076923, 0.6301775147928994}, {
         1, -0.8461538461538461, 0.5710059171597633}, {
         0.8461538461538461, -0.8461538461538461, 0.6420118343195266}, {
         0.8461538461538461, -0.6923076923076923, 0.7011834319526628}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[-7, 13], Rational[229, 338]}, {
         1, Rational[-9, 13], Rational[213, 338]}, {
         Rational[11, 13], Rational[-9, 13], Rational[237, 338]}, {
         Rational[11, 13], Rational[-7, 13], Rational[253, 338]}}, {{
         1, -0.5384615384615384, 0.6775147928994083}, {
         1, -0.6923076923076923, 0.6301775147928994}, {
         0.8461538461538461, -0.6923076923076923, 0.7011834319526628}, {
         0.8461538461538461, -0.5384615384615384, 0.7485207100591716}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[-5, 13], Rational[241, 338]}, {
         1, Rational[-7, 13], Rational[229, 338]}, {
         Rational[11, 13], Rational[-7, 13], Rational[253, 338]}, {
         Rational[11, 13], Rational[-5, 13], Rational[265, 338]}}, {{
         1, -0.38461538461538464`, 0.7130177514792899}, {
         1, -0.5384615384615384, 0.6775147928994083}, {
         0.8461538461538461, -0.5384615384615384, 0.7485207100591716}, {
         0.8461538461538461, -0.38461538461538464`, 0.7840236686390533}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[-3, 13], Rational[249, 338]}, {
         1, Rational[-5, 13], Rational[241, 338]}, {
         Rational[11, 13], Rational[-5, 13], Rational[265, 338]}, {
         Rational[11, 13], Rational[-3, 13], Rational[21, 26]}}, {{
         1, -0.23076923076923078`, 0.7366863905325444}, {
         1, -0.38461538461538464`, 0.7130177514792899}, {
         0.8461538461538461, -0.38461538461538464`, 0.7840236686390533}, {
         0.8461538461538461, -0.23076923076923078`, 0.8076923076923077}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[-1, 13], Rational[253, 338]}, {
         1, Rational[-3, 13], Rational[249, 338]}, {
         Rational[11, 13], Rational[-3, 13], Rational[21, 26]}, {
         Rational[11, 13], Rational[-1, 13], Rational[277, 338]}}, {{
         1, -0.07692307692307693, 0.7485207100591716}, {
         1, -0.23076923076923078`, 0.7366863905325444}, {
         0.8461538461538461, -0.23076923076923078`, 0.8076923076923077}, {
         0.8461538461538461, -0.07692307692307693, 0.8195266272189349}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[1, 13], Rational[253, 338]}, {
         1, Rational[-1, 13], Rational[253, 338]}, {
         Rational[11, 13], Rational[-1, 13], Rational[277, 338]}, {
         Rational[11, 13], Rational[1, 13], Rational[277, 338]}}, {{
         1, 0.07692307692307693, 0.7485207100591716}, {
         1, -0.07692307692307693, 0.7485207100591716}, {
         0.8461538461538461, -0.07692307692307693, 0.8195266272189349}, {
         0.8461538461538461, 0.07692307692307693, 0.8195266272189349}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[3, 13], Rational[249, 338]}, {
         1, Rational[1, 13], Rational[253, 338]}, {
         Rational[11, 13], Rational[1, 13], Rational[277, 338]}, {
         Rational[11, 13], Rational[3, 13], Rational[21, 26]}}, {{
         1, 0.23076923076923078`, 0.7366863905325444}, {
         1, 0.07692307692307693, 0.7485207100591716}, {0.8461538461538461, 
         0.07692307692307693, 0.8195266272189349}, {0.8461538461538461, 
         0.23076923076923078`, 0.8076923076923077}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[5, 13], Rational[241, 338]}, {
         1, Rational[3, 13], Rational[249, 338]}, {
         Rational[11, 13], Rational[3, 13], Rational[21, 26]}, {
         Rational[11, 13], Rational[5, 13], Rational[265, 338]}}, {{
         1, 0.38461538461538464`, 0.7130177514792899}, {
         1, 0.23076923076923078`, 0.7366863905325444}, {0.8461538461538461, 
         0.23076923076923078`, 0.8076923076923077}, {0.8461538461538461, 
         0.38461538461538464`, 0.7840236686390533}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[7, 13], Rational[229, 338]}, {
         1, Rational[5, 13], Rational[241, 338]}, {
         Rational[11, 13], Rational[5, 13], Rational[265, 338]}, {
         Rational[11, 13], Rational[7, 13], Rational[253, 338]}}, {{
         1, 0.5384615384615384, 0.6775147928994083}, {
         1, 0.38461538461538464`, 0.7130177514792899}, {0.8461538461538461, 
         0.38461538461538464`, 0.7840236686390533}, {0.8461538461538461, 
         0.5384615384615384, 0.7485207100591716}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[9, 13], Rational[213, 338]}, {
         1, Rational[7, 13], Rational[229, 338]}, {
         Rational[11, 13], Rational[7, 13], Rational[253, 338]}, {
         Rational[11, 13], Rational[9, 13], Rational[237, 338]}}, {{
         1, 0.6923076923076923, 0.6301775147928994}, {
         1, 0.5384615384615384, 0.6775147928994083}, {0.8461538461538461, 
         0.5384615384615384, 0.7485207100591716}, {0.8461538461538461, 
         0.6923076923076923, 0.7011834319526628}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[11, 13], Rational[193, 338]}, {
         1, Rational[9, 13], Rational[213, 338]}, {
         Rational[11, 13], Rational[9, 13], Rational[237, 338]}, {
         Rational[11, 13], Rational[11, 13], Rational[217, 338]}}, {{
         1, 0.8461538461538461, 0.5710059171597633}, {
         1, 0.6923076923076923, 0.6301775147928994}, {0.8461538461538461, 
         0.6923076923076923, 0.7011834319526628}, {0.8461538461538461, 
         0.8461538461538461, 0.6420118343195266}}]], 
      Polygon3DBox[
       NCache[{{1, 1, Rational[1, 2]}, {
         1, Rational[11, 13], Rational[193, 338]}, {
         Rational[11, 13], Rational[11, 13], Rational[217, 338]}, {
         Rational[11, 13], 1, Rational[193, 338]}}, {{1, 1, 0.5}, {
         1, 0.8461538461538461, 0.5710059171597633}, {0.8461538461538461, 
         0.8461538461538461, 0.6420118343195266}, {
         0.8461538461538461, 1, 0.5710059171597633}}]]}}, 
    {EdgeForm[GrayLevel[
     0.5]], {Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[-11, 13], 1.5480769230769231`}, {
         Rational[-11, 13], -1, 1.5865384615384617`}, {-1, -1, 1.625}, {-1, 
          Rational[-11, 13], 
          1.5865384615384617`}}, {{-0.8461538461538461, -0.8461538461538461, 
         1.5480769230769231`}, {-0.8461538461538461, -1, 
          1.5865384615384617`}, {-1, -1, 1.625}, {-1, -0.8461538461538461, 
          1.5865384615384617`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[-9, 13], 1.5096153846153846`}, {
         Rational[-11, 13], Rational[-11, 13], 1.5480769230769231`}, {-1, 
          Rational[-11, 13], 1.5865384615384617`}, {-1, Rational[-9, 13], 
          1.5480769230769231`}}, {{-0.8461538461538461, -0.6923076923076923, 
         1.5096153846153846`}, {-0.8461538461538461, -0.8461538461538461, 
         1.5480769230769231`}, {-1, -0.8461538461538461, 
          1.5865384615384617`}, {-1, -0.6923076923076923, 
          1.5480769230769231`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[-7, 13], 1.4711538461538463`}, {
         Rational[-11, 13], Rational[-9, 13], 1.5096153846153846`}, {-1, 
          Rational[-9, 13], 1.5480769230769231`}, {-1, Rational[-7, 13], 
          1.5096153846153846`}}, {{-0.8461538461538461, -0.5384615384615384, 
         1.4711538461538463`}, {-0.8461538461538461, -0.6923076923076923, 
         1.5096153846153846`}, {-1, -0.6923076923076923, 
          1.5480769230769231`}, {-1, -0.5384615384615384, 
          1.5096153846153846`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[-5, 13], 1.4326923076923077`}, {
         Rational[-11, 13], Rational[-7, 13], 1.4711538461538463`}, {-1, 
          Rational[-7, 13], 1.5096153846153846`}, {-1, Rational[-5, 13], 
          1.4711538461538463`}}, {{-0.8461538461538461, -0.38461538461538464`,
          1.4326923076923077`}, {-0.8461538461538461, -0.5384615384615384, 
         1.4711538461538463`}, {-1, -0.5384615384615384, 
          1.5096153846153846`}, {-1, -0.38461538461538464`, 
          1.4711538461538463`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[-3, 13], 1.3942307692307692`}, {
         Rational[-11, 13], Rational[-5, 13], 1.4326923076923077`}, {-1, 
          Rational[-5, 13], 1.4711538461538463`}, {-1, Rational[-3, 13], 
          1.4326923076923077`}}, {{-0.8461538461538461, -0.23076923076923078`,
          1.3942307692307692`}, {-0.8461538461538461, -0.38461538461538464`, 
         1.4326923076923077`}, {-1, -0.38461538461538464`, 
          1.4711538461538463`}, {-1, -0.23076923076923078`, 
          1.4326923076923077`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[-1, 13], 1.3557692307692308`}, {
         Rational[-11, 13], Rational[-3, 13], 1.3942307692307692`}, {-1, 
          Rational[-3, 13], 1.4326923076923077`}, {-1, Rational[-1, 13], 
          1.3942307692307692`}}, {{-0.8461538461538461, -0.07692307692307693, 
         1.3557692307692308`}, {-0.8461538461538461, -0.23076923076923078`, 
         1.3942307692307692`}, {-1, -0.23076923076923078`, 
          1.4326923076923077`}, {-1, -0.07692307692307693, 
          1.3942307692307692`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[1, 13], 1.3173076923076923`}, {
         Rational[-11, 13], Rational[-1, 13], 1.3557692307692308`}, {-1, 
          Rational[-1, 13], 1.3942307692307692`}, {-1, Rational[1, 13], 
          1.3557692307692308`}}, {{-0.8461538461538461, 0.07692307692307693, 
         1.3173076923076923`}, {-0.8461538461538461, -0.07692307692307693, 
         1.3557692307692308`}, {-1, -0.07692307692307693, 
          1.3942307692307692`}, {-1, 0.07692307692307693, 
          1.3557692307692308`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[3, 13], 1.2788461538461537`}, {
         Rational[-11, 13], Rational[1, 13], 1.3173076923076923`}, {-1, 
          Rational[1, 13], 1.3557692307692308`}, {-1, Rational[3, 13], 
          1.3173076923076923`}}, {{-0.8461538461538461, 0.23076923076923078`, 
         1.2788461538461537`}, {-0.8461538461538461, 0.07692307692307693, 
         1.3173076923076923`}, {-1, 0.07692307692307693, 
          1.3557692307692308`}, {-1, 0.23076923076923078`, 
          1.3173076923076923`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[5, 13], 1.2403846153846154`}, {
         Rational[-11, 13], Rational[3, 13], 1.2788461538461537`}, {-1, 
          Rational[3, 13], 1.3173076923076923`}, {-1, Rational[5, 13], 
          1.2788461538461537`}}, {{-0.8461538461538461, 0.38461538461538464`, 
         1.2403846153846154`}, {-0.8461538461538461, 0.23076923076923078`, 
         1.2788461538461537`}, {-1, 0.23076923076923078`, 
          1.3173076923076923`}, {-1, 0.38461538461538464`, 
          1.2788461538461537`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[7, 13], 1.201923076923077}, {
         Rational[-11, 13], Rational[5, 13], 1.2403846153846154`}, {-1, 
          Rational[5, 13], 1.2788461538461537`}, {-1, Rational[7, 13], 
          1.2403846153846154`}}, {{-0.8461538461538461, 0.5384615384615384, 
         1.201923076923077}, {-0.8461538461538461, 0.38461538461538464`, 
         1.2403846153846154`}, {-1, 0.38461538461538464`, 
          1.2788461538461537`}, {-1, 0.5384615384615384, 
          1.2403846153846154`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[9, 13], 1.1634615384615385`}, {
         Rational[-11, 13], Rational[7, 13], 1.201923076923077}, {-1, 
          Rational[7, 13], 1.2403846153846154`}, {-1, Rational[9, 13], 
          1.2019230769230769`}}, {{-0.8461538461538461, 0.6923076923076923, 
         1.1634615384615385`}, {-0.8461538461538461, 0.5384615384615384, 
         1.201923076923077}, {-1, 0.5384615384615384, 
          1.2403846153846154`}, {-1, 0.6923076923076923, 
          1.2019230769230769`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], Rational[11, 13], 1.125}, {
         Rational[-11, 13], Rational[9, 13], 1.1634615384615385`}, {-1, 
          Rational[9, 13], 1.2019230769230769`}, {-1, Rational[11, 13], 
          1.1634615384615383`}}, {{-0.8461538461538461, 0.8461538461538461, 
         1.125}, {-0.8461538461538461, 0.6923076923076923, 
         1.1634615384615385`}, {-1, 0.6923076923076923, 
          1.2019230769230769`}, {-1, 0.8461538461538461, 
          1.1634615384615383`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-11, 13], 1, 1.0865384615384617`}, {
         Rational[-11, 13], Rational[11, 13], 1.125}, {-1, Rational[11, 13], 
          1.1634615384615383`}, {-1, 1, 1.125}}, {{-0.8461538461538461, 1, 
          1.0865384615384617`}, {-0.8461538461538461, 0.8461538461538461, 
         1.125}, {-1, 0.8461538461538461, 1.1634615384615383`}, {-1, 1, 
          1.125}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[-11, 13], 1.5096153846153846`}, {
         Rational[-9, 13], -1, 1.5480769230769231`}, {
         Rational[-11, 13], -1, 1.5865384615384617`}, {
         Rational[-11, 13], Rational[-11, 13], 
          1.5480769230769231`}}, {{-0.6923076923076923, -0.8461538461538461, 
         1.5096153846153846`}, {-0.6923076923076923, -1, 
          1.5480769230769231`}, {-0.8461538461538461, -1, 
          1.5865384615384617`}, {-0.8461538461538461, -0.8461538461538461, 
         1.5480769230769231`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[-9, 13], 1.4711538461538463`}, {
         Rational[-9, 13], Rational[-11, 13], 1.5096153846153846`}, {
         Rational[-11, 13], Rational[-11, 13], 1.5480769230769231`}, {
         Rational[-11, 13], Rational[-9, 13], 
          1.5096153846153846`}}, {{-0.6923076923076923, -0.6923076923076923, 
        1.4711538461538463`}, {-0.6923076923076923, -0.8461538461538461, 
        1.5096153846153846`}, {-0.8461538461538461, -0.8461538461538461, 
        1.5480769230769231`}, {-0.8461538461538461, -0.6923076923076923, 
        1.5096153846153846`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[-7, 13], 1.4326923076923077`}, {
         Rational[-9, 13], Rational[-9, 13], 1.4711538461538463`}, {
         Rational[-11, 13], Rational[-9, 13], 1.5096153846153846`}, {
         Rational[-11, 13], Rational[-7, 13], 
          1.4711538461538463`}}, {{-0.6923076923076923, -0.5384615384615384, 
        1.4326923076923077`}, {-0.6923076923076923, -0.6923076923076923, 
        1.4711538461538463`}, {-0.8461538461538461, -0.6923076923076923, 
        1.5096153846153846`}, {-0.8461538461538461, -0.5384615384615384, 
        1.4711538461538463`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[-5, 13], 1.3942307692307692`}, {
         Rational[-9, 13], Rational[-7, 13], 1.4326923076923077`}, {
         Rational[-11, 13], Rational[-7, 13], 1.4711538461538463`}, {
         Rational[-11, 13], Rational[-5, 13], 
          1.4326923076923077`}}, {{-0.6923076923076923, -0.38461538461538464`,
         1.3942307692307692`}, {-0.6923076923076923, -0.5384615384615384, 
        1.4326923076923077`}, {-0.8461538461538461, -0.5384615384615384, 
        1.4711538461538463`}, {-0.8461538461538461, -0.38461538461538464`, 
        1.4326923076923077`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[-3, 13], 1.3557692307692308`}, {
         Rational[-9, 13], Rational[-5, 13], 1.3942307692307692`}, {
         Rational[-11, 13], Rational[-5, 13], 1.4326923076923077`}, {
         Rational[-11, 13], Rational[-3, 13], 
          1.3942307692307692`}}, {{-0.6923076923076923, -0.23076923076923078`,
         1.3557692307692308`}, {-0.6923076923076923, -0.38461538461538464`, 
        1.3942307692307692`}, {-0.8461538461538461, -0.38461538461538464`, 
        1.4326923076923077`}, {-0.8461538461538461, -0.23076923076923078`, 
        1.3942307692307692`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[-1, 13], 1.3173076923076923`}, {
         Rational[-9, 13], Rational[-3, 13], 1.3557692307692308`}, {
         Rational[-11, 13], Rational[-3, 13], 1.3942307692307692`}, {
         Rational[-11, 13], Rational[-1, 13], 
          1.3557692307692308`}}, {{-0.6923076923076923, -0.07692307692307693, 
        1.3173076923076923`}, {-0.6923076923076923, -0.23076923076923078`, 
        1.3557692307692308`}, {-0.8461538461538461, -0.23076923076923078`, 
        1.3942307692307692`}, {-0.8461538461538461, -0.07692307692307693, 
        1.3557692307692308`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[1, 13], 1.2788461538461537`}, {
         Rational[-9, 13], Rational[-1, 13], 1.3173076923076923`}, {
         Rational[-11, 13], Rational[-1, 13], 1.3557692307692308`}, {
         Rational[-11, 13], Rational[1, 13], 
          1.3173076923076923`}}, {{-0.6923076923076923, 0.07692307692307693, 
        1.2788461538461537`}, {-0.6923076923076923, -0.07692307692307693, 
        1.3173076923076923`}, {-0.8461538461538461, -0.07692307692307693, 
        1.3557692307692308`}, {-0.8461538461538461, 0.07692307692307693, 
        1.3173076923076923`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[3, 13], 1.2403846153846154`}, {
         Rational[-9, 13], Rational[1, 13], 1.2788461538461537`}, {
         Rational[-11, 13], Rational[1, 13], 1.3173076923076923`}, {
         Rational[-11, 13], Rational[3, 13], 
          1.2788461538461537`}}, {{-0.6923076923076923, 0.23076923076923078`, 
        1.2403846153846154`}, {-0.6923076923076923, 0.07692307692307693, 
        1.2788461538461537`}, {-0.8461538461538461, 0.07692307692307693, 
        1.3173076923076923`}, {-0.8461538461538461, 0.23076923076923078`, 
        1.2788461538461537`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[5, 13], 1.2019230769230769`}, {
         Rational[-9, 13], Rational[3, 13], 1.2403846153846154`}, {
         Rational[-11, 13], Rational[3, 13], 1.2788461538461537`}, {
         Rational[-11, 13], Rational[5, 13], 
          1.2403846153846154`}}, {{-0.6923076923076923, 0.38461538461538464`, 
        1.2019230769230769`}, {-0.6923076923076923, 0.23076923076923078`, 
        1.2403846153846154`}, {-0.8461538461538461, 0.23076923076923078`, 
        1.2788461538461537`}, {-0.8461538461538461, 0.38461538461538464`, 
        1.2403846153846154`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[7, 13], 1.1634615384615383`}, {
         Rational[-9, 13], Rational[5, 13], 1.2019230769230769`}, {
         Rational[-11, 13], Rational[5, 13], 1.2403846153846154`}, {
         Rational[-11, 13], Rational[7, 13], 
          1.201923076923077}}, {{-0.6923076923076923, 0.5384615384615384, 
        1.1634615384615383`}, {-0.6923076923076923, 0.38461538461538464`, 
        1.2019230769230769`}, {-0.8461538461538461, 0.38461538461538464`, 
        1.2403846153846154`}, {-0.8461538461538461, 0.5384615384615384, 
        1.201923076923077}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[9, 13], 1.125}, {
         Rational[-9, 13], Rational[7, 13], 1.1634615384615383`}, {
         Rational[-11, 13], Rational[7, 13], 1.201923076923077}, {
         Rational[-11, 13], Rational[9, 13], 
          1.1634615384615385`}}, {{-0.6923076923076923, 0.6923076923076923, 
        1.125}, {-0.6923076923076923, 0.5384615384615384, 
        1.1634615384615383`}, {-0.8461538461538461, 0.5384615384615384, 
        1.201923076923077}, {-0.8461538461538461, 0.6923076923076923, 
        1.1634615384615385`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], Rational[11, 13], 1.0865384615384615`}, {
         Rational[-9, 13], Rational[9, 13], 1.125}, {
         Rational[-11, 13], Rational[9, 13], 1.1634615384615385`}, {
         Rational[-11, 13], Rational[11, 13], 1.125}}, {{-0.6923076923076923, 
        0.8461538461538461, 1.0865384615384615`}, {-0.6923076923076923, 
        0.6923076923076923, 1.125}, {-0.8461538461538461, 0.6923076923076923, 
        1.1634615384615385`}, {-0.8461538461538461, 0.8461538461538461, 
        1.125}}]], 
      Polygon3DBox[
       NCache[{{Rational[-9, 13], 1, 1.0480769230769231`}, {
         Rational[-9, 13], Rational[11, 13], 1.0865384615384615`}, {
         Rational[-11, 13], Rational[11, 13], 1.125}, {
         Rational[-11, 13], 1, 1.0865384615384617`}}, {{-0.6923076923076923, 
          1, 1.0480769230769231`}, {-0.6923076923076923, 0.8461538461538461, 
         1.0865384615384615`}, {-0.8461538461538461, 0.8461538461538461, 
         1.125}, {-0.8461538461538461, 1, 1.0865384615384617`}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[-11, 13], 1.4711538461538463`}, {
         Rational[-7, 13], -1, 1.5096153846153846`}, {
         Rational[-9, 13], -1, 1.5480769230769231`}, {
         Rational[-9, 13], Rational[-11, 13], 
          1.5096153846153846`}}, {{-0.5384615384615384, -0.8461538461538461, 
         1.4711538461538463`}, {-0.5384615384615384, -1, 
          1.5096153846153846`}, {-0.6923076923076923, -1, 
          1.5480769230769231`}, {-0.6923076923076923, -0.8461538461538461, 
         1.5096153846153846`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[-9, 13], 1.4326923076923077`}, {
         Rational[-7, 13], Rational[-11, 13], 1.4711538461538463`}, {
         Rational[-9, 13], Rational[-11, 13], 1.5096153846153846`}, {
         Rational[-9, 13], Rational[-9, 13], 
          1.4711538461538463`}}, {{-0.5384615384615384, -0.6923076923076923, 
        1.4326923076923077`}, {-0.5384615384615384, -0.8461538461538461, 
        1.4711538461538463`}, {-0.6923076923076923, -0.8461538461538461, 
        1.5096153846153846`}, {-0.6923076923076923, -0.6923076923076923, 
        1.4711538461538463`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[-7, 13], 1.3942307692307692`}, {
         Rational[-7, 13], Rational[-9, 13], 1.4326923076923077`}, {
         Rational[-9, 13], Rational[-9, 13], 1.4711538461538463`}, {
         Rational[-9, 13], Rational[-7, 13], 
          1.4326923076923077`}}, {{-0.5384615384615384, -0.5384615384615384, 
        1.3942307692307692`}, {-0.5384615384615384, -0.6923076923076923, 
        1.4326923076923077`}, {-0.6923076923076923, -0.6923076923076923, 
        1.4711538461538463`}, {-0.6923076923076923, -0.5384615384615384, 
        1.4326923076923077`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[-5, 13], 1.3557692307692308`}, {
         Rational[-7, 13], Rational[-7, 13], 1.3942307692307692`}, {
         Rational[-9, 13], Rational[-7, 13], 1.4326923076923077`}, {
         Rational[-9, 13], Rational[-5, 13], 
          1.3942307692307692`}}, {{-0.5384615384615384, -0.38461538461538464`,
         1.3557692307692308`}, {-0.5384615384615384, -0.5384615384615384, 
        1.3942307692307692`}, {-0.6923076923076923, -0.5384615384615384, 
        1.4326923076923077`}, {-0.6923076923076923, -0.38461538461538464`, 
        1.3942307692307692`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[-3, 13], 1.3173076923076923`}, {
         Rational[-7, 13], Rational[-5, 13], 1.3557692307692308`}, {
         Rational[-9, 13], Rational[-5, 13], 1.3942307692307692`}, {
         Rational[-9, 13], Rational[-3, 13], 
          1.3557692307692308`}}, {{-0.5384615384615384, -0.23076923076923078`,
         1.3173076923076923`}, {-0.5384615384615384, -0.38461538461538464`, 
        1.3557692307692308`}, {-0.6923076923076923, -0.38461538461538464`, 
        1.3942307692307692`}, {-0.6923076923076923, -0.23076923076923078`, 
        1.3557692307692308`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[-1, 13], 1.2788461538461537`}, {
         Rational[-7, 13], Rational[-3, 13], 1.3173076923076923`}, {
         Rational[-9, 13], Rational[-3, 13], 1.3557692307692308`}, {
         Rational[-9, 13], Rational[-1, 13], 
          1.3173076923076923`}}, {{-0.5384615384615384, -0.07692307692307693, 
        1.2788461538461537`}, {-0.5384615384615384, -0.23076923076923078`, 
        1.3173076923076923`}, {-0.6923076923076923, -0.23076923076923078`, 
        1.3557692307692308`}, {-0.6923076923076923, -0.07692307692307693, 
        1.3173076923076923`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[1, 13], 1.2403846153846154`}, {
         Rational[-7, 13], Rational[-1, 13], 1.2788461538461537`}, {
         Rational[-9, 13], Rational[-1, 13], 1.3173076923076923`}, {
         Rational[-9, 13], Rational[1, 13], 
          1.2788461538461537`}}, {{-0.5384615384615384, 0.07692307692307693, 
        1.2403846153846154`}, {-0.5384615384615384, -0.07692307692307693, 
        1.2788461538461537`}, {-0.6923076923076923, -0.07692307692307693, 
        1.3173076923076923`}, {-0.6923076923076923, 0.07692307692307693, 
        1.2788461538461537`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[3, 13], 1.2019230769230769`}, {
         Rational[-7, 13], Rational[1, 13], 1.2403846153846154`}, {
         Rational[-9, 13], Rational[1, 13], 1.2788461538461537`}, {
         Rational[-9, 13], Rational[3, 13], 
          1.2403846153846154`}}, {{-0.5384615384615384, 0.23076923076923078`, 
        1.2019230769230769`}, {-0.5384615384615384, 0.07692307692307693, 
        1.2403846153846154`}, {-0.6923076923076923, 0.07692307692307693, 
        1.2788461538461537`}, {-0.6923076923076923, 0.23076923076923078`, 
        1.2403846153846154`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[5, 13], 1.1634615384615383`}, {
         Rational[-7, 13], Rational[3, 13], 1.2019230769230769`}, {
         Rational[-9, 13], Rational[3, 13], 1.2403846153846154`}, {
         Rational[-9, 13], Rational[5, 13], 
          1.2019230769230769`}}, {{-0.5384615384615384, 0.38461538461538464`, 
        1.1634615384615383`}, {-0.5384615384615384, 0.23076923076923078`, 
        1.2019230769230769`}, {-0.6923076923076923, 0.23076923076923078`, 
        1.2403846153846154`}, {-0.6923076923076923, 0.38461538461538464`, 
        1.2019230769230769`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[7, 13], 1.125}, {
         Rational[-7, 13], Rational[5, 13], 1.1634615384615383`}, {
         Rational[-9, 13], Rational[5, 13], 1.2019230769230769`}, {
         Rational[-9, 13], Rational[7, 13], 
          1.1634615384615383`}}, {{-0.5384615384615384, 0.5384615384615384, 
        1.125}, {-0.5384615384615384, 0.38461538461538464`, 
        1.1634615384615383`}, {-0.6923076923076923, 0.38461538461538464`, 
        1.2019230769230769`}, {-0.6923076923076923, 0.5384615384615384, 
        1.1634615384615383`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[9, 13], 1.0865384615384615`}, {
         Rational[-7, 13], Rational[7, 13], 1.125}, {
         Rational[-9, 13], Rational[7, 13], 1.1634615384615383`}, {
         Rational[-9, 13], Rational[9, 13], 1.125}}, {{-0.5384615384615384, 
        0.6923076923076923, 1.0865384615384615`}, {-0.5384615384615384, 
        0.5384615384615384, 1.125}, {-0.6923076923076923, 0.5384615384615384, 
        1.1634615384615383`}, {-0.6923076923076923, 0.6923076923076923, 
        1.125}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], Rational[11, 13], 1.0480769230769231`}, {
         Rational[-7, 13], Rational[9, 13], 1.0865384615384615`}, {
         Rational[-9, 13], Rational[9, 13], 1.125}, {
         Rational[-9, 13], Rational[11, 13], 
          1.0865384615384615`}}, {{-0.5384615384615384, 0.8461538461538461, 
        1.0480769230769231`}, {-0.5384615384615384, 0.6923076923076923, 
        1.0865384615384615`}, {-0.6923076923076923, 0.6923076923076923, 
        1.125}, {-0.6923076923076923, 0.8461538461538461, 
        1.0865384615384615`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-7, 13], 1, 1.0096153846153846`}, {
         Rational[-7, 13], Rational[11, 13], 1.0480769230769231`}, {
         Rational[-9, 13], Rational[11, 13], 1.0865384615384615`}, {
         Rational[-9, 13], 1, 1.0480769230769231`}}, {{-0.5384615384615384, 1,
           1.0096153846153846`}, {-0.5384615384615384, 0.8461538461538461, 
         1.0480769230769231`}, {-0.6923076923076923, 0.8461538461538461, 
         1.0865384615384615`}, {-0.6923076923076923, 1, 
          1.0480769230769231`}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[-11, 13], 1.4326923076923077`}, {
         Rational[-5, 13], -1, 1.4711538461538463`}, {
         Rational[-7, 13], -1, 1.5096153846153846`}, {
         Rational[-7, 13], Rational[-11, 13], 
          1.4711538461538463`}}, {{-0.38461538461538464`, -0.8461538461538461,
          1.4326923076923077`}, {-0.38461538461538464`, -1, 
          1.4711538461538463`}, {-0.5384615384615384, -1, 
          1.5096153846153846`}, {-0.5384615384615384, -0.8461538461538461, 
         1.4711538461538463`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[-9, 13], 1.3942307692307692`}, {
         Rational[-5, 13], Rational[-11, 13], 1.4326923076923077`}, {
         Rational[-7, 13], Rational[-11, 13], 1.4711538461538463`}, {
         Rational[-7, 13], Rational[-9, 13], 
          1.4326923076923077`}}, {{-0.38461538461538464`, -0.6923076923076923,
         1.3942307692307692`}, {-0.38461538461538464`, -0.8461538461538461, 
        1.4326923076923077`}, {-0.5384615384615384, -0.8461538461538461, 
        1.4711538461538463`}, {-0.5384615384615384, -0.6923076923076923, 
        1.4326923076923077`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[-7, 13], 1.3557692307692308`}, {
         Rational[-5, 13], Rational[-9, 13], 1.3942307692307692`}, {
         Rational[-7, 13], Rational[-9, 13], 1.4326923076923077`}, {
         Rational[-7, 13], Rational[-7, 13], 
          1.3942307692307692`}}, {{-0.38461538461538464`, -0.5384615384615384,
         1.3557692307692308`}, {-0.38461538461538464`, -0.6923076923076923, 
        1.3942307692307692`}, {-0.5384615384615384, -0.6923076923076923, 
        1.4326923076923077`}, {-0.5384615384615384, -0.5384615384615384, 
        1.3942307692307692`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[-5, 13], 1.3173076923076923`}, {
         Rational[-5, 13], Rational[-7, 13], 1.3557692307692308`}, {
         Rational[-7, 13], Rational[-7, 13], 1.3942307692307692`}, {
         Rational[-7, 13], Rational[-5, 13], 
          1.3557692307692308`}}, {{-0.38461538461538464`, \
-0.38461538461538464`, 
        1.3173076923076923`}, {-0.38461538461538464`, -0.5384615384615384, 
        1.3557692307692308`}, {-0.5384615384615384, -0.5384615384615384, 
        1.3942307692307692`}, {-0.5384615384615384, -0.38461538461538464`, 
        1.3557692307692308`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[-3, 13], 1.2788461538461537`}, {
         Rational[-5, 13], Rational[-5, 13], 1.3173076923076923`}, {
         Rational[-7, 13], Rational[-5, 13], 1.3557692307692308`}, {
         Rational[-7, 13], Rational[-3, 13], 
          1.3173076923076923`}}, {{-0.38461538461538464`, \
-0.23076923076923078`, 
        1.2788461538461537`}, {-0.38461538461538464`, -0.38461538461538464`, 
        1.3173076923076923`}, {-0.5384615384615384, -0.38461538461538464`, 
        1.3557692307692308`}, {-0.5384615384615384, -0.23076923076923078`, 
        1.3173076923076923`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[-1, 13], 1.2403846153846154`}, {
         Rational[-5, 13], Rational[-3, 13], 1.2788461538461537`}, {
         Rational[-7, 13], Rational[-3, 13], 1.3173076923076923`}, {
         Rational[-7, 13], Rational[-1, 13], 
          1.2788461538461537`}}, {{-0.38461538461538464`, \
-0.07692307692307693, 
        1.2403846153846154`}, {-0.38461538461538464`, -0.23076923076923078`, 
        1.2788461538461537`}, {-0.5384615384615384, -0.23076923076923078`, 
        1.3173076923076923`}, {-0.5384615384615384, -0.07692307692307693, 
        1.2788461538461537`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[1, 13], 1.2019230769230769`}, {
         Rational[-5, 13], Rational[-1, 13], 1.2403846153846154`}, {
         Rational[-7, 13], Rational[-1, 13], 1.2788461538461537`}, {
         Rational[-7, 13], Rational[1, 13], 
          1.2403846153846154`}}, {{-0.38461538461538464`, 0.07692307692307693,
         1.2019230769230769`}, {-0.38461538461538464`, -0.07692307692307693, 
        1.2403846153846154`}, {-0.5384615384615384, -0.07692307692307693, 
        1.2788461538461537`}, {-0.5384615384615384, 0.07692307692307693, 
        1.2403846153846154`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[3, 13], 1.1634615384615383`}, {
         Rational[-5, 13], Rational[1, 13], 1.2019230769230769`}, {
         Rational[-7, 13], Rational[1, 13], 1.2403846153846154`}, {
         Rational[-7, 13], Rational[3, 13], 
          1.2019230769230769`}}, {{-0.38461538461538464`, 
        0.23076923076923078`, 1.1634615384615383`}, {-0.38461538461538464`, 
        0.07692307692307693, 1.2019230769230769`}, {-0.5384615384615384, 
        0.07692307692307693, 1.2403846153846154`}, {-0.5384615384615384, 
        0.23076923076923078`, 1.2019230769230769`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[5, 13], 1.125}, {
         Rational[-5, 13], Rational[3, 13], 1.1634615384615383`}, {
         Rational[-7, 13], Rational[3, 13], 1.2019230769230769`}, {
         Rational[-7, 13], Rational[5, 13], 
          1.1634615384615383`}}, {{-0.38461538461538464`, 
        0.38461538461538464`, 1.125}, {-0.38461538461538464`, 
        0.23076923076923078`, 1.1634615384615383`}, {-0.5384615384615384, 
        0.23076923076923078`, 1.2019230769230769`}, {-0.5384615384615384, 
        0.38461538461538464`, 1.1634615384615383`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[7, 13], 1.0865384615384615`}, {
         Rational[-5, 13], Rational[5, 13], 1.125}, {
         Rational[-7, 13], Rational[5, 13], 1.1634615384615383`}, {
         Rational[-7, 13], Rational[7, 13], 1.125}}, {{-0.38461538461538464`, 
        0.5384615384615384, 1.0865384615384615`}, {-0.38461538461538464`, 
        0.38461538461538464`, 1.125}, {-0.5384615384615384, 
        0.38461538461538464`, 1.1634615384615383`}, {-0.5384615384615384, 
        0.5384615384615384, 1.125}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[9, 13], 1.0480769230769231`}, {
         Rational[-5, 13], Rational[7, 13], 1.0865384615384615`}, {
         Rational[-7, 13], Rational[7, 13], 1.125}, {
         Rational[-7, 13], Rational[9, 13], 
          1.0865384615384615`}}, {{-0.38461538461538464`, 0.6923076923076923, 
        1.0480769230769231`}, {-0.38461538461538464`, 0.5384615384615384, 
        1.0865384615384615`}, {-0.5384615384615384, 0.5384615384615384, 
        1.125}, {-0.5384615384615384, 0.6923076923076923, 
        1.0865384615384615`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], Rational[11, 13], 1.0096153846153846`}, {
         Rational[-5, 13], Rational[9, 13], 1.0480769230769231`}, {
         Rational[-7, 13], Rational[9, 13], 1.0865384615384615`}, {
         Rational[-7, 13], Rational[11, 13], 
          1.0480769230769231`}}, {{-0.38461538461538464`, 0.8461538461538461, 
        1.0096153846153846`}, {-0.38461538461538464`, 0.6923076923076923, 
        1.0480769230769231`}, {-0.5384615384615384, 0.6923076923076923, 
        1.0865384615384615`}, {-0.5384615384615384, 0.8461538461538461, 
        1.0480769230769231`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-5, 13], 1, 0.9711538461538461}, {
         Rational[-5, 13], Rational[11, 13], 1.0096153846153846`}, {
         Rational[-7, 13], Rational[11, 13], 1.0480769230769231`}, {
         Rational[-7, 13], 1, 1.0096153846153846`}}, {{-0.38461538461538464`, 
          1, 0.9711538461538461}, {-0.38461538461538464`, 0.8461538461538461, 
         1.0096153846153846`}, {-0.5384615384615384, 0.8461538461538461, 
         1.0480769230769231`}, {-0.5384615384615384, 1, 
          1.0096153846153846`}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[-11, 13], 1.3942307692307692`}, {
         Rational[-3, 13], -1, 1.4326923076923077`}, {
         Rational[-5, 13], -1, 1.4711538461538463`}, {
         Rational[-5, 13], Rational[-11, 13], 
          1.4326923076923077`}}, {{-0.23076923076923078`, -0.8461538461538461,
          1.3942307692307692`}, {-0.23076923076923078`, -1, 
          1.4326923076923077`}, {-0.38461538461538464`, -1, 
          1.4711538461538463`}, {-0.38461538461538464`, -0.8461538461538461, 
         1.4326923076923077`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[-9, 13], 1.3557692307692308`}, {
         Rational[-3, 13], Rational[-11, 13], 1.3942307692307692`}, {
         Rational[-5, 13], Rational[-11, 13], 1.4326923076923077`}, {
         Rational[-5, 13], Rational[-9, 13], 
          1.3942307692307692`}}, {{-0.23076923076923078`, -0.6923076923076923,
         1.3557692307692308`}, {-0.23076923076923078`, -0.8461538461538461, 
        1.3942307692307692`}, {-0.38461538461538464`, -0.8461538461538461, 
        1.4326923076923077`}, {-0.38461538461538464`, -0.6923076923076923, 
        1.3942307692307692`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[-7, 13], 1.3173076923076923`}, {
         Rational[-3, 13], Rational[-9, 13], 1.3557692307692308`}, {
         Rational[-5, 13], Rational[-9, 13], 1.3942307692307692`}, {
         Rational[-5, 13], Rational[-7, 13], 
          1.3557692307692308`}}, {{-0.23076923076923078`, -0.5384615384615384,
         1.3173076923076923`}, {-0.23076923076923078`, -0.6923076923076923, 
        1.3557692307692308`}, {-0.38461538461538464`, -0.6923076923076923, 
        1.3942307692307692`}, {-0.38461538461538464`, -0.5384615384615384, 
        1.3557692307692308`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[-5, 13], 1.2788461538461537`}, {
         Rational[-3, 13], Rational[-7, 13], 1.3173076923076923`}, {
         Rational[-5, 13], Rational[-7, 13], 1.3557692307692308`}, {
         Rational[-5, 13], Rational[-5, 13], 
          1.3173076923076923`}}, {{-0.23076923076923078`, \
-0.38461538461538464`, 
        1.2788461538461537`}, {-0.23076923076923078`, -0.5384615384615384, 
        1.3173076923076923`}, {-0.38461538461538464`, -0.5384615384615384, 
        1.3557692307692308`}, {-0.38461538461538464`, -0.38461538461538464`, 
        1.3173076923076923`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[-3, 13], 1.2403846153846154`}, {
         Rational[-3, 13], Rational[-5, 13], 1.2788461538461537`}, {
         Rational[-5, 13], Rational[-5, 13], 1.3173076923076923`}, {
         Rational[-5, 13], Rational[-3, 13], 
          1.2788461538461537`}}, {{-0.23076923076923078`, \
-0.23076923076923078`, 
        1.2403846153846154`}, {-0.23076923076923078`, -0.38461538461538464`, 
        1.2788461538461537`}, {-0.38461538461538464`, -0.38461538461538464`, 
        1.3173076923076923`}, {-0.38461538461538464`, -0.23076923076923078`, 
        1.2788461538461537`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[-1, 13], 1.2019230769230769`}, {
         Rational[-3, 13], Rational[-3, 13], 1.2403846153846154`}, {
         Rational[-5, 13], Rational[-3, 13], 1.2788461538461537`}, {
         Rational[-5, 13], Rational[-1, 13], 
          1.2403846153846154`}}, {{-0.23076923076923078`, \
-0.07692307692307693, 
        1.2019230769230769`}, {-0.23076923076923078`, -0.23076923076923078`, 
        1.2403846153846154`}, {-0.38461538461538464`, -0.23076923076923078`, 
        1.2788461538461537`}, {-0.38461538461538464`, -0.07692307692307693, 
        1.2403846153846154`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[1, 13], 1.1634615384615385`}, {
         Rational[-3, 13], Rational[-1, 13], 1.2019230769230769`}, {
         Rational[-5, 13], Rational[-1, 13], 1.2403846153846154`}, {
         Rational[-5, 13], Rational[1, 13], 
          1.2019230769230769`}}, {{-0.23076923076923078`, 0.07692307692307693,
         1.1634615384615385`}, {-0.23076923076923078`, -0.07692307692307693, 
        1.2019230769230769`}, {-0.38461538461538464`, -0.07692307692307693, 
        1.2403846153846154`}, {-0.38461538461538464`, 0.07692307692307693, 
        1.2019230769230769`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[3, 13], 1.125}, {
         Rational[-3, 13], Rational[1, 13], 1.1634615384615385`}, {
         Rational[-5, 13], Rational[1, 13], 1.2019230769230769`}, {
         Rational[-5, 13], Rational[3, 13], 
          1.1634615384615383`}}, {{-0.23076923076923078`, 
        0.23076923076923078`, 1.125}, {-0.23076923076923078`, 
        0.07692307692307693, 1.1634615384615385`}, {-0.38461538461538464`, 
        0.07692307692307693, 1.2019230769230769`}, {-0.38461538461538464`, 
        0.23076923076923078`, 1.1634615384615383`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[5, 13], 1.0865384615384617`}, {
         Rational[-3, 13], Rational[3, 13], 1.125}, {
         Rational[-5, 13], Rational[3, 13], 1.1634615384615383`}, {
         Rational[-5, 13], Rational[5, 13], 1.125}}, {{-0.23076923076923078`, 
        0.38461538461538464`, 1.0865384615384617`}, {-0.23076923076923078`, 
        0.23076923076923078`, 1.125}, {-0.38461538461538464`, 
        0.23076923076923078`, 1.1634615384615383`}, {-0.38461538461538464`, 
        0.38461538461538464`, 1.125}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[7, 13], 1.0480769230769231`}, {
         Rational[-3, 13], Rational[5, 13], 1.0865384615384617`}, {
         Rational[-5, 13], Rational[5, 13], 1.125}, {
         Rational[-5, 13], Rational[7, 13], 
          1.0865384615384615`}}, {{-0.23076923076923078`, 0.5384615384615384, 
        1.0480769230769231`}, {-0.23076923076923078`, 0.38461538461538464`, 
        1.0865384615384617`}, {-0.38461538461538464`, 0.38461538461538464`, 
        1.125}, {-0.38461538461538464`, 0.5384615384615384, 
        1.0865384615384615`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[9, 13], 1.0096153846153846`}, {
         Rational[-3, 13], Rational[7, 13], 1.0480769230769231`}, {
         Rational[-5, 13], Rational[7, 13], 1.0865384615384615`}, {
         Rational[-5, 13], Rational[9, 13], 
          1.0480769230769231`}}, {{-0.23076923076923078`, 0.6923076923076923, 
        1.0096153846153846`}, {-0.23076923076923078`, 0.5384615384615384, 
        1.0480769230769231`}, {-0.38461538461538464`, 0.5384615384615384, 
        1.0865384615384615`}, {-0.38461538461538464`, 0.6923076923076923, 
        1.0480769230769231`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], Rational[11, 13], 0.9711538461538461}, {
         Rational[-3, 13], Rational[9, 13], 1.0096153846153846`}, {
         Rational[-5, 13], Rational[9, 13], 1.0480769230769231`}, {
         Rational[-5, 13], Rational[11, 13], 
          1.0096153846153846`}}, {{-0.23076923076923078`, 0.8461538461538461, 
        0.9711538461538461}, {-0.23076923076923078`, 0.6923076923076923, 
        1.0096153846153846`}, {-0.38461538461538464`, 0.6923076923076923, 
        1.0480769230769231`}, {-0.38461538461538464`, 0.8461538461538461, 
        1.0096153846153846`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-3, 13], 1, 0.9326923076923077}, {
         Rational[-3, 13], Rational[11, 13], 0.9711538461538461}, {
         Rational[-5, 13], Rational[11, 13], 1.0096153846153846`}, {
         Rational[-5, 13], 1, 0.9711538461538461}}, {{-0.23076923076923078`, 
          1, 0.9326923076923077}, {-0.23076923076923078`, 0.8461538461538461, 
         0.9711538461538461}, {-0.38461538461538464`, 0.8461538461538461, 
         1.0096153846153846`}, {-0.38461538461538464`, 1, 
          0.9711538461538461}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[-11, 13], 1.3557692307692308`}, {
         Rational[-1, 13], -1, 1.3942307692307692`}, {
         Rational[-3, 13], -1, 1.4326923076923077`}, {
         Rational[-3, 13], Rational[-11, 13], 
          1.3942307692307692`}}, {{-0.07692307692307693, -0.8461538461538461, 
         1.3557692307692308`}, {-0.07692307692307693, -1, 
          1.3942307692307692`}, {-0.23076923076923078`, -1, 
          1.4326923076923077`}, {-0.23076923076923078`, -0.8461538461538461, 
         1.3942307692307692`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[-9, 13], 1.3173076923076923`}, {
         Rational[-1, 13], Rational[-11, 13], 1.3557692307692308`}, {
         Rational[-3, 13], Rational[-11, 13], 1.3942307692307692`}, {
         Rational[-3, 13], Rational[-9, 13], 
          1.3557692307692308`}}, {{-0.07692307692307693, -0.6923076923076923, 
        1.3173076923076923`}, {-0.07692307692307693, -0.8461538461538461, 
        1.3557692307692308`}, {-0.23076923076923078`, -0.8461538461538461, 
        1.3942307692307692`}, {-0.23076923076923078`, -0.6923076923076923, 
        1.3557692307692308`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[-7, 13], 1.2788461538461537`}, {
         Rational[-1, 13], Rational[-9, 13], 1.3173076923076923`}, {
         Rational[-3, 13], Rational[-9, 13], 1.3557692307692308`}, {
         Rational[-3, 13], Rational[-7, 13], 
          1.3173076923076923`}}, {{-0.07692307692307693, -0.5384615384615384, 
        1.2788461538461537`}, {-0.07692307692307693, -0.6923076923076923, 
        1.3173076923076923`}, {-0.23076923076923078`, -0.6923076923076923, 
        1.3557692307692308`}, {-0.23076923076923078`, -0.5384615384615384, 
        1.3173076923076923`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[-5, 13], 1.2403846153846154`}, {
         Rational[-1, 13], Rational[-7, 13], 1.2788461538461537`}, {
         Rational[-3, 13], Rational[-7, 13], 1.3173076923076923`}, {
         Rational[-3, 13], Rational[-5, 13], 
          1.2788461538461537`}}, {{-0.07692307692307693, \
-0.38461538461538464`, 
        1.2403846153846154`}, {-0.07692307692307693, -0.5384615384615384, 
        1.2788461538461537`}, {-0.23076923076923078`, -0.5384615384615384, 
        1.3173076923076923`}, {-0.23076923076923078`, -0.38461538461538464`, 
        1.2788461538461537`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[-3, 13], 1.2019230769230769`}, {
         Rational[-1, 13], Rational[-5, 13], 1.2403846153846154`}, {
         Rational[-3, 13], Rational[-5, 13], 1.2788461538461537`}, {
         Rational[-3, 13], Rational[-3, 13], 
          
          1.2403846153846154`}}, {{-0.07692307692307693, \
-0.23076923076923078`, 
        1.2019230769230769`}, {-0.07692307692307693, -0.38461538461538464`, 
        1.2403846153846154`}, {-0.23076923076923078`, -0.38461538461538464`, 
        1.2788461538461537`}, {-0.23076923076923078`, -0.23076923076923078`, 
        1.2403846153846154`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[-1, 13], 1.1634615384615383`}, {
         Rational[-1, 13], Rational[-3, 13], 1.2019230769230769`}, {
         Rational[-3, 13], Rational[-3, 13], 1.2403846153846154`}, {
         Rational[-3, 13], Rational[-1, 13], 
          1.2019230769230769`}}, {{-0.07692307692307693, -0.07692307692307693,
         1.1634615384615383`}, {-0.07692307692307693, -0.23076923076923078`, 
        1.2019230769230769`}, {-0.23076923076923078`, -0.23076923076923078`, 
        1.2403846153846154`}, {-0.23076923076923078`, -0.07692307692307693, 
        1.2019230769230769`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[1, 13], 1.125}, {
         Rational[-1, 13], Rational[-1, 13], 1.1634615384615383`}, {
         Rational[-3, 13], Rational[-1, 13], 1.2019230769230769`}, {
         Rational[-3, 13], Rational[1, 13], 
          1.1634615384615385`}}, {{-0.07692307692307693, 0.07692307692307693, 
        1.125}, {-0.07692307692307693, -0.07692307692307693, 
        1.1634615384615383`}, {-0.23076923076923078`, -0.07692307692307693, 
        1.2019230769230769`}, {-0.23076923076923078`, 0.07692307692307693, 
        1.1634615384615385`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[3, 13], 1.0865384615384615`}, {
         Rational[-1, 13], Rational[1, 13], 1.125}, {
         Rational[-3, 13], Rational[1, 13], 1.1634615384615385`}, {
         Rational[-3, 13], Rational[3, 13], 1.125}}, {{-0.07692307692307693, 
        0.23076923076923078`, 1.0865384615384615`}, {-0.07692307692307693, 
        0.07692307692307693, 1.125}, {-0.23076923076923078`, 
        0.07692307692307693, 1.1634615384615385`}, {-0.23076923076923078`, 
        0.23076923076923078`, 1.125}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[5, 13], 1.0480769230769231`}, {
         Rational[-1, 13], Rational[3, 13], 1.0865384615384615`}, {
         Rational[-3, 13], Rational[3, 13], 1.125}, {
         Rational[-3, 13], Rational[5, 13], 
          1.0865384615384617`}}, {{-0.07692307692307693, 0.38461538461538464`,
         1.0480769230769231`}, {-0.07692307692307693, 0.23076923076923078`, 
        1.0865384615384615`}, {-0.23076923076923078`, 0.23076923076923078`, 
        1.125}, {-0.23076923076923078`, 0.38461538461538464`, 
        1.0865384615384617`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[7, 13], 1.0096153846153846`}, {
         Rational[-1, 13], Rational[5, 13], 1.0480769230769231`}, {
         Rational[-3, 13], Rational[5, 13], 1.0865384615384617`}, {
         Rational[-3, 13], Rational[7, 13], 
          1.0480769230769231`}}, {{-0.07692307692307693, 0.5384615384615384, 
        1.0096153846153846`}, {-0.07692307692307693, 0.38461538461538464`, 
        1.0480769230769231`}, {-0.23076923076923078`, 0.38461538461538464`, 
        1.0865384615384617`}, {-0.23076923076923078`, 0.5384615384615384, 
        1.0480769230769231`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[9, 13], 0.9711538461538461}, {
         Rational[-1, 13], Rational[7, 13], 1.0096153846153846`}, {
         Rational[-3, 13], Rational[7, 13], 1.0480769230769231`}, {
         Rational[-3, 13], Rational[9, 13], 
          1.0096153846153846`}}, {{-0.07692307692307693, 0.6923076923076923, 
        0.9711538461538461}, {-0.07692307692307693, 0.5384615384615384, 
        1.0096153846153846`}, {-0.23076923076923078`, 0.5384615384615384, 
        1.0480769230769231`}, {-0.23076923076923078`, 0.6923076923076923, 
        1.0096153846153846`}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], Rational[11, 13], 0.9326923076923077}, {
         Rational[-1, 13], Rational[9, 13], 0.9711538461538461}, {
         Rational[-3, 13], Rational[9, 13], 1.0096153846153846`}, {
         Rational[-3, 13], Rational[11, 13], 
          0.9711538461538461}}, {{-0.07692307692307693, 0.8461538461538461, 
        0.9326923076923077}, {-0.07692307692307693, 0.6923076923076923, 
        0.9711538461538461}, {-0.23076923076923078`, 0.6923076923076923, 
        1.0096153846153846`}, {-0.23076923076923078`, 0.8461538461538461, 
        0.9711538461538461}}]], 
      Polygon3DBox[
       NCache[{{Rational[-1, 13], 1, 0.8942307692307692}, {
         Rational[-1, 13], Rational[11, 13], 0.9326923076923077}, {
         Rational[-3, 13], Rational[11, 13], 0.9711538461538461}, {
         Rational[-3, 13], 1, 0.9326923076923077}}, {{-0.07692307692307693, 1,
           0.8942307692307692}, {-0.07692307692307693, 0.8461538461538461, 
         0.9326923076923077}, {-0.23076923076923078`, 0.8461538461538461, 
         0.9711538461538461}, {-0.23076923076923078`, 1, 
          0.9326923076923077}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[-11, 13], 1.3173076923076923`}, {
         Rational[1, 13], -1, 1.3557692307692308`}, {
         Rational[-1, 13], -1, 1.3942307692307692`}, {
         Rational[-1, 13], Rational[-11, 13], 1.3557692307692308`}}, {{
         0.07692307692307693, -0.8461538461538461, 1.3173076923076923`}, {
         0.07692307692307693, -1, 
          1.3557692307692308`}, {-0.07692307692307693, -1, 
          1.3942307692307692`}, {-0.07692307692307693, -0.8461538461538461, 
         1.3557692307692308`}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[-9, 13], 1.2788461538461537`}, {
         Rational[1, 13], Rational[-11, 13], 1.3173076923076923`}, {
         Rational[-1, 13], Rational[-11, 13], 1.3557692307692308`}, {
         Rational[-1, 13], Rational[-9, 13], 1.3173076923076923`}}, {{
        0.07692307692307693, -0.6923076923076923, 1.2788461538461537`}, {
        0.07692307692307693, -0.8461538461538461, 
        1.3173076923076923`}, {-0.07692307692307693, -0.8461538461538461, 
        1.3557692307692308`}, {-0.07692307692307693, -0.6923076923076923, 
        1.3173076923076923`}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[-7, 13], 1.2403846153846154`}, {
         Rational[1, 13], Rational[-9, 13], 1.2788461538461537`}, {
         Rational[-1, 13], Rational[-9, 13], 1.3173076923076923`}, {
         Rational[-1, 13], Rational[-7, 13], 1.2788461538461537`}}, {{
        0.07692307692307693, -0.5384615384615384, 1.2403846153846154`}, {
        0.07692307692307693, -0.6923076923076923, 
        1.2788461538461537`}, {-0.07692307692307693, -0.6923076923076923, 
        1.3173076923076923`}, {-0.07692307692307693, -0.5384615384615384, 
        1.2788461538461537`}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[-5, 13], 1.2019230769230769`}, {
         Rational[1, 13], Rational[-7, 13], 1.2403846153846154`}, {
         Rational[-1, 13], Rational[-7, 13], 1.2788461538461537`}, {
         Rational[-1, 13], Rational[-5, 13], 1.2403846153846154`}}, {{
        0.07692307692307693, -0.38461538461538464`, 1.2019230769230769`}, {
        0.07692307692307693, -0.5384615384615384, 
        1.2403846153846154`}, {-0.07692307692307693, -0.5384615384615384, 
        1.2788461538461537`}, {-0.07692307692307693, -0.38461538461538464`, 
        1.2403846153846154`}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[-3, 13], 1.1634615384615385`}, {
         Rational[1, 13], Rational[-5, 13], 1.2019230769230769`}, {
         Rational[-1, 13], Rational[-5, 13], 1.2403846153846154`}, {
         Rational[-1, 13], Rational[-3, 13], 1.2019230769230769`}}, {{
        0.07692307692307693, -0.23076923076923078`, 1.1634615384615385`}, {
        0.07692307692307693, -0.38461538461538464`, 
        1.2019230769230769`}, {-0.07692307692307693, -0.38461538461538464`, 
        1.2403846153846154`}, {-0.07692307692307693, -0.23076923076923078`, 
        1.2019230769230769`}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[-1, 13], 1.125}, {
         Rational[1, 13], Rational[-3, 13], 1.1634615384615385`}, {
         Rational[-1, 13], Rational[-3, 13], 1.2019230769230769`}, {
         Rational[-1, 13], Rational[-1, 13], 1.1634615384615383`}}, {{
        0.07692307692307693, -0.07692307692307693, 1.125}, {
        0.07692307692307693, -0.23076923076923078`, 
        1.1634615384615385`}, {-0.07692307692307693, -0.23076923076923078`, 
        1.2019230769230769`}, {-0.07692307692307693, -0.07692307692307693, 
        1.1634615384615383`}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[1, 13], 1.0865384615384615`}, {
         Rational[1, 13], Rational[-1, 13], 1.125}, {
         Rational[-1, 13], Rational[-1, 13], 1.1634615384615383`}, {
         Rational[-1, 13], Rational[1, 13], 1.125}}, {{0.07692307692307693, 
        0.07692307692307693, 1.0865384615384615`}, {
        0.07692307692307693, -0.07692307692307693, 
        1.125}, {-0.07692307692307693, -0.07692307692307693, 
        1.1634615384615383`}, {-0.07692307692307693, 0.07692307692307693, 
        1.125}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[3, 13], 1.0480769230769231`}, {
         Rational[1, 13], Rational[1, 13], 1.0865384615384615`}, {
         Rational[-1, 13], Rational[1, 13], 1.125}, {
         Rational[-1, 13], Rational[3, 13], 1.0865384615384615`}}, {{
        0.07692307692307693, 0.23076923076923078`, 1.0480769230769231`}, {
        0.07692307692307693, 0.07692307692307693, 
        1.0865384615384615`}, {-0.07692307692307693, 0.07692307692307693, 
        1.125}, {-0.07692307692307693, 0.23076923076923078`, 
        1.0865384615384615`}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[5, 13], 1.0096153846153846`}, {
         Rational[1, 13], Rational[3, 13], 1.0480769230769231`}, {
         Rational[-1, 13], Rational[3, 13], 1.0865384615384615`}, {
         Rational[-1, 13], Rational[5, 13], 1.0480769230769231`}}, {{
        0.07692307692307693, 0.38461538461538464`, 1.0096153846153846`}, {
        0.07692307692307693, 0.23076923076923078`, 
        1.0480769230769231`}, {-0.07692307692307693, 0.23076923076923078`, 
        1.0865384615384615`}, {-0.07692307692307693, 0.38461538461538464`, 
        1.0480769230769231`}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[7, 13], 0.9711538461538461}, {
         Rational[1, 13], Rational[5, 13], 1.0096153846153846`}, {
         Rational[-1, 13], Rational[5, 13], 1.0480769230769231`}, {
         Rational[-1, 13], Rational[7, 13], 1.0096153846153846`}}, {{
        0.07692307692307693, 0.5384615384615384, 0.9711538461538461}, {
        0.07692307692307693, 0.38461538461538464`, 
        1.0096153846153846`}, {-0.07692307692307693, 0.38461538461538464`, 
        1.0480769230769231`}, {-0.07692307692307693, 0.5384615384615384, 
        1.0096153846153846`}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[9, 13], 0.9326923076923077}, {
         Rational[1, 13], Rational[7, 13], 0.9711538461538461}, {
         Rational[-1, 13], Rational[7, 13], 1.0096153846153846`}, {
         Rational[-1, 13], Rational[9, 13], 0.9711538461538461}}, {{
        0.07692307692307693, 0.6923076923076923, 0.9326923076923077}, {
        0.07692307692307693, 0.5384615384615384, 
        0.9711538461538461}, {-0.07692307692307693, 0.5384615384615384, 
        1.0096153846153846`}, {-0.07692307692307693, 0.6923076923076923, 
        0.9711538461538461}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], Rational[11, 13], 0.8942307692307693}, {
         Rational[1, 13], Rational[9, 13], 0.9326923076923077}, {
         Rational[-1, 13], Rational[9, 13], 0.9711538461538461}, {
         Rational[-1, 13], Rational[11, 13], 0.9326923076923077}}, {{
        0.07692307692307693, 0.8461538461538461, 0.8942307692307693}, {
        0.07692307692307693, 0.6923076923076923, 
        0.9326923076923077}, {-0.07692307692307693, 0.6923076923076923, 
        0.9711538461538461}, {-0.07692307692307693, 0.8461538461538461, 
        0.9326923076923077}}]], 
      Polygon3DBox[
       NCache[{{Rational[1, 13], 1, 0.8557692307692307}, {
         Rational[1, 13], Rational[11, 13], 0.8942307692307693}, {
         Rational[-1, 13], Rational[11, 13], 0.9326923076923077}, {
         Rational[-1, 13], 1, 0.8942307692307692}}, {{
         0.07692307692307693, 1, 0.8557692307692307}, {0.07692307692307693, 
         0.8461538461538461, 0.8942307692307693}, {-0.07692307692307693, 
         0.8461538461538461, 
         0.9326923076923077}, {-0.07692307692307693, 1, 
          0.8942307692307692}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[-11, 13], 1.2788461538461537`}, {
         Rational[3, 13], -1, 1.3173076923076923`}, {
         Rational[1, 13], -1, 1.3557692307692308`}, {
         Rational[1, 13], Rational[-11, 13], 1.3173076923076923`}}, {{
         0.23076923076923078`, -0.8461538461538461, 1.2788461538461537`}, {
         0.23076923076923078`, -1, 1.3173076923076923`}, {
         0.07692307692307693, -1, 1.3557692307692308`}, {
         0.07692307692307693, -0.8461538461538461, 1.3173076923076923`}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[-9, 13], 1.2403846153846154`}, {
         Rational[3, 13], Rational[-11, 13], 1.2788461538461537`}, {
         Rational[1, 13], Rational[-11, 13], 1.3173076923076923`}, {
         Rational[1, 13], Rational[-9, 13], 1.2788461538461537`}}, {{
        0.23076923076923078`, -0.6923076923076923, 1.2403846153846154`}, {
        0.23076923076923078`, -0.8461538461538461, 1.2788461538461537`}, {
        0.07692307692307693, -0.8461538461538461, 1.3173076923076923`}, {
        0.07692307692307693, -0.6923076923076923, 1.2788461538461537`}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[-7, 13], 1.2019230769230769`}, {
         Rational[3, 13], Rational[-9, 13], 1.2403846153846154`}, {
         Rational[1, 13], Rational[-9, 13], 1.2788461538461537`}, {
         Rational[1, 13], Rational[-7, 13], 1.2403846153846154`}}, {{
        0.23076923076923078`, -0.5384615384615384, 1.2019230769230769`}, {
        0.23076923076923078`, -0.6923076923076923, 1.2403846153846154`}, {
        0.07692307692307693, -0.6923076923076923, 1.2788461538461537`}, {
        0.07692307692307693, -0.5384615384615384, 1.2403846153846154`}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[-5, 13], 1.1634615384615383`}, {
         Rational[3, 13], Rational[-7, 13], 1.2019230769230769`}, {
         Rational[1, 13], Rational[-7, 13], 1.2403846153846154`}, {
         Rational[1, 13], Rational[-5, 13], 1.2019230769230769`}}, {{
        0.23076923076923078`, -0.38461538461538464`, 1.1634615384615383`}, {
        0.23076923076923078`, -0.5384615384615384, 1.2019230769230769`}, {
        0.07692307692307693, -0.5384615384615384, 1.2403846153846154`}, {
        0.07692307692307693, -0.38461538461538464`, 1.2019230769230769`}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[-3, 13], 1.125}, {
         Rational[3, 13], Rational[-5, 13], 1.1634615384615383`}, {
         Rational[1, 13], Rational[-5, 13], 1.2019230769230769`}, {
         Rational[1, 13], Rational[-3, 13], 1.1634615384615385`}}, {{
        0.23076923076923078`, -0.23076923076923078`, 1.125}, {
        0.23076923076923078`, -0.38461538461538464`, 1.1634615384615383`}, {
        0.07692307692307693, -0.38461538461538464`, 1.2019230769230769`}, {
        0.07692307692307693, -0.23076923076923078`, 1.1634615384615385`}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[-1, 13], 1.0865384615384615`}, {
         Rational[3, 13], Rational[-3, 13], 1.125}, {
         Rational[1, 13], Rational[-3, 13], 1.1634615384615385`}, {
         Rational[1, 13], Rational[-1, 13], 1.125}}, {{
        0.23076923076923078`, -0.07692307692307693, 1.0865384615384615`}, {
        0.23076923076923078`, -0.23076923076923078`, 1.125}, {
        0.07692307692307693, -0.23076923076923078`, 1.1634615384615385`}, {
        0.07692307692307693, -0.07692307692307693, 1.125}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[1, 13], 1.0480769230769231`}, {
         Rational[3, 13], Rational[-1, 13], 1.0865384615384615`}, {
         Rational[1, 13], Rational[-1, 13], 1.125}, {
         Rational[1, 13], Rational[1, 13], 1.0865384615384615`}}, {{
        0.23076923076923078`, 0.07692307692307693, 1.0480769230769231`}, {
        0.23076923076923078`, -0.07692307692307693, 1.0865384615384615`}, {
        0.07692307692307693, -0.07692307692307693, 1.125}, {
        0.07692307692307693, 0.07692307692307693, 1.0865384615384615`}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[3, 13], 1.0096153846153846`}, {
         Rational[3, 13], Rational[1, 13], 1.0480769230769231`}, {
         Rational[1, 13], Rational[1, 13], 1.0865384615384615`}, {
         Rational[1, 13], Rational[3, 13], 1.0480769230769231`}}, {{
        0.23076923076923078`, 0.23076923076923078`, 1.0096153846153846`}, {
        0.23076923076923078`, 0.07692307692307693, 1.0480769230769231`}, {
        0.07692307692307693, 0.07692307692307693, 1.0865384615384615`}, {
        0.07692307692307693, 0.23076923076923078`, 1.0480769230769231`}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[5, 13], 0.9711538461538461}, {
         Rational[3, 13], Rational[3, 13], 1.0096153846153846`}, {
         Rational[1, 13], Rational[3, 13], 1.0480769230769231`}, {
         Rational[1, 13], Rational[5, 13], 1.0096153846153846`}}, {{
        0.23076923076923078`, 0.38461538461538464`, 0.9711538461538461}, {
        0.23076923076923078`, 0.23076923076923078`, 1.0096153846153846`}, {
        0.07692307692307693, 0.23076923076923078`, 1.0480769230769231`}, {
        0.07692307692307693, 0.38461538461538464`, 1.0096153846153846`}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[7, 13], 0.9326923076923077}, {
         Rational[3, 13], Rational[5, 13], 0.9711538461538461}, {
         Rational[1, 13], Rational[5, 13], 1.0096153846153846`}, {
         Rational[1, 13], Rational[7, 13], 0.9711538461538461}}, {{
        0.23076923076923078`, 0.5384615384615384, 0.9326923076923077}, {
        0.23076923076923078`, 0.38461538461538464`, 0.9711538461538461}, {
        0.07692307692307693, 0.38461538461538464`, 1.0096153846153846`}, {
        0.07692307692307693, 0.5384615384615384, 0.9711538461538461}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[9, 13], 0.8942307692307693}, {
         Rational[3, 13], Rational[7, 13], 0.9326923076923077}, {
         Rational[1, 13], Rational[7, 13], 0.9711538461538461}, {
         Rational[1, 13], Rational[9, 13], 0.9326923076923077}}, {{
        0.23076923076923078`, 0.6923076923076923, 0.8942307692307693}, {
        0.23076923076923078`, 0.5384615384615384, 0.9326923076923077}, {
        0.07692307692307693, 0.5384615384615384, 0.9711538461538461}, {
        0.07692307692307693, 0.6923076923076923, 0.9326923076923077}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], Rational[11, 13], 0.8557692307692307}, {
         Rational[3, 13], Rational[9, 13], 0.8942307692307693}, {
         Rational[1, 13], Rational[9, 13], 0.9326923076923077}, {
         Rational[1, 13], Rational[11, 13], 0.8942307692307693}}, {{
        0.23076923076923078`, 0.8461538461538461, 0.8557692307692307}, {
        0.23076923076923078`, 0.6923076923076923, 0.8942307692307693}, {
        0.07692307692307693, 0.6923076923076923, 0.9326923076923077}, {
        0.07692307692307693, 0.8461538461538461, 0.8942307692307693}}]], 
      Polygon3DBox[
       NCache[{{Rational[3, 13], 1, 0.8173076923076923}, {
         Rational[3, 13], Rational[11, 13], 0.8557692307692307}, {
         Rational[1, 13], Rational[11, 13], 0.8942307692307693}, {
         Rational[1, 13], 1, 0.8557692307692307}}, {{
         0.23076923076923078`, 1, 0.8173076923076923}, {0.23076923076923078`, 
         0.8461538461538461, 0.8557692307692307}, {0.07692307692307693, 
         0.8461538461538461, 0.8942307692307693}, {
         0.07692307692307693, 1, 0.8557692307692307}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[-11, 13], 1.2403846153846154`}, {
         Rational[5, 13], -1, 1.2788461538461537`}, {
         Rational[3, 13], -1, 1.3173076923076923`}, {
         Rational[3, 13], Rational[-11, 13], 1.2788461538461537`}}, {{
         0.38461538461538464`, -0.8461538461538461, 1.2403846153846154`}, {
         0.38461538461538464`, -1, 1.2788461538461537`}, {
         0.23076923076923078`, -1, 1.3173076923076923`}, {
         0.23076923076923078`, -0.8461538461538461, 1.2788461538461537`}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[-9, 13], 1.2019230769230769`}, {
         Rational[5, 13], Rational[-11, 13], 1.2403846153846154`}, {
         Rational[3, 13], Rational[-11, 13], 1.2788461538461537`}, {
         Rational[3, 13], Rational[-9, 13], 1.2403846153846154`}}, {{
        0.38461538461538464`, -0.6923076923076923, 1.2019230769230769`}, {
        0.38461538461538464`, -0.8461538461538461, 1.2403846153846154`}, {
        0.23076923076923078`, -0.8461538461538461, 1.2788461538461537`}, {
        0.23076923076923078`, -0.6923076923076923, 1.2403846153846154`}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[-7, 13], 1.1634615384615383`}, {
         Rational[5, 13], Rational[-9, 13], 1.2019230769230769`}, {
         Rational[3, 13], Rational[-9, 13], 1.2403846153846154`}, {
         Rational[3, 13], Rational[-7, 13], 1.2019230769230769`}}, {{
        0.38461538461538464`, -0.5384615384615384, 1.1634615384615383`}, {
        0.38461538461538464`, -0.6923076923076923, 1.2019230769230769`}, {
        0.23076923076923078`, -0.6923076923076923, 1.2403846153846154`}, {
        0.23076923076923078`, -0.5384615384615384, 1.2019230769230769`}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[-5, 13], 1.125}, {
         Rational[5, 13], Rational[-7, 13], 1.1634615384615383`}, {
         Rational[3, 13], Rational[-7, 13], 1.2019230769230769`}, {
         Rational[3, 13], Rational[-5, 13], 1.1634615384615383`}}, {{
        0.38461538461538464`, -0.38461538461538464`, 1.125}, {
        0.38461538461538464`, -0.5384615384615384, 1.1634615384615383`}, {
        0.23076923076923078`, -0.5384615384615384, 1.2019230769230769`}, {
        0.23076923076923078`, -0.38461538461538464`, 1.1634615384615383`}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[-3, 13], 1.0865384615384617`}, {
         Rational[5, 13], Rational[-5, 13], 1.125}, {
         Rational[3, 13], Rational[-5, 13], 1.1634615384615383`}, {
         Rational[3, 13], Rational[-3, 13], 1.125}}, {{
        0.38461538461538464`, -0.23076923076923078`, 1.0865384615384617`}, {
        0.38461538461538464`, -0.38461538461538464`, 1.125}, {
        0.23076923076923078`, -0.38461538461538464`, 1.1634615384615383`}, {
        0.23076923076923078`, -0.23076923076923078`, 1.125}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[-1, 13], 1.0480769230769231`}, {
         Rational[5, 13], Rational[-3, 13], 1.0865384615384617`}, {
         Rational[3, 13], Rational[-3, 13], 1.125}, {
         Rational[3, 13], Rational[-1, 13], 1.0865384615384615`}}, {{
        0.38461538461538464`, -0.07692307692307693, 1.0480769230769231`}, {
        0.38461538461538464`, -0.23076923076923078`, 1.0865384615384617`}, {
        0.23076923076923078`, -0.23076923076923078`, 1.125}, {
        0.23076923076923078`, -0.07692307692307693, 1.0865384615384615`}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[1, 13], 1.0096153846153846`}, {
         Rational[5, 13], Rational[-1, 13], 1.0480769230769231`}, {
         Rational[3, 13], Rational[-1, 13], 1.0865384615384615`}, {
         Rational[3, 13], Rational[1, 13], 1.0480769230769231`}}, {{
        0.38461538461538464`, 0.07692307692307693, 1.0096153846153846`}, {
        0.38461538461538464`, -0.07692307692307693, 1.0480769230769231`}, {
        0.23076923076923078`, -0.07692307692307693, 1.0865384615384615`}, {
        0.23076923076923078`, 0.07692307692307693, 1.0480769230769231`}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[3, 13], 0.9711538461538461}, {
         Rational[5, 13], Rational[1, 13], 1.0096153846153846`}, {
         Rational[3, 13], Rational[1, 13], 1.0480769230769231`}, {
         Rational[3, 13], Rational[3, 13], 1.0096153846153846`}}, {{
        0.38461538461538464`, 0.23076923076923078`, 0.9711538461538461}, {
        0.38461538461538464`, 0.07692307692307693, 1.0096153846153846`}, {
        0.23076923076923078`, 0.07692307692307693, 1.0480769230769231`}, {
        0.23076923076923078`, 0.23076923076923078`, 1.0096153846153846`}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[5, 13], 0.9326923076923077}, {
         Rational[5, 13], Rational[3, 13], 0.9711538461538461}, {
         Rational[3, 13], Rational[3, 13], 1.0096153846153846`}, {
         Rational[3, 13], Rational[5, 13], 0.9711538461538461}}, {{
        0.38461538461538464`, 0.38461538461538464`, 0.9326923076923077}, {
        0.38461538461538464`, 0.23076923076923078`, 0.9711538461538461}, {
        0.23076923076923078`, 0.23076923076923078`, 1.0096153846153846`}, {
        0.23076923076923078`, 0.38461538461538464`, 0.9711538461538461}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[7, 13], 0.8942307692307693}, {
         Rational[5, 13], Rational[5, 13], 0.9326923076923077}, {
         Rational[3, 13], Rational[5, 13], 0.9711538461538461}, {
         Rational[3, 13], Rational[7, 13], 0.9326923076923077}}, {{
        0.38461538461538464`, 0.5384615384615384, 0.8942307692307693}, {
        0.38461538461538464`, 0.38461538461538464`, 0.9326923076923077}, {
        0.23076923076923078`, 0.38461538461538464`, 0.9711538461538461}, {
        0.23076923076923078`, 0.5384615384615384, 0.9326923076923077}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[9, 13], 0.8557692307692307}, {
         Rational[5, 13], Rational[7, 13], 0.8942307692307693}, {
         Rational[3, 13], Rational[7, 13], 0.9326923076923077}, {
         Rational[3, 13], Rational[9, 13], 0.8942307692307693}}, {{
        0.38461538461538464`, 0.6923076923076923, 0.8557692307692307}, {
        0.38461538461538464`, 0.5384615384615384, 0.8942307692307693}, {
        0.23076923076923078`, 0.5384615384615384, 0.9326923076923077}, {
        0.23076923076923078`, 0.6923076923076923, 0.8942307692307693}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], Rational[11, 13], 0.8173076923076923}, {
         Rational[5, 13], Rational[9, 13], 0.8557692307692307}, {
         Rational[3, 13], Rational[9, 13], 0.8942307692307693}, {
         Rational[3, 13], Rational[11, 13], 0.8557692307692307}}, {{
        0.38461538461538464`, 0.8461538461538461, 0.8173076923076923}, {
        0.38461538461538464`, 0.6923076923076923, 0.8557692307692307}, {
        0.23076923076923078`, 0.6923076923076923, 0.8942307692307693}, {
        0.23076923076923078`, 0.8461538461538461, 0.8557692307692307}}]], 
      Polygon3DBox[
       NCache[{{Rational[5, 13], 1, 0.7788461538461539}, {
         Rational[5, 13], Rational[11, 13], 0.8173076923076923}, {
         Rational[3, 13], Rational[11, 13], 0.8557692307692307}, {
         Rational[3, 13], 1, 0.8173076923076923}}, {{
         0.38461538461538464`, 1, 0.7788461538461539}, {0.38461538461538464`, 
         0.8461538461538461, 0.8173076923076923}, {0.23076923076923078`, 
         0.8461538461538461, 0.8557692307692307}, {
         0.23076923076923078`, 1, 0.8173076923076923}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[-11, 13], 1.201923076923077}, {
         Rational[7, 13], -1, 1.2403846153846154`}, {
         Rational[5, 13], -1, 1.2788461538461537`}, {
         Rational[5, 13], Rational[-11, 13], 1.2403846153846154`}}, {{
         0.5384615384615384, -0.8461538461538461, 1.201923076923077}, {
         0.5384615384615384, -1, 1.2403846153846154`}, {
         0.38461538461538464`, -1, 1.2788461538461537`}, {
         0.38461538461538464`, -0.8461538461538461, 1.2403846153846154`}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[-9, 13], 1.1634615384615383`}, {
         Rational[7, 13], Rational[-11, 13], 1.201923076923077}, {
         Rational[5, 13], Rational[-11, 13], 1.2403846153846154`}, {
         Rational[5, 13], Rational[-9, 13], 1.2019230769230769`}}, {{
        0.5384615384615384, -0.6923076923076923, 1.1634615384615383`}, {
        0.5384615384615384, -0.8461538461538461, 1.201923076923077}, {
        0.38461538461538464`, -0.8461538461538461, 1.2403846153846154`}, {
        0.38461538461538464`, -0.6923076923076923, 1.2019230769230769`}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[-7, 13], 1.125}, {
         Rational[7, 13], Rational[-9, 13], 1.1634615384615383`}, {
         Rational[5, 13], Rational[-9, 13], 1.2019230769230769`}, {
         Rational[5, 13], Rational[-7, 13], 1.1634615384615383`}}, {{
        0.5384615384615384, -0.5384615384615384, 1.125}, {
        0.5384615384615384, -0.6923076923076923, 1.1634615384615383`}, {
        0.38461538461538464`, -0.6923076923076923, 1.2019230769230769`}, {
        0.38461538461538464`, -0.5384615384615384, 1.1634615384615383`}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[-5, 13], 1.0865384615384615`}, {
         Rational[7, 13], Rational[-7, 13], 1.125}, {
         Rational[5, 13], Rational[-7, 13], 1.1634615384615383`}, {
         Rational[5, 13], Rational[-5, 13], 1.125}}, {{
        0.5384615384615384, -0.38461538461538464`, 1.0865384615384615`}, {
        0.5384615384615384, -0.5384615384615384, 1.125}, {
        0.38461538461538464`, -0.5384615384615384, 1.1634615384615383`}, {
        0.38461538461538464`, -0.38461538461538464`, 1.125}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[-3, 13], 1.0480769230769231`}, {
         Rational[7, 13], Rational[-5, 13], 1.0865384615384615`}, {
         Rational[5, 13], Rational[-5, 13], 1.125}, {
         Rational[5, 13], Rational[-3, 13], 1.0865384615384617`}}, {{
        0.5384615384615384, -0.23076923076923078`, 1.0480769230769231`}, {
        0.5384615384615384, -0.38461538461538464`, 1.0865384615384615`}, {
        0.38461538461538464`, -0.38461538461538464`, 1.125}, {
        0.38461538461538464`, -0.23076923076923078`, 1.0865384615384617`}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[-1, 13], 1.0096153846153846`}, {
         Rational[7, 13], Rational[-3, 13], 1.0480769230769231`}, {
         Rational[5, 13], Rational[-3, 13], 1.0865384615384617`}, {
         Rational[5, 13], Rational[-1, 13], 1.0480769230769231`}}, {{
        0.5384615384615384, -0.07692307692307693, 1.0096153846153846`}, {
        0.5384615384615384, -0.23076923076923078`, 1.0480769230769231`}, {
        0.38461538461538464`, -0.23076923076923078`, 1.0865384615384617`}, {
        0.38461538461538464`, -0.07692307692307693, 1.0480769230769231`}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[1, 13], 0.9711538461538461}, {
         Rational[7, 13], Rational[-1, 13], 1.0096153846153846`}, {
         Rational[5, 13], Rational[-1, 13], 1.0480769230769231`}, {
         Rational[5, 13], Rational[1, 13], 1.0096153846153846`}}, {{
        0.5384615384615384, 0.07692307692307693, 0.9711538461538461}, {
        0.5384615384615384, -0.07692307692307693, 1.0096153846153846`}, {
        0.38461538461538464`, -0.07692307692307693, 1.0480769230769231`}, {
        0.38461538461538464`, 0.07692307692307693, 1.0096153846153846`}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[3, 13], 0.9326923076923077}, {
         Rational[7, 13], Rational[1, 13], 0.9711538461538461}, {
         Rational[5, 13], Rational[1, 13], 1.0096153846153846`}, {
         Rational[5, 13], Rational[3, 13], 0.9711538461538461}}, {{
        0.5384615384615384, 0.23076923076923078`, 0.9326923076923077}, {
        0.5384615384615384, 0.07692307692307693, 0.9711538461538461}, {
        0.38461538461538464`, 0.07692307692307693, 1.0096153846153846`}, {
        0.38461538461538464`, 0.23076923076923078`, 0.9711538461538461}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[5, 13], 0.8942307692307693}, {
         Rational[7, 13], Rational[3, 13], 0.9326923076923077}, {
         Rational[5, 13], Rational[3, 13], 0.9711538461538461}, {
         Rational[5, 13], Rational[5, 13], 0.9326923076923077}}, {{
        0.5384615384615384, 0.38461538461538464`, 0.8942307692307693}, {
        0.5384615384615384, 0.23076923076923078`, 0.9326923076923077}, {
        0.38461538461538464`, 0.23076923076923078`, 0.9711538461538461}, {
        0.38461538461538464`, 0.38461538461538464`, 0.9326923076923077}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[7, 13], 0.8557692307692308}, {
         Rational[7, 13], Rational[5, 13], 0.8942307692307693}, {
         Rational[5, 13], Rational[5, 13], 0.9326923076923077}, {
         Rational[5, 13], Rational[7, 13], 0.8942307692307693}}, {{
        0.5384615384615384, 0.5384615384615384, 0.8557692307692308}, {
        0.5384615384615384, 0.38461538461538464`, 0.8942307692307693}, {
        0.38461538461538464`, 0.38461538461538464`, 0.9326923076923077}, {
        0.38461538461538464`, 0.5384615384615384, 0.8942307692307693}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[9, 13], 0.8173076923076923}, {
         Rational[7, 13], Rational[7, 13], 0.8557692307692308}, {
         Rational[5, 13], Rational[7, 13], 0.8942307692307693}, {
         Rational[5, 13], Rational[9, 13], 0.8557692307692307}}, {{
        0.5384615384615384, 0.6923076923076923, 0.8173076923076923}, {
        0.5384615384615384, 0.5384615384615384, 0.8557692307692308}, {
        0.38461538461538464`, 0.5384615384615384, 0.8942307692307693}, {
        0.38461538461538464`, 0.6923076923076923, 0.8557692307692307}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], Rational[11, 13], 0.7788461538461539}, {
         Rational[7, 13], Rational[9, 13], 0.8173076923076923}, {
         Rational[5, 13], Rational[9, 13], 0.8557692307692307}, {
         Rational[5, 13], Rational[11, 13], 0.8173076923076923}}, {{
        0.5384615384615384, 0.8461538461538461, 0.7788461538461539}, {
        0.5384615384615384, 0.6923076923076923, 0.8173076923076923}, {
        0.38461538461538464`, 0.6923076923076923, 0.8557692307692307}, {
        0.38461538461538464`, 0.8461538461538461, 0.8173076923076923}}]], 
      Polygon3DBox[
       NCache[{{Rational[7, 13], 1, 0.7403846153846154}, {
         Rational[7, 13], Rational[11, 13], 0.7788461538461539}, {
         Rational[5, 13], Rational[11, 13], 0.8173076923076923}, {
         Rational[5, 13], 1, 0.7788461538461539}}, {{
         0.5384615384615384, 1, 0.7403846153846154}, {0.5384615384615384, 
         0.8461538461538461, 0.7788461538461539}, {0.38461538461538464`, 
         0.8461538461538461, 0.8173076923076923}, {
         0.38461538461538464`, 1, 0.7788461538461539}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[-11, 13], 1.1634615384615385`}, {
         Rational[9, 13], -1, 1.2019230769230769`}, {
         Rational[7, 13], -1, 1.2403846153846154`}, {
         Rational[7, 13], Rational[-11, 13], 1.201923076923077}}, {{
         0.6923076923076923, -0.8461538461538461, 1.1634615384615385`}, {
         0.6923076923076923, -1, 1.2019230769230769`}, {
         0.5384615384615384, -1, 1.2403846153846154`}, {
         0.5384615384615384, -0.8461538461538461, 1.201923076923077}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[-9, 13], 1.125}, {
         Rational[9, 13], Rational[-11, 13], 1.1634615384615385`}, {
         Rational[7, 13], Rational[-11, 13], 1.201923076923077}, {
         Rational[7, 13], Rational[-9, 13], 1.1634615384615383`}}, {{
        0.6923076923076923, -0.6923076923076923, 1.125}, {
        0.6923076923076923, -0.8461538461538461, 1.1634615384615385`}, {
        0.5384615384615384, -0.8461538461538461, 1.201923076923077}, {
        0.5384615384615384, -0.6923076923076923, 1.1634615384615383`}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[-7, 13], 1.0865384615384615`}, {
         Rational[9, 13], Rational[-9, 13], 1.125}, {
         Rational[7, 13], Rational[-9, 13], 1.1634615384615383`}, {
         Rational[7, 13], Rational[-7, 13], 1.125}}, {{
        0.6923076923076923, -0.5384615384615384, 1.0865384615384615`}, {
        0.6923076923076923, -0.6923076923076923, 1.125}, {
        0.5384615384615384, -0.6923076923076923, 1.1634615384615383`}, {
        0.5384615384615384, -0.5384615384615384, 1.125}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[-5, 13], 1.0480769230769231`}, {
         Rational[9, 13], Rational[-7, 13], 1.0865384615384615`}, {
         Rational[7, 13], Rational[-7, 13], 1.125}, {
         Rational[7, 13], Rational[-5, 13], 1.0865384615384615`}}, {{
        0.6923076923076923, -0.38461538461538464`, 1.0480769230769231`}, {
        0.6923076923076923, -0.5384615384615384, 1.0865384615384615`}, {
        0.5384615384615384, -0.5384615384615384, 1.125}, {
        0.5384615384615384, -0.38461538461538464`, 1.0865384615384615`}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[-3, 13], 1.0096153846153846`}, {
         Rational[9, 13], Rational[-5, 13], 1.0480769230769231`}, {
         Rational[7, 13], Rational[-5, 13], 1.0865384615384615`}, {
         Rational[7, 13], Rational[-3, 13], 1.0480769230769231`}}, {{
        0.6923076923076923, -0.23076923076923078`, 1.0096153846153846`}, {
        0.6923076923076923, -0.38461538461538464`, 1.0480769230769231`}, {
        0.5384615384615384, -0.38461538461538464`, 1.0865384615384615`}, {
        0.5384615384615384, -0.23076923076923078`, 1.0480769230769231`}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[-1, 13], 0.9711538461538461}, {
         Rational[9, 13], Rational[-3, 13], 1.0096153846153846`}, {
         Rational[7, 13], Rational[-3, 13], 1.0480769230769231`}, {
         Rational[7, 13], Rational[-1, 13], 1.0096153846153846`}}, {{
        0.6923076923076923, -0.07692307692307693, 0.9711538461538461}, {
        0.6923076923076923, -0.23076923076923078`, 1.0096153846153846`}, {
        0.5384615384615384, -0.23076923076923078`, 1.0480769230769231`}, {
        0.5384615384615384, -0.07692307692307693, 1.0096153846153846`}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[1, 13], 0.9326923076923077}, {
         Rational[9, 13], Rational[-1, 13], 0.9711538461538461}, {
         Rational[7, 13], Rational[-1, 13], 1.0096153846153846`}, {
         Rational[7, 13], Rational[1, 13], 0.9711538461538461}}, {{
        0.6923076923076923, 0.07692307692307693, 0.9326923076923077}, {
        0.6923076923076923, -0.07692307692307693, 0.9711538461538461}, {
        0.5384615384615384, -0.07692307692307693, 1.0096153846153846`}, {
        0.5384615384615384, 0.07692307692307693, 0.9711538461538461}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[3, 13], 0.8942307692307693}, {
         Rational[9, 13], Rational[1, 13], 0.9326923076923077}, {
         Rational[7, 13], Rational[1, 13], 0.9711538461538461}, {
         Rational[7, 13], Rational[3, 13], 0.9326923076923077}}, {{
        0.6923076923076923, 0.23076923076923078`, 0.8942307692307693}, {
        0.6923076923076923, 0.07692307692307693, 0.9326923076923077}, {
        0.5384615384615384, 0.07692307692307693, 0.9711538461538461}, {
        0.5384615384615384, 0.23076923076923078`, 0.9326923076923077}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[5, 13], 0.8557692307692307}, {
         Rational[9, 13], Rational[3, 13], 0.8942307692307693}, {
         Rational[7, 13], Rational[3, 13], 0.9326923076923077}, {
         Rational[7, 13], Rational[5, 13], 0.8942307692307693}}, {{
        0.6923076923076923, 0.38461538461538464`, 0.8557692307692307}, {
        0.6923076923076923, 0.23076923076923078`, 0.8942307692307693}, {
        0.5384615384615384, 0.23076923076923078`, 0.9326923076923077}, {
        0.5384615384615384, 0.38461538461538464`, 0.8942307692307693}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[7, 13], 0.8173076923076923}, {
         Rational[9, 13], Rational[5, 13], 0.8557692307692307}, {
         Rational[7, 13], Rational[5, 13], 0.8942307692307693}, {
         Rational[7, 13], Rational[7, 13], 0.8557692307692308}}, {{
        0.6923076923076923, 0.5384615384615384, 0.8173076923076923}, {
        0.6923076923076923, 0.38461538461538464`, 0.8557692307692307}, {
        0.5384615384615384, 0.38461538461538464`, 0.8942307692307693}, {
        0.5384615384615384, 0.5384615384615384, 0.8557692307692308}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[9, 13], 0.7788461538461539}, {
         Rational[9, 13], Rational[7, 13], 0.8173076923076923}, {
         Rational[7, 13], Rational[7, 13], 0.8557692307692308}, {
         Rational[7, 13], Rational[9, 13], 0.8173076923076923}}, {{
        0.6923076923076923, 0.6923076923076923, 0.7788461538461539}, {
        0.6923076923076923, 0.5384615384615384, 0.8173076923076923}, {
        0.5384615384615384, 0.5384615384615384, 0.8557692307692308}, {
        0.5384615384615384, 0.6923076923076923, 0.8173076923076923}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], Rational[11, 13], 0.7403846153846154}, {
         Rational[9, 13], Rational[9, 13], 0.7788461538461539}, {
         Rational[7, 13], Rational[9, 13], 0.8173076923076923}, {
         Rational[7, 13], Rational[11, 13], 0.7788461538461539}}, {{
        0.6923076923076923, 0.8461538461538461, 0.7403846153846154}, {
        0.6923076923076923, 0.6923076923076923, 0.7788461538461539}, {
        0.5384615384615384, 0.6923076923076923, 0.8173076923076923}, {
        0.5384615384615384, 0.8461538461538461, 0.7788461538461539}}]], 
      Polygon3DBox[
       NCache[{{Rational[9, 13], 1, 0.7019230769230769}, {
         Rational[9, 13], Rational[11, 13], 0.7403846153846154}, {
         Rational[7, 13], Rational[11, 13], 0.7788461538461539}, {
         Rational[7, 13], 1, 0.7403846153846154}}, {{
         0.6923076923076923, 1, 0.7019230769230769}, {0.6923076923076923, 
         0.8461538461538461, 0.7403846153846154}, {0.5384615384615384, 
         0.8461538461538461, 0.7788461538461539}, {
         0.5384615384615384, 1, 0.7403846153846154}}]]}, {
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[-11, 13], 1.125}, {
         Rational[11, 13], -1, 1.1634615384615383`}, {
         Rational[9, 13], -1, 1.2019230769230769`}, {
         Rational[9, 13], Rational[-11, 13], 1.1634615384615385`}}, {{
         0.8461538461538461, -0.8461538461538461, 1.125}, {
         0.8461538461538461, -1, 1.1634615384615383`}, {
         0.6923076923076923, -1, 1.2019230769230769`}, {
         0.6923076923076923, -0.8461538461538461, 1.1634615384615385`}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[-9, 13], 1.0865384615384615`}, {
         Rational[11, 13], Rational[-11, 13], 1.125}, {
         Rational[9, 13], Rational[-11, 13], 1.1634615384615385`}, {
         Rational[9, 13], Rational[-9, 13], 1.125}}, {{
        0.8461538461538461, -0.6923076923076923, 1.0865384615384615`}, {
        0.8461538461538461, -0.8461538461538461, 1.125}, {
        0.6923076923076923, -0.8461538461538461, 1.1634615384615385`}, {
        0.6923076923076923, -0.6923076923076923, 1.125}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[-7, 13], 1.0480769230769231`}, {
         Rational[11, 13], Rational[-9, 13], 1.0865384615384615`}, {
         Rational[9, 13], Rational[-9, 13], 1.125}, {
         Rational[9, 13], Rational[-7, 13], 1.0865384615384615`}}, {{
        0.8461538461538461, -0.5384615384615384, 1.0480769230769231`}, {
        0.8461538461538461, -0.6923076923076923, 1.0865384615384615`}, {
        0.6923076923076923, -0.6923076923076923, 1.125}, {
        0.6923076923076923, -0.5384615384615384, 1.0865384615384615`}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[-5, 13], 1.0096153846153846`}, {
         Rational[11, 13], Rational[-7, 13], 1.0480769230769231`}, {
         Rational[9, 13], Rational[-7, 13], 1.0865384615384615`}, {
         Rational[9, 13], Rational[-5, 13], 1.0480769230769231`}}, {{
        0.8461538461538461, -0.38461538461538464`, 1.0096153846153846`}, {
        0.8461538461538461, -0.5384615384615384, 1.0480769230769231`}, {
        0.6923076923076923, -0.5384615384615384, 1.0865384615384615`}, {
        0.6923076923076923, -0.38461538461538464`, 1.0480769230769231`}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[-3, 13], 0.9711538461538461}, {
         Rational[11, 13], Rational[-5, 13], 1.0096153846153846`}, {
         Rational[9, 13], Rational[-5, 13], 1.0480769230769231`}, {
         Rational[9, 13], Rational[-3, 13], 1.0096153846153846`}}, {{
        0.8461538461538461, -0.23076923076923078`, 0.9711538461538461}, {
        0.8461538461538461, -0.38461538461538464`, 1.0096153846153846`}, {
        0.6923076923076923, -0.38461538461538464`, 1.0480769230769231`}, {
        0.6923076923076923, -0.23076923076923078`, 1.0096153846153846`}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[-1, 13], 0.9326923076923077}, {
         Rational[11, 13], Rational[-3, 13], 0.9711538461538461}, {
         Rational[9, 13], Rational[-3, 13], 1.0096153846153846`}, {
         Rational[9, 13], Rational[-1, 13], 0.9711538461538461}}, {{
        0.8461538461538461, -0.07692307692307693, 0.9326923076923077}, {
        0.8461538461538461, -0.23076923076923078`, 0.9711538461538461}, {
        0.6923076923076923, -0.23076923076923078`, 1.0096153846153846`}, {
        0.6923076923076923, -0.07692307692307693, 0.9711538461538461}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[1, 13], 0.8942307692307693}, {
         Rational[11, 13], Rational[-1, 13], 0.9326923076923077}, {
         Rational[9, 13], Rational[-1, 13], 0.9711538461538461}, {
         Rational[9, 13], Rational[1, 13], 0.9326923076923077}}, {{
        0.8461538461538461, 0.07692307692307693, 0.8942307692307693}, {
        0.8461538461538461, -0.07692307692307693, 0.9326923076923077}, {
        0.6923076923076923, -0.07692307692307693, 0.9711538461538461}, {
        0.6923076923076923, 0.07692307692307693, 0.9326923076923077}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[3, 13], 0.8557692307692307}, {
         Rational[11, 13], Rational[1, 13], 0.8942307692307693}, {
         Rational[9, 13], Rational[1, 13], 0.9326923076923077}, {
         Rational[9, 13], Rational[3, 13], 0.8942307692307693}}, {{
        0.8461538461538461, 0.23076923076923078`, 0.8557692307692307}, {
        0.8461538461538461, 0.07692307692307693, 0.8942307692307693}, {
        0.6923076923076923, 0.07692307692307693, 0.9326923076923077}, {
        0.6923076923076923, 0.23076923076923078`, 0.8942307692307693}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[5, 13], 0.8173076923076923}, {
         Rational[11, 13], Rational[3, 13], 0.8557692307692307}, {
         Rational[9, 13], Rational[3, 13], 0.8942307692307693}, {
         Rational[9, 13], Rational[5, 13], 0.8557692307692307}}, {{
        0.8461538461538461, 0.38461538461538464`, 0.8173076923076923}, {
        0.8461538461538461, 0.23076923076923078`, 0.8557692307692307}, {
        0.6923076923076923, 0.23076923076923078`, 0.8942307692307693}, {
        0.6923076923076923, 0.38461538461538464`, 0.8557692307692307}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[7, 13], 0.7788461538461539}, {
         Rational[11, 13], Rational[5, 13], 0.8173076923076923}, {
         Rational[9, 13], Rational[5, 13], 0.8557692307692307}, {
         Rational[9, 13], Rational[7, 13], 0.8173076923076923}}, {{
        0.8461538461538461, 0.5384615384615384, 0.7788461538461539}, {
        0.8461538461538461, 0.38461538461538464`, 0.8173076923076923}, {
        0.6923076923076923, 0.38461538461538464`, 0.8557692307692307}, {
        0.6923076923076923, 0.5384615384615384, 0.8173076923076923}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[9, 13], 0.7403846153846154}, {
         Rational[11, 13], Rational[7, 13], 0.7788461538461539}, {
         Rational[9, 13], Rational[7, 13], 0.8173076923076923}, {
         Rational[9, 13], Rational[9, 13], 0.7788461538461539}}, {{
        0.8461538461538461, 0.6923076923076923, 0.7403846153846154}, {
        0.8461538461538461, 0.5384615384615384, 0.7788461538461539}, {
        0.6923076923076923, 0.5384615384615384, 0.8173076923076923}, {
        0.6923076923076923, 0.6923076923076923, 0.7788461538461539}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], Rational[11, 13], 0.7019230769230769}, {
         Rational[11, 13], Rational[9, 13], 0.7403846153846154}, {
         Rational[9, 13], Rational[9, 13], 0.7788461538461539}, {
         Rational[9, 13], Rational[11, 13], 0.7403846153846154}}, {{
        0.8461538461538461, 0.8461538461538461, 0.7019230769230769}, {
        0.8461538461538461, 0.6923076923076923, 0.7403846153846154}, {
        0.6923076923076923, 0.6923076923076923, 0.7788461538461539}, {
        0.6923076923076923, 0.8461538461538461, 0.7403846153846154}}]], 
      Polygon3DBox[
       NCache[{{Rational[11, 13], 1, 0.6634615384615384}, {
         Rational[11, 13], Rational[11, 13], 0.7019230769230769}, {
         Rational[9, 13], Rational[11, 13], 0.7403846153846154}, {
         Rational[9, 13], 1, 0.7019230769230769}}, {{
         0.8461538461538461, 1, 0.6634615384615384}, {0.8461538461538461, 
         0.8461538461538461, 0.7019230769230769}, {0.6923076923076923, 
         0.8461538461538461, 0.7403846153846154}, {
         0.6923076923076923, 1, 0.7019230769230769}}]]}, {
      Polygon3DBox[
       NCache[{{1, Rational[-11, 13], 1.0865384615384617`}, {1, -1, 1.125}, {
         Rational[11, 13], -1, 1.1634615384615383`}, {
         Rational[11, 13], Rational[-11, 13], 1.125}}, {{
         1, -0.8461538461538461, 1.0865384615384617`}, {1, -1, 1.125}, {
         0.8461538461538461, -1, 1.1634615384615383`}, {
         0.8461538461538461, -0.8461538461538461, 1.125}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[-9, 13], 1.0480769230769231`}, {
         1, Rational[-11, 13], 1.0865384615384617`}, {
         Rational[11, 13], Rational[-11, 13], 1.125}, {
         Rational[11, 13], Rational[-9, 13], 1.0865384615384615`}}, {{
         1, -0.6923076923076923, 1.0480769230769231`}, {
         1, -0.8461538461538461, 1.0865384615384617`}, {
         0.8461538461538461, -0.8461538461538461, 1.125}, {
         0.8461538461538461, -0.6923076923076923, 1.0865384615384615`}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[-7, 13], 1.0096153846153846`}, {
         1, Rational[-9, 13], 1.0480769230769231`}, {
         Rational[11, 13], Rational[-9, 13], 1.0865384615384615`}, {
         Rational[11, 13], Rational[-7, 13], 1.0480769230769231`}}, {{
         1, -0.5384615384615384, 1.0096153846153846`}, {
         1, -0.6923076923076923, 1.0480769230769231`}, {
         0.8461538461538461, -0.6923076923076923, 1.0865384615384615`}, {
         0.8461538461538461, -0.5384615384615384, 1.0480769230769231`}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[-5, 13], 0.9711538461538461}, {
         1, Rational[-7, 13], 1.0096153846153846`}, {
         Rational[11, 13], Rational[-7, 13], 1.0480769230769231`}, {
         Rational[11, 13], Rational[-5, 13], 1.0096153846153846`}}, {{
         1, -0.38461538461538464`, 0.9711538461538461}, {
         1, -0.5384615384615384, 1.0096153846153846`}, {
         0.8461538461538461, -0.5384615384615384, 1.0480769230769231`}, {
         0.8461538461538461, -0.38461538461538464`, 1.0096153846153846`}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[-3, 13], 0.9326923076923077}, {
         1, Rational[-5, 13], 0.9711538461538461}, {
         Rational[11, 13], Rational[-5, 13], 1.0096153846153846`}, {
         Rational[11, 13], Rational[-3, 13], 0.9711538461538461}}, {{
         1, -0.23076923076923078`, 0.9326923076923077}, {
         1, -0.38461538461538464`, 0.9711538461538461}, {
         0.8461538461538461, -0.38461538461538464`, 1.0096153846153846`}, {
         0.8461538461538461, -0.23076923076923078`, 0.9711538461538461}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[-1, 13], 0.8942307692307692}, {
         1, Rational[-3, 13], 0.9326923076923077}, {
         Rational[11, 13], Rational[-3, 13], 0.9711538461538461}, {
         Rational[11, 13], Rational[-1, 13], 0.9326923076923077}}, {{
         1, -0.07692307692307693, 0.8942307692307692}, {
         1, -0.23076923076923078`, 0.9326923076923077}, {
         0.8461538461538461, -0.23076923076923078`, 0.9711538461538461}, {
         0.8461538461538461, -0.07692307692307693, 0.9326923076923077}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[1, 13], 0.8557692307692307}, {
         1, Rational[-1, 13], 0.8942307692307692}, {
         Rational[11, 13], Rational[-1, 13], 0.9326923076923077}, {
         Rational[11, 13], Rational[1, 13], 0.8942307692307693}}, {{
         1, 0.07692307692307693, 0.8557692307692307}, {
         1, -0.07692307692307693, 0.8942307692307692}, {
         0.8461538461538461, -0.07692307692307693, 0.9326923076923077}, {
         0.8461538461538461, 0.07692307692307693, 0.8942307692307693}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[3, 13], 0.8173076923076923}, {
         1, Rational[1, 13], 0.8557692307692307}, {
         Rational[11, 13], Rational[1, 13], 0.8942307692307693}, {
         Rational[11, 13], Rational[3, 13], 0.8557692307692307}}, {{
         1, 0.23076923076923078`, 0.8173076923076923}, {
         1, 0.07692307692307693, 0.8557692307692307}, {0.8461538461538461, 
         0.07692307692307693, 0.8942307692307693}, {0.8461538461538461, 
         0.23076923076923078`, 0.8557692307692307}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[5, 13], 0.7788461538461539}, {
         1, Rational[3, 13], 0.8173076923076923}, {
         Rational[11, 13], Rational[3, 13], 0.8557692307692307}, {
         Rational[11, 13], Rational[5, 13], 0.8173076923076923}}, {{
         1, 0.38461538461538464`, 0.7788461538461539}, {
         1, 0.23076923076923078`, 0.8173076923076923}, {0.8461538461538461, 
         0.23076923076923078`, 0.8557692307692307}, {0.8461538461538461, 
         0.38461538461538464`, 0.8173076923076923}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[7, 13], 0.7403846153846154}, {
         1, Rational[5, 13], 0.7788461538461539}, {
         Rational[11, 13], Rational[5, 13], 0.8173076923076923}, {
         Rational[11, 13], Rational[7, 13], 0.7788461538461539}}, {{
         1, 0.5384615384615384, 0.7403846153846154}, {
         1, 0.38461538461538464`, 0.7788461538461539}, {0.8461538461538461, 
         0.38461538461538464`, 0.8173076923076923}, {0.8461538461538461, 
         0.5384615384615384, 0.7788461538461539}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[9, 13], 0.7019230769230769}, {
         1, Rational[7, 13], 0.7403846153846154}, {
         Rational[11, 13], Rational[7, 13], 0.7788461538461539}, {
         Rational[11, 13], Rational[9, 13], 0.7403846153846154}}, {{
         1, 0.6923076923076923, 0.7019230769230769}, {
         1, 0.5384615384615384, 0.7403846153846154}, {0.8461538461538461, 
         0.5384615384615384, 0.7788461538461539}, {0.8461538461538461, 
         0.6923076923076923, 0.7403846153846154}}]], 
      Polygon3DBox[
       NCache[{{1, Rational[11, 13], 0.6634615384615384}, {
         1, Rational[9, 13], 0.7019230769230769}, {
         Rational[11, 13], Rational[9, 13], 0.7403846153846154}, {
         Rational[11, 13], Rational[11, 13], 0.7019230769230769}}, {{
         1, 0.8461538461538461, 0.6634615384615384}, {
         1, 0.6923076923076923, 0.7019230769230769}, {0.8461538461538461, 
         0.6923076923076923, 0.7403846153846154}, {0.8461538461538461, 
         0.8461538461538461, 0.7019230769230769}}]], 
      Polygon3DBox[
       NCache[{{1, 1, 0.625}, {1, Rational[11, 13], 0.6634615384615384}, {
         Rational[11, 13], Rational[11, 13], 0.7019230769230769}, {
         Rational[11, 13], 1, 0.6634615384615384}}, {{1, 1, 0.625}, {
         1, 0.8461538461538461, 0.6634615384615384}, {0.8461538461538461, 
         0.8461538461538461, 0.7019230769230769}, {
         0.8461538461538461, 1, 0.6634615384615384}}]]}}}},
  Boxed->False,
  PlotRange->{{-1, 1}, {-1, 1}, {-1, 2.5}}]], "Output",
 CellChangeTimes->{
  3.405507515785721*^9, 3.405507548757398*^9, 3.405586740197112*^9, 
   3.405587284182296*^9, 3.405587396847174*^9, 3.405589020738962*^9, {
   3.405589180436382*^9, 3.405589200287557*^9}, 3.405589818162854*^9, 
   3.405607548900603*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]]
}, Closed]],

Cell[TextData[{
 "Wir schreiben diese wieder zur Verwendung als Input in unser html-Seite ",
 Cell[BoxData[
  TagBox[
   ButtonBox[
    PaneSelectorBox[{False->
     FrameBox["\<\"Beispiel-2.html\"\>",
      StripOnInput->False], True->
     StyleBox[
      FrameBox["\<\"Beispiel-2.html\"\>",
       StripOnInput->False], "HyperlinkActive"]}, Dynamic[
      CurrentValue["MouseOver"]],
     BaselinePosition->Baseline,
     FrameMargins->0,
     ImageSize->Automatic],
    BaseStyle->"Hyperlink",
    ButtonData->{
      URL["file:///home/andreas/uni/vortrag/Beispiel-2.html"], None},
    ButtonNote->"file:///home/andreas/uni/vortrag/Beispiel-2.html"],
   Annotation[#, "file:///home/andreas/uni/vortrag/Beispiel-2.html", 
    "Hyperlink"]& ]],
  CellChangeTimes->{3.40560641992851*^9, 3.40560648916559*^9, 
   3.405606942570584*^9}]
}], "Text",
 CellChangeTimes->{{3.405597713018501*^9, 3.405597753246961*^9}, {
   3.405597852807638*^9, 3.405597857625892*^9}, 3.405607484501725*^9, {
   3.40560751980633*^9, 3.405607527499343*^9}}],

Cell[BoxData[
 RowBox[{"WriteLiveForm", "[", 
  RowBox[{"\"\<demo-2d.m\>\"", ",", 
   RowBox[{"G2", "[", 
    RowBox[{"u", ",", "v"}], "]"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.405504457291049*^9, 3.405504519998677*^9}, {
   3.4055045517009*^9, 3.40550455964924*^9}, {3.405505280275964*^9, 
   3.405505301051302*^9}, {3.405507348873778*^9, 3.405507351898364*^9}, {
   3.405507467059134*^9, 3.405507467554529*^9}, {3.405507899077929*^9, 
   3.405507906513906*^9}, 3.405591143735949*^9, 3.405591225815042*^9, 
   3.405591404827512*^9, 3.405591712931163*^9, {3.405591742934334*^9, 
   3.405591744352259*^9}, 3.405607464105833*^9, {3.405607532090454*^9, 
   3.405607536066814*^9}}],

Cell["Innerhalb Mathematica sieht das ganze nun wie folgt aus", "Text",
 CellChangeTimes->{{3.405597770676109*^9, 3.40559778476259*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"G2", "[", 
    RowBox[{
     RowBox[{"u", "[", 
      RowBox[{"[", "1", "]"}], "]"}], ",", 
     RowBox[{"u", "[", 
      RowBox[{"[", "2", "]"}], "]"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"u", ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", "\"\<Position\>\""}], "}"}], ",",
      
     RowBox[{"{", 
      RowBox[{"x0", ",", "y0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"x1", ",", "y1"}], "}"}]}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.405508556499417*^9, 3.405508583312785*^9}, {
   3.405590053195545*^9, 3.405590089789331*^9}, {3.405590311523588*^9, 
   3.40559031599896*^9}, {3.405590362341724*^9, 3.405590372410757*^9}, 
   3.405591135167311*^9, {3.405607578973635*^9, 3.405607591628271*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`u$$ = {-0.57, 0.7200000000000001}, 
    Typeset`show$$ = True, Typeset`bookmarkList$$ = {}, 
    Typeset`bookmarkMode$$ = "Menu", Typeset`animator$$, Typeset`animvar$$ = 
    1, Typeset`name$$ = "\"untitled\"", Typeset`specs$$ = {{{
       Hold[$CellContext`u$$], {0, 0}, "Position"}, {-1, -1}, {1, 1}}}, 
    Typeset`size$$ = {290., {214., 218.}}, Typeset`update$$ = 0, 
    Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`u$549$$ = {0, 0}}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`u$$ = {0, 0}}, 
      "ControllerVariables" :> {
        Hold[$CellContext`u$$, $CellContext`u$549$$, {0, 0}]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> $CellContext`G2[
        Part[$CellContext`u$$, 1], 
        Part[$CellContext`u$$, 2]], 
      "Specifications" :> {{{$CellContext`u$$, {0, 0}, 
          "Position"}, {-1, -1}, {1, 1}}}, "Options" :> {}, 
      "DefaultOptions" :> {
       ControlPlacement -> Right, SaveDefinitions -> True}],
     ImageSizeCache->{480., {241., 248.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`G2[
         Pattern[$CellContext`u, 
          Blank[]], 
         Pattern[$CellContext`v, 
          Blank[]]] := Graphics3D[{
          $CellContext`G0[$CellContext`u, $CellContext`v], 
          FaceForm[
           RGBColor[0, 1, 1], 
           RGBColor[0, 0.6, 0.6]], 
          Part[$CellContext`P0, 1], 
          Part[$CellContext`P1, 1], 
          Part[
           $CellContext`P2[$CellContext`u, $CellContext`v], 
           1]}], $CellContext`G0[
         Pattern[$CellContext`u, 
          Blank[]], 
         Pattern[$CellContext`v, 
          Blank[]]] := {Red, 
         PointSize[0.02], 
         Point[{$CellContext`u, $CellContext`v, $CellContext`z0 - \
$CellContext`\[Epsilon]}], 
         Point[{$CellContext`u, $CellContext`v, $CellContext`z0 + \
$CellContext`\[Epsilon]}], 
         Point[{$CellContext`u, $CellContext`v, \
$CellContext`f[$CellContext`u, $CellContext`v] + $CellContext`\[Epsilon]}], 
         Point[{$CellContext`u, $CellContext`v, \
$CellContext`f[$CellContext`u, $CellContext`v] - $CellContext`\[Epsilon]}], 
         Point[{$CellContext`u, $CellContext`v, 
           $CellContext`f[$CellContext`u, $CellContext`v]}], 
         Line[{{$CellContext`u, $CellContext`v, $CellContext`z0}, \
{$CellContext`u, $CellContext`v, 
            $CellContext`f[$CellContext`u, $CellContext`v]}}], 
         Black}, $CellContext`z0 = -1, $CellContext`\[Epsilon] = 
       0.03, $CellContext`f[
         Pattern[$CellContext`x, 
          Blank[]], 
         Pattern[$CellContext`y, 
          Blank[]]] := 1 - ($CellContext`x^2 + $CellContext`y^2)/4, 
       Attributes[Power] = {Listable, NumericFunction, OneIdentity}, 
       TagSetDelayed[Power, 
        Default[Power, 2], 
        1], $CellContext`P0 := $CellContext`PP3D[{$CellContext`x, \
$CellContext`y, $CellContext`z0}, {$CellContext`x, $CellContext`x0, \
$CellContext`x1}, {$CellContext`y, $CellContext`y0, $CellContext`y1}], \
$CellContext`PP3D[Blank[] Removed["f"], 
         Pattern[$CellContext`x, 
          Blank[]], 
         PatternTest[
          Pattern[$CellContext`opts, 
           BlankNullSequence[]], OptionQ]] := 
       Module[{$CellContext`xv, $CellContext`x0, $CellContext`x1, \
$CellContext`steps}, $CellContext`xv = 
          Part[$CellContext`x, 1]; $CellContext`x0 = 
          Part[$CellContext`x, 2]; $CellContext`x1 = Part[$CellContext`x, 3]; 
         Unprotect["PlotPoints"]; $CellContext`steps = ReplaceAll[
            ReplaceAll[PlotPoints, {$CellContext`opts}], 
            Options[$CellContext`PP3D]]; $CellContext`thickness = ReplaceAll[
            ReplaceAll[$CellContext`LineThickness, {$CellContext`opts}], 
            Options[$CellContext`PP3D]]; $CellContext`color = ReplaceAll[
            ReplaceAll[$CellContext`LineColor, {$CellContext`opts}], 
            Options[$CellContext`PP3D]]; If[
           VectorQ[$CellContext`steps], $CellContext`steps = 
           Part[$CellContext`steps, 
             1]]; $CellContext`dx = ($CellContext`x1 - \
$CellContext`x0)/$CellContext`steps; Graphics3D[{
            If[
             VectorQ[$CellContext`thickness], 
             Thickness[
              Part[$CellContext`thickness, 1]], 
             Thickness[$CellContext`thickness]], $CellContext`color, 
            Line[
             Table[
              ReplaceAll[
               Removed[
               "f"], {$CellContext`xv -> $CellContext`i}], {$CellContext`i, \
$CellContext`x0, $CellContext`x1, $CellContext`dx}]]}]], $CellContext`PP3D[
        Removed["f"] Blank[], 
         Pattern[$CellContext`x, 
          Blank[]], 
         PatternTest[
          Pattern[$CellContext`opts, 
           BlankNullSequence[]], OptionQ]] := 
       Module[{$CellContext`xv, $CellContext`x0, $CellContext`x1, \
$CellContext`steps}, $CellContext`xv = 
          Part[$CellContext`x, 1]; $CellContext`x0 = 
          Part[$CellContext`x, 2]; $CellContext`x1 = Part[$CellContext`x, 3]; 
         Unprotect["PlotPoints"]; $CellContext`steps = ReplaceAll[
            ReplaceAll[PlotPoints, {$CellContext`opts}], 
            Options[$CellContext`PP3D]]; $CellContext`thickness = ReplaceAll[
            ReplaceAll[$CellContext`LineThickness, {$CellContext`opts}], 
            Options[$CellContext`PP3D]]; $CellContext`color = ReplaceAll[
            ReplaceAll[$CellContext`LineColor, {$CellContext`opts}], 
            Options[$CellContext`PP3D]]; If[
           VectorQ[$CellContext`steps], $CellContext`steps = 
           Part[$CellContext`steps, 
             1]]; $CellContext`dx = ($CellContext`x1 - \
$CellContext`x0)/$CellContext`steps; Graphics3D[{
            If[
             VectorQ[$CellContext`thickness], 
             Thickness[
              Part[$CellContext`thickness, 1]], 
             Thickness[$CellContext`thickness]], $CellContext`color, 
            Line[
             Table[
              ReplaceAll[
               Removed[
               "f"], {$CellContext`xv -> $CellContext`i}], {$CellContext`i, \
$CellContext`x0, $CellContext`x1, $CellContext`dx}]]}]], $CellContext`PP3D[
        Blank[] Removed["f"], 
         Pattern[$CellContext`x, 
          Blank[]], 
         Pattern[$CellContext`y, 
          Blank[]], 
         PatternTest[
          Pattern[$CellContext`opts, 
           BlankNullSequence[]], OptionQ]] := 
       Module[{$CellContext`xy, $CellContext`x0, $CellContext`x1, \
$CellContext`dx, $CellContext`yv, $CellContext`y0, $CellContext`y1, \
$CellContext`dy, $CellContext`steps}, $CellContext`xv = 
          Part[$CellContext`x, 1]; $CellContext`yv = 
          Part[$CellContext`y, 1]; $CellContext`x0 = 
          Part[$CellContext`x, 2]; $CellContext`x1 = 
          Part[$CellContext`x, 3]; $CellContext`y0 = 
          Part[$CellContext`y, 2]; $CellContext`y1 = Part[$CellContext`y, 3]; 
         Unprotect["PlotPoints"]; $CellContext`steps = ReplaceAll[
            ReplaceAll[PlotPoints, {$CellContext`opts}], 
            Options[$CellContext`PP3D]]; $CellContext`gridlines = ReplaceAll[
            ReplaceAll[GridLines, {$CellContext`opts}], 
            
            Options[$CellContext`PP3D]]; $CellContext`dx = ($CellContext`x1 - \
$CellContext`x0)/
           Part[$CellContext`steps, 
            1]; $CellContext`dy = ($CellContext`y1 - $CellContext`y0)/
           Part[$CellContext`steps, 2]; Graphics3D[{
            If[$CellContext`gridlines, 
             EdgeForm[
              GrayLevel[0.5]], 
             EdgeForm[{}]], 
            Table[
             Polygon[{
               ReplaceAll[
                Removed[
                "f"], {$CellContext`xv -> $CellContext`i, $CellContext`yv -> \
$CellContext`j}], 
               ReplaceAll[
                Removed[
                "f"], {$CellContext`xv -> $CellContext`i, $CellContext`yv -> \
$CellContext`j - $CellContext`dy}], 
               ReplaceAll[
                Removed[
                "f"], {$CellContext`xv -> $CellContext`i - $CellContext`dx, \
$CellContext`yv -> $CellContext`j - $CellContext`dy}], 
               ReplaceAll[
                Removed[
                "f"], {$CellContext`xv -> $CellContext`i - $CellContext`dx, \
$CellContext`yv -> $CellContext`j}]}], {$CellContext`i, $CellContext`x0 + \
$CellContext`dx, $CellContext`x1, $CellContext`dx}, {$CellContext`j, \
$CellContext`y0 + $CellContext`dy, $CellContext`y1, $CellContext`dy}]}]], \
$CellContext`PP3D[Removed["f"] Blank[], 
         Pattern[$CellContext`x, 
          Blank[]], 
         Pattern[$CellContext`y, 
          Blank[]], 
         PatternTest[
          Pattern[$CellContext`opts, 
           BlankNullSequence[]], OptionQ]] := 
       Module[{$CellContext`xy, $CellContext`x0, $CellContext`x1, \
$CellContext`dx, $CellContext`yv, $CellContext`y0, $CellContext`y1, \
$CellContext`dy, $CellContext`steps}, $CellContext`xv = 
          Part[$CellContext`x, 1]; $CellContext`yv = 
          Part[$CellContext`y, 1]; $CellContext`x0 = 
          Part[$CellContext`x, 2]; $CellContext`x1 = 
          Part[$CellContext`x, 3]; $CellContext`y0 = 
          Part[$CellContext`y, 2]; $CellContext`y1 = Part[$CellContext`y, 3]; 
         Unprotect["PlotPoints"]; $CellContext`steps = ReplaceAll[
            ReplaceAll[PlotPoints, {$CellContext`opts}], 
            Options[$CellContext`PP3D]]; $CellContext`gridlines = ReplaceAll[
            ReplaceAll[GridLines, {$CellContext`opts}], 
            
            Options[$CellContext`PP3D]]; $CellContext`dx = ($CellContext`x1 - \
$CellContext`x0)/
           Part[$CellContext`steps, 
            1]; $CellContext`dy = ($CellContext`y1 - $CellContext`y0)/
           Part[$CellContext`steps, 2]; Graphics3D[{
            If[$CellContext`gridlines, 
             EdgeForm[
              GrayLevel[0.5]], 
             EdgeForm[{}]], 
            Table[
             Polygon[{
               ReplaceAll[
                Removed[
                "f"], {$CellContext`xv -> $CellContext`i, $CellContext`yv -> \
$CellContext`j}], 
               ReplaceAll[
                Removed[
                "f"], {$CellContext`xv -> $CellContext`i, $CellContext`yv -> \
$CellContext`j - $CellContext`dy}], 
               ReplaceAll[
                Removed[
                "f"], {$CellContext`xv -> $CellContext`i - $CellContext`dx, \
$CellContext`yv -> $CellContext`j - $CellContext`dy}], 
               ReplaceAll[
                Removed[
                "f"], {$CellContext`xv -> $CellContext`i - $CellContext`dx, \
$CellContext`yv -> $CellContext`j}]}], {$CellContext`i, $CellContext`x0 + \
$CellContext`dx, $CellContext`x1, $CellContext`dx}, {$CellContext`j, \
$CellContext`y0 + $CellContext`dy, $CellContext`y1, $CellContext`dy}]}]], 
       Options[$CellContext`PP3D] = {
        PlotPoints -> {13, 13}, GridLines -> True, $CellContext`LineThickness -> 
         0.001, $CellContext`LineColor -> 
         GrayLevel[
          0]}, $CellContext`xv = $CellContext`x, $CellContext`x0 = -1, \
$CellContext`x1 = 1, $CellContext`y0 = -1, $CellContext`y1 = 
       1, $CellContext`gridlines = 
       True, $CellContext`P1 := $CellContext`PP3D[{$CellContext`x, \
$CellContext`y, 
          $CellContext`f[$CellContext`x, $CellContext`y]}, {$CellContext`x, \
$CellContext`x0, $CellContext`x1}, {$CellContext`y, $CellContext`y0, \
$CellContext`y1}], $CellContext`P2[
         Pattern[$CellContext`u, 
          Blank[]], 
         Pattern[$CellContext`v, 
          Blank[]]] := $CellContext`PP3D[{$CellContext`x, $CellContext`y, 
          $CellContext`t[$CellContext`x, $CellContext`y, $CellContext`u, \
$CellContext`v]}, {$CellContext`x, $CellContext`x0, $CellContext`x1}, \
{$CellContext`y, $CellContext`y0, $CellContext`y1}], $CellContext`t[
         Pattern[$CellContext`x, 
          Blank[]], 
         Pattern[$CellContext`y, 
          Blank[]], 
         Pattern[$CellContext`u, 
          Blank[]], 
         Pattern[$CellContext`v, 
          
          Blank[]]] := $CellContext`f[$CellContext`u, $CellContext`v] + \
($CellContext`x - $CellContext`u) 
         Derivative[
          1, 0][$CellContext`f][$CellContext`u, $CellContext`v] + \
($CellContext`y - $CellContext`v) 
         Derivative[0, 1][$CellContext`f][$CellContext`u, $CellContext`v], 
       Attributes[Derivative] = {NHoldAll, ReadProtected}}; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.40550858538665*^9, 3.405589831484273*^9, 3.405590012869977*^9, {
   3.405590064740022*^9, 3.405590091799908*^9}, 3.405590316964302*^9, 
   3.40559037277309*^9, {3.405607581968058*^9, 3.405607593302891*^9}}]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell[TextData[{
 "Ein einfaches Beispiel via ParametricPlot3D / PP3D ",
 Cell[BoxData[
  TagBox[
   ButtonBox[
    PaneSelectorBox[{False->
     FrameBox["\<\"Torus.html\"\>",
      StripOnInput->False], True->
     StyleBox[
      FrameBox["\<\"Torus.html\"\>",
       StripOnInput->False], "HyperlinkActive"]}, Dynamic[
      CurrentValue["MouseOver"]],
     BaselinePosition->Baseline,
     FrameMargins->0,
     ImageSize->Automatic],
    BaseStyle->"Hyperlink",
    ButtonData->{
      URL["file:///home/andreas/uni/vortrag/Torus.html"], None},
    ButtonNote->"file:///home/andreas/uni/vortrag/Torus.html"],
   Annotation[#, "file:///home/andreas/uni/vortrag/Torus.html", 
    "Hyperlink"]& ]],
  CellChangeTimes->{3.40560642182797*^9}]
}], "Section",
 CellChangeTimes->{{3.405574376906464*^9, 3.405574424142039*^9}, 
   3.405574501108898*^9, {3.405606460649276*^9, 3.405606461267737*^9}}],

Cell["\<\
Wir rollen ein Rechteck auf verschiedende Weisen zu einem Torus ein.\
\>", "Text",
 CellChangeTimes->{{3.405591926350569*^9, 3.405591955402659*^9}, {
  3.405595098711891*^9, 3.405595119306501*^9}}],

Cell[CellGroupData[{

Cell["Die parametrisierte Graphik", "Subsection",
 CellChangeTimes->{{3.40559435613945*^9, 3.405594366869296*^9}, {
  3.405595008183055*^9, 3.405595010385198*^9}}],

Cell[CellGroupData[{

Cell["Das Rechteck in Ruhelage", "Subsubsection",
 CellChangeTimes->{{3.405417265076219*^9, 3.405417272988193*^9}}],

Cell[BoxData[{
 RowBox[{"Clear", "[", "h", "]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"h", "[", 
   RowBox[{"\[Phi]_", ",", "\[Psi]_"}], "]"}], ":=", 
  RowBox[{"{", 
   RowBox[{"\[Phi]", ",", "0", ",", "\[Psi]"}], "}"}]}]}], "Input",
 CellChangeTimes->{{3.40541624054968*^9, 3.405416261815591*^9}, {
  3.405416294112404*^9, 3.405416297009048*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Tangentiale und normale Komponente des Einrollens der x-Achse in Richtung y\
\>", "Subsubsection",
 CellChangeTimes->{{3.405421775251579*^9, 3.405421798803274*^9}}],

Cell["\<\
\[Phi] ... Der Bogenlaengenparameter
t ... Der Deformationsparameter
ft ... Die tangentiale Komponente
fn ... Die vertikale Komponente\
\>", "Text",
 CellChangeTimes->{{3.405423921106163*^9, 3.405424007761351*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"ft", "[", 
   RowBox[{"t_", ",", "\[Phi]_"}], "]"}], ":=", 
  RowBox[{
   RowBox[{"Sin", "[", 
    RowBox[{"t", " ", "\[Phi]"}], "]"}], "/", 
   "t"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"fn", "[", 
   RowBox[{"t_", ",", "\[Phi]_"}], "]"}], ":=", 
  RowBox[{"2", 
   RowBox[{
    RowBox[{
     RowBox[{"Sin", "[", 
      RowBox[{"t", " ", 
       RowBox[{"\[Phi]", "/", "2"}]}], "]"}], "^", "2"}], "/", 
    "t"}]}]}]}], "Input"]
}, Closed]],

Cell[CellGroupData[{

Cell["Visualisierung des Einrolllens einer Gerade zu einem Kreis", \
"Subsubsection",
 CellChangeTimes->{{3.405424023127574*^9, 3.40542403420083*^9}, {
  3.405598060000201*^9, 3.405598098864606*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Manipulate", "[", 
  RowBox[{
   RowBox[{"ParametricPlot", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"ft", "[", 
        RowBox[{"t", ",", "\[Phi]"}], "]"}], ",", 
       RowBox[{"fn", "[", 
        RowBox[{"t", ",", "\[Phi]"}], "]"}]}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"\[Phi]", ",", 
       RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
     RowBox[{"PlotRange", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "2"}], "}"}]}], "}"}]}], ",", 
     RowBox[{"Ticks", "\[Rule]", "False"}]}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"t", ",", "0.001", ",", "1"}], "}"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.405421831257147*^9, 3.405421931689062*^9}, {
   3.405422098948047*^9, 3.405422197412222*^9}, 3.405592002336674*^9, {
   3.405592053260478*^9, 3.405592102844954*^9}, {3.405592295301053*^9, 
   3.405592367704069*^9}, {3.405592403192119*^9, 3.405592413479558*^9}, {
   3.405592483313239*^9, 3.405592500014472*^9}, {3.405607674197468*^9, 
   3.405607677559031*^9}}],

Cell[BoxData[
 TagBox[
  StyleBox[
   DynamicModuleBox[{$CellContext`t$$ = 1., Typeset`show$$ = True, 
    Typeset`bookmarkList$$ = {}, Typeset`bookmarkMode$$ = "Menu", 
    Typeset`animator$$, Typeset`animvar$$ = 1, Typeset`name$$ = 
    "\"untitled\"", Typeset`specs$$ = {{
      Hold[$CellContext`t$$], 0.001, 1}}, Typeset`size$$ = {360., {55., 60.}},
     Typeset`update$$ = 0, Typeset`initDone$$, Typeset`skipInitDone$$ = 
    False, $CellContext`t$642$$ = 0}, 
    DynamicBox[Manipulate`ManipulateBoxes[
     1, StandardForm, "Variables" :> {$CellContext`t$$ = 0.001}, 
      "ControllerVariables" :> {
        Hold[$CellContext`t$$, $CellContext`t$642$$, 0]}, 
      "OtherVariables" :> {
       Typeset`show$$, Typeset`bookmarkList$$, Typeset`bookmarkMode$$, 
        Typeset`animator$$, Typeset`animvar$$, Typeset`name$$, 
        Typeset`specs$$, Typeset`size$$, Typeset`update$$, Typeset`initDone$$,
         Typeset`skipInitDone$$}, "Body" :> ParametricPlot[{
         $CellContext`ft[$CellContext`t$$, $CellContext`\[Phi]], 
         $CellContext`fn[$CellContext`t$$, $CellContext`\[Phi]]}, \
{$CellContext`\[Phi], -Pi, Pi}, PlotRange -> {{-Pi, Pi}, {0, 2}}, Ticks -> 
        False], "Specifications" :> {{$CellContext`t$$, 0.001, 1}}, 
      "Options" :> {}, 
      "DefaultOptions" :> {
       ControlPlacement -> Right, SaveDefinitions -> True}],
     ImageSizeCache->{638., {82., 89.}},
     SingleEvaluation->True],
    Deinitialization:>None,
    DynamicModuleValues:>{},
    Initialization:>({$CellContext`ft[
         Pattern[$CellContext`t, 
          Blank[]], 
         Pattern[$CellContext`\[Phi], 
          Blank[]]] := 
       Sin[$CellContext`t $CellContext`\[Phi]]/$CellContext`t, \
$CellContext`t$$[
         Pattern[$CellContext`x, 
          Blank[]], 
         Pattern[$CellContext`y, 
          Blank[]], 
         Pattern[$CellContext`u, 
          Blank[]], 
         Pattern[$CellContext`v, 
          
          Blank[]]] := $CellContext`f[$CellContext`u, $CellContext`v] + \
($CellContext`x - $CellContext`u) 
         Derivative[
          1, 0][$CellContext`f][$CellContext`u, $CellContext`v] + \
($CellContext`y - $CellContext`v) 
         Derivative[
          0, 1][$CellContext`f][$CellContext`u, $CellContext`v], \
$CellContext`f[
         Pattern[$CellContext`x, 
          Blank[]], 
         Pattern[$CellContext`y, 
          Blank[]]] := 1 - ($CellContext`x^2 + $CellContext`y^2)/4, 
       Attributes[Power] = {Listable, NumericFunction, OneIdentity}, 
       TagSetDelayed[Power, 
        Default[Power, 2], 1], 
       Attributes[Derivative] = {NHoldAll, ReadProtected}, $CellContext`fn[
         Pattern[$CellContext`t, 
          Blank[]], 
         Pattern[$CellContext`\[Phi], 
          Blank[]]] := 
       2 (Sin[$CellContext`t ($CellContext`\[Phi]/2)]^2/$CellContext`t)}; 
     Typeset`initDone$$ = True),
    SynchronousInitialization->True,
    UnsavedVariables:>{Typeset`initDone$$},
    UntrackedVariables:>{Typeset`size$$}], "Manipulate",
   Deployed->True,
   StripOnInput->False],
  Manipulate`InterpretManipulate[1]]], "Output",
 CellChangeTimes->{
  3.4054218966457*^9, 3.405421932563109*^9, {3.405422109902316*^9, 
   3.405422115683956*^9}, {3.4054221562304*^9, 3.40542219849469*^9}, 
   3.405492870623759*^9, 3.405495673835249*^9, {3.405591973242257*^9, 
   3.405591992506877*^9}, 3.40559210701234*^9, {3.405592305287944*^9, 
   3.405592359956257*^9}, {3.405592404473235*^9, 3.405592414017791*^9}, 
   3.405592500548076*^9, {3.405607668763375*^9, 3.40560767853235*^9}}]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Einrollen der Erzeugendenschar einer Flaeche in Richtung der Flaechennormale\
\>", "Subsubsection",
 CellChangeTimes->{{3.405422356791117*^9, 3.40542240553962*^9}}],

Cell["\<\
Dabei ist vorausgesetzt, dass die parametrisierte Flaeche h in diesem \
Parameter linear ist.
Gerollt wird in Richtung der Flaechennormale.\
\>", "Text",
 CellChangeTimes->{{3.40542243012193*^9, 3.405422431994458*^9}, {
   3.405422495508187*^9, 3.405422513847236*^9}, 3.405424069283342*^9, {
   3.405424100941801*^9, 3.405424103103165*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"R1", "[", 
   RowBox[{"h_", ",", "t_", ",", "u_", ",", "v_"}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"h", "[", 
    RowBox[{"0", ",", "v"}], "]"}], "+", 
   RowBox[{
    RowBox[{"ft", "[", 
     RowBox[{"t", ",", "u"}], "]"}], " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Derivative", "[", 
       RowBox[{"1", ",", "0"}], "]"}], "[", "h", "]"}], "[", 
     RowBox[{"u", ",", "v"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"fn", "[", 
     RowBox[{"t", ",", "u"}], "]"}], 
    RowBox[{"Cross", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"0", ",", "1"}], "]"}], "[", "h", "]"}], "[", 
       RowBox[{"u", ",", "v"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"1", ",", "0"}], "]"}], "[", "h", "]"}], "[", 
       RowBox[{"u", ",", "v"}], "]"}]}], "]"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R2", "[", 
   RowBox[{"h_", ",", "t_", ",", "u_", ",", "v_"}], "]"}], ":=", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"h", "[", 
    RowBox[{"u", ",", "0"}], "]"}], "+", 
   RowBox[{
    RowBox[{"ft", "[", 
     RowBox[{"t", ",", "v"}], "]"}], " ", 
    RowBox[{
     RowBox[{
      RowBox[{"Derivative", "[", 
       RowBox[{"0", ",", "1"}], "]"}], "[", "h", "]"}], "[", 
     RowBox[{"u", ",", "v"}], "]"}]}], "+", 
   RowBox[{
    RowBox[{"fn", "[", 
     RowBox[{"t", ",", "v"}], "]"}], 
    RowBox[{"Cross", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"1", ",", "0"}], "]"}], "[", "h", "]"}], "[", 
       RowBox[{"u", ",", "v"}], "]"}], ",", 
      RowBox[{
       RowBox[{
        RowBox[{"Derivative", "[", 
         RowBox[{"0", ",", "1"}], "]"}], "[", "h", "]"}], "[", 
       RowBox[{"u", ",", "v"}], "]"}]}], "]"}]}]}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"R", "[", 
   RowBox[{"u_", ",", "v_", ",", "t_", ",", "s_"}], "]"}], ":=", 
  RowBox[{"R2", "[", 
   RowBox[{
    RowBox[{"Function", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"u1", ",", "v1"}], "}"}], ",", 
      RowBox[{"R1", "[", 
       RowBox[{"h", ",", 
        RowBox[{"t", "/", "2"}], ",", "u1", ",", "v1"}], "]"}]}], "]"}], ",", 
    
    RowBox[{"s", "/", "2"}], ",", "u", ",", "v"}], "]"}]}]}], "Input",
 CellChangeTimes->{{3.405416288837698*^9, 3.405416291303879*^9}, 
   3.405417293417233*^9, {3.405598267374167*^9, 3.405598268223743*^9}, {
   3.405599271708994*^9, 3.405599296432216*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Die Schieberegel fuer die beiden Deformations-Parameter als farbige Punkte im \
Raum \
\>", "Subsubsection",
 CellChangeTimes->{{3.405598315283541*^9, 3.405598342250187*^9}, {
  3.405598431436664*^9, 3.405598446108125*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"G03", "[", 
   RowBox[{"t_", ",", "s_"}], "]"}], ":=", 
  RowBox[{"Graphics3D", "[", 
   RowBox[{"{", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"PointSize", "[", "0.01", "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"1", ",", "0", ",", "0"}], "]"}], ",", "\[IndentingNewLine]", 
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "2", ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Point", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "t", ",", "0"}], "}"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"RGBColor", "[", 
      RowBox[{"0", ",", "0.8", ",", "0"}], "]"}], ",", "\[IndentingNewLine]", 
     
     RowBox[{"Line", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "0", ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", 
          RowBox[{"-", "2"}], ",", "0"}], "}"}]}], "}"}], "]"}], ",", 
     "\[IndentingNewLine]", 
     RowBox[{"Point", "[", 
      RowBox[{"{", 
       RowBox[{"0", ",", "s", ",", "0"}], "}"}], "]"}]}], 
    "\[IndentingNewLine]", "}"}], "]"}]}]], "Input",
 CellChangeTimes->{{3.405598363857451*^9, 3.405598390754243*^9}, {
  3.405599060048707*^9, 3.405599062556219*^9}, {3.405607713436426*^9, 
  3.405607714604549*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Testbilder", "Subsubsection",
 CellChangeTimes->{{3.405417304990029*^9, 3.405417312087616*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"R1", "[", 
    RowBox[{"h", ",", 
     RowBox[{"1", "/", "2"}], ",", "u", ",", "v"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}]}], 
  "]"}], "\[IndentingNewLine]", 
 RowBox[{"ParametricPlot3D", "[", 
  RowBox[{
   RowBox[{"R", "[", 
    RowBox[{"u", ",", "v", ",", "0.5", ",", "0.5"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"u", ",", 
     RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}], ",", 
   RowBox[{"{", 
    RowBox[{"v", ",", 
     RowBox[{"-", "\[Pi]"}], ",", "\[Pi]"}], "}"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.405607738632775*^9, 3.405607770353978*^9}}],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyFnHuUV1UVx2F4ZhqFZgLZktBCSSgzDSz3pUSBEhEX4BNdJBZYYShWSyAt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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmXnAVtMWxs/eZ0dligiheTLmorpkqDRnSIPSIEqIEkplShpFhqgMGSpz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         "]], Polygon3DBox[CompressedData["
1:eJwtmXfgjuUexp/nvp8oRSKhzDKSkFnJHhVRkZJUJ1qys2fZMkMRSmgRomGE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         "]], Polygon3DBox[CompressedData["
1:eJwt1nf8T/UeB/Cvn71Hl1BZN7tIRUZGysiMjOwRbvYOJSkymvdmKytbtqz7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         "]]}]}, {}, {}, {}}, {{}, {}, {}, {
      Line3DBox[{251, 459, 1044, 252, 472, 278, 1132, 486, 292, 1136, 500, 
       306, 1142, 514, 320, 1150, 528, 334, 1160, 542, 348, 556, 1087, 362, 
       1173, 570, 376, 1176, 584, 390, 1180, 598, 404, 1186, 612, 418, 1194, 
       626, 432, 1203, 640, 446}], 
      Line3DBox[{253, 460, 1045, 254, 473, 1055, 279, 487, 293, 1137, 501, 
       307, 1143, 515, 321, 1151, 529, 335, 1161, 543, 349, 557, 1088, 363, 
       571, 1099, 377, 585, 391, 1181, 599, 405, 1187, 613, 419, 1195, 627, 
       433, 1204, 641, 447}], 
      Line3DBox[{255, 461, 1046, 256, 474, 1056, 280, 488, 1065, 294, 502, 
       308, 1144, 516, 322, 1152, 530, 336, 1162, 544, 350, 558, 1089, 364, 
       572, 1100, 378, 586, 1109, 392, 600, 406, 1188, 614, 420, 1196, 628, 
       434, 1205, 642, 448}], 
      Line3DBox[{257, 462, 1047, 258, 475, 1057, 281, 489, 1066, 295, 503, 
       1073, 309, 517, 323, 1153, 531, 337, 1163, 545, 351, 559, 1090, 365, 
       573, 1101, 379, 587, 1110, 393, 601, 1117, 407, 615, 421, 1197, 629, 
       435, 1206, 643, 449}], 
      Line3DBox[{259, 463, 1048, 260, 476, 1058, 282, 490, 1067, 296, 504, 
       1074, 310, 518, 1079, 324, 532, 338, 1164, 546, 352, 560, 1091, 366, 
       574, 1102, 380, 588, 1111, 394, 602, 1118, 408, 616, 1123, 422, 630, 
       436, 1207, 644, 450}], 
      Line3DBox[{261, 464, 1049, 262, 477, 1059, 283, 491, 1068, 297, 505, 
       1075, 311, 519, 1080, 325, 533, 1083, 339, 547, 353, 561, 1092, 367, 
       575, 1103, 381, 589, 1112, 395, 603, 1119, 409, 617, 1124, 423, 631, 
       1127, 437, 645, 451}], 
      Line3DBox[{8, 667, 23, 681, 38, 696, 53, 711, 68, 726, 83, 741, 98, 756,
        113, 771, 128, 786, 143, 801, 158, 816, 173, 831, 188, 846, 203, 860, 
       218}], Line3DBox[{263, 465, 264, 1130, 478, 284, 1133, 492, 298, 1138, 
       506, 312, 1145, 520, 326, 1154, 534, 340, 1165, 548, 354, 562, 368, 
       1174, 576, 382, 1177, 590, 396, 1182, 604, 410, 1189, 618, 424, 1198, 
       632, 438, 1208, 646, 452}], 
      Line3DBox[{265, 466, 1050, 266, 479, 285, 1134, 493, 299, 1139, 507, 
       313, 1146, 521, 327, 1155, 535, 341, 1166, 549, 355, 563, 1093, 369, 
       577, 383, 1178, 591, 397, 1183, 605, 411, 1190, 619, 425, 1199, 633, 
       439, 1209, 647, 453}], 
      Line3DBox[{267, 467, 1051, 268, 480, 1060, 286, 494, 300, 1140, 508, 
       314, 1147, 522, 328, 1156, 536, 342, 1167, 550, 356, 564, 1094, 370, 
       578, 1104, 384, 592, 398, 1184, 606, 412, 1191, 620, 426, 1200, 634, 
       440, 1210, 648, 454}], 
      Line3DBox[{269, 468, 1052, 270, 481, 1061, 287, 495, 1069, 301, 509, 
       315, 1148, 523, 329, 1157, 537, 343, 1168, 551, 357, 565, 1095, 371, 
       579, 1105, 385, 593, 1113, 399, 607, 413, 1192, 621, 427, 1201, 635, 
       441, 1211, 649, 455}], 
      Line3DBox[{271, 469, 1053, 272, 482, 1062, 288, 496, 1070, 302, 510, 
       1076, 316, 524, 330, 1158, 538, 344, 1169, 552, 358, 566, 1096, 372, 
       580, 1106, 386, 594, 1114, 400, 608, 1120, 414, 622, 428, 1202, 636, 
       442, 1212, 650, 456}], 
      Line3DBox[{273, 470, 1054, 274, 483, 1063, 289, 497, 1071, 303, 511, 
       1077, 317, 525, 1081, 331, 539, 1084, 345, 1170, 553, 359, 567, 1097, 
       373, 581, 1107, 387, 595, 1115, 401, 609, 1121, 415, 623, 1125, 429, 
       637, 443, 1213, 651, 457}], 
      Line3DBox[{275, 653, 654, 276, 484, 1064, 290, 498, 1072, 304, 512, 
       1078, 318, 526, 1082, 332, 540, 1085, 346, 554, 1086, 360, 568, 1098, 
       374, 582, 1108, 388, 596, 1116, 402, 610, 1122, 416, 624, 1126, 430, 
       638, 1128, 444, 656, 657, 658}], 
      Line3DBox[{445, 639, 655, 431, 625, 1193, 417, 611, 1185, 403, 597, 
       1179, 389, 583, 1175, 375, 569, 1172, 361, 555, 1171, 347, 541, 1159, 
       333, 527, 1149, 319, 513, 1141, 305, 499, 1135, 291, 485, 1131, 277, 
       471, 1129, 250, 458, 652, 659}]}, {
      Line3DBox[{661, 954, 458, 660, 1044, 868, 662, 1045, 869, 663, 1046, 
       870, 664, 1047, 871, 665, 1048, 872, 666, 1049, 873, 667, 465, 668, 
       1050, 874, 669, 1051, 875, 670, 1052, 876, 671, 1053, 877, 672, 1054, 
       878, 673, 654, 879, 955}], 
      Line3DBox[{675, 959, 1129, 674, 472, 676, 1055, 880, 677, 1056, 881, 
       678, 1057, 882, 679, 1058, 883, 680, 1059, 884, 681, 960, 1130, 682, 
       479, 683, 1060, 885, 684, 1061, 886, 685, 1062, 887, 686, 1063, 888, 
       687, 1064, 889, 688}], 
      Line3DBox[{690, 961, 1131, 689, 962, 1132, 691, 487, 692, 1065, 890, 
       693, 1066, 891, 694, 1067, 892, 695, 1068, 893, 696, 963, 1133, 697, 
       964, 1134, 698, 494, 699, 1069, 894, 700, 1070, 895, 701, 1071, 896, 
       702, 1072, 897, 703}], 
      Line3DBox[{705, 965, 1135, 704, 966, 1136, 706, 967, 1137, 707, 502, 
       708, 1073, 898, 709, 1074, 899, 710, 1075, 900, 711, 968, 1138, 712, 
       969, 1139, 713, 970, 1140, 714, 509, 715, 1076, 901, 716, 1077, 902, 
       717, 1078, 903, 718}], 
      Line3DBox[{720, 971, 1141, 719, 972, 1142, 721, 973, 1143, 722, 974, 
       1144, 723, 517, 724, 1079, 904, 725, 1080, 905, 726, 975, 1145, 727, 
       976, 1146, 728, 977, 1147, 729, 978, 1148, 730, 524, 731, 1081, 906, 
       732, 1082, 907, 733}], 
      Line3DBox[{735, 979, 1149, 734, 980, 1150, 736, 981, 1151, 737, 982, 
       1152, 738, 983, 1153, 739, 532, 740, 1083, 908, 741, 984, 1154, 742, 
       985, 1155, 743, 986, 1156, 744, 987, 1157, 745, 988, 1158, 746, 1084, 
       909, 747, 1085, 910, 748}], 
      Line3DBox[{106, 347, 107, 348, 108, 349, 109, 350, 110, 351, 111, 352, 
       112, 353, 113, 354, 114, 355, 115, 356, 116, 357, 117, 358, 118, 359, 
       119, 360, 120}], 
      Line3DBox[{750, 989, 1159, 749, 990, 1160, 751, 991, 1161, 752, 992, 
       1162, 753, 993, 1163, 754, 994, 1164, 755, 547, 756, 995, 1165, 757, 
       996, 1166, 758, 997, 1167, 759, 998, 1168, 760, 999, 1169, 761, 1000, 
       1170, 762, 1086, 911, 763}], 
      Line3DBox[{765, 1001, 1171, 764, 1087, 912, 766, 1088, 913, 767, 1089, 
       914, 768, 1090, 915, 769, 1091, 916, 770, 1092, 917, 771, 562, 772, 
       1093, 918, 773, 1094, 919, 774, 1095, 920, 775, 1096, 921, 776, 1097, 
       922, 777, 1098, 923, 778}], 
      Line3DBox[{780, 1002, 1172, 779, 1003, 1173, 781, 1099, 924, 782, 1100, 
       925, 783, 1101, 926, 784, 1102, 927, 785, 1103, 928, 786, 1004, 1174, 
       787, 577, 788, 1104, 929, 789, 1105, 930, 790, 1106, 931, 791, 1107, 
       932, 792, 1108, 933, 793}], 
      Line3DBox[{795, 1005, 1175, 794, 1006, 1176, 796, 585, 797, 1109, 934, 
       798, 1110, 935, 799, 1111, 936, 800, 1112, 937, 801, 1007, 1177, 802, 
       1008, 1178, 803, 592, 804, 1113, 938, 805, 1114, 939, 806, 1115, 940, 
       807, 1116, 941, 808}], 
      Line3DBox[{810, 1009, 1179, 809, 1010, 1180, 811, 1011, 1181, 812, 600, 
       813, 1117, 942, 814, 1118, 943, 815, 1119, 944, 816, 1012, 1182, 817, 
       1013, 1183, 818, 1014, 1184, 819, 607, 820, 1120, 945, 821, 1121, 946, 
       822, 1122, 947, 823}], 
      Line3DBox[{825, 1015, 1185, 824, 1016, 1186, 826, 1017, 1187, 827, 1018,
        1188, 828, 615, 829, 1123, 948, 830, 1124, 949, 831, 1019, 1189, 832, 
       1020, 1190, 833, 1021, 1191, 834, 1022, 1192, 835, 622, 836, 1125, 950,
        837, 1126, 951, 838}], 
      Line3DBox[{840, 1023, 1193, 839, 1024, 1194, 841, 1025, 1195, 842, 1026,
        1196, 843, 1027, 1197, 844, 630, 845, 1127, 952, 846, 1028, 1198, 847,
        1029, 1199, 848, 1030, 1200, 849, 1031, 1201, 850, 1032, 1202, 851, 
       637, 852, 1128, 953, 853}], 
      Line3DBox[{867, 958, 656, 866, 1213, 1043, 865, 1212, 1042, 864, 1211, 
       1041, 863, 1210, 1040, 862, 1209, 1039, 861, 1208, 1038, 860, 645, 859,
        1207, 1037, 858, 1206, 1036, 857, 1205, 1035, 856, 1204, 1034, 855, 
       1203, 1033, 854, 655, 956, 957}]}}},
   VertexNormals->CompressedData["
1:eJztm3tczFkfxwuvx33XY6kQm0tuS3k2tyGOQnmQCJu1kpLbsvK4LFE2stm0
27iHBoWQyiW6kDolKhUtuqBS6SZdhpV2Y1p7fi/zmzn9nuc80293pmbHmX96
9e38zvmez/me9/f8mu/p7ehss6SFlpZWTCstrZboZ8t3zEcM107P/zU6Qxir
Jf0cT3pS6fe5GG7XrRPu3ZIGWfs2PR2P6xmVsHKiSXXczRyZPa9VmkVCq3J4
q7uHfsCrIplduKZ1lD/6HbyuOsj8nbX7fZH1EfO89q4nUUx/rH2CINR3Nxpv
5tzAtiI0vlaDz7Dx73++kNldHYLPoPbgQGR0G7x96O6unVH/oHSxToP+E+0y
o5E/oJNlyT7cn7yo/OnodxA0s7gL7n/39d6e6Hng+UVWPj7fgfG6L5A+wNHq
O1tcH5P3eoK6m13tcwN/lOmpSGcPgs5VaqKzm5rq/BtB53V/MZ6fKElnMw2P
5/U845nEjUSOzrsJOos0PJ4pNyg3NElnUjxTnanOVGeqM9VZPXWm542mOW/Q
8/OHxQ1Nfx+k3GgabtD/16k2nvtuWfadW5oYxtWY3YkMui5rT+JJQKSrO2oP
AoPt3PH2pHVUVv8kO9t/PKd/vu1J/rcbWZSg/0oM53aPOjktPETWvvejrTeR
Heyz3F47FbPzbU+Kc779k9aXb3u+/gycY7t2nqMYCvRray/VJ8vsEQNKt+YJ
q2BQ4pSAPe4P/8t+jmOfuPHQveIjz6HriB8SJUmFCu32Fz8SHPMvhfmJ4n3M
T0X2cFs9O+b5T4w76ZWg/hTZy5bevbob+fe8Z955xl9F9qFBgW8voPm3yj3o
zeihyG5w70L7i/XJIN09ZRdu702wD5AYx6JxwY8RNaH4uCT7Tedhi9C8QE3q
713xeZHs1ywF45FewNf4lg+uG8k+d9+pLLQuoGPJm1h8XUj21057tiP/wHCt
/UJ83Un2LRNmXfZxFIOCTvEbnOvkcTV5pcEGpAsQPK+PxeONjcPRjYxDvnHF
N06MeK4733Xkuy4knRXp2dh9zVfPCIKez3juL777RV31bCwPlRWfmqKnuux3
qifVk+pJ9aR6fth60vxOz5/qrKe67HdNfz+i+52fnqHpVy+i930YVZAbhL/v
q1s+Urf4VKQbjcP/rZu68fDvEm+qzteLpHo+UVF+Ubc4bK78Qs8/DfVUl/1O
9aR6Uj2pnlTPD0NP+v6oXudPqmdDPVW135V1/tSU96Om3u9/9/cj+v+iP6cn
STdSvQ3Jrqx++PZPqrMl1a3R+tv3H1JdKKmellSfSevG/7+epLpKRXHLvR9B
70GoRufGxjPVuaHO3LpoyuGm1Vld+KwpOpO4QXWmOlOdqc7KOm/QPNg05w16
rmsanel7imby+UN776YcbpyeXD58OcF3nGBEFTy6f8c/LQ0fy9o/6lK+wmJP
Oax2PphkOV4+bl2fewP0A4vhZutwL/11z2T2Pice3T1hnweL47OLx6yWz+uS
y2fLJ/2aDo3CCp6vllTL/S/6Jr/aXwQ77hOOS5PI9Tk7OPNfFoaPgcug086M
X6z9SpXYCfkBnO4MvML4xdqNki+YIj/Acuc2HoxfrP3wgHUXkB9AlLr76Enk
F2vf8dugu8gPkFO/zdAC+cXarc6vtkmWiIH3vYl3V4WJZPbeCTf63tB7Dt8U
uN2q2PFUHg+pSU/DbUrgqm1H9a1yy2T2JS1Gjtjz+gl8c7uvQay2XIfqded/
Co68Bx06mKdkQrkO94VTd+4MCYFfze55st8ruQ7FV14tQuOBau8eK5nxWbvO
uzNp03PLwDJjM9MIND5rd626VBajXQkWLtqgvReNz9qfzlt8Do0H3q6q+joE
jc/ax7QWidB4wK02M9EnRH7/V7i8cEMLSQnMyM50C50gn1daoKNZknkBXGxw
TXebsEJm3/is5dT7ax7AXj43C8pd5fM6lJz+8Mb34bCV0WW7d0/l8/q0um4w
6hdESHbcYcZh7cmzzHLdhRVg9Ajj08w4rH1Vy/gY1C8QW541fIDGYe09WtfM
Rv0CW33J+kQ0Dmv/6twSnTmtC+FSqxedbuvK/Rwblz+jTf9MeOpx5/Y/m8j9
fJizpv+XYdfhea+EBQvT5H4GP9t0P1m3ArhaJ7sw/bH2xL3i4nSTalAeHT2w
LeqPtc/skGqNngdD3k6JXRAmv4f+/fRR5y2ysmC7ypVLoorl8Vxz/UhcRkU8
zBzcw8n6gnxc+IuxKWoHTGt7elqi51j7gRTxbNQOTAzR3pWFnmPtMQHnrC9v
ugXzHvV5WuEt74f9vsCE831BVWnaXdQOdHEerhOOnmPt7Pcyoznfy8yX8kHE
4cNjnnzoR+BDmJQPQzl8GNBEfDhK4EMuhw9lQTPGID+A38cvV9T7K+aDGYEP
S6V8qOPwQSzlwyIOH3L+JB+WE/hgT+CDhMCHnRw++Ej5kKliPoRz+JAk5YNA
w/jgqWI+xBH4wHJAh8MB/3Q9Jg/C1ukGVquxPEg6P5Dak96XSXlW7PWfNMa/
w7oiK9yfkuUx9sh/EJm+rhD3/34HLRtGl2Ojb8fh8y303jya0fFY/Q+HcX1i
IsJ+RnoCPU+vxbiew82NLiP9wSZjFydc/yqXSTOY9Y4av2WwHbZe5sPGFqL1
hR4zSsbh6ys8E38HxQOM++Tf2/B46Lj4lAWKH1A6zbpB/HR2cJ6D4g3MPNmt
HR5vkzYKuqHnwR37QR/j8Xk894ENs09GxUTm4/G81abbNWZfuRUcMMXj/9L2
vGy0X2D/muOh+H4JLPAyZPZtve3kB/j+8u2vVYf2I+hqsaDBfszeYTQT7V+w
rCw5H9+/GbrVE1G/wPaWQAff729t4GbULwgqHOuC86GXab4fw6/kZZ8fFmI8
kdhlnGZ4d+hggAfOn6jU40WIV9B54bBOOK9WuNclIr7BsgSROc43vcF+dgx/
jzls+QbnYd4N3yTETyA+WnQC5+fjuRv2I94Cv35TbuO8tekXLkB8Bu2DS3rh
fO7+06wyxHNwe5pQD+f5gbGGg9B4wMuhLAbnfxfJSwGTt9r8btjmHZYvXhbD
FCbPJXh+Ox/PLz5HLgYzeXGz06cheD4y804ZyeTRF+ktd+H5K+DIfAcm7w4R
5ETg+c6n/T+MUH6E3R3d1+D50d49yV7sLwImOWsb5NO25r98i/IvSEmtLMfz
r3nv6PsoX4P+htlFeL6Oq333GfIDTO411BPP7+FeJ52RHyCy7RuInwceDhlq
hvwAutlbtfHzA1s/M4pTP8NywJfDAbYO5CynDqSIJx8KpHw4TvmgUj48kPJh
HocPEgV8iGskH65K+bCKw4evpXwobSQfMgh8eCjlg4jDB2sFfEhpJB+aiwNz
1YwD6lYf21x1XM1VH9hc9X5874XxrSNVtf/KqndVlj9845xv/8rqh6inmtV5
qlt9bHPp0FzzVfW8VO2/svxUlj98ucS3f1J+4XsfgVRfzfc+CN+6d2XV8yur
3l7V9wtUfS+gue6XNdd9B3W7T6du9z5I+vDVjTQvvvtF2Xxo7Po2FR/+arxp
Kh+a6/5Oc73nqhsH/gABT4Gm
    "]],
  Axes->True,
  Boxed->True,
  PlotRange->{{-1.9999999999999496`, 1.9999999999999496`}, {0., 
   1.9999995512010496`}, {-3.1415922047908427`, 3.1415922047908427`}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.405607772218841*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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\
\>"]],

Cell[BoxData[
 Graphics3DBox[GraphicsComplex3DBox[CompressedData["
1:eJyFfHVUltn3PQ2iYmDrWINiYHeei5gYg42Njt3F2DHqqKg4KnZgiwEWBop4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   "], {{
     {EdgeForm[None], GraphicsGroup3DBox[{Polygon3DBox[CompressedData["
1:eJwtmXnAVtMWxs/eZ0dligiheTLmorpkqDRnSIPSIEqIEkplShpFhqgMGSpz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         "]], Polygon3DBox[CompressedData["
1:eJwtmXfgjuUexp/nvp8oRSKhzDKSkFnJHhVRkZJUJ1qys2fZMkMRSmgRomGE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         "]], Polygon3DBox[CompressedData["
1:eJwt1nf8T/UeB/Cvn71Hl1BZN7tIRUZGysiMjOwRbvYOJSkymvdmKytbtqz7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         "]]}]}, {}, {}, {}}, {{}, {}, {}, {
      Line3DBox[{251, 459, 1044, 252, 472, 278, 1132, 486, 292, 1136, 500, 
       306, 1142, 514, 320, 1150, 528, 334, 1160, 542, 348, 556, 1087, 362, 
       1173, 570, 376, 1176, 584, 390, 1180, 598, 404, 1186, 612, 418, 1194, 
       626, 432, 1203, 640, 446}], 
      Line3DBox[{253, 460, 1045, 254, 473, 1055, 279, 487, 293, 1137, 501, 
       307, 1143, 515, 321, 1151, 529, 335, 1161, 543, 349, 557, 1088, 363, 
       571, 1099, 377, 585, 391, 1181, 599, 405, 1187, 613, 419, 1195, 627, 
       433, 1204, 641, 447}], 
      Line3DBox[{255, 461, 1046, 256, 474, 1056, 280, 488, 1065, 294, 502, 
       308, 1144, 516, 322, 1152, 530, 336, 1162, 544, 350, 558, 1089, 364, 
       572, 1100, 378, 586, 1109, 392, 600, 406, 1188, 614, 420, 1196, 628, 
       434, 1205, 642, 448}], 
      Line3DBox[{257, 462, 1047, 258, 475, 1057, 281, 489, 1066, 295, 503, 
       1073, 309, 517, 323, 1153, 531, 337, 1163, 545, 351, 559, 1090, 365, 
       573, 1101, 379, 587, 1110, 393, 601, 1117, 407, 615, 421, 1197, 629, 
       435, 1206, 643, 449}], 
      Line3DBox[{259, 463, 1048, 260, 476, 1058, 282, 490, 1067, 296, 504, 
       1074, 310, 518, 1079, 324, 532, 338, 1164, 546, 352, 560, 1091, 366, 
       574, 1102, 380, 588, 1111, 394, 602, 1118, 408, 616, 1123, 422, 630, 
       436, 1207, 644, 450}], 
      Line3DBox[{261, 464, 1049, 262, 477, 1059, 283, 491, 1068, 297, 505, 
       1075, 311, 519, 1080, 325, 533, 1083, 339, 547, 353, 561, 1092, 367, 
       575, 1103, 381, 589, 1112, 395, 603, 1119, 409, 617, 1124, 423, 631, 
       1127, 437, 645, 451}], 
      Line3DBox[{8, 667, 23, 681, 38, 696, 53, 711, 68, 726, 83, 741, 98, 756,
        113, 771, 128, 786, 143, 801, 158, 816, 173, 831, 188, 846, 203, 860, 
       218}], Line3DBox[{263, 465, 264, 1130, 478, 284, 1133, 492, 298, 1138, 
       506, 312, 1145, 520, 326, 1154, 534, 340, 1165, 548, 354, 562, 368, 
       1174, 576, 382, 1177, 590, 396, 1182, 604, 410, 1189, 618, 424, 1198, 
       632, 438, 1208, 646, 452}], 
      Line3DBox[{265, 466, 1050, 266, 479, 285, 1134, 493, 299, 1139, 507, 
       313, 1146, 521, 327, 1155, 535, 341, 1166, 549, 355, 563, 1093, 369, 
       577, 383, 1178, 591, 397, 1183, 605, 411, 1190, 619, 425, 1199, 633, 
       439, 1209, 647, 453}], 
      Line3DBox[{267, 467, 1051, 268, 480, 1060, 286, 494, 300, 1140, 508, 
       314, 1147, 522, 328, 1156, 536, 342, 1167, 550, 356, 564, 1094, 370, 
       578, 1104, 384, 592, 398, 1184, 606, 412, 1191, 620, 426, 1200, 634, 
       440, 1210, 648, 454}], 
      Line3DBox[{269, 468, 1052, 270, 481, 1061, 287, 495, 1069, 301, 509, 
       315, 1148, 523, 329, 1157, 537, 343, 1168, 551, 357, 565, 1095, 371, 
       579, 1105, 385, 593, 1113, 399, 607, 413, 1192, 621, 427, 1201, 635, 
       441, 1211, 649, 455}], 
      Line3DBox[{271, 469, 1053, 272, 482, 1062, 288, 496, 1070, 302, 510, 
       1076, 316, 524, 330, 1158, 538, 344, 1169, 552, 358, 566, 1096, 372, 
       580, 1106, 386, 594, 1114, 400, 608, 1120, 414, 622, 428, 1202, 636, 
       442, 1212, 650, 456}], 
      Line3DBox[{273, 470, 1054, 274, 483, 1063, 289, 497, 1071, 303, 511, 
       1077, 317, 525, 1081, 331, 539, 1084, 345, 1170, 553, 359, 567, 1097, 
       373, 581, 1107, 387, 595, 1115, 401, 609, 1121, 415, 623, 1125, 429, 
       637, 443, 1213, 651, 457}], 
      Line3DBox[{275, 653, 654, 276, 484, 1064, 290, 498, 1072, 304, 512, 
       1078, 318, 526, 1082, 332, 540, 1085, 346, 554, 1086, 360, 568, 1098, 
       374, 582, 1108, 388, 596, 1116, 402, 610, 1122, 416, 624, 1126, 430, 
       638, 1128, 444, 656, 657, 658}], 
      Line3DBox[{445, 639, 655, 431, 625, 1193, 417, 611, 1185, 403, 597, 
       1179, 389, 583, 1175, 375, 569, 1172, 361, 555, 1171, 347, 541, 1159, 
       333, 527, 1149, 319, 513, 1141, 305, 499, 1135, 291, 485, 1131, 277, 
       471, 1129, 250, 458, 652, 659}]}, {
      Line3DBox[{661, 954, 458, 660, 1044, 868, 662, 1045, 869, 663, 1046, 
       870, 664, 1047, 871, 665, 1048, 872, 666, 1049, 873, 667, 465, 668, 
       1050, 874, 669, 1051, 875, 670, 1052, 876, 671, 1053, 877, 672, 1054, 
       878, 673, 654, 879, 955}], 
      Line3DBox[{675, 959, 1129, 674, 472, 676, 1055, 880, 677, 1056, 881, 
       678, 1057, 882, 679, 1058, 883, 680, 1059, 884, 681, 960, 1130, 682, 
       479, 683, 1060, 885, 684, 1061, 886, 685, 1062, 887, 686, 1063, 888, 
       687, 1064, 889, 688}], 
      Line3DBox[{690, 961, 1131, 689, 962, 1132, 691, 487, 692, 1065, 890, 
       693, 1066, 891, 694, 1067, 892, 695, 1068, 893, 696, 963, 1133, 697, 
       964, 1134, 698, 494, 699, 1069, 894, 700, 1070, 895, 701, 1071, 896, 
       702, 1072, 897, 703}], 
      Line3DBox[{705, 965, 1135, 704, 966, 1136, 706, 967, 1137, 707, 502, 
       708, 1073, 898, 709, 1074, 899, 710, 1075, 900, 711, 968, 1138, 712, 
       969, 1139, 713, 970, 1140, 714, 509, 715, 1076, 901, 716, 1077, 902, 
       717, 1078, 903, 718}], 
      Line3DBox[{720, 971, 1141, 719, 972, 1142, 721, 973, 1143, 722, 974, 
       1144, 723, 517, 724, 1079, 904, 725, 1080, 905, 726, 975, 1145, 727, 
       976, 1146, 728, 977, 1147, 729, 978, 1148, 730, 524, 731, 1081, 906, 
       732, 1082, 907, 733}], 
      Line3DBox[{735, 979, 1149, 734, 980, 1150, 736, 981, 1151, 737, 982, 
       1152, 738, 983, 1153, 739, 532, 740, 1083, 908, 741, 984, 1154, 742, 
       985, 1155, 743, 986, 1156, 744, 987, 1157, 745, 988, 1158, 746, 1084, 
       909, 747, 1085, 910, 748}], 
      Line3DBox[{106, 347, 107, 348, 108, 349, 109, 350, 110, 351, 111, 352, 
       112, 353, 113, 354, 114, 355, 115, 356, 116, 357, 117, 358, 118, 359, 
       119, 360, 120}], 
      Line3DBox[{750, 989, 1159, 749, 990, 1160, 751, 991, 1161, 752, 992, 
       1162, 753, 993, 1163, 754, 994, 1164, 755, 547, 756, 995, 1165, 757, 
       996, 1166, 758, 997, 1167, 759, 998, 1168, 760, 999, 1169, 761, 1000, 
       1170, 762, 1086, 911, 763}], 
      Line3DBox[{765, 1001, 1171, 764, 1087, 912, 766, 1088, 913, 767, 1089, 
       914, 768, 1090, 915, 769, 1091, 916, 770, 1092, 917, 771, 562, 772, 
       1093, 918, 773, 1094, 919, 774, 1095, 920, 775, 1096, 921, 776, 1097, 
       922, 777, 1098, 923, 778}], 
      Line3DBox[{780, 1002, 1172, 779, 1003, 1173, 781, 1099, 924, 782, 1100, 
       925, 783, 1101, 926, 784, 1102, 927, 785, 1103, 928, 786, 1004, 1174, 
       787, 577, 788, 1104, 929, 789, 1105, 930, 790, 1106, 931, 791, 1107, 
       932, 792, 1108, 933, 793}], 
      Line3DBox[{795, 1005, 1175, 794, 1006, 1176, 796, 585, 797, 1109, 934, 
       798, 1110, 935, 799, 1111, 936, 800, 1112, 937, 801, 1007, 1177, 802, 
       1008, 1178, 803, 592, 804, 1113, 938, 805, 1114, 939, 806, 1115, 940, 
       807, 1116, 941, 808}], 
      Line3DBox[{810, 1009, 1179, 809, 1010, 1180, 811, 1011, 1181, 812, 600, 
       813, 1117, 942, 814, 1118, 943, 815, 1119, 944, 816, 1012, 1182, 817, 
       1013, 1183, 818, 1014, 1184, 819, 607, 820, 1120, 945, 821, 1121, 946, 
       822, 1122, 947, 823}], 
      Line3DBox[{825, 1015, 1185, 824, 1016, 1186, 826, 1017, 1187, 827, 1018,
        1188, 828, 615, 829, 1123, 948, 830, 1124, 949, 831, 1019, 1189, 832, 
       1020, 1190, 833, 1021, 1191, 834, 1022, 1192, 835, 622, 836, 1125, 950,
        837, 1126, 951, 838}], 
      Line3DBox[{840, 1023, 1193, 839, 1024, 1194, 841, 1025, 1195, 842, 1026,
        1196, 843, 1027, 1197, 844, 630, 845, 1127, 952, 846, 1028, 1198, 847,
        1029, 1199, 848, 1030, 1200, 849, 1031, 1201, 850, 1032, 1202, 851, 
       637, 852, 1128, 953, 853}], 
      Line3DBox[{867, 958, 656, 866, 1213, 1043, 865, 1212, 1042, 864, 1211, 
       1041, 863, 1210, 1040, 862, 1209, 1039, 861, 1208, 1038, 860, 645, 859,
        1207, 1037, 858, 1206, 1036, 857, 1205, 1035, 856, 1204, 1034, 855, 
       1203, 1033, 854, 655, 956, 957}]}}},
   VertexNormals->CompressedData["
1:eJxke3dcz9/7foVE02rTsCOUneqIlozsUNmaaJDsEUWkJEqKrEpkpS3dkVIp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    "]],
  Axes->True,
  Boxed->True,
  PlotRange->{{-3.6568536147948323`, 
   3.6568536147948323`}, {-1.1715725579050464`, 
   1.1715725579050464`}, {-2.828426807397391, 2.828426807397391}},
  PlotRangePadding->{
    Scaled[0.02], 
    Scaled[0.02], 
    Scaled[0.02]}]], "Output",
 CellChangeTimes->{3.40560777882209*^9},
 ImageCache->GraphicsData["CompressedBitmap", "\<\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