LiveForm[graphics_, animOpts___] := 
   Module[{
   graphics3d = Switch[graphics, 
   _ContourGraphics, Graphics3D[SurfaceGraphics[graphics]], 
   _DensityGraphics, Graphics3D[SurfaceGraphics[graphics]], 
   _SurfaceGraphics, Graphics3D[graphics],
   _, graphics]
   }, 
   Switch[graphics3d,
   _List, HoldForm[ShowAnimation][NumberForm[InputForm[N[graphics3d]], 5], 
   InputForm[N[Flatten[{animOpts}]]]], 
   _, NumberForm[InputForm[N[graphics3d]], 5]]];

WriteLiveForm[filename_, graphics_, animOpts___] := 
  Module[{ps,x}, 
  	ps=Unprotect[Real];
		Unprotect[Power]; 
    Format[x_Real, InputForm] := 
    OutputForm[ NumberForm[x, 5, 
    NumberFormat -> (If[#3 == "", #1, SequenceForm[#1, "*^", #3]] &) ]]; 
    Protect@@ps;
    WriteString[filename, ToString[LiveForm[graphics, animOpts], CharacterEncoding->None]]; 
    Close[filename];
    ps=Unprotect[Real]; 
    Format[x_Real, InputForm] =.; 
    Protect@@ps;
    ];

(*
		Format[Power[x_,y_],InputForm]:=OutputForm[Infix[{PrecedenceForm[InputForm[x],100],PrecedenceForm[InputForm[y],100]},"^"]];
*)
