(* ::Package:: *)

(************************************************************************)
(* This file was generated automatically by the Mathematica front end.  *)
(* It contains Initialization cells from a Notebook file, which         *)
(* typically will have the same name as this file except ending in      *)
(* ".nb" instead of ".m".                                               *)
(*                                                                      *)
(* This file is intended to be loaded into the Mathematica kernel using *)
(* the package loading commands Get or Needs.  Doing so is equivalent   *)
(* to using the Evaluate Initialization Cells menu command in the front *)
(* end.                                                                 *)
(*                                                                      *)
(* DO NOT EDIT THIS FILE.  This entire file is regenerated              *)
(* automatically each time the parent Notebook file is saved in the     *)
(* Mathematica front end.  Any changes you make to this file will be    *)
(* overwritten.                                                         *)
(************************************************************************)



PP3D[f_, x_, (opts___)?OptionQ] := Module[{xv, x0, x1, steps}, 
     xv = x[[1]]; x0 = x[[2]]; x1 = x[[3]]; Unprotect["PlotPoints"];
      steps = PlotPoints /. {opts} /. Options[PP3D];
      thickness = LineThickness /.{opts}/.Options[PP3D];
      color=LineColor/.{opts}/.Options[PP3D];
      If[VectorQ[steps], steps = steps[[1]]]; dx = (x1 - x0)/steps; 
      Graphics3D[{
      	If[VectorQ[thickness],Thickness[thickness[[1]]], Thickness[thickness]],
      	color,
      	Line[Table[f /. {xv -> i}, {i, x0, x1, dx}]]
      }]]
 
PP3D[f_, x_, y_, (opts___)?OptionQ] := Module[{xy, x0, x1, dx, yv, y0, y1, 
      dy, steps}, xv = x[[1]]; yv = y[[1]]; x0 = x[[2]]; x1 = x[[3]]; 
      y0 = y[[2]]; y1 = y[[3]]; Unprotect["PlotPoints"]; 
      steps = PlotPoints /. {opts} /. Options[PP3D]; 
      gridlines = GridLines /. {opts} /. Options[PP3D]; 
      dx = (x1 - x0)/steps[[1]]; dy = (y1 - y0)/steps[[2]]; 
      Graphics3D[{If[gridlines, EdgeForm[GrayLevel[0.5]], EdgeForm[{}]], 
        Table[Polygon[{f /. {xv -> i, yv -> j}, f /. {xv -> i, yv -> j - dy}, 
           f /. {xv -> i - dx, yv -> j - dy}, f /. {xv -> i - dx, yv -> j}}], 
         {i, x0 + dx, x1, dx}, {j, y0 + dy, y1, dy}]}]]
 
Options[PP3D] = {PlotPoints -> {13, 13}, GridLines -> True, LineThickness -> 0.001, LineColor -> GrayLevel[0] };

