(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[      2659,         87]
NotebookOptionsPosition[      2247,         68]
NotebookOutlinePosition[      2613,         84]
CellTagsIndexPosition[      2570,         81]
WindowFrame->Normal
ContainsDynamic->False*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["PP3D", "Subsection"],

Cell["\<\
These are two variants of ParametricPlot3D 
for plotting curves and surfaces
to be used for output with WriteLiveForm.
Followed by its default Options.\
\>", "Text"],

Cell["\<\
PP3D[f_, x_, (opts___)?OptionQ] := Module[{xv, x0, x1, steps}, 
     xv = x[[1]]; x0 = x[[2]]; x1 = x[[3]]; Unprotect[\"PlotPoints\"];
      steps = PlotPoints /. {opts} /. Options[PP3D];
      thickness = LineThickness /.{opts}/.Options[PP3D];
      color=LineColor/.{opts}/.Options[PP3D];
      If[VectorQ[steps], steps = steps[[1]]]; dx = (x1 - x0)/steps; 
      Graphics3D[{
      \tIf[VectorQ[thickness],Thickness[thickness[[1]]], \
Thickness[thickness]],
      \tcolor,
      \tLine[Table[f /. {xv -> i}, {i, x0, x1, dx}]]
      }]]
 
PP3D[f_, x_, y_, (opts___)?OptionQ] := Module[{xy, x0, x1, dx, yv, y0, y1, 
      dy, steps}, xv = x[[1]]; yv = y[[1]]; x0 = x[[2]]; x1 = x[[3]]; 
      y0 = y[[2]]; y1 = y[[3]]; Unprotect[\"PlotPoints\"]; 
      steps = PlotPoints /. {opts} /. Options[PP3D]; 
      gridlines = GridLines /. {opts} /. Options[PP3D]; 
      dx = (x1 - x0)/steps[[1]]; dy = (y1 - y0)/steps[[2]]; 
      Graphics3D[{If[gridlines, EdgeForm[GrayLevel[0.5]], EdgeForm[{}]], 
        Table[Polygon[{f /. {xv -> i, yv -> j}, f /. {xv -> i, yv -> j - dy}, \

           f /. {xv -> i - dx, yv -> j - dy}, f /. {xv -> i - dx, yv -> j}}], \

         {i, x0 + dx, x1, dx}, {j, y0 + dy, y1, dy}]}]]
 
Options[PP3D] = {PlotPoints -> {13, 13}, GridLines -> True, LineThickness -> \
0.001, LineColor -> GrayLevel[0] };
\
\>", "Input",
 PageWidth->Infinity,
 InitializationCell->True,
 ShowSpecialCharacters->False]
}, Open  ]]
},
AutoGeneratedPackage->Automatic,
WindowSize->{1120, 816},
WindowMargins->{{51, Automatic}, {Automatic, 0}},
FrontEndVersion->"6.0 for Linux x86 (32-bit) (June 19, 2007)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[590, 23, 26, 0, 39, "Subsection"],
Cell[619, 25, 175, 5, 91, "Text"],
Cell[797, 32, 1434, 33, 464, "Input",
 InitializationCell->True]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

